/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.dynamics;

import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.dynamics.DynamicsJNI;
import com.badlogic.gdx.physics.bullet.dynamics.SWIGTYPE_p_btAlignedObjectArrayT_btMatrix3x3_t;
import com.badlogic.gdx.physics.bullet.dynamics.SWIGTYPE_p_btAlignedObjectArrayT_btQuaternion_t;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBodyLinkCollider;
import com.badlogic.gdx.physics.bullet.dynamics.btMultibodyLink;
import com.badlogic.gdx.physics.bullet.linearmath.btScalarArray;
import com.badlogic.gdx.physics.bullet.linearmath.btSerializer;
import com.badlogic.gdx.physics.bullet.linearmath.btVector3;
import com.badlogic.gdx.physics.bullet.linearmath.btVector3Array;
import java.nio.FloatBuffer;

public class btMultiBody
extends BulletBase {
    private long swigCPtr;

    protected btMultiBody(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btMultiBody(long cPtr, boolean cMemoryOwn) {
        this("btMultiBody", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(btMultiBody obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                DynamicsJNI.delete_btMultiBody(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public long operatorNew(long sizeInBytes) {
        return DynamicsJNI.btMultiBody_operatorNew__SWIG_0(this.swigCPtr, this, sizeInBytes);
    }

    public void operatorDelete(long ptr) {
        DynamicsJNI.btMultiBody_operatorDelete__SWIG_0(this.swigCPtr, this, ptr);
    }

    public long operatorNew(long arg0, long ptr) {
        return DynamicsJNI.btMultiBody_operatorNew__SWIG_1(this.swigCPtr, this, arg0, ptr);
    }

    public void operatorDelete(long arg0, long arg1) {
        DynamicsJNI.btMultiBody_operatorDelete__SWIG_1(this.swigCPtr, this, arg0, arg1);
    }

    public long operatorNewArray(long sizeInBytes) {
        return DynamicsJNI.btMultiBody_operatorNewArray__SWIG_0(this.swigCPtr, this, sizeInBytes);
    }

    public void operatorDeleteArray(long ptr) {
        DynamicsJNI.btMultiBody_operatorDeleteArray__SWIG_0(this.swigCPtr, this, ptr);
    }

    public long operatorNewArray(long arg0, long ptr) {
        return DynamicsJNI.btMultiBody_operatorNewArray__SWIG_1(this.swigCPtr, this, arg0, ptr);
    }

    public void operatorDeleteArray(long arg0, long arg1) {
        DynamicsJNI.btMultiBody_operatorDeleteArray__SWIG_1(this.swigCPtr, this, arg0, arg1);
    }

    public btMultiBody(int n_links, float mass, Vector3 inertia, boolean fixedBase, boolean canSleep, boolean deprecatedMultiDof) {
        this(DynamicsJNI.new_btMultiBody__SWIG_0(n_links, mass, inertia, fixedBase, canSleep, deprecatedMultiDof), true);
    }

    public btMultiBody(int n_links, float mass, Vector3 inertia, boolean fixedBase, boolean canSleep) {
        this(DynamicsJNI.new_btMultiBody__SWIG_1(n_links, mass, inertia, fixedBase, canSleep), true);
    }

    public void setupFixed(int linkIndex, float mass, Vector3 inertia, int parent, Quaternion rotParentToThis, Vector3 parentComToThisPivotOffset, Vector3 thisPivotToThisComOffset, boolean deprecatedDisableParentCollision) {
        DynamicsJNI.btMultiBody_setupFixed__SWIG_0(this.swigCPtr, this, linkIndex, mass, inertia, parent, rotParentToThis, parentComToThisPivotOffset, thisPivotToThisComOffset, deprecatedDisableParentCollision);
    }

    public void setupFixed(int linkIndex, float mass, Vector3 inertia, int parent, Quaternion rotParentToThis, Vector3 parentComToThisPivotOffset, Vector3 thisPivotToThisComOffset) {
        DynamicsJNI.btMultiBody_setupFixed__SWIG_1(this.swigCPtr, this, linkIndex, mass, inertia, parent, rotParentToThis, parentComToThisPivotOffset, thisPivotToThisComOffset);
    }

    public void setupPrismatic(int i, float mass, Vector3 inertia, int parent, Quaternion rotParentToThis, Vector3 jointAxis, Vector3 parentComToThisPivotOffset, Vector3 thisPivotToThisComOffset, boolean disableParentCollision) {
        DynamicsJNI.btMultiBody_setupPrismatic(this.swigCPtr, this, i, mass, inertia, parent, rotParentToThis, jointAxis, parentComToThisPivotOffset, thisPivotToThisComOffset, disableParentCollision);
    }

    public void setupRevolute(int linkIndex, float mass, Vector3 inertia, int parentIndex, Quaternion rotParentToThis, Vector3 jointAxis, Vector3 parentComToThisPivotOffset, Vector3 thisPivotToThisComOffset, boolean disableParentCollision) {
        DynamicsJNI.btMultiBody_setupRevolute__SWIG_0(this.swigCPtr, this, linkIndex, mass, inertia, parentIndex, rotParentToThis, jointAxis, parentComToThisPivotOffset, thisPivotToThisComOffset, disableParentCollision);
    }

    public void setupRevolute(int linkIndex, float mass, Vector3 inertia, int parentIndex, Quaternion rotParentToThis, Vector3 jointAxis, Vector3 parentComToThisPivotOffset, Vector3 thisPivotToThisComOffset) {
        DynamicsJNI.btMultiBody_setupRevolute__SWIG_1(this.swigCPtr, this, linkIndex, mass, inertia, parentIndex, rotParentToThis, jointAxis, parentComToThisPivotOffset, thisPivotToThisComOffset);
    }

    public void setupSpherical(int linkIndex, float mass, Vector3 inertia, int parent, Quaternion rotParentToThis, Vector3 parentComToThisPivotOffset, Vector3 thisPivotToThisComOffset, boolean disableParentCollision) {
        DynamicsJNI.btMultiBody_setupSpherical__SWIG_0(this.swigCPtr, this, linkIndex, mass, inertia, parent, rotParentToThis, parentComToThisPivotOffset, thisPivotToThisComOffset, disableParentCollision);
    }

    public void setupSpherical(int linkIndex, float mass, Vector3 inertia, int parent, Quaternion rotParentToThis, Vector3 parentComToThisPivotOffset, Vector3 thisPivotToThisComOffset) {
        DynamicsJNI.btMultiBody_setupSpherical__SWIG_1(this.swigCPtr, this, linkIndex, mass, inertia, parent, rotParentToThis, parentComToThisPivotOffset, thisPivotToThisComOffset);
    }

    public void setupPlanar(int i, float mass, Vector3 inertia, int parent, Quaternion rotParentToThis, Vector3 rotationAxis, Vector3 parentComToThisComOffset, boolean disableParentCollision) {
        DynamicsJNI.btMultiBody_setupPlanar__SWIG_0(this.swigCPtr, this, i, mass, inertia, parent, rotParentToThis, rotationAxis, parentComToThisComOffset, disableParentCollision);
    }

    public void setupPlanar(int i, float mass, Vector3 inertia, int parent, Quaternion rotParentToThis, Vector3 rotationAxis, Vector3 parentComToThisComOffset) {
        DynamicsJNI.btMultiBody_setupPlanar__SWIG_1(this.swigCPtr, this, i, mass, inertia, parent, rotParentToThis, rotationAxis, parentComToThisComOffset);
    }

    public btMultibodyLink getLinkConst(int index) {
        return new btMultibodyLink(DynamicsJNI.btMultiBody_getLinkConst(this.swigCPtr, this, index), false);
    }

    public btMultibodyLink getLink(int index) {
        return new btMultibodyLink(DynamicsJNI.btMultiBody_getLink(this.swigCPtr, this, index), false);
    }

    public void setBaseCollider(btMultiBodyLinkCollider collider) {
        DynamicsJNI.btMultiBody_setBaseCollider(this.swigCPtr, this, btMultiBodyLinkCollider.getCPtr(collider), collider);
    }

    public btMultiBodyLinkCollider getBaseColliderConst() {
        long cPtr = DynamicsJNI.btMultiBody_getBaseColliderConst(this.swigCPtr, this);
        return cPtr == 0L ? null : new btMultiBodyLinkCollider(cPtr, false);
    }

    public btMultiBodyLinkCollider getBaseCollider() {
        long cPtr = DynamicsJNI.btMultiBody_getBaseCollider(this.swigCPtr, this);
        return cPtr == 0L ? null : new btMultiBodyLinkCollider(cPtr, false);
    }

    public btMultiBodyLinkCollider getLinkCollider(int index) {
        long cPtr = DynamicsJNI.btMultiBody_getLinkCollider(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new btMultiBodyLinkCollider(cPtr, false);
    }

    public int getParent(int link_num) {
        return DynamicsJNI.btMultiBody_getParent(this.swigCPtr, this, link_num);
    }

    public int getNumLinks() {
        return DynamicsJNI.btMultiBody_getNumLinks(this.swigCPtr, this);
    }

    public int getNumDofs() {
        return DynamicsJNI.btMultiBody_getNumDofs(this.swigCPtr, this);
    }

    public int getNumPosVars() {
        return DynamicsJNI.btMultiBody_getNumPosVars(this.swigCPtr, this);
    }

    public float getBaseMass() {
        return DynamicsJNI.btMultiBody_getBaseMass(this.swigCPtr, this);
    }

    public Vector3 getBaseInertia() {
        return DynamicsJNI.btMultiBody_getBaseInertia(this.swigCPtr, this);
    }

    public float getLinkMass(int i) {
        return DynamicsJNI.btMultiBody_getLinkMass(this.swigCPtr, this, i);
    }

    public Vector3 getLinkInertia(int i) {
        return DynamicsJNI.btMultiBody_getLinkInertia(this.swigCPtr, this, i);
    }

    public void setBaseMass(float mass) {
        DynamicsJNI.btMultiBody_setBaseMass(this.swigCPtr, this, mass);
    }

    public void setBaseInertia(Vector3 inertia) {
        DynamicsJNI.btMultiBody_setBaseInertia(this.swigCPtr, this, inertia);
    }

    public Vector3 getBasePos() {
        return DynamicsJNI.btMultiBody_getBasePos(this.swigCPtr, this);
    }

    public Vector3 getBaseVel() {
        return DynamicsJNI.btMultiBody_getBaseVel(this.swigCPtr, this);
    }

    public Quaternion getWorldToBaseRot() {
        return DynamicsJNI.btMultiBody_getWorldToBaseRot(this.swigCPtr, this);
    }

    public Vector3 getBaseOmega() {
        return DynamicsJNI.btMultiBody_getBaseOmega(this.swigCPtr, this);
    }

    public void setBasePos(Vector3 pos) {
        DynamicsJNI.btMultiBody_setBasePos(this.swigCPtr, this, pos);
    }

    public void setBaseWorldTransform(Matrix4 tr) {
        DynamicsJNI.btMultiBody_setBaseWorldTransform(this.swigCPtr, this, tr);
    }

    public Matrix4 getBaseWorldTransform() {
        return DynamicsJNI.btMultiBody_getBaseWorldTransform(this.swigCPtr, this);
    }

    public void setBaseVel(Vector3 vel) {
        DynamicsJNI.btMultiBody_setBaseVel(this.swigCPtr, this, vel);
    }

    public void setWorldToBaseRot(Quaternion rot) {
        DynamicsJNI.btMultiBody_setWorldToBaseRot(this.swigCPtr, this, rot);
    }

    public void setBaseOmega(Vector3 omega) {
        DynamicsJNI.btMultiBody_setBaseOmega(this.swigCPtr, this, omega);
    }

    public float getJointPos(int i) {
        return DynamicsJNI.btMultiBody_getJointPos(this.swigCPtr, this, i);
    }

    public float getJointVel(int i) {
        return DynamicsJNI.btMultiBody_getJointVel(this.swigCPtr, this, i);
    }

    public FloatBuffer getJointVelMultiDof(int i) {
        return DynamicsJNI.btMultiBody_getJointVelMultiDof(this.swigCPtr, this, i);
    }

    public FloatBuffer getJointPosMultiDof(int i) {
        return DynamicsJNI.btMultiBody_getJointPosMultiDof(this.swigCPtr, this, i);
    }

    public FloatBuffer getJointVelMultiDofConst(int i) {
        return DynamicsJNI.btMultiBody_getJointVelMultiDofConst(this.swigCPtr, this, i);
    }

    public FloatBuffer getJointPosMultiDofConst(int i) {
        return DynamicsJNI.btMultiBody_getJointPosMultiDofConst(this.swigCPtr, this, i);
    }

    public void setJointPos(int i, float q) {
        DynamicsJNI.btMultiBody_setJointPos(this.swigCPtr, this, i, q);
    }

    public void setJointVel(int i, float qdot) {
        DynamicsJNI.btMultiBody_setJointVel(this.swigCPtr, this, i, qdot);
    }

    public void setJointPosMultiDof(int i, FloatBuffer q) {
        assert (q.isDirect()) : "Buffer must be allocated direct.";
        DynamicsJNI.btMultiBody_setJointPosMultiDof(this.swigCPtr, this, i, q);
    }

    public void setJointVelMultiDof(int i, FloatBuffer qdot) {
        assert (qdot.isDirect()) : "Buffer must be allocated direct.";
        DynamicsJNI.btMultiBody_setJointVelMultiDof(this.swigCPtr, this, i, qdot);
    }

    public FloatBuffer getVelocityVector() {
        return DynamicsJNI.btMultiBody_getVelocityVector(this.swigCPtr, this);
    }

    public Vector3 getRVector(int i) {
        return DynamicsJNI.btMultiBody_getRVector(this.swigCPtr, this, i);
    }

    public Quaternion getParentToLocalRot(int i) {
        return DynamicsJNI.btMultiBody_getParentToLocalRot(this.swigCPtr, this, i);
    }

    public Vector3 localPosToWorld(int i, Vector3 vec) {
        return DynamicsJNI.btMultiBody_localPosToWorld(this.swigCPtr, this, i, vec);
    }

    public Vector3 localDirToWorld(int i, Vector3 vec) {
        return DynamicsJNI.btMultiBody_localDirToWorld(this.swigCPtr, this, i, vec);
    }

    public Vector3 worldPosToLocal(int i, Vector3 vec) {
        return DynamicsJNI.btMultiBody_worldPosToLocal(this.swigCPtr, this, i, vec);
    }

    public Vector3 worldDirToLocal(int i, Vector3 vec) {
        return DynamicsJNI.btMultiBody_worldDirToLocal(this.swigCPtr, this, i, vec);
    }

    public Matrix3 localFrameToWorld(int i, Matrix3 mat) {
        return DynamicsJNI.btMultiBody_localFrameToWorld(this.swigCPtr, this, i, mat);
    }

    public float getKineticEnergy() {
        return DynamicsJNI.btMultiBody_getKineticEnergy(this.swigCPtr, this);
    }

    public Vector3 getAngularMomentum() {
        return DynamicsJNI.btMultiBody_getAngularMomentum(this.swigCPtr, this);
    }

    public void clearForcesAndTorques() {
        DynamicsJNI.btMultiBody_clearForcesAndTorques(this.swigCPtr, this);
    }

    public void clearConstraintForces() {
        DynamicsJNI.btMultiBody_clearConstraintForces(this.swigCPtr, this);
    }

    public void clearVelocities() {
        DynamicsJNI.btMultiBody_clearVelocities(this.swigCPtr, this);
    }

    public void addBaseForce(Vector3 f) {
        DynamicsJNI.btMultiBody_addBaseForce(this.swigCPtr, this, f);
    }

    public void addBaseTorque(Vector3 t) {
        DynamicsJNI.btMultiBody_addBaseTorque(this.swigCPtr, this, t);
    }

    public void addLinkForce(int i, Vector3 f) {
        DynamicsJNI.btMultiBody_addLinkForce(this.swigCPtr, this, i, f);
    }

    public void addLinkTorque(int i, Vector3 t) {
        DynamicsJNI.btMultiBody_addLinkTorque(this.swigCPtr, this, i, t);
    }

    public void addBaseConstraintForce(Vector3 f) {
        DynamicsJNI.btMultiBody_addBaseConstraintForce(this.swigCPtr, this, f);
    }

    public void addBaseConstraintTorque(Vector3 t) {
        DynamicsJNI.btMultiBody_addBaseConstraintTorque(this.swigCPtr, this, t);
    }

    public void addLinkConstraintForce(int i, Vector3 f) {
        DynamicsJNI.btMultiBody_addLinkConstraintForce(this.swigCPtr, this, i, f);
    }

    public void addLinkConstraintTorque(int i, Vector3 t) {
        DynamicsJNI.btMultiBody_addLinkConstraintTorque(this.swigCPtr, this, i, t);
    }

    public void addJointTorque(int i, float Q) {
        DynamicsJNI.btMultiBody_addJointTorque(this.swigCPtr, this, i, Q);
    }

    public void addJointTorqueMultiDof(int i, int dof, float Q) {
        DynamicsJNI.btMultiBody_addJointTorqueMultiDof__SWIG_0(this.swigCPtr, this, i, dof, Q);
    }

    public void addJointTorqueMultiDof(int i, FloatBuffer Q) {
        assert (Q.isDirect()) : "Buffer must be allocated direct.";
        DynamicsJNI.btMultiBody_addJointTorqueMultiDof__SWIG_1(this.swigCPtr, this, i, Q);
    }

    public Vector3 getBaseForce() {
        return DynamicsJNI.btMultiBody_getBaseForce(this.swigCPtr, this);
    }

    public Vector3 getBaseTorque() {
        return DynamicsJNI.btMultiBody_getBaseTorque(this.swigCPtr, this);
    }

    public Vector3 getLinkForce(int i) {
        return DynamicsJNI.btMultiBody_getLinkForce(this.swigCPtr, this, i);
    }

    public Vector3 getLinkTorque(int i) {
        return DynamicsJNI.btMultiBody_getLinkTorque(this.swigCPtr, this, i);
    }

    public float getJointTorque(int i) {
        return DynamicsJNI.btMultiBody_getJointTorque(this.swigCPtr, this, i);
    }

    public FloatBuffer getJointTorqueMultiDof(int i) {
        return DynamicsJNI.btMultiBody_getJointTorqueMultiDof(this.swigCPtr, this, i);
    }

    public void computeAccelerationsArticulatedBodyAlgorithmMultiDof(float dt, btScalarArray scratch_r, btVector3Array scratch_v, SWIGTYPE_p_btAlignedObjectArrayT_btMatrix3x3_t scratch_m, boolean isConstraintPass) {
        DynamicsJNI.btMultiBody_computeAccelerationsArticulatedBodyAlgorithmMultiDof__SWIG_0(this.swigCPtr, this, dt, btScalarArray.getCPtr(scratch_r), scratch_r, btVector3Array.getCPtr(scratch_v), scratch_v, SWIGTYPE_p_btAlignedObjectArrayT_btMatrix3x3_t.getCPtr(scratch_m), isConstraintPass);
    }

    public void computeAccelerationsArticulatedBodyAlgorithmMultiDof(float dt, btScalarArray scratch_r, btVector3Array scratch_v, SWIGTYPE_p_btAlignedObjectArrayT_btMatrix3x3_t scratch_m) {
        DynamicsJNI.btMultiBody_computeAccelerationsArticulatedBodyAlgorithmMultiDof__SWIG_1(this.swigCPtr, this, dt, btScalarArray.getCPtr(scratch_r), scratch_r, btVector3Array.getCPtr(scratch_v), scratch_v, SWIGTYPE_p_btAlignedObjectArrayT_btMatrix3x3_t.getCPtr(scratch_m));
    }

    public void stepVelocitiesMultiDof(float dt, btScalarArray scratch_r, btVector3Array scratch_v, SWIGTYPE_p_btAlignedObjectArrayT_btMatrix3x3_t scratch_m, boolean isConstraintPass) {
        DynamicsJNI.btMultiBody_stepVelocitiesMultiDof__SWIG_0(this.swigCPtr, this, dt, btScalarArray.getCPtr(scratch_r), scratch_r, btVector3Array.getCPtr(scratch_v), scratch_v, SWIGTYPE_p_btAlignedObjectArrayT_btMatrix3x3_t.getCPtr(scratch_m), isConstraintPass);
    }

    public void stepVelocitiesMultiDof(float dt, btScalarArray scratch_r, btVector3Array scratch_v, SWIGTYPE_p_btAlignedObjectArrayT_btMatrix3x3_t scratch_m) {
        DynamicsJNI.btMultiBody_stepVelocitiesMultiDof__SWIG_1(this.swigCPtr, this, dt, btScalarArray.getCPtr(scratch_r), scratch_r, btVector3Array.getCPtr(scratch_v), scratch_v, SWIGTYPE_p_btAlignedObjectArrayT_btMatrix3x3_t.getCPtr(scratch_m));
    }

    public void calcAccelerationDeltasMultiDof(FloatBuffer force, FloatBuffer output, btScalarArray scratch_r, btVector3Array scratch_v) {
        assert (force.isDirect()) : "Buffer must be allocated direct.";
        assert (output.isDirect()) : "Buffer must be allocated direct.";
        DynamicsJNI.btMultiBody_calcAccelerationDeltasMultiDof(this.swigCPtr, this, force, output, btScalarArray.getCPtr(scratch_r), scratch_r, btVector3Array.getCPtr(scratch_v), scratch_v);
    }

    public void applyDeltaVeeMultiDof2(FloatBuffer delta_vee, float multiplier) {
        assert (delta_vee.isDirect()) : "Buffer must be allocated direct.";
        DynamicsJNI.btMultiBody_applyDeltaVeeMultiDof2(this.swigCPtr, this, delta_vee, multiplier);
    }

    public void processDeltaVeeMultiDof2() {
        DynamicsJNI.btMultiBody_processDeltaVeeMultiDof2(this.swigCPtr, this);
    }

    public void applyDeltaVeeMultiDof(FloatBuffer delta_vee, float multiplier) {
        assert (delta_vee.isDirect()) : "Buffer must be allocated direct.";
        DynamicsJNI.btMultiBody_applyDeltaVeeMultiDof(this.swigCPtr, this, delta_vee, multiplier);
    }

    public void stepPositionsMultiDof(float dt, FloatBuffer pq, FloatBuffer pqd) {
        assert (pq.isDirect()) : "Buffer must be allocated direct.";
        assert (pqd.isDirect()) : "Buffer must be allocated direct.";
        DynamicsJNI.btMultiBody_stepPositionsMultiDof__SWIG_0(this.swigCPtr, this, dt, pq, pqd);
    }

    public void stepPositionsMultiDof(float dt, FloatBuffer pq) {
        assert (pq.isDirect()) : "Buffer must be allocated direct.";
        DynamicsJNI.btMultiBody_stepPositionsMultiDof__SWIG_1(this.swigCPtr, this, dt, pq);
    }

    public void stepPositionsMultiDof(float dt) {
        DynamicsJNI.btMultiBody_stepPositionsMultiDof__SWIG_2(this.swigCPtr, this, dt);
    }

    public void fillContactJacobianMultiDof(int link, Vector3 contact_point, Vector3 normal, FloatBuffer jac, btScalarArray scratch_r, btVector3Array scratch_v, SWIGTYPE_p_btAlignedObjectArrayT_btMatrix3x3_t scratch_m) {
        assert (jac.isDirect()) : "Buffer must be allocated direct.";
        DynamicsJNI.btMultiBody_fillContactJacobianMultiDof(this.swigCPtr, this, link, contact_point, normal, jac, btScalarArray.getCPtr(scratch_r), scratch_r, btVector3Array.getCPtr(scratch_v), scratch_v, SWIGTYPE_p_btAlignedObjectArrayT_btMatrix3x3_t.getCPtr(scratch_m));
    }

    public void fillConstraintJacobianMultiDof(int link, Vector3 contact_point, Vector3 normal_ang, Vector3 normal_lin, FloatBuffer jac, btScalarArray scratch_r, btVector3Array scratch_v, SWIGTYPE_p_btAlignedObjectArrayT_btMatrix3x3_t scratch_m) {
        assert (jac.isDirect()) : "Buffer must be allocated direct.";
        DynamicsJNI.btMultiBody_fillConstraintJacobianMultiDof(this.swigCPtr, this, link, contact_point, normal_ang, normal_lin, jac, btScalarArray.getCPtr(scratch_r), scratch_r, btVector3Array.getCPtr(scratch_v), scratch_v, SWIGTYPE_p_btAlignedObjectArrayT_btMatrix3x3_t.getCPtr(scratch_m));
    }

    public void setCanSleep(boolean canSleep) {
        DynamicsJNI.btMultiBody_setCanSleep(this.swigCPtr, this, canSleep);
    }

    public boolean getCanSleep() {
        return DynamicsJNI.btMultiBody_getCanSleep(this.swigCPtr, this);
    }

    public boolean isAwake() {
        return DynamicsJNI.btMultiBody_isAwake(this.swigCPtr, this);
    }

    public void wakeUp() {
        DynamicsJNI.btMultiBody_wakeUp(this.swigCPtr, this);
    }

    public void goToSleep() {
        DynamicsJNI.btMultiBody_goToSleep(this.swigCPtr, this);
    }

    public void checkMotionAndSleepIfRequired(float timestep) {
        DynamicsJNI.btMultiBody_checkMotionAndSleepIfRequired(this.swigCPtr, this, timestep);
    }

    public boolean hasFixedBase() {
        return DynamicsJNI.btMultiBody_hasFixedBase(this.swigCPtr, this);
    }

    public int getCompanionId() {
        return DynamicsJNI.btMultiBody_getCompanionId(this.swigCPtr, this);
    }

    public void setCompanionId(int id) {
        DynamicsJNI.btMultiBody_setCompanionId(this.swigCPtr, this, id);
    }

    public void setNumLinks(int numLinks) {
        DynamicsJNI.btMultiBody_setNumLinks(this.swigCPtr, this, numLinks);
    }

    public float getLinearDamping() {
        return DynamicsJNI.btMultiBody_getLinearDamping(this.swigCPtr, this);
    }

    public void setLinearDamping(float damp) {
        DynamicsJNI.btMultiBody_setLinearDamping(this.swigCPtr, this, damp);
    }

    public float getAngularDamping() {
        return DynamicsJNI.btMultiBody_getAngularDamping(this.swigCPtr, this);
    }

    public void setAngularDamping(float damp) {
        DynamicsJNI.btMultiBody_setAngularDamping(this.swigCPtr, this, damp);
    }

    public boolean getUseGyroTerm() {
        return DynamicsJNI.btMultiBody_getUseGyroTerm(this.swigCPtr, this);
    }

    public void setUseGyroTerm(boolean useGyro) {
        DynamicsJNI.btMultiBody_setUseGyroTerm(this.swigCPtr, this, useGyro);
    }

    public float getMaxCoordinateVelocity() {
        return DynamicsJNI.btMultiBody_getMaxCoordinateVelocity(this.swigCPtr, this);
    }

    public void setMaxCoordinateVelocity(float maxVel) {
        DynamicsJNI.btMultiBody_setMaxCoordinateVelocity(this.swigCPtr, this, maxVel);
    }

    public float getMaxAppliedImpulse() {
        return DynamicsJNI.btMultiBody_getMaxAppliedImpulse(this.swigCPtr, this);
    }

    public void setMaxAppliedImpulse(float maxImp) {
        DynamicsJNI.btMultiBody_setMaxAppliedImpulse(this.swigCPtr, this, maxImp);
    }

    public void setHasSelfCollision(boolean hasSelfCollision) {
        DynamicsJNI.btMultiBody_setHasSelfCollision(this.swigCPtr, this, hasSelfCollision);
    }

    public boolean hasSelfCollision() {
        return DynamicsJNI.btMultiBody_hasSelfCollision(this.swigCPtr, this);
    }

    public void finalizeMultiDof() {
        DynamicsJNI.btMultiBody_finalizeMultiDof(this.swigCPtr, this);
    }

    public void useRK4Integration(boolean use) {
        DynamicsJNI.btMultiBody_useRK4Integration(this.swigCPtr, this, use);
    }

    public boolean isUsingRK4Integration() {
        return DynamicsJNI.btMultiBody_isUsingRK4Integration(this.swigCPtr, this);
    }

    public void useGlobalVelocities(boolean use) {
        DynamicsJNI.btMultiBody_useGlobalVelocities(this.swigCPtr, this, use);
    }

    public boolean isUsingGlobalVelocities() {
        return DynamicsJNI.btMultiBody_isUsingGlobalVelocities(this.swigCPtr, this);
    }

    public boolean isPosUpdated() {
        return DynamicsJNI.btMultiBody_isPosUpdated(this.swigCPtr, this);
    }

    public void setPosUpdated(boolean updated) {
        DynamicsJNI.btMultiBody_setPosUpdated(this.swigCPtr, this, updated);
    }

    public boolean internalNeedsJointFeedback() {
        return DynamicsJNI.btMultiBody_internalNeedsJointFeedback(this.swigCPtr, this);
    }

    public void forwardKinematics(SWIGTYPE_p_btAlignedObjectArrayT_btQuaternion_t scratch_q, btVector3Array scratch_m) {
        DynamicsJNI.btMultiBody_forwardKinematics(this.swigCPtr, this, SWIGTYPE_p_btAlignedObjectArrayT_btQuaternion_t.getCPtr(scratch_q), btVector3Array.getCPtr(scratch_m), scratch_m);
    }

    public void compTreeLinkVelocities(btVector3 omega, btVector3 vel) {
        DynamicsJNI.btMultiBody_compTreeLinkVelocities(this.swigCPtr, this, btVector3.getCPtr(omega), omega, btVector3.getCPtr(vel), vel);
    }

    public void updateCollisionObjectWorldTransforms(SWIGTYPE_p_btAlignedObjectArrayT_btQuaternion_t scratch_q, btVector3Array scratch_m) {
        DynamicsJNI.btMultiBody_updateCollisionObjectWorldTransforms(this.swigCPtr, this, SWIGTYPE_p_btAlignedObjectArrayT_btQuaternion_t.getCPtr(scratch_q), btVector3Array.getCPtr(scratch_m), scratch_m);
    }

    public int calculateSerializeBufferSize() {
        return DynamicsJNI.btMultiBody_calculateSerializeBufferSize(this.swigCPtr, this);
    }

    public String serialize(long dataBuffer, btSerializer serializer) {
        return DynamicsJNI.btMultiBody_serialize(this.swigCPtr, this, dataBuffer, btSerializer.getCPtr(serializer), serializer);
    }

    public String getBaseName() {
        return DynamicsJNI.btMultiBody_getBaseName(this.swigCPtr, this);
    }

    public void setBaseName(String name) {
        DynamicsJNI.btMultiBody_setBaseName(this.swigCPtr, this, name);
    }

    public long getUserPointer() {
        return DynamicsJNI.btMultiBody_getUserPointer(this.swigCPtr, this);
    }

    public int getUserIndex() {
        return DynamicsJNI.btMultiBody_getUserIndex(this.swigCPtr, this);
    }

    public int getUserIndex2() {
        return DynamicsJNI.btMultiBody_getUserIndex2(this.swigCPtr, this);
    }

    public void setUserPointer(long userPointer) {
        DynamicsJNI.btMultiBody_setUserPointer(this.swigCPtr, this, userPointer);
    }

    public void setUserIndex(int index) {
        DynamicsJNI.btMultiBody_setUserIndex(this.swigCPtr, this, index);
    }

    public void setUserIndex2(int index) {
        DynamicsJNI.btMultiBody_setUserIndex2(this.swigCPtr, this, index);
    }
}

