/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.dynamics;

import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.collision.btBroadphaseProxy;
import com.badlogic.gdx.physics.bullet.collision.btCollisionObject;
import com.badlogic.gdx.physics.bullet.collision.btCollisionShape;
import com.badlogic.gdx.physics.bullet.dynamics.DynamicsJNI;
import com.badlogic.gdx.physics.bullet.dynamics.btTypedConstraint;
import com.badlogic.gdx.physics.bullet.linearmath.btMotionState;
import com.badlogic.gdx.physics.bullet.linearmath.btTransform;
import com.badlogic.gdx.physics.bullet.linearmath.btVector3;

public class btRigidBody
extends btCollisionObject {
    private long swigCPtr;
    protected btMotionState motionState;

    protected btRigidBody(String className, long cPtr, boolean cMemoryOwn) {
        super(className, DynamicsJNI.btRigidBody_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btRigidBody(long cPtr, boolean cMemoryOwn) {
        this("btRigidBody", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(DynamicsJNI.btRigidBody_SWIGUpcast(this.swigCPtr), cMemoryOwn);
    }

    public static long getCPtr(btRigidBody obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                DynamicsJNI.delete_btRigidBody(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static btRigidBody getInstance(long swigCPtr) {
        return (btRigidBody)btCollisionObject.getInstance(swigCPtr);
    }

    public static btRigidBody getInstance(long swigCPtr, boolean owner) {
        if (swigCPtr == 0L) {
            return null;
        }
        btRigidBody result = btRigidBody.getInstance(swigCPtr);
        if (result == null) {
            result = new btRigidBody(swigCPtr, owner);
        }
        return result;
    }

    public btRigidBody(btRigidBodyConstructionInfo constructionInfo) {
        this(false, constructionInfo);
        this.refCollisionShape(constructionInfo.getCollisionShape());
        this.refMotionState(constructionInfo.getMotionState());
    }

    public btRigidBody(float mass, btMotionState motionState, btCollisionShape collisionShape, Vector3 localInertia) {
        this(false, mass, motionState, collisionShape, localInertia);
        this.refCollisionShape(collisionShape);
        this.refMotionState(motionState);
    }

    public btRigidBody(float mass, btMotionState motionState, btCollisionShape collisionShape) {
        this(false, mass, motionState, collisionShape);
        this.refCollisionShape(collisionShape);
        this.refMotionState(motionState);
    }

    public void setMotionState(btMotionState motionState) {
        this.refMotionState(motionState);
        this.internalSetMotionState(motionState);
    }

    protected void refMotionState(btMotionState motionState) {
        if (this.motionState == motionState) {
            return;
        }
        if (this.motionState != null) {
            this.motionState.release();
        }
        this.motionState = motionState;
        if (this.motionState != null) {
            this.motionState.obtain();
        }
    }

    public btMotionState getMotionState() {
        return this.motionState;
    }

    @Override
    public void dispose() {
        if (this.motionState != null) {
            this.motionState.release();
        }
        this.motionState = null;
        super.dispose();
    }

    public void proceedToTransform(Matrix4 newTrans) {
        DynamicsJNI.btRigidBody_proceedToTransform(this.swigCPtr, this, newTrans);
    }

    public void predictIntegratedTransform(float step, Matrix4 predictedTransform) {
        DynamicsJNI.btRigidBody_predictIntegratedTransform(this.swigCPtr, this, step, predictedTransform);
    }

    public void saveKinematicState(float step) {
        DynamicsJNI.btRigidBody_saveKinematicState(this.swigCPtr, this, step);
    }

    public void applyGravity() {
        DynamicsJNI.btRigidBody_applyGravity(this.swigCPtr, this);
    }

    public void setGravity(Vector3 acceleration) {
        DynamicsJNI.btRigidBody_setGravity(this.swigCPtr, this, acceleration);
    }

    public Vector3 getGravity() {
        return DynamicsJNI.btRigidBody_getGravity(this.swigCPtr, this);
    }

    public void setDamping(float lin_damping, float ang_damping) {
        DynamicsJNI.btRigidBody_setDamping(this.swigCPtr, this, lin_damping, ang_damping);
    }

    public float getLinearDamping() {
        return DynamicsJNI.btRigidBody_getLinearDamping(this.swigCPtr, this);
    }

    public float getAngularDamping() {
        return DynamicsJNI.btRigidBody_getAngularDamping(this.swigCPtr, this);
    }

    public float getLinearSleepingThreshold() {
        return DynamicsJNI.btRigidBody_getLinearSleepingThreshold(this.swigCPtr, this);
    }

    public float getAngularSleepingThreshold() {
        return DynamicsJNI.btRigidBody_getAngularSleepingThreshold(this.swigCPtr, this);
    }

    public void applyDamping(float timeStep) {
        DynamicsJNI.btRigidBody_applyDamping(this.swigCPtr, this, timeStep);
    }

    public void setMassProps(float mass, Vector3 inertia) {
        DynamicsJNI.btRigidBody_setMassProps(this.swigCPtr, this, mass, inertia);
    }

    public Vector3 getLinearFactor() {
        return DynamicsJNI.btRigidBody_getLinearFactor(this.swigCPtr, this);
    }

    public void setLinearFactor(Vector3 linearFactor) {
        DynamicsJNI.btRigidBody_setLinearFactor(this.swigCPtr, this, linearFactor);
    }

    public float getInvMass() {
        return DynamicsJNI.btRigidBody_getInvMass(this.swigCPtr, this);
    }

    public Matrix3 getInvInertiaTensorWorld() {
        return DynamicsJNI.btRigidBody_getInvInertiaTensorWorld(this.swigCPtr, this);
    }

    public void integrateVelocities(float step) {
        DynamicsJNI.btRigidBody_integrateVelocities(this.swigCPtr, this, step);
    }

    public void setCenterOfMassTransform(Matrix4 xform) {
        DynamicsJNI.btRigidBody_setCenterOfMassTransform(this.swigCPtr, this, xform);
    }

    public void applyCentralForce(Vector3 force) {
        DynamicsJNI.btRigidBody_applyCentralForce(this.swigCPtr, this, force);
    }

    public Vector3 getTotalForce() {
        return DynamicsJNI.btRigidBody_getTotalForce(this.swigCPtr, this);
    }

    public Vector3 getTotalTorque() {
        return DynamicsJNI.btRigidBody_getTotalTorque(this.swigCPtr, this);
    }

    public Vector3 getInvInertiaDiagLocal() {
        return DynamicsJNI.btRigidBody_getInvInertiaDiagLocal(this.swigCPtr, this);
    }

    public void setInvInertiaDiagLocal(Vector3 diagInvInertia) {
        DynamicsJNI.btRigidBody_setInvInertiaDiagLocal(this.swigCPtr, this, diagInvInertia);
    }

    public void setSleepingThresholds(float linear, float angular) {
        DynamicsJNI.btRigidBody_setSleepingThresholds(this.swigCPtr, this, linear, angular);
    }

    public void applyTorque(Vector3 torque) {
        DynamicsJNI.btRigidBody_applyTorque(this.swigCPtr, this, torque);
    }

    public void applyForce(Vector3 force, Vector3 rel_pos) {
        DynamicsJNI.btRigidBody_applyForce(this.swigCPtr, this, force, rel_pos);
    }

    public void applyCentralImpulse(Vector3 impulse) {
        DynamicsJNI.btRigidBody_applyCentralImpulse(this.swigCPtr, this, impulse);
    }

    public void applyTorqueImpulse(Vector3 torque) {
        DynamicsJNI.btRigidBody_applyTorqueImpulse(this.swigCPtr, this, torque);
    }

    public void applyImpulse(Vector3 impulse, Vector3 rel_pos) {
        DynamicsJNI.btRigidBody_applyImpulse(this.swigCPtr, this, impulse, rel_pos);
    }

    public void clearForces() {
        DynamicsJNI.btRigidBody_clearForces(this.swigCPtr, this);
    }

    public void updateInertiaTensor() {
        DynamicsJNI.btRigidBody_updateInertiaTensor(this.swigCPtr, this);
    }

    public Vector3 getCenterOfMassPosition() {
        return DynamicsJNI.btRigidBody_getCenterOfMassPosition(this.swigCPtr, this);
    }

    public Quaternion getOrientation() {
        return DynamicsJNI.btRigidBody_getOrientation(this.swigCPtr, this);
    }

    public Matrix4 getCenterOfMassTransform() {
        return DynamicsJNI.btRigidBody_getCenterOfMassTransform(this.swigCPtr, this);
    }

    public Vector3 getLinearVelocity() {
        return DynamicsJNI.btRigidBody_getLinearVelocity(this.swigCPtr, this);
    }

    public Vector3 getAngularVelocity() {
        return DynamicsJNI.btRigidBody_getAngularVelocity(this.swigCPtr, this);
    }

    public void setLinearVelocity(Vector3 lin_vel) {
        DynamicsJNI.btRigidBody_setLinearVelocity(this.swigCPtr, this, lin_vel);
    }

    public void setAngularVelocity(Vector3 ang_vel) {
        DynamicsJNI.btRigidBody_setAngularVelocity(this.swigCPtr, this, ang_vel);
    }

    public Vector3 getVelocityInLocalPoint(Vector3 rel_pos) {
        return DynamicsJNI.btRigidBody_getVelocityInLocalPoint(this.swigCPtr, this, rel_pos);
    }

    public void translate(Vector3 v) {
        DynamicsJNI.btRigidBody_translate(this.swigCPtr, this, v);
    }

    public void getAabb(Vector3 aabbMin, Vector3 aabbMax) {
        DynamicsJNI.btRigidBody_getAabb(this.swigCPtr, this, aabbMin, aabbMax);
    }

    public float computeImpulseDenominator(Vector3 pos, Vector3 normal) {
        return DynamicsJNI.btRigidBody_computeImpulseDenominator(this.swigCPtr, this, pos, normal);
    }

    public float computeAngularImpulseDenominator(Vector3 axis) {
        return DynamicsJNI.btRigidBody_computeAngularImpulseDenominator(this.swigCPtr, this, axis);
    }

    public void updateDeactivation(float timeStep) {
        DynamicsJNI.btRigidBody_updateDeactivation(this.swigCPtr, this, timeStep);
    }

    public boolean wantsSleeping() {
        return DynamicsJNI.btRigidBody_wantsSleeping(this.swigCPtr, this);
    }

    public btBroadphaseProxy getBroadphaseProxyConst() {
        return btBroadphaseProxy.internalTemp(DynamicsJNI.btRigidBody_getBroadphaseProxyConst(this.swigCPtr, this), false);
    }

    public btBroadphaseProxy getBroadphaseProxy() {
        return btBroadphaseProxy.internalTemp(DynamicsJNI.btRigidBody_getBroadphaseProxy(this.swigCPtr, this), false);
    }

    public void setNewBroadphaseProxy(btBroadphaseProxy broadphaseProxy) {
        DynamicsJNI.btRigidBody_setNewBroadphaseProxy(this.swigCPtr, this, btBroadphaseProxy.getCPtr(broadphaseProxy), broadphaseProxy);
    }

    private btMotionState internalGetMotionState() {
        long cPtr = DynamicsJNI.btRigidBody_internalGetMotionState(this.swigCPtr, this);
        return cPtr == 0L ? null : new btMotionState(cPtr, false);
    }

    private btMotionState getMotionStateConst() {
        long cPtr = DynamicsJNI.btRigidBody_getMotionStateConst(this.swigCPtr, this);
        return cPtr == 0L ? null : new btMotionState(cPtr, false);
    }

    private void internalSetMotionState(btMotionState motionState) {
        DynamicsJNI.btRigidBody_internalSetMotionState(this.swigCPtr, this, btMotionState.getCPtr(motionState), motionState);
    }

    public void setContactSolverType(int value) {
        DynamicsJNI.btRigidBody_contactSolverType_set(this.swigCPtr, this, value);
    }

    public int getContactSolverType() {
        return DynamicsJNI.btRigidBody_contactSolverType_get(this.swigCPtr, this);
    }

    public void setFrictionSolverType(int value) {
        DynamicsJNI.btRigidBody_frictionSolverType_set(this.swigCPtr, this, value);
    }

    public int getFrictionSolverType() {
        return DynamicsJNI.btRigidBody_frictionSolverType_get(this.swigCPtr, this);
    }

    public void setAngularFactor(Vector3 angFac) {
        DynamicsJNI.btRigidBody_setAngularFactor__SWIG_0(this.swigCPtr, this, angFac);
    }

    public void setAngularFactor(float angFac) {
        DynamicsJNI.btRigidBody_setAngularFactor__SWIG_1(this.swigCPtr, this, angFac);
    }

    public Vector3 getAngularFactor() {
        return DynamicsJNI.btRigidBody_getAngularFactor(this.swigCPtr, this);
    }

    public boolean isInWorld() {
        return DynamicsJNI.btRigidBody_isInWorld(this.swigCPtr, this);
    }

    public void addConstraintRef(btTypedConstraint c) {
        DynamicsJNI.btRigidBody_addConstraintRef(this.swigCPtr, this, btTypedConstraint.getCPtr(c), c);
    }

    public void removeConstraintRef(btTypedConstraint c) {
        DynamicsJNI.btRigidBody_removeConstraintRef(this.swigCPtr, this, btTypedConstraint.getCPtr(c), c);
    }

    public btTypedConstraint getConstraintRef(int index) {
        long cPtr = DynamicsJNI.btRigidBody_getConstraintRef(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new btTypedConstraint(cPtr, false);
    }

    public int getNumConstraintRefs() {
        return DynamicsJNI.btRigidBody_getNumConstraintRefs(this.swigCPtr, this);
    }

    public void setFlags(int flags) {
        DynamicsJNI.btRigidBody_setFlags(this.swigCPtr, this, flags);
    }

    public int getFlags() {
        return DynamicsJNI.btRigidBody_getFlags(this.swigCPtr, this);
    }

    public Vector3 computeGyroscopicImpulseImplicit_World(float dt) {
        return DynamicsJNI.btRigidBody_computeGyroscopicImpulseImplicit_World(this.swigCPtr, this, dt);
    }

    public Vector3 computeGyroscopicImpulseImplicit_Body(float step) {
        return DynamicsJNI.btRigidBody_computeGyroscopicImpulseImplicit_Body(this.swigCPtr, this, step);
    }

    public Vector3 computeGyroscopicForceExplicit(float maxGyroscopicForce) {
        return DynamicsJNI.btRigidBody_computeGyroscopicForceExplicit(this.swigCPtr, this, maxGyroscopicForce);
    }

    public Vector3 getLocalInertia() {
        return DynamicsJNI.btRigidBody_getLocalInertia(this.swigCPtr, this);
    }

    private btRigidBody(boolean dummy, btRigidBodyConstructionInfo constructionInfo) {
        this(DynamicsJNI.new_btRigidBody__SWIG_0(dummy, btRigidBodyConstructionInfo.getCPtr(constructionInfo), constructionInfo), true);
    }

    private btRigidBody(boolean dummy, float mass, btMotionState motionState, btCollisionShape collisionShape, Vector3 localInertia) {
        this(DynamicsJNI.new_btRigidBody__SWIG_1(dummy, mass, btMotionState.getCPtr(motionState), motionState, btCollisionShape.getCPtr(collisionShape), collisionShape, localInertia), true);
    }

    private btRigidBody(boolean dummy, float mass, btMotionState motionState, btCollisionShape collisionShape) {
        this(DynamicsJNI.new_btRigidBody__SWIG_2(dummy, mass, btMotionState.getCPtr(motionState), motionState, btCollisionShape.getCPtr(collisionShape), collisionShape), true);
    }

    public static class btRigidBodyConstructionInfo
    extends BulletBase {
        private long swigCPtr;
        protected btMotionState motionState;
        protected btCollisionShape collisionShape;

        protected btRigidBodyConstructionInfo(String className, long cPtr, boolean cMemoryOwn) {
            super(className, cPtr, cMemoryOwn);
            this.swigCPtr = cPtr;
        }

        public btRigidBodyConstructionInfo(long cPtr, boolean cMemoryOwn) {
            this("btRigidBodyConstructionInfo", cPtr, cMemoryOwn);
            this.construct();
        }

        @Override
        protected void reset(long cPtr, boolean cMemoryOwn) {
            if (!this.destroyed) {
                this.destroy();
            }
            this.swigCPtr = cPtr;
            super.reset(this.swigCPtr, cMemoryOwn);
        }

        public static long getCPtr(btRigidBodyConstructionInfo obj) {
            return obj == null ? 0L : obj.swigCPtr;
        }

        @Override
        protected void finalize() throws Throwable {
            if (!this.destroyed) {
                this.destroy();
            }
            super.finalize();
        }

        @Override
        protected synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    DynamicsJNI.delete_btRigidBody_btRigidBodyConstructionInfo(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
            super.delete();
        }

        public void setMotionState(btMotionState motionState) {
            this.refMotionState(motionState);
            this.setI_motionState(motionState);
        }

        protected void refMotionState(btMotionState motionState) {
            if (this.motionState == motionState) {
                return;
            }
            if (this.motionState != null) {
                this.motionState.release();
            }
            this.motionState = motionState;
            if (this.motionState != null) {
                this.motionState.obtain();
            }
        }

        public btMotionState getMotionState() {
            return this.motionState;
        }

        public void setCollisionShape(btCollisionShape collisionShape) {
            this.refCollisionShape(collisionShape);
            this.setI_collisionShape(collisionShape);
        }

        protected void refCollisionShape(btCollisionShape shape) {
            if (this.collisionShape == shape) {
                return;
            }
            if (this.collisionShape != null) {
                this.collisionShape.release();
            }
            this.collisionShape = shape;
            if (this.collisionShape != null) {
                this.collisionShape.obtain();
            }
        }

        public btCollisionShape getCollisionShape() {
            return this.collisionShape;
        }

        public btRigidBodyConstructionInfo(float mass, btMotionState motionState, btCollisionShape collisionShape, Vector3 localInertia) {
            this(false, mass, motionState, collisionShape, localInertia);
            this.refMotionState(motionState);
            this.refCollisionShape(collisionShape);
        }

        public btRigidBodyConstructionInfo(float mass, btMotionState motionState, btCollisionShape collisionShape) {
            this(false, mass, motionState, collisionShape);
            this.refMotionState(motionState);
            this.refCollisionShape(collisionShape);
        }

        @Override
        public void dispose() {
            if (this.motionState != null) {
                this.motionState.release();
            }
            this.motionState = null;
            if (this.collisionShape != null) {
                this.collisionShape.release();
            }
            this.collisionShape = null;
            super.dispose();
        }

        public void setMass(float value) {
            DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_mass_set(this.swigCPtr, this, value);
        }

        public float getMass() {
            return DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_mass_get(this.swigCPtr, this);
        }

        private void setI_motionState(btMotionState value) {
            DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_i_motionState_set(this.swigCPtr, this, btMotionState.getCPtr(value), value);
        }

        private btMotionState getI_motionState() {
            long cPtr = DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_i_motionState_get(this.swigCPtr, this);
            return cPtr == 0L ? null : new btMotionState(cPtr, false);
        }

        public void setStartWorldTransform(btTransform value) {
            DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_startWorldTransform_set(this.swigCPtr, this, btTransform.getCPtr(value), value);
        }

        public btTransform getStartWorldTransform() {
            long cPtr = DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_startWorldTransform_get(this.swigCPtr, this);
            return cPtr == 0L ? null : new btTransform(cPtr, false);
        }

        private void setI_collisionShape(btCollisionShape value) {
            DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_i_collisionShape_set(this.swigCPtr, this, btCollisionShape.getCPtr(value), value);
        }

        private btCollisionShape getI_collisionShape() {
            long cPtr = DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_i_collisionShape_get(this.swigCPtr, this);
            return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
        }

        public void setLocalInertia(btVector3 value) {
            DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_localInertia_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
        }

        public btVector3 getLocalInertia() {
            long cPtr = DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_localInertia_get(this.swigCPtr, this);
            return cPtr == 0L ? null : new btVector3(cPtr, false);
        }

        public void setLinearDamping(float value) {
            DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_linearDamping_set(this.swigCPtr, this, value);
        }

        public float getLinearDamping() {
            return DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_linearDamping_get(this.swigCPtr, this);
        }

        public void setAngularDamping(float value) {
            DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_angularDamping_set(this.swigCPtr, this, value);
        }

        public float getAngularDamping() {
            return DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_angularDamping_get(this.swigCPtr, this);
        }

        public void setFriction(float value) {
            DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_friction_set(this.swigCPtr, this, value);
        }

        public float getFriction() {
            return DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_friction_get(this.swigCPtr, this);
        }

        public void setRollingFriction(float value) {
            DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_rollingFriction_set(this.swigCPtr, this, value);
        }

        public float getRollingFriction() {
            return DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_rollingFriction_get(this.swigCPtr, this);
        }

        public void setSpinningFriction(float value) {
            DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_spinningFriction_set(this.swigCPtr, this, value);
        }

        public float getSpinningFriction() {
            return DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_spinningFriction_get(this.swigCPtr, this);
        }

        public void setRestitution(float value) {
            DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_restitution_set(this.swigCPtr, this, value);
        }

        public float getRestitution() {
            return DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_restitution_get(this.swigCPtr, this);
        }

        public void setLinearSleepingThreshold(float value) {
            DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_linearSleepingThreshold_set(this.swigCPtr, this, value);
        }

        public float getLinearSleepingThreshold() {
            return DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_linearSleepingThreshold_get(this.swigCPtr, this);
        }

        public void setAngularSleepingThreshold(float value) {
            DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_angularSleepingThreshold_set(this.swigCPtr, this, value);
        }

        public float getAngularSleepingThreshold() {
            return DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_angularSleepingThreshold_get(this.swigCPtr, this);
        }

        public void setAdditionalDamping(boolean value) {
            DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_additionalDamping_set(this.swigCPtr, this, value);
        }

        public boolean getAdditionalDamping() {
            return DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_additionalDamping_get(this.swigCPtr, this);
        }

        public void setAdditionalDampingFactor(float value) {
            DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_additionalDampingFactor_set(this.swigCPtr, this, value);
        }

        public float getAdditionalDampingFactor() {
            return DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_additionalDampingFactor_get(this.swigCPtr, this);
        }

        public void setAdditionalLinearDampingThresholdSqr(float value) {
            DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_additionalLinearDampingThresholdSqr_set(this.swigCPtr, this, value);
        }

        public float getAdditionalLinearDampingThresholdSqr() {
            return DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_additionalLinearDampingThresholdSqr_get(this.swigCPtr, this);
        }

        public void setAdditionalAngularDampingThresholdSqr(float value) {
            DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_additionalAngularDampingThresholdSqr_set(this.swigCPtr, this, value);
        }

        public float getAdditionalAngularDampingThresholdSqr() {
            return DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_additionalAngularDampingThresholdSqr_get(this.swigCPtr, this);
        }

        public void setAdditionalAngularDampingFactor(float value) {
            DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_additionalAngularDampingFactor_set(this.swigCPtr, this, value);
        }

        public float getAdditionalAngularDampingFactor() {
            return DynamicsJNI.btRigidBody_btRigidBodyConstructionInfo_additionalAngularDampingFactor_get(this.swigCPtr, this);
        }

        private btRigidBodyConstructionInfo(boolean dummy, float mass, btMotionState motionState, btCollisionShape collisionShape, Vector3 localInertia) {
            this(DynamicsJNI.new_btRigidBody_btRigidBodyConstructionInfo__SWIG_0(dummy, mass, btMotionState.getCPtr(motionState), motionState, btCollisionShape.getCPtr(collisionShape), collisionShape, localInertia), true);
        }

        private btRigidBodyConstructionInfo(boolean dummy, float mass, btMotionState motionState, btCollisionShape collisionShape) {
            this(DynamicsJNI.new_btRigidBody_btRigidBodyConstructionInfo__SWIG_1(dummy, mass, btMotionState.getCPtr(motionState), motionState, btCollisionShape.getCPtr(collisionShape), collisionShape), true);
        }
    }
}

