/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.extras;

import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.extras.ExtrasJNI;
import com.badlogic.gdx.physics.bullet.extras.SWIGTYPE_p_MultiBodyNameMap;
import com.badlogic.gdx.physics.bullet.extras.SWIGTYPE_p_btInverseDynamicsBullet3__JointType;
import com.badlogic.gdx.physics.bullet.extras.SWIGTYPE_p_mat33;
import com.badlogic.gdx.physics.bullet.extras.SWIGTYPE_p_p_void;
import com.badlogic.gdx.physics.bullet.extras.SWIGTYPE_p_vec3;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class MultiBodyTreeCreator
extends BulletBase {
    private long swigCPtr;

    protected MultiBodyTreeCreator(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public MultiBodyTreeCreator(long cPtr, boolean cMemoryOwn) {
        this("MultiBodyTreeCreator", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(MultiBodyTreeCreator obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                ExtrasJNI.delete_MultiBodyTreeCreator(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public int getNumBodies(IntBuffer num_bodies) {
        assert (num_bodies.isDirect()) : "Buffer must be allocated direct.";
        return ExtrasJNI.MultiBodyTreeCreator_getNumBodies(this.swigCPtr, this, num_bodies);
    }

    public int getBody(int body_index, IntBuffer parent_index, SWIGTYPE_p_btInverseDynamicsBullet3__JointType joint_type, SWIGTYPE_p_vec3 parent_r_parent_body_ref, SWIGTYPE_p_mat33 body_T_parent_ref, SWIGTYPE_p_vec3 body_axis_of_motion, FloatBuffer mass, SWIGTYPE_p_vec3 body_r_body_com, SWIGTYPE_p_mat33 body_I_body, IntBuffer user_int, SWIGTYPE_p_p_void user_ptr) {
        assert (parent_index.isDirect()) : "Buffer must be allocated direct.";
        assert (mass.isDirect()) : "Buffer must be allocated direct.";
        assert (user_int.isDirect()) : "Buffer must be allocated direct.";
        return ExtrasJNI.MultiBodyTreeCreator_getBody(this.swigCPtr, this, body_index, parent_index, SWIGTYPE_p_btInverseDynamicsBullet3__JointType.getCPtr(joint_type), SWIGTYPE_p_vec3.getCPtr(parent_r_parent_body_ref), SWIGTYPE_p_mat33.getCPtr(body_T_parent_ref), SWIGTYPE_p_vec3.getCPtr(body_axis_of_motion), mass, SWIGTYPE_p_vec3.getCPtr(body_r_body_com), SWIGTYPE_p_mat33.getCPtr(body_I_body), user_int, SWIGTYPE_p_p_void.getCPtr(user_ptr));
    }

    public SWIGTYPE_p_MultiBodyNameMap getNameMap() {
        long cPtr = ExtrasJNI.MultiBodyTreeCreator_getNameMap(this.swigCPtr, this);
        return cPtr == 0L ? null : new SWIGTYPE_p_MultiBodyNameMap(cPtr, false);
    }
}

