/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.physics.bullet.collision.GIM_AABB;
import com.badlogic.gdx.physics.bullet.collision.GIM_TRIANGLE_CONTACT_DATA;
import com.badlogic.gdx.physics.bullet.collision.SWIGTYPE_p_float;
import com.badlogic.gdx.physics.bullet.linearmath.btVector3;
import com.badlogic.gdx.physics.bullet.linearmath.btVector4;

public class GIM_TRIANGLE
extends BulletBase {
    private long swigCPtr;

    protected GIM_TRIANGLE(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public GIM_TRIANGLE(long cPtr, boolean cMemoryOwn) {
        this("GIM_TRIANGLE", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(GIM_TRIANGLE obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_GIM_TRIANGLE(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setMargin(float value) {
        CollisionJNI.GIM_TRIANGLE_margin_set(this.swigCPtr, this, value);
    }

    public float getMargin() {
        return CollisionJNI.GIM_TRIANGLE_margin_get(this.swigCPtr, this);
    }

    public void setVertices(btVector3 value) {
        CollisionJNI.GIM_TRIANGLE_vertices_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getVertices() {
        long cPtr = CollisionJNI.GIM_TRIANGLE_vertices_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public GIM_TRIANGLE() {
        this(CollisionJNI.new_GIM_TRIANGLE(), true);
    }

    public GIM_AABB get_box() {
        return new GIM_AABB(CollisionJNI.GIM_TRIANGLE_get_box(this.swigCPtr, this), true);
    }

    public void get_normal(Vector3 normal) {
        CollisionJNI.GIM_TRIANGLE_get_normal(this.swigCPtr, this, normal);
    }

    public void get_plane(btVector4 plane) {
        CollisionJNI.GIM_TRIANGLE_get_plane(this.swigCPtr, this, btVector4.getCPtr(plane), plane);
    }

    public void apply_transform(Matrix4 trans) {
        CollisionJNI.GIM_TRIANGLE_apply_transform(this.swigCPtr, this, trans);
    }

    public void get_edge_plane(long edge_index, Vector3 triangle_normal, btVector4 plane) {
        CollisionJNI.GIM_TRIANGLE_get_edge_plane(this.swigCPtr, this, edge_index, triangle_normal, btVector4.getCPtr(plane), plane);
    }

    public void get_triangle_transform(Matrix4 triangle_transform) {
        CollisionJNI.GIM_TRIANGLE_get_triangle_transform(this.swigCPtr, this, triangle_transform);
    }

    public boolean collide_triangle_hard_test(GIM_TRIANGLE other, GIM_TRIANGLE_CONTACT_DATA contact_data) {
        return CollisionJNI.GIM_TRIANGLE_collide_triangle_hard_test(this.swigCPtr, this, GIM_TRIANGLE.getCPtr(other), other, GIM_TRIANGLE_CONTACT_DATA.getCPtr(contact_data), contact_data);
    }

    public boolean collide_triangle(GIM_TRIANGLE other, GIM_TRIANGLE_CONTACT_DATA contact_data) {
        return CollisionJNI.GIM_TRIANGLE_collide_triangle(this.swigCPtr, this, GIM_TRIANGLE.getCPtr(other), other, GIM_TRIANGLE_CONTACT_DATA.getCPtr(contact_data), contact_data);
    }

    public boolean get_uv_parameters(Vector3 point, Vector3 tri_plane, SWIGTYPE_p_float u, SWIGTYPE_p_float v) {
        return CollisionJNI.GIM_TRIANGLE_get_uv_parameters(this.swigCPtr, this, point, tri_plane, SWIGTYPE_p_float.getCPtr(u), SWIGTYPE_p_float.getCPtr(v));
    }

    public boolean is_point_inside(Vector3 point, Vector3 tri_normal) {
        return CollisionJNI.GIM_TRIANGLE_is_point_inside(this.swigCPtr, this, point, tri_normal);
    }

    public boolean ray_collision(Vector3 vPoint, Vector3 vDir, Vector3 pout, Vector3 triangle_normal, SWIGTYPE_p_float tparam, float tmax) {
        return CollisionJNI.GIM_TRIANGLE_ray_collision__SWIG_0(this.swigCPtr, this, vPoint, vDir, pout, triangle_normal, SWIGTYPE_p_float.getCPtr(tparam), tmax);
    }

    public boolean ray_collision(Vector3 vPoint, Vector3 vDir, Vector3 pout, Vector3 triangle_normal, SWIGTYPE_p_float tparam) {
        return CollisionJNI.GIM_TRIANGLE_ray_collision__SWIG_1(this.swigCPtr, this, vPoint, vDir, pout, triangle_normal, SWIGTYPE_p_float.getCPtr(tparam));
    }

    public boolean ray_collision_front_side(Vector3 vPoint, Vector3 vDir, Vector3 pout, Vector3 triangle_normal, SWIGTYPE_p_float tparam, float tmax) {
        return CollisionJNI.GIM_TRIANGLE_ray_collision_front_side__SWIG_0(this.swigCPtr, this, vPoint, vDir, pout, triangle_normal, SWIGTYPE_p_float.getCPtr(tparam), tmax);
    }

    public boolean ray_collision_front_side(Vector3 vPoint, Vector3 vDir, Vector3 pout, Vector3 triangle_normal, SWIGTYPE_p_float tparam) {
        return CollisionJNI.GIM_TRIANGLE_ray_collision_front_side__SWIG_1(this.swigCPtr, this, vPoint, vDir, pout, triangle_normal, SWIGTYPE_p_float.getCPtr(tparam));
    }
}

