/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.physics.bullet.collision.btOptimizedBvh;
import com.badlogic.gdx.physics.bullet.collision.btStridingMeshInterface;
import com.badlogic.gdx.physics.bullet.collision.btTriangleCallback;
import com.badlogic.gdx.physics.bullet.collision.btTriangleIndexVertexArray;
import com.badlogic.gdx.physics.bullet.collision.btTriangleInfoMap;
import com.badlogic.gdx.physics.bullet.collision.btTriangleMeshShape;
import com.badlogic.gdx.physics.bullet.linearmath.btSerializer;
import com.badlogic.gdx.utils.Array;

public class btBvhTriangleMeshShape
extends btTriangleMeshShape {
    private long swigCPtr;
    protected static final Array<btBvhTriangleMeshShape> instances = new Array();
    private btStridingMeshInterface meshInterface = null;

    protected btBvhTriangleMeshShape(String className, long cPtr, boolean cMemoryOwn) {
        super(className, CollisionJNI.btBvhTriangleMeshShape_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btBvhTriangleMeshShape(long cPtr, boolean cMemoryOwn) {
        this("btBvhTriangleMeshShape", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(CollisionJNI.btBvhTriangleMeshShape_SWIGUpcast(this.swigCPtr), cMemoryOwn);
    }

    public static long getCPtr(btBvhTriangleMeshShape obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_btBvhTriangleMeshShape(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    protected static <T extends MeshPart> btBvhTriangleMeshShape getInstance(Array<T> meshParts) {
        for (btBvhTriangleMeshShape instance : instances) {
            if (!(instance.meshInterface instanceof btTriangleIndexVertexArray) || !btTriangleIndexVertexArray.compare((btTriangleIndexVertexArray)instance.meshInterface, meshParts)) continue;
            return instance;
        }
        return null;
    }

    public static <T extends MeshPart> btBvhTriangleMeshShape obtain(Array<T> meshParts) {
        btBvhTriangleMeshShape result = btBvhTriangleMeshShape.getInstance(meshParts);
        if (result == null) {
            result = new btBvhTriangleMeshShape(btTriangleIndexVertexArray.obtain(meshParts), true);
            instances.add((Object)result);
        }
        result.obtain();
        return result;
    }

    @Override
    public btStridingMeshInterface getMeshInterface() {
        return this.meshInterface;
    }

    public <T extends MeshPart> btBvhTriangleMeshShape(Array<T> meshParts) {
        this(meshParts, true);
    }

    public <T extends MeshPart> btBvhTriangleMeshShape(Array<T> meshParts, boolean useQuantizedAabbCompression) {
        this(1, (btStridingMeshInterface)btTriangleIndexVertexArray.obtain(meshParts), useQuantizedAabbCompression);
    }

    public <T extends MeshPart> btBvhTriangleMeshShape(Array<T> meshParts, boolean useQuantizedAabbCompression, boolean buildBvh) {
        this(1, (btStridingMeshInterface)btTriangleIndexVertexArray.obtain(meshParts), useQuantizedAabbCompression, buildBvh);
    }

    public <T extends MeshPart> btBvhTriangleMeshShape(Array<T> meshParts, boolean useQuantizedAabbCompression, Vector3 bvhAabbMin, Vector3 bvhAabbMax) {
        this(1, (btStridingMeshInterface)btTriangleIndexVertexArray.obtain(meshParts), useQuantizedAabbCompression, bvhAabbMin, bvhAabbMax);
    }

    public <T extends MeshPart> btBvhTriangleMeshShape(Array<T> meshParts, boolean useQuantizedAabbCompression, Vector3 bvhAabbMin, Vector3 bvhAabbMax, boolean buildBvh) {
        this(1, (btStridingMeshInterface)btTriangleIndexVertexArray.obtain(meshParts), useQuantizedAabbCompression, bvhAabbMin, bvhAabbMax, buildBvh);
    }

    public btBvhTriangleMeshShape(btStridingMeshInterface meshInterface, boolean useQuantizedAabbCompression) {
        this(0, meshInterface, useQuantizedAabbCompression);
    }

    public btBvhTriangleMeshShape(btStridingMeshInterface meshInterface, boolean useQuantizedAabbCompression, boolean buildBvh) {
        this(0, meshInterface, useQuantizedAabbCompression, buildBvh);
    }

    public btBvhTriangleMeshShape(btStridingMeshInterface meshInterface, boolean useQuantizedAabbCompression, Vector3 bvhAabbMin, Vector3 bvhAabbMax, boolean buildBvh) {
        this(0, meshInterface, useQuantizedAabbCompression, bvhAabbMin, bvhAabbMax, buildBvh);
    }

    public btBvhTriangleMeshShape(btStridingMeshInterface meshInterface, boolean useQuantizedAabbCompression, Vector3 bvhAabbMin, Vector3 bvhAabbMax) {
        this(0, meshInterface, useQuantizedAabbCompression, bvhAabbMin, bvhAabbMax);
    }

    private btBvhTriangleMeshShape(int obtained, btStridingMeshInterface meshInterface, boolean useQuantizedAabbCompression) {
        this(true, meshInterface, useQuantizedAabbCompression);
        this.meshInterface = meshInterface;
        if (obtained == 0) {
            meshInterface.obtain();
        }
    }

    private btBvhTriangleMeshShape(int obtained, btStridingMeshInterface meshInterface, boolean useQuantizedAabbCompression, boolean buildBvh) {
        this(true, meshInterface, useQuantizedAabbCompression, buildBvh);
        this.meshInterface = meshInterface;
        if (obtained == 0) {
            meshInterface.obtain();
        }
    }

    private btBvhTriangleMeshShape(int obtained, btStridingMeshInterface meshInterface, boolean useQuantizedAabbCompression, Vector3 bvhAabbMin, Vector3 bvhAabbMax, boolean buildBvh) {
        this(true, meshInterface, useQuantizedAabbCompression, bvhAabbMin, bvhAabbMax, buildBvh);
        this.meshInterface = meshInterface;
        if (obtained == 0) {
            meshInterface.obtain();
        }
    }

    private btBvhTriangleMeshShape(int obtained, btStridingMeshInterface meshInterface, boolean useQuantizedAabbCompression, Vector3 bvhAabbMin, Vector3 bvhAabbMax) {
        this(true, meshInterface, useQuantizedAabbCompression, bvhAabbMin, bvhAabbMax);
        this.meshInterface = meshInterface;
        if (obtained == 0) {
            meshInterface.obtain();
        }
    }

    @Override
    public void dispose() {
        if (this.meshInterface != null) {
            this.meshInterface.release();
        }
        this.meshInterface = null;
        super.dispose();
    }

    @Override
    public long operatorNew(long sizeInBytes) {
        return CollisionJNI.btBvhTriangleMeshShape_operatorNew__SWIG_0(this.swigCPtr, this, sizeInBytes);
    }

    @Override
    public void operatorDelete(long ptr) {
        CollisionJNI.btBvhTriangleMeshShape_operatorDelete__SWIG_0(this.swigCPtr, this, ptr);
    }

    @Override
    public long operatorNew(long arg0, long ptr) {
        return CollisionJNI.btBvhTriangleMeshShape_operatorNew__SWIG_1(this.swigCPtr, this, arg0, ptr);
    }

    @Override
    public void operatorDelete(long arg0, long arg1) {
        CollisionJNI.btBvhTriangleMeshShape_operatorDelete__SWIG_1(this.swigCPtr, this, arg0, arg1);
    }

    @Override
    public long operatorNewArray(long sizeInBytes) {
        return CollisionJNI.btBvhTriangleMeshShape_operatorNewArray__SWIG_0(this.swigCPtr, this, sizeInBytes);
    }

    @Override
    public void operatorDeleteArray(long ptr) {
        CollisionJNI.btBvhTriangleMeshShape_operatorDeleteArray__SWIG_0(this.swigCPtr, this, ptr);
    }

    @Override
    public long operatorNewArray(long arg0, long ptr) {
        return CollisionJNI.btBvhTriangleMeshShape_operatorNewArray__SWIG_1(this.swigCPtr, this, arg0, ptr);
    }

    @Override
    public void operatorDeleteArray(long arg0, long arg1) {
        CollisionJNI.btBvhTriangleMeshShape_operatorDeleteArray__SWIG_1(this.swigCPtr, this, arg0, arg1);
    }

    public boolean getOwnsBvh() {
        return CollisionJNI.btBvhTriangleMeshShape_getOwnsBvh(this.swigCPtr, this);
    }

    public void performRaycast(btTriangleCallback callback, Vector3 raySource, Vector3 rayTarget) {
        CollisionJNI.btBvhTriangleMeshShape_performRaycast(this.swigCPtr, this, btTriangleCallback.getCPtr(callback), callback, raySource, rayTarget);
    }

    public void performConvexcast(btTriangleCallback callback, Vector3 boxSource, Vector3 boxTarget, Vector3 boxMin, Vector3 boxMax) {
        CollisionJNI.btBvhTriangleMeshShape_performConvexcast(this.swigCPtr, this, btTriangleCallback.getCPtr(callback), callback, boxSource, boxTarget, boxMin, boxMax);
    }

    public void refitTree(Vector3 aabbMin, Vector3 aabbMax) {
        CollisionJNI.btBvhTriangleMeshShape_refitTree(this.swigCPtr, this, aabbMin, aabbMax);
    }

    public void partialRefitTree(Vector3 aabbMin, Vector3 aabbMax) {
        CollisionJNI.btBvhTriangleMeshShape_partialRefitTree(this.swigCPtr, this, aabbMin, aabbMax);
    }

    public btOptimizedBvh getOptimizedBvh() {
        long cPtr = CollisionJNI.btBvhTriangleMeshShape_getOptimizedBvh(this.swigCPtr, this);
        return cPtr == 0L ? null : new btOptimizedBvh(cPtr, false);
    }

    public void setOptimizedBvh(btOptimizedBvh bvh, Vector3 localScaling) {
        CollisionJNI.btBvhTriangleMeshShape_setOptimizedBvh__SWIG_0(this.swigCPtr, this, btOptimizedBvh.getCPtr(bvh), bvh, localScaling);
    }

    public void setOptimizedBvh(btOptimizedBvh bvh) {
        CollisionJNI.btBvhTriangleMeshShape_setOptimizedBvh__SWIG_1(this.swigCPtr, this, btOptimizedBvh.getCPtr(bvh), bvh);
    }

    public void buildOptimizedBvh() {
        CollisionJNI.btBvhTriangleMeshShape_buildOptimizedBvh(this.swigCPtr, this);
    }

    public boolean usesQuantizedAabbCompression() {
        return CollisionJNI.btBvhTriangleMeshShape_usesQuantizedAabbCompression(this.swigCPtr, this);
    }

    public void setTriangleInfoMap(btTriangleInfoMap triangleInfoMap) {
        CollisionJNI.btBvhTriangleMeshShape_setTriangleInfoMap(this.swigCPtr, this, btTriangleInfoMap.getCPtr(triangleInfoMap), triangleInfoMap);
    }

    public btTriangleInfoMap getTriangleInfoMap() {
        long cPtr = CollisionJNI.btBvhTriangleMeshShape_getTriangleInfoMap__SWIG_0(this.swigCPtr, this);
        return cPtr == 0L ? null : new btTriangleInfoMap(cPtr, false);
    }

    public void serializeSingleBvh(btSerializer serializer) {
        CollisionJNI.btBvhTriangleMeshShape_serializeSingleBvh(this.swigCPtr, this, btSerializer.getCPtr(serializer), serializer);
    }

    public void serializeSingleTriangleInfoMap(btSerializer serializer) {
        CollisionJNI.btBvhTriangleMeshShape_serializeSingleTriangleInfoMap(this.swigCPtr, this, btSerializer.getCPtr(serializer), serializer);
    }

    private btBvhTriangleMeshShape(boolean dummy, btStridingMeshInterface meshInterface, boolean useQuantizedAabbCompression, boolean buildBvh) {
        this(CollisionJNI.new_btBvhTriangleMeshShape__SWIG_0(dummy, btStridingMeshInterface.getCPtr(meshInterface), meshInterface, useQuantizedAabbCompression, buildBvh), true);
    }

    private btBvhTriangleMeshShape(boolean dummy, btStridingMeshInterface meshInterface, boolean useQuantizedAabbCompression) {
        this(CollisionJNI.new_btBvhTriangleMeshShape__SWIG_1(dummy, btStridingMeshInterface.getCPtr(meshInterface), meshInterface, useQuantizedAabbCompression), true);
    }

    private btBvhTriangleMeshShape(boolean dummy, btStridingMeshInterface meshInterface, boolean useQuantizedAabbCompression, Vector3 bvhAabbMin, Vector3 bvhAabbMax, boolean buildBvh) {
        this(CollisionJNI.new_btBvhTriangleMeshShape__SWIG_2(dummy, btStridingMeshInterface.getCPtr(meshInterface), meshInterface, useQuantizedAabbCompression, bvhAabbMin, bvhAabbMax, buildBvh), true);
    }

    private btBvhTriangleMeshShape(boolean dummy, btStridingMeshInterface meshInterface, boolean useQuantizedAabbCompression, Vector3 bvhAabbMin, Vector3 bvhAabbMax) {
        this(CollisionJNI.new_btBvhTriangleMeshShape__SWIG_3(dummy, btStridingMeshInterface.getCPtr(meshInterface), meshInterface, useQuantizedAabbCompression, bvhAabbMin, bvhAabbMax), true);
    }
}

