/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class btIndexedMesh
extends BulletBase {
    private long swigCPtr;
    protected static final Array<btIndexedMesh> instances = new Array();
    public Object tag;

    protected btIndexedMesh(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btIndexedMesh(long cPtr, boolean cMemoryOwn) {
        this("btIndexedMesh", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(btIndexedMesh obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_btIndexedMesh(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    protected static btIndexedMesh getInstance(Object tag) {
        int n = btIndexedMesh.instances.size;
        for (int i = 0; i < n; ++i) {
            btIndexedMesh mesh = (btIndexedMesh)instances.get(i);
            if (!tag.equals(mesh.tag)) continue;
            return mesh;
        }
        return null;
    }

    public static btIndexedMesh obtain(MeshPart meshPart) {
        if (meshPart == null) {
            throw new GdxRuntimeException("meshPart cannot be null");
        }
        btIndexedMesh result = btIndexedMesh.getInstance(meshPart);
        if (result == null) {
            result = new btIndexedMesh(meshPart);
            instances.add((Object)result);
        }
        result.obtain();
        return result;
    }

    public static btIndexedMesh obtain(Object tag, FloatBuffer vertices, int sizeInBytesOfEachVertex, int vertexCount, int positionOffsetInBytes, ShortBuffer indices, int indexOffset, int indexCount) {
        if (tag == null) {
            throw new GdxRuntimeException("tag cannot be null");
        }
        btIndexedMesh result = btIndexedMesh.getInstance(tag);
        if (result == null) {
            result = new btIndexedMesh(vertices, sizeInBytesOfEachVertex, vertexCount, positionOffsetInBytes, indices, indexOffset, indexCount);
            result.tag = tag;
            instances.add((Object)result);
        }
        result.obtain();
        return result;
    }

    public btIndexedMesh(Mesh mesh) {
        this();
        this.set(mesh);
    }

    public btIndexedMesh(MeshPart meshPart) {
        this();
        this.set(meshPart);
    }

    public btIndexedMesh(Mesh mesh, int offset, int count) {
        this();
        this.set(mesh, offset, count);
    }

    public btIndexedMesh(FloatBuffer vertices, int sizeInBytesOfEachVertex, int vertexCount, int positionOffsetInBytes, ShortBuffer indices, int indexOffset, int indexCount) {
        this();
        this.set(vertices, sizeInBytesOfEachVertex, vertexCount, positionOffsetInBytes, indices, indexOffset, indexCount);
    }

    public void set(Mesh mesh) {
        this.set(mesh, mesh, 0, mesh.getNumIndices());
    }

    public void set(Object tag, Mesh mesh) {
        this.set(tag, mesh, 0, mesh.getNumIndices());
    }

    public void set(MeshPart meshPart) {
        if (meshPart.primitiveType != 4) {
            throw new GdxRuntimeException("Mesh must be indexed and triangulated");
        }
        this.set(meshPart, meshPart.mesh, meshPart.offset, meshPart.size);
    }

    public void set(Mesh mesh, int offset, int count) {
        this.set(null, mesh, offset, count);
    }

    public void set(Object tag, Mesh mesh, int offset, int count) {
        if (count <= 0 || count % 3 != 0) {
            throw new GdxRuntimeException("Mesh must be indexed and triangulated");
        }
        VertexAttribute posAttr = mesh.getVertexAttribute(1);
        if (posAttr == null) {
            throw new GdxRuntimeException("Mesh doesn't have a position attribute");
        }
        this.set(tag, mesh.getVerticesBuffer(false), mesh.getVertexSize(), mesh.getNumVertices(), posAttr.offset, mesh.getIndicesBuffer(false), offset, count);
    }

    public void set(FloatBuffer vertices, int sizeInBytesOfEachVertex, int vertexCount, int positionOffsetInBytes, ShortBuffer indices, int indexOffset, int indexCount) {
        this.set(null, vertices, sizeInBytesOfEachVertex, vertexCount, positionOffsetInBytes, indices, indexOffset, indexCount);
    }

    public void set(Object tag, FloatBuffer vertices, int sizeInBytesOfEachVertex, int vertexCount, int positionOffsetInBytes, ShortBuffer indices, int indexOffset, int indexCount) {
        this.setVertices(vertices, sizeInBytesOfEachVertex, vertexCount, positionOffsetInBytes);
        this.setIndices(indices, indexOffset, indexCount);
        this.tag = tag;
    }

    public long operatorNew(long sizeInBytes) {
        return CollisionJNI.btIndexedMesh_operatorNew__SWIG_0(this.swigCPtr, this, sizeInBytes);
    }

    public void operatorDelete(long ptr) {
        CollisionJNI.btIndexedMesh_operatorDelete__SWIG_0(this.swigCPtr, this, ptr);
    }

    public long operatorNew(long arg0, long ptr) {
        return CollisionJNI.btIndexedMesh_operatorNew__SWIG_1(this.swigCPtr, this, arg0, ptr);
    }

    public void operatorDelete(long arg0, long arg1) {
        CollisionJNI.btIndexedMesh_operatorDelete__SWIG_1(this.swigCPtr, this, arg0, arg1);
    }

    public long operatorNewArray(long sizeInBytes) {
        return CollisionJNI.btIndexedMesh_operatorNewArray__SWIG_0(this.swigCPtr, this, sizeInBytes);
    }

    public void operatorDeleteArray(long ptr) {
        CollisionJNI.btIndexedMesh_operatorDeleteArray__SWIG_0(this.swigCPtr, this, ptr);
    }

    public long operatorNewArray(long arg0, long ptr) {
        return CollisionJNI.btIndexedMesh_operatorNewArray__SWIG_1(this.swigCPtr, this, arg0, ptr);
    }

    public void operatorDeleteArray(long arg0, long arg1) {
        CollisionJNI.btIndexedMesh_operatorDeleteArray__SWIG_1(this.swigCPtr, this, arg0, arg1);
    }

    public void setNumTriangles(int value) {
        CollisionJNI.btIndexedMesh_numTriangles_set(this.swigCPtr, this, value);
    }

    public int getNumTriangles() {
        return CollisionJNI.btIndexedMesh_numTriangles_get(this.swigCPtr, this);
    }

    public void setTriangleIndexBase(ByteBuffer value) {
        assert (value.isDirect()) : "Buffer must be allocated direct.";
        CollisionJNI.btIndexedMesh_triangleIndexBase_set(this.swigCPtr, this, value);
    }

    public ByteBuffer getTriangleIndexBase() {
        return CollisionJNI.btIndexedMesh_triangleIndexBase_get(this.swigCPtr, this);
    }

    public void setTriangleIndexStride(int value) {
        CollisionJNI.btIndexedMesh_triangleIndexStride_set(this.swigCPtr, this, value);
    }

    public int getTriangleIndexStride() {
        return CollisionJNI.btIndexedMesh_triangleIndexStride_get(this.swigCPtr, this);
    }

    public void setNumVertices(int value) {
        CollisionJNI.btIndexedMesh_numVertices_set(this.swigCPtr, this, value);
    }

    public int getNumVertices() {
        return CollisionJNI.btIndexedMesh_numVertices_get(this.swigCPtr, this);
    }

    public void setVertexBase(ByteBuffer value) {
        assert (value.isDirect()) : "Buffer must be allocated direct.";
        CollisionJNI.btIndexedMesh_vertexBase_set(this.swigCPtr, this, value);
    }

    public ByteBuffer getVertexBase() {
        return CollisionJNI.btIndexedMesh_vertexBase_get(this.swigCPtr, this);
    }

    public void setVertexStride(int value) {
        CollisionJNI.btIndexedMesh_vertexStride_set(this.swigCPtr, this, value);
    }

    public int getVertexStride() {
        return CollisionJNI.btIndexedMesh_vertexStride_get(this.swigCPtr, this);
    }

    public void setIndexType(int value) {
        CollisionJNI.btIndexedMesh_indexType_set(this.swigCPtr, this, value);
    }

    public int getIndexType() {
        return CollisionJNI.btIndexedMesh_indexType_get(this.swigCPtr, this);
    }

    public void setVertexType(int value) {
        CollisionJNI.btIndexedMesh_vertexType_set(this.swigCPtr, this, value);
    }

    public int getVertexType() {
        return CollisionJNI.btIndexedMesh_vertexType_get(this.swigCPtr, this);
    }

    public btIndexedMesh() {
        this(CollisionJNI.new_btIndexedMesh(), true);
    }

    public void setTriangleIndexBase(ShortBuffer data) {
        assert (data.isDirect()) : "Buffer must be allocated direct.";
        CollisionJNI.btIndexedMesh_setTriangleIndexBase(this.swigCPtr, this, data);
    }

    public void setVertexBase(FloatBuffer data) {
        assert (data.isDirect()) : "Buffer must be allocated direct.";
        CollisionJNI.btIndexedMesh_setVertexBase(this.swigCPtr, this, data);
    }

    public void setVertices(FloatBuffer vertices, int sizeInBytesOfEachVertex, int vertexCount, int positionOffsetInBytes) {
        assert (vertices.isDirect()) : "Buffer must be allocated direct.";
        CollisionJNI.btIndexedMesh_setVertices(this.swigCPtr, this, vertices, sizeInBytesOfEachVertex, vertexCount, positionOffsetInBytes);
    }

    public void setIndices(ShortBuffer indices, int indexOffset, int indexCount) {
        assert (indices.isDirect()) : "Buffer must be allocated direct.";
        CollisionJNI.btIndexedMesh_setIndices(this.swigCPtr, this, indices, indexOffset, indexCount);
    }
}

