/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.physics.bullet.collision.btCollisionObject;
import com.badlogic.gdx.physics.bullet.collision.btManifoldPoint;
import com.badlogic.gdx.physics.bullet.linearmath.btTypedObject;

public class btPersistentManifold
extends btTypedObject {
    private long swigCPtr;

    protected btPersistentManifold(String className, long cPtr, boolean cMemoryOwn) {
        super(className, CollisionJNI.btPersistentManifold_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btPersistentManifold(long cPtr, boolean cMemoryOwn) {
        this("btPersistentManifold", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(CollisionJNI.btPersistentManifold_SWIGUpcast(this.swigCPtr), cMemoryOwn);
    }

    public static long getCPtr(btPersistentManifold obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_btPersistentManifold(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public long operatorNew(long sizeInBytes) {
        return CollisionJNI.btPersistentManifold_operatorNew__SWIG_0(this.swigCPtr, this, sizeInBytes);
    }

    public void operatorDelete(long ptr) {
        CollisionJNI.btPersistentManifold_operatorDelete__SWIG_0(this.swigCPtr, this, ptr);
    }

    public long operatorNew(long arg0, long ptr) {
        return CollisionJNI.btPersistentManifold_operatorNew__SWIG_1(this.swigCPtr, this, arg0, ptr);
    }

    public void operatorDelete(long arg0, long arg1) {
        CollisionJNI.btPersistentManifold_operatorDelete__SWIG_1(this.swigCPtr, this, arg0, arg1);
    }

    public long operatorNewArray(long sizeInBytes) {
        return CollisionJNI.btPersistentManifold_operatorNewArray__SWIG_0(this.swigCPtr, this, sizeInBytes);
    }

    public void operatorDeleteArray(long ptr) {
        CollisionJNI.btPersistentManifold_operatorDeleteArray__SWIG_0(this.swigCPtr, this, ptr);
    }

    public long operatorNewArray(long arg0, long ptr) {
        return CollisionJNI.btPersistentManifold_operatorNewArray__SWIG_1(this.swigCPtr, this, arg0, ptr);
    }

    public void operatorDeleteArray(long arg0, long arg1) {
        CollisionJNI.btPersistentManifold_operatorDeleteArray__SWIG_1(this.swigCPtr, this, arg0, arg1);
    }

    public void setCompanionIdA(int value) {
        CollisionJNI.btPersistentManifold_companionIdA_set(this.swigCPtr, this, value);
    }

    public int getCompanionIdA() {
        return CollisionJNI.btPersistentManifold_companionIdA_get(this.swigCPtr, this);
    }

    public void setCompanionIdB(int value) {
        CollisionJNI.btPersistentManifold_companionIdB_set(this.swigCPtr, this, value);
    }

    public int getCompanionIdB() {
        return CollisionJNI.btPersistentManifold_companionIdB_get(this.swigCPtr, this);
    }

    public void setIndex1a(int value) {
        CollisionJNI.btPersistentManifold_index1a_set(this.swigCPtr, this, value);
    }

    public int getIndex1a() {
        return CollisionJNI.btPersistentManifold_index1a_get(this.swigCPtr, this);
    }

    public btPersistentManifold() {
        this(CollisionJNI.new_btPersistentManifold__SWIG_0(), true);
    }

    public btPersistentManifold(btCollisionObject body0, btCollisionObject body1, int arg2, float contactBreakingThreshold, float contactProcessingThreshold) {
        this(CollisionJNI.new_btPersistentManifold__SWIG_1(btCollisionObject.getCPtr(body0), body0, btCollisionObject.getCPtr(body1), body1, arg2, contactBreakingThreshold, contactProcessingThreshold), true);
    }

    public btCollisionObject getBody0() {
        return btCollisionObject.getInstance(CollisionJNI.btPersistentManifold_getBody0(this.swigCPtr, this), false);
    }

    public btCollisionObject getBody1() {
        return btCollisionObject.getInstance(CollisionJNI.btPersistentManifold_getBody1(this.swigCPtr, this), false);
    }

    public void setBodies(btCollisionObject body0, btCollisionObject body1) {
        CollisionJNI.btPersistentManifold_setBodies(this.swigCPtr, this, btCollisionObject.getCPtr(body0), body0, btCollisionObject.getCPtr(body1), body1);
    }

    public void clearUserCache(btManifoldPoint pt) {
        CollisionJNI.btPersistentManifold_clearUserCache(this.swigCPtr, this, btManifoldPoint.getCPtr(pt), pt);
    }

    public int getNumContacts() {
        return CollisionJNI.btPersistentManifold_getNumContacts(this.swigCPtr, this);
    }

    public void setNumContacts(int cachedPoints) {
        CollisionJNI.btPersistentManifold_setNumContacts(this.swigCPtr, this, cachedPoints);
    }

    public btManifoldPoint getContactPointConst(int index) {
        return new btManifoldPoint(CollisionJNI.btPersistentManifold_getContactPointConst(this.swigCPtr, this, index), false);
    }

    public btManifoldPoint getContactPoint(int index) {
        return new btManifoldPoint(CollisionJNI.btPersistentManifold_getContactPoint(this.swigCPtr, this, index), false);
    }

    public float getContactBreakingThreshold() {
        return CollisionJNI.btPersistentManifold_getContactBreakingThreshold(this.swigCPtr, this);
    }

    public float getContactProcessingThreshold() {
        return CollisionJNI.btPersistentManifold_getContactProcessingThreshold(this.swigCPtr, this);
    }

    public void setContactBreakingThreshold(float contactBreakingThreshold) {
        CollisionJNI.btPersistentManifold_setContactBreakingThreshold(this.swigCPtr, this, contactBreakingThreshold);
    }

    public void setContactProcessingThreshold(float contactProcessingThreshold) {
        CollisionJNI.btPersistentManifold_setContactProcessingThreshold(this.swigCPtr, this, contactProcessingThreshold);
    }

    public int getCacheEntry(btManifoldPoint newPoint) {
        return CollisionJNI.btPersistentManifold_getCacheEntry(this.swigCPtr, this, btManifoldPoint.getCPtr(newPoint), newPoint);
    }

    public int addManifoldPoint(btManifoldPoint newPoint, boolean isPredictive) {
        return CollisionJNI.btPersistentManifold_addManifoldPoint__SWIG_0(this.swigCPtr, this, btManifoldPoint.getCPtr(newPoint), newPoint, isPredictive);
    }

    public int addManifoldPoint(btManifoldPoint newPoint) {
        return CollisionJNI.btPersistentManifold_addManifoldPoint__SWIG_1(this.swigCPtr, this, btManifoldPoint.getCPtr(newPoint), newPoint);
    }

    public void removeContactPoint(int index) {
        CollisionJNI.btPersistentManifold_removeContactPoint(this.swigCPtr, this, index);
    }

    public void replaceContactPoint(btManifoldPoint newPoint, int insertIndex) {
        CollisionJNI.btPersistentManifold_replaceContactPoint(this.swigCPtr, this, btManifoldPoint.getCPtr(newPoint), newPoint, insertIndex);
    }

    public boolean validContactDistance(btManifoldPoint pt) {
        return CollisionJNI.btPersistentManifold_validContactDistance(this.swigCPtr, this, btManifoldPoint.getCPtr(pt), pt);
    }

    public void refreshContactPoints(Matrix4 trA, Matrix4 trB) {
        CollisionJNI.btPersistentManifold_refreshContactPoints(this.swigCPtr, this, trA, trB);
    }

    public void clearManifold() {
        CollisionJNI.btPersistentManifold_clearManifold(this.swigCPtr, this);
    }
}

