/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.11
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */


#ifndef SWIGJAVA
#define SWIGJAVA
#endif

#define SWIG_DIRECTORS


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/* -----------------------------------------------------------------------------
 * director_common.swg
 *
 * This file contains support for director classes which is common between
 * languages.
 * ----------------------------------------------------------------------------- */

/*
  Use -DSWIG_DIRECTOR_STATIC if you prefer to avoid the use of the
  'Swig' namespace. This could be useful for multi-modules projects.
*/
#ifdef SWIG_DIRECTOR_STATIC
/* Force anonymous (static) namespace */
#define Swig
#endif
/* -----------------------------------------------------------------------------
 * director.swg
 *
 * This file contains support for director classes so that Java proxy
 * methods can be called from C++.
 * ----------------------------------------------------------------------------- */

#if defined(DEBUG_DIRECTOR_OWNED) || defined(DEBUG_DIRECTOR_EXCEPTION)
#include <iostream>
#endif

#include <exception>

namespace Swig {

  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(NULL), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = NULL;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (!jthis_) {
        weak_global_ = !mem_own; // hold as weak global if explicitly requested or not owned
        if (jobj)
          jthis_ = weak_global_ ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, NULL) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = NULL;
      weak_global_ = true;
    }

    /* Only call peek if you know what you are doing wrt to weak/global references */
    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else {
	/* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

  /* Local JNI reference deleter */
  class LocalRefGuard {
    JNIEnv *jenv_;
    jobject jobj_;

    // non-copyable
    LocalRefGuard(const LocalRefGuard &);
    LocalRefGuard &operator=(const LocalRefGuard &);
  public:
    LocalRefGuard(JNIEnv *jenv, jobject jobj): jenv_(jenv), jobj_(jobj) {}
    ~LocalRefGuard() {
      if (jobj_)
        jenv_->DeleteLocalRef(jobj_);
    }
  };

  /* director base class */
  class Director {
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
#if defined (_MSC_VER) && (_MSC_VER<1300)
    class JNIEnvWrapper;
    friend class JNIEnvWrapper;
#endif
    /* Utility class for managing the JNI environment */
    class JNIEnvWrapper {
      const Director *director_;
      JNIEnv *jenv_;
      int env_status;
    public:
      JNIEnvWrapper(const Director *director) : director_(director), jenv_(0), env_status(0) {
#if defined(__ANDROID__)
        JNIEnv **jenv = &jenv_;
#else
        void **jenv = (void **)&jenv_;
#endif
        env_status = director_->swig_jvm_->GetEnv((void **)&jenv_, JNI_VERSION_1_2);
#if defined(SWIG_JAVA_ATTACH_CURRENT_THREAD_AS_DAEMON)
        // Attach a daemon thread to the JVM. Useful when the JVM should not wait for
        // the thread to exit upon shutdown. Only for jdk-1.4 and later.
        director_->swig_jvm_->AttachCurrentThreadAsDaemon(jenv, NULL);
#else
        director_->swig_jvm_->AttachCurrentThread(jenv, NULL);
#endif
      }
      ~JNIEnvWrapper() {
#if !defined(SWIG_JAVA_NO_DETACH_CURRENT_THREAD)
        // Some JVMs, eg jdk-1.4.2 and lower on Solaris have a bug and crash with the DetachCurrentThread call.
        // However, without this call, the JVM hangs on exit when the thread was not created by the JVM and creates a memory leak.
        if (env_status == JNI_EDETACHED)
          director_->swig_jvm_->DetachCurrentThread();
#endif
      }
      JNIEnv *getJNIEnv() const {
        return jenv_;
      }
    };

    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      jobject jobj = swig_self_.get(jenv);
      LocalRefGuard ref_deleter(jenv, jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) NULL), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      swig_self_.release(jenv);
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };

  // Zero initialized bool array
  template<size_t N> class BoolArray {
    bool array_[N];
  public:
    BoolArray() {
      memset(array_, 0, sizeof(array_));
    }
    bool& operator[](size_t n) {
      return array_[n];
    }
    bool operator[](size_t n) const {
      return array_[n];
    }
  };

  // Utility classes and functions for exception handling.

  // Simple holder for a Java string during exception handling, providing access to a c-style string
  class JavaString {
  public:
    JavaString(JNIEnv *jenv, jstring jstr) : jenv_(jenv), jstr_(jstr), cstr_(0) {
      if (jenv_ && jstr_)
	cstr_ = (const char *) jenv_->GetStringUTFChars(jstr_, NULL);
    }

    ~JavaString() {
      if (jenv_ && jstr_ && cstr_)
	jenv_->ReleaseStringUTFChars(jstr_, cstr_);
    }

    const char *c_str(const char *null_string = "null JavaString") const {
      return cstr_ ? cstr_ : null_string;
    }

  private:
    // non-copyable
    JavaString(const JavaString &);
    JavaString &operator=(const JavaString &);

    JNIEnv *jenv_;
    jstring jstr_;
    const char *cstr_;
  };

  // Helper class to extract the exception message from a Java throwable
  class JavaExceptionMessage {
  public:
    JavaExceptionMessage(JNIEnv *jenv, jthrowable throwable) : message_(jenv, exceptionMessageFromThrowable(jenv, throwable)) {
    }

    const char *message() const {
      return message_.c_str("Could not get exception message in JavaExceptionMessage");
    }

  private:
    // non-copyable
    JavaExceptionMessage(const JavaExceptionMessage &);
    JavaExceptionMessage &operator=(const JavaExceptionMessage &);

    // Get exception message by calling Java method Throwable.getMessage()
    static jstring exceptionMessageFromThrowable(JNIEnv *jenv, jthrowable throwable) {
      jstring jmsg = NULL;
      if (jenv && throwable) {
	jenv->ExceptionClear(); // Cannot invoke methods with any pending exceptions
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  // All Throwable classes have a getMessage() method, so call it to extract the exception message
	  jmethodID getMessageMethodID = jenv->GetMethodID(throwclz, "getMessage", "()Ljava/lang/String;");
	  if (getMessageMethodID)
	    jmsg = (jstring)jenv->CallObjectMethod(throwable, getMessageMethodID);
	}
	if (jmsg == NULL && jenv->ExceptionCheck())
	  jenv->ExceptionClear();
      }
      return jmsg;
    }

    JavaString message_;
  };

  // C++ Exception class for handling Java exceptions thrown during a director method Java upcall
  class DirectorException : public std::exception {
  public:

    // Construct exception from a Java throwable
    DirectorException(JNIEnv *jenv, jthrowable throwable) : classname_(0), msg_(0) {

      // Call Java method Object.getClass().getName() to obtain the throwable's class name (delimited by '/')
      if (throwable) {
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  jclass clzclz = jenv->GetObjectClass(throwclz);
	  if (clzclz) {
	    jmethodID getNameMethodID = jenv->GetMethodID(clzclz, "getName", "()Ljava/lang/String;");
	    if (getNameMethodID) {
	      jstring jstr_classname = (jstring)(jenv->CallObjectMethod(throwclz, getNameMethodID));
              // Copy strings, since there is no guarantee that jenv will be active when handled
              if (jstr_classname) {
                JavaString jsclassname(jenv, jstr_classname);
                const char *classname = jsclassname.c_str(0);
                if (classname)
                  classname_ = copypath(classname);
              }
	    }
	  }
	}
      }

      JavaExceptionMessage exceptionmsg(jenv, throwable);
      msg_ = copystr(exceptionmsg.message());
    }

    // More general constructor for handling as a java.lang.RuntimeException
    DirectorException(const char *msg) : classname_(0), msg_(copystr(msg ? msg : "Unspecified DirectorException message")) {
    }

    ~DirectorException() throw() {
      delete[] classname_;
      delete[] msg_;
    }

    const char *what() const throw() {
      return msg_;
    }

    // Reconstruct and raise/throw the Java Exception that caused the DirectorException
    // Note that any error in the JNI exception handling results in a Java RuntimeException
    void raiseJavaException(JNIEnv *jenv) const {
      if (jenv) {
	jenv->ExceptionClear();

	jmethodID ctorMethodID = 0;
	jclass throwableclass = 0;
        if (classname_) {
          throwableclass = jenv->FindClass(classname_);
          if (throwableclass)
            ctorMethodID = jenv->GetMethodID(throwableclass, "<init>", "(Ljava/lang/String;)V");
	}

	if (ctorMethodID) {
	  jenv->ThrowNew(throwableclass, what());
	} else {
	  SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, what());
	}
      }
    }

  private:
    static char *copypath(const char *srcmsg) {
      char *target = copystr(srcmsg);
      for (char *c=target; *c; ++c) {
        if ('.' == *c)
          *c = '/';
      }
      return target;
    }

    static char *copystr(const char *srcmsg) {
      char *target = 0;
      if (srcmsg) {
	size_t msglen = strlen(srcmsg) + 1;
	target = new char[msglen];
	strncpy(target, srcmsg, msglen);
      }
      return target;
    }

    const char *classname_;
    const char *msg_;
  };

  // Helper method to determine if a Java throwable matches a particular Java class type
  SWIGINTERN inline bool ExceptionMatches(JNIEnv *jenv, jthrowable throwable, const char *classname) {
    bool matches = false;

    if (throwable && jenv && classname) {
      // Exceptions need to be cleared for correct behavior.
      // The caller of ExceptionMatches should restore pending exceptions if desired -
      // the caller already has the throwable.
      jenv->ExceptionClear();

      jclass clz = jenv->FindClass(classname);
      if (clz) {
	jclass classclz = jenv->GetObjectClass(clz);
	jmethodID isInstanceMethodID = jenv->GetMethodID(classclz, "isInstance", "(Ljava/lang/Object;)Z");
	if (isInstanceMethodID) {
	  matches = jenv->CallBooleanMethod(clz, isInstanceMethodID, throwable) != 0;
	}
      }

#if defined(DEBUG_DIRECTOR_EXCEPTION)
      if (jenv->ExceptionCheck()) {
        // Typically occurs when an invalid classname argument is passed resulting in a ClassNotFoundException
        JavaExceptionMessage exc(jenv, jenv->ExceptionOccurred());
        std::cout << "Error: ExceptionMatches: class '" << classname << "' : " << exc.message() << std::endl;
      }
#endif
    }
    return matches;
  }
}


#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new jlong[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif


#include <gdx/common/jniHelpers.h>


#include <stdint.h>


#include <gdx/linearmath/mathtypes.h>
#include <LinearMath/btVector3.h>
#include <LinearMath/btQuaternion.h>
#include <LinearMath/btMatrix3x3.h>
#include <LinearMath/btTransform.h>


#include <BulletCollision/CollisionDispatch/btCollisionWorld.h>
typedef btCollisionWorld::RayResultCallback RayResultCallback;


#include <BulletSoftBody/btSoftBodySolvers.h>


#include <BulletSoftBody/btDefaultSoftBodySolver.h>


#include <BulletSoftBody/btSparseSDF.h>



	/* Gets a global ref to the temp class.  Do not release this. */
	SWIGINTERN inline jclass gdx_getTempClassVector3(JNIEnv * jenv) {
	  static jclass cls = NULL;
	  if (cls == NULL) {
		cls = (jclass) jenv->NewGlobalRef(jenv->FindClass("com/badlogic/gdx/physics/bullet/linearmath/LinearMath"));
	  }
	  return cls;
	}
	
	SWIGINTERN inline jobject gdx_takePoolObjectVector3(JNIEnv * jenv, const char * poolName) {
	  jclass tempClass = gdx_getTempClassVector3(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID obtainMethod = NULL;
	  if (obtainMethod == NULL) {
		obtainMethod = (jmethodID) jenv->GetMethodID(poolClass, "obtain", "()Ljava/lang/Object;");
	  }
	  
	  jobject ret = jenv->CallObjectMethod(poolObject, obtainMethod);
	
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	
	  return ret;
	}
	
	SWIGINTERN inline void gdx_releasePoolObjectVector3(JNIEnv * jenv, const char * poolName, jobject obj) {
	  jclass tempClass = gdx_getTempClassVector3(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID freeMethod = NULL;
	  if (freeMethod == NULL) {
		freeMethod = (jmethodID) jenv->GetMethodID(poolClass, "free", "(Ljava/lang/Object;)V");
	  }
	  
	  jenv->CallVoidMethod(poolObject, freeMethod, obj);
	  
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	  jenv->DeleteLocalRef(obj);
	}
	
	/*
	 * A simple RAII wrapper to release jobjects we obtain from pools in 
	 * directorin typemaps.  SWIG doesn't have hooks to release them after
	 * they're used. 
	 */
	class gdxPoolAutoReleaseVector3 {
	private:
	  JNIEnv * jenv;
	  const char * poolName;
	  jobject obj;
	public:
	  gdxPoolAutoReleaseVector3(JNIEnv * jenv, const char * poolName, jobject obj) : 
		jenv(jenv), poolName(poolName), obj(obj) { };
	  virtual ~gdxPoolAutoReleaseVector3() {
		gdx_releasePoolObjectVector3(this->jenv, this->poolName, this->obj);
	  };
	};


	
// Workaround for some strange swig behaviour


	/* Gets a global ref to the temp class's Return Vector3.  Do not release this. */ 
	SWIGINTERN inline jobject gdx_getReturnVector3(JNIEnv * jenv) {
	  static jobject ret = NULL;
	  if (ret == NULL) {
	    jclass tempClass = gdx_getTempClassVector3(jenv);
	    jfieldID field = jenv->GetStaticFieldID(tempClass, "staticVector3", "Lcom/badlogic/gdx/math/Vector3;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(tempClass, field));
	  }
	  return ret;
	}
	
	/* Sets the data in the Bullet type from the Gdx type. */
	SWIGINTERN inline void gdx_setbtVector3FromVector3(JNIEnv * jenv, btVector3 & target, jobject source) {
		Vector3_to_btVector3(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setbtVector3FromVector3(JNIEnv * jenv, btVector3 * target, jobject source) {
		gdx_setbtVector3FromVector3(jenv, *target, source);
	}

	/* Sets the data in the Gdx type from the Bullet type. */
	SWIGINTERN inline void gdx_setVector3FrombtVector3(JNIEnv * jenv, jobject target, const btVector3 & source) {
		btVector3_to_Vector3(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setVector3FrombtVector3(JNIEnv * jenv, jobject target, const btVector3 * source) {
		gdx_setVector3FrombtVector3(jenv, target, *source);
	}

	/*
	 * RAII wrapper to commit changes made to a local btVector3 back to Vector3
	 */
	class gdxAutoCommitVector3 {
	private:
	  JNIEnv * jenv;
	  jobject jVector3;
	  btVector3 & cbtVector3;
	public:
	  gdxAutoCommitVector3(JNIEnv * jenv, jobject jVector3, btVector3 & cbtVector3) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(cbtVector3) { };
	  gdxAutoCommitVector3(JNIEnv * jenv, jobject jVector3, btVector3 * cbtVector3) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(*cbtVector3) { };
	  virtual ~gdxAutoCommitVector3() {
	    gdx_setVector3FrombtVector3(this->jenv, this->jVector3, this->cbtVector3);
	  };
	};

	class gdxAutoCommitbtVector3AndReleaseVector3 {
	private:
	  JNIEnv * jenv;
	  jobject jVector3;
	  btVector3 & cbtVector3;
	  const char * poolName;
	public:
	  gdxAutoCommitbtVector3AndReleaseVector3(JNIEnv * jenv, jobject jVector3, btVector3 & cbtVector3, const char *poolName) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(cbtVector3), poolName(poolName) { };
	  gdxAutoCommitbtVector3AndReleaseVector3(JNIEnv * jenv, jobject jVector3, btVector3 * cbtVector3, const char *poolName) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(*cbtVector3), poolName(poolName) { };
	  virtual ~gdxAutoCommitbtVector3AndReleaseVector3() {
	    gdx_setbtVector3FromVector3(this->jenv, this->cbtVector3, this->jVector3);
	    gdx_releasePoolObjectVector3(this->jenv, this->poolName, this->jVector3);
	  };
	};


#include <BulletSoftBody/btSoftBody.h>



	/* Gets a global ref to the temp class.  Do not release this. */
	SWIGINTERN inline jclass gdx_getTempClassMatrix3(JNIEnv * jenv) {
	  static jclass cls = NULL;
	  if (cls == NULL) {
		cls = (jclass) jenv->NewGlobalRef(jenv->FindClass("com/badlogic/gdx/physics/bullet/linearmath/LinearMath"));
	  }
	  return cls;
	}
	
	SWIGINTERN inline jobject gdx_takePoolObjectMatrix3(JNIEnv * jenv, const char * poolName) {
	  jclass tempClass = gdx_getTempClassMatrix3(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID obtainMethod = NULL;
	  if (obtainMethod == NULL) {
		obtainMethod = (jmethodID) jenv->GetMethodID(poolClass, "obtain", "()Ljava/lang/Object;");
	  }
	  
	  jobject ret = jenv->CallObjectMethod(poolObject, obtainMethod);
	
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	
	  return ret;
	}
	
	SWIGINTERN inline void gdx_releasePoolObjectMatrix3(JNIEnv * jenv, const char * poolName, jobject obj) {
	  jclass tempClass = gdx_getTempClassMatrix3(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID freeMethod = NULL;
	  if (freeMethod == NULL) {
		freeMethod = (jmethodID) jenv->GetMethodID(poolClass, "free", "(Ljava/lang/Object;)V");
	  }
	  
	  jenv->CallVoidMethod(poolObject, freeMethod, obj);
	  
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	  jenv->DeleteLocalRef(obj);
	}
	
	/*
	 * A simple RAII wrapper to release jobjects we obtain from pools in 
	 * directorin typemaps.  SWIG doesn't have hooks to release them after
	 * they're used. 
	 */
	class gdxPoolAutoReleaseMatrix3 {
	private:
	  JNIEnv * jenv;
	  const char * poolName;
	  jobject obj;
	public:
	  gdxPoolAutoReleaseMatrix3(JNIEnv * jenv, const char * poolName, jobject obj) : 
		jenv(jenv), poolName(poolName), obj(obj) { };
	  virtual ~gdxPoolAutoReleaseMatrix3() {
		gdx_releasePoolObjectMatrix3(this->jenv, this->poolName, this->obj);
	  };
	};


	
// Workaround for some strange swig behaviour


	/* Gets a global ref to the temp class's Return Matrix3.  Do not release this. */ 
	SWIGINTERN inline jobject gdx_getReturnMatrix3(JNIEnv * jenv) {
	  static jobject ret = NULL;
	  if (ret == NULL) {
	    jclass tempClass = gdx_getTempClassMatrix3(jenv);
	    jfieldID field = jenv->GetStaticFieldID(tempClass, "staticMatrix3", "Lcom/badlogic/gdx/math/Matrix3;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(tempClass, field));
	  }
	  return ret;
	}
	
	/* Sets the data in the Bullet type from the Gdx type. */
	SWIGINTERN inline void gdx_setbtMatrix3x3FromMatrix3(JNIEnv * jenv, btMatrix3x3 & target, jobject source) {
		Matrix3_to_btMatrix3(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setbtMatrix3x3FromMatrix3(JNIEnv * jenv, btMatrix3x3 * target, jobject source) {
		gdx_setbtMatrix3x3FromMatrix3(jenv, *target, source);
	}

	/* Sets the data in the Gdx type from the Bullet type. */
	SWIGINTERN inline void gdx_setMatrix3FrombtMatrix3x3(JNIEnv * jenv, jobject target, const btMatrix3x3 & source) {
		btMatrix3_to_Matrix3(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setMatrix3FrombtMatrix3x3(JNIEnv * jenv, jobject target, const btMatrix3x3 * source) {
		gdx_setMatrix3FrombtMatrix3x3(jenv, target, *source);
	}

	/*
	 * RAII wrapper to commit changes made to a local btMatrix3x3 back to Matrix3
	 */
	class gdxAutoCommitMatrix3 {
	private:
	  JNIEnv * jenv;
	  jobject jMatrix3;
	  btMatrix3x3 & cbtMatrix3x3;
	public:
	  gdxAutoCommitMatrix3(JNIEnv * jenv, jobject jMatrix3, btMatrix3x3 & cbtMatrix3x3) : 
	    jenv(jenv), jMatrix3(jMatrix3), cbtMatrix3x3(cbtMatrix3x3) { };
	  gdxAutoCommitMatrix3(JNIEnv * jenv, jobject jMatrix3, btMatrix3x3 * cbtMatrix3x3) : 
	    jenv(jenv), jMatrix3(jMatrix3), cbtMatrix3x3(*cbtMatrix3x3) { };
	  virtual ~gdxAutoCommitMatrix3() {
	    gdx_setMatrix3FrombtMatrix3x3(this->jenv, this->jMatrix3, this->cbtMatrix3x3);
	  };
	};

	class gdxAutoCommitbtMatrix3x3AndReleaseMatrix3 {
	private:
	  JNIEnv * jenv;
	  jobject jMatrix3;
	  btMatrix3x3 & cbtMatrix3x3;
	  const char * poolName;
	public:
	  gdxAutoCommitbtMatrix3x3AndReleaseMatrix3(JNIEnv * jenv, jobject jMatrix3, btMatrix3x3 & cbtMatrix3x3, const char *poolName) : 
	    jenv(jenv), jMatrix3(jMatrix3), cbtMatrix3x3(cbtMatrix3x3), poolName(poolName) { };
	  gdxAutoCommitbtMatrix3x3AndReleaseMatrix3(JNIEnv * jenv, jobject jMatrix3, btMatrix3x3 * cbtMatrix3x3, const char *poolName) : 
	    jenv(jenv), jMatrix3(jMatrix3), cbtMatrix3x3(*cbtMatrix3x3), poolName(poolName) { };
	  virtual ~gdxAutoCommitbtMatrix3x3AndReleaseMatrix3() {
	    gdx_setbtMatrix3x3FromMatrix3(this->jenv, this->cbtMatrix3x3, this->jMatrix3);
	    gdx_releasePoolObjectMatrix3(this->jenv, this->poolName, this->jMatrix3);
	  };
	};



	/* Gets a global ref to the temp class.  Do not release this. */
	SWIGINTERN inline jclass gdx_getTempClassMatrix4(JNIEnv * jenv) {
	  static jclass cls = NULL;
	  if (cls == NULL) {
		cls = (jclass) jenv->NewGlobalRef(jenv->FindClass("com/badlogic/gdx/physics/bullet/linearmath/LinearMath"));
	  }
	  return cls;
	}
	
	SWIGINTERN inline jobject gdx_takePoolObjectMatrix4(JNIEnv * jenv, const char * poolName) {
	  jclass tempClass = gdx_getTempClassMatrix4(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID obtainMethod = NULL;
	  if (obtainMethod == NULL) {
		obtainMethod = (jmethodID) jenv->GetMethodID(poolClass, "obtain", "()Ljava/lang/Object;");
	  }
	  
	  jobject ret = jenv->CallObjectMethod(poolObject, obtainMethod);
	
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	
	  return ret;
	}
	
	SWIGINTERN inline void gdx_releasePoolObjectMatrix4(JNIEnv * jenv, const char * poolName, jobject obj) {
	  jclass tempClass = gdx_getTempClassMatrix4(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID freeMethod = NULL;
	  if (freeMethod == NULL) {
		freeMethod = (jmethodID) jenv->GetMethodID(poolClass, "free", "(Ljava/lang/Object;)V");
	  }
	  
	  jenv->CallVoidMethod(poolObject, freeMethod, obj);
	  
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	  jenv->DeleteLocalRef(obj);
	}
	
	/*
	 * A simple RAII wrapper to release jobjects we obtain from pools in 
	 * directorin typemaps.  SWIG doesn't have hooks to release them after
	 * they're used. 
	 */
	class gdxPoolAutoReleaseMatrix4 {
	private:
	  JNIEnv * jenv;
	  const char * poolName;
	  jobject obj;
	public:
	  gdxPoolAutoReleaseMatrix4(JNIEnv * jenv, const char * poolName, jobject obj) : 
		jenv(jenv), poolName(poolName), obj(obj) { };
	  virtual ~gdxPoolAutoReleaseMatrix4() {
		gdx_releasePoolObjectMatrix4(this->jenv, this->poolName, this->obj);
	  };
	};


	
// Workaround for some strange swig behaviour


	/* Gets a global ref to the temp class's Return Matrix4.  Do not release this. */ 
	SWIGINTERN inline jobject gdx_getReturnMatrix4(JNIEnv * jenv) {
	  static jobject ret = NULL;
	  if (ret == NULL) {
	    jclass tempClass = gdx_getTempClassMatrix4(jenv);
	    jfieldID field = jenv->GetStaticFieldID(tempClass, "staticMatrix4", "Lcom/badlogic/gdx/math/Matrix4;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(tempClass, field));
	  }
	  return ret;
	}
	
	/* Sets the data in the Bullet type from the Gdx type. */
	SWIGINTERN inline void gdx_setbtTransformFromMatrix4(JNIEnv * jenv, btTransform & target, jobject source) {
		Matrix4_to_btTransform(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setbtTransformFromMatrix4(JNIEnv * jenv, btTransform * target, jobject source) {
		gdx_setbtTransformFromMatrix4(jenv, *target, source);
	}

	/* Sets the data in the Gdx type from the Bullet type. */
	SWIGINTERN inline void gdx_setMatrix4FrombtTransform(JNIEnv * jenv, jobject target, const btTransform & source) {
		btTransform_to_Matrix4(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setMatrix4FrombtTransform(JNIEnv * jenv, jobject target, const btTransform * source) {
		gdx_setMatrix4FrombtTransform(jenv, target, *source);
	}

	/*
	 * RAII wrapper to commit changes made to a local btTransform back to Matrix4
	 */
	class gdxAutoCommitMatrix4 {
	private:
	  JNIEnv * jenv;
	  jobject jMatrix4;
	  btTransform & cbtTransform;
	public:
	  gdxAutoCommitMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform & cbtTransform) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(cbtTransform) { };
	  gdxAutoCommitMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform * cbtTransform) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(*cbtTransform) { };
	  virtual ~gdxAutoCommitMatrix4() {
	    gdx_setMatrix4FrombtTransform(this->jenv, this->jMatrix4, this->cbtTransform);
	  };
	};

	class gdxAutoCommitbtTransformAndReleaseMatrix4 {
	private:
	  JNIEnv * jenv;
	  jobject jMatrix4;
	  btTransform & cbtTransform;
	  const char * poolName;
	public:
	  gdxAutoCommitbtTransformAndReleaseMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform & cbtTransform, const char *poolName) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(cbtTransform), poolName(poolName) { };
	  gdxAutoCommitbtTransformAndReleaseMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform * cbtTransform, const char *poolName) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(*cbtTransform), poolName(poolName) { };
	  virtual ~gdxAutoCommitbtTransformAndReleaseMatrix4() {
	    gdx_setbtTransformFromMatrix4(this->jenv, this->cbtTransform, this->jMatrix4);
	    gdx_releasePoolObjectMatrix4(this->jenv, this->poolName, this->jMatrix4);
	  };
	};



	/* Gets a global ref to the temp class.  Do not release this. */
	SWIGINTERN inline jclass gdx_getTempClassQuaternion(JNIEnv * jenv) {
	  static jclass cls = NULL;
	  if (cls == NULL) {
		cls = (jclass) jenv->NewGlobalRef(jenv->FindClass("com/badlogic/gdx/physics/bullet/linearmath/LinearMath"));
	  }
	  return cls;
	}
	
	SWIGINTERN inline jobject gdx_takePoolObjectQuaternion(JNIEnv * jenv, const char * poolName) {
	  jclass tempClass = gdx_getTempClassQuaternion(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID obtainMethod = NULL;
	  if (obtainMethod == NULL) {
		obtainMethod = (jmethodID) jenv->GetMethodID(poolClass, "obtain", "()Ljava/lang/Object;");
	  }
	  
	  jobject ret = jenv->CallObjectMethod(poolObject, obtainMethod);
	
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	
	  return ret;
	}
	
	SWIGINTERN inline void gdx_releasePoolObjectQuaternion(JNIEnv * jenv, const char * poolName, jobject obj) {
	  jclass tempClass = gdx_getTempClassQuaternion(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID freeMethod = NULL;
	  if (freeMethod == NULL) {
		freeMethod = (jmethodID) jenv->GetMethodID(poolClass, "free", "(Ljava/lang/Object;)V");
	  }
	  
	  jenv->CallVoidMethod(poolObject, freeMethod, obj);
	  
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	  jenv->DeleteLocalRef(obj);
	}
	
	/*
	 * A simple RAII wrapper to release jobjects we obtain from pools in 
	 * directorin typemaps.  SWIG doesn't have hooks to release them after
	 * they're used. 
	 */
	class gdxPoolAutoReleaseQuaternion {
	private:
	  JNIEnv * jenv;
	  const char * poolName;
	  jobject obj;
	public:
	  gdxPoolAutoReleaseQuaternion(JNIEnv * jenv, const char * poolName, jobject obj) : 
		jenv(jenv), poolName(poolName), obj(obj) { };
	  virtual ~gdxPoolAutoReleaseQuaternion() {
		gdx_releasePoolObjectQuaternion(this->jenv, this->poolName, this->obj);
	  };
	};


	
// Workaround for some strange swig behaviour


	/* Gets a global ref to the temp class's Return Quaternion.  Do not release this. */ 
	SWIGINTERN inline jobject gdx_getReturnQuaternion(JNIEnv * jenv) {
	  static jobject ret = NULL;
	  if (ret == NULL) {
	    jclass tempClass = gdx_getTempClassQuaternion(jenv);
	    jfieldID field = jenv->GetStaticFieldID(tempClass, "staticQuaternion", "Lcom/badlogic/gdx/math/Quaternion;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(tempClass, field));
	  }
	  return ret;
	}
	
	/* Sets the data in the Bullet type from the Gdx type. */
	SWIGINTERN inline void gdx_setbtQuaternionFromQuaternion(JNIEnv * jenv, btQuaternion & target, jobject source) {
		Quaternion_to_btQuaternion(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setbtQuaternionFromQuaternion(JNIEnv * jenv, btQuaternion * target, jobject source) {
		gdx_setbtQuaternionFromQuaternion(jenv, *target, source);
	}

	/* Sets the data in the Gdx type from the Bullet type. */
	SWIGINTERN inline void gdx_setQuaternionFrombtQuaternion(JNIEnv * jenv, jobject target, const btQuaternion & source) {
		btQuaternion_to_Quaternion(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setQuaternionFrombtQuaternion(JNIEnv * jenv, jobject target, const btQuaternion * source) {
		gdx_setQuaternionFrombtQuaternion(jenv, target, *source);
	}

	/*
	 * RAII wrapper to commit changes made to a local btQuaternion back to Quaternion
	 */
	class gdxAutoCommitQuaternion {
	private:
	  JNIEnv * jenv;
	  jobject jQuaternion;
	  btQuaternion & cbtQuaternion;
	public:
	  gdxAutoCommitQuaternion(JNIEnv * jenv, jobject jQuaternion, btQuaternion & cbtQuaternion) : 
	    jenv(jenv), jQuaternion(jQuaternion), cbtQuaternion(cbtQuaternion) { };
	  gdxAutoCommitQuaternion(JNIEnv * jenv, jobject jQuaternion, btQuaternion * cbtQuaternion) : 
	    jenv(jenv), jQuaternion(jQuaternion), cbtQuaternion(*cbtQuaternion) { };
	  virtual ~gdxAutoCommitQuaternion() {
	    gdx_setQuaternionFrombtQuaternion(this->jenv, this->jQuaternion, this->cbtQuaternion);
	  };
	};

	class gdxAutoCommitbtQuaternionAndReleaseQuaternion {
	private:
	  JNIEnv * jenv;
	  jobject jQuaternion;
	  btQuaternion & cbtQuaternion;
	  const char * poolName;
	public:
	  gdxAutoCommitbtQuaternionAndReleaseQuaternion(JNIEnv * jenv, jobject jQuaternion, btQuaternion & cbtQuaternion, const char *poolName) : 
	    jenv(jenv), jQuaternion(jQuaternion), cbtQuaternion(cbtQuaternion), poolName(poolName) { };
	  gdxAutoCommitbtQuaternionAndReleaseQuaternion(JNIEnv * jenv, jobject jQuaternion, btQuaternion * cbtQuaternion, const char *poolName) : 
	    jenv(jenv), jQuaternion(jQuaternion), cbtQuaternion(*cbtQuaternion), poolName(poolName) { };
	  virtual ~gdxAutoCommitbtQuaternionAndReleaseQuaternion() {
	    gdx_setbtQuaternionFromQuaternion(this->jenv, this->cbtQuaternion, this->jQuaternion);
	    gdx_releasePoolObjectQuaternion(this->jenv, this->poolName, this->jQuaternion);
	  };
	};

SWIGINTERN btSoftBody *new_btSoftBody__SWIG_2(btSoftBodyWorldInfo *worldInfo,float *vertices,int vertexSize,int posOffset,int normalOffset,short *indices,int indexOffset,int numVertices,short *indexMap,int indexMapOffset){		
		int poffset = posOffset / sizeof(btScalar);
		int noffset = normalOffset / sizeof(btScalar);
		int size = vertexSize / sizeof(btScalar);
		btAlignedObjectArray<btVector3>	points;
		
		btSoftBody *result = new btSoftBody(worldInfo);
		btSoftBody::Material* pm = result->appendMaterial();
		pm->m_kLST = 1;
		pm->m_kAST = 1;
		pm->m_kVST = 1;
		pm->m_flags = btSoftBody::fMaterial::Default;
		
		const btScalar margin = result->getCollisionShape()->getMargin();
		int nodeCount = 0;
		result->m_nodes.resize(numVertices);
		for (int i = 0; i < numVertices; i++) {
			const float * const &verts = &vertices[indices[indexOffset+i]*size+poffset];
			btVector3 point(verts[0], verts[1], verts[2]);
			int idx = -1;
			for (int j = 0; j < nodeCount; j++) {
				if (result->m_nodes[j].m_x==point) {
					idx = j;
					break;
				}
			}
			if (idx < 0) {
				btSoftBody::Node &node = result->m_nodes[nodeCount];
				memset(&node,0,sizeof(btSoftBody::Node));
				node.m_x = point;
				node.m_q = node.m_x;
				node.m_im = 1;
				node.m_leaf = result->m_ndbvt.insert(btDbvtVolume::FromCR(node.m_x,margin),&node);
				node.m_material = pm;
				if (noffset >= 0) {
					node.m_n.m_floats[0] = vertices[indices[indexOffset+i]*size+noffset];
					node.m_n.m_floats[1] = vertices[indices[indexOffset+i]*size+noffset+1];
					node.m_n.m_floats[2] = vertices[indices[indexOffset+i]*size+noffset+2];
				}
				points.push_back(point);
				idx = nodeCount;
				nodeCount++;
			}
			indexMap[indexMapOffset+i] = (short)idx; 
		}
		result->m_nodes.resize(nodeCount);
		
		//const int vertexCount = points.size();
		//btSoftBody *result = new btSoftBody(worldInfo, vertexCount, &points[0], 0);
		
		btAlignedObjectArray<bool> chks;
		chks.resize(nodeCount * nodeCount, false);
		for(int i=0; i<numVertices; i+=3)
		{
			const int idx[]={indexMap[indexMapOffset+i],indexMap[indexMapOffset+i+1],indexMap[indexMapOffset+i+2]};

			for(int j=2,k=0;k<3;j=k++)
			{
				if(!chks[((idx[k])*nodeCount+(idx[j]))])
				{
					chks[((idx[k])*nodeCount+(idx[j]))]=true;
					chks[((idx[j])*nodeCount+(idx[k]))]=true;
					result->appendLink(idx[j],idx[k]);
				}
			}

			result->appendFace(idx[0],idx[1],idx[2]);
		}
		
		result->updateBounds();
		return result;
	}
SWIGINTERN int btSoftBody_getNodeCount(btSoftBody *self){
		return self->m_nodes.size();
	}
SWIGINTERN btSoftBody::Node *btSoftBody_getNode(btSoftBody *self,int idx){
		return &(self->m_nodes[idx]);
	}
SWIGINTERN int btSoftBody_getLinkCount(btSoftBody *self){
		return self->m_links.size();
	}
SWIGINTERN btSoftBody::Link *btSoftBody_getLink(btSoftBody *self,int idx){
		return &(self->m_links[idx]);
	}
SWIGINTERN void btSoftBody_getVertices__SWIG_0(btSoftBody *self,btScalar *buffer,int vertexCount,int vertexSize,int posOffset){
		int offset = posOffset / (sizeof(btScalar));
		int size = vertexSize / (sizeof(btScalar));
		for (int i = 0; i < vertexCount; i++) {
			const int o = i*size+offset;
			const float *src = self->m_nodes[i].m_x.m_floats;
			buffer[o] = src[0];
			buffer[o+1] = src[1];
			buffer[o+2] = src[2];
		}
	}
SWIGINTERN void btSoftBody_getVertices__SWIG_1(btSoftBody *self,float *vertices,int vertexSize,int posOffset,short *indices,int indexOffset,int numVertices,short *indexMap,int indexMapOffset){
		int poffset = posOffset / (sizeof(btScalar));
		int size = vertexSize / (sizeof(btScalar));
		for (int i = 0; i < numVertices; i++) {
			const int vidx = indices[indexOffset+i]*size+poffset;
			const int pidx = indexMap[indexMapOffset+i];
			const float * const &point = self->m_nodes[pidx].m_x.m_floats;
			vertices[vidx  ] = point[0];
			vertices[vidx+1] = point[1];
			vertices[vidx+2] = point[2];
		}
	}
SWIGINTERN void btSoftBody_getVertices__SWIG_2(btSoftBody *self,float *vertices,int vertexSize,int posOffset,int normalOffset,short *indices,int indexOffset,int numVertices,short *indexMap,int indexMapOffset){
		int poffset = posOffset / (sizeof(btScalar));
		int noffset = normalOffset / (sizeof(btScalar));
		int size = vertexSize / (sizeof(btScalar));
		for (int i = 0; i < numVertices; i++) {
			const int vidx = indices[indexOffset+i]*size+poffset;
			const int nidx = indices[indexOffset+i]*size+noffset;
			const int pidx = indexMap[indexMapOffset+i];
			const float * const &point = self->m_nodes[pidx].m_x.m_floats;
			const float * const &normal = self->m_nodes[pidx].m_n.m_floats;
			vertices[vidx  ] = point[0];
			vertices[vidx+1] = point[1];
			vertices[vidx+2] = point[2];
			vertices[nidx  ] = normal[0];
			vertices[nidx+1] = normal[1];
			vertices[nidx+2] = normal[2];
		}
	}
SWIGINTERN int btSoftBody_getFaceCount(btSoftBody *self){
		return self->m_faces.size();
	}
SWIGINTERN btSoftBody::Face *btSoftBody_getFace(btSoftBody *self,int idx){
		return &(self->m_faces[idx]);
	}
SWIGINTERN void btSoftBody_getIndices(btSoftBody *self,short *buffer,int triangleCount){
		const size_t nodeSize = sizeof(btSoftBody::Node);
		const intptr_t nodeOffset = (intptr_t)(&self->m_nodes[0]);
		for (int i = 0; i < triangleCount; i++) {
			const int idx = i * 3;
			buffer[idx] = ((intptr_t)(self->m_faces[i].m_n[0]) - nodeOffset) / nodeSize;
			buffer[idx+1] = ((intptr_t)(self->m_faces[i].m_n[1]) - nodeOffset) / nodeSize;
			buffer[idx+2] = ((intptr_t)(self->m_faces[i].m_n[2]) - nodeOffset) / nodeSize;
		}
	}
SWIGINTERN void btSoftBody_setConfig_kVCF(btSoftBody *self,btScalar v){ self->m_cfg.kVCF = v; }
SWIGINTERN void btSoftBody_setConfig_kDP(btSoftBody *self,btScalar v){ self->m_cfg.kDP = v; }
SWIGINTERN void btSoftBody_setConfig_kDG(btSoftBody *self,btScalar v){ self->m_cfg.kDG = v; }
SWIGINTERN void btSoftBody_setConfig_kLF(btSoftBody *self,btScalar v){ self->m_cfg.kLF = v; }
SWIGINTERN void btSoftBody_setConfig_kPR(btSoftBody *self,btScalar v){ self->m_cfg.kPR = v; }
SWIGINTERN void btSoftBody_setConfig_kVC(btSoftBody *self,btScalar v){ self->m_cfg.kVC = v; }
SWIGINTERN void btSoftBody_setConfig_kDF(btSoftBody *self,btScalar v){ self->m_cfg.kDF = v; }
SWIGINTERN void btSoftBody_setConfig_kMT(btSoftBody *self,btScalar v){ self->m_cfg.kMT = v; }
SWIGINTERN void btSoftBody_setConfig_kCHR(btSoftBody *self,btScalar v){ self->m_cfg.kCHR = v; }
SWIGINTERN void btSoftBody_setConfig_kKHR(btSoftBody *self,btScalar v){ self->m_cfg.kKHR = v; }
SWIGINTERN void btSoftBody_setConfig_kSHR(btSoftBody *self,btScalar v){ self->m_cfg.kSHR = v; }
SWIGINTERN void btSoftBody_setConfig_kAHR(btSoftBody *self,btScalar v){ self->m_cfg.kAHR = v; }
SWIGINTERN void btSoftBody_setConfig_kSRHR_CL(btSoftBody *self,btScalar v){ self->m_cfg.kSRHR_CL = v; }
SWIGINTERN void btSoftBody_setConfig_kSKHR_CL(btSoftBody *self,btScalar v){ self->m_cfg.kSKHR_CL = v; }
SWIGINTERN void btSoftBody_setConfig_kSSHR_CL(btSoftBody *self,btScalar v){ self->m_cfg.kSSHR_CL = v; }
SWIGINTERN void btSoftBody_setConfig_kSR_SPLT_CL(btSoftBody *self,btScalar v){ self->m_cfg.kSR_SPLT_CL = v; }
SWIGINTERN void btSoftBody_setConfig_kSK_SPLT_CL(btSoftBody *self,btScalar v){ self->m_cfg.kSK_SPLT_CL = v; }
SWIGINTERN void btSoftBody_setConfig_kSS_SPLT_CL(btSoftBody *self,btScalar v){ self->m_cfg.kSS_SPLT_CL = v; }
SWIGINTERN void btSoftBody_setConfig_maxvolume(btSoftBody *self,btScalar v){ self->m_cfg.maxvolume = v; }
SWIGINTERN void btSoftBody_setConfig_timescale(btSoftBody *self,btScalar v){ self->m_cfg.timescale = v; }
SWIGINTERN void btSoftBody_setConfig_viterations(btSoftBody *self,int v){ self->m_cfg.viterations = v; }
SWIGINTERN void btSoftBody_setConfig_piterations(btSoftBody *self,int v){ self->m_cfg.piterations = v; }
SWIGINTERN void btSoftBody_setConfig_diterations(btSoftBody *self,int v){ self->m_cfg.diterations = v; }
SWIGINTERN void btSoftBody_setConfig_citerations(btSoftBody *self,int v){ self->m_cfg.citerations = v; }
SWIGINTERN void btSoftBody_setConfig_collisions(btSoftBody *self,int v){ self->m_cfg.collisions = v; }

#include <BulletSoftBody/btSoftBodyConcaveCollisionAlgorithm.h>


#include <BulletSoftBody/btSoftBodyData.h>


#include <BulletSoftBody/btSoftBodyHelpers.h>


#include <BulletSoftBody/btSoftBodyInternals.h>


#include <BulletSoftBody/btSoftBodyRigidBodyCollisionConfiguration.h>


#include <BulletSoftBody/btSoftBodySolverVertexBuffer.h>


#include <BulletSoftBody/btSoftRigidCollisionAlgorithm.h>


#include <BulletSoftBody/btSoftRigidDynamicsWorld.h>


#include <BulletSoftBody/btSoftSoftCollisionAlgorithm.h>


#include <BulletSoftBody/btSoftMultiBodyDynamicsWorld.h>



/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "softbody_wrap.h"


#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBodySolver(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBodySolver *arg1 = (btSoftBodySolver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBodySolver **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodySolver_1getSolverType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBodySolver *arg1 = (btSoftBodySolver *) 0 ;
  btSoftBodySolver::SolverTypes result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodySolver **)&jarg1; 
  result = (btSoftBodySolver::SolverTypes)((btSoftBodySolver const *)arg1)->getSolverType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodySolver_1checkInitialized(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btSoftBodySolver *arg1 = (btSoftBodySolver *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodySolver **)&jarg1; 
  result = (bool)(arg1)->checkInitialized();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodySolver_1optimize_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jboolean jarg3) {
  btSoftBodySolver *arg1 = (btSoftBodySolver *) 0 ;
  btAlignedObjectArray< btSoftBody * > *arg2 = 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodySolver **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btSoftBody * > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btSoftBody * > & reference is null");
    return ;
  } 
  arg3 = jarg3 ? true : false; 
  (arg1)->optimize(*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodySolver_1optimize_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBodySolver *arg1 = (btSoftBodySolver *) 0 ;
  btAlignedObjectArray< btSoftBody * > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodySolver **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btSoftBody * > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btSoftBody * > & reference is null");
    return ;
  } 
  (arg1)->optimize(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodySolver_1copyBackToSoftBodies_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btSoftBodySolver *arg1 = (btSoftBodySolver *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodySolver **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->copyBackToSoftBodies(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodySolver_1copyBackToSoftBodies_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBodySolver *arg1 = (btSoftBodySolver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodySolver **)&jarg1; 
  (arg1)->copyBackToSoftBodies();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodySolver_1predictMotion(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBodySolver *arg1 = (btSoftBodySolver *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodySolver **)&jarg1; 
  arg2 = (float)jarg2; 
  (arg1)->predictMotion(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodySolver_1solveConstraints(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBodySolver *arg1 = (btSoftBodySolver *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodySolver **)&jarg1; 
  arg2 = (float)jarg2; 
  (arg1)->solveConstraints(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodySolver_1updateSoftBodies(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBodySolver *arg1 = (btSoftBodySolver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodySolver **)&jarg1; 
  (arg1)->updateSoftBodies();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodySolver_1processCollision_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btSoftBodySolver *arg1 = (btSoftBodySolver *) 0 ;
  btSoftBody *arg2 = (btSoftBody *) 0 ;
  btCollisionObjectWrapper *arg3 = (btCollisionObjectWrapper *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btSoftBodySolver **)&jarg1; 
  arg2 = *(btSoftBody **)&jarg2; 
  arg3 = *(btCollisionObjectWrapper **)&jarg3; 
  (arg1)->processCollision(arg2,(btCollisionObjectWrapper const *)arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodySolver_1processCollision_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btSoftBodySolver *arg1 = (btSoftBodySolver *) 0 ;
  btSoftBody *arg2 = (btSoftBody *) 0 ;
  btSoftBody *arg3 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btSoftBodySolver **)&jarg1; 
  arg2 = *(btSoftBody **)&jarg2; 
  arg3 = *(btSoftBody **)&jarg3; 
  (arg1)->processCollision(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodySolver_1setNumberOfPositionIterations(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBodySolver *arg1 = (btSoftBodySolver *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodySolver **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setNumberOfPositionIterations(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodySolver_1getNumberOfPositionIterations(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBodySolver *arg1 = (btSoftBodySolver *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodySolver **)&jarg1; 
  result = (int)(arg1)->getNumberOfPositionIterations();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodySolver_1setNumberOfVelocityIterations(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBodySolver *arg1 = (btSoftBodySolver *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodySolver **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setNumberOfVelocityIterations(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodySolver_1getNumberOfVelocityIterations(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBodySolver *arg1 = (btSoftBodySolver *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodySolver **)&jarg1; 
  result = (int)(arg1)->getNumberOfVelocityIterations();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodySolver_1getTimeScale(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBodySolver *arg1 = (btSoftBodySolver *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodySolver **)&jarg1; 
  result = (float)(arg1)->getTimeScale();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBodySolverOutput(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBodySolverOutput *arg1 = (btSoftBodySolverOutput *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBodySolverOutput **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodySolverOutput_1copySoftBodyToVertexBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btSoftBodySolverOutput *arg1 = (btSoftBodySolverOutput *) 0 ;
  btSoftBody *arg2 = (btSoftBody *) (btSoftBody *)0 ;
  btVertexBufferDescriptor *arg3 = (btVertexBufferDescriptor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btSoftBodySolverOutput **)&jarg1; 
  arg2 = *(btSoftBody **)&jarg2; 
  arg3 = *(btVertexBufferDescriptor **)&jarg3; 
  (arg1)->copySoftBodyToVertexBuffer((btSoftBody const *)arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btDefaultSoftBodySolver(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btDefaultSoftBodySolver *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btDefaultSoftBodySolver *)new btDefaultSoftBodySolver();
  *(btDefaultSoftBodySolver **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btDefaultSoftBodySolver(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDefaultSoftBodySolver *arg1 = (btDefaultSoftBodySolver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDefaultSoftBodySolver **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btDefaultSoftBodySolver_1optimize_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jboolean jarg3) {
  btDefaultSoftBodySolver *arg1 = (btDefaultSoftBodySolver *) 0 ;
  btAlignedObjectArray< btSoftBody * > *arg2 = 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultSoftBodySolver **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btSoftBody * > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btSoftBody * > & reference is null");
    return ;
  } 
  arg3 = jarg3 ? true : false; 
  (arg1)->optimize(*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btDefaultSoftBodySolver_1optimize_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDefaultSoftBodySolver *arg1 = (btDefaultSoftBodySolver *) 0 ;
  btAlignedObjectArray< btSoftBody * > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultSoftBodySolver **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btSoftBody * > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btSoftBody * > & reference is null");
    return ;
  } 
  (arg1)->optimize(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btDefaultSoftBodySolver_1copyBackToSoftBodies_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btDefaultSoftBodySolver *arg1 = (btDefaultSoftBodySolver *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultSoftBodySolver **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->copyBackToSoftBodies(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btDefaultSoftBodySolver_1copyBackToSoftBodies_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btDefaultSoftBodySolver *arg1 = (btDefaultSoftBodySolver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultSoftBodySolver **)&jarg1; 
  (arg1)->copyBackToSoftBodies();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btDefaultSoftBodySolver_1copySoftBodyToVertexBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btDefaultSoftBodySolver *arg1 = (btDefaultSoftBodySolver *) 0 ;
  btSoftBody *arg2 = (btSoftBody *) (btSoftBody *)0 ;
  btVertexBufferDescriptor *arg3 = (btVertexBufferDescriptor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDefaultSoftBodySolver **)&jarg1; 
  arg2 = *(btSoftBody **)&jarg2; 
  arg3 = *(btVertexBufferDescriptor **)&jarg3; 
  (arg1)->copySoftBodyToVertexBuffer((btSoftBody const *)arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btDefaultSoftBodySolver_1processCollision_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btDefaultSoftBodySolver *arg1 = (btDefaultSoftBodySolver *) 0 ;
  btSoftBody *arg2 = (btSoftBody *) 0 ;
  btCollisionObjectWrapper *arg3 = (btCollisionObjectWrapper *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDefaultSoftBodySolver **)&jarg1; 
  arg2 = *(btSoftBody **)&jarg2; 
  arg3 = *(btCollisionObjectWrapper **)&jarg3; 
  (arg1)->processCollision(arg2,(btCollisionObjectWrapper const *)arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btDefaultSoftBodySolver_1processCollision_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btDefaultSoftBodySolver *arg1 = (btDefaultSoftBodySolver *) 0 ;
  btSoftBody *arg2 = (btSoftBody *) 0 ;
  btSoftBody *arg3 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDefaultSoftBodySolver **)&jarg1; 
  arg2 = *(btSoftBody **)&jarg2; 
  arg3 = *(btSoftBody **)&jarg3; 
  (arg1)->processCollision(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1IntFrac_1b_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSparseSdf< 3 >::IntFrac *arg1 = (btSparseSdf< 3 >::IntFrac *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 >::IntFrac **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->b = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1IntFrac_1b_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSparseSdf< 3 >::IntFrac *arg1 = (btSparseSdf< 3 >::IntFrac *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 >::IntFrac **)&jarg1; 
  result = (int) ((arg1)->b);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1IntFrac_1i_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSparseSdf< 3 >::IntFrac *arg1 = (btSparseSdf< 3 >::IntFrac *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 >::IntFrac **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->i = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1IntFrac_1i_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSparseSdf< 3 >::IntFrac *arg1 = (btSparseSdf< 3 >::IntFrac *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 >::IntFrac **)&jarg1; 
  result = (int) ((arg1)->i);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1IntFrac_1f_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSparseSdf< 3 >::IntFrac *arg1 = (btSparseSdf< 3 >::IntFrac *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 >::IntFrac **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->f = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1IntFrac_1f_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSparseSdf< 3 >::IntFrac *arg1 = (btSparseSdf< 3 >::IntFrac *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 >::IntFrac **)&jarg1; 
  result = (btScalar) ((arg1)->f);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSparseSdf3_1IntFrac(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSparseSdf< 3 >::IntFrac *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSparseSdf< 3 >::IntFrac *)new btSparseSdf< 3 >::IntFrac();
  *(btSparseSdf< 3 >::IntFrac **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSparseSdf3_1IntFrac(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSparseSdf< 3 >::IntFrac *arg1 = (btSparseSdf< 3 >::IntFrac *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSparseSdf< 3 >::IntFrac **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1Cell_1d_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSparseSdf< 3 >::Cell *arg1 = (btSparseSdf< 3 >::Cell *) 0 ;
  btScalar (*arg2)[3+1][3+1] ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 >::Cell **)&jarg1; 
  arg2 = *(btScalar (**)[3+1][3+1])&jarg2; 
  {
    btScalar (*inp)[3+1] = (btScalar (*)[3+1])(arg2);
    btScalar (*dest)[3+1] = (btScalar (*)[3+1])(arg1->d);
    size_t ii = 0;
    for (; ii < 3+1; ++ii) {
      btScalar *ip = inp[ii];
      btScalar *dp = dest[ii];
      size_t jj = 0;
      for (; jj < 3+1; ++jj) dp[jj] = ip[jj];
    }
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1Cell_1d_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSparseSdf< 3 >::Cell *arg1 = (btSparseSdf< 3 >::Cell *) 0 ;
  btScalar (*result)[3+1][3+1] = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 >::Cell **)&jarg1; 
  result = (btScalar (*)[3+1][3+1])(btScalar (*)[3+1][3+1]) ((arg1)->d);
  *(btScalar (**)[3+1][3+1])&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1Cell_1c_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btSparseSdf< 3 >::Cell *arg1 = (btSparseSdf< 3 >::Cell *) 0 ;
  int *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 >::Cell **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  arg2 = (int *)jenv->GetPrimitiveArrayCritical(jarg2, 0); 
  {
    size_t ii;
    int *b = (int *) arg1->c;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((int *) arg2 + ii);
  }
  jenv->ReleasePrimitiveArrayCritical(jarg2, (int *)arg2, 0); 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1Cell_1c_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btSparseSdf< 3 >::Cell *arg1 = (btSparseSdf< 3 >::Cell *) 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 >::Cell **)&jarg1; 
  result = (int *)(int *) ((arg1)->c);
  /*jresult = SWIG_JavaArrayOut##Int(jenv, (int *)result, 3);*/ 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1Cell_1puid_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSparseSdf< 3 >::Cell *arg1 = (btSparseSdf< 3 >::Cell *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 >::Cell **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->puid = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1Cell_1puid_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSparseSdf< 3 >::Cell *arg1 = (btSparseSdf< 3 >::Cell *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 >::Cell **)&jarg1; 
  result = (int) ((arg1)->puid);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1Cell_1hash_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSparseSdf< 3 >::Cell *arg1 = (btSparseSdf< 3 >::Cell *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 >::Cell **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->hash = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1Cell_1hash_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSparseSdf< 3 >::Cell *arg1 = (btSparseSdf< 3 >::Cell *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 >::Cell **)&jarg1; 
  result = (unsigned int) ((arg1)->hash);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1Cell_1pclient_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSparseSdf< 3 >::Cell *arg1 = (btSparseSdf< 3 >::Cell *) 0 ;
  btCollisionShape *arg2 = (btCollisionShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSparseSdf< 3 >::Cell **)&jarg1; 
  arg2 = *(btCollisionShape **)&jarg2; 
  if (arg1) (arg1)->pclient = (btCollisionShape const *)arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1Cell_1pclient_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSparseSdf< 3 >::Cell *arg1 = (btSparseSdf< 3 >::Cell *) 0 ;
  btCollisionShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 >::Cell **)&jarg1; 
  result = (btCollisionShape *) ((arg1)->pclient);
  *(btCollisionShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1Cell_1next_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSparseSdf< 3 >::Cell *arg1 = (btSparseSdf< 3 >::Cell *) 0 ;
  btSparseSdf< 3 >::Cell *arg2 = (btSparseSdf< 3 >::Cell *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSparseSdf< 3 >::Cell **)&jarg1; 
  arg2 = *(btSparseSdf< 3 >::Cell **)&jarg2; 
  if (arg1) (arg1)->next = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1Cell_1next_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSparseSdf< 3 >::Cell *arg1 = (btSparseSdf< 3 >::Cell *) 0 ;
  btSparseSdf< 3 >::Cell *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 >::Cell **)&jarg1; 
  result = (btSparseSdf< 3 >::Cell *) ((arg1)->next);
  *(btSparseSdf< 3 >::Cell **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSparseSdf3_1Cell(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSparseSdf< 3 >::Cell *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSparseSdf< 3 >::Cell *)new btSparseSdf< 3 >::Cell();
  *(btSparseSdf< 3 >::Cell **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSparseSdf3_1Cell(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSparseSdf< 3 >::Cell *arg1 = (btSparseSdf< 3 >::Cell *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSparseSdf< 3 >::Cell **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1cells_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  btAlignedObjectArray< btSparseSdf< 3 >::Cell * > *arg2 = (btAlignedObjectArray< btSparseSdf< 3 >::Cell * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btSparseSdf< 3 >::Cell * > **)&jarg2; 
  if (arg1) (arg1)->cells = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1cells_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  btAlignedObjectArray< btSparseSdf< 3 >::Cell * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  result = (btAlignedObjectArray< btSparseSdf< 3 >::Cell * > *)& ((arg1)->cells);
  *(btAlignedObjectArray< btSparseSdf< 3 >::Cell * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1voxelsz_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->voxelsz = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1voxelsz_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  result = (btScalar) ((arg1)->voxelsz);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1puid_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->puid = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1puid_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  result = (int) ((arg1)->puid);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1ncells_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->ncells = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1ncells_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  result = (int) ((arg1)->ncells);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1clampCells_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_clampCells = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1clampCells_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  result = (int) ((arg1)->m_clampCells);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1nprobes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->nprobes = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1nprobes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  result = (int) ((arg1)->nprobes);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1nqueries_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->nqueries = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1nqueries_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  result = (int) ((arg1)->nqueries);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1Initialize_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->Initialize(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1Initialize_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->Initialize(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1Initialize_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  (arg1)->Initialize();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1Reset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  (arg1)->Reset();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1GarbageCollect_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->GarbageCollect(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1GarbageCollect_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  (arg1)->GarbageCollect();
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1RemoveReferences(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  btCollisionShape *arg2 = (btCollisionShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  arg2 = *(btCollisionShape **)&jarg2; 
  result = (int)(arg1)->RemoveReferences(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1Evaluate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jobject jarg3_, jobject jarg4, jfloat jarg5) {
  jfloat jresult = 0 ;
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  btVector3 *arg2 = 0 ;
  btCollisionShape *arg3 = (btCollisionShape *) 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = *(btCollisionShape **)&jarg3; 
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = (btScalar)jarg5; 
  result = (btScalar)(arg1)->Evaluate((btVector3 const &)*arg2,(btCollisionShape const *)arg3,*arg4,arg5);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1BuildCell(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  btSparseSdf< 3 >::Cell *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  arg2 = *(btSparseSdf< 3 >::Cell **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSparseSdf< 3 >::Cell & reference is null");
    return ;
  } 
  (arg1)->BuildCell(*arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1DistanceToShape(JNIEnv *jenv, jclass jcls, jobject jarg1, jlong jarg2, jobject jarg2_) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btCollisionShape *arg2 = (btCollisionShape *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  arg2 = *(btCollisionShape **)&jarg2; 
  result = (btScalar)btSparseSdf< 3 >::SWIGTEMPLATEDISAMBIGUATOR DistanceToShape((btVector3 const &)*arg1,(btCollisionShape const *)arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1Decompose(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jlong jresult = 0 ;
  btScalar arg1 ;
  btSparseSdf< 3 >::IntFrac result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = btSparseSdf< 3 >::SWIGTEMPLATEDISAMBIGUATOR Decompose(arg1);
  *(btSparseSdf< 3 >::IntFrac **)&jresult = new btSparseSdf< 3 >::IntFrac((const btSparseSdf< 3 >::IntFrac &)result); 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1Lerp(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2, jfloat jarg3) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  result = (btScalar)btSparseSdf< 3 >::SWIGTEMPLATEDISAMBIGUATOR Lerp(arg1,arg2,arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSparseSdf3_1Hash(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  int arg3 ;
  btCollisionShape *arg4 = (btCollisionShape *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg4_;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = *(btCollisionShape **)&jarg4; 
  result = (unsigned int)btSparseSdf< 3 >::SWIGTEMPLATEDISAMBIGUATOR Hash(arg1,arg2,arg3,(btCollisionShape const *)arg4);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSparseSdf3(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSparseSdf< 3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSparseSdf< 3 > *)new btSparseSdf< 3 >();
  *(btSparseSdf< 3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSparseSdf3(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSparseSdf< 3 > *arg1 = (btSparseSdf< 3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSparseSdf< 3 > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyWorldInfo_1air_1density_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->air_density = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyWorldInfo_1air_1density_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  result = (btScalar) ((arg1)->air_density);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyWorldInfo_1water_1density_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->water_density = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyWorldInfo_1water_1density_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  result = (btScalar) ((arg1)->water_density);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyWorldInfo_1water_1offset_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->water_offset = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyWorldInfo_1water_1offset_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  result = (btScalar) ((arg1)->water_offset);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyWorldInfo_1maxDisplacement_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_maxDisplacement = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyWorldInfo_1maxDisplacement_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_maxDisplacement);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyWorldInfo_1water_1normal_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->water_normal = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyWorldInfo_1water_1normal_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  result = (btVector3 *)& ((arg1)->water_normal);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyWorldInfo_1broadphase_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  btBroadphaseInterface *arg2 = (btBroadphaseInterface *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  arg2 = *(btBroadphaseInterface **)&jarg2; 
  if (arg1) (arg1)->m_broadphase = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyWorldInfo_1broadphase_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  btBroadphaseInterface *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  result = (btBroadphaseInterface *) ((arg1)->m_broadphase);
  *(btBroadphaseInterface **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyWorldInfo_1dispatcher_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  btDispatcher *arg2 = (btDispatcher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  arg2 = *(btDispatcher **)&jarg2; 
  if (arg1) (arg1)->m_dispatcher = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyWorldInfo_1dispatcher_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  btDispatcher *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  result = (btDispatcher *) ((arg1)->m_dispatcher);
  *(btDispatcher **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyWorldInfo_1gravity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_gravity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyWorldInfo_1gravity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_gravity);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyWorldInfo_1sparsesdf_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  btSparseSdf< 3 > *arg2 = (btSparseSdf< 3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  arg2 = *(btSparseSdf< 3 > **)&jarg2; 
  if (arg1) (arg1)->m_sparsesdf = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyWorldInfo_1sparsesdf_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  btSparseSdf< 3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  result = (btSparseSdf< 3 > *)& ((arg1)->m_sparsesdf);
  *(btSparseSdf< 3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBodyWorldInfo(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBodyWorldInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBodyWorldInfo *)new btSoftBodyWorldInfo();
  *(btSoftBodyWorldInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBodyWorldInfo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1collisionDisabledObjects_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btAlignedObjectArray< btCollisionObject const * > *arg2 = (btAlignedObjectArray< btCollisionObject const * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btCollisionObject const * > **)&jarg2; 
  if (arg1) (arg1)->m_collisionDisabledObjects = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1collisionDisabledObjects_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btAlignedObjectArray< btCollisionObject const * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btAlignedObjectArray< btCollisionObject const * > *)& ((arg1)->m_collisionDisabledObjects);
  *(btAlignedObjectArray< btCollisionObject const * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1softBodySolver_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBodySolver *arg2 = (btSoftBodySolver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBodySolver **)&jarg2; 
  if (arg1) (arg1)->m_softBodySolver = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1softBodySolver_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBodySolver *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btSoftBodySolver *) ((arg1)->m_softBodySolver);
  *(btSoftBodySolver **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1eAeroModel(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::eAeroModel *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::eAeroModel *)new btSoftBody::eAeroModel();
  *(btSoftBody::eAeroModel **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1eAeroModel(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::eAeroModel *arg1 = (btSoftBody::eAeroModel *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::eAeroModel **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1eVSolver(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::eVSolver *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::eVSolver *)new btSoftBody::eVSolver();
  *(btSoftBody::eVSolver **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1eVSolver(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::eVSolver *arg1 = (btSoftBody::eVSolver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::eVSolver **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1ePSolver(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::ePSolver *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::ePSolver *)new btSoftBody::ePSolver();
  *(btSoftBody::ePSolver **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1ePSolver(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::ePSolver *arg1 = (btSoftBody::ePSolver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::ePSolver **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1eSolverPresets(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::eSolverPresets *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::eSolverPresets *)new btSoftBody::eSolverPresets();
  *(btSoftBody::eSolverPresets **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1eSolverPresets(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::eSolverPresets *arg1 = (btSoftBody::eSolverPresets *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::eSolverPresets **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1eFeature(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::eFeature *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::eFeature *)new btSoftBody::eFeature();
  *(btSoftBody::eFeature **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1eFeature(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::eFeature *arg1 = (btSoftBody::eFeature *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::eFeature **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1fCollision(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::fCollision *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::fCollision *)new btSoftBody::fCollision();
  *(btSoftBody::fCollision **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1fCollision(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::fCollision *arg1 = (btSoftBody::fCollision *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::fCollision **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1fMaterial(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::fMaterial *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::fMaterial *)new btSoftBody::fMaterial();
  *(btSoftBody::fMaterial **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1fMaterial(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::fMaterial *arg1 = (btSoftBody::fMaterial *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::fMaterial **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1sRayCast_1body_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::sRayCast *arg1 = (btSoftBody::sRayCast *) 0 ;
  btSoftBody *arg2 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::sRayCast **)&jarg1; 
  arg2 = *(btSoftBody **)&jarg2; 
  if (arg1) (arg1)->body = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1sRayCast_1body_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::sRayCast *arg1 = (btSoftBody::sRayCast *) 0 ;
  btSoftBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::sRayCast **)&jarg1; 
  result = (btSoftBody *) ((arg1)->body);
  *(btSoftBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1sRayCast_1feature_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody::sRayCast *arg1 = (btSoftBody::sRayCast *) 0 ;
  btSoftBody::eFeature::_ arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::sRayCast **)&jarg1; 
  arg2 = (btSoftBody::eFeature::_)jarg2; 
  if (arg1) (arg1)->feature = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1sRayCast_1feature_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody::sRayCast *arg1 = (btSoftBody::sRayCast *) 0 ;
  btSoftBody::eFeature::_ result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::sRayCast **)&jarg1; 
  result = (btSoftBody::eFeature::_) ((arg1)->feature);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1sRayCast_1index_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody::sRayCast *arg1 = (btSoftBody::sRayCast *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::sRayCast **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->index = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1sRayCast_1index_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody::sRayCast *arg1 = (btSoftBody::sRayCast *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::sRayCast **)&jarg1; 
  result = (int) ((arg1)->index);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1sRayCast_1fraction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::sRayCast *arg1 = (btSoftBody::sRayCast *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::sRayCast **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->fraction = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1sRayCast_1fraction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::sRayCast *arg1 = (btSoftBody::sRayCast *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::sRayCast **)&jarg1; 
  result = (btScalar) ((arg1)->fraction);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1sRayCast(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::sRayCast *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::sRayCast *)new btSoftBody::sRayCast();
  *(btSoftBody::sRayCast **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1sRayCast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::sRayCast *arg1 = (btSoftBody::sRayCast *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::sRayCast **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1ImplicitFn(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::ImplicitFn *arg1 = (btSoftBody::ImplicitFn *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::ImplicitFn **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1ImplicitFn_1Eval(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jfloat jresult = 0 ;
  btSoftBody::ImplicitFn *arg1 = (btSoftBody::ImplicitFn *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::ImplicitFn **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btScalar)(arg1)->Eval((btVector3 const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1sCti_1colObj_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::sCti *arg1 = (btSoftBody::sCti *) 0 ;
  btCollisionObject *arg2 = (btCollisionObject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::sCti **)&jarg1; 
  arg2 = *(btCollisionObject **)&jarg2; 
  if (arg1) (arg1)->m_colObj = (btCollisionObject const *)arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1sCti_1colObj_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::sCti *arg1 = (btSoftBody::sCti *) 0 ;
  btCollisionObject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::sCti **)&jarg1; 
  result = (btCollisionObject *) ((arg1)->m_colObj);
  *(btCollisionObject **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1sCti_1normal_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::sCti *arg1 = (btSoftBody::sCti *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::sCti **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_normal = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1sCti_1normal_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::sCti *arg1 = (btSoftBody::sCti *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::sCti **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_normal);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1sCti_1offset_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::sCti *arg1 = (btSoftBody::sCti *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::sCti **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_offset = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1sCti_1offset_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::sCti *arg1 = (btSoftBody::sCti *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::sCti **)&jarg1; 
  result = (btScalar) ((arg1)->m_offset);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1sCti(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::sCti *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::sCti *)new btSoftBody::sCti();
  *(btSoftBody::sCti **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1sCti(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::sCti *arg1 = (btSoftBody::sCti *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::sCti **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1sMedium_1velocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::sMedium *arg1 = (btSoftBody::sMedium *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::sMedium **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_velocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1sMedium_1velocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::sMedium *arg1 = (btSoftBody::sMedium *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::sMedium **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_velocity);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1sMedium_1pressure_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::sMedium *arg1 = (btSoftBody::sMedium *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::sMedium **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_pressure = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1sMedium_1pressure_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::sMedium *arg1 = (btSoftBody::sMedium *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::sMedium **)&jarg1; 
  result = (btScalar) ((arg1)->m_pressure);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1sMedium_1density_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::sMedium *arg1 = (btSoftBody::sMedium *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::sMedium **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_density = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1sMedium_1density_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::sMedium *arg1 = (btSoftBody::sMedium *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::sMedium **)&jarg1; 
  result = (btScalar) ((arg1)->m_density);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1sMedium(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::sMedium *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::sMedium *)new btSoftBody::sMedium();
  *(btSoftBody::sMedium **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1sMedium(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::sMedium *arg1 = (btSoftBody::sMedium *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::sMedium **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Element_1tag_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody::Element *arg1 = (btSoftBody::Element *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Element **)&jarg1; 
  arg2 = (void *)jarg2; 
  if (arg1) (arg1)->m_tag = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Element_1tag_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Element *arg1 = (btSoftBody::Element *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Element **)&jarg1; 
  result = (void *) ((arg1)->m_tag);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1Element(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::Element *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::Element *)new btSoftBody::Element();
  *(btSoftBody::Element **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1Element(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::Element *arg1 = (btSoftBody::Element *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::Element **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Material_1kLST_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Material *arg1 = (btSoftBody::Material *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Material **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_kLST = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Material_1kLST_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Material *arg1 = (btSoftBody::Material *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Material **)&jarg1; 
  result = (btScalar) ((arg1)->m_kLST);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Material_1kAST_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Material *arg1 = (btSoftBody::Material *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Material **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_kAST = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Material_1kAST_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Material *arg1 = (btSoftBody::Material *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Material **)&jarg1; 
  result = (btScalar) ((arg1)->m_kAST);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Material_1kVST_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Material *arg1 = (btSoftBody::Material *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Material **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_kVST = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Material_1kVST_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Material *arg1 = (btSoftBody::Material *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Material **)&jarg1; 
  result = (btScalar) ((arg1)->m_kVST);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Material_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody::Material *arg1 = (btSoftBody::Material *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Material **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_flags = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Material_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody::Material *arg1 = (btSoftBody::Material *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Material **)&jarg1; 
  result = (int) ((arg1)->m_flags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1Material(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::Material *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::Material *)new btSoftBody::Material();
  *(btSoftBody::Material **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1Material(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::Material *arg1 = (btSoftBody::Material *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::Material **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Feature_1material_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Feature *arg1 = (btSoftBody::Feature *) 0 ;
  btSoftBody::Material *arg2 = (btSoftBody::Material *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Feature **)&jarg1; 
  arg2 = *(btSoftBody::Material **)&jarg2; 
  if (arg1) (arg1)->m_material = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Feature_1material_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Feature *arg1 = (btSoftBody::Feature *) 0 ;
  btSoftBody::Material *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Feature **)&jarg1; 
  result = (btSoftBody::Material *) ((arg1)->m_material);
  *(btSoftBody::Material **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1Feature(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::Feature *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::Feature *)new btSoftBody::Feature();
  *(btSoftBody::Feature **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1Feature(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::Feature *arg1 = (btSoftBody::Feature *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::Feature **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Node_1x_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Node *arg1 = (btSoftBody::Node *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Node **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_x = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Node_1x_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Node *arg1 = (btSoftBody::Node *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Node **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_x);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Node_1q_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Node *arg1 = (btSoftBody::Node *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Node **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_q = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Node_1q_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Node *arg1 = (btSoftBody::Node *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Node **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_q);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Node_1v_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Node *arg1 = (btSoftBody::Node *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Node **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_v = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Node_1v_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Node *arg1 = (btSoftBody::Node *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Node **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_v);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Node_1f_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Node *arg1 = (btSoftBody::Node *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Node **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_f = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Node_1f_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Node *arg1 = (btSoftBody::Node *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Node **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_f);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Node_1n_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Node *arg1 = (btSoftBody::Node *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Node **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_n = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Node_1n_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Node *arg1 = (btSoftBody::Node *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Node **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_n);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Node_1im_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Node *arg1 = (btSoftBody::Node *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Node **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_im = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Node_1im_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Node *arg1 = (btSoftBody::Node *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Node **)&jarg1; 
  result = (btScalar) ((arg1)->m_im);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Node_1area_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Node *arg1 = (btSoftBody::Node *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Node **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_area = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Node_1area_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Node *arg1 = (btSoftBody::Node *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Node **)&jarg1; 
  result = (btScalar) ((arg1)->m_area);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Node_1leaf_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Node *arg1 = (btSoftBody::Node *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Node **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  if (arg1) (arg1)->m_leaf = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Node_1leaf_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Node *arg1 = (btSoftBody::Node *) 0 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Node **)&jarg1; 
  result = (btDbvtNode *) ((arg1)->m_leaf);
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Node_1battach_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody::Node *arg1 = (btSoftBody::Node *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Node **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_battach = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Node_1battach_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody::Node *arg1 = (btSoftBody::Node *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Node **)&jarg1; 
  result = (int) ((arg1)->m_battach);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1Node(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::Node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::Node *)new btSoftBody::Node();
  *(btSoftBody::Node **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1Node(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::Node *arg1 = (btSoftBody::Node *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::Node **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1c3_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_c3 = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1c3_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_c3);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1n_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  btSoftBody::Node **arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  arg2 = *(btSoftBody::Node ***)&jarg2; 
  {
    size_t ii;
    btSoftBody::Node * *b = (btSoftBody::Node * *) arg1->m_n;
    for (ii = 0; ii < (size_t)2; ii++) b[ii] = *((btSoftBody::Node * *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1n_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  btSoftBody::Node **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  result = (btSoftBody::Node **)(btSoftBody::Node **) ((arg1)->m_n);
  *(btSoftBody::Node ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1rl_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_rl = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1rl_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  result = (btScalar) ((arg1)->m_rl);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1bbending_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_bbending = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1bbending_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  result = (int) ((arg1)->m_bbending);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1c0_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_c0 = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1c0_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  result = (btScalar) ((arg1)->m_c0);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1c1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_c1 = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1c1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  result = (btScalar) ((arg1)->m_c1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1c2_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_c2 = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1c2_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  result = (btScalar) ((arg1)->m_c2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1operatorNew_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1operatorDelete_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1operatorNew_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1operatorDelete_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1operatorNewArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new[](arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1operatorDeleteArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete[](arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1operatorNewArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new[](arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1operatorDeleteArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete[](arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1Link(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::Link *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::Link *)new btSoftBody::Link();
  *(btSoftBody::Link **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1Link(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::Link *arg1 = (btSoftBody::Link *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::Link **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Face_1n_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody::Face *arg1 = (btSoftBody::Face *) 0 ;
  btSoftBody::Node **arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Face **)&jarg1; 
  arg2 = *(btSoftBody::Node ***)&jarg2; 
  {
    size_t ii;
    btSoftBody::Node * *b = (btSoftBody::Node * *) arg1->m_n;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((btSoftBody::Node * *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Face_1n_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Face *arg1 = (btSoftBody::Face *) 0 ;
  btSoftBody::Node **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Face **)&jarg1; 
  result = (btSoftBody::Node **)(btSoftBody::Node **) ((arg1)->m_n);
  *(btSoftBody::Node ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Face_1normal_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Face *arg1 = (btSoftBody::Face *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Face **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_normal = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Face_1normal_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Face *arg1 = (btSoftBody::Face *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Face **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_normal);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Face_1ra_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Face *arg1 = (btSoftBody::Face *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Face **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_ra = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Face_1ra_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Face *arg1 = (btSoftBody::Face *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Face **)&jarg1; 
  result = (btScalar) ((arg1)->m_ra);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Face_1leaf_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Face *arg1 = (btSoftBody::Face *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Face **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  if (arg1) (arg1)->m_leaf = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Face_1leaf_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Face *arg1 = (btSoftBody::Face *) 0 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Face **)&jarg1; 
  result = (btDbvtNode *) ((arg1)->m_leaf);
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1Face(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::Face *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::Face *)new btSoftBody::Face();
  *(btSoftBody::Face **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1Face(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::Face *arg1 = (btSoftBody::Face *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::Face **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Tetra_1n_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody::Tetra *arg1 = (btSoftBody::Tetra *) 0 ;
  btSoftBody::Node **arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Tetra **)&jarg1; 
  arg2 = *(btSoftBody::Node ***)&jarg2; 
  {
    size_t ii;
    btSoftBody::Node * *b = (btSoftBody::Node * *) arg1->m_n;
    for (ii = 0; ii < (size_t)4; ii++) b[ii] = *((btSoftBody::Node * *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Tetra_1n_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Tetra *arg1 = (btSoftBody::Tetra *) 0 ;
  btSoftBody::Node **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Tetra **)&jarg1; 
  result = (btSoftBody::Node **)(btSoftBody::Node **) ((arg1)->m_n);
  *(btSoftBody::Node ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Tetra_1rv_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Tetra *arg1 = (btSoftBody::Tetra *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Tetra **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_rv = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Tetra_1rv_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Tetra *arg1 = (btSoftBody::Tetra *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Tetra **)&jarg1; 
  result = (btScalar) ((arg1)->m_rv);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Tetra_1leaf_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Tetra *arg1 = (btSoftBody::Tetra *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Tetra **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  if (arg1) (arg1)->m_leaf = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Tetra_1leaf_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Tetra *arg1 = (btSoftBody::Tetra *) 0 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Tetra **)&jarg1; 
  result = (btDbvtNode *) ((arg1)->m_leaf);
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Tetra_1c0_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Tetra *arg1 = (btSoftBody::Tetra *) 0 ;
  btVector3 *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Tetra **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  {
    size_t ii;
    btVector3 *b = (btVector3 *) arg1->m_c0;
    for (ii = 0; ii < (size_t)4; ii++) b[ii] = *((btVector3 *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Tetra_1c0_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Tetra *arg1 = (btSoftBody::Tetra *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Tetra **)&jarg1; 
  result = (btVector3 *)(btVector3 *) ((arg1)->m_c0);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Tetra_1c1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Tetra *arg1 = (btSoftBody::Tetra *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Tetra **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_c1 = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Tetra_1c1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Tetra *arg1 = (btSoftBody::Tetra *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Tetra **)&jarg1; 
  result = (btScalar) ((arg1)->m_c1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Tetra_1c2_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Tetra *arg1 = (btSoftBody::Tetra *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Tetra **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_c2 = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Tetra_1c2_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Tetra *arg1 = (btSoftBody::Tetra *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Tetra **)&jarg1; 
  result = (btScalar) ((arg1)->m_c2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1Tetra(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::Tetra *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::Tetra *)new btSoftBody::Tetra();
  *(btSoftBody::Tetra **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1Tetra(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::Tetra *arg1 = (btSoftBody::Tetra *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::Tetra **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RContact_1cti_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::RContact *arg1 = (btSoftBody::RContact *) 0 ;
  btSoftBody::sCti *arg2 = (btSoftBody::sCti *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::RContact **)&jarg1; 
  arg2 = *(btSoftBody::sCti **)&jarg2; 
  if (arg1) (arg1)->m_cti = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RContact_1cti_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::RContact *arg1 = (btSoftBody::RContact *) 0 ;
  btSoftBody::sCti *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::RContact **)&jarg1; 
  result = (btSoftBody::sCti *)& ((arg1)->m_cti);
  *(btSoftBody::sCti **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RContact_1node_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::RContact *arg1 = (btSoftBody::RContact *) 0 ;
  btSoftBody::Node *arg2 = (btSoftBody::Node *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::RContact **)&jarg1; 
  arg2 = *(btSoftBody::Node **)&jarg2; 
  if (arg1) (arg1)->m_node = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RContact_1node_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::RContact *arg1 = (btSoftBody::RContact *) 0 ;
  btSoftBody::Node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::RContact **)&jarg1; 
  result = (btSoftBody::Node *) ((arg1)->m_node);
  *(btSoftBody::Node **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RContact_1c0_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::RContact *arg1 = (btSoftBody::RContact *) 0 ;
  btMatrix3x3 *arg2 = (btMatrix3x3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::RContact **)&jarg1; 
  arg2 = *(btMatrix3x3 **)&jarg2; 
  if (arg1) (arg1)->m_c0 = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RContact_1c0_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::RContact *arg1 = (btSoftBody::RContact *) 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::RContact **)&jarg1; 
  result = (btMatrix3x3 *)& ((arg1)->m_c0);
  *(btMatrix3x3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RContact_1c1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::RContact *arg1 = (btSoftBody::RContact *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::RContact **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_c1 = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RContact_1c1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::RContact *arg1 = (btSoftBody::RContact *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::RContact **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_c1);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RContact_1c2_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::RContact *arg1 = (btSoftBody::RContact *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::RContact **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_c2 = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RContact_1c2_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::RContact *arg1 = (btSoftBody::RContact *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::RContact **)&jarg1; 
  result = (btScalar) ((arg1)->m_c2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RContact_1c3_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::RContact *arg1 = (btSoftBody::RContact *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::RContact **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_c3 = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RContact_1c3_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::RContact *arg1 = (btSoftBody::RContact *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::RContact **)&jarg1; 
  result = (btScalar) ((arg1)->m_c3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RContact_1c4_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::RContact *arg1 = (btSoftBody::RContact *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::RContact **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_c4 = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RContact_1c4_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::RContact *arg1 = (btSoftBody::RContact *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::RContact **)&jarg1; 
  result = (btScalar) ((arg1)->m_c4);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1RContact(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::RContact *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::RContact *)new btSoftBody::RContact();
  *(btSoftBody::RContact **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1RContact(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::RContact *arg1 = (btSoftBody::RContact *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::RContact **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SContact_1node_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::SContact *arg1 = (btSoftBody::SContact *) 0 ;
  btSoftBody::Node *arg2 = (btSoftBody::Node *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::SContact **)&jarg1; 
  arg2 = *(btSoftBody::Node **)&jarg2; 
  if (arg1) (arg1)->m_node = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SContact_1node_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::SContact *arg1 = (btSoftBody::SContact *) 0 ;
  btSoftBody::Node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::SContact **)&jarg1; 
  result = (btSoftBody::Node *) ((arg1)->m_node);
  *(btSoftBody::Node **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SContact_1face_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::SContact *arg1 = (btSoftBody::SContact *) 0 ;
  btSoftBody::Face *arg2 = (btSoftBody::Face *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::SContact **)&jarg1; 
  arg2 = *(btSoftBody::Face **)&jarg2; 
  if (arg1) (arg1)->m_face = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SContact_1face_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::SContact *arg1 = (btSoftBody::SContact *) 0 ;
  btSoftBody::Face *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::SContact **)&jarg1; 
  result = (btSoftBody::Face *) ((arg1)->m_face);
  *(btSoftBody::Face **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SContact_1weights_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::SContact *arg1 = (btSoftBody::SContact *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::SContact **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_weights = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SContact_1weights_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::SContact *arg1 = (btSoftBody::SContact *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::SContact **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_weights);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SContact_1normal_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::SContact *arg1 = (btSoftBody::SContact *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::SContact **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_normal = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SContact_1normal_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::SContact *arg1 = (btSoftBody::SContact *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::SContact **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_normal);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SContact_1margin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::SContact *arg1 = (btSoftBody::SContact *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::SContact **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_margin = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SContact_1margin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::SContact *arg1 = (btSoftBody::SContact *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::SContact **)&jarg1; 
  result = (btScalar) ((arg1)->m_margin);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SContact_1friction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::SContact *arg1 = (btSoftBody::SContact *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::SContact **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_friction = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SContact_1friction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::SContact *arg1 = (btSoftBody::SContact *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::SContact **)&jarg1; 
  result = (btScalar) ((arg1)->m_friction);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SContact_1cfm_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloatArray jarg2) {
  btSoftBody::SContact *arg1 = (btSoftBody::SContact *) 0 ;
  btScalar *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::SContact **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  arg2 = (float *)jenv->GetPrimitiveArrayCritical(jarg2, 0); 
  {
    size_t ii;
    btScalar *b = (btScalar *) arg1->m_cfm;
    for (ii = 0; ii < (size_t)2; ii++) b[ii] = *((btScalar *) arg2 + ii);
  }
  jenv->ReleasePrimitiveArrayCritical(jarg2, (float *)arg2, 0); 
}


SWIGEXPORT jfloatArray JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SContact_1cfm_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloatArray jresult = 0 ;
  btSoftBody::SContact *arg1 = (btSoftBody::SContact *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::SContact **)&jarg1; 
  result = (btScalar *)(btScalar *) ((arg1)->m_cfm);
  /*jresult = SWIG_JavaArrayOut##Float(jenv, (float *)result, 2);*/ 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1SContact(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::SContact *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::SContact *)new btSoftBody::SContact();
  *(btSoftBody::SContact **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1SContact(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::SContact *arg1 = (btSoftBody::SContact *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::SContact **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Anchor_1node_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Anchor *arg1 = (btSoftBody::Anchor *) 0 ;
  btSoftBody::Node *arg2 = (btSoftBody::Node *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Anchor **)&jarg1; 
  arg2 = *(btSoftBody::Node **)&jarg2; 
  if (arg1) (arg1)->m_node = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Anchor_1node_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Anchor *arg1 = (btSoftBody::Anchor *) 0 ;
  btSoftBody::Node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Anchor **)&jarg1; 
  result = (btSoftBody::Node *) ((arg1)->m_node);
  *(btSoftBody::Node **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Anchor_1local_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Anchor *arg1 = (btSoftBody::Anchor *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Anchor **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_local = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Anchor_1local_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Anchor *arg1 = (btSoftBody::Anchor *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Anchor **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_local);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Anchor_1body_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Anchor *arg1 = (btSoftBody::Anchor *) 0 ;
  btRigidBody *arg2 = (btRigidBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Anchor **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2; 
  if (arg1) (arg1)->m_body = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Anchor_1body_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Anchor *arg1 = (btSoftBody::Anchor *) 0 ;
  btRigidBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Anchor **)&jarg1; 
  result = (btRigidBody *) ((arg1)->m_body);
  *(btRigidBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Anchor_1influence_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Anchor *arg1 = (btSoftBody::Anchor *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Anchor **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_influence = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Anchor_1influence_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Anchor *arg1 = (btSoftBody::Anchor *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Anchor **)&jarg1; 
  result = (btScalar) ((arg1)->m_influence);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Anchor_1c0_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Anchor *arg1 = (btSoftBody::Anchor *) 0 ;
  btMatrix3x3 *arg2 = (btMatrix3x3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Anchor **)&jarg1; 
  arg2 = *(btMatrix3x3 **)&jarg2; 
  if (arg1) (arg1)->m_c0 = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Anchor_1c0_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Anchor *arg1 = (btSoftBody::Anchor *) 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Anchor **)&jarg1; 
  result = (btMatrix3x3 *)& ((arg1)->m_c0);
  *(btMatrix3x3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Anchor_1c1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Anchor *arg1 = (btSoftBody::Anchor *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Anchor **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_c1 = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Anchor_1c1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Anchor *arg1 = (btSoftBody::Anchor *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Anchor **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_c1);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Anchor_1c2_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Anchor *arg1 = (btSoftBody::Anchor *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Anchor **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_c2 = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Anchor_1c2_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Anchor *arg1 = (btSoftBody::Anchor *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Anchor **)&jarg1; 
  result = (btScalar) ((arg1)->m_c2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1Anchor(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::Anchor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::Anchor *)new btSoftBody::Anchor();
  *(btSoftBody::Anchor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1Anchor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::Anchor *arg1 = (btSoftBody::Anchor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::Anchor **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Note_1text_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btSoftBody::Note *arg1 = (btSoftBody::Note *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Note **)&jarg1; 
  result = (char *) ((arg1)->m_text);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Note_1offset_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Note *arg1 = (btSoftBody::Note *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Note **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_offset = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Note_1offset_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Note *arg1 = (btSoftBody::Note *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Note **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_offset);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Note_1rank_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody::Note *arg1 = (btSoftBody::Note *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Note **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_rank = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Note_1rank_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody::Note *arg1 = (btSoftBody::Note *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Note **)&jarg1; 
  result = (int) ((arg1)->m_rank);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Note_1nodes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody::Note *arg1 = (btSoftBody::Note *) 0 ;
  btSoftBody::Node **arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Note **)&jarg1; 
  arg2 = *(btSoftBody::Node ***)&jarg2; 
  {
    size_t ii;
    btSoftBody::Node * *b = (btSoftBody::Node * *) arg1->m_nodes;
    for (ii = 0; ii < (size_t)4; ii++) b[ii] = *((btSoftBody::Node * *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Note_1nodes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Note *arg1 = (btSoftBody::Note *) 0 ;
  btSoftBody::Node **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Note **)&jarg1; 
  result = (btSoftBody::Node **)(btSoftBody::Node **) ((arg1)->m_nodes);
  *(btSoftBody::Node ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Note_1coords_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloatArray jarg2) {
  btSoftBody::Note *arg1 = (btSoftBody::Note *) 0 ;
  btScalar *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Note **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  arg2 = (float *)jenv->GetPrimitiveArrayCritical(jarg2, 0); 
  {
    size_t ii;
    btScalar *b = (btScalar *) arg1->m_coords;
    for (ii = 0; ii < (size_t)4; ii++) b[ii] = *((btScalar *) arg2 + ii);
  }
  jenv->ReleasePrimitiveArrayCritical(jarg2, (float *)arg2, 0); 
}


SWIGEXPORT jfloatArray JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Note_1coords_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloatArray jresult = 0 ;
  btSoftBody::Note *arg1 = (btSoftBody::Note *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Note **)&jarg1; 
  result = (btScalar *)(btScalar *) ((arg1)->m_coords);
  /*jresult = SWIG_JavaArrayOut##Float(jenv, (float *)result, 4);*/ 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1Note(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::Note *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::Note *)new btSoftBody::Note();
  *(btSoftBody::Note **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1Note(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::Note *arg1 = (btSoftBody::Note *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::Note **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Pose_1bvolume_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btSoftBody::Pose *arg1 = (btSoftBody::Pose *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Pose **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_bvolume = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Pose_1bvolume_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btSoftBody::Pose *arg1 = (btSoftBody::Pose *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Pose **)&jarg1; 
  result = (bool) ((arg1)->m_bvolume);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Pose_1bframe_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btSoftBody::Pose *arg1 = (btSoftBody::Pose *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Pose **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_bframe = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Pose_1bframe_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btSoftBody::Pose *arg1 = (btSoftBody::Pose *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Pose **)&jarg1; 
  result = (bool) ((arg1)->m_bframe);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Pose_1volume_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Pose *arg1 = (btSoftBody::Pose *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Pose **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_volume = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Pose_1volume_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Pose *arg1 = (btSoftBody::Pose *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Pose **)&jarg1; 
  result = (btScalar) ((arg1)->m_volume);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Pose_1pos_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Pose *arg1 = (btSoftBody::Pose *) 0 ;
  btSoftBody::tVector3Array *arg2 = (btSoftBody::tVector3Array *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Pose **)&jarg1; 
  arg2 = *(btSoftBody::tVector3Array **)&jarg2; 
  if (arg1) (arg1)->m_pos = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Pose_1pos_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Pose *arg1 = (btSoftBody::Pose *) 0 ;
  btSoftBody::tVector3Array *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Pose **)&jarg1; 
  result = (btSoftBody::tVector3Array *)& ((arg1)->m_pos);
  *(btSoftBody::tVector3Array **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Pose_1wgh_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Pose *arg1 = (btSoftBody::Pose *) 0 ;
  btSoftBody::tScalarArray *arg2 = (btSoftBody::tScalarArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Pose **)&jarg1; 
  arg2 = *(btSoftBody::tScalarArray **)&jarg2; 
  if (arg1) (arg1)->m_wgh = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Pose_1wgh_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Pose *arg1 = (btSoftBody::Pose *) 0 ;
  btSoftBody::tScalarArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Pose **)&jarg1; 
  result = (btSoftBody::tScalarArray *)& ((arg1)->m_wgh);
  *(btSoftBody::tScalarArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Pose_1com_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Pose *arg1 = (btSoftBody::Pose *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Pose **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_com = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Pose_1com_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Pose *arg1 = (btSoftBody::Pose *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Pose **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_com);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Pose_1rot_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Pose *arg1 = (btSoftBody::Pose *) 0 ;
  btMatrix3x3 *arg2 = (btMatrix3x3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Pose **)&jarg1; 
  arg2 = *(btMatrix3x3 **)&jarg2; 
  if (arg1) (arg1)->m_rot = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Pose_1rot_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Pose *arg1 = (btSoftBody::Pose *) 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Pose **)&jarg1; 
  result = (btMatrix3x3 *)& ((arg1)->m_rot);
  *(btMatrix3x3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Pose_1scl_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Pose *arg1 = (btSoftBody::Pose *) 0 ;
  btMatrix3x3 *arg2 = (btMatrix3x3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Pose **)&jarg1; 
  arg2 = *(btMatrix3x3 **)&jarg2; 
  if (arg1) (arg1)->m_scl = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Pose_1scl_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Pose *arg1 = (btSoftBody::Pose *) 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Pose **)&jarg1; 
  result = (btMatrix3x3 *)& ((arg1)->m_scl);
  *(btMatrix3x3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Pose_1aqq_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Pose *arg1 = (btSoftBody::Pose *) 0 ;
  btMatrix3x3 *arg2 = (btMatrix3x3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Pose **)&jarg1; 
  arg2 = *(btMatrix3x3 **)&jarg2; 
  if (arg1) (arg1)->m_aqq = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Pose_1aqq_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Pose *arg1 = (btSoftBody::Pose *) 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Pose **)&jarg1; 
  result = (btMatrix3x3 *)& ((arg1)->m_aqq);
  *(btMatrix3x3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1Pose(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::Pose *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::Pose *)new btSoftBody::Pose();
  *(btSoftBody::Pose **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1Pose(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::Pose *arg1 = (btSoftBody::Pose *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::Pose **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1masses_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btSoftBody::tScalarArray *arg2 = (btSoftBody::tScalarArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = *(btSoftBody::tScalarArray **)&jarg2; 
  if (arg1) (arg1)->m_masses = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1masses_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btSoftBody::tScalarArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (btSoftBody::tScalarArray *)& ((arg1)->m_masses);
  *(btSoftBody::tScalarArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1nodes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btAlignedObjectArray< btSoftBody::Node * > *arg2 = (btAlignedObjectArray< btSoftBody::Node * > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = *(btAlignedObjectArray< btSoftBody::Node * > **)&jarg2; 
  if (arg1) (arg1)->m_nodes = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1nodes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btAlignedObjectArray< btSoftBody::Node * > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (btAlignedObjectArray< btSoftBody::Node * > *)& ((arg1)->m_nodes);
  *(btAlignedObjectArray< btSoftBody::Node * > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1framerefs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btSoftBody::tVector3Array *arg2 = (btSoftBody::tVector3Array *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = *(btSoftBody::tVector3Array **)&jarg2; 
  if (arg1) (arg1)->m_framerefs = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1framerefs_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btSoftBody::tVector3Array *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (btSoftBody::tVector3Array *)& ((arg1)->m_framerefs);
  *(btSoftBody::tVector3Array **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1framexform_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btTransform *arg2 = (btTransform *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = *(btTransform **)&jarg2; 
  if (arg1) (arg1)->m_framexform = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1framexform_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (btTransform *)& ((arg1)->m_framexform);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1idmass_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_idmass = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1idmass_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (btScalar) ((arg1)->m_idmass);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1imass_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_imass = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1imass_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (btScalar) ((arg1)->m_imass);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1locii_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btMatrix3x3 *arg2 = (btMatrix3x3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = *(btMatrix3x3 **)&jarg2; 
  if (arg1) (arg1)->m_locii = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1locii_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (btMatrix3x3 *)& ((arg1)->m_locii);
  *(btMatrix3x3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1invwi_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btMatrix3x3 *arg2 = (btMatrix3x3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = *(btMatrix3x3 **)&jarg2; 
  if (arg1) (arg1)->m_invwi = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1invwi_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (btMatrix3x3 *)& ((arg1)->m_invwi);
  *(btMatrix3x3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1com_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_com = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1com_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_com);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1vimpulses_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btVector3 *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  {
    size_t ii;
    btVector3 *b = (btVector3 *) arg1->m_vimpulses;
    for (ii = 0; ii < (size_t)2; ii++) b[ii] = *((btVector3 *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1vimpulses_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (btVector3 *)(btVector3 *) ((arg1)->m_vimpulses);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1dimpulses_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btVector3 *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  {
    size_t ii;
    btVector3 *b = (btVector3 *) arg1->m_dimpulses;
    for (ii = 0; ii < (size_t)2; ii++) b[ii] = *((btVector3 *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1dimpulses_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (btVector3 *)(btVector3 *) ((arg1)->m_dimpulses);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1nvimpulses_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_nvimpulses = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1nvimpulses_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (int) ((arg1)->m_nvimpulses);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1ndimpulses_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_ndimpulses = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1ndimpulses_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (int) ((arg1)->m_ndimpulses);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1lv_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_lv = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1lv_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_lv);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1av_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_av = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1av_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_av);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1leaf_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btDbvtNode *arg2 = (btDbvtNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = *(btDbvtNode **)&jarg2; 
  if (arg1) (arg1)->m_leaf = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1leaf_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btDbvtNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (btDbvtNode *) ((arg1)->m_leaf);
  *(btDbvtNode **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1ndamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_ndamping = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1ndamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (btScalar) ((arg1)->m_ndamping);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1ldamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_ldamping = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1ldamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (btScalar) ((arg1)->m_ldamping);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1adamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_adamping = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1adamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (btScalar) ((arg1)->m_adamping);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1matching_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_matching = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1matching_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (btScalar) ((arg1)->m_matching);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1maxSelfCollisionImpulse_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_maxSelfCollisionImpulse = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1maxSelfCollisionImpulse_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (btScalar) ((arg1)->m_maxSelfCollisionImpulse);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1selfCollisionImpulseFactor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_selfCollisionImpulseFactor = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1selfCollisionImpulseFactor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (btScalar) ((arg1)->m_selfCollisionImpulseFactor);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1containsAnchor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_containsAnchor = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1containsAnchor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (bool) ((arg1)->m_containsAnchor);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1collide_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_collide = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1collide_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (bool) ((arg1)->m_collide);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1clusterIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_clusterIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Cluster_1clusterIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (int) ((arg1)->m_clusterIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1Cluster(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::Cluster *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::Cluster *)new btSoftBody::Cluster();
  *(btSoftBody::Cluster **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1Cluster(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Impulse_1velocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Impulse *arg1 = (btSoftBody::Impulse *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Impulse **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_velocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Impulse_1velocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Impulse *arg1 = (btSoftBody::Impulse *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Impulse **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_velocity);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Impulse_1drift_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Impulse *arg1 = (btSoftBody::Impulse *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Impulse **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_drift = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Impulse_1drift_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Impulse *arg1 = (btSoftBody::Impulse *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Impulse **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_drift);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Impulse_1asVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody::Impulse *arg1 = (btSoftBody::Impulse *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Impulse **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_asVelocity = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Impulse_1asVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody::Impulse *arg1 = (btSoftBody::Impulse *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Impulse **)&jarg1; 
  result = (int) ((arg1)->m_asVelocity);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Impulse_1asDrift_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody::Impulse *arg1 = (btSoftBody::Impulse *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Impulse **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_asDrift = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Impulse_1asDrift_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody::Impulse *arg1 = (btSoftBody::Impulse *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Impulse **)&jarg1; 
  result = (int) ((arg1)->m_asDrift);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1Impulse(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::Impulse *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::Impulse *)new btSoftBody::Impulse();
  *(btSoftBody::Impulse **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Impulse_1operatorSubtraction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Impulse *arg1 = (btSoftBody::Impulse *) 0 ;
  btSoftBody::Impulse result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Impulse **)&jarg1; 
  result = ((btSoftBody::Impulse const *)arg1)->operator -();
  *(btSoftBody::Impulse **)&jresult = new btSoftBody::Impulse((const btSoftBody::Impulse &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Impulse_1operatorMultiplication(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jlong jresult = 0 ;
  btSoftBody::Impulse *arg1 = (btSoftBody::Impulse *) 0 ;
  btScalar arg2 ;
  btSoftBody::Impulse result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Impulse **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  result = ((btSoftBody::Impulse const *)arg1)->operator *(arg2);
  *(btSoftBody::Impulse **)&jresult = new btSoftBody::Impulse((const btSoftBody::Impulse &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1Impulse(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::Impulse *arg1 = (btSoftBody::Impulse *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::Impulse **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Body_1soft_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Body *arg1 = (btSoftBody::Body *) 0 ;
  btSoftBody::Cluster *arg2 = (btSoftBody::Cluster *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Body **)&jarg1; 
  arg2 = *(btSoftBody::Cluster **)&jarg2; 
  if (arg1) (arg1)->m_soft = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Body_1soft_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Body *arg1 = (btSoftBody::Body *) 0 ;
  btSoftBody::Cluster *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Body **)&jarg1; 
  result = (btSoftBody::Cluster *) ((arg1)->m_soft);
  *(btSoftBody::Cluster **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Body_1rigid_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Body *arg1 = (btSoftBody::Body *) 0 ;
  btRigidBody *arg2 = (btRigidBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Body **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2; 
  if (arg1) (arg1)->m_rigid = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Body_1rigid_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Body *arg1 = (btSoftBody::Body *) 0 ;
  btRigidBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Body **)&jarg1; 
  result = (btRigidBody *) ((arg1)->m_rigid);
  *(btRigidBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Body_1collisionObject_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Body *arg1 = (btSoftBody::Body *) 0 ;
  btCollisionObject *arg2 = (btCollisionObject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Body **)&jarg1; 
  arg2 = *(btCollisionObject **)&jarg2; 
  if (arg1) (arg1)->m_collisionObject = (btCollisionObject const *)arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Body_1collisionObject_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Body *arg1 = (btSoftBody::Body *) 0 ;
  btCollisionObject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Body **)&jarg1; 
  result = (btCollisionObject *) ((arg1)->m_collisionObject);
  *(btCollisionObject **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1Body_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::Body *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::Body *)new btSoftBody::Body();
  *(btSoftBody::Body **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1Body_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btSoftBody::Body *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (btSoftBody::Body *)new btSoftBody::Body(arg1);
  *(btSoftBody::Body **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1Body_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btSoftBody::Body *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (btSoftBody::Body *)new btSoftBody::Body((btCollisionObject const *)arg1);
  *(btSoftBody::Body **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Body_1activate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody::Body *arg1 = (btSoftBody::Body *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Body **)&jarg1; 
  ((btSoftBody::Body const *)arg1)->activate();
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Body_1invWorldInertia(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSoftBody::Body *arg1 = (btSoftBody::Body *) 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Body **)&jarg1; 
  result = (btMatrix3x3 *) &((btSoftBody::Body const *)arg1)->invWorldInertia();
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Body_1invMass(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Body *arg1 = (btSoftBody::Body *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Body **)&jarg1; 
  result = (btScalar)((btSoftBody::Body const *)arg1)->invMass();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Body_1xform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSoftBody::Body *arg1 = (btSoftBody::Body *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Body **)&jarg1; 
  result = (btTransform *) &((btSoftBody::Body const *)arg1)->xform();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Body_1linearVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSoftBody::Body *arg1 = (btSoftBody::Body *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Body **)&jarg1; 
  result = ((btSoftBody::Body const *)arg1)->linearVelocity();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Body_1angularVelocity_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btSoftBody::Body *arg1 = (btSoftBody::Body *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Body **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btSoftBody::Body const *)arg1)->angularVelocity((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Body_1angularVelocity_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSoftBody::Body *arg1 = (btSoftBody::Body *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Body **)&jarg1; 
  result = ((btSoftBody::Body const *)arg1)->angularVelocity();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Body_1velocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btSoftBody::Body *arg1 = (btSoftBody::Body *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Body **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btSoftBody::Body const *)arg1)->velocity((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Body_1applyVImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btSoftBody::Body *arg1 = (btSoftBody::Body *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Body **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  ((btSoftBody::Body const *)arg1)->applyVImpulse((btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Body_1applyDImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btSoftBody::Body *arg1 = (btSoftBody::Body *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Body **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  ((btSoftBody::Body const *)arg1)->applyDImpulse((btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Body_1applyImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  btSoftBody::Body *arg1 = (btSoftBody::Body *) 0 ;
  btSoftBody::Impulse *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Body **)&jarg1; 
  arg2 = *(btSoftBody::Impulse **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBody::Impulse const & reference is null");
    return ;
  } 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  ((btSoftBody::Body const *)arg1)->applyImpulse((btSoftBody::Impulse const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Body_1applyVAImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSoftBody::Body *arg1 = (btSoftBody::Body *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Body **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  ((btSoftBody::Body const *)arg1)->applyVAImpulse((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Body_1applyDAImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSoftBody::Body *arg1 = (btSoftBody::Body *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Body **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  ((btSoftBody::Body const *)arg1)->applyDAImpulse((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Body_1applyAImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Body *arg1 = (btSoftBody::Body *) 0 ;
  btSoftBody::Impulse *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Body **)&jarg1; 
  arg2 = *(btSoftBody::Impulse **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBody::Impulse const & reference is null");
    return ;
  } 
  ((btSoftBody::Body const *)arg1)->applyAImpulse((btSoftBody::Impulse const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Body_1applyDCImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSoftBody::Body *arg1 = (btSoftBody::Body *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Body **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  ((btSoftBody::Body const *)arg1)->applyDCImpulse((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1Body(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::Body *arg1 = (btSoftBody::Body *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::Body **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1Joint_1eType(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::Joint::eType *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::Joint::eType *)new btSoftBody::Joint::eType();
  *(btSoftBody::Joint::eType **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1Joint_1eType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::Joint::eType *arg1 = (btSoftBody::Joint::eType *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::Joint::eType **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1Joint_1Specs(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::Joint::Specs *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::Joint::Specs *)new btSoftBody::Joint::Specs();
  *(btSoftBody::Joint::Specs **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1Specs_1erp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Joint::Specs *arg1 = (btSoftBody::Joint::Specs *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint::Specs **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->erp = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1Specs_1erp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Joint::Specs *arg1 = (btSoftBody::Joint::Specs *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint::Specs **)&jarg1; 
  result = (btScalar) ((arg1)->erp);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1Specs_1cfm_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Joint::Specs *arg1 = (btSoftBody::Joint::Specs *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint::Specs **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->cfm = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1Specs_1cfm_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Joint::Specs *arg1 = (btSoftBody::Joint::Specs *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint::Specs **)&jarg1; 
  result = (btScalar) ((arg1)->cfm);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1Specs_1split_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Joint::Specs *arg1 = (btSoftBody::Joint::Specs *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint::Specs **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->split = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1Specs_1split_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Joint::Specs *arg1 = (btSoftBody::Joint::Specs *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint::Specs **)&jarg1; 
  result = (btScalar) ((arg1)->split);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1Joint_1Specs(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::Joint::Specs *arg1 = (btSoftBody::Joint::Specs *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::Joint::Specs **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1bodies_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  btSoftBody::Body *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  arg2 = *(btSoftBody::Body **)&jarg2; 
  {
    size_t ii;
    btSoftBody::Body *b = (btSoftBody::Body *) arg1->m_bodies;
    for (ii = 0; ii < (size_t)2; ii++) b[ii] = *((btSoftBody::Body *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1bodies_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  btSoftBody::Body *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  result = (btSoftBody::Body *)(btSoftBody::Body *) ((arg1)->m_bodies);
  *(btSoftBody::Body **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1refs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  btVector3 *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  {
    size_t ii;
    btVector3 *b = (btVector3 *) arg1->m_refs;
    for (ii = 0; ii < (size_t)2; ii++) b[ii] = *((btVector3 *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1refs_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  result = (btVector3 *)(btVector3 *) ((arg1)->m_refs);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1cfm_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_cfm = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1cfm_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  result = (btScalar) ((arg1)->m_cfm);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1erp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_erp = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1erp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  result = (btScalar) ((arg1)->m_erp);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1split_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_split = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1split_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  result = (btScalar) ((arg1)->m_split);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1drift_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_drift = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1drift_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_drift);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1sdrift_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_sdrift = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1sdrift_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_sdrift);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1massmatrix_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  btMatrix3x3 *arg2 = (btMatrix3x3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  arg2 = *(btMatrix3x3 **)&jarg2; 
  if (arg1) (arg1)->m_massmatrix = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1massmatrix_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  result = (btMatrix3x3 *)& ((arg1)->m_massmatrix);
  *(btMatrix3x3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1delete_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_delete = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1delete_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  result = (bool) ((arg1)->m_delete);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1Joint(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1Prepare(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jint jarg3) {
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  btScalar arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->Prepare(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1Solve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->Solve(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1Terminate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->Terminate(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Joint_1Type(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody::Joint *arg1 = (btSoftBody::Joint *) 0 ;
  btSoftBody::Joint::eType::_ result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Joint **)&jarg1; 
  result = (btSoftBody::Joint::eType::_)((btSoftBody::Joint const *)arg1)->Type();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1LJoint_1Specs_1position_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::LJoint::Specs *arg1 = (btSoftBody::LJoint::Specs *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::LJoint::Specs **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->position = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1LJoint_1Specs_1position_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::LJoint::Specs *arg1 = (btSoftBody::LJoint::Specs *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::LJoint::Specs **)&jarg1; 
  result = (btVector3 *)& ((arg1)->position);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1LJoint_1Specs(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::LJoint::Specs *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::LJoint::Specs *)new btSoftBody::LJoint::Specs();
  *(btSoftBody::LJoint::Specs **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1LJoint_1Specs(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::LJoint::Specs *arg1 = (btSoftBody::LJoint::Specs *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::LJoint::Specs **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1LJoint_1rpos_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::LJoint *arg1 = (btSoftBody::LJoint *) 0 ;
  btVector3 *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::LJoint **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  {
    size_t ii;
    btVector3 *b = (btVector3 *) arg1->m_rpos;
    for (ii = 0; ii < (size_t)2; ii++) b[ii] = *((btVector3 *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1LJoint_1rpos_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::LJoint *arg1 = (btSoftBody::LJoint *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::LJoint **)&jarg1; 
  result = (btVector3 *)(btVector3 *) ((arg1)->m_rpos);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1LJoint(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::LJoint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::LJoint *)new btSoftBody::LJoint();
  *(btSoftBody::LJoint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1LJoint(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::LJoint *arg1 = (btSoftBody::LJoint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::LJoint **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1AJoint_1IControl(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::AJoint::IControl *arg1 = (btSoftBody::AJoint::IControl *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::AJoint::IControl **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1AJoint_1IControl_1Prepare(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::AJoint::IControl *arg1 = (btSoftBody::AJoint::IControl *) 0 ;
  btSoftBody::AJoint *arg2 = (btSoftBody::AJoint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::AJoint::IControl **)&jarg1; 
  arg2 = *(btSoftBody::AJoint **)&jarg2; 
  (arg1)->Prepare(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1AJoint_1IControl_1Speed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3) {
  jfloat jresult = 0 ;
  btSoftBody::AJoint::IControl *arg1 = (btSoftBody::AJoint::IControl *) 0 ;
  btSoftBody::AJoint *arg2 = (btSoftBody::AJoint *) 0 ;
  btScalar arg3 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::AJoint::IControl **)&jarg1; 
  arg2 = *(btSoftBody::AJoint **)&jarg2; 
  arg3 = (btScalar)jarg3; 
  result = (btScalar)(arg1)->Speed(arg2,arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1AJoint_1IControl_1Default(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::AJoint::IControl *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::AJoint::IControl *)btSoftBody::AJoint::IControl::Default();
  *(btSoftBody::AJoint::IControl **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1AJoint_1IControl(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::AJoint::IControl *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::AJoint::IControl *)new btSoftBody::AJoint::IControl();
  *(btSoftBody::AJoint::IControl **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1AJoint_1Specs(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::AJoint::Specs *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::AJoint::Specs *)new btSoftBody::AJoint::Specs();
  *(btSoftBody::AJoint::Specs **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1AJoint_1Specs_1axis_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::AJoint::Specs *arg1 = (btSoftBody::AJoint::Specs *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::AJoint::Specs **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->axis = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1AJoint_1Specs_1axis_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::AJoint::Specs *arg1 = (btSoftBody::AJoint::Specs *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::AJoint::Specs **)&jarg1; 
  result = (btVector3 *)& ((arg1)->axis);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1AJoint_1Specs_1icontrol_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::AJoint::Specs *arg1 = (btSoftBody::AJoint::Specs *) 0 ;
  btSoftBody::AJoint::IControl *arg2 = (btSoftBody::AJoint::IControl *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::AJoint::Specs **)&jarg1; 
  arg2 = *(btSoftBody::AJoint::IControl **)&jarg2; 
  if (arg1) (arg1)->icontrol = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1AJoint_1Specs_1icontrol_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::AJoint::Specs *arg1 = (btSoftBody::AJoint::Specs *) 0 ;
  btSoftBody::AJoint::IControl *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::AJoint::Specs **)&jarg1; 
  result = (btSoftBody::AJoint::IControl *) ((arg1)->icontrol);
  *(btSoftBody::AJoint::IControl **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1AJoint_1Specs(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::AJoint::Specs *arg1 = (btSoftBody::AJoint::Specs *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::AJoint::Specs **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1AJoint_1axis_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::AJoint *arg1 = (btSoftBody::AJoint *) 0 ;
  btVector3 *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::AJoint **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  {
    size_t ii;
    btVector3 *b = (btVector3 *) arg1->m_axis;
    for (ii = 0; ii < (size_t)2; ii++) b[ii] = *((btVector3 *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1AJoint_1axis_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::AJoint *arg1 = (btSoftBody::AJoint *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::AJoint **)&jarg1; 
  result = (btVector3 *)(btVector3 *) ((arg1)->m_axis);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1AJoint_1icontrol_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::AJoint *arg1 = (btSoftBody::AJoint *) 0 ;
  btSoftBody::AJoint::IControl *arg2 = (btSoftBody::AJoint::IControl *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::AJoint **)&jarg1; 
  arg2 = *(btSoftBody::AJoint::IControl **)&jarg2; 
  if (arg1) (arg1)->m_icontrol = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1AJoint_1icontrol_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::AJoint *arg1 = (btSoftBody::AJoint *) 0 ;
  btSoftBody::AJoint::IControl *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::AJoint **)&jarg1; 
  result = (btSoftBody::AJoint::IControl *) ((arg1)->m_icontrol);
  *(btSoftBody::AJoint::IControl **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1AJoint(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::AJoint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::AJoint *)new btSoftBody::AJoint();
  *(btSoftBody::AJoint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1AJoint(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::AJoint *arg1 = (btSoftBody::AJoint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::AJoint **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1CJoint_1life_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody::CJoint *arg1 = (btSoftBody::CJoint *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::CJoint **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_life = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1CJoint_1life_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody::CJoint *arg1 = (btSoftBody::CJoint *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::CJoint **)&jarg1; 
  result = (int) ((arg1)->m_life);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1CJoint_1maxlife_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody::CJoint *arg1 = (btSoftBody::CJoint *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::CJoint **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_maxlife = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1CJoint_1maxlife_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody::CJoint *arg1 = (btSoftBody::CJoint *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::CJoint **)&jarg1; 
  result = (int) ((arg1)->m_maxlife);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1CJoint_1rpos_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::CJoint *arg1 = (btSoftBody::CJoint *) 0 ;
  btVector3 *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::CJoint **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  {
    size_t ii;
    btVector3 *b = (btVector3 *) arg1->m_rpos;
    for (ii = 0; ii < (size_t)2; ii++) b[ii] = *((btVector3 *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1CJoint_1rpos_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::CJoint *arg1 = (btSoftBody::CJoint *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::CJoint **)&jarg1; 
  result = (btVector3 *)(btVector3 *) ((arg1)->m_rpos);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1CJoint_1normal_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::CJoint *arg1 = (btSoftBody::CJoint *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::CJoint **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_normal = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1CJoint_1normal_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::CJoint *arg1 = (btSoftBody::CJoint *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::CJoint **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_normal);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1CJoint_1friction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::CJoint *arg1 = (btSoftBody::CJoint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::CJoint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_friction = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1CJoint_1friction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::CJoint *arg1 = (btSoftBody::CJoint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::CJoint **)&jarg1; 
  result = (btScalar) ((arg1)->m_friction);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1CJoint(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::CJoint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::CJoint *)new btSoftBody::CJoint();
  *(btSoftBody::CJoint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1CJoint(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::CJoint *arg1 = (btSoftBody::CJoint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::CJoint **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1aeromodel_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btSoftBody::eAeroModel::_ arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (btSoftBody::eAeroModel::_)jarg2; 
  if (arg1) (arg1)->aeromodel = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1aeromodel_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btSoftBody::eAeroModel::_ result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btSoftBody::eAeroModel::_) ((arg1)->aeromodel);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kVCF_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->kVCF = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kVCF_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btScalar) ((arg1)->kVCF);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kDP_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->kDP = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kDP_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btScalar) ((arg1)->kDP);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kDG_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->kDG = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kDG_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btScalar) ((arg1)->kDG);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kLF_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->kLF = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kLF_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btScalar) ((arg1)->kLF);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kPR_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->kPR = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kPR_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btScalar) ((arg1)->kPR);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kVC_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->kVC = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kVC_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btScalar) ((arg1)->kVC);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kDF_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->kDF = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kDF_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btScalar) ((arg1)->kDF);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kMT_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->kMT = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kMT_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btScalar) ((arg1)->kMT);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kCHR_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->kCHR = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kCHR_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btScalar) ((arg1)->kCHR);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kKHR_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->kKHR = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kKHR_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btScalar) ((arg1)->kKHR);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kSHR_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->kSHR = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kSHR_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btScalar) ((arg1)->kSHR);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kAHR_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->kAHR = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kAHR_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btScalar) ((arg1)->kAHR);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kSRHR_1CL_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->kSRHR_CL = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kSRHR_1CL_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btScalar) ((arg1)->kSRHR_CL);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kSKHR_1CL_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->kSKHR_CL = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kSKHR_1CL_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btScalar) ((arg1)->kSKHR_CL);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kSSHR_1CL_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->kSSHR_CL = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kSSHR_1CL_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btScalar) ((arg1)->kSSHR_CL);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kSR_1SPLT_1CL_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->kSR_SPLT_CL = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kSR_1SPLT_1CL_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btScalar) ((arg1)->kSR_SPLT_CL);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kSK_1SPLT_1CL_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->kSK_SPLT_CL = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kSK_1SPLT_1CL_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btScalar) ((arg1)->kSK_SPLT_CL);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kSS_1SPLT_1CL_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->kSS_SPLT_CL = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1kSS_1SPLT_1CL_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btScalar) ((arg1)->kSS_SPLT_CL);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1maxvolume_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->maxvolume = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1maxvolume_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btScalar) ((arg1)->maxvolume);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1timescale_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->timescale = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1timescale_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btScalar) ((arg1)->timescale);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1viterations_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->viterations = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1viterations_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (int) ((arg1)->viterations);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1piterations_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->piterations = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1piterations_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (int) ((arg1)->piterations);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1diterations_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->diterations = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1diterations_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (int) ((arg1)->diterations);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1citerations_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->citerations = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1citerations_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (int) ((arg1)->citerations);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1collisions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->collisions = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1collisions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (int) ((arg1)->collisions);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1vsequence_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btSoftBody::tVSolverArray *arg2 = (btSoftBody::tVSolverArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = *(btSoftBody::tVSolverArray **)&jarg2; 
  if (arg1) (arg1)->m_vsequence = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1vsequence_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btSoftBody::tVSolverArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btSoftBody::tVSolverArray *)& ((arg1)->m_vsequence);
  *(btSoftBody::tVSolverArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1psequence_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btSoftBody::tPSolverArray *arg2 = (btSoftBody::tPSolverArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = *(btSoftBody::tPSolverArray **)&jarg2; 
  if (arg1) (arg1)->m_psequence = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1psequence_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btSoftBody::tPSolverArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btSoftBody::tPSolverArray *)& ((arg1)->m_psequence);
  *(btSoftBody::tPSolverArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1dsequence_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btSoftBody::tPSolverArray *arg2 = (btSoftBody::tPSolverArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  arg2 = *(btSoftBody::tPSolverArray **)&jarg2; 
  if (arg1) (arg1)->m_dsequence = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Config_1dsequence_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  btSoftBody::tPSolverArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  result = (btSoftBody::tPSolverArray *)& ((arg1)->m_dsequence);
  *(btSoftBody::tPSolverArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1Config(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::Config *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::Config *)new btSoftBody::Config();
  *(btSoftBody::Config **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1Config(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::Config *arg1 = (btSoftBody::Config *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::Config **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SolverState_1sdt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::SolverState *arg1 = (btSoftBody::SolverState *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::SolverState **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->sdt = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SolverState_1sdt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::SolverState *arg1 = (btSoftBody::SolverState *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::SolverState **)&jarg1; 
  result = (btScalar) ((arg1)->sdt);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SolverState_1isdt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::SolverState *arg1 = (btSoftBody::SolverState *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::SolverState **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->isdt = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SolverState_1isdt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::SolverState *arg1 = (btSoftBody::SolverState *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::SolverState **)&jarg1; 
  result = (btScalar) ((arg1)->isdt);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SolverState_1velmrg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::SolverState *arg1 = (btSoftBody::SolverState *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::SolverState **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->velmrg = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SolverState_1velmrg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::SolverState *arg1 = (btSoftBody::SolverState *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::SolverState **)&jarg1; 
  result = (btScalar) ((arg1)->velmrg);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SolverState_1radmrg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::SolverState *arg1 = (btSoftBody::SolverState *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::SolverState **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->radmrg = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SolverState_1radmrg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::SolverState *arg1 = (btSoftBody::SolverState *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::SolverState **)&jarg1; 
  result = (btScalar) ((arg1)->radmrg);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SolverState_1updmrg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::SolverState *arg1 = (btSoftBody::SolverState *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::SolverState **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->updmrg = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SolverState_1updmrg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::SolverState *arg1 = (btSoftBody::SolverState *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::SolverState **)&jarg1; 
  result = (btScalar) ((arg1)->updmrg);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1SolverState(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBody::SolverState *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBody::SolverState *)new btSoftBody::SolverState();
  *(btSoftBody::SolverState **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1SolverState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::SolverState *arg1 = (btSoftBody::SolverState *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::SolverState **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RayFromToCaster_1rayFrom_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::RayFromToCaster *arg1 = (btSoftBody::RayFromToCaster *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::RayFromToCaster **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_rayFrom = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RayFromToCaster_1rayFrom_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::RayFromToCaster *arg1 = (btSoftBody::RayFromToCaster *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::RayFromToCaster **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_rayFrom);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RayFromToCaster_1rayTo_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::RayFromToCaster *arg1 = (btSoftBody::RayFromToCaster *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::RayFromToCaster **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_rayTo = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RayFromToCaster_1rayTo_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::RayFromToCaster *arg1 = (btSoftBody::RayFromToCaster *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::RayFromToCaster **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_rayTo);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RayFromToCaster_1rayNormalizedDirection_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::RayFromToCaster *arg1 = (btSoftBody::RayFromToCaster *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::RayFromToCaster **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_rayNormalizedDirection = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RayFromToCaster_1rayNormalizedDirection_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::RayFromToCaster *arg1 = (btSoftBody::RayFromToCaster *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::RayFromToCaster **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_rayNormalizedDirection);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RayFromToCaster_1mint_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody::RayFromToCaster *arg1 = (btSoftBody::RayFromToCaster *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::RayFromToCaster **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_mint = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RayFromToCaster_1mint_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody::RayFromToCaster *arg1 = (btSoftBody::RayFromToCaster *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::RayFromToCaster **)&jarg1; 
  result = (btScalar) ((arg1)->m_mint);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RayFromToCaster_1face_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::RayFromToCaster *arg1 = (btSoftBody::RayFromToCaster *) 0 ;
  btSoftBody::Face *arg2 = (btSoftBody::Face *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::RayFromToCaster **)&jarg1; 
  arg2 = *(btSoftBody::Face **)&jarg2; 
  if (arg1) (arg1)->m_face = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RayFromToCaster_1face_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::RayFromToCaster *arg1 = (btSoftBody::RayFromToCaster *) 0 ;
  btSoftBody::Face *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::RayFromToCaster **)&jarg1; 
  result = (btSoftBody::Face *) ((arg1)->m_face);
  *(btSoftBody::Face **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RayFromToCaster_1tests_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody::RayFromToCaster *arg1 = (btSoftBody::RayFromToCaster *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::RayFromToCaster **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_tests = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RayFromToCaster_1tests_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody::RayFromToCaster *arg1 = (btSoftBody::RayFromToCaster *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::RayFromToCaster **)&jarg1; 
  result = (int) ((arg1)->m_tests);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1RayFromToCaster(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jfloat jarg3) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  btSoftBody::RayFromToCaster *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  result = (btSoftBody::RayFromToCaster *)new btSoftBody::RayFromToCaster((btVector3 const &)*arg1,(btVector3 const &)*arg2,arg3);
  *(btSoftBody::RayFromToCaster **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RayFromToCaster_1rayFromToTriangle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jobject jarg4, jobject jarg5, jobject jarg6, jfloat jarg7) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  btScalar arg7 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  arg7 = (btScalar)jarg7; 
  result = (btScalar)btSoftBody::RayFromToCaster::rayFromToTriangle((btVector3 const &)*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6,arg7);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RayFromToCaster_1rayFromToTriangle_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jobject jarg4, jobject jarg5, jobject jarg6) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  result = (btScalar)btSoftBody::RayFromToCaster::rayFromToTriangle((btVector3 const &)*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody_1RayFromToCaster(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody::RayFromToCaster *arg1 = (btSoftBody::RayFromToCaster *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody::RayFromToCaster **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1cfg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::Config *arg2 = (btSoftBody::Config *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::Config **)&jarg2; 
  if (arg1) (arg1)->m_cfg = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1cfg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::Config *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btSoftBody::Config *)& ((arg1)->m_cfg);
  *(btSoftBody::Config **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1sst_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::SolverState *arg2 = (btSoftBody::SolverState *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::SolverState **)&jarg2; 
  if (arg1) (arg1)->m_sst = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1sst_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::SolverState *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btSoftBody::SolverState *)& ((arg1)->m_sst);
  *(btSoftBody::SolverState **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1pose_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::Pose *arg2 = (btSoftBody::Pose *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::Pose **)&jarg2; 
  if (arg1) (arg1)->m_pose = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1pose_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::Pose *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btSoftBody::Pose *)& ((arg1)->m_pose);
  *(btSoftBody::Pose **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1tag_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (void *)jarg2; 
  if (arg1) (arg1)->m_tag = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1tag_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (void *) ((arg1)->m_tag);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1worldInfo_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBodyWorldInfo *arg2 = (btSoftBodyWorldInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBodyWorldInfo **)&jarg2; 
  if (arg1) (arg1)->m_worldInfo = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1worldInfo_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBodyWorldInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btSoftBodyWorldInfo *) ((arg1)->m_worldInfo);
  *(btSoftBodyWorldInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1notes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::tNoteArray *arg2 = (btSoftBody::tNoteArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::tNoteArray **)&jarg2; 
  if (arg1) (arg1)->m_notes = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1notes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::tNoteArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btSoftBody::tNoteArray *)& ((arg1)->m_notes);
  *(btSoftBody::tNoteArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1nodes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::tNodeArray *arg2 = (btSoftBody::tNodeArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::tNodeArray **)&jarg2; 
  if (arg1) (arg1)->m_nodes = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1nodes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::tNodeArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btSoftBody::tNodeArray *)& ((arg1)->m_nodes);
  *(btSoftBody::tNodeArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1links_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::tLinkArray *arg2 = (btSoftBody::tLinkArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::tLinkArray **)&jarg2; 
  if (arg1) (arg1)->m_links = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1links_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::tLinkArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btSoftBody::tLinkArray *)& ((arg1)->m_links);
  *(btSoftBody::tLinkArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1faces_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::tFaceArray *arg2 = (btSoftBody::tFaceArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::tFaceArray **)&jarg2; 
  if (arg1) (arg1)->m_faces = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1faces_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::tFaceArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btSoftBody::tFaceArray *)& ((arg1)->m_faces);
  *(btSoftBody::tFaceArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1tetras_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::tTetraArray *arg2 = (btSoftBody::tTetraArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::tTetraArray **)&jarg2; 
  if (arg1) (arg1)->m_tetras = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1tetras_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::tTetraArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btSoftBody::tTetraArray *)& ((arg1)->m_tetras);
  *(btSoftBody::tTetraArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1anchors_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::tAnchorArray *arg2 = (btSoftBody::tAnchorArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::tAnchorArray **)&jarg2; 
  if (arg1) (arg1)->m_anchors = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1anchors_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::tAnchorArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btSoftBody::tAnchorArray *)& ((arg1)->m_anchors);
  *(btSoftBody::tAnchorArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1rcontacts_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::tRContactArray *arg2 = (btSoftBody::tRContactArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::tRContactArray **)&jarg2; 
  if (arg1) (arg1)->m_rcontacts = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1rcontacts_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::tRContactArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btSoftBody::tRContactArray *)& ((arg1)->m_rcontacts);
  *(btSoftBody::tRContactArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1scontacts_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::tSContactArray *arg2 = (btSoftBody::tSContactArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::tSContactArray **)&jarg2; 
  if (arg1) (arg1)->m_scontacts = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1scontacts_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::tSContactArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btSoftBody::tSContactArray *)& ((arg1)->m_scontacts);
  *(btSoftBody::tSContactArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1joints_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::tJointArray *arg2 = (btSoftBody::tJointArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::tJointArray **)&jarg2; 
  if (arg1) (arg1)->m_joints = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1joints_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::tJointArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btSoftBody::tJointArray *)& ((arg1)->m_joints);
  *(btSoftBody::tJointArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1materials_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::tMaterialArray *arg2 = (btSoftBody::tMaterialArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::tMaterialArray **)&jarg2; 
  if (arg1) (arg1)->m_materials = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1materials_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::tMaterialArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btSoftBody::tMaterialArray *)& ((arg1)->m_materials);
  *(btSoftBody::tMaterialArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1timeacc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_timeacc = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1timeacc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btScalar) ((arg1)->m_timeacc);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1bounds_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btVector3 *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  {
    size_t ii;
    btVector3 *b = (btVector3 *) arg1->m_bounds;
    for (ii = 0; ii < (size_t)2; ii++) b[ii] = *((btVector3 *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1bounds_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btVector3 *)(btVector3 *) ((arg1)->m_bounds);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1bUpdateRtCst_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_bUpdateRtCst = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1bUpdateRtCst_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (bool) ((arg1)->m_bUpdateRtCst);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1ndbvt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btDbvt *arg2 = (btDbvt *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btDbvt **)&jarg2; 
  if (arg1) (arg1)->m_ndbvt = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1ndbvt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btDbvt *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btDbvt *)& ((arg1)->m_ndbvt);
  *(btDbvt **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1fdbvt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btDbvt *arg2 = (btDbvt *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btDbvt **)&jarg2; 
  if (arg1) (arg1)->m_fdbvt = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1fdbvt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btDbvt *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btDbvt *)& ((arg1)->m_fdbvt);
  *(btDbvt **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1cdbvt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btDbvt *arg2 = (btDbvt *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btDbvt **)&jarg2; 
  if (arg1) (arg1)->m_cdbvt = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1cdbvt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btDbvt *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btDbvt *)& ((arg1)->m_cdbvt);
  *(btDbvt **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1clusters_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::tClusterArray *arg2 = (btSoftBody::tClusterArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::tClusterArray **)&jarg2; 
  if (arg1) (arg1)->m_clusters = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1clusters_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::tClusterArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btSoftBody::tClusterArray *)& ((arg1)->m_clusters);
  *(btSoftBody::tClusterArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1clusterConnectivity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btAlignedObjectArray< bool > *arg2 = (btAlignedObjectArray< bool > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btAlignedObjectArray< bool > **)&jarg2; 
  if (arg1) (arg1)->m_clusterConnectivity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1clusterConnectivity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btAlignedObjectArray< bool > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btAlignedObjectArray< bool > *)& ((arg1)->m_clusterConnectivity);
  *(btAlignedObjectArray< bool > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1initialWorldTransform_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btTransform *arg2 = (btTransform *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btTransform **)&jarg2; 
  if (arg1) (arg1)->m_initialWorldTransform = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1initialWorldTransform_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btTransform *)& ((arg1)->m_initialWorldTransform);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1windVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_windVelocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1windVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_windVelocity);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1restLengthScale_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_restLengthScale = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1restLengthScale_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btScalar) ((arg1)->m_restLengthScale);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_, jobject jarg4) {
  jlong jresult = 0 ;
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  int arg2 ;
  btVector3 *arg3 = (btVector3 *) 0 ;
  btScalar *arg4 = (btScalar *) 0 ;
  btSoftBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(btVector3 **)&jarg3; 
  {
    arg4 = (btScalar*)jenv->GetDirectBufferAddress(jarg4);
    if (arg4 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  result = (btSoftBody *)new btSoftBody(arg1,arg2,(btVector3 const *)arg3,(btScalar const *)arg4);
  *(btSoftBody **)&jresult = result; 
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  btSoftBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  result = (btSoftBody *)new btSoftBody(arg1);
  *(btSoftBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1initDefaults(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  (arg1)->initDefaults();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBody(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1userIndexMapping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btAlignedObjectArray< int > *arg2 = (btAlignedObjectArray< int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btAlignedObjectArray< int > **)&jarg2; 
  if (arg1) (arg1)->m_userIndexMapping = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1userIndexMapping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btAlignedObjectArray< int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btAlignedObjectArray< int > *)& ((arg1)->m_userIndexMapping);
  *(btAlignedObjectArray< int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1checkLink_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (bool)((btSoftBody const *)arg1)->checkLink(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1checkLink_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::Node *arg2 = (btSoftBody::Node *) 0 ;
  btSoftBody::Node *arg3 = (btSoftBody::Node *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::Node **)&jarg2; 
  arg3 = *(btSoftBody::Node **)&jarg3; 
  result = (bool)((btSoftBody const *)arg1)->checkLink((btSoftBody::Node const *)arg2,(btSoftBody::Node const *)arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1checkFace(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4) {
  jboolean jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (bool)((btSoftBody const *)arg1)->checkFace(arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendMaterial(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::Material *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btSoftBody::Material *)(arg1)->appendMaterial();
  *(btSoftBody::Material **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendNote_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_, jlong jarg7, jobject jarg7_, jlong jarg8, jobject jarg8_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  char *arg2 = (char *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector4 *arg4 = 0 ;
  btSoftBody::Node *arg5 = (btSoftBody::Node *) 0 ;
  btSoftBody::Node *arg6 = (btSoftBody::Node *) 0 ;
  btSoftBody::Node *arg7 = (btSoftBody::Node *) 0 ;
  btSoftBody::Node *arg8 = (btSoftBody::Node *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  (void)jarg5_;
  (void)jarg6_;
  (void)jarg7_;
  (void)jarg8_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btVector4 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector4 const & reference is null");
    return ;
  } 
  arg5 = *(btSoftBody::Node **)&jarg5; 
  arg6 = *(btSoftBody::Node **)&jarg6; 
  arg7 = *(btSoftBody::Node **)&jarg7; 
  arg8 = *(btSoftBody::Node **)&jarg8; 
  (arg1)->appendNote((char const *)arg2,(btVector3 const &)*arg3,(btVector4 const &)*arg4,arg5,arg6,arg7,arg8);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendNote_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_, jlong jarg7, jobject jarg7_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  char *arg2 = (char *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector4 *arg4 = 0 ;
  btSoftBody::Node *arg5 = (btSoftBody::Node *) 0 ;
  btSoftBody::Node *arg6 = (btSoftBody::Node *) 0 ;
  btSoftBody::Node *arg7 = (btSoftBody::Node *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  (void)jarg5_;
  (void)jarg6_;
  (void)jarg7_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btVector4 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector4 const & reference is null");
    return ;
  } 
  arg5 = *(btSoftBody::Node **)&jarg5; 
  arg6 = *(btSoftBody::Node **)&jarg6; 
  arg7 = *(btSoftBody::Node **)&jarg7; 
  (arg1)->appendNote((char const *)arg2,(btVector3 const &)*arg3,(btVector4 const &)*arg4,arg5,arg6,arg7);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendNote_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  char *arg2 = (char *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector4 *arg4 = 0 ;
  btSoftBody::Node *arg5 = (btSoftBody::Node *) 0 ;
  btSoftBody::Node *arg6 = (btSoftBody::Node *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  (void)jarg5_;
  (void)jarg6_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btVector4 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector4 const & reference is null");
    return ;
  } 
  arg5 = *(btSoftBody::Node **)&jarg5; 
  arg6 = *(btSoftBody::Node **)&jarg6; 
  (arg1)->appendNote((char const *)arg2,(btVector3 const &)*arg3,(btVector4 const &)*arg4,arg5,arg6);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendNote_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jobject jarg3, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  char *arg2 = (char *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector4 *arg4 = 0 ;
  btSoftBody::Node *arg5 = (btSoftBody::Node *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btVector4 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector4 const & reference is null");
    return ;
  } 
  arg5 = *(btSoftBody::Node **)&jarg5; 
  (arg1)->appendNote((char const *)arg2,(btVector3 const &)*arg3,(btVector4 const &)*arg4,arg5);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendNote_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jobject jarg3, jlong jarg4, jobject jarg4_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  char *arg2 = (char *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector4 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btVector4 **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btVector4 const & reference is null");
    return ;
  } 
  (arg1)->appendNote((char const *)arg2,(btVector3 const &)*arg3,(btVector4 const &)*arg4);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendNote_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jobject jarg3) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  char *arg2 = (char *) 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->appendNote((char const *)arg2,(btVector3 const &)*arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendNote_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jobject jarg3, jlong jarg4, jobject jarg4_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  char *arg2 = (char *) 0 ;
  btVector3 *arg3 = 0 ;
  btSoftBody::Node *arg4 = (btSoftBody::Node *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btSoftBody::Node **)&jarg4; 
  (arg1)->appendNote((char const *)arg2,(btVector3 const &)*arg3,arg4);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendNote_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jobject jarg3, jlong jarg4, jobject jarg4_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  char *arg2 = (char *) 0 ;
  btVector3 *arg3 = 0 ;
  btSoftBody::Link *arg4 = (btSoftBody::Link *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btSoftBody::Link **)&jarg4; 
  (arg1)->appendNote((char const *)arg2,(btVector3 const &)*arg3,arg4);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendNote_1_1SWIG_18(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jobject jarg3, jlong jarg4, jobject jarg4_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  char *arg2 = (char *) 0 ;
  btVector3 *arg3 = 0 ;
  btSoftBody::Face *arg4 = (btSoftBody::Face *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btSoftBody::Face **)&jarg4; 
  (arg1)->appendNote((char const *)arg2,(btVector3 const &)*arg3,arg4);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendNode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  (arg1)->appendNode((btVector3 const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendLink_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  btSoftBody::Material *arg3 = (btSoftBody::Material *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(btSoftBody::Material **)&jarg3; 
  (arg1)->appendLink(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendLink_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->appendLink(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendLink_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  (arg1)->appendLink();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendLink_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jlong jarg4, jobject jarg4_, jboolean jarg5) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  int arg3 ;
  btSoftBody::Material *arg4 = (btSoftBody::Material *) 0 ;
  bool arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = *(btSoftBody::Material **)&jarg4; 
  arg5 = jarg5 ? true : false; 
  (arg1)->appendLink(arg2,arg3,arg4,arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendLink_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jlong jarg4, jobject jarg4_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  int arg3 ;
  btSoftBody::Material *arg4 = (btSoftBody::Material *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = *(btSoftBody::Material **)&jarg4; 
  (arg1)->appendLink(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendLink_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->appendLink(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendLink_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jboolean jarg5) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::Node *arg2 = (btSoftBody::Node *) 0 ;
  btSoftBody::Node *arg3 = (btSoftBody::Node *) 0 ;
  btSoftBody::Material *arg4 = (btSoftBody::Material *) 0 ;
  bool arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::Node **)&jarg2; 
  arg3 = *(btSoftBody::Node **)&jarg3; 
  arg4 = *(btSoftBody::Material **)&jarg4; 
  arg5 = jarg5 ? true : false; 
  (arg1)->appendLink(arg2,arg3,arg4,arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendLink_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::Node *arg2 = (btSoftBody::Node *) 0 ;
  btSoftBody::Node *arg3 = (btSoftBody::Node *) 0 ;
  btSoftBody::Material *arg4 = (btSoftBody::Material *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::Node **)&jarg2; 
  arg3 = *(btSoftBody::Node **)&jarg3; 
  arg4 = *(btSoftBody::Material **)&jarg4; 
  (arg1)->appendLink(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendLink_1_1SWIG_18(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::Node *arg2 = (btSoftBody::Node *) 0 ;
  btSoftBody::Node *arg3 = (btSoftBody::Node *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::Node **)&jarg2; 
  arg3 = *(btSoftBody::Node **)&jarg3; 
  (arg1)->appendLink(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendFace_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  btSoftBody::Material *arg3 = (btSoftBody::Material *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(btSoftBody::Material **)&jarg3; 
  (arg1)->appendFace(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendFace_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->appendFace(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendFace_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  (arg1)->appendFace();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendFace_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4, jlong jarg5, jobject jarg5_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  btSoftBody::Material *arg5 = (btSoftBody::Material *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = *(btSoftBody::Material **)&jarg5; 
  (arg1)->appendFace(arg2,arg3,arg4,arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendFace_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->appendFace(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendTetra_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  btSoftBody::Material *arg3 = (btSoftBody::Material *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(btSoftBody::Material **)&jarg3; 
  (arg1)->appendTetra(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendTetra_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jlong jarg6, jobject jarg6_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  btSoftBody::Material *arg6 = (btSoftBody::Material *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg6_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = *(btSoftBody::Material **)&jarg6; 
  (arg1)->appendTetra(arg2,arg3,arg4,arg5,arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendTetra_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4, jint jarg5) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  (arg1)->appendTetra(arg2,arg3,arg4,arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendAnchor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_, jboolean jarg4, jfloat jarg5) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  btRigidBody *arg3 = (btRigidBody *) 0 ;
  bool arg4 ;
  btScalar arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(btRigidBody **)&jarg3; 
  arg4 = jarg4 ? true : false; 
  arg5 = (btScalar)jarg5; 
  (arg1)->appendAnchor(arg2,arg3,arg4,arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendAnchor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_, jboolean jarg4) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  btRigidBody *arg3 = (btRigidBody *) 0 ;
  bool arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(btRigidBody **)&jarg3; 
  arg4 = jarg4 ? true : false; 
  (arg1)->appendAnchor(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendAnchor_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  btRigidBody *arg3 = (btRigidBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(btRigidBody **)&jarg3; 
  (arg1)->appendAnchor(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendAnchor_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_, jobject jarg4, jboolean jarg5, jfloat jarg6) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  btRigidBody *arg3 = (btRigidBody *) 0 ;
  btVector3 *arg4 = 0 ;
  bool arg5 ;
  btScalar arg6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(btRigidBody **)&jarg3; 
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = jarg5 ? true : false; 
  arg6 = (btScalar)jarg6; 
  (arg1)->appendAnchor(arg2,arg3,(btVector3 const &)*arg4,arg5,arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendAnchor_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_, jobject jarg4, jboolean jarg5) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  btRigidBody *arg3 = (btRigidBody *) 0 ;
  btVector3 *arg4 = 0 ;
  bool arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(btRigidBody **)&jarg3; 
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = jarg5 ? true : false; 
  (arg1)->appendAnchor(arg2,arg3,(btVector3 const &)*arg4,arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendAnchor_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_, jobject jarg4) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  btRigidBody *arg3 = (btRigidBody *) 0 ;
  btVector3 *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(btRigidBody **)&jarg3; 
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  (arg1)->appendAnchor(arg2,arg3,(btVector3 const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendLinearJoint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::LJoint::Specs *arg2 = 0 ;
  btSoftBody::Cluster *arg3 = (btSoftBody::Cluster *) 0 ;
  btSoftBody::Body arg4 ;
  btSoftBody::Body *argp4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::LJoint::Specs **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBody::LJoint::Specs const & reference is null");
    return ;
  } 
  arg3 = *(btSoftBody::Cluster **)&jarg3; 
  argp4 = *(btSoftBody::Body **)&jarg4; 
  if (!argp4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null btSoftBody::Body");
    return ;
  }
  arg4 = *argp4; 
  (arg1)->appendLinearJoint((btSoftBody::LJoint::Specs const &)*arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendLinearJoint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::LJoint::Specs *arg2 = 0 ;
  btSoftBody::Body arg3 ;
  btSoftBody::Body *argp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::LJoint::Specs **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBody::LJoint::Specs const & reference is null");
    return ;
  } 
  argp3 = *(btSoftBody::Body **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null btSoftBody::Body");
    return ;
  }
  arg3 = *argp3; 
  (arg1)->appendLinearJoint((btSoftBody::LJoint::Specs const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendLinearJoint_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::LJoint::Specs *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::LJoint::Specs **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBody::LJoint::Specs const & reference is null");
    return ;
  } 
  (arg1)->appendLinearJoint((btSoftBody::LJoint::Specs const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendLinearJoint_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::LJoint::Specs *arg2 = 0 ;
  btSoftBody *arg3 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::LJoint::Specs **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBody::LJoint::Specs const & reference is null");
    return ;
  } 
  arg3 = *(btSoftBody **)&jarg3; 
  (arg1)->appendLinearJoint((btSoftBody::LJoint::Specs const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendAngularJoint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::AJoint::Specs *arg2 = 0 ;
  btSoftBody::Cluster *arg3 = (btSoftBody::Cluster *) 0 ;
  btSoftBody::Body arg4 ;
  btSoftBody::Body *argp4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::AJoint::Specs **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBody::AJoint::Specs const & reference is null");
    return ;
  } 
  arg3 = *(btSoftBody::Cluster **)&jarg3; 
  argp4 = *(btSoftBody::Body **)&jarg4; 
  if (!argp4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null btSoftBody::Body");
    return ;
  }
  arg4 = *argp4; 
  (arg1)->appendAngularJoint((btSoftBody::AJoint::Specs const &)*arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendAngularJoint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::AJoint::Specs *arg2 = 0 ;
  btSoftBody::Body arg3 ;
  btSoftBody::Body *argp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::AJoint::Specs **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBody::AJoint::Specs const & reference is null");
    return ;
  } 
  argp3 = *(btSoftBody::Body **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null btSoftBody::Body");
    return ;
  }
  arg3 = *argp3; 
  (arg1)->appendAngularJoint((btSoftBody::AJoint::Specs const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendAngularJoint_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::AJoint::Specs *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::AJoint::Specs **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBody::AJoint::Specs const & reference is null");
    return ;
  } 
  (arg1)->appendAngularJoint((btSoftBody::AJoint::Specs const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1appendAngularJoint_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::AJoint::Specs *arg2 = 0 ;
  btSoftBody *arg3 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::AJoint::Specs **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBody::AJoint::Specs const & reference is null");
    return ;
  } 
  arg3 = *(btSoftBody **)&jarg3; 
  (arg1)->appendAngularJoint((btSoftBody::AJoint::Specs const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1addForce_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->addForce((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1addForce_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btVector3 *arg2 = 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (int)jarg3; 
  (arg1)->addForce((btVector3 const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1addAeroForceToNode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btVector3 *arg2 = 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (int)jarg3; 
  (arg1)->addAeroForceToNode((btVector3 const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1addAeroForceToFace(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btVector3 *arg2 = 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (int)jarg3; 
  (arg1)->addAeroForceToFace((btVector3 const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1addVelocity_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->addVelocity((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setVelocity((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1addVelocity_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btVector3 *arg2 = 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (int)jarg3; 
  (arg1)->addVelocity((btVector3 const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setMass(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setMass(arg2,arg3);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1getMass(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jfloat jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btScalar)((btSoftBody const *)arg1)->getMass(arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1getTotalMass(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btScalar)((btSoftBody const *)arg1)->getTotalMass();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setTotalMass_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jboolean jarg3) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = jarg3 ? true : false; 
  (arg1)->setTotalMass(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setTotalMass_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setTotalMass(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setTotalDensity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setTotalDensity(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setVolumeMass(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setVolumeMass(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setVolumeDensity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setVolumeDensity(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1transform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btTransform *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->transform((btTransform const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1translate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->translate((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1rotate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btQuaternion *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->rotate((btQuaternion const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1scale(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->scale((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setPose(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jboolean jarg3) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  bool arg2 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = jarg3 ? true : false; 
  (arg1)->setPose(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1resetLinkRestLengths(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  (arg1)->resetLinkRestLengths();
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1getVolume(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btScalar)((btSoftBody const *)arg1)->getVolume();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1clusterCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (int)((btSoftBody const *)arg1)->clusterCount();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1clusterCom_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = btSoftBody::clusterCom((btSoftBody::Cluster const *)arg1);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1clusterCom_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  result = ((btSoftBody const *)arg1)->clusterCom(arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1clusterVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = btSoftBody::clusterVelocity((btSoftBody::Cluster const *)arg1,(btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1clusterVImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btSoftBody::clusterVImpulse(arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1clusterDImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btSoftBody::clusterDImpulse(arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1clusterImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jobject jarg3_) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btVector3 *arg2 = 0 ;
  btSoftBody::Impulse *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = *(btSoftBody::Impulse **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBody::Impulse const & reference is null");
    return ;
  } 
  btSoftBody::clusterImpulse(arg1,(btVector3 const &)*arg2,(btSoftBody::Impulse const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1clusterVAImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btSoftBody::clusterVAImpulse(arg1,(btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1clusterDAImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btSoftBody::clusterDAImpulse(arg1,(btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1clusterAImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btSoftBody::Impulse *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  arg2 = *(btSoftBody::Impulse **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBody::Impulse const & reference is null");
    return ;
  } 
  btSoftBody::clusterAImpulse(arg1,(btSoftBody::Impulse const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1clusterDCImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btSoftBody::clusterDCImpulse(arg1,(btVector3 const &)*arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1generateBendingConstraints_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jint jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  btSoftBody::Material *arg3 = (btSoftBody::Material *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(btSoftBody::Material **)&jarg3; 
  result = (int)(arg1)->generateBendingConstraints(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1generateBendingConstraints_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)(arg1)->generateBendingConstraints(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1randomizeConstraints(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  (arg1)->randomizeConstraints();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1releaseCluster(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->releaseCluster(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1releaseClusters(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  (arg1)->releaseClusters();
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1generateClusters_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jint jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (int)(arg1)->generateClusters(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1generateClusters_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)(arg1)->generateClusters(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1refine(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3, jboolean jarg4) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::ImplicitFn *arg2 = (btSoftBody::ImplicitFn *) 0 ;
  btScalar arg3 ;
  bool arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::ImplicitFn **)&jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = jarg4 ? true : false; 
  (arg1)->refine(arg2,arg3,arg4);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1cutLink_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jfloat jarg4) {
  jboolean jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  int arg3 ;
  btScalar arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (btScalar)jarg4; 
  result = (bool)(arg1)->cutLink(arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1cutLink_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jfloat jarg4) {
  jboolean jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::Node *arg2 = (btSoftBody::Node *) 0 ;
  btSoftBody::Node *arg3 = (btSoftBody::Node *) 0 ;
  btScalar arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody::Node **)&jarg2; 
  arg3 = *(btSoftBody::Node **)&jarg3; 
  arg4 = (btScalar)jarg4; 
  result = (bool)(arg1)->cutLink((btSoftBody::Node const *)arg2,(btSoftBody::Node const *)arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1rayTest_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jobject jarg4_) {
  jboolean jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btSoftBody::sRayCast *arg4 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(btSoftBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btSoftBody::sRayCast **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBody::sRayCast & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setSolver(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody::eSolverPresets::_ arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btSoftBody::eSolverPresets::_)jarg2; 
  (arg1)->setSolver(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1predictMotion(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->predictMotion(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1solveConstraints(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  (arg1)->solveConstraints();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1staticSolve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->staticSolve(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1solveCommonConstraints(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  btSoftBody **arg1 = (btSoftBody **) 0 ;
  int arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBody ***)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  btSoftBody::solveCommonConstraints(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1solveClusters_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btAlignedObjectArray< btSoftBody * > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAlignedObjectArray< btSoftBody * > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btAlignedObjectArray< btSoftBody * > const & reference is null");
    return ;
  } 
  btSoftBody::solveClusters((btAlignedObjectArray< btSoftBody * > const &)*arg1);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1integrateMotion(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  (arg1)->integrateMotion();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1defaultCollisionHandler_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btCollisionObjectWrapper *arg2 = (btCollisionObjectWrapper *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btCollisionObjectWrapper **)&jarg2; 
  (arg1)->defaultCollisionHandler((btCollisionObjectWrapper const *)arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1defaultCollisionHandler_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBody *arg2 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btSoftBody **)&jarg2; 
  (arg1)->defaultCollisionHandler(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setWindVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setWindVelocity((btVector3 const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1upcastConstBtCollisionObject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btSoftBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (btSoftBody *)btSoftBody::upcast((btCollisionObject const *)arg1);
  *(btSoftBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1upcast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionObject *arg1 = (btCollisionObject *) 0 ;
  btSoftBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionObject **)&jarg1; 
  result = (btSoftBody *)btSoftBody::upcast(arg1);
  *(btSoftBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1getAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  ((btSoftBody const *)arg1)->getAabb(*arg2,*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1pointersToIndices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  (arg1)->pointersToIndices();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1indicesToPointers_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int *arg2 = (int *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  {
    arg2 = (int*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  (arg1)->indicesToPointers((int const *)arg2);
  
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1indicesToPointers_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  (arg1)->indicesToPointers();
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1rayTest_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jboolean jarg7) {
  jint jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  btSoftBody::eFeature::_ *arg5 = 0 ;
  int *arg6 = 0 ;
  bool arg7 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btScalar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return 0;
  } 
  arg5 = *(btSoftBody::eFeature::_ **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBody::eFeature::_ & reference is null");
    return 0;
  } 
  arg6 = *(int **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return 0;
  } 
  arg7 = jarg7 ? true : false; 
  result = (int)((btSoftBody const *)arg1)->rayTest((btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,*arg5,*arg6,arg7);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1initializeFaceTree(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  (arg1)->initializeFaceTree();
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1evaluateCom(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = ((btSoftBody const *)arg1)->evaluateCom();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1checkContact(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jfloat jarg4, jlong jarg5, jobject jarg5_) {
  jboolean jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btCollisionObjectWrapper *arg2 = (btCollisionObjectWrapper *) 0 ;
  btVector3 *arg3 = 0 ;
  btScalar arg4 ;
  btSoftBody::sCti *arg5 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg5_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btCollisionObjectWrapper **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (btScalar)jarg4; 
  arg5 = *(btSoftBody::sCti **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBody::sCti & reference is null");
    return 0;
  } 
  result = (bool)((btSoftBody const *)arg1)->checkContact((btCollisionObjectWrapper const *)arg2,(btVector3 const &)*arg3,arg4,*arg5);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1updateNormals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  (arg1)->updateNormals();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1updateBounds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  (arg1)->updateBounds();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1updatePose(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  (arg1)->updatePose();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1updateConstants(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  (arg1)->updateConstants();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1updateLinkConstants(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  (arg1)->updateLinkConstants();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1updateArea_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->updateArea(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1updateArea_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  (arg1)->updateArea();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1initializeClusters(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  (arg1)->initializeClusters();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1updateClusters(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  (arg1)->updateClusters();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1cleanupClusters(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  (arg1)->cleanupClusters();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1prepareClusters(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->prepareClusters(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1solveClusters_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->solveClusters(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1applyClusters(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->applyClusters(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1dampClusters(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  (arg1)->dampClusters();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1applyForces(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  (arg1)->applyForces();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1PSolve_1Anchors(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  btSoftBody::PSolve_Anchors(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1PSolve_1RContacts(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  btSoftBody::PSolve_RContacts(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1PSolve_1SContacts(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  btSoftBody::PSolve_SContacts(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1PSolve_1Links(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  btSoftBody::PSolve_Links(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1VSolve_1Links(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btSoftBody::VSolve_Links(arg1,arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1getSolver_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  btSoftBody::ePSolver::_ arg1 ;
  btSoftBody::psolver_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btSoftBody::ePSolver::_)jarg1; 
  result = (btSoftBody::psolver_t)btSoftBody::getSolver(arg1);
  *(btSoftBody::psolver_t *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBody_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3, jint jarg4, jint jarg5, jobject jarg6, jint jarg7, jint jarg8, jobject jarg9, jint jarg10) {
  jlong jresult = 0 ;
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  float *arg2 = (float *) 0 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  short *arg6 = (short *) 0 ;
  int arg7 ;
  int arg8 ;
  short *arg9 = (short *) 0 ;
  int arg10 ;
  btSoftBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  {
    arg2 = (float*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  {
    arg6 = (short*)jenv->GetDirectBufferAddress(jarg6);
    if (arg6 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg7 = (int)jarg7; 
  arg8 = (int)jarg8; 
  {
    arg9 = (short*)jenv->GetDirectBufferAddress(jarg9);
    if (arg9 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg10 = (int)jarg10; 
  result = (btSoftBody *)new_btSoftBody__SWIG_2(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
  *(btSoftBody **)&jresult = result; 
  
  
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1getNodeCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (int)btSoftBody_getNodeCount(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1getNode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  btSoftBody::Node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btSoftBody::Node *)btSoftBody_getNode(arg1,arg2);
  *(btSoftBody::Node **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1getLinkCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (int)btSoftBody_getLinkCount(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1getLink(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  btSoftBody::Link *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btSoftBody::Link *)btSoftBody_getLink(arg1,arg2);
  *(btSoftBody::Link **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1getVertices_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3, jint jarg4, jint jarg5) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar *arg2 = (btScalar *) 0 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  {
    arg2 = (btScalar*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  btSoftBody_getVertices__SWIG_0(arg1,arg2,arg3,arg4,arg5);
  
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1getVertices_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3, jint jarg4, jobject jarg5, jint jarg6, jint jarg7, jobject jarg8, jint jarg9) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  float *arg2 = (float *) 0 ;
  int arg3 ;
  int arg4 ;
  short *arg5 = (short *) 0 ;
  int arg6 ;
  int arg7 ;
  short *arg8 = (short *) 0 ;
  int arg9 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  {
    arg2 = (float*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  {
    arg5 = (short*)jenv->GetDirectBufferAddress(jarg5);
    if (arg5 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg6 = (int)jarg6; 
  arg7 = (int)jarg7; 
  {
    arg8 = (short*)jenv->GetDirectBufferAddress(jarg8);
    if (arg8 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg9 = (int)jarg9; 
  btSoftBody_getVertices__SWIG_1(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
  
  
  
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1getVertices_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3, jint jarg4, jint jarg5, jobject jarg6, jint jarg7, jint jarg8, jobject jarg9, jint jarg10) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  float *arg2 = (float *) 0 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  short *arg6 = (short *) 0 ;
  int arg7 ;
  int arg8 ;
  short *arg9 = (short *) 0 ;
  int arg10 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  {
    arg2 = (float*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  {
    arg6 = (short*)jenv->GetDirectBufferAddress(jarg6);
    if (arg6 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg7 = (int)jarg7; 
  arg8 = (int)jarg8; 
  {
    arg9 = (short*)jenv->GetDirectBufferAddress(jarg9);
    if (arg9 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg10 = (int)jarg10; 
  btSoftBody_getVertices__SWIG_2(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
  
  
  
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1getFaceCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (int)btSoftBody_getFaceCount(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1getFace(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  btSoftBody::Face *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btSoftBody::Face *)btSoftBody_getFace(arg1,arg2);
  *(btSoftBody::Face **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1getIndices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  short *arg2 = (short *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  {
    arg2 = (short*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg3 = (int)jarg3; 
  btSoftBody_getIndices(arg1,arg2,arg3);
  
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1kVCF(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btSoftBody_setConfig_kVCF(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1kDP(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btSoftBody_setConfig_kDP(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1kDG(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btSoftBody_setConfig_kDG(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1kLF(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btSoftBody_setConfig_kLF(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1kPR(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btSoftBody_setConfig_kPR(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1kVC(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btSoftBody_setConfig_kVC(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1kDF(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btSoftBody_setConfig_kDF(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1kMT(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btSoftBody_setConfig_kMT(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1kCHR(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btSoftBody_setConfig_kCHR(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1kKHR(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btSoftBody_setConfig_kKHR(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1kSHR(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btSoftBody_setConfig_kSHR(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1kAHR(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btSoftBody_setConfig_kAHR(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1kSRHR_1CL(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btSoftBody_setConfig_kSRHR_CL(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1kSKHR_1CL(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btSoftBody_setConfig_kSKHR_CL(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1kSSHR_1CL(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btSoftBody_setConfig_kSSHR_CL(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1kSR_1SPLT_1CL(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btSoftBody_setConfig_kSR_SPLT_CL(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1kSK_1SPLT_1CL(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btSoftBody_setConfig_kSK_SPLT_CL(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1kSS_1SPLT_1CL(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btSoftBody_setConfig_kSS_SPLT_CL(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1maxvolume(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btSoftBody_setConfig_maxvolume(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1timescale(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btSoftBody_setConfig_timescale(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1viterations(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  btSoftBody_setConfig_viterations(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1piterations(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  btSoftBody_setConfig_piterations(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1diterations(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  btSoftBody_setConfig_diterations(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1citerations(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  btSoftBody_setConfig_citerations(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1setConfig_1collisions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = (int)jarg2; 
  btSoftBody_setConfig_collisions(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btTriIndex_1PartIdTriangleIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTriIndex *arg1 = (btTriIndex *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriIndex **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_PartIdTriangleIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btTriIndex_1PartIdTriangleIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTriIndex *arg1 = (btTriIndex *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriIndex **)&jarg1; 
  result = (int) ((arg1)->m_PartIdTriangleIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btTriIndex_1childShape_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTriIndex *arg1 = (btTriIndex *) 0 ;
  btCollisionShape *arg2 = (btCollisionShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTriIndex **)&jarg1; 
  arg2 = *(btCollisionShape **)&jarg2; 
  if (arg1) (arg1)->m_childShape = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btTriIndex_1childShape_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTriIndex *arg1 = (btTriIndex *) 0 ;
  btCollisionShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriIndex **)&jarg1; 
  result = (btCollisionShape *) ((arg1)->m_childShape);
  *(btCollisionShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btTriIndex(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  btCollisionShape *arg3 = (btCollisionShape *) 0 ;
  btTriIndex *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(btCollisionShape **)&jarg3; 
  result = (btTriIndex *)new btTriIndex(arg1,arg2,arg3);
  *(btTriIndex **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btTriIndex_1getTriangleIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTriIndex *arg1 = (btTriIndex *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriIndex **)&jarg1; 
  result = (int)((btTriIndex const *)arg1)->getTriangleIndex();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btTriIndex_1getPartId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTriIndex *arg1 = (btTriIndex *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriIndex **)&jarg1; 
  result = (int)((btTriIndex const *)arg1)->getPartId();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btTriIndex_1getUid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTriIndex *arg1 = (btTriIndex *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTriIndex **)&jarg1; 
  result = (int)((btTriIndex const *)arg1)->getUid();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btTriIndex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTriIndex *arg1 = (btTriIndex *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTriIndex **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyTriangleCallback_1triangleCount_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBodyTriangleCallback *arg1 = (btSoftBodyTriangleCallback *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyTriangleCallback **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_triangleCount = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyTriangleCallback_1triangleCount_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBodyTriangleCallback *arg1 = (btSoftBodyTriangleCallback *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyTriangleCallback **)&jarg1; 
  result = (int) ((arg1)->m_triangleCount);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBodyTriangleCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jboolean jarg4) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btCollisionObjectWrapper *arg2 = (btCollisionObjectWrapper *) 0 ;
  btCollisionObjectWrapper *arg3 = (btCollisionObjectWrapper *) 0 ;
  bool arg4 ;
  btSoftBodyTriangleCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btCollisionObjectWrapper **)&jarg2; 
  arg3 = *(btCollisionObjectWrapper **)&jarg3; 
  arg4 = jarg4 ? true : false; 
  result = (btSoftBodyTriangleCallback *)new btSoftBodyTriangleCallback(arg1,(btCollisionObjectWrapper const *)arg2,(btCollisionObjectWrapper const *)arg3,arg4);
  *(btSoftBodyTriangleCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyTriangleCallback_1setTimeStepAndCounters(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  btSoftBodyTriangleCallback *arg1 = (btSoftBodyTriangleCallback *) 0 ;
  btScalar arg2 ;
  btCollisionObjectWrapper *arg3 = (btCollisionObjectWrapper *) 0 ;
  btDispatcherInfo *arg4 = 0 ;
  btManifoldResult *arg5 = (btManifoldResult *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(btSoftBodyTriangleCallback **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = *(btCollisionObjectWrapper **)&jarg3; 
  arg4 = *(btDispatcherInfo **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDispatcherInfo const & reference is null");
    return ;
  } 
  arg5 = *(btManifoldResult **)&jarg5; 
  (arg1)->setTimeStepAndCounters(arg2,(btCollisionObjectWrapper const *)arg3,(btDispatcherInfo const &)*arg4,arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBodyTriangleCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBodyTriangleCallback *arg1 = (btSoftBodyTriangleCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBodyTriangleCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyTriangleCallback_1clearCache(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBodyTriangleCallback *arg1 = (btSoftBodyTriangleCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyTriangleCallback **)&jarg1; 
  (arg1)->clearCache();
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyTriangleCallback_1getAabbMin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSoftBodyTriangleCallback *arg1 = (btSoftBodyTriangleCallback *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyTriangleCallback **)&jarg1; 
  result = (btVector3 *) &((btSoftBodyTriangleCallback const *)arg1)->getAabbMin();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyTriangleCallback_1getAabbMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSoftBodyTriangleCallback *arg1 = (btSoftBodyTriangleCallback *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyTriangleCallback **)&jarg1; 
  result = (btVector3 *) &((btSoftBodyTriangleCallback const *)arg1)->getAabbMax();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBodyConcaveCollisionAlgorithm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jboolean jarg4) {
  jlong jresult = 0 ;
  btCollisionAlgorithmConstructionInfo *arg1 = 0 ;
  btCollisionObjectWrapper *arg2 = (btCollisionObjectWrapper *) 0 ;
  btCollisionObjectWrapper *arg3 = (btCollisionObjectWrapper *) 0 ;
  bool arg4 ;
  btSoftBodyConcaveCollisionAlgorithm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btCollisionAlgorithmConstructionInfo **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btCollisionAlgorithmConstructionInfo const & reference is null");
    return 0;
  } 
  arg2 = *(btCollisionObjectWrapper **)&jarg2; 
  arg3 = *(btCollisionObjectWrapper **)&jarg3; 
  arg4 = jarg4 ? true : false; 
  result = (btSoftBodyConcaveCollisionAlgorithm *)new btSoftBodyConcaveCollisionAlgorithm((btCollisionAlgorithmConstructionInfo const &)*arg1,(btCollisionObjectWrapper const *)arg2,(btCollisionObjectWrapper const *)arg3,arg4);
  *(btSoftBodyConcaveCollisionAlgorithm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBodyConcaveCollisionAlgorithm(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBodyConcaveCollisionAlgorithm *arg1 = (btSoftBodyConcaveCollisionAlgorithm *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBodyConcaveCollisionAlgorithm **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyConcaveCollisionAlgorithm_1clearCache(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBodyConcaveCollisionAlgorithm *arg1 = (btSoftBodyConcaveCollisionAlgorithm *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyConcaveCollisionAlgorithm **)&jarg1; 
  (arg1)->clearCache();
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBodyConcaveCollisionAlgorithm_1CreateFunc(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBodyConcaveCollisionAlgorithm::CreateFunc *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBodyConcaveCollisionAlgorithm::CreateFunc *)new btSoftBodyConcaveCollisionAlgorithm::CreateFunc();
  *(btSoftBodyConcaveCollisionAlgorithm::CreateFunc **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBodyConcaveCollisionAlgorithm_1CreateFunc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBodyConcaveCollisionAlgorithm::CreateFunc *arg1 = (btSoftBodyConcaveCollisionAlgorithm::CreateFunc *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBodyConcaveCollisionAlgorithm::CreateFunc **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBodyConcaveCollisionAlgorithm_1SwappedCreateFunc(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBodyConcaveCollisionAlgorithm::SwappedCreateFunc *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBodyConcaveCollisionAlgorithm::SwappedCreateFunc *)new btSoftBodyConcaveCollisionAlgorithm::SwappedCreateFunc();
  *(btSoftBodyConcaveCollisionAlgorithm::SwappedCreateFunc **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBodyConcaveCollisionAlgorithm_1SwappedCreateFunc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBodyConcaveCollisionAlgorithm::SwappedCreateFunc *arg1 = (btSoftBodyConcaveCollisionAlgorithm::SwappedCreateFunc *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBodyConcaveCollisionAlgorithm::SwappedCreateFunc **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyMaterialData_1linearStiffness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyMaterialData *arg1 = (SoftBodyMaterialData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyMaterialData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_linearStiffness = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyMaterialData_1linearStiffness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyMaterialData *arg1 = (SoftBodyMaterialData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyMaterialData **)&jarg1; 
  result = (float) ((arg1)->m_linearStiffness);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyMaterialData_1angularStiffness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyMaterialData *arg1 = (SoftBodyMaterialData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyMaterialData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_angularStiffness = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyMaterialData_1angularStiffness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyMaterialData *arg1 = (SoftBodyMaterialData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyMaterialData **)&jarg1; 
  result = (float) ((arg1)->m_angularStiffness);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyMaterialData_1volumeStiffness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyMaterialData *arg1 = (SoftBodyMaterialData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyMaterialData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_volumeStiffness = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyMaterialData_1volumeStiffness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyMaterialData *arg1 = (SoftBodyMaterialData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyMaterialData **)&jarg1; 
  result = (float) ((arg1)->m_volumeStiffness);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyMaterialData_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyMaterialData *arg1 = (SoftBodyMaterialData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyMaterialData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_flags = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyMaterialData_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyMaterialData *arg1 = (SoftBodyMaterialData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyMaterialData **)&jarg1; 
  result = (int) ((arg1)->m_flags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1SoftBodyMaterialData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SoftBodyMaterialData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (SoftBodyMaterialData *)new SoftBodyMaterialData();
  *(SoftBodyMaterialData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1SoftBodyMaterialData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SoftBodyMaterialData *arg1 = (SoftBodyMaterialData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SoftBodyMaterialData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyNodeData_1material_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyNodeData *arg1 = (SoftBodyNodeData *) 0 ;
  SoftBodyMaterialData *arg2 = (SoftBodyMaterialData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyNodeData **)&jarg1; 
  arg2 = *(SoftBodyMaterialData **)&jarg2; 
  if (arg1) (arg1)->m_material = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyNodeData_1material_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyNodeData *arg1 = (SoftBodyNodeData *) 0 ;
  SoftBodyMaterialData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyNodeData **)&jarg1; 
  result = (SoftBodyMaterialData *) ((arg1)->m_material);
  *(SoftBodyMaterialData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyNodeData_1position_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyNodeData *arg1 = (SoftBodyNodeData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyNodeData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_position = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyNodeData_1position_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyNodeData *arg1 = (SoftBodyNodeData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyNodeData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_position);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyNodeData_1previousPosition_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyNodeData *arg1 = (SoftBodyNodeData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyNodeData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_previousPosition = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyNodeData_1previousPosition_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyNodeData *arg1 = (SoftBodyNodeData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyNodeData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_previousPosition);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyNodeData_1velocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyNodeData *arg1 = (SoftBodyNodeData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyNodeData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_velocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyNodeData_1velocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyNodeData *arg1 = (SoftBodyNodeData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyNodeData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_velocity);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyNodeData_1accumulatedForce_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyNodeData *arg1 = (SoftBodyNodeData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyNodeData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_accumulatedForce = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyNodeData_1accumulatedForce_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyNodeData *arg1 = (SoftBodyNodeData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyNodeData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_accumulatedForce);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyNodeData_1normal_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyNodeData *arg1 = (SoftBodyNodeData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyNodeData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_normal = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyNodeData_1normal_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyNodeData *arg1 = (SoftBodyNodeData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyNodeData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_normal);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyNodeData_1inverseMass_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyNodeData *arg1 = (SoftBodyNodeData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyNodeData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_inverseMass = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyNodeData_1inverseMass_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyNodeData *arg1 = (SoftBodyNodeData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyNodeData **)&jarg1; 
  result = (float) ((arg1)->m_inverseMass);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyNodeData_1area_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyNodeData *arg1 = (SoftBodyNodeData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyNodeData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_area = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyNodeData_1area_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyNodeData *arg1 = (SoftBodyNodeData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyNodeData **)&jarg1; 
  result = (float) ((arg1)->m_area);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyNodeData_1attach_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyNodeData *arg1 = (SoftBodyNodeData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyNodeData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_attach = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyNodeData_1attach_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyNodeData *arg1 = (SoftBodyNodeData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyNodeData **)&jarg1; 
  result = (int) ((arg1)->m_attach);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyNodeData_1pad_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyNodeData *arg1 = (SoftBodyNodeData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyNodeData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_pad = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyNodeData_1pad_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyNodeData *arg1 = (SoftBodyNodeData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyNodeData **)&jarg1; 
  result = (int) ((arg1)->m_pad);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1SoftBodyNodeData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SoftBodyNodeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (SoftBodyNodeData *)new SoftBodyNodeData();
  *(SoftBodyNodeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1SoftBodyNodeData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SoftBodyNodeData *arg1 = (SoftBodyNodeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SoftBodyNodeData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyLinkData_1material_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyLinkData *arg1 = (SoftBodyLinkData *) 0 ;
  SoftBodyMaterialData *arg2 = (SoftBodyMaterialData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyLinkData **)&jarg1; 
  arg2 = *(SoftBodyMaterialData **)&jarg2; 
  if (arg1) (arg1)->m_material = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyLinkData_1material_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyLinkData *arg1 = (SoftBodyLinkData *) 0 ;
  SoftBodyMaterialData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyLinkData **)&jarg1; 
  result = (SoftBodyMaterialData *) ((arg1)->m_material);
  *(SoftBodyMaterialData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyLinkData_1nodeIndices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  SoftBodyLinkData *arg1 = (SoftBodyLinkData *) 0 ;
  int *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyLinkData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  arg2 = (int *)jenv->GetPrimitiveArrayCritical(jarg2, 0); 
  {
    size_t ii;
    int *b = (int *) arg1->m_nodeIndices;
    for (ii = 0; ii < (size_t)2; ii++) b[ii] = *((int *) arg2 + ii);
  }
  jenv->ReleasePrimitiveArrayCritical(jarg2, (int *)arg2, 0); 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyLinkData_1nodeIndices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  SoftBodyLinkData *arg1 = (SoftBodyLinkData *) 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyLinkData **)&jarg1; 
  result = (int *)(int *) ((arg1)->m_nodeIndices);
  /*jresult = SWIG_JavaArrayOut##Int(jenv, (int *)result, 2);*/ 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyLinkData_1restLength_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyLinkData *arg1 = (SoftBodyLinkData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyLinkData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_restLength = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyLinkData_1restLength_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyLinkData *arg1 = (SoftBodyLinkData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyLinkData **)&jarg1; 
  result = (float) ((arg1)->m_restLength);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyLinkData_1bbending_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyLinkData *arg1 = (SoftBodyLinkData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyLinkData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_bbending = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyLinkData_1bbending_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyLinkData *arg1 = (SoftBodyLinkData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyLinkData **)&jarg1; 
  result = (int) ((arg1)->m_bbending);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1SoftBodyLinkData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SoftBodyLinkData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (SoftBodyLinkData *)new SoftBodyLinkData();
  *(SoftBodyLinkData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1SoftBodyLinkData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SoftBodyLinkData *arg1 = (SoftBodyLinkData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SoftBodyLinkData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyFaceData_1normal_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyFaceData *arg1 = (SoftBodyFaceData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyFaceData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_normal = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyFaceData_1normal_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyFaceData *arg1 = (SoftBodyFaceData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyFaceData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_normal);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyFaceData_1material_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyFaceData *arg1 = (SoftBodyFaceData *) 0 ;
  SoftBodyMaterialData *arg2 = (SoftBodyMaterialData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyFaceData **)&jarg1; 
  arg2 = *(SoftBodyMaterialData **)&jarg2; 
  if (arg1) (arg1)->m_material = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyFaceData_1material_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyFaceData *arg1 = (SoftBodyFaceData *) 0 ;
  SoftBodyMaterialData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyFaceData **)&jarg1; 
  result = (SoftBodyMaterialData *) ((arg1)->m_material);
  *(SoftBodyMaterialData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyFaceData_1nodeIndices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  SoftBodyFaceData *arg1 = (SoftBodyFaceData *) 0 ;
  int *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyFaceData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  arg2 = (int *)jenv->GetPrimitiveArrayCritical(jarg2, 0); 
  {
    size_t ii;
    int *b = (int *) arg1->m_nodeIndices;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((int *) arg2 + ii);
  }
  jenv->ReleasePrimitiveArrayCritical(jarg2, (int *)arg2, 0); 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyFaceData_1nodeIndices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  SoftBodyFaceData *arg1 = (SoftBodyFaceData *) 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyFaceData **)&jarg1; 
  result = (int *)(int *) ((arg1)->m_nodeIndices);
  /*jresult = SWIG_JavaArrayOut##Int(jenv, (int *)result, 3);*/ 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyFaceData_1restArea_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyFaceData *arg1 = (SoftBodyFaceData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyFaceData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_restArea = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyFaceData_1restArea_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyFaceData *arg1 = (SoftBodyFaceData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyFaceData **)&jarg1; 
  result = (float) ((arg1)->m_restArea);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1SoftBodyFaceData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SoftBodyFaceData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (SoftBodyFaceData *)new SoftBodyFaceData();
  *(SoftBodyFaceData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1SoftBodyFaceData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SoftBodyFaceData *arg1 = (SoftBodyFaceData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SoftBodyFaceData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyTetraData_1c0_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyTetraData *arg1 = (SoftBodyTetraData *) 0 ;
  btVector3FloatData *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyTetraData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  {
    size_t ii;
    btVector3FloatData *b = (btVector3FloatData *) arg1->m_c0;
    for (ii = 0; ii < (size_t)4; ii++) b[ii] = *((btVector3FloatData *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyTetraData_1c0_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyTetraData *arg1 = (SoftBodyTetraData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyTetraData **)&jarg1; 
  result = (btVector3FloatData *)(btVector3FloatData *) ((arg1)->m_c0);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyTetraData_1material_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyTetraData *arg1 = (SoftBodyTetraData *) 0 ;
  SoftBodyMaterialData *arg2 = (SoftBodyMaterialData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyTetraData **)&jarg1; 
  arg2 = *(SoftBodyMaterialData **)&jarg2; 
  if (arg1) (arg1)->m_material = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyTetraData_1material_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyTetraData *arg1 = (SoftBodyTetraData *) 0 ;
  SoftBodyMaterialData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyTetraData **)&jarg1; 
  result = (SoftBodyMaterialData *) ((arg1)->m_material);
  *(SoftBodyMaterialData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyTetraData_1nodeIndices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  SoftBodyTetraData *arg1 = (SoftBodyTetraData *) 0 ;
  int *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyTetraData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  arg2 = (int *)jenv->GetPrimitiveArrayCritical(jarg2, 0); 
  {
    size_t ii;
    int *b = (int *) arg1->m_nodeIndices;
    for (ii = 0; ii < (size_t)4; ii++) b[ii] = *((int *) arg2 + ii);
  }
  jenv->ReleasePrimitiveArrayCritical(jarg2, (int *)arg2, 0); 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyTetraData_1nodeIndices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  SoftBodyTetraData *arg1 = (SoftBodyTetraData *) 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyTetraData **)&jarg1; 
  result = (int *)(int *) ((arg1)->m_nodeIndices);
  /*jresult = SWIG_JavaArrayOut##Int(jenv, (int *)result, 4);*/ 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyTetraData_1restVolume_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyTetraData *arg1 = (SoftBodyTetraData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyTetraData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_restVolume = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyTetraData_1restVolume_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyTetraData *arg1 = (SoftBodyTetraData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyTetraData **)&jarg1; 
  result = (float) ((arg1)->m_restVolume);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyTetraData_1c1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyTetraData *arg1 = (SoftBodyTetraData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyTetraData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_c1 = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyTetraData_1c1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyTetraData *arg1 = (SoftBodyTetraData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyTetraData **)&jarg1; 
  result = (float) ((arg1)->m_c1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyTetraData_1c2_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyTetraData *arg1 = (SoftBodyTetraData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyTetraData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_c2 = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyTetraData_1c2_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyTetraData *arg1 = (SoftBodyTetraData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyTetraData **)&jarg1; 
  result = (float) ((arg1)->m_c2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyTetraData_1pad_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyTetraData *arg1 = (SoftBodyTetraData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyTetraData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_pad = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyTetraData_1pad_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyTetraData *arg1 = (SoftBodyTetraData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyTetraData **)&jarg1; 
  result = (int) ((arg1)->m_pad);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1SoftBodyTetraData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SoftBodyTetraData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (SoftBodyTetraData *)new SoftBodyTetraData();
  *(SoftBodyTetraData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1SoftBodyTetraData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SoftBodyTetraData *arg1 = (SoftBodyTetraData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SoftBodyTetraData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftRigidAnchorData_1c0_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftRigidAnchorData *arg1 = (SoftRigidAnchorData *) 0 ;
  btMatrix3x3FloatData *arg2 = (btMatrix3x3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftRigidAnchorData **)&jarg1; 
  arg2 = *(btMatrix3x3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_c0 = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftRigidAnchorData_1c0_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftRigidAnchorData *arg1 = (SoftRigidAnchorData *) 0 ;
  btMatrix3x3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftRigidAnchorData **)&jarg1; 
  result = (btMatrix3x3FloatData *)& ((arg1)->m_c0);
  *(btMatrix3x3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftRigidAnchorData_1c1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftRigidAnchorData *arg1 = (SoftRigidAnchorData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftRigidAnchorData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_c1 = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftRigidAnchorData_1c1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftRigidAnchorData *arg1 = (SoftRigidAnchorData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftRigidAnchorData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_c1);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftRigidAnchorData_1localFrame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftRigidAnchorData *arg1 = (SoftRigidAnchorData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftRigidAnchorData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_localFrame = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftRigidAnchorData_1localFrame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftRigidAnchorData *arg1 = (SoftRigidAnchorData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftRigidAnchorData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_localFrame);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftRigidAnchorData_1rigidBody_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftRigidAnchorData *arg1 = (SoftRigidAnchorData *) 0 ;
  btRigidBodyFloatData *arg2 = (btRigidBodyFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftRigidAnchorData **)&jarg1; 
  arg2 = *(btRigidBodyFloatData **)&jarg2; 
  if (arg1) (arg1)->m_rigidBody = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftRigidAnchorData_1rigidBody_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftRigidAnchorData *arg1 = (SoftRigidAnchorData *) 0 ;
  btRigidBodyFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftRigidAnchorData **)&jarg1; 
  result = (btRigidBodyFloatData *) ((arg1)->m_rigidBody);
  *(btRigidBodyFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftRigidAnchorData_1nodeIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftRigidAnchorData *arg1 = (SoftRigidAnchorData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftRigidAnchorData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_nodeIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftRigidAnchorData_1nodeIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftRigidAnchorData *arg1 = (SoftRigidAnchorData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftRigidAnchorData **)&jarg1; 
  result = (int) ((arg1)->m_nodeIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftRigidAnchorData_1c2_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftRigidAnchorData *arg1 = (SoftRigidAnchorData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftRigidAnchorData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_c2 = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftRigidAnchorData_1c2_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftRigidAnchorData *arg1 = (SoftRigidAnchorData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftRigidAnchorData **)&jarg1; 
  result = (float) ((arg1)->m_c2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1SoftRigidAnchorData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SoftRigidAnchorData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (SoftRigidAnchorData *)new SoftRigidAnchorData();
  *(SoftRigidAnchorData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1SoftRigidAnchorData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SoftRigidAnchorData *arg1 = (SoftRigidAnchorData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SoftRigidAnchorData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1aeroModel_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_aeroModel = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1aeroModel_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (int) ((arg1)->m_aeroModel);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1baumgarte_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_baumgarte = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1baumgarte_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (float) ((arg1)->m_baumgarte);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1damping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_damping = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1damping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (float) ((arg1)->m_damping);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1drag_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_drag = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1drag_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (float) ((arg1)->m_drag);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1lift_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_lift = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1lift_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (float) ((arg1)->m_lift);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1pressure_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_pressure = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1pressure_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (float) ((arg1)->m_pressure);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1volume_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_volume = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1volume_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (float) ((arg1)->m_volume);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1dynamicFriction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_dynamicFriction = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1dynamicFriction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (float) ((arg1)->m_dynamicFriction);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1poseMatch_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_poseMatch = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1poseMatch_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (float) ((arg1)->m_poseMatch);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1rigidContactHardness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_rigidContactHardness = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1rigidContactHardness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (float) ((arg1)->m_rigidContactHardness);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1kineticContactHardness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_kineticContactHardness = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1kineticContactHardness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (float) ((arg1)->m_kineticContactHardness);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1softContactHardness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_softContactHardness = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1softContactHardness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (float) ((arg1)->m_softContactHardness);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1anchorHardness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_anchorHardness = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1anchorHardness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (float) ((arg1)->m_anchorHardness);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1softRigidClusterHardness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_softRigidClusterHardness = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1softRigidClusterHardness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (float) ((arg1)->m_softRigidClusterHardness);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1softKineticClusterHardness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_softKineticClusterHardness = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1softKineticClusterHardness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (float) ((arg1)->m_softKineticClusterHardness);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1softSoftClusterHardness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_softSoftClusterHardness = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1softSoftClusterHardness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (float) ((arg1)->m_softSoftClusterHardness);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1softRigidClusterImpulseSplit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_softRigidClusterImpulseSplit = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1softRigidClusterImpulseSplit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (float) ((arg1)->m_softRigidClusterImpulseSplit);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1softKineticClusterImpulseSplit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_softKineticClusterImpulseSplit = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1softKineticClusterImpulseSplit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (float) ((arg1)->m_softKineticClusterImpulseSplit);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1softSoftClusterImpulseSplit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_softSoftClusterImpulseSplit = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1softSoftClusterImpulseSplit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (float) ((arg1)->m_softSoftClusterImpulseSplit);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1maxVolume_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_maxVolume = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1maxVolume_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (float) ((arg1)->m_maxVolume);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1timeScale_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_timeScale = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1timeScale_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (float) ((arg1)->m_timeScale);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1velocityIterations_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_velocityIterations = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1velocityIterations_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (int) ((arg1)->m_velocityIterations);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1positionIterations_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_positionIterations = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1positionIterations_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (int) ((arg1)->m_positionIterations);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1driftIterations_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_driftIterations = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1driftIterations_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (int) ((arg1)->m_driftIterations);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1clusterIterations_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_clusterIterations = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1clusterIterations_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (int) ((arg1)->m_clusterIterations);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1collisionFlags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_collisionFlags = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyConfigData_1collisionFlags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  result = (int) ((arg1)->m_collisionFlags);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1SoftBodyConfigData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SoftBodyConfigData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (SoftBodyConfigData *)new SoftBodyConfigData();
  *(SoftBodyConfigData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1SoftBodyConfigData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SoftBodyConfigData *arg1 = (SoftBodyConfigData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SoftBodyConfigData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1rot_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  btMatrix3x3FloatData *arg2 = (btMatrix3x3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  arg2 = *(btMatrix3x3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_rot = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1rot_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  btMatrix3x3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  result = (btMatrix3x3FloatData *)& ((arg1)->m_rot);
  *(btMatrix3x3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1scale_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  btMatrix3x3FloatData *arg2 = (btMatrix3x3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  arg2 = *(btMatrix3x3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_scale = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1scale_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  btMatrix3x3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  result = (btMatrix3x3FloatData *)& ((arg1)->m_scale);
  *(btMatrix3x3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1aqq_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  btMatrix3x3FloatData *arg2 = (btMatrix3x3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  arg2 = *(btMatrix3x3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_aqq = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1aqq_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  btMatrix3x3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  result = (btMatrix3x3FloatData *)& ((arg1)->m_aqq);
  *(btMatrix3x3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1com_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_com = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1com_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_com);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1positions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_positions = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1positions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  result = (btVector3FloatData *) ((arg1)->m_positions);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1weights_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  float *arg2 = (float *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  {
    arg2 = (float*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    if (arg2) {
      arg1->m_weights = arg2;
    } else {
      arg1->m_weights = 0;
    }
  }
  
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1weights_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  float *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  result = (float *) ((arg1)->m_weights);
  *(float **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1numPositions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numPositions = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1numPositions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  result = (int) ((arg1)->m_numPositions);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1numWeigts_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numWeigts = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1numWeigts_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  result = (int) ((arg1)->m_numWeigts);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1bvolume_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_bvolume = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1bvolume_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  result = (int) ((arg1)->m_bvolume);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1bframe_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_bframe = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1bframe_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  result = (int) ((arg1)->m_bframe);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1restVolume_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_restVolume = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1restVolume_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  result = (float) ((arg1)->m_restVolume);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1pad_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_pad = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyPoseData_1pad_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  result = (int) ((arg1)->m_pad);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1SoftBodyPoseData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SoftBodyPoseData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (SoftBodyPoseData *)new SoftBodyPoseData();
  *(SoftBodyPoseData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1SoftBodyPoseData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SoftBodyPoseData *arg1 = (SoftBodyPoseData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SoftBodyPoseData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1framexform_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  btTransformFloatData *arg2 = (btTransformFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = *(btTransformFloatData **)&jarg2; 
  if (arg1) (arg1)->m_framexform = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1framexform_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  btTransformFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (btTransformFloatData *)& ((arg1)->m_framexform);
  *(btTransformFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1locii_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  btMatrix3x3FloatData *arg2 = (btMatrix3x3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = *(btMatrix3x3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_locii = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1locii_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  btMatrix3x3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (btMatrix3x3FloatData *)& ((arg1)->m_locii);
  *(btMatrix3x3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1invwi_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  btMatrix3x3FloatData *arg2 = (btMatrix3x3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = *(btMatrix3x3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_invwi = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1invwi_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  btMatrix3x3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (btMatrix3x3FloatData *)& ((arg1)->m_invwi);
  *(btMatrix3x3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1com_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_com = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1com_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_com);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1vimpulses_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  btVector3FloatData *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  {
    size_t ii;
    btVector3FloatData *b = (btVector3FloatData *) arg1->m_vimpulses;
    for (ii = 0; ii < (size_t)2; ii++) b[ii] = *((btVector3FloatData *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1vimpulses_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (btVector3FloatData *)(btVector3FloatData *) ((arg1)->m_vimpulses);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1dimpulses_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  btVector3FloatData *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  {
    size_t ii;
    btVector3FloatData *b = (btVector3FloatData *) arg1->m_dimpulses;
    for (ii = 0; ii < (size_t)2; ii++) b[ii] = *((btVector3FloatData *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1dimpulses_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (btVector3FloatData *)(btVector3FloatData *) ((arg1)->m_dimpulses);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1lv_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_lv = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1lv_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_lv);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1av_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_av = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1av_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_av);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1framerefs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_framerefs = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1framerefs_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (btVector3FloatData *) ((arg1)->m_framerefs);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1nodeIndices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  int *arg2 = (int *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  {
    arg2 = (int*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    if (arg2) {
      arg1->m_nodeIndices = arg2;
    } else {
      arg1->m_nodeIndices = 0;
    }
  }
  
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1nodeIndices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (int *) ((arg1)->m_nodeIndices);
  *(int **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1masses_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  float *arg2 = (float *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  {
    arg2 = (float*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    if (arg2) {
      arg1->m_masses = arg2;
    } else {
      arg1->m_masses = 0;
    }
  }
  
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1masses_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  float *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (float *) ((arg1)->m_masses);
  *(float **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1numFrameRefs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numFrameRefs = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1numFrameRefs_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (int) ((arg1)->m_numFrameRefs);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1numNodes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numNodes = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1numNodes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (int) ((arg1)->m_numNodes);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1numMasses_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numMasses = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1numMasses_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (int) ((arg1)->m_numMasses);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1idmass_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_idmass = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1idmass_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (float) ((arg1)->m_idmass);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1imass_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_imass = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1imass_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (float) ((arg1)->m_imass);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1nvimpulses_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_nvimpulses = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1nvimpulses_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (int) ((arg1)->m_nvimpulses);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1ndimpulses_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_ndimpulses = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1ndimpulses_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (int) ((arg1)->m_ndimpulses);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1ndamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_ndamping = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1ndamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (float) ((arg1)->m_ndamping);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1ldamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_ldamping = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1ldamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (float) ((arg1)->m_ldamping);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1adamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_adamping = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1adamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (float) ((arg1)->m_adamping);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1matching_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_matching = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1matching_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (float) ((arg1)->m_matching);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1maxSelfCollisionImpulse_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_maxSelfCollisionImpulse = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1maxSelfCollisionImpulse_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (float) ((arg1)->m_maxSelfCollisionImpulse);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1selfCollisionImpulseFactor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_selfCollisionImpulseFactor = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1selfCollisionImpulseFactor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (float) ((arg1)->m_selfCollisionImpulseFactor);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1containsAnchor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_containsAnchor = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1containsAnchor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (int) ((arg1)->m_containsAnchor);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1collide_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_collide = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1collide_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (int) ((arg1)->m_collide);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1clusterIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_clusterIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_SoftBodyClusterData_1clusterIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  result = (int) ((arg1)->m_clusterIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1SoftBodyClusterData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SoftBodyClusterData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (SoftBodyClusterData *)new SoftBodyClusterData();
  *(SoftBodyClusterData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1SoftBodyClusterData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SoftBodyClusterData *arg1 = (SoftBodyClusterData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SoftBodyClusterData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1bodyA_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  arg2 = (void *)jarg2; 
  if (arg1) (arg1)->m_bodyA = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1bodyA_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  result = (void *) ((arg1)->m_bodyA);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1bodyB_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  arg2 = (void *)jarg2; 
  if (arg1) (arg1)->m_bodyB = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1bodyB_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  result = (void *) ((arg1)->m_bodyB);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1refs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  btVector3FloatData *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  {
    size_t ii;
    btVector3FloatData *b = (btVector3FloatData *) arg1->m_refs;
    for (ii = 0; ii < (size_t)2; ii++) b[ii] = *((btVector3FloatData *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1refs_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  result = (btVector3FloatData *)(btVector3FloatData *) ((arg1)->m_refs);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1cfm_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_cfm = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1cfm_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  result = (float) ((arg1)->m_cfm);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1erp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_erp = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1erp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  result = (float) ((arg1)->m_erp);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1split_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_split = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1split_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  result = (float) ((arg1)->m_split);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1delete_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_delete = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1delete_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  result = (int) ((arg1)->m_delete);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1relPosition_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  btVector3FloatData *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  {
    size_t ii;
    btVector3FloatData *b = (btVector3FloatData *) arg1->m_relPosition;
    for (ii = 0; ii < (size_t)2; ii++) b[ii] = *((btVector3FloatData *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1relPosition_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  result = (btVector3FloatData *)(btVector3FloatData *) ((arg1)->m_relPosition);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1bodyAtype_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_bodyAtype = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1bodyAtype_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  result = (int) ((arg1)->m_bodyAtype);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1bodyBtype_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_bodyBtype = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1bodyBtype_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  result = (int) ((arg1)->m_bodyBtype);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1jointType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_jointType = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1jointType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  result = (int) ((arg1)->m_jointType);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1pad_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_pad = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyJointData_1pad_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  result = (int) ((arg1)->m_pad);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBodyJointData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBodyJointData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBodyJointData *)new btSoftBodyJointData();
  *(btSoftBodyJointData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBodyJointData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBodyJointData *arg1 = (btSoftBodyJointData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBodyJointData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1collisionObjectData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  btCollisionObjectFloatData *arg2 = (btCollisionObjectFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  arg2 = *(btCollisionObjectFloatData **)&jarg2; 
  if (arg1) (arg1)->m_collisionObjectData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1collisionObjectData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  btCollisionObjectFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  result = (btCollisionObjectFloatData *)& ((arg1)->m_collisionObjectData);
  *(btCollisionObjectFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1pose_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  SoftBodyPoseData *arg2 = (SoftBodyPoseData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  arg2 = *(SoftBodyPoseData **)&jarg2; 
  if (arg1) (arg1)->m_pose = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1pose_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  SoftBodyPoseData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  result = (SoftBodyPoseData *) ((arg1)->m_pose);
  *(SoftBodyPoseData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1materials_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  SoftBodyMaterialData **arg2 = (SoftBodyMaterialData **) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  arg2 = *(SoftBodyMaterialData ***)&jarg2; 
  if (arg1) (arg1)->m_materials = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1materials_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  SoftBodyMaterialData **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  result = (SoftBodyMaterialData **) ((arg1)->m_materials);
  *(SoftBodyMaterialData ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1nodes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  SoftBodyNodeData *arg2 = (SoftBodyNodeData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  arg2 = *(SoftBodyNodeData **)&jarg2; 
  if (arg1) (arg1)->m_nodes = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1nodes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  SoftBodyNodeData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  result = (SoftBodyNodeData *) ((arg1)->m_nodes);
  *(SoftBodyNodeData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1links_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  SoftBodyLinkData *arg2 = (SoftBodyLinkData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  arg2 = *(SoftBodyLinkData **)&jarg2; 
  if (arg1) (arg1)->m_links = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1links_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  SoftBodyLinkData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  result = (SoftBodyLinkData *) ((arg1)->m_links);
  *(SoftBodyLinkData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1faces_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  SoftBodyFaceData *arg2 = (SoftBodyFaceData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  arg2 = *(SoftBodyFaceData **)&jarg2; 
  if (arg1) (arg1)->m_faces = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1faces_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  SoftBodyFaceData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  result = (SoftBodyFaceData *) ((arg1)->m_faces);
  *(SoftBodyFaceData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1tetrahedra_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  SoftBodyTetraData *arg2 = (SoftBodyTetraData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  arg2 = *(SoftBodyTetraData **)&jarg2; 
  if (arg1) (arg1)->m_tetrahedra = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1tetrahedra_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  SoftBodyTetraData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  result = (SoftBodyTetraData *) ((arg1)->m_tetrahedra);
  *(SoftBodyTetraData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1anchors_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  SoftRigidAnchorData *arg2 = (SoftRigidAnchorData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  arg2 = *(SoftRigidAnchorData **)&jarg2; 
  if (arg1) (arg1)->m_anchors = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1anchors_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  SoftRigidAnchorData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  result = (SoftRigidAnchorData *) ((arg1)->m_anchors);
  *(SoftRigidAnchorData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1clusters_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  SoftBodyClusterData *arg2 = (SoftBodyClusterData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  arg2 = *(SoftBodyClusterData **)&jarg2; 
  if (arg1) (arg1)->m_clusters = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1clusters_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  SoftBodyClusterData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  result = (SoftBodyClusterData *) ((arg1)->m_clusters);
  *(SoftBodyClusterData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1joints_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  btSoftBodyJointData *arg2 = (btSoftBodyJointData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  arg2 = *(btSoftBodyJointData **)&jarg2; 
  if (arg1) (arg1)->m_joints = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1joints_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  btSoftBodyJointData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  result = (btSoftBodyJointData *) ((arg1)->m_joints);
  *(btSoftBodyJointData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1numMaterials_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numMaterials = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1numMaterials_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  result = (int) ((arg1)->m_numMaterials);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1numNodes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numNodes = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1numNodes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  result = (int) ((arg1)->m_numNodes);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1numLinks_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numLinks = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1numLinks_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  result = (int) ((arg1)->m_numLinks);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1numFaces_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numFaces = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1numFaces_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  result = (int) ((arg1)->m_numFaces);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1numTetrahedra_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numTetrahedra = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1numTetrahedra_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  result = (int) ((arg1)->m_numTetrahedra);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1numAnchors_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numAnchors = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1numAnchors_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  result = (int) ((arg1)->m_numAnchors);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1numClusters_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numClusters = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1numClusters_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  result = (int) ((arg1)->m_numClusters);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1numJoints_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numJoints = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1numJoints_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  result = (int) ((arg1)->m_numJoints);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1config_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  SoftBodyConfigData *arg2 = (SoftBodyConfigData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  arg2 = *(SoftBodyConfigData **)&jarg2; 
  if (arg1) (arg1)->m_config = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyFloatData_1config_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  SoftBodyConfigData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  result = (SoftBodyConfigData *)& ((arg1)->m_config);
  *(SoftBodyConfigData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBodyFloatData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBodyFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBodyFloatData *)new btSoftBodyFloatData();
  *(btSoftBodyFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBodyFloatData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBodyFloatData *arg1 = (btSoftBodyFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBodyFloatData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1fDrawFlags(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  fDrawFlags *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (fDrawFlags *)new fDrawFlags();
  *(fDrawFlags **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1fDrawFlags(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  fDrawFlags *arg1 = (fDrawFlags *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(fDrawFlags **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1Draw_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btIDebugDraw *arg2 = (btIDebugDraw *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btIDebugDraw **)&jarg2; 
  arg3 = (int)jarg3; 
  btSoftBodyHelpers::Draw(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1Draw_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btIDebugDraw *arg2 = (btIDebugDraw *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btIDebugDraw **)&jarg2; 
  btSoftBodyHelpers::Draw(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1DrawInfos(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3, jboolean jarg4, jboolean jarg5) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btIDebugDraw *arg2 = (btIDebugDraw *) 0 ;
  bool arg3 ;
  bool arg4 ;
  bool arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btIDebugDraw **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  arg4 = jarg4 ? true : false; 
  arg5 = jarg5 ? true : false; 
  btSoftBodyHelpers::DrawInfos(arg1,arg2,arg3,arg4,arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1DrawNodeTree_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btIDebugDraw *arg2 = (btIDebugDraw *) 0 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btIDebugDraw **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  btSoftBodyHelpers::DrawNodeTree(arg1,arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1DrawNodeTree_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btIDebugDraw *arg2 = (btIDebugDraw *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btIDebugDraw **)&jarg2; 
  arg3 = (int)jarg3; 
  btSoftBodyHelpers::DrawNodeTree(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1DrawNodeTree_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btIDebugDraw *arg2 = (btIDebugDraw *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btIDebugDraw **)&jarg2; 
  btSoftBodyHelpers::DrawNodeTree(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1DrawFaceTree_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btIDebugDraw *arg2 = (btIDebugDraw *) 0 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btIDebugDraw **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  btSoftBodyHelpers::DrawFaceTree(arg1,arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1DrawFaceTree_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btIDebugDraw *arg2 = (btIDebugDraw *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btIDebugDraw **)&jarg2; 
  arg3 = (int)jarg3; 
  btSoftBodyHelpers::DrawFaceTree(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1DrawFaceTree_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btIDebugDraw *arg2 = (btIDebugDraw *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btIDebugDraw **)&jarg2; 
  btSoftBodyHelpers::DrawFaceTree(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1DrawClusterTree_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btIDebugDraw *arg2 = (btIDebugDraw *) 0 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btIDebugDraw **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  btSoftBodyHelpers::DrawClusterTree(arg1,arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1DrawClusterTree_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btIDebugDraw *arg2 = (btIDebugDraw *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btIDebugDraw **)&jarg2; 
  arg3 = (int)jarg3; 
  btSoftBodyHelpers::DrawClusterTree(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1DrawClusterTree_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btIDebugDraw *arg2 = (btIDebugDraw *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btIDebugDraw **)&jarg2; 
  btSoftBodyHelpers::DrawClusterTree(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1DrawFrame(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btIDebugDraw *arg2 = (btIDebugDraw *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBody **)&jarg1; 
  arg2 = *(btIDebugDraw **)&jarg2; 
  btSoftBodyHelpers::DrawFrame(arg1,arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1CreateRope(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jint jarg4, jint jarg5) {
  jlong jresult = 0 ;
  btSoftBodyWorldInfo *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  int arg4 ;
  int arg5 ;
  btSoftBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBodyWorldInfo & reference is null");
    return 0;
  } 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  result = (btSoftBody *)btSoftBodyHelpers::CreateRope(*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4,arg5);
  *(btSoftBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1CreatePatch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jobject jarg5, jint jarg6, jint jarg7, jint jarg8, jboolean jarg9) {
  jlong jresult = 0 ;
  btSoftBodyWorldInfo *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  int arg6 ;
  int arg7 ;
  int arg8 ;
  bool arg9 ;
  btSoftBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBodyWorldInfo & reference is null");
    return 0;
  } 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  arg6 = (int)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (int)jarg8; 
  arg9 = jarg9 ? true : false; 
  result = (btSoftBody *)btSoftBodyHelpers::CreatePatch(*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,arg6,arg7,arg8,arg9);
  *(btSoftBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1CreatePatchUV_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jobject jarg5, jint jarg6, jint jarg7, jint jarg8, jboolean jarg9, jobject jarg10) {
  jlong jresult = 0 ;
  btSoftBodyWorldInfo *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  int arg6 ;
  int arg7 ;
  int arg8 ;
  bool arg9 ;
  float *arg10 = (float *) 0 ;
  btSoftBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBodyWorldInfo & reference is null");
    return 0;
  } 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  arg6 = (int)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (int)jarg8; 
  arg9 = jarg9 ? true : false; 
  {
    arg10 = (float*)jenv->GetDirectBufferAddress(jarg10);
    if (arg10 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  result = (btSoftBody *)btSoftBodyHelpers::CreatePatchUV(*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,arg6,arg7,arg8,arg9,arg10);
  *(btSoftBody **)&jresult = result; 
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1CreatePatchUV_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jobject jarg5, jint jarg6, jint jarg7, jint jarg8, jboolean jarg9) {
  jlong jresult = 0 ;
  btSoftBodyWorldInfo *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  int arg6 ;
  int arg7 ;
  int arg8 ;
  bool arg9 ;
  btSoftBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBodyWorldInfo & reference is null");
    return 0;
  } 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  arg6 = (int)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (int)jarg8; 
  arg9 = jarg9 ? true : false; 
  result = (btSoftBody *)btSoftBodyHelpers::CreatePatchUV(*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,arg6,arg7,arg8,arg9);
  *(btSoftBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1CalculateUV(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5) {
  jfloat jresult = 0 ;
  int arg1 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  result = (float)btSoftBodyHelpers::CalculateUV(arg1,arg2,arg3,arg4,arg5);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1CreateEllipsoid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jint jarg4) {
  jlong jresult = 0 ;
  btSoftBodyWorldInfo *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  int arg4 ;
  btSoftBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBodyWorldInfo & reference is null");
    return 0;
  } 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (int)jarg4; 
  result = (btSoftBody *)btSoftBodyHelpers::CreateEllipsoid(*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4);
  *(btSoftBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1CreateFromTriMesh_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jint jarg4, jboolean jarg5) {
  jlong jresult = 0 ;
  btSoftBodyWorldInfo *arg1 = 0 ;
  btScalar *arg2 = (btScalar *) 0 ;
  int *arg3 = (int *) 0 ;
  int arg4 ;
  bool arg5 ;
  btSoftBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBodyWorldInfo & reference is null");
    return 0;
  } 
  {
    arg2 = (btScalar*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    arg3 = (int*)jenv->GetDirectBufferAddress(jarg3);
    if (arg3 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg4 = (int)jarg4; 
  arg5 = jarg5 ? true : false; 
  result = (btSoftBody *)btSoftBodyHelpers::CreateFromTriMesh(*arg1,(float const *)arg2,(int const *)arg3,arg4,arg5);
  *(btSoftBody **)&jresult = result; 
  
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1CreateFromTriMesh_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jint jarg4) {
  jlong jresult = 0 ;
  btSoftBodyWorldInfo *arg1 = 0 ;
  btScalar *arg2 = (btScalar *) 0 ;
  int *arg3 = (int *) 0 ;
  int arg4 ;
  btSoftBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBodyWorldInfo & reference is null");
    return 0;
  } 
  {
    arg2 = (btScalar*)jenv->GetDirectBufferAddress(jarg2);
    if (arg2 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  {
    arg3 = (int*)jenv->GetDirectBufferAddress(jarg3);
    if (arg3 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg4 = (int)jarg4; 
  result = (btSoftBody *)btSoftBodyHelpers::CreateFromTriMesh(*arg1,(float const *)arg2,(int const *)arg3,arg4);
  *(btSoftBody **)&jresult = result; 
  
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1CreateFromConvexHull_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  btSoftBodyWorldInfo *arg1 = 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  int arg3 ;
  bool arg4 ;
  btSoftBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBodyWorldInfo & reference is null");
    return 0;
  } 
  arg2 = *(btVector3 **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = jarg4 ? true : false; 
  result = (btSoftBody *)btSoftBodyHelpers::CreateFromConvexHull(*arg1,(btVector3 const *)arg2,arg3,arg4);
  *(btSoftBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1CreateFromConvexHull_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  btSoftBodyWorldInfo *arg1 = 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  int arg3 ;
  btSoftBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBodyWorldInfo & reference is null");
    return 0;
  } 
  arg2 = *(btVector3 **)&jarg2; 
  arg3 = (int)jarg3; 
  result = (btSoftBody *)btSoftBodyHelpers::CreateFromConvexHull(*arg1,(btVector3 const *)arg2,arg3);
  *(btSoftBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1CreateFromTetGenData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4, jboolean jarg5, jboolean jarg6, jboolean jarg7) {
  jlong jresult = 0 ;
  btSoftBodyWorldInfo *arg1 = 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  bool arg5 ;
  bool arg6 ;
  bool arg7 ;
  btSoftBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBodyWorldInfo & reference is null");
    return 0;
  } 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = jarg5 ? true : false; 
  arg6 = jarg6 ? true : false; 
  arg7 = jarg7 ? true : false; 
  result = (btSoftBody *)btSoftBodyHelpers::CreateFromTetGenData(*arg1,(char const *)arg2,(char const *)arg3,(char const *)arg4,arg5,arg6,arg7);
  *(btSoftBody **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyHelpers_1ReoptimizeLinkOrder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  btSoftBodyHelpers::ReoptimizeLinkOrder(arg1);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBodyHelpers(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBodyHelpers *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBodyHelpers *)new btSoftBodyHelpers();
  *(btSoftBodyHelpers **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBodyHelpers(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBodyHelpers *arg1 = (btSoftBodyHelpers *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBodyHelpers **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyCollisionShape_1body_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftBodyCollisionShape *arg1 = (btSoftBodyCollisionShape *) 0 ;
  btSoftBody *arg2 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftBodyCollisionShape **)&jarg1; 
  arg2 = *(btSoftBody **)&jarg2; 
  if (arg1) (arg1)->m_body = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyCollisionShape_1body_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBodyCollisionShape *arg1 = (btSoftBodyCollisionShape *) 0 ;
  btSoftBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBodyCollisionShape **)&jarg1; 
  result = (btSoftBody *) ((arg1)->m_body);
  *(btSoftBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBodyCollisionShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody *arg1 = (btSoftBody *) 0 ;
  btSoftBodyCollisionShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody **)&jarg1; 
  result = (btSoftBodyCollisionShape *)new btSoftBodyCollisionShape(arg1);
  *(btSoftBodyCollisionShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBodyCollisionShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBodyCollisionShape *arg1 = (btSoftBodyCollisionShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBodyCollisionShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftClusterCollisionShape_1cluster_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftClusterCollisionShape *arg1 = (btSoftClusterCollisionShape *) 0 ;
  btSoftBody::Cluster *arg2 = (btSoftBody::Cluster *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftClusterCollisionShape **)&jarg1; 
  arg2 = *(btSoftBody::Cluster **)&jarg2; 
  if (arg1) (arg1)->m_cluster = (btSoftBody::Cluster const *)arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftClusterCollisionShape_1cluster_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftClusterCollisionShape *arg1 = (btSoftClusterCollisionShape *) 0 ;
  btSoftBody::Cluster *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftClusterCollisionShape **)&jarg1; 
  result = (btSoftBody::Cluster *) ((arg1)->m_cluster);
  *(btSoftBody::Cluster **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftClusterCollisionShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftBody::Cluster *arg1 = (btSoftBody::Cluster *) 0 ;
  btSoftClusterCollisionShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Cluster **)&jarg1; 
  result = (btSoftClusterCollisionShape *)new btSoftClusterCollisionShape((btSoftBody::Cluster const *)arg1);
  *(btSoftClusterCollisionShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftClusterCollisionShape_1getShapeType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftClusterCollisionShape *arg1 = (btSoftClusterCollisionShape *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftClusterCollisionShape **)&jarg1; 
  result = (int)((btSoftClusterCollisionShape const *)arg1)->getShapeType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftClusterCollisionShape(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftClusterCollisionShape *arg1 = (btSoftClusterCollisionShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftClusterCollisionShape **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_Lerp(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jfloat jarg3) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btScalar arg3 ;
  btMatrix3x3 result;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  result = Lerp((btMatrix3x3 const &)*arg1,(btMatrix3x3 const &)*arg2,arg3);
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_Clamp(JNIEnv *jenv, jclass jcls, jobject jarg1, jfloat jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btScalar arg2 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  arg2 = (btScalar)jarg2; 
  result = Clamp((btVector3 const &)*arg1,arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_ClusterMetric(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btScalar)ClusterMetric((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_ScaleAlongAxis(JNIEnv *jenv, jclass jcls, jobject jarg1, jfloat jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btScalar arg2 ;
  btMatrix3x3 result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  arg2 = (btScalar)jarg2; 
  result = ScaleAlongAxis((btVector3 const &)*arg1,arg2);
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_Cross(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jobject jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btMatrix3x3 result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  result = Cross((btVector3 const &)*arg1);
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_Diagonal(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jobject jresult = 0 ;
  btScalar arg1 ;
  btMatrix3x3 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  result = Diagonal(arg1);
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_Add(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btMatrix3x3 result;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = Add((btMatrix3x3 const &)*arg1,(btMatrix3x3 const &)*arg2);
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_Sub(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btMatrix3x3 result;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = Sub((btMatrix3x3 const &)*arg1,(btMatrix3x3 const &)*arg2);
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_Mul(JNIEnv *jenv, jclass jcls, jobject jarg1, jfloat jarg2) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btScalar arg2 ;
  btMatrix3x3 result;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  arg2 = (btScalar)jarg2; 
  result = Mul((btMatrix3x3 const &)*arg1,arg2);
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_Orthogonalize(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  btMatrix3x3 *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  Orthogonalize(*arg1);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_MassMatrix(JNIEnv *jenv, jclass jcls, jfloat jarg1, jobject jarg2, jobject jarg3) {
  jobject jresult = 0 ;
  btScalar arg1 ;
  btMatrix3x3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btMatrix3x3 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  result = MassMatrix(arg1,(btMatrix3x3 const &)*arg2,(btVector3 const &)*arg3);
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_ImpulseMatrix_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2, jfloat jarg3, jobject jarg4, jobject jarg5) {
  jobject jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btMatrix3x3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btMatrix3x3 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  btMatrix3x3 local_arg4;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  result = ImpulseMatrix(arg1,arg2,arg3,(btMatrix3x3 const &)*arg4,(btVector3 const &)*arg5);
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_ImpulseMatrix_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jfloat jarg1, jobject jarg2, jobject jarg3, jfloat jarg4, jobject jarg5, jobject jarg6) {
  jobject jresult = 0 ;
  btScalar arg1 ;
  btMatrix3x3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar arg4 ;
  btMatrix3x3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  btMatrix3x3 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (btScalar)jarg4; 
  btMatrix3x3 local_arg5;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  result = ImpulseMatrix(arg1,(btMatrix3x3 const &)*arg2,(btVector3 const &)*arg3,arg4,(btMatrix3x3 const &)*arg5,(btVector3 const &)*arg6);
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_AngularImpulseMatrix(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btMatrix3x3 result;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = AngularImpulseMatrix((btMatrix3x3 const &)*arg1,(btMatrix3x3 const &)*arg2);
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_ProjectOnAxis(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ProjectOnAxis((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_ProjectOnPlane(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jobject jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ProjectOnPlane((btVector3 const &)*arg1,(btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_ProjectOrigin_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jlong jarg4) {
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = *(btScalar **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  ProjectOrigin((btVector3 const &)*arg1,(btVector3 const &)*arg2,*arg3,*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_ProjectOrigin_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jobject jarg4, jlong jarg5) {
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = *(btScalar **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  ProjectOrigin((btVector3 const &)*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3,*arg4,*arg5);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_BaryCoord(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jobject jarg4) {
  jobject jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  result = BaryCoord((btVector3 const &)*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_ImplicitSolve_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jfloat jarg4, jint jarg5) {
  jfloat jresult = 0 ;
  btSoftBody::ImplicitFn *arg1 = (btSoftBody::ImplicitFn *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar arg4 ;
  int arg5 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::ImplicitFn **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (btScalar)jarg4; 
  arg5 = (int)jarg5; 
  result = (btScalar)ImplicitSolve(arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4,arg5);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_ImplicitSolve_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jfloat jarg4) {
  jfloat jresult = 0 ;
  btSoftBody::ImplicitFn *arg1 = (btSoftBody::ImplicitFn *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar arg4 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::ImplicitFn **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (btScalar)jarg4; 
  result = (btScalar)ImplicitSolve(arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_EvaluateMedium(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jobject jarg3_) {
  btSoftBodyWorldInfo *arg1 = (btSoftBodyWorldInfo *) 0 ;
  btVector3 *arg2 = 0 ;
  btSoftBody::sMedium *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btSoftBodyWorldInfo **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = *(btSoftBody::sMedium **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBody::sMedium & reference is null");
    return ;
  } 
  EvaluateMedium((btSoftBodyWorldInfo const *)arg1,(btVector3 const &)*arg2,*arg3);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_NormalizeAny(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jobject jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  result = NormalizeAny((btVector3 const &)*arg1);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_VolumeOf_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jlong jresult = 0 ;
  btSoftBody::Face *arg1 = 0 ;
  btScalar arg2 ;
  btDbvtVolume result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Face **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBody::Face const & reference is null");
    return 0;
  } 
  arg2 = (btScalar)jarg2; 
  result = VolumeOf((btSoftBody::Face const &)*arg1,arg2);
  *(btDbvtVolume **)&jresult = new btDbvtVolume((const btDbvtVolume &)result); 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_CenterOf(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSoftBody::Face *arg1 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Face **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBody::Face const & reference is null");
    return 0;
  } 
  result = CenterOf((btSoftBody::Face const &)*arg1);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_AreaOf(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  result = (btScalar)AreaOf((btVector3 const &)*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_VolumeOf_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jobject jarg4) {
  jfloat jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  result = (btScalar)VolumeOf((btVector3 const &)*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_ApplyClampedForce(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3) {
  btSoftBody::Node *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftBody::Node **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBody::Node & reference is null");
    return ;
  } 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  ApplyClampedForce(*arg1,(btVector3 const &)*arg2,arg3);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_MatchEdge(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jint jresult = 0 ;
  btSoftBody::Node *arg1 = (btSoftBody::Node *) 0 ;
  btSoftBody::Node *arg2 = (btSoftBody::Node *) 0 ;
  btSoftBody::Node *arg3 = (btSoftBody::Node *) 0 ;
  btSoftBody::Node *arg4 = (btSoftBody::Node *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btSoftBody::Node **)&jarg1; 
  arg2 = *(btSoftBody::Node **)&jarg2; 
  arg3 = *(btSoftBody::Node **)&jarg3; 
  arg4 = *(btSoftBody::Node **)&jarg4; 
  result = (int)MatchEdge((btSoftBody::Node const *)arg1,(btSoftBody::Node const *)arg2,(btSoftBody::Node const *)arg3,(btSoftBody::Node const *)arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btEigen_1system_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jint jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btMatrix3x3 *arg2 = (btMatrix3x3 *) 0 ;
  btVector3 *arg3 = (btVector3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg3_;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  arg2 = *(btMatrix3x3 **)&jarg2; 
  arg3 = *(btVector3 **)&jarg3; 
  result = (int)btEigen::system(*arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btEigen_1system_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btMatrix3x3 *arg2 = (btMatrix3x3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  arg2 = *(btMatrix3x3 **)&jarg2; 
  result = (int)btEigen::system(*arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btEigen(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btEigen *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btEigen *)new btEigen();
  *(btEigen **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btEigen(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btEigen *arg1 = (btEigen *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btEigen **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_PolarDecompose(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3) {
  jint jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btMatrix3x3 *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btMatrix3x3 local_arg3;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  result = (int)PolarDecompose((btMatrix3x3 const &)*arg1,*arg2,*arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1ClusterBase_1erp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftColliders::ClusterBase *arg1 = (btSoftColliders::ClusterBase *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::ClusterBase **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->erp = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1ClusterBase_1erp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftColliders::ClusterBase *arg1 = (btSoftColliders::ClusterBase *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::ClusterBase **)&jarg1; 
  result = (btScalar) ((arg1)->erp);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1ClusterBase_1idt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftColliders::ClusterBase *arg1 = (btSoftColliders::ClusterBase *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::ClusterBase **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->idt = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1ClusterBase_1idt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftColliders::ClusterBase *arg1 = (btSoftColliders::ClusterBase *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::ClusterBase **)&jarg1; 
  result = (btScalar) ((arg1)->idt);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1ClusterBase_1margin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftColliders::ClusterBase *arg1 = (btSoftColliders::ClusterBase *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::ClusterBase **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_margin = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1ClusterBase_1margin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftColliders::ClusterBase *arg1 = (btSoftColliders::ClusterBase *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::ClusterBase **)&jarg1; 
  result = (btScalar) ((arg1)->m_margin);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1ClusterBase_1friction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftColliders::ClusterBase *arg1 = (btSoftColliders::ClusterBase *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::ClusterBase **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->friction = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1ClusterBase_1friction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftColliders::ClusterBase *arg1 = (btSoftColliders::ClusterBase *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::ClusterBase **)&jarg1; 
  result = (btScalar) ((arg1)->friction);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1ClusterBase_1threshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftColliders::ClusterBase *arg1 = (btSoftColliders::ClusterBase *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::ClusterBase **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->threshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1ClusterBase_1threshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftColliders::ClusterBase *arg1 = (btSoftColliders::ClusterBase *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::ClusterBase **)&jarg1; 
  result = (btScalar) ((arg1)->threshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftColliders_1ClusterBase(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftColliders::ClusterBase *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftColliders::ClusterBase *)new btSoftColliders::ClusterBase();
  *(btSoftColliders::ClusterBase **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1ClusterBase_1SolveContact(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jboolean jresult = 0 ;
  btSoftColliders::ClusterBase *arg1 = (btSoftColliders::ClusterBase *) 0 ;
  btGjkEpaSolver2::sResults *arg2 = 0 ;
  btSoftBody::Body arg3 ;
  btSoftBody::Body arg4 ;
  btSoftBody::CJoint *arg5 = 0 ;
  btSoftBody::Body *argp3 ;
  btSoftBody::Body const *argp4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(btSoftColliders::ClusterBase **)&jarg1; 
  arg2 = *(btGjkEpaSolver2::sResults **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btGjkEpaSolver2::sResults const & reference is null");
    return 0;
  } 
  argp3 = *(btSoftBody::Body **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null btSoftBody::Body");
    return 0;
  }
  arg3 = *argp3; 
  argp4 = *(btSoftBody::Body **)&jarg4; 
  if (!argp4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null btSoftBody::Body const");
    return 0;
  }
  arg4 = *argp4; 
  arg5 = *(btSoftBody::CJoint **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBody::CJoint & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->SolveContact((btGjkEpaSolver2::sResults const &)*arg2,arg3,arg4,*arg5);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftColliders_1ClusterBase(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftColliders::ClusterBase *arg1 = (btSoftColliders::ClusterBase *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftColliders::ClusterBase **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideCL_1RS_1psb_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftColliders::CollideCL_RS *arg1 = (btSoftColliders::CollideCL_RS *) 0 ;
  btSoftBody *arg2 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftColliders::CollideCL_RS **)&jarg1; 
  arg2 = *(btSoftBody **)&jarg2; 
  if (arg1) (arg1)->psb = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideCL_1RS_1psb_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftColliders::CollideCL_RS *arg1 = (btSoftColliders::CollideCL_RS *) 0 ;
  btSoftBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::CollideCL_RS **)&jarg1; 
  result = (btSoftBody *) ((arg1)->psb);
  *(btSoftBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideCL_1RS_1colObjWrap_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftColliders::CollideCL_RS *arg1 = (btSoftColliders::CollideCL_RS *) 0 ;
  btCollisionObjectWrapper *arg2 = (btCollisionObjectWrapper *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftColliders::CollideCL_RS **)&jarg1; 
  arg2 = *(btCollisionObjectWrapper **)&jarg2; 
  if (arg1) (arg1)->m_colObjWrap = (btCollisionObjectWrapper const *)arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideCL_1RS_1colObjWrap_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftColliders::CollideCL_RS *arg1 = (btSoftColliders::CollideCL_RS *) 0 ;
  btCollisionObjectWrapper *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::CollideCL_RS **)&jarg1; 
  result = (btCollisionObjectWrapper *) ((arg1)->m_colObjWrap);
  *(btCollisionObjectWrapper **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideCL_1RS_1ProcessColObj(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btSoftColliders::CollideCL_RS *arg1 = (btSoftColliders::CollideCL_RS *) 0 ;
  btSoftBody *arg2 = (btSoftBody *) 0 ;
  btCollisionObjectWrapper *arg3 = (btCollisionObjectWrapper *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btSoftColliders::CollideCL_RS **)&jarg1; 
  arg2 = *(btSoftBody **)&jarg2; 
  arg3 = *(btCollisionObjectWrapper **)&jarg3; 
  (arg1)->ProcessColObj(arg2,(btCollisionObjectWrapper const *)arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftColliders_1CollideCL_1RS(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftColliders::CollideCL_RS *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftColliders::CollideCL_RS *)new btSoftColliders::CollideCL_RS();
  *(btSoftColliders::CollideCL_RS **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftColliders_1CollideCL_1RS(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftColliders::CollideCL_RS *arg1 = (btSoftColliders::CollideCL_RS *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftColliders::CollideCL_RS **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideCL_1SS_1bodies_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftColliders::CollideCL_SS *arg1 = (btSoftColliders::CollideCL_SS *) 0 ;
  btSoftBody **arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::CollideCL_SS **)&jarg1; 
  arg2 = *(btSoftBody ***)&jarg2; 
  {
    size_t ii;
    btSoftBody * *b = (btSoftBody * *) arg1->bodies;
    for (ii = 0; ii < (size_t)2; ii++) b[ii] = *((btSoftBody * *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideCL_1SS_1bodies_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftColliders::CollideCL_SS *arg1 = (btSoftColliders::CollideCL_SS *) 0 ;
  btSoftBody **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::CollideCL_SS **)&jarg1; 
  result = (btSoftBody **)(btSoftBody **) ((arg1)->bodies);
  *(btSoftBody ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideCL_1SS_1ProcessSoftSoft(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btSoftColliders::CollideCL_SS *arg1 = (btSoftColliders::CollideCL_SS *) 0 ;
  btSoftBody *arg2 = (btSoftBody *) 0 ;
  btSoftBody *arg3 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btSoftColliders::CollideCL_SS **)&jarg1; 
  arg2 = *(btSoftBody **)&jarg2; 
  arg3 = *(btSoftBody **)&jarg3; 
  (arg1)->ProcessSoftSoft(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftColliders_1CollideCL_1SS(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftColliders::CollideCL_SS *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftColliders::CollideCL_SS *)new btSoftColliders::CollideCL_SS();
  *(btSoftColliders::CollideCL_SS **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftColliders_1CollideCL_1SS(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftColliders::CollideCL_SS *arg1 = (btSoftColliders::CollideCL_SS *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftColliders::CollideCL_SS **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideSDF_1RS_1DoNode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftColliders::CollideSDF_RS *arg1 = (btSoftColliders::CollideSDF_RS *) 0 ;
  btSoftBody::Node *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftColliders::CollideSDF_RS **)&jarg1; 
  arg2 = *(btSoftBody::Node **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSoftBody::Node & reference is null");
    return ;
  } 
  ((btSoftColliders::CollideSDF_RS const *)arg1)->DoNode(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideSDF_1RS_1psb_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftColliders::CollideSDF_RS *arg1 = (btSoftColliders::CollideSDF_RS *) 0 ;
  btSoftBody *arg2 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftColliders::CollideSDF_RS **)&jarg1; 
  arg2 = *(btSoftBody **)&jarg2; 
  if (arg1) (arg1)->psb = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideSDF_1RS_1psb_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftColliders::CollideSDF_RS *arg1 = (btSoftColliders::CollideSDF_RS *) 0 ;
  btSoftBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::CollideSDF_RS **)&jarg1; 
  result = (btSoftBody *) ((arg1)->psb);
  *(btSoftBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideSDF_1RS_1colObj1Wrap_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftColliders::CollideSDF_RS *arg1 = (btSoftColliders::CollideSDF_RS *) 0 ;
  btCollisionObjectWrapper *arg2 = (btCollisionObjectWrapper *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftColliders::CollideSDF_RS **)&jarg1; 
  arg2 = *(btCollisionObjectWrapper **)&jarg2; 
  if (arg1) (arg1)->m_colObj1Wrap = (btCollisionObjectWrapper const *)arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideSDF_1RS_1colObj1Wrap_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftColliders::CollideSDF_RS *arg1 = (btSoftColliders::CollideSDF_RS *) 0 ;
  btCollisionObjectWrapper *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::CollideSDF_RS **)&jarg1; 
  result = (btCollisionObjectWrapper *) ((arg1)->m_colObj1Wrap);
  *(btCollisionObjectWrapper **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideSDF_1RS_1rigidBody_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftColliders::CollideSDF_RS *arg1 = (btSoftColliders::CollideSDF_RS *) 0 ;
  btRigidBody *arg2 = (btRigidBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftColliders::CollideSDF_RS **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2; 
  if (arg1) (arg1)->m_rigidBody = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideSDF_1RS_1rigidBody_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftColliders::CollideSDF_RS *arg1 = (btSoftColliders::CollideSDF_RS *) 0 ;
  btRigidBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::CollideSDF_RS **)&jarg1; 
  result = (btRigidBody *) ((arg1)->m_rigidBody);
  *(btRigidBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideSDF_1RS_1dynmargin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftColliders::CollideSDF_RS *arg1 = (btSoftColliders::CollideSDF_RS *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::CollideSDF_RS **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->dynmargin = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideSDF_1RS_1dynmargin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftColliders::CollideSDF_RS *arg1 = (btSoftColliders::CollideSDF_RS *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::CollideSDF_RS **)&jarg1; 
  result = (btScalar) ((arg1)->dynmargin);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideSDF_1RS_1stamargin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftColliders::CollideSDF_RS *arg1 = (btSoftColliders::CollideSDF_RS *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::CollideSDF_RS **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->stamargin = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideSDF_1RS_1stamargin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftColliders::CollideSDF_RS *arg1 = (btSoftColliders::CollideSDF_RS *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::CollideSDF_RS **)&jarg1; 
  result = (btScalar) ((arg1)->stamargin);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftColliders_1CollideSDF_1RS(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftColliders::CollideSDF_RS *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftColliders::CollideSDF_RS *)new btSoftColliders::CollideSDF_RS();
  *(btSoftColliders::CollideSDF_RS **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftColliders_1CollideSDF_1RS(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftColliders::CollideSDF_RS *arg1 = (btSoftColliders::CollideSDF_RS *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftColliders::CollideSDF_RS **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideVF_1SS_1psb_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSoftColliders::CollideVF_SS *arg1 = (btSoftColliders::CollideVF_SS *) 0 ;
  btSoftBody **arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::CollideVF_SS **)&jarg1; 
  arg2 = *(btSoftBody ***)&jarg2; 
  {
    size_t ii;
    btSoftBody * *b = (btSoftBody * *) arg1->psb;
    for (ii = 0; ii < (size_t)2; ii++) b[ii] = *((btSoftBody * *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideVF_1SS_1psb_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftColliders::CollideVF_SS *arg1 = (btSoftColliders::CollideVF_SS *) 0 ;
  btSoftBody **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::CollideVF_SS **)&jarg1; 
  result = (btSoftBody **)(btSoftBody **) ((arg1)->psb);
  *(btSoftBody ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideVF_1SS_1mrg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSoftColliders::CollideVF_SS *arg1 = (btSoftColliders::CollideVF_SS *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::CollideVF_SS **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->mrg = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideVF_1SS_1mrg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSoftColliders::CollideVF_SS *arg1 = (btSoftColliders::CollideVF_SS *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftColliders::CollideVF_SS **)&jarg1; 
  result = (btScalar) ((arg1)->mrg);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftColliders_1CollideVF_1SS(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftColliders::CollideVF_SS *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftColliders::CollideVF_SS *)new btSoftColliders::CollideVF_SS();
  *(btSoftColliders::CollideVF_SS **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftColliders_1CollideVF_1SS(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftColliders::CollideVF_SS *arg1 = (btSoftColliders::CollideVF_SS *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftColliders::CollideVF_SS **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftColliders(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftColliders *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftColliders *)new btSoftColliders();
  *(btSoftColliders **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftColliders(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftColliders *arg1 = (btSoftColliders *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftColliders **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBodyRigidBodyCollisionConfiguration_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDefaultCollisionConstructionInfo *arg1 = 0 ;
  btSoftBodyRigidBodyCollisionConfiguration *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDefaultCollisionConstructionInfo **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btDefaultCollisionConstructionInfo const & reference is null");
    return 0;
  } 
  result = (btSoftBodyRigidBodyCollisionConfiguration *)new btSoftBodyRigidBodyCollisionConfiguration((btDefaultCollisionConstructionInfo const &)*arg1);
  *(btSoftBodyRigidBodyCollisionConfiguration **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftBodyRigidBodyCollisionConfiguration_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftBodyRigidBodyCollisionConfiguration *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftBodyRigidBodyCollisionConfiguration *)new btSoftBodyRigidBodyCollisionConfiguration();
  *(btSoftBodyRigidBodyCollisionConfiguration **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftBodyRigidBodyCollisionConfiguration(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftBodyRigidBodyCollisionConfiguration *arg1 = (btSoftBodyRigidBodyCollisionConfiguration *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftBodyRigidBodyCollisionConfiguration **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btVertexBufferDescriptor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btVertexBufferDescriptor *arg1 = (btVertexBufferDescriptor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btVertexBufferDescriptor **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btVertexBufferDescriptor_1hasVertexPositions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btVertexBufferDescriptor *arg1 = (btVertexBufferDescriptor *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVertexBufferDescriptor **)&jarg1; 
  result = (bool)((btVertexBufferDescriptor const *)arg1)->hasVertexPositions();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btVertexBufferDescriptor_1hasNormals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btVertexBufferDescriptor *arg1 = (btVertexBufferDescriptor *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVertexBufferDescriptor **)&jarg1; 
  result = (bool)((btVertexBufferDescriptor const *)arg1)->hasNormals();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btVertexBufferDescriptor_1getBufferType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btVertexBufferDescriptor *arg1 = (btVertexBufferDescriptor *) 0 ;
  btVertexBufferDescriptor::BufferTypes result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVertexBufferDescriptor **)&jarg1; 
  result = (btVertexBufferDescriptor::BufferTypes)((btVertexBufferDescriptor const *)arg1)->getBufferType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btVertexBufferDescriptor_1getVertexOffset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btVertexBufferDescriptor *arg1 = (btVertexBufferDescriptor *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVertexBufferDescriptor **)&jarg1; 
  result = (int)((btVertexBufferDescriptor const *)arg1)->getVertexOffset();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btVertexBufferDescriptor_1getVertexStride(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btVertexBufferDescriptor *arg1 = (btVertexBufferDescriptor *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVertexBufferDescriptor **)&jarg1; 
  result = (int)((btVertexBufferDescriptor const *)arg1)->getVertexStride();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btVertexBufferDescriptor_1getNormalOffset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btVertexBufferDescriptor *arg1 = (btVertexBufferDescriptor *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVertexBufferDescriptor **)&jarg1; 
  result = (int)((btVertexBufferDescriptor const *)arg1)->getNormalOffset();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btVertexBufferDescriptor_1getNormalStride(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btVertexBufferDescriptor *arg1 = (btVertexBufferDescriptor *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btVertexBufferDescriptor **)&jarg1; 
  result = (int)((btVertexBufferDescriptor const *)arg1)->getNormalStride();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btCPUVertexBufferDescriptor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  float *arg1 = (float *) 0 ;
  int arg2 ;
  int arg3 ;
  btCPUVertexBufferDescriptor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    arg1 = (float*)jenv->GetDirectBufferAddress(jarg1);
    if (arg1 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (btCPUVertexBufferDescriptor *)new btCPUVertexBufferDescriptor(arg1,arg2,arg3);
  *(btCPUVertexBufferDescriptor **)&jresult = result; 
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btCPUVertexBufferDescriptor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5) {
  jlong jresult = 0 ;
  float *arg1 = (float *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  btCPUVertexBufferDescriptor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    arg1 = (float*)jenv->GetDirectBufferAddress(jarg1);
    if (arg1 == NULL) {
      SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Unable to get address of direct buffer. Buffer must be allocated direct.");
    }
  }
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  result = (btCPUVertexBufferDescriptor *)new btCPUVertexBufferDescriptor(arg1,arg2,arg3,arg4,arg5);
  *(btCPUVertexBufferDescriptor **)&jresult = result; 
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btCPUVertexBufferDescriptor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCPUVertexBufferDescriptor *arg1 = (btCPUVertexBufferDescriptor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCPUVertexBufferDescriptor **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btCPUVertexBufferDescriptor_1getBasePointer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btCPUVertexBufferDescriptor *arg1 = (btCPUVertexBufferDescriptor *) 0 ;
  float *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCPUVertexBufferDescriptor **)&jarg1; 
  result = (float *)((btCPUVertexBufferDescriptor const *)arg1)->getBasePointer();
  *(float **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftRigidCollisionAlgorithm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jboolean jarg5) {
  jlong jresult = 0 ;
  btPersistentManifold *arg1 = (btPersistentManifold *) 0 ;
  btCollisionAlgorithmConstructionInfo *arg2 = 0 ;
  btCollisionObjectWrapper *arg3 = (btCollisionObjectWrapper *) 0 ;
  btCollisionObjectWrapper *arg4 = (btCollisionObjectWrapper *) 0 ;
  bool arg5 ;
  btSoftRigidCollisionAlgorithm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btPersistentManifold **)&jarg1; 
  arg2 = *(btCollisionAlgorithmConstructionInfo **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btCollisionAlgorithmConstructionInfo const & reference is null");
    return 0;
  } 
  arg3 = *(btCollisionObjectWrapper **)&jarg3; 
  arg4 = *(btCollisionObjectWrapper **)&jarg4; 
  arg5 = jarg5 ? true : false; 
  result = (btSoftRigidCollisionAlgorithm *)new btSoftRigidCollisionAlgorithm(arg1,(btCollisionAlgorithmConstructionInfo const &)*arg2,(btCollisionObjectWrapper const *)arg3,(btCollisionObjectWrapper const *)arg4,arg5);
  *(btSoftRigidCollisionAlgorithm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftRigidCollisionAlgorithm(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftRigidCollisionAlgorithm *arg1 = (btSoftRigidCollisionAlgorithm *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftRigidCollisionAlgorithm **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftRigidCollisionAlgorithm_1CreateFunc(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftRigidCollisionAlgorithm::CreateFunc *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftRigidCollisionAlgorithm::CreateFunc *)new btSoftRigidCollisionAlgorithm::CreateFunc();
  *(btSoftRigidCollisionAlgorithm::CreateFunc **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftRigidCollisionAlgorithm_1CreateFunc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftRigidCollisionAlgorithm::CreateFunc *arg1 = (btSoftRigidCollisionAlgorithm::CreateFunc *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftRigidCollisionAlgorithm::CreateFunc **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftRigidDynamicsWorld_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btBroadphaseInterface *arg2 = (btBroadphaseInterface *) 0 ;
  btConstraintSolver *arg3 = (btConstraintSolver *) 0 ;
  btCollisionConfiguration *arg4 = (btCollisionConfiguration *) 0 ;
  btSoftBodySolver *arg5 = (btSoftBodySolver *) 0 ;
  btSoftRigidDynamicsWorld *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btBroadphaseInterface **)&jarg2; 
  arg3 = *(btConstraintSolver **)&jarg3; 
  arg4 = *(btCollisionConfiguration **)&jarg4; 
  arg5 = *(btSoftBodySolver **)&jarg5; 
  result = (btSoftRigidDynamicsWorld *)new btSoftRigidDynamicsWorld(arg1,arg2,arg3,arg4,arg5);
  *(btSoftRigidDynamicsWorld **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftRigidDynamicsWorld_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btBroadphaseInterface *arg2 = (btBroadphaseInterface *) 0 ;
  btConstraintSolver *arg3 = (btConstraintSolver *) 0 ;
  btCollisionConfiguration *arg4 = (btCollisionConfiguration *) 0 ;
  btSoftRigidDynamicsWorld *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btBroadphaseInterface **)&jarg2; 
  arg3 = *(btConstraintSolver **)&jarg3; 
  arg4 = *(btCollisionConfiguration **)&jarg4; 
  result = (btSoftRigidDynamicsWorld *)new btSoftRigidDynamicsWorld(arg1,arg2,arg3,arg4);
  *(btSoftRigidDynamicsWorld **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftRigidDynamicsWorld(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftRigidDynamicsWorld *arg1 = (btSoftRigidDynamicsWorld *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftRigidDynamicsWorld **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftRigidDynamicsWorld_1addSoftBody_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  btSoftRigidDynamicsWorld *arg1 = (btSoftRigidDynamicsWorld *) 0 ;
  btSoftBody *arg2 = (btSoftBody *) 0 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftRigidDynamicsWorld **)&jarg1; 
  arg2 = *(btSoftBody **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->addSoftBody(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftRigidDynamicsWorld_1addSoftBody_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  btSoftRigidDynamicsWorld *arg1 = (btSoftRigidDynamicsWorld *) 0 ;
  btSoftBody *arg2 = (btSoftBody *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftRigidDynamicsWorld **)&jarg1; 
  arg2 = *(btSoftBody **)&jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->addSoftBody(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftRigidDynamicsWorld_1addSoftBody_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftRigidDynamicsWorld *arg1 = (btSoftRigidDynamicsWorld *) 0 ;
  btSoftBody *arg2 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftRigidDynamicsWorld **)&jarg1; 
  arg2 = *(btSoftBody **)&jarg2; 
  (arg1)->addSoftBody(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftRigidDynamicsWorld_1removeSoftBody(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftRigidDynamicsWorld *arg1 = (btSoftRigidDynamicsWorld *) 0 ;
  btSoftBody *arg2 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftRigidDynamicsWorld **)&jarg1; 
  arg2 = *(btSoftBody **)&jarg2; 
  (arg1)->removeSoftBody(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftRigidDynamicsWorld_1getDrawFlags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftRigidDynamicsWorld *arg1 = (btSoftRigidDynamicsWorld *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftRigidDynamicsWorld **)&jarg1; 
  result = (int)((btSoftRigidDynamicsWorld const *)arg1)->getDrawFlags();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftRigidDynamicsWorld_1setDrawFlags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftRigidDynamicsWorld *arg1 = (btSoftRigidDynamicsWorld *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftRigidDynamicsWorld **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setDrawFlags(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftRigidDynamicsWorld_1getWorldInfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftRigidDynamicsWorld *arg1 = (btSoftRigidDynamicsWorld *) 0 ;
  btSoftBodyWorldInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftRigidDynamicsWorld **)&jarg1; 
  result = (btSoftBodyWorldInfo *) &(arg1)->getWorldInfo();
  *(btSoftBodyWorldInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftRigidDynamicsWorld_1getWorldInfoConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftRigidDynamicsWorld *arg1 = (btSoftRigidDynamicsWorld *) 0 ;
  btSoftBodyWorldInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftRigidDynamicsWorld **)&jarg1; 
  result = (btSoftBodyWorldInfo *) &((btSoftRigidDynamicsWorld const *)arg1)->getWorldInfo();
  *(btSoftBodyWorldInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftRigidDynamicsWorld_1getSoftBodyArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftRigidDynamicsWorld *arg1 = (btSoftRigidDynamicsWorld *) 0 ;
  btSoftBodyArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftRigidDynamicsWorld **)&jarg1; 
  result = (btSoftBodyArray *) &(arg1)->getSoftBodyArray();
  *(btSoftBodyArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftRigidDynamicsWorld_1getSoftBodyArrayConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftRigidDynamicsWorld *arg1 = (btSoftRigidDynamicsWorld *) 0 ;
  btSoftBodyArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftRigidDynamicsWorld **)&jarg1; 
  result = (btSoftBodyArray *) &((btSoftRigidDynamicsWorld const *)arg1)->getSoftBodyArray();
  *(btSoftBodyArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftRigidDynamicsWorld_1rayTestSingle(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jobject jarg5, jlong jarg6, jobject jarg6_) {
  btTransform *arg1 = 0 ;
  btTransform *arg2 = 0 ;
  btCollisionObject *arg3 = (btCollisionObject *) 0 ;
  btCollisionShape *arg4 = (btCollisionShape *) 0 ;
  btTransform *arg5 = 0 ;
  btCollisionWorld::RayResultCallback *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg6_;
  btTransform local_arg1;
  gdx_setbtTransformFromMatrix4(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix4 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = *(btCollisionObject **)&jarg3; 
  arg4 = *(btCollisionShape **)&jarg4; 
  btTransform local_arg5;
  gdx_setbtTransformFromMatrix4(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix4 auto_commit_arg5(jenv, jarg5, &local_arg5);
  arg6 = *(btCollisionWorld::RayResultCallback **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btCollisionWorld::RayResultCallback & reference is null");
    return ;
  } 
  btSoftRigidDynamicsWorld::rayTestSingle((btTransform const &)*arg1,(btTransform const &)*arg2,arg3,(btCollisionShape const *)arg4,(btTransform const &)*arg5,*arg6);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftSoftCollisionAlgorithm_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btCollisionAlgorithmConstructionInfo *arg1 = 0 ;
  btSoftSoftCollisionAlgorithm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCollisionAlgorithmConstructionInfo **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btCollisionAlgorithmConstructionInfo const & reference is null");
    return 0;
  } 
  result = (btSoftSoftCollisionAlgorithm *)new btSoftSoftCollisionAlgorithm((btCollisionAlgorithmConstructionInfo const &)*arg1);
  *(btSoftSoftCollisionAlgorithm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftSoftCollisionAlgorithm_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  btPersistentManifold *arg1 = (btPersistentManifold *) 0 ;
  btCollisionAlgorithmConstructionInfo *arg2 = 0 ;
  btCollisionObjectWrapper *arg3 = (btCollisionObjectWrapper *) 0 ;
  btCollisionObjectWrapper *arg4 = (btCollisionObjectWrapper *) 0 ;
  btSoftSoftCollisionAlgorithm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btPersistentManifold **)&jarg1; 
  arg2 = *(btCollisionAlgorithmConstructionInfo **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btCollisionAlgorithmConstructionInfo const & reference is null");
    return 0;
  } 
  arg3 = *(btCollisionObjectWrapper **)&jarg3; 
  arg4 = *(btCollisionObjectWrapper **)&jarg4; 
  result = (btSoftSoftCollisionAlgorithm *)new btSoftSoftCollisionAlgorithm(arg1,(btCollisionAlgorithmConstructionInfo const &)*arg2,(btCollisionObjectWrapper const *)arg3,(btCollisionObjectWrapper const *)arg4);
  *(btSoftSoftCollisionAlgorithm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftSoftCollisionAlgorithm(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftSoftCollisionAlgorithm *arg1 = (btSoftSoftCollisionAlgorithm *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftSoftCollisionAlgorithm **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftSoftCollisionAlgorithm_1CreateFunc(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSoftSoftCollisionAlgorithm::CreateFunc *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSoftSoftCollisionAlgorithm::CreateFunc *)new btSoftSoftCollisionAlgorithm::CreateFunc();
  *(btSoftSoftCollisionAlgorithm::CreateFunc **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftSoftCollisionAlgorithm_1CreateFunc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftSoftCollisionAlgorithm::CreateFunc *arg1 = (btSoftSoftCollisionAlgorithm::CreateFunc *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftSoftCollisionAlgorithm::CreateFunc **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftMultiBodyDynamicsWorld_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btBroadphaseInterface *arg2 = (btBroadphaseInterface *) 0 ;
  btMultiBodyConstraintSolver *arg3 = (btMultiBodyConstraintSolver *) 0 ;
  btCollisionConfiguration *arg4 = (btCollisionConfiguration *) 0 ;
  btSoftBodySolver *arg5 = (btSoftBodySolver *) 0 ;
  btSoftMultiBodyDynamicsWorld *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btBroadphaseInterface **)&jarg2; 
  arg3 = *(btMultiBodyConstraintSolver **)&jarg3; 
  arg4 = *(btCollisionConfiguration **)&jarg4; 
  arg5 = *(btSoftBodySolver **)&jarg5; 
  result = (btSoftMultiBodyDynamicsWorld *)new btSoftMultiBodyDynamicsWorld(arg1,arg2,arg3,arg4,arg5);
  *(btSoftMultiBodyDynamicsWorld **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_new_1btSoftMultiBodyDynamicsWorld_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btBroadphaseInterface *arg2 = (btBroadphaseInterface *) 0 ;
  btMultiBodyConstraintSolver *arg3 = (btMultiBodyConstraintSolver *) 0 ;
  btCollisionConfiguration *arg4 = (btCollisionConfiguration *) 0 ;
  btSoftMultiBodyDynamicsWorld *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btBroadphaseInterface **)&jarg2; 
  arg3 = *(btMultiBodyConstraintSolver **)&jarg3; 
  arg4 = *(btCollisionConfiguration **)&jarg4; 
  result = (btSoftMultiBodyDynamicsWorld *)new btSoftMultiBodyDynamicsWorld(arg1,arg2,arg3,arg4);
  *(btSoftMultiBodyDynamicsWorld **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_delete_1btSoftMultiBodyDynamicsWorld(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSoftMultiBodyDynamicsWorld *arg1 = (btSoftMultiBodyDynamicsWorld *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSoftMultiBodyDynamicsWorld **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftMultiBodyDynamicsWorld_1addSoftBody_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  btSoftMultiBodyDynamicsWorld *arg1 = (btSoftMultiBodyDynamicsWorld *) 0 ;
  btSoftBody *arg2 = (btSoftBody *) 0 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftMultiBodyDynamicsWorld **)&jarg1; 
  arg2 = *(btSoftBody **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->addSoftBody(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftMultiBodyDynamicsWorld_1addSoftBody_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  btSoftMultiBodyDynamicsWorld *arg1 = (btSoftMultiBodyDynamicsWorld *) 0 ;
  btSoftBody *arg2 = (btSoftBody *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftMultiBodyDynamicsWorld **)&jarg1; 
  arg2 = *(btSoftBody **)&jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->addSoftBody(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftMultiBodyDynamicsWorld_1addSoftBody_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftMultiBodyDynamicsWorld *arg1 = (btSoftMultiBodyDynamicsWorld *) 0 ;
  btSoftBody *arg2 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftMultiBodyDynamicsWorld **)&jarg1; 
  arg2 = *(btSoftBody **)&jarg2; 
  (arg1)->addSoftBody(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftMultiBodyDynamicsWorld_1removeSoftBody(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSoftMultiBodyDynamicsWorld *arg1 = (btSoftMultiBodyDynamicsWorld *) 0 ;
  btSoftBody *arg2 = (btSoftBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSoftMultiBodyDynamicsWorld **)&jarg1; 
  arg2 = *(btSoftBody **)&jarg2; 
  (arg1)->removeSoftBody(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftMultiBodyDynamicsWorld_1getDrawFlags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSoftMultiBodyDynamicsWorld *arg1 = (btSoftMultiBodyDynamicsWorld *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftMultiBodyDynamicsWorld **)&jarg1; 
  result = (int)((btSoftMultiBodyDynamicsWorld const *)arg1)->getDrawFlags();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftMultiBodyDynamicsWorld_1setDrawFlags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSoftMultiBodyDynamicsWorld *arg1 = (btSoftMultiBodyDynamicsWorld *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftMultiBodyDynamicsWorld **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setDrawFlags(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftMultiBodyDynamicsWorld_1getWorldInfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftMultiBodyDynamicsWorld *arg1 = (btSoftMultiBodyDynamicsWorld *) 0 ;
  btSoftBodyWorldInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftMultiBodyDynamicsWorld **)&jarg1; 
  result = (btSoftBodyWorldInfo *) &(arg1)->getWorldInfo();
  *(btSoftBodyWorldInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftMultiBodyDynamicsWorld_1getWorldInfoConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftMultiBodyDynamicsWorld *arg1 = (btSoftMultiBodyDynamicsWorld *) 0 ;
  btSoftBodyWorldInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftMultiBodyDynamicsWorld **)&jarg1; 
  result = (btSoftBodyWorldInfo *) &((btSoftMultiBodyDynamicsWorld const *)arg1)->getWorldInfo();
  *(btSoftBodyWorldInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftMultiBodyDynamicsWorld_1getSoftBodyArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftMultiBodyDynamicsWorld *arg1 = (btSoftMultiBodyDynamicsWorld *) 0 ;
  btSoftBodyArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftMultiBodyDynamicsWorld **)&jarg1; 
  result = (btSoftBodyArray *) &(arg1)->getSoftBodyArray();
  *(btSoftBodyArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftMultiBodyDynamicsWorld_1getSoftBodyArrayConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSoftMultiBodyDynamicsWorld *arg1 = (btSoftMultiBodyDynamicsWorld *) 0 ;
  btSoftBodyArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSoftMultiBodyDynamicsWorld **)&jarg1; 
  result = (btSoftBodyArray *) &((btSoftMultiBodyDynamicsWorld const *)arg1)->getSoftBodyArray();
  *(btSoftBodyArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftMultiBodyDynamicsWorld_1rayTestSingle(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jobject jarg5, jlong jarg6, jobject jarg6_) {
  btTransform *arg1 = 0 ;
  btTransform *arg2 = 0 ;
  btCollisionObject *arg3 = (btCollisionObject *) 0 ;
  btCollisionShape *arg4 = (btCollisionShape *) 0 ;
  btTransform *arg5 = 0 ;
  btCollisionWorld::RayResultCallback *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg6_;
  btTransform local_arg1;
  gdx_setbtTransformFromMatrix4(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix4 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = *(btCollisionObject **)&jarg3; 
  arg4 = *(btCollisionShape **)&jarg4; 
  btTransform local_arg5;
  gdx_setbtTransformFromMatrix4(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix4 auto_commit_arg5(jenv, jarg5, &local_arg5);
  arg6 = *(btCollisionWorld::RayResultCallback **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btCollisionWorld::RayResultCallback & reference is null");
    return ;
  } 
  btSoftMultiBodyDynamicsWorld::rayTestSingle((btTransform const &)*arg1,(btTransform const &)*arg2,arg3,(btCollisionShape const *)arg4,(btTransform const &)*arg5,*arg6);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btDefaultSoftBodySolver_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btSoftBodySolver **)&baseptr = *(btDefaultSoftBodySolver **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Material_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btSoftBody::Element **)&baseptr = *(btSoftBody::Material **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Feature_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btSoftBody::Element **)&baseptr = *(btSoftBody::Feature **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Node_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btSoftBody::Feature **)&baseptr = *(btSoftBody::Node **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Link_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btSoftBody::Feature **)&baseptr = *(btSoftBody::Link **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Face_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btSoftBody::Feature **)&baseptr = *(btSoftBody::Face **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Tetra_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btSoftBody::Feature **)&baseptr = *(btSoftBody::Tetra **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1Note_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btSoftBody::Element **)&baseptr = *(btSoftBody::Note **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1LJoint_1Specs_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btSoftBody::Joint::Specs **)&baseptr = *(btSoftBody::LJoint::Specs **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1LJoint_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btSoftBody::Joint **)&baseptr = *(btSoftBody::LJoint **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1AJoint_1Specs_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btSoftBody::Joint::Specs **)&baseptr = *(btSoftBody::AJoint::Specs **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1AJoint_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btSoftBody::Joint **)&baseptr = *(btSoftBody::AJoint **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1CJoint_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btSoftBody::Joint **)&baseptr = *(btSoftBody::CJoint **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1RayFromToCaster_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btDbvt::ICollide **)&baseptr = *(btSoftBody::RayFromToCaster **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBody_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btCollisionObject **)&baseptr = *(btSoftBody **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyTriangleCallback_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btTriangleCallback **)&baseptr = *(btSoftBodyTriangleCallback **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyConcaveCollisionAlgorithm_1CreateFunc_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btCollisionAlgorithmCreateFunc **)&baseptr = *(btSoftBodyConcaveCollisionAlgorithm::CreateFunc **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyConcaveCollisionAlgorithm_1SwappedCreateFunc_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btCollisionAlgorithmCreateFunc **)&baseptr = *(btSoftBodyConcaveCollisionAlgorithm::SwappedCreateFunc **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyConcaveCollisionAlgorithm_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btCollisionAlgorithm **)&baseptr = *(btSoftBodyConcaveCollisionAlgorithm **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyCollisionShape_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btConcaveShape **)&baseptr = *(btSoftBodyCollisionShape **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftClusterCollisionShape_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btConvexInternalShape **)&baseptr = *(btSoftClusterCollisionShape **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1ClusterBase_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btDbvt::ICollide **)&baseptr = *(btSoftColliders::ClusterBase **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideCL_1RS_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btSoftColliders::ClusterBase **)&baseptr = *(btSoftColliders::CollideCL_RS **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideCL_1SS_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btSoftColliders::ClusterBase **)&baseptr = *(btSoftColliders::CollideCL_SS **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideSDF_1RS_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btDbvt::ICollide **)&baseptr = *(btSoftColliders::CollideSDF_RS **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftColliders_1CollideVF_1SS_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btDbvt::ICollide **)&baseptr = *(btSoftColliders::CollideVF_SS **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftBodyRigidBodyCollisionConfiguration_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btDefaultCollisionConfiguration **)&baseptr = *(btSoftBodyRigidBodyCollisionConfiguration **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btCPUVertexBufferDescriptor_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btVertexBufferDescriptor **)&baseptr = *(btCPUVertexBufferDescriptor **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftRigidCollisionAlgorithm_1CreateFunc_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btCollisionAlgorithmCreateFunc **)&baseptr = *(btSoftRigidCollisionAlgorithm::CreateFunc **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftRigidCollisionAlgorithm_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btCollisionAlgorithm **)&baseptr = *(btSoftRigidCollisionAlgorithm **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftRigidDynamicsWorld_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btDiscreteDynamicsWorld **)&baseptr = *(btSoftRigidDynamicsWorld **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftSoftCollisionAlgorithm_1CreateFunc_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btCollisionAlgorithmCreateFunc **)&baseptr = *(btSoftSoftCollisionAlgorithm::CreateFunc **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftSoftCollisionAlgorithm_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btCollisionAlgorithm **)&baseptr = *(btSoftSoftCollisionAlgorithm **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_softbody_SoftbodyJNI_btSoftMultiBodyDynamicsWorld_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(btMultiBodyDynamicsWorld **)&baseptr = *(btSoftMultiBodyDynamicsWorld **)&jarg1;
    return baseptr;
}

#ifdef __cplusplus
}
#endif

