/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.linearmath;

import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.linearmath.LinearMathJNI;
import java.nio.ByteBuffer;

public class btPoolAllocator
extends BulletBase {
    private long swigCPtr;

    protected btPoolAllocator(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btPoolAllocator(long cPtr, boolean cMemoryOwn) {
        this("btPoolAllocator", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(btPoolAllocator obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                LinearMathJNI.delete_btPoolAllocator(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public btPoolAllocator(int elemSize, int maxElements) {
        this(LinearMathJNI.new_btPoolAllocator(elemSize, maxElements), true);
    }

    public int getFreeCount() {
        return LinearMathJNI.btPoolAllocator_getFreeCount(this.swigCPtr, this);
    }

    public int getUsedCount() {
        return LinearMathJNI.btPoolAllocator_getUsedCount(this.swigCPtr, this);
    }

    public int getMaxCount() {
        return LinearMathJNI.btPoolAllocator_getMaxCount(this.swigCPtr, this);
    }

    public long allocate(int size) {
        return LinearMathJNI.btPoolAllocator_allocate(this.swigCPtr, this, size);
    }

    public boolean validPtr(long ptr) {
        return LinearMathJNI.btPoolAllocator_validPtr(this.swigCPtr, this, ptr);
    }

    public void freeMemory(long ptr) {
        LinearMathJNI.btPoolAllocator_freeMemory(this.swigCPtr, this, ptr);
    }

    public int getElementSize() {
        return LinearMathJNI.btPoolAllocator_getElementSize(this.swigCPtr, this);
    }

    public ByteBuffer getPoolAddress() {
        return LinearMathJNI.btPoolAllocator_getPoolAddress(this.swigCPtr, this);
    }

    public ByteBuffer getPoolAddressConst() {
        return LinearMathJNI.btPoolAllocator_getPoolAddressConst(this.swigCPtr, this);
    }
}

