/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.11
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */


#ifndef SWIGJAVA
#define SWIGJAVA
#endif

#define SWIG_DIRECTORS


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/* -----------------------------------------------------------------------------
 * director_common.swg
 *
 * This file contains support for director classes which is common between
 * languages.
 * ----------------------------------------------------------------------------- */

/*
  Use -DSWIG_DIRECTOR_STATIC if you prefer to avoid the use of the
  'Swig' namespace. This could be useful for multi-modules projects.
*/
#ifdef SWIG_DIRECTOR_STATIC
/* Force anonymous (static) namespace */
#define Swig
#endif
/* -----------------------------------------------------------------------------
 * director.swg
 *
 * This file contains support for director classes so that Java proxy
 * methods can be called from C++.
 * ----------------------------------------------------------------------------- */

#if defined(DEBUG_DIRECTOR_OWNED) || defined(DEBUG_DIRECTOR_EXCEPTION)
#include <iostream>
#endif

#include <exception>

namespace Swig {

  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(NULL), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = NULL;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (!jthis_) {
        weak_global_ = !mem_own; // hold as weak global if explicitly requested or not owned
        if (jobj)
          jthis_ = weak_global_ ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, NULL) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = NULL;
      weak_global_ = true;
    }

    /* Only call peek if you know what you are doing wrt to weak/global references */
    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else {
	/* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

  /* Local JNI reference deleter */
  class LocalRefGuard {
    JNIEnv *jenv_;
    jobject jobj_;

    // non-copyable
    LocalRefGuard(const LocalRefGuard &);
    LocalRefGuard &operator=(const LocalRefGuard &);
  public:
    LocalRefGuard(JNIEnv *jenv, jobject jobj): jenv_(jenv), jobj_(jobj) {}
    ~LocalRefGuard() {
      if (jobj_)
        jenv_->DeleteLocalRef(jobj_);
    }
  };

  /* director base class */
  class Director {
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
#if defined (_MSC_VER) && (_MSC_VER<1300)
    class JNIEnvWrapper;
    friend class JNIEnvWrapper;
#endif
    /* Utility class for managing the JNI environment */
    class JNIEnvWrapper {
      const Director *director_;
      JNIEnv *jenv_;
      int env_status;
    public:
      JNIEnvWrapper(const Director *director) : director_(director), jenv_(0), env_status(0) {
#if defined(__ANDROID__)
        JNIEnv **jenv = &jenv_;
#else
        void **jenv = (void **)&jenv_;
#endif
        env_status = director_->swig_jvm_->GetEnv((void **)&jenv_, JNI_VERSION_1_2);
#if defined(SWIG_JAVA_ATTACH_CURRENT_THREAD_AS_DAEMON)
        // Attach a daemon thread to the JVM. Useful when the JVM should not wait for
        // the thread to exit upon shutdown. Only for jdk-1.4 and later.
        director_->swig_jvm_->AttachCurrentThreadAsDaemon(jenv, NULL);
#else
        director_->swig_jvm_->AttachCurrentThread(jenv, NULL);
#endif
      }
      ~JNIEnvWrapper() {
#if !defined(SWIG_JAVA_NO_DETACH_CURRENT_THREAD)
        // Some JVMs, eg jdk-1.4.2 and lower on Solaris have a bug and crash with the DetachCurrentThread call.
        // However, without this call, the JVM hangs on exit when the thread was not created by the JVM and creates a memory leak.
        if (env_status == JNI_EDETACHED)
          director_->swig_jvm_->DetachCurrentThread();
#endif
      }
      JNIEnv *getJNIEnv() const {
        return jenv_;
      }
    };

    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      jobject jobj = swig_self_.get(jenv);
      LocalRefGuard ref_deleter(jenv, jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) NULL), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      swig_self_.release(jenv);
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };

  // Zero initialized bool array
  template<size_t N> class BoolArray {
    bool array_[N];
  public:
    BoolArray() {
      memset(array_, 0, sizeof(array_));
    }
    bool& operator[](size_t n) {
      return array_[n];
    }
    bool operator[](size_t n) const {
      return array_[n];
    }
  };

  // Utility classes and functions for exception handling.

  // Simple holder for a Java string during exception handling, providing access to a c-style string
  class JavaString {
  public:
    JavaString(JNIEnv *jenv, jstring jstr) : jenv_(jenv), jstr_(jstr), cstr_(0) {
      if (jenv_ && jstr_)
	cstr_ = (const char *) jenv_->GetStringUTFChars(jstr_, NULL);
    }

    ~JavaString() {
      if (jenv_ && jstr_ && cstr_)
	jenv_->ReleaseStringUTFChars(jstr_, cstr_);
    }

    const char *c_str(const char *null_string = "null JavaString") const {
      return cstr_ ? cstr_ : null_string;
    }

  private:
    // non-copyable
    JavaString(const JavaString &);
    JavaString &operator=(const JavaString &);

    JNIEnv *jenv_;
    jstring jstr_;
    const char *cstr_;
  };

  // Helper class to extract the exception message from a Java throwable
  class JavaExceptionMessage {
  public:
    JavaExceptionMessage(JNIEnv *jenv, jthrowable throwable) : message_(jenv, exceptionMessageFromThrowable(jenv, throwable)) {
    }

    const char *message() const {
      return message_.c_str("Could not get exception message in JavaExceptionMessage");
    }

  private:
    // non-copyable
    JavaExceptionMessage(const JavaExceptionMessage &);
    JavaExceptionMessage &operator=(const JavaExceptionMessage &);

    // Get exception message by calling Java method Throwable.getMessage()
    static jstring exceptionMessageFromThrowable(JNIEnv *jenv, jthrowable throwable) {
      jstring jmsg = NULL;
      if (jenv && throwable) {
	jenv->ExceptionClear(); // Cannot invoke methods with any pending exceptions
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  // All Throwable classes have a getMessage() method, so call it to extract the exception message
	  jmethodID getMessageMethodID = jenv->GetMethodID(throwclz, "getMessage", "()Ljava/lang/String;");
	  if (getMessageMethodID)
	    jmsg = (jstring)jenv->CallObjectMethod(throwable, getMessageMethodID);
	}
	if (jmsg == NULL && jenv->ExceptionCheck())
	  jenv->ExceptionClear();
      }
      return jmsg;
    }

    JavaString message_;
  };

  // C++ Exception class for handling Java exceptions thrown during a director method Java upcall
  class DirectorException : public std::exception {
  public:

    // Construct exception from a Java throwable
    DirectorException(JNIEnv *jenv, jthrowable throwable) : classname_(0), msg_(0) {

      // Call Java method Object.getClass().getName() to obtain the throwable's class name (delimited by '/')
      if (throwable) {
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  jclass clzclz = jenv->GetObjectClass(throwclz);
	  if (clzclz) {
	    jmethodID getNameMethodID = jenv->GetMethodID(clzclz, "getName", "()Ljava/lang/String;");
	    if (getNameMethodID) {
	      jstring jstr_classname = (jstring)(jenv->CallObjectMethod(throwclz, getNameMethodID));
              // Copy strings, since there is no guarantee that jenv will be active when handled
              if (jstr_classname) {
                JavaString jsclassname(jenv, jstr_classname);
                const char *classname = jsclassname.c_str(0);
                if (classname)
                  classname_ = copypath(classname);
              }
	    }
	  }
	}
      }

      JavaExceptionMessage exceptionmsg(jenv, throwable);
      msg_ = copystr(exceptionmsg.message());
    }

    // More general constructor for handling as a java.lang.RuntimeException
    DirectorException(const char *msg) : classname_(0), msg_(copystr(msg ? msg : "Unspecified DirectorException message")) {
    }

    ~DirectorException() throw() {
      delete[] classname_;
      delete[] msg_;
    }

    const char *what() const throw() {
      return msg_;
    }

    // Reconstruct and raise/throw the Java Exception that caused the DirectorException
    // Note that any error in the JNI exception handling results in a Java RuntimeException
    void raiseJavaException(JNIEnv *jenv) const {
      if (jenv) {
	jenv->ExceptionClear();

	jmethodID ctorMethodID = 0;
	jclass throwableclass = 0;
        if (classname_) {
          throwableclass = jenv->FindClass(classname_);
          if (throwableclass)
            ctorMethodID = jenv->GetMethodID(throwableclass, "<init>", "(Ljava/lang/String;)V");
	}

	if (ctorMethodID) {
	  jenv->ThrowNew(throwableclass, what());
	} else {
	  SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, what());
	}
      }
    }

  private:
    static char *copypath(const char *srcmsg) {
      char *target = copystr(srcmsg);
      for (char *c=target; *c; ++c) {
        if ('.' == *c)
          *c = '/';
      }
      return target;
    }

    static char *copystr(const char *srcmsg) {
      char *target = 0;
      if (srcmsg) {
	size_t msglen = strlen(srcmsg) + 1;
	target = new char[msglen];
	strncpy(target, srcmsg, msglen);
      }
      return target;
    }

    const char *classname_;
    const char *msg_;
  };

  // Helper method to determine if a Java throwable matches a particular Java class type
  SWIGINTERN inline bool ExceptionMatches(JNIEnv *jenv, jthrowable throwable, const char *classname) {
    bool matches = false;

    if (throwable && jenv && classname) {
      // Exceptions need to be cleared for correct behavior.
      // The caller of ExceptionMatches should restore pending exceptions if desired -
      // the caller already has the throwable.
      jenv->ExceptionClear();

      jclass clz = jenv->FindClass(classname);
      if (clz) {
	jclass classclz = jenv->GetObjectClass(clz);
	jmethodID isInstanceMethodID = jenv->GetMethodID(classclz, "isInstance", "(Ljava/lang/Object;)Z");
	if (isInstanceMethodID) {
	  matches = jenv->CallBooleanMethod(clz, isInstanceMethodID, throwable) != 0;
	}
      }

#if defined(DEBUG_DIRECTOR_EXCEPTION)
      if (jenv->ExceptionCheck()) {
        // Typically occurs when an invalid classname argument is passed resulting in a ClassNotFoundException
        JavaExceptionMessage exc(jenv, jenv->ExceptionOccurred());
        std::cout << "Error: ExceptionMatches: class '" << classname << "' : " << exc.message() << std::endl;
      }
#endif
    }
    return matches;
  }
}

namespace Swig {
  namespace {
    jclass jclass_DynamicsJNI = NULL;
    jmethodID director_method_ids[3];
  }
}

#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new jlong[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif


#include <gdx/common/jniHelpers.h>


#include <stdint.h>


#include <gdx/linearmath/mathtypes.h>
#include <LinearMath/btVector3.h>
#include <LinearMath/btQuaternion.h>
#include <LinearMath/btMatrix3x3.h>
#include <LinearMath/btTransform.h>


#include <BulletDynamics/Dynamics/btRigidBody.h>



	/* Gets a global ref to the temp class.  Do not release this. */
	SWIGINTERN inline jclass gdx_getTempClassVector3(JNIEnv * jenv) {
	  static jclass cls = NULL;
	  if (cls == NULL) {
		cls = (jclass) jenv->NewGlobalRef(jenv->FindClass("com/badlogic/gdx/physics/bullet/linearmath/LinearMath"));
	  }
	  return cls;
	}
	
	SWIGINTERN inline jobject gdx_takePoolObjectVector3(JNIEnv * jenv, const char * poolName) {
	  jclass tempClass = gdx_getTempClassVector3(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID obtainMethod = NULL;
	  if (obtainMethod == NULL) {
		obtainMethod = (jmethodID) jenv->GetMethodID(poolClass, "obtain", "()Ljava/lang/Object;");
	  }
	  
	  jobject ret = jenv->CallObjectMethod(poolObject, obtainMethod);
	
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	
	  return ret;
	}
	
	SWIGINTERN inline void gdx_releasePoolObjectVector3(JNIEnv * jenv, const char * poolName, jobject obj) {
	  jclass tempClass = gdx_getTempClassVector3(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID freeMethod = NULL;
	  if (freeMethod == NULL) {
		freeMethod = (jmethodID) jenv->GetMethodID(poolClass, "free", "(Ljava/lang/Object;)V");
	  }
	  
	  jenv->CallVoidMethod(poolObject, freeMethod, obj);
	  
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	  jenv->DeleteLocalRef(obj);
	}
	
	/*
	 * A simple RAII wrapper to release jobjects we obtain from pools in 
	 * directorin typemaps.  SWIG doesn't have hooks to release them after
	 * they're used. 
	 */
	class gdxPoolAutoReleaseVector3 {
	private:
	  JNIEnv * jenv;
	  const char * poolName;
	  jobject obj;
	public:
	  gdxPoolAutoReleaseVector3(JNIEnv * jenv, const char * poolName, jobject obj) : 
		jenv(jenv), poolName(poolName), obj(obj) { };
	  virtual ~gdxPoolAutoReleaseVector3() {
		gdx_releasePoolObjectVector3(this->jenv, this->poolName, this->obj);
	  };
	};


	
// Workaround for some strange swig behaviour


	/* Gets a global ref to the temp class's Return Vector3.  Do not release this. */ 
	SWIGINTERN inline jobject gdx_getReturnVector3(JNIEnv * jenv) {
	  static jobject ret = NULL;
	  if (ret == NULL) {
	    jclass tempClass = gdx_getTempClassVector3(jenv);
	    jfieldID field = jenv->GetStaticFieldID(tempClass, "staticVector3", "Lcom/badlogic/gdx/math/Vector3;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(tempClass, field));
	  }
	  return ret;
	}
	
	/* Sets the data in the Bullet type from the Gdx type. */
	SWIGINTERN inline void gdx_setbtVector3FromVector3(JNIEnv * jenv, btVector3 & target, jobject source) {
		Vector3_to_btVector3(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setbtVector3FromVector3(JNIEnv * jenv, btVector3 * target, jobject source) {
		gdx_setbtVector3FromVector3(jenv, *target, source);
	}

	/* Sets the data in the Gdx type from the Bullet type. */
	SWIGINTERN inline void gdx_setVector3FrombtVector3(JNIEnv * jenv, jobject target, const btVector3 & source) {
		btVector3_to_Vector3(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setVector3FrombtVector3(JNIEnv * jenv, jobject target, const btVector3 * source) {
		gdx_setVector3FrombtVector3(jenv, target, *source);
	}

	/*
	 * RAII wrapper to commit changes made to a local btVector3 back to Vector3
	 */
	class gdxAutoCommitVector3 {
	private:
	  JNIEnv * jenv;
	  jobject jVector3;
	  btVector3 & cbtVector3;
	public:
	  gdxAutoCommitVector3(JNIEnv * jenv, jobject jVector3, btVector3 & cbtVector3) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(cbtVector3) { };
	  gdxAutoCommitVector3(JNIEnv * jenv, jobject jVector3, btVector3 * cbtVector3) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(*cbtVector3) { };
	  virtual ~gdxAutoCommitVector3() {
	    gdx_setVector3FrombtVector3(this->jenv, this->jVector3, this->cbtVector3);
	  };
	};

	class gdxAutoCommitbtVector3AndReleaseVector3 {
	private:
	  JNIEnv * jenv;
	  jobject jVector3;
	  btVector3 & cbtVector3;
	  const char * poolName;
	public:
	  gdxAutoCommitbtVector3AndReleaseVector3(JNIEnv * jenv, jobject jVector3, btVector3 & cbtVector3, const char *poolName) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(cbtVector3), poolName(poolName) { };
	  gdxAutoCommitbtVector3AndReleaseVector3(JNIEnv * jenv, jobject jVector3, btVector3 * cbtVector3, const char *poolName) : 
	    jenv(jenv), jVector3(jVector3), cbtVector3(*cbtVector3), poolName(poolName) { };
	  virtual ~gdxAutoCommitbtVector3AndReleaseVector3() {
	    gdx_setbtVector3FromVector3(this->jenv, this->cbtVector3, this->jVector3);
	    gdx_releasePoolObjectVector3(this->jenv, this->poolName, this->jVector3);
	  };
	};

SWIGINTERN btRigidBody::btRigidBodyConstructionInfo *new_btRigidBody_btRigidBodyConstructionInfo__SWIG_0(bool dummy,btScalar mass,btMotionState *motionState,btCollisionShape *collisionShape,btVector3 const &localInertia=btVector3(0,0,0)){
		return new btRigidBody::btRigidBodyConstructionInfo(mass, motionState, collisionShape, localInertia);
	}


	/* Gets a global ref to the temp class.  Do not release this. */
	SWIGINTERN inline jclass gdx_getTempClassMatrix4(JNIEnv * jenv) {
	  static jclass cls = NULL;
	  if (cls == NULL) {
		cls = (jclass) jenv->NewGlobalRef(jenv->FindClass("com/badlogic/gdx/physics/bullet/linearmath/LinearMath"));
	  }
	  return cls;
	}
	
	SWIGINTERN inline jobject gdx_takePoolObjectMatrix4(JNIEnv * jenv, const char * poolName) {
	  jclass tempClass = gdx_getTempClassMatrix4(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID obtainMethod = NULL;
	  if (obtainMethod == NULL) {
		obtainMethod = (jmethodID) jenv->GetMethodID(poolClass, "obtain", "()Ljava/lang/Object;");
	  }
	  
	  jobject ret = jenv->CallObjectMethod(poolObject, obtainMethod);
	
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	
	  return ret;
	}
	
	SWIGINTERN inline void gdx_releasePoolObjectMatrix4(JNIEnv * jenv, const char * poolName, jobject obj) {
	  jclass tempClass = gdx_getTempClassMatrix4(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID freeMethod = NULL;
	  if (freeMethod == NULL) {
		freeMethod = (jmethodID) jenv->GetMethodID(poolClass, "free", "(Ljava/lang/Object;)V");
	  }
	  
	  jenv->CallVoidMethod(poolObject, freeMethod, obj);
	  
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	  jenv->DeleteLocalRef(obj);
	}
	
	/*
	 * A simple RAII wrapper to release jobjects we obtain from pools in 
	 * directorin typemaps.  SWIG doesn't have hooks to release them after
	 * they're used. 
	 */
	class gdxPoolAutoReleaseMatrix4 {
	private:
	  JNIEnv * jenv;
	  const char * poolName;
	  jobject obj;
	public:
	  gdxPoolAutoReleaseMatrix4(JNIEnv * jenv, const char * poolName, jobject obj) : 
		jenv(jenv), poolName(poolName), obj(obj) { };
	  virtual ~gdxPoolAutoReleaseMatrix4() {
		gdx_releasePoolObjectMatrix4(this->jenv, this->poolName, this->obj);
	  };
	};


	
// Workaround for some strange swig behaviour


	/* Gets a global ref to the temp class's Return Matrix4.  Do not release this. */ 
	SWIGINTERN inline jobject gdx_getReturnMatrix4(JNIEnv * jenv) {
	  static jobject ret = NULL;
	  if (ret == NULL) {
	    jclass tempClass = gdx_getTempClassMatrix4(jenv);
	    jfieldID field = jenv->GetStaticFieldID(tempClass, "staticMatrix4", "Lcom/badlogic/gdx/math/Matrix4;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(tempClass, field));
	  }
	  return ret;
	}
	
	/* Sets the data in the Bullet type from the Gdx type. */
	SWIGINTERN inline void gdx_setbtTransformFromMatrix4(JNIEnv * jenv, btTransform & target, jobject source) {
		Matrix4_to_btTransform(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setbtTransformFromMatrix4(JNIEnv * jenv, btTransform * target, jobject source) {
		gdx_setbtTransformFromMatrix4(jenv, *target, source);
	}

	/* Sets the data in the Gdx type from the Bullet type. */
	SWIGINTERN inline void gdx_setMatrix4FrombtTransform(JNIEnv * jenv, jobject target, const btTransform & source) {
		btTransform_to_Matrix4(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setMatrix4FrombtTransform(JNIEnv * jenv, jobject target, const btTransform * source) {
		gdx_setMatrix4FrombtTransform(jenv, target, *source);
	}

	/*
	 * RAII wrapper to commit changes made to a local btTransform back to Matrix4
	 */
	class gdxAutoCommitMatrix4 {
	private:
	  JNIEnv * jenv;
	  jobject jMatrix4;
	  btTransform & cbtTransform;
	public:
	  gdxAutoCommitMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform & cbtTransform) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(cbtTransform) { };
	  gdxAutoCommitMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform * cbtTransform) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(*cbtTransform) { };
	  virtual ~gdxAutoCommitMatrix4() {
	    gdx_setMatrix4FrombtTransform(this->jenv, this->jMatrix4, this->cbtTransform);
	  };
	};

	class gdxAutoCommitbtTransformAndReleaseMatrix4 {
	private:
	  JNIEnv * jenv;
	  jobject jMatrix4;
	  btTransform & cbtTransform;
	  const char * poolName;
	public:
	  gdxAutoCommitbtTransformAndReleaseMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform & cbtTransform, const char *poolName) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(cbtTransform), poolName(poolName) { };
	  gdxAutoCommitbtTransformAndReleaseMatrix4(JNIEnv * jenv, jobject jMatrix4, btTransform * cbtTransform, const char *poolName) : 
	    jenv(jenv), jMatrix4(jMatrix4), cbtTransform(*cbtTransform), poolName(poolName) { };
	  virtual ~gdxAutoCommitbtTransformAndReleaseMatrix4() {
	    gdx_setbtTransformFromMatrix4(this->jenv, this->cbtTransform, this->jMatrix4);
	    gdx_releasePoolObjectMatrix4(this->jenv, this->poolName, this->jMatrix4);
	  };
	};



	/* Gets a global ref to the temp class.  Do not release this. */
	SWIGINTERN inline jclass gdx_getTempClassMatrix3(JNIEnv * jenv) {
	  static jclass cls = NULL;
	  if (cls == NULL) {
		cls = (jclass) jenv->NewGlobalRef(jenv->FindClass("com/badlogic/gdx/physics/bullet/linearmath/LinearMath"));
	  }
	  return cls;
	}
	
	SWIGINTERN inline jobject gdx_takePoolObjectMatrix3(JNIEnv * jenv, const char * poolName) {
	  jclass tempClass = gdx_getTempClassMatrix3(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID obtainMethod = NULL;
	  if (obtainMethod == NULL) {
		obtainMethod = (jmethodID) jenv->GetMethodID(poolClass, "obtain", "()Ljava/lang/Object;");
	  }
	  
	  jobject ret = jenv->CallObjectMethod(poolObject, obtainMethod);
	
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	
	  return ret;
	}
	
	SWIGINTERN inline void gdx_releasePoolObjectMatrix3(JNIEnv * jenv, const char * poolName, jobject obj) {
	  jclass tempClass = gdx_getTempClassMatrix3(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID freeMethod = NULL;
	  if (freeMethod == NULL) {
		freeMethod = (jmethodID) jenv->GetMethodID(poolClass, "free", "(Ljava/lang/Object;)V");
	  }
	  
	  jenv->CallVoidMethod(poolObject, freeMethod, obj);
	  
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	  jenv->DeleteLocalRef(obj);
	}
	
	/*
	 * A simple RAII wrapper to release jobjects we obtain from pools in 
	 * directorin typemaps.  SWIG doesn't have hooks to release them after
	 * they're used. 
	 */
	class gdxPoolAutoReleaseMatrix3 {
	private:
	  JNIEnv * jenv;
	  const char * poolName;
	  jobject obj;
	public:
	  gdxPoolAutoReleaseMatrix3(JNIEnv * jenv, const char * poolName, jobject obj) : 
		jenv(jenv), poolName(poolName), obj(obj) { };
	  virtual ~gdxPoolAutoReleaseMatrix3() {
		gdx_releasePoolObjectMatrix3(this->jenv, this->poolName, this->obj);
	  };
	};


	
// Workaround for some strange swig behaviour


	/* Gets a global ref to the temp class's Return Matrix3.  Do not release this. */ 
	SWIGINTERN inline jobject gdx_getReturnMatrix3(JNIEnv * jenv) {
	  static jobject ret = NULL;
	  if (ret == NULL) {
	    jclass tempClass = gdx_getTempClassMatrix3(jenv);
	    jfieldID field = jenv->GetStaticFieldID(tempClass, "staticMatrix3", "Lcom/badlogic/gdx/math/Matrix3;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(tempClass, field));
	  }
	  return ret;
	}
	
	/* Sets the data in the Bullet type from the Gdx type. */
	SWIGINTERN inline void gdx_setbtMatrix3x3FromMatrix3(JNIEnv * jenv, btMatrix3x3 & target, jobject source) {
		Matrix3_to_btMatrix3(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setbtMatrix3x3FromMatrix3(JNIEnv * jenv, btMatrix3x3 * target, jobject source) {
		gdx_setbtMatrix3x3FromMatrix3(jenv, *target, source);
	}

	/* Sets the data in the Gdx type from the Bullet type. */
	SWIGINTERN inline void gdx_setMatrix3FrombtMatrix3x3(JNIEnv * jenv, jobject target, const btMatrix3x3 & source) {
		btMatrix3_to_Matrix3(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setMatrix3FrombtMatrix3x3(JNIEnv * jenv, jobject target, const btMatrix3x3 * source) {
		gdx_setMatrix3FrombtMatrix3x3(jenv, target, *source);
	}

	/*
	 * RAII wrapper to commit changes made to a local btMatrix3x3 back to Matrix3
	 */
	class gdxAutoCommitMatrix3 {
	private:
	  JNIEnv * jenv;
	  jobject jMatrix3;
	  btMatrix3x3 & cbtMatrix3x3;
	public:
	  gdxAutoCommitMatrix3(JNIEnv * jenv, jobject jMatrix3, btMatrix3x3 & cbtMatrix3x3) : 
	    jenv(jenv), jMatrix3(jMatrix3), cbtMatrix3x3(cbtMatrix3x3) { };
	  gdxAutoCommitMatrix3(JNIEnv * jenv, jobject jMatrix3, btMatrix3x3 * cbtMatrix3x3) : 
	    jenv(jenv), jMatrix3(jMatrix3), cbtMatrix3x3(*cbtMatrix3x3) { };
	  virtual ~gdxAutoCommitMatrix3() {
	    gdx_setMatrix3FrombtMatrix3x3(this->jenv, this->jMatrix3, this->cbtMatrix3x3);
	  };
	};

	class gdxAutoCommitbtMatrix3x3AndReleaseMatrix3 {
	private:
	  JNIEnv * jenv;
	  jobject jMatrix3;
	  btMatrix3x3 & cbtMatrix3x3;
	  const char * poolName;
	public:
	  gdxAutoCommitbtMatrix3x3AndReleaseMatrix3(JNIEnv * jenv, jobject jMatrix3, btMatrix3x3 & cbtMatrix3x3, const char *poolName) : 
	    jenv(jenv), jMatrix3(jMatrix3), cbtMatrix3x3(cbtMatrix3x3), poolName(poolName) { };
	  gdxAutoCommitbtMatrix3x3AndReleaseMatrix3(JNIEnv * jenv, jobject jMatrix3, btMatrix3x3 * cbtMatrix3x3, const char *poolName) : 
	    jenv(jenv), jMatrix3(jMatrix3), cbtMatrix3x3(*cbtMatrix3x3), poolName(poolName) { };
	  virtual ~gdxAutoCommitbtMatrix3x3AndReleaseMatrix3() {
	    gdx_setbtMatrix3x3FromMatrix3(this->jenv, this->cbtMatrix3x3, this->jMatrix3);
	    gdx_releasePoolObjectMatrix3(this->jenv, this->poolName, this->jMatrix3);
	  };
	};



	/* Gets a global ref to the temp class.  Do not release this. */
	SWIGINTERN inline jclass gdx_getTempClassQuaternion(JNIEnv * jenv) {
	  static jclass cls = NULL;
	  if (cls == NULL) {
		cls = (jclass) jenv->NewGlobalRef(jenv->FindClass("com/badlogic/gdx/physics/bullet/linearmath/LinearMath"));
	  }
	  return cls;
	}
	
	SWIGINTERN inline jobject gdx_takePoolObjectQuaternion(JNIEnv * jenv, const char * poolName) {
	  jclass tempClass = gdx_getTempClassQuaternion(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID obtainMethod = NULL;
	  if (obtainMethod == NULL) {
		obtainMethod = (jmethodID) jenv->GetMethodID(poolClass, "obtain", "()Ljava/lang/Object;");
	  }
	  
	  jobject ret = jenv->CallObjectMethod(poolObject, obtainMethod);
	
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	
	  return ret;
	}
	
	SWIGINTERN inline void gdx_releasePoolObjectQuaternion(JNIEnv * jenv, const char * poolName, jobject obj) {
	  jclass tempClass = gdx_getTempClassQuaternion(jenv);
	  
	  static jfieldID poolField = NULL;
	  if (poolField == NULL) {
		poolField = jenv->GetStaticFieldID(tempClass, poolName, "Lcom/badlogic/gdx/utils/Pool;");
	  }
	  
	  jobject poolObject = jenv->GetStaticObjectField(tempClass, poolField);
	  jclass poolClass = jenv->GetObjectClass(poolObject);
	  
	  static jmethodID freeMethod = NULL;
	  if (freeMethod == NULL) {
		freeMethod = (jmethodID) jenv->GetMethodID(poolClass, "free", "(Ljava/lang/Object;)V");
	  }
	  
	  jenv->CallVoidMethod(poolObject, freeMethod, obj);
	  
	  jenv->DeleteLocalRef(poolObject);
	  jenv->DeleteLocalRef(poolClass);
	  jenv->DeleteLocalRef(obj);
	}
	
	/*
	 * A simple RAII wrapper to release jobjects we obtain from pools in 
	 * directorin typemaps.  SWIG doesn't have hooks to release them after
	 * they're used. 
	 */
	class gdxPoolAutoReleaseQuaternion {
	private:
	  JNIEnv * jenv;
	  const char * poolName;
	  jobject obj;
	public:
	  gdxPoolAutoReleaseQuaternion(JNIEnv * jenv, const char * poolName, jobject obj) : 
		jenv(jenv), poolName(poolName), obj(obj) { };
	  virtual ~gdxPoolAutoReleaseQuaternion() {
		gdx_releasePoolObjectQuaternion(this->jenv, this->poolName, this->obj);
	  };
	};


	
// Workaround for some strange swig behaviour


	/* Gets a global ref to the temp class's Return Quaternion.  Do not release this. */ 
	SWIGINTERN inline jobject gdx_getReturnQuaternion(JNIEnv * jenv) {
	  static jobject ret = NULL;
	  if (ret == NULL) {
	    jclass tempClass = gdx_getTempClassQuaternion(jenv);
	    jfieldID field = jenv->GetStaticFieldID(tempClass, "staticQuaternion", "Lcom/badlogic/gdx/math/Quaternion;");
	    ret = jenv->NewGlobalRef(jenv->GetStaticObjectField(tempClass, field));
	  }
	  return ret;
	}
	
	/* Sets the data in the Bullet type from the Gdx type. */
	SWIGINTERN inline void gdx_setbtQuaternionFromQuaternion(JNIEnv * jenv, btQuaternion & target, jobject source) {
		Quaternion_to_btQuaternion(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setbtQuaternionFromQuaternion(JNIEnv * jenv, btQuaternion * target, jobject source) {
		gdx_setbtQuaternionFromQuaternion(jenv, *target, source);
	}

	/* Sets the data in the Gdx type from the Bullet type. */
	SWIGINTERN inline void gdx_setQuaternionFrombtQuaternion(JNIEnv * jenv, jobject target, const btQuaternion & source) {
		btQuaternion_to_Quaternion(jenv, target, source);
	}

	SWIGINTERN inline void gdx_setQuaternionFrombtQuaternion(JNIEnv * jenv, jobject target, const btQuaternion * source) {
		gdx_setQuaternionFrombtQuaternion(jenv, target, *source);
	}

	/*
	 * RAII wrapper to commit changes made to a local btQuaternion back to Quaternion
	 */
	class gdxAutoCommitQuaternion {
	private:
	  JNIEnv * jenv;
	  jobject jQuaternion;
	  btQuaternion & cbtQuaternion;
	public:
	  gdxAutoCommitQuaternion(JNIEnv * jenv, jobject jQuaternion, btQuaternion & cbtQuaternion) : 
	    jenv(jenv), jQuaternion(jQuaternion), cbtQuaternion(cbtQuaternion) { };
	  gdxAutoCommitQuaternion(JNIEnv * jenv, jobject jQuaternion, btQuaternion * cbtQuaternion) : 
	    jenv(jenv), jQuaternion(jQuaternion), cbtQuaternion(*cbtQuaternion) { };
	  virtual ~gdxAutoCommitQuaternion() {
	    gdx_setQuaternionFrombtQuaternion(this->jenv, this->jQuaternion, this->cbtQuaternion);
	  };
	};

	class gdxAutoCommitbtQuaternionAndReleaseQuaternion {
	private:
	  JNIEnv * jenv;
	  jobject jQuaternion;
	  btQuaternion & cbtQuaternion;
	  const char * poolName;
	public:
	  gdxAutoCommitbtQuaternionAndReleaseQuaternion(JNIEnv * jenv, jobject jQuaternion, btQuaternion & cbtQuaternion, const char *poolName) : 
	    jenv(jenv), jQuaternion(jQuaternion), cbtQuaternion(cbtQuaternion), poolName(poolName) { };
	  gdxAutoCommitbtQuaternionAndReleaseQuaternion(JNIEnv * jenv, jobject jQuaternion, btQuaternion * cbtQuaternion, const char *poolName) : 
	    jenv(jenv), jQuaternion(jQuaternion), cbtQuaternion(*cbtQuaternion), poolName(poolName) { };
	  virtual ~gdxAutoCommitbtQuaternionAndReleaseQuaternion() {
	    gdx_setbtQuaternionFromQuaternion(this->jenv, this->cbtQuaternion, this->jQuaternion);
	    gdx_releasePoolObjectQuaternion(this->jenv, this->poolName, this->jQuaternion);
	  };
	};

SWIGINTERN btRigidBody *new_btRigidBody__SWIG_0(bool dummy,btRigidBody::btRigidBodyConstructionInfo const &constructionInfo){
		return new btRigidBody(constructionInfo);
	}
SWIGINTERN btRigidBody *new_btRigidBody__SWIG_1(bool dummy,btScalar mass,btMotionState *motionState,btCollisionShape *collisionShape,btVector3 const &localInertia=btVector3(0,0,0)){
		return new btRigidBody(mass, motionState, collisionShape, localInertia);
	}

#include <BulletDynamics/ConstraintSolver/btTypedConstraint.h>


#include <BulletDynamics/Dynamics/btDynamicsWorld.h>


#include <gdx/dynamics/InternalTickCallback.h>


#include <BulletDynamics/Dynamics/btSimpleDynamicsWorld.h>


#include <BulletDynamics/Dynamics/btActionInterface.h>


#include <gdx/dynamics/CustomActionInterface.h>


#include <BulletDynamics/Dynamics/btDiscreteDynamicsWorld.h>


#include <BulletDynamics/Character/btCharacterControllerInterface.h>


#include <BulletDynamics/Character/btKinematicCharacterController.h>


#include <BulletDynamics/ConstraintSolver/btContactSolverInfo.h>


#include <BulletDynamics/ConstraintSolver/btConstraintSolver.h>


#include <BulletDynamics/ConstraintSolver/btSequentialImpulseConstraintSolver.h>


#include <BulletDynamics/ConstraintSolver/btSolverBody.h>


#include <BulletDynamics/ConstraintSolver/btSliderConstraint.h>


#include <BulletDynamics/ConstraintSolver/btPoint2PointConstraint.h>


#include <BulletDynamics/ConstraintSolver/btJacobianEntry.h>


#include <BulletDynamics/ConstraintSolver/btSolve2LinearConstraint.h>


#include <BulletDynamics/ConstraintSolver/btGeneric6DofConstraint.h>


#include <BulletDynamics/ConstraintSolver/btUniversalConstraint.h>


#include <BulletDynamics/ConstraintSolver/btContactConstraint.h>


#include <BulletDynamics/ConstraintSolver/btConeTwistConstraint.h>


#include <BulletDynamics/ConstraintSolver/btGeneric6DofSpringConstraint.h>


#include <BulletDynamics/ConstraintSolver/btGeneric6DofSpring2Constraint.h>


#include <BulletDynamics/ConstraintSolver/btHingeConstraint.h>


#include <BulletDynamics/ConstraintSolver/btSolverConstraint.h>


#include <BulletDynamics/ConstraintSolver/btHinge2Constraint.h>


#include <BulletDynamics/ConstraintSolver/btFixedConstraint.h>


#include <BulletDynamics/Vehicle/btVehicleRaycaster.h>


#include <BulletDynamics/Vehicle/btWheelInfo.h>


#include <BulletDynamics/Vehicle/btRaycastVehicle.h>


#include <gdx/dynamics/FilterableVehicleRaycaster.h>


#include <BulletDynamics/ConstraintSolver/btGearConstraint.h>


#include <BulletDynamics/ConstraintSolver/btNNCGConstraintSolver.h>


#include <BulletDynamics/Dynamics/btDiscreteDynamicsWorldMt.h>


#include <BulletDynamics/Dynamics/btSimulationIslandManagerMt.h>


#include <BulletDynamics/Featherstone/btMultiBody.h>


#include <BulletDynamics/Featherstone/btMultiBodyConstraint.h>


#include <BulletDynamics/Featherstone/btMultiBodyGearConstraint.h>


#include <BulletDynamics/Featherstone/btMultiBodyConstraintSolver.h>


#include <BulletDynamics/Featherstone/btMultiBodyDynamicsWorld.h>


#include <BulletDynamics/Featherstone/btMultiBodyFixedConstraint.h>


#include <BulletDynamics/Featherstone/btMultiBodyJointFeedback.h>


#include <BulletDynamics/Featherstone/btMultiBodyJointLimitConstraint.h>


#include <BulletDynamics/Featherstone/btMultiBodyJointMotor.h>


#include <BulletDynamics/Featherstone/btMultiBodyLink.h>


#include <BulletDynamics/Featherstone/btMultiBodyLinkCollider.h>


#include <BulletDynamics/Featherstone/btMultiBodyPoint2Point.h>


#include <BulletDynamics/Featherstone/btMultiBodySliderConstraint.h>


#include <BulletDynamics/Featherstone/btMultiBodySolverConstraint.h>


#include <BulletDynamics/MLCPSolvers/btDantzigLCP.h>


#include <BulletDynamics/MLCPSolvers/btMLCPSolverInterface.h>


#include <BulletDynamics/MLCPSolvers/btDantzigSolver.h>


#include <BulletDynamics/MLCPSolvers/btLemkeAlgorithm.h>


#include <BulletDynamics/MLCPSolvers/btLemkeSolver.h>


#include <BulletDynamics/MLCPSolvers/btMLCPSolver.h>


#include <BulletDynamics/MLCPSolvers/btPATHSolver.h>


#include <BulletDynamics/MLCPSolvers/btSolveProjectedGaussSeidel.h>


#include <BulletDynamics/Vehicle/btRaycastVehicle.h>


#include <BulletDynamics/Vehicle/btVehicleRaycaster.h>


#include <BulletDynamics/Vehicle/btWheelInfo.h>



/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "dynamics_wrap.h"

SwigDirector_InternalTickCallback::SwigDirector_InternalTickCallback(JNIEnv *jenv, btDynamicsWorld *dynamicsWorld, bool isPreTick) : InternalTickCallback(dynamicsWorld, isPreTick), Swig::Director(jenv) {
}

void SwigDirector_InternalTickCallback::onInternalTick(btDynamicsWorld *dynamicsWorld, btScalar timeStep) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdynamicsWorld = 0 ;
  jfloat jtimeStep  ;
  
  if (!swig_override[0]) {
    InternalTickCallback::onInternalTick(dynamicsWorld,timeStep);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((btDynamicsWorld **)&jdynamicsWorld) = (btDynamicsWorld *) dynamicsWorld; 
    jtimeStep = (jfloat) timeStep;
    jenv->CallStaticVoidMethod(Swig::jclass_DynamicsJNI, Swig::director_method_ids[0], swigjobj, jdynamicsWorld, jtimeStep);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in InternalTickCallback::onInternalTick ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_InternalTickCallback::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "onInternalTick", "(Lcom/badlogic/gdx/physics/bullet/dynamics/btDynamicsWorld;F)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/dynamics/InternalTickCallback");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_CustomActionInterface::SwigDirector_CustomActionInterface(JNIEnv *jenv) : CustomActionInterface(), Swig::Director(jenv) {
}

SwigDirector_CustomActionInterface::~SwigDirector_CustomActionInterface() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_CustomActionInterface::updateAction(btCollisionWorld *collisionWorld, btScalar timeStep) {
  CustomActionInterface::updateAction(collisionWorld,timeStep);
}

void SwigDirector_CustomActionInterface::debugDraw(btIDebugDraw *debugDrawer) {
  CustomActionInterface::debugDraw(debugDrawer);
}

void SwigDirector_CustomActionInterface::updateAction(btScalar timeStep) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jfloat jtimeStep  ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method CustomActionInterface::updateAction.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jtimeStep = (jfloat) timeStep;
    jenv->CallStaticVoidMethod(Swig::jclass_DynamicsJNI, Swig::director_method_ids[1], swigjobj, jtimeStep);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in CustomActionInterface::updateAction ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_CustomActionInterface::debugDraw() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method CustomActionInterface::debugDraw.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_DynamicsJNI, Swig::director_method_ids[2], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in CustomActionInterface::debugDraw ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_CustomActionInterface::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "updateAction", "(F)V", NULL 
    },
    {
      "debugDraw", "()V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/badlogic/gdx/physics/bullet/dynamics/CustomActionInterface");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}



#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_gDeactivationTime_1set(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  btScalar arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  gDeactivationTime = arg1;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_gDeactivationTime_1get(JNIEnv *jenv, jclass jcls) {
  jfloat jresult = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  result = (btScalar)gDeactivationTime;
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_gDisableDeactivation_1set(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  bool arg1 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  gDisableDeactivation = arg1;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_gDisableDeactivation_1get(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  result = (bool)gDisableDeactivation;
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1mass_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_mass = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1mass_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_mass);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1i_1motionState_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btMotionState *arg2 = (btMotionState *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  arg2 = *(btMotionState **)&jarg2; 
  if (arg1) (arg1)->m_motionState = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1i_1motionState_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btMotionState *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  result = (btMotionState *) ((arg1)->m_motionState);
  *(btMotionState **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1startWorldTransform_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btTransform *arg2 = (btTransform *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  arg2 = *(btTransform **)&jarg2; 
  if (arg1) (arg1)->m_startWorldTransform = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1startWorldTransform_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  result = (btTransform *)& ((arg1)->m_startWorldTransform);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1i_1collisionShape_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btCollisionShape *arg2 = (btCollisionShape *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  arg2 = *(btCollisionShape **)&jarg2; 
  if (arg1) (arg1)->m_collisionShape = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1i_1collisionShape_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btCollisionShape *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  result = (btCollisionShape *) ((arg1)->m_collisionShape);
  *(btCollisionShape **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1localInertia_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_localInertia = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1localInertia_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_localInertia);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1linearDamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_linearDamping = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1linearDamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_linearDamping);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1angularDamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_angularDamping = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1angularDamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_angularDamping);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1friction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_friction = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1friction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_friction);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1rollingFriction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_rollingFriction = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1rollingFriction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_rollingFriction);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1spinningFriction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_spinningFriction = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1spinningFriction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_spinningFriction);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1restitution_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_restitution = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1restitution_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_restitution);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1linearSleepingThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_linearSleepingThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1linearSleepingThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_linearSleepingThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1angularSleepingThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_angularSleepingThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1angularSleepingThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_angularSleepingThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1additionalDamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_additionalDamping = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1additionalDamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  result = (bool) ((arg1)->m_additionalDamping);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1additionalDampingFactor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_additionalDampingFactor = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1additionalDampingFactor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_additionalDampingFactor);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1additionalLinearDampingThresholdSqr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_additionalLinearDampingThresholdSqr = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1additionalLinearDampingThresholdSqr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_additionalLinearDampingThresholdSqr);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1additionalAngularDampingThresholdSqr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_additionalAngularDampingThresholdSqr = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1additionalAngularDampingThresholdSqr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_additionalAngularDampingThresholdSqr);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1additionalAngularDampingFactor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_additionalAngularDampingFactor = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1btRigidBodyConstructionInfo_1additionalAngularDampingFactor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  result = (btScalar) ((arg1)->m_additionalAngularDampingFactor);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btRigidBody_1btRigidBodyConstructionInfo_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jboolean jarg1, jfloat jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jobject jarg5) {
  jlong jresult = 0 ;
  bool arg1 ;
  btScalar arg2 ;
  btMotionState *arg3 = (btMotionState *) 0 ;
  btCollisionShape *arg4 = (btCollisionShape *) 0 ;
  btVector3 *arg5 = 0 ;
  btRigidBody::btRigidBodyConstructionInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = jarg1 ? true : false; 
  arg2 = (btScalar)jarg2; 
  arg3 = *(btMotionState **)&jarg3; 
  arg4 = *(btCollisionShape **)&jarg4; 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  result = (btRigidBody::btRigidBodyConstructionInfo *)new_btRigidBody_btRigidBodyConstructionInfo__SWIG_0(arg1,arg2,arg3,arg4,(btVector3 const &)*arg5);
  *(btRigidBody::btRigidBodyConstructionInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btRigidBody_1btRigidBodyConstructionInfo_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jboolean jarg1, jfloat jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  bool arg1 ;
  btScalar arg2 ;
  btMotionState *arg3 = (btMotionState *) 0 ;
  btCollisionShape *arg4 = (btCollisionShape *) 0 ;
  btRigidBody::btRigidBodyConstructionInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = jarg1 ? true : false; 
  arg2 = (btScalar)jarg2; 
  arg3 = *(btMotionState **)&jarg3; 
  arg4 = *(btCollisionShape **)&jarg4; 
  result = (btRigidBody::btRigidBodyConstructionInfo *)new_btRigidBody_btRigidBodyConstructionInfo__SWIG_0(arg1,arg2,arg3,arg4);
  *(btRigidBody::btRigidBodyConstructionInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btRigidBody_1btRigidBodyConstructionInfo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btRigidBody::btRigidBodyConstructionInfo *arg1 = (btRigidBody::btRigidBodyConstructionInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btRigidBody(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btRigidBody **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1proceedToTransform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btTransform *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->proceedToTransform((btTransform const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1predictIntegratedTransform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jobject jarg3) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btScalar arg2 ;
  btTransform *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->predictIntegratedTransform(arg2,*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1saveKinematicState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->saveKinematicState(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1applyGravity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  (arg1)->applyGravity();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1setGravity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setGravity((btVector3 const &)*arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getGravity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (btVector3 *) &((btRigidBody const *)arg1)->getGravity();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1setDamping(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setDamping(arg2,arg3);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getLinearDamping(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (btScalar)((btRigidBody const *)arg1)->getLinearDamping();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getAngularDamping(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (btScalar)((btRigidBody const *)arg1)->getAngularDamping();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getLinearSleepingThreshold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (btScalar)((btRigidBody const *)arg1)->getLinearSleepingThreshold();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getAngularSleepingThreshold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (btScalar)((btRigidBody const *)arg1)->getAngularSleepingThreshold();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1applyDamping(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->applyDamping(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1setMassProps(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jobject jarg3) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btScalar arg2 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->setMassProps(arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getLinearFactor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (btVector3 *) &((btRigidBody const *)arg1)->getLinearFactor();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1setLinearFactor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setLinearFactor((btVector3 const &)*arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getInvMass(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (btScalar)((btRigidBody const *)arg1)->getInvMass();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getInvInertiaTensorWorld(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btMatrix3x3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (btMatrix3x3 *) &((btRigidBody const *)arg1)->getInvInertiaTensorWorld();
  jresult = gdx_getReturnMatrix3(jenv);
  gdx_setMatrix3FrombtMatrix3x3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1integrateVelocities(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->integrateVelocities(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1setCenterOfMassTransform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btTransform *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setCenterOfMassTransform((btTransform const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1applyCentralForce(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->applyCentralForce((btVector3 const &)*arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getTotalForce(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (btVector3 *) &((btRigidBody const *)arg1)->getTotalForce();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getTotalTorque(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (btVector3 *) &((btRigidBody const *)arg1)->getTotalTorque();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getInvInertiaDiagLocal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (btVector3 *) &((btRigidBody const *)arg1)->getInvInertiaDiagLocal();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1setInvInertiaDiagLocal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setInvInertiaDiagLocal((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1setSleepingThresholds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setSleepingThresholds(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1applyTorque(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->applyTorque((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1applyForce(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->applyForce((btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1applyCentralImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->applyCentralImpulse((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1applyTorqueImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->applyTorqueImpulse((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1applyImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->applyImpulse((btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1clearForces(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  (arg1)->clearForces();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1updateInertiaTensor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  (arg1)->updateInertiaTensor();
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getCenterOfMassPosition(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (btVector3 *) &((btRigidBody const *)arg1)->getCenterOfMassPosition();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getOrientation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btQuaternion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = ((btRigidBody const *)arg1)->getOrientation();
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getCenterOfMassTransform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (btTransform *) &((btRigidBody const *)arg1)->getCenterOfMassTransform();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getLinearVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (btVector3 *) &((btRigidBody const *)arg1)->getLinearVelocity();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getAngularVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (btVector3 *) &((btRigidBody const *)arg1)->getAngularVelocity();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1setLinearVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setLinearVelocity((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1setAngularVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setAngularVelocity((btVector3 const &)*arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getVelocityInLocalPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = ((btRigidBody const *)arg1)->getVelocityInLocalPoint((btVector3 const &)*arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1translate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->translate((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getAabb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  ((btRigidBody const *)arg1)->getAabb(*arg2,*arg3);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1computeImpulseDenominator(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  jfloat jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  result = (btScalar)((btRigidBody const *)arg1)->computeImpulseDenominator((btVector3 const &)*arg2,(btVector3 const &)*arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1computeAngularImpulseDenominator(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jfloat jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btScalar)((btRigidBody const *)arg1)->computeAngularImpulseDenominator((btVector3 const &)*arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1updateDeactivation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->updateDeactivation(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1wantsSleeping(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (bool)(arg1)->wantsSleeping();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getBroadphaseProxyConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btBroadphaseProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (btBroadphaseProxy *)((btRigidBody const *)arg1)->getBroadphaseProxy();
  *(btBroadphaseProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getBroadphaseProxy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btBroadphaseProxy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (btBroadphaseProxy *)(arg1)->getBroadphaseProxy();
  *(btBroadphaseProxy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1setNewBroadphaseProxy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btBroadphaseProxy *arg2 = (btBroadphaseProxy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBody **)&jarg1; 
  arg2 = *(btBroadphaseProxy **)&jarg2; 
  (arg1)->setNewBroadphaseProxy(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1internalGetMotionState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btMotionState *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (btMotionState *)(arg1)->getMotionState();
  *(btMotionState **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getMotionStateConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btMotionState *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (btMotionState *)((btRigidBody const *)arg1)->getMotionState();
  *(btMotionState **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1internalSetMotionState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btMotionState *arg2 = (btMotionState *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBody **)&jarg1; 
  arg2 = *(btMotionState **)&jarg2; 
  (arg1)->setMotionState(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1contactSolverType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_contactSolverType = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1contactSolverType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (int) ((arg1)->m_contactSolverType);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1frictionSolverType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_frictionSolverType = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1frictionSolverType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (int) ((arg1)->m_frictionSolverType);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1setAngularFactor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setAngularFactor((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1setAngularFactor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setAngularFactor(arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getAngularFactor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (btVector3 *) &((btRigidBody const *)arg1)->getAngularFactor();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1isInWorld(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (bool)((btRigidBody const *)arg1)->isInWorld();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1addConstraintRef(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btTypedConstraint *arg2 = (btTypedConstraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBody **)&jarg1; 
  arg2 = *(btTypedConstraint **)&jarg2; 
  (arg1)->addConstraintRef(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1removeConstraintRef(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btTypedConstraint *arg2 = (btTypedConstraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBody **)&jarg1; 
  arg2 = *(btTypedConstraint **)&jarg2; 
  (arg1)->removeConstraintRef(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getConstraintRef(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  int arg2 ;
  btTypedConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btTypedConstraint *)(arg1)->getConstraintRef(arg2);
  *(btTypedConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getNumConstraintRefs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (int)((btRigidBody const *)arg1)->getNumConstraintRefs();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1setFlags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setFlags(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getFlags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = (int)((btRigidBody const *)arg1)->getFlags();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1computeGyroscopicImpulseImplicit_1World(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jobject jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btScalar arg2 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  result = ((btRigidBody const *)arg1)->computeGyroscopicImpulseImplicit_World(arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1computeGyroscopicImpulseImplicit_1Body(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jobject jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btScalar arg2 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  result = ((btRigidBody const *)arg1)->computeGyroscopicImpulseImplicit_Body(arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1computeGyroscopicForceExplicit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jobject jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btScalar arg2 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  result = ((btRigidBody const *)arg1)->computeGyroscopicForceExplicit(arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBody_1getLocalInertia(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1; 
  result = ((btRigidBody const *)arg1)->getLocalInertia();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btRigidBody_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jboolean jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  bool arg1 ;
  btRigidBody::btRigidBodyConstructionInfo *arg2 = 0 ;
  btRigidBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1 ? true : false; 
  arg2 = *(btRigidBody::btRigidBodyConstructionInfo **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody::btRigidBodyConstructionInfo const & reference is null");
    return 0;
  } 
  result = (btRigidBody *)new_btRigidBody__SWIG_0(arg1,(btRigidBody::btRigidBodyConstructionInfo const &)*arg2);
  *(btRigidBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btRigidBody_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jboolean jarg1, jfloat jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jobject jarg5) {
  jlong jresult = 0 ;
  bool arg1 ;
  btScalar arg2 ;
  btMotionState *arg3 = (btMotionState *) 0 ;
  btCollisionShape *arg4 = (btCollisionShape *) 0 ;
  btVector3 *arg5 = 0 ;
  btRigidBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = jarg1 ? true : false; 
  arg2 = (btScalar)jarg2; 
  arg3 = *(btMotionState **)&jarg3; 
  arg4 = *(btCollisionShape **)&jarg4; 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  result = (btRigidBody *)new_btRigidBody__SWIG_1(arg1,arg2,arg3,arg4,(btVector3 const &)*arg5);
  *(btRigidBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btRigidBody_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jboolean jarg1, jfloat jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  bool arg1 ;
  btScalar arg2 ;
  btMotionState *arg3 = (btMotionState *) 0 ;
  btCollisionShape *arg4 = (btCollisionShape *) 0 ;
  btRigidBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = jarg1 ? true : false; 
  arg2 = (btScalar)jarg2; 
  arg3 = *(btMotionState **)&jarg3; 
  arg4 = *(btCollisionShape **)&jarg4; 
  result = (btRigidBody *)new_btRigidBody__SWIG_1(arg1,arg2,arg3,arg4);
  *(btRigidBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1collisionObjectData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  btCollisionObjectFloatData *arg2 = (btCollisionObjectFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  arg2 = *(btCollisionObjectFloatData **)&jarg2; 
  if (arg1) (arg1)->m_collisionObjectData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1collisionObjectData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  btCollisionObjectFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  result = (btCollisionObjectFloatData *)& ((arg1)->m_collisionObjectData);
  *(btCollisionObjectFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1invInertiaTensorWorld_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  btMatrix3x3FloatData *arg2 = (btMatrix3x3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  arg2 = *(btMatrix3x3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_invInertiaTensorWorld = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1invInertiaTensorWorld_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  btMatrix3x3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  result = (btMatrix3x3FloatData *)& ((arg1)->m_invInertiaTensorWorld);
  *(btMatrix3x3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1linearVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_linearVelocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1linearVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_linearVelocity);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1angularVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_angularVelocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1angularVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_angularVelocity);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1angularFactor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_angularFactor = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1angularFactor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_angularFactor);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1linearFactor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_linearFactor = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1linearFactor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_linearFactor);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1gravity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_gravity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1gravity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_gravity);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1gravity_1acceleration_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_gravity_acceleration = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1gravity_1acceleration_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_gravity_acceleration);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1invInertiaLocal_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_invInertiaLocal = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1invInertiaLocal_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_invInertiaLocal);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1totalForce_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_totalForce = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1totalForce_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_totalForce);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1totalTorque_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_totalTorque = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1totalTorque_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_totalTorque);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1inverseMass_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_inverseMass = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1inverseMass_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  result = (float) ((arg1)->m_inverseMass);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1linearDamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_linearDamping = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1linearDamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  result = (float) ((arg1)->m_linearDamping);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1angularDamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_angularDamping = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1angularDamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  result = (float) ((arg1)->m_angularDamping);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1additionalDampingFactor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_additionalDampingFactor = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1additionalDampingFactor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  result = (float) ((arg1)->m_additionalDampingFactor);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1additionalLinearDampingThresholdSqr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_additionalLinearDampingThresholdSqr = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1additionalLinearDampingThresholdSqr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  result = (float) ((arg1)->m_additionalLinearDampingThresholdSqr);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1additionalAngularDampingThresholdSqr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_additionalAngularDampingThresholdSqr = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1additionalAngularDampingThresholdSqr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  result = (float) ((arg1)->m_additionalAngularDampingThresholdSqr);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1additionalAngularDampingFactor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_additionalAngularDampingFactor = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1additionalAngularDampingFactor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  result = (float) ((arg1)->m_additionalAngularDampingFactor);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1linearSleepingThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_linearSleepingThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1linearSleepingThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  result = (float) ((arg1)->m_linearSleepingThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1angularSleepingThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_angularSleepingThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1angularSleepingThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  result = (float) ((arg1)->m_angularSleepingThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1additionalDamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_additionalDamping = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyFloatData_1additionalDamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  result = (int) ((arg1)->m_additionalDamping);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btRigidBodyFloatData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btRigidBodyFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btRigidBodyFloatData *)new btRigidBodyFloatData();
  *(btRigidBodyFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btRigidBodyFloatData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btRigidBodyFloatData *arg1 = (btRigidBodyFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btRigidBodyFloatData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1collisionObjectData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  btCollisionObjectDoubleData *arg2 = (btCollisionObjectDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  arg2 = *(btCollisionObjectDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_collisionObjectData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1collisionObjectData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  btCollisionObjectDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  result = (btCollisionObjectDoubleData *)& ((arg1)->m_collisionObjectData);
  *(btCollisionObjectDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1invInertiaTensorWorld_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  btMatrix3x3DoubleData *arg2 = (btMatrix3x3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  arg2 = *(btMatrix3x3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_invInertiaTensorWorld = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1invInertiaTensorWorld_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  btMatrix3x3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  result = (btMatrix3x3DoubleData *)& ((arg1)->m_invInertiaTensorWorld);
  *(btMatrix3x3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1linearVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_linearVelocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1linearVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_linearVelocity);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1angularVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_angularVelocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1angularVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_angularVelocity);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1angularFactor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_angularFactor = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1angularFactor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_angularFactor);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1linearFactor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_linearFactor = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1linearFactor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_linearFactor);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1gravity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_gravity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1gravity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_gravity);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1gravity_1acceleration_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_gravity_acceleration = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1gravity_1acceleration_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_gravity_acceleration);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1invInertiaLocal_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_invInertiaLocal = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1invInertiaLocal_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_invInertiaLocal);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1totalForce_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_totalForce = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1totalForce_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_totalForce);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1totalTorque_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_totalTorque = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1totalTorque_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_totalTorque);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1inverseMass_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_inverseMass = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1inverseMass_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_inverseMass);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1linearDamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_linearDamping = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1linearDamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_linearDamping);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1angularDamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_angularDamping = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1angularDamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_angularDamping);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1additionalDampingFactor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_additionalDampingFactor = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1additionalDampingFactor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_additionalDampingFactor);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1additionalLinearDampingThresholdSqr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_additionalLinearDampingThresholdSqr = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1additionalLinearDampingThresholdSqr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_additionalLinearDampingThresholdSqr);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1additionalAngularDampingThresholdSqr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_additionalAngularDampingThresholdSqr = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1additionalAngularDampingThresholdSqr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_additionalAngularDampingThresholdSqr);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1additionalAngularDampingFactor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_additionalAngularDampingFactor = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1additionalAngularDampingFactor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_additionalAngularDampingFactor);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1linearSleepingThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_linearSleepingThreshold = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1linearSleepingThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_linearSleepingThreshold);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1angularSleepingThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_angularSleepingThreshold = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1angularSleepingThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_angularSleepingThreshold);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1additionalDamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_additionalDamping = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1additionalDamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_additionalDamping);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1padding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_padding, (const char *)arg2, 4-1);
      arg1->m_padding[4-1] = 0;
    } else {
      arg1->m_padding[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRigidBodyDoubleData_1padding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_padding);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btRigidBodyDoubleData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btRigidBodyDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btRigidBodyDoubleData *)new btRigidBodyDoubleData();
  *(btRigidBodyDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btRigidBodyDoubleData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btRigidBodyDoubleData *arg1 = (btRigidBodyDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btRigidBodyDoubleData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJointFeedback_1operatorNew_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btJointFeedback *arg1 = (btJointFeedback *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btJointFeedback **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJointFeedback_1operatorDelete_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btJointFeedback *arg1 = (btJointFeedback *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btJointFeedback **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJointFeedback_1operatorNew_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btJointFeedback *arg1 = (btJointFeedback *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btJointFeedback **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJointFeedback_1operatorDelete_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btJointFeedback *arg1 = (btJointFeedback *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btJointFeedback **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJointFeedback_1operatorNewArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btJointFeedback *arg1 = (btJointFeedback *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btJointFeedback **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new[](arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJointFeedback_1operatorDeleteArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btJointFeedback *arg1 = (btJointFeedback *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btJointFeedback **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete[](arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJointFeedback_1operatorNewArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btJointFeedback *arg1 = (btJointFeedback *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btJointFeedback **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new[](arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJointFeedback_1operatorDeleteArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btJointFeedback *arg1 = (btJointFeedback *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btJointFeedback **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete[](arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJointFeedback_1appliedForceBodyA_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btJointFeedback *arg1 = (btJointFeedback *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btJointFeedback **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_appliedForceBodyA = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJointFeedback_1appliedForceBodyA_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btJointFeedback *arg1 = (btJointFeedback *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btJointFeedback **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_appliedForceBodyA);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJointFeedback_1appliedTorqueBodyA_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btJointFeedback *arg1 = (btJointFeedback *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btJointFeedback **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_appliedTorqueBodyA = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJointFeedback_1appliedTorqueBodyA_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btJointFeedback *arg1 = (btJointFeedback *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btJointFeedback **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_appliedTorqueBodyA);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJointFeedback_1appliedForceBodyB_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btJointFeedback *arg1 = (btJointFeedback *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btJointFeedback **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_appliedForceBodyB = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJointFeedback_1appliedForceBodyB_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btJointFeedback *arg1 = (btJointFeedback *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btJointFeedback **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_appliedForceBodyB);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJointFeedback_1appliedTorqueBodyB_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btJointFeedback *arg1 = (btJointFeedback *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btJointFeedback **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_appliedTorqueBodyB = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJointFeedback_1appliedTorqueBodyB_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btJointFeedback *arg1 = (btJointFeedback *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btJointFeedback **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_appliedTorqueBodyB);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btJointFeedback(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btJointFeedback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btJointFeedback *)new btJointFeedback();
  *(btJointFeedback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btJointFeedback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btJointFeedback *arg1 = (btJointFeedback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btJointFeedback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1operatorNew_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1operatorDelete_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1operatorNew_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1operatorDelete_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1operatorNewArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new[](arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1operatorDeleteArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete[](arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1operatorNewArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new[](arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1operatorDeleteArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete[](arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btTypedConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTypedConstraint **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo1_1numConstraintRows_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraint::btConstraintInfo1 *arg1 = (btTypedConstraint::btConstraintInfo1 *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo1 **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numConstraintRows = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo1_1numConstraintRows_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraint::btConstraintInfo1 *arg1 = (btTypedConstraint::btConstraintInfo1 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo1 **)&jarg1; 
  result = (int) ((arg1)->m_numConstraintRows);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo1_1nub_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraint::btConstraintInfo1 *arg1 = (btTypedConstraint::btConstraintInfo1 *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo1 **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->nub = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo1_1nub_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraint::btConstraintInfo1 *arg1 = (btTypedConstraint::btConstraintInfo1 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo1 **)&jarg1; 
  result = (int) ((arg1)->nub);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btTypedConstraint_1btConstraintInfo1(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTypedConstraint::btConstraintInfo1 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTypedConstraint::btConstraintInfo1 *)new btTypedConstraint::btConstraintInfo1();
  *(btTypedConstraint::btConstraintInfo1 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btTypedConstraint_1btConstraintInfo1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTypedConstraint::btConstraintInfo1 *arg1 = (btTypedConstraint::btConstraintInfo1 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTypedConstraint::btConstraintInfo1 **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1getFixedBody(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btRigidBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btRigidBody *) &btTypedConstraint::getFixedBody();
  *(btRigidBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1fps_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->fps = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1fps_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  result = (btScalar) ((arg1)->fps);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1erp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->erp = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1erp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  result = (btScalar) ((arg1)->erp);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1J1linearAxis_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btScalar *arg2 = (btScalar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  arg2 = *(btScalar **)&jarg2; 
  if (arg1) (arg1)->m_J1linearAxis = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1J1linearAxis_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  result = (btScalar *) ((arg1)->m_J1linearAxis);
  *(btScalar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1J1angularAxis_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btScalar *arg2 = (btScalar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  arg2 = *(btScalar **)&jarg2; 
  if (arg1) (arg1)->m_J1angularAxis = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1J1angularAxis_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  result = (btScalar *) ((arg1)->m_J1angularAxis);
  *(btScalar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1J2linearAxis_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btScalar *arg2 = (btScalar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  arg2 = *(btScalar **)&jarg2; 
  if (arg1) (arg1)->m_J2linearAxis = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1J2linearAxis_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  result = (btScalar *) ((arg1)->m_J2linearAxis);
  *(btScalar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1J2angularAxis_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btScalar *arg2 = (btScalar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  arg2 = *(btScalar **)&jarg2; 
  if (arg1) (arg1)->m_J2angularAxis = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1J2angularAxis_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  result = (btScalar *) ((arg1)->m_J2angularAxis);
  *(btScalar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1rowskip_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->rowskip = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1rowskip_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  result = (int) ((arg1)->rowskip);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1constraintError_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btScalar *arg2 = (btScalar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  arg2 = *(btScalar **)&jarg2; 
  if (arg1) (arg1)->m_constraintError = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1constraintError_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  result = (btScalar *) ((arg1)->m_constraintError);
  *(btScalar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1cfm_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btScalar *arg2 = (btScalar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  arg2 = *(btScalar **)&jarg2; 
  if (arg1) (arg1)->cfm = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1cfm_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  result = (btScalar *) ((arg1)->cfm);
  *(btScalar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1lowerLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btScalar *arg2 = (btScalar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  arg2 = *(btScalar **)&jarg2; 
  if (arg1) (arg1)->m_lowerLimit = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1lowerLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  result = (btScalar *) ((arg1)->m_lowerLimit);
  *(btScalar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1upperLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btScalar *arg2 = (btScalar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  arg2 = *(btScalar **)&jarg2; 
  if (arg1) (arg1)->m_upperLimit = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1upperLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btScalar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  result = (btScalar *) ((arg1)->m_upperLimit);
  *(btScalar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1numIterations_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numIterations = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1numIterations_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  result = (int) ((arg1)->m_numIterations);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1damping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_damping = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1btConstraintInfo2_1damping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  result = (btScalar) ((arg1)->m_damping);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btTypedConstraint_1btConstraintInfo2(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTypedConstraint::btConstraintInfo2 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTypedConstraint::btConstraintInfo2 *)new btTypedConstraint::btConstraintInfo2();
  *(btTypedConstraint::btConstraintInfo2 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btTypedConstraint_1btConstraintInfo2(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTypedConstraint::btConstraintInfo2 *arg1 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTypedConstraint::btConstraintInfo2 **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1getOverrideNumSolverIterations(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  result = (int)((btTypedConstraint const *)arg1)->getOverrideNumSolverIterations();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1setOverrideNumSolverIterations(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setOverrideNumSolverIterations(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1buildJacobian(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  (arg1)->buildJacobian();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1setupSolverConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jfloat jarg5) {
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  btConstraintArray *arg2 = 0 ;
  int arg3 ;
  int arg4 ;
  btScalar arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = *(btConstraintArray **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btConstraintArray & reference is null");
    return ;
  } 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (btScalar)jarg5; 
  (arg1)->setupSolverConstraint(*arg2,arg3,arg4,arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1getInfo1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  btTypedConstraint::btConstraintInfo1 *arg2 = (btTypedConstraint::btConstraintInfo1 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = *(btTypedConstraint::btConstraintInfo1 **)&jarg2; 
  (arg1)->getInfo1(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1getInfo2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  btTypedConstraint::btConstraintInfo2 *arg2 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = *(btTypedConstraint::btConstraintInfo2 **)&jarg2; 
  (arg1)->getInfo2(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1internalSetAppliedImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->internalSetAppliedImpulse(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1internalGetAppliedImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  result = (btScalar)(arg1)->internalGetAppliedImpulse();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1getBreakingImpulseThreshold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  result = (btScalar)((btTypedConstraint const *)arg1)->getBreakingImpulseThreshold();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1setBreakingImpulseThreshold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setBreakingImpulseThreshold(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1isEnabled(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  result = (bool)((btTypedConstraint const *)arg1)->isEnabled();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1setEnabled(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->setEnabled(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1solveConstraintObsolete(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jfloat jarg4) {
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  btSolverBody *arg2 = 0 ;
  btSolverBody *arg3 = 0 ;
  btScalar arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = *(btSolverBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSolverBody & reference is null");
    return ;
  } 
  arg3 = *(btSolverBody **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btSolverBody & reference is null");
    return ;
  } 
  arg4 = (btScalar)jarg4; 
  (arg1)->solveConstraintObsolete(*arg2,*arg3,arg4);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1getRigidBodyAConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  btRigidBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  result = (btRigidBody *) &((btTypedConstraint const *)arg1)->getRigidBodyA();
  *(btRigidBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1getRigidBodyBConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  btRigidBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  result = (btRigidBody *) &((btTypedConstraint const *)arg1)->getRigidBodyB();
  *(btRigidBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1getRigidBodyA(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  btRigidBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  result = (btRigidBody *) &(arg1)->getRigidBodyA();
  *(btRigidBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1getRigidBodyB(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  btRigidBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  result = (btRigidBody *) &(arg1)->getRigidBodyB();
  *(btRigidBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1getUserConstraintType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  result = (int)((btTypedConstraint const *)arg1)->getUserConstraintType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1setUserConstraintType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setUserConstraintType(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1setUserConstraintId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setUserConstraintId(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1getUserConstraintId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  result = (int)((btTypedConstraint const *)arg1)->getUserConstraintId();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1setUserConstraintPtr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->setUserConstraintPtr(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1getUserConstraintPtr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  result = (void *)(arg1)->getUserConstraintPtr();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1setJointFeedback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  btJointFeedback *arg2 = (btJointFeedback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = *(btJointFeedback **)&jarg2; 
  (arg1)->setJointFeedback(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1getJointFeedbackConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  btJointFeedback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  result = (btJointFeedback *)((btTypedConstraint const *)arg1)->getJointFeedback();
  *(btJointFeedback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1getJointFeedback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  btJointFeedback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  result = (btJointFeedback *)(arg1)->getJointFeedback();
  *(btJointFeedback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1getUid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  result = (int)((btTypedConstraint const *)arg1)->getUid();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1needsFeedback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  result = (bool)((btTypedConstraint const *)arg1)->needsFeedback();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1enableFeedback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->enableFeedback(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1getAppliedImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  result = (btScalar)((btTypedConstraint const *)arg1)->getAppliedImpulse();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1getConstraintType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  btTypedConstraintType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  result = (btTypedConstraintType)((btTypedConstraint const *)arg1)->getConstraintType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1setDbgDrawSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setDbgDrawSize(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1getDbgDrawSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getDbgDrawSize();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1setParam_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3, jint jarg4) {
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->setParam(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1setParam_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setParam(arg2,arg3);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1getParam_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jfloat jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  int arg2 ;
  int arg3 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (btScalar)((btTypedConstraint const *)arg1)->getParam(arg2,arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1getParam_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jfloat jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  int arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btScalar)((btTypedConstraint const *)arg1)->getParam(arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1calculateSerializeBufferSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  result = (int)((btTypedConstraint const *)arg1)->calculateSerializeBufferSize();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraint_1serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_) {
  jstring jresult = 0 ;
  btTypedConstraint *arg1 = (btTypedConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  btSerializer *arg3 = (btSerializer *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btTypedConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = *(btSerializer **)&jarg3; 
  result = (char *)((btTypedConstraint const *)arg1)->serialize(arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btAdjustAngleToLimits(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2, jfloat jarg3) {
  jfloat jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  result = (btScalar)btAdjustAngleToLimits(arg1,arg2,arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1rbA_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  btRigidBodyFloatData *arg2 = (btRigidBodyFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  arg2 = *(btRigidBodyFloatData **)&jarg2; 
  if (arg1) (arg1)->m_rbA = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1rbA_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  btRigidBodyFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  result = (btRigidBodyFloatData *) ((arg1)->m_rbA);
  *(btRigidBodyFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1rbB_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  btRigidBodyFloatData *arg2 = (btRigidBodyFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  arg2 = *(btRigidBodyFloatData **)&jarg2; 
  if (arg1) (arg1)->m_rbB = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1rbB_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  btRigidBodyFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  result = (btRigidBodyFloatData *) ((arg1)->m_rbB);
  *(btRigidBodyFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    delete [] arg1->m_name;
    if (arg2) {
      arg1->m_name = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->m_name, (const char *)arg2);
    } else {
      arg1->m_name = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  result = (char *) ((arg1)->m_name);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1objectType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_objectType = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1objectType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  result = (int) ((arg1)->m_objectType);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1userConstraintType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_userConstraintType = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1userConstraintType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  result = (int) ((arg1)->m_userConstraintType);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1userConstraintId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_userConstraintId = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1userConstraintId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  result = (int) ((arg1)->m_userConstraintId);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1needsFeedback_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_needsFeedback = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1needsFeedback_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  result = (int) ((arg1)->m_needsFeedback);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1appliedImpulse_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_appliedImpulse = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1appliedImpulse_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  result = (float) ((arg1)->m_appliedImpulse);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1dbgDrawSize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_dbgDrawSize = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1dbgDrawSize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  result = (float) ((arg1)->m_dbgDrawSize);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1disableCollisionsBetweenLinkedBodies_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_disableCollisionsBetweenLinkedBodies = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1disableCollisionsBetweenLinkedBodies_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  result = (int) ((arg1)->m_disableCollisionsBetweenLinkedBodies);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1overrideNumSolverIterations_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_overrideNumSolverIterations = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1overrideNumSolverIterations_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  result = (int) ((arg1)->m_overrideNumSolverIterations);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1breakingImpulseThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_breakingImpulseThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1breakingImpulseThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  result = (float) ((arg1)->m_breakingImpulseThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1isEnabled_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_isEnabled = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintFloatData_1isEnabled_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  result = (int) ((arg1)->m_isEnabled);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btTypedConstraintFloatData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTypedConstraintFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTypedConstraintFloatData *)new btTypedConstraintFloatData();
  *(btTypedConstraintFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btTypedConstraintFloatData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTypedConstraintFloatData *arg1 = (btTypedConstraintFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTypedConstraintFloatData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1rbA_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  btRigidBodyFloatData *arg2 = (btRigidBodyFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  arg2 = *(btRigidBodyFloatData **)&jarg2; 
  if (arg1) (arg1)->m_rbA = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1rbA_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  btRigidBodyFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  result = (btRigidBodyFloatData *) ((arg1)->m_rbA);
  *(btRigidBodyFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1rbB_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  btRigidBodyFloatData *arg2 = (btRigidBodyFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  arg2 = *(btRigidBodyFloatData **)&jarg2; 
  if (arg1) (arg1)->m_rbB = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1rbB_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  btRigidBodyFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  result = (btRigidBodyFloatData *) ((arg1)->m_rbB);
  *(btRigidBodyFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    delete [] arg1->m_name;
    if (arg2) {
      arg1->m_name = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->m_name, (const char *)arg2);
    } else {
      arg1->m_name = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  result = (char *) ((arg1)->m_name);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1objectType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_objectType = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1objectType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  result = (int) ((arg1)->m_objectType);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1userConstraintType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_userConstraintType = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1userConstraintType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  result = (int) ((arg1)->m_userConstraintType);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1userConstraintId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_userConstraintId = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1userConstraintId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  result = (int) ((arg1)->m_userConstraintId);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1needsFeedback_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_needsFeedback = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1needsFeedback_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  result = (int) ((arg1)->m_needsFeedback);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1appliedImpulse_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_appliedImpulse = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1appliedImpulse_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  result = (float) ((arg1)->m_appliedImpulse);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1dbgDrawSize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_dbgDrawSize = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1dbgDrawSize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  result = (float) ((arg1)->m_dbgDrawSize);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1disableCollisionsBetweenLinkedBodies_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_disableCollisionsBetweenLinkedBodies = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1disableCollisionsBetweenLinkedBodies_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  result = (int) ((arg1)->m_disableCollisionsBetweenLinkedBodies);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1overrideNumSolverIterations_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_overrideNumSolverIterations = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1overrideNumSolverIterations_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  result = (int) ((arg1)->m_overrideNumSolverIterations);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1breakingImpulseThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_breakingImpulseThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1breakingImpulseThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  result = (float) ((arg1)->m_breakingImpulseThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1isEnabled_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_isEnabled = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintData_1isEnabled_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  result = (int) ((arg1)->m_isEnabled);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btTypedConstraintData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTypedConstraintData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTypedConstraintData *)new btTypedConstraintData();
  *(btTypedConstraintData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btTypedConstraintData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTypedConstraintData *arg1 = (btTypedConstraintData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTypedConstraintData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1rbA_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  btRigidBodyDoubleData *arg2 = (btRigidBodyDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  arg2 = *(btRigidBodyDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_rbA = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1rbA_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  btRigidBodyDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  result = (btRigidBodyDoubleData *) ((arg1)->m_rbA);
  *(btRigidBodyDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1rbB_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  btRigidBodyDoubleData *arg2 = (btRigidBodyDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  arg2 = *(btRigidBodyDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_rbB = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1rbB_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  btRigidBodyDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  result = (btRigidBodyDoubleData *) ((arg1)->m_rbB);
  *(btRigidBodyDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    delete [] arg1->m_name;
    if (arg2) {
      arg1->m_name = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->m_name, (const char *)arg2);
    } else {
      arg1->m_name = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  result = (char *) ((arg1)->m_name);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1objectType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_objectType = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1objectType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_objectType);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1userConstraintType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_userConstraintType = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1userConstraintType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_userConstraintType);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1userConstraintId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_userConstraintId = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1userConstraintId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_userConstraintId);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1needsFeedback_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_needsFeedback = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1needsFeedback_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_needsFeedback);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1appliedImpulse_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_appliedImpulse = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1appliedImpulse_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_appliedImpulse);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1dbgDrawSize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_dbgDrawSize = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1dbgDrawSize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_dbgDrawSize);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1disableCollisionsBetweenLinkedBodies_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_disableCollisionsBetweenLinkedBodies = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1disableCollisionsBetweenLinkedBodies_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_disableCollisionsBetweenLinkedBodies);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1overrideNumSolverIterations_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_overrideNumSolverIterations = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1overrideNumSolverIterations_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_overrideNumSolverIterations);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1breakingImpulseThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_breakingImpulseThreshold = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1breakingImpulseThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_breakingImpulseThreshold);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1isEnabled_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_isEnabled = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1isEnabled_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_isEnabled);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1padding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->padding, (const char *)arg2, 4-1);
      arg1->padding[4-1] = 0;
    } else {
      arg1->padding[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTypedConstraintDoubleData_1padding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  result = (char *)(char *) ((arg1)->padding);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btTypedConstraintDoubleData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTypedConstraintDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTypedConstraintDoubleData *)new btTypedConstraintDoubleData();
  *(btTypedConstraintDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btTypedConstraintDoubleData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTypedConstraintDoubleData *arg1 = (btTypedConstraintDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTypedConstraintDoubleData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btAngularLimit(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btAngularLimit *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btAngularLimit *)new btAngularLimit();
  *(btAngularLimit **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btAngularLimit_1set_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4, jfloat jarg5, jfloat jarg6) {
  btAngularLimit *arg1 = (btAngularLimit *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btScalar arg4 ;
  btScalar arg5 ;
  btScalar arg6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAngularLimit **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (btScalar)jarg4; 
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  (arg1)->set(arg2,arg3,arg4,arg5,arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btAngularLimit_1set_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4, jfloat jarg5) {
  btAngularLimit *arg1 = (btAngularLimit *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btScalar arg4 ;
  btScalar arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAngularLimit **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (btScalar)jarg4; 
  arg5 = (btScalar)jarg5; 
  (arg1)->set(arg2,arg3,arg4,arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btAngularLimit_1set_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4) {
  btAngularLimit *arg1 = (btAngularLimit *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btScalar arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAngularLimit **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (btScalar)jarg4; 
  (arg1)->set(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btAngularLimit_1set_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  btAngularLimit *arg1 = (btAngularLimit *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAngularLimit **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->set(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btAngularLimit_1test(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btAngularLimit *arg1 = (btAngularLimit *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAngularLimit **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->test(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btAngularLimit_1getSoftness(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btAngularLimit *arg1 = (btAngularLimit *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAngularLimit **)&jarg1; 
  result = (btScalar)((btAngularLimit const *)arg1)->getSoftness();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btAngularLimit_1getBiasFactor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btAngularLimit *arg1 = (btAngularLimit *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAngularLimit **)&jarg1; 
  result = (btScalar)((btAngularLimit const *)arg1)->getBiasFactor();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btAngularLimit_1getRelaxationFactor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btAngularLimit *arg1 = (btAngularLimit *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAngularLimit **)&jarg1; 
  result = (btScalar)((btAngularLimit const *)arg1)->getRelaxationFactor();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btAngularLimit_1getCorrection(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btAngularLimit *arg1 = (btAngularLimit *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAngularLimit **)&jarg1; 
  result = (btScalar)((btAngularLimit const *)arg1)->getCorrection();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btAngularLimit_1getSign(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btAngularLimit *arg1 = (btAngularLimit *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAngularLimit **)&jarg1; 
  result = (btScalar)((btAngularLimit const *)arg1)->getSign();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btAngularLimit_1getHalfRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btAngularLimit *arg1 = (btAngularLimit *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAngularLimit **)&jarg1; 
  result = (btScalar)((btAngularLimit const *)arg1)->getHalfRange();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btAngularLimit_1isLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btAngularLimit *arg1 = (btAngularLimit *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAngularLimit **)&jarg1; 
  result = (bool)((btAngularLimit const *)arg1)->isLimit();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btAngularLimit_1fit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btAngularLimit *arg1 = (btAngularLimit *) 0 ;
  btScalar *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAngularLimit **)&jarg1; 
  arg2 = *(btScalar **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  ((btAngularLimit const *)arg1)->fit(*arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btAngularLimit_1getError(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btAngularLimit *arg1 = (btAngularLimit *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAngularLimit **)&jarg1; 
  result = (btScalar)((btAngularLimit const *)arg1)->getError();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btAngularLimit_1getLow(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btAngularLimit *arg1 = (btAngularLimit *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAngularLimit **)&jarg1; 
  result = (btScalar)((btAngularLimit const *)arg1)->getLow();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btAngularLimit_1getHigh(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btAngularLimit *arg1 = (btAngularLimit *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btAngularLimit **)&jarg1; 
  result = (btScalar)((btAngularLimit const *)arg1)->getHigh();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btAngularLimit(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btAngularLimit *arg1 = (btAngularLimit *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btAngularLimit **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btDynamicsWorld(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1stepSimulation_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jint jarg3, jfloat jarg4) {
  jint jresult = 0 ;
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btScalar arg2 ;
  int arg3 ;
  btScalar arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (btScalar)jarg4; 
  result = (int)(arg1)->stepSimulation(arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1stepSimulation_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jint jarg3) {
  jint jresult = 0 ;
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btScalar arg2 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (int)jarg3; 
  result = (int)(arg1)->stepSimulation(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1stepSimulation_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jint jresult = 0 ;
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btScalar arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (int)(arg1)->stepSimulation(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1addConstraint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btTypedConstraint *arg2 = (btTypedConstraint *) 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = *(btTypedConstraint **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  (arg1)->addConstraint(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1addConstraint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btTypedConstraint *arg2 = (btTypedConstraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = *(btTypedConstraint **)&jarg2; 
  (arg1)->addConstraint(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1removeConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btTypedConstraint *arg2 = (btTypedConstraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = *(btTypedConstraint **)&jarg2; 
  (arg1)->removeConstraint(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1addAction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btActionInterface *arg2 = (btActionInterface *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = *(btActionInterface **)&jarg2; 
  (arg1)->addAction(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1removeAction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btActionInterface *arg2 = (btActionInterface *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = *(btActionInterface **)&jarg2; 
  (arg1)->removeAction(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1setGravity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setGravity((btVector3 const &)*arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1getGravity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  result = ((btDynamicsWorld const *)arg1)->getGravity();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1synchronizeMotionStates(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  (arg1)->synchronizeMotionStates();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1addRigidBody_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btRigidBody *arg2 = (btRigidBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2; 
  (arg1)->addRigidBody(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1addRigidBody_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btRigidBody *arg2 = (btRigidBody *) 0 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->addRigidBody(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1removeRigidBody(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btRigidBody *arg2 = (btRigidBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2; 
  (arg1)->removeRigidBody(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1setConstraintSolver(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btConstraintSolver *arg2 = (btConstraintSolver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = *(btConstraintSolver **)&jarg2; 
  (arg1)->setConstraintSolver(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1getConstraintSolver(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btConstraintSolver *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  result = (btConstraintSolver *)(arg1)->getConstraintSolver();
  *(btConstraintSolver **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1getNumConstraints(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  result = (int)((btDynamicsWorld const *)arg1)->getNumConstraints();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1getConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  int arg2 ;
  btTypedConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btTypedConstraint *)(arg1)->getConstraint(arg2);
  *(btTypedConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1getConstraintConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  int arg2 ;
  btTypedConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btTypedConstraint *)((btDynamicsWorld const *)arg1)->getConstraint(arg2);
  *(btTypedConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1getWorldType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btDynamicsWorldType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  result = (btDynamicsWorldType)((btDynamicsWorld const *)arg1)->getWorldType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1clearForces(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  (arg1)->clearForces();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1setInternalTickCallback_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jboolean jarg4) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btInternalTickCallback arg2 = (btInternalTickCallback) 0 ;
  void *arg3 = (void *) 0 ;
  bool arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = *(btInternalTickCallback *)&jarg2; 
  arg3 = (void *)jarg3; 
  arg4 = jarg4 ? true : false; 
  (arg1)->setInternalTickCallback(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1setInternalTickCallback_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btInternalTickCallback arg2 = (btInternalTickCallback) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = *(btInternalTickCallback *)&jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->setInternalTickCallback(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1setInternalTickCallback_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btInternalTickCallback arg2 = (btInternalTickCallback) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = *(btInternalTickCallback *)&jarg2; 
  (arg1)->setInternalTickCallback(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1setWorldUserInfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->setWorldUserInfo(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1getWorldUserInfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  result = (void *)((btDynamicsWorld const *)arg1)->getWorldUserInfo();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1getSolverInfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btContactSolverInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  result = (btContactSolverInfo *) &(arg1)->getSolverInfo();
  *(btContactSolverInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1getSolverInfoConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btContactSolverInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  result = (btContactSolverInfo *) &((btDynamicsWorld const *)arg1)->getSolverInfo();
  *(btContactSolverInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1addVehicle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btActionInterface *arg2 = (btActionInterface *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = *(btActionInterface **)&jarg2; 
  (arg1)->addVehicle(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1removeVehicle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btActionInterface *arg2 = (btActionInterface *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = *(btActionInterface **)&jarg2; 
  (arg1)->removeVehicle(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1addCharacter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btActionInterface *arg2 = (btActionInterface *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = *(btActionInterface **)&jarg2; 
  (arg1)->addCharacter(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorld_1removeCharacter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btActionInterface *arg2 = (btActionInterface *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = *(btActionInterface **)&jarg2; 
  (arg1)->removeCharacter(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorldDoubleData_1solverInfo_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDynamicsWorldDoubleData *arg1 = (btDynamicsWorldDoubleData *) 0 ;
  btContactSolverInfoDoubleData *arg2 = (btContactSolverInfoDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDynamicsWorldDoubleData **)&jarg1; 
  arg2 = *(btContactSolverInfoDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_solverInfo = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorldDoubleData_1solverInfo_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDynamicsWorldDoubleData *arg1 = (btDynamicsWorldDoubleData *) 0 ;
  btContactSolverInfoDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorldDoubleData **)&jarg1; 
  result = (btContactSolverInfoDoubleData *)& ((arg1)->m_solverInfo);
  *(btContactSolverInfoDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorldDoubleData_1gravity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDynamicsWorldDoubleData *arg1 = (btDynamicsWorldDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDynamicsWorldDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_gravity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorldDoubleData_1gravity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDynamicsWorldDoubleData *arg1 = (btDynamicsWorldDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorldDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_gravity);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btDynamicsWorldDoubleData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btDynamicsWorldDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btDynamicsWorldDoubleData *)new btDynamicsWorldDoubleData();
  *(btDynamicsWorldDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btDynamicsWorldDoubleData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDynamicsWorldDoubleData *arg1 = (btDynamicsWorldDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDynamicsWorldDoubleData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorldFloatData_1solverInfo_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDynamicsWorldFloatData *arg1 = (btDynamicsWorldFloatData *) 0 ;
  btContactSolverInfoFloatData *arg2 = (btContactSolverInfoFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDynamicsWorldFloatData **)&jarg1; 
  arg2 = *(btContactSolverInfoFloatData **)&jarg2; 
  if (arg1) (arg1)->m_solverInfo = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorldFloatData_1solverInfo_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDynamicsWorldFloatData *arg1 = (btDynamicsWorldFloatData *) 0 ;
  btContactSolverInfoFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorldFloatData **)&jarg1; 
  result = (btContactSolverInfoFloatData *)& ((arg1)->m_solverInfo);
  *(btContactSolverInfoFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorldFloatData_1gravity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDynamicsWorldFloatData *arg1 = (btDynamicsWorldFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDynamicsWorldFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_gravity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDynamicsWorldFloatData_1gravity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDynamicsWorldFloatData *arg1 = (btDynamicsWorldFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorldFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_gravity);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btDynamicsWorldFloatData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btDynamicsWorldFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btDynamicsWorldFloatData *)new btDynamicsWorldFloatData();
  *(btDynamicsWorldFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btDynamicsWorldFloatData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDynamicsWorldFloatData *arg1 = (btDynamicsWorldFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDynamicsWorldFloatData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_InternalTickCallback_1CB(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  InternalTickCallback_CB(arg1,arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1InternalTickCallback_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jlong jresult = 0 ;
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  bool arg2 ;
  InternalTickCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (InternalTickCallback *)new SwigDirector_InternalTickCallback(jenv,arg1,arg2);
  *(InternalTickCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1InternalTickCallback_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  InternalTickCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  result = (InternalTickCallback *)new SwigDirector_InternalTickCallback(jenv,arg1);
  *(InternalTickCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1InternalTickCallback_1_1SWIG_12(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  InternalTickCallback *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (InternalTickCallback *)new SwigDirector_InternalTickCallback(jenv);
  *(InternalTickCallback **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_InternalTickCallback_1onInternalTick(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3) {
  InternalTickCallback *arg1 = (InternalTickCallback *) 0 ;
  btDynamicsWorld *arg2 = (btDynamicsWorld *) 0 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(InternalTickCallback **)&jarg1; 
  arg2 = *(btDynamicsWorld **)&jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->onInternalTick(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_InternalTickCallback_1onInternalTickSwigExplicitInternalTickCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3) {
  InternalTickCallback *arg1 = (InternalTickCallback *) 0 ;
  btDynamicsWorld *arg2 = (btDynamicsWorld *) 0 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(InternalTickCallback **)&jarg1; 
  arg2 = *(btDynamicsWorld **)&jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->InternalTickCallback::onInternalTick(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_InternalTickCallback_1detach_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  InternalTickCallback *arg1 = (InternalTickCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InternalTickCallback **)&jarg1; 
  (arg1)->detach();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_InternalTickCallback_1attach_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  InternalTickCallback *arg1 = (InternalTickCallback *) 0 ;
  btDynamicsWorld *arg2 = (btDynamicsWorld *) 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(InternalTickCallback **)&jarg1; 
  arg2 = *(btDynamicsWorld **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  (arg1)->attach(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_InternalTickCallback_1attach_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  InternalTickCallback *arg1 = (InternalTickCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InternalTickCallback **)&jarg1; 
  (arg1)->attach();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_InternalTickCallback_1detach_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btDynamicsWorld *arg1 = (btDynamicsWorld *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDynamicsWorld **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  InternalTickCallback::detach(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1InternalTickCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  InternalTickCallback *arg1 = (InternalTickCallback *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(InternalTickCallback **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_InternalTickCallback_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  InternalTickCallback *obj = *((InternalTickCallback **)&objarg);
  (void)jcls;
  SwigDirector_InternalTickCallback *director = (SwigDirector_InternalTickCallback *)(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_InternalTickCallback_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  InternalTickCallback *obj = *((InternalTickCallback **)&objarg);
  SwigDirector_InternalTickCallback *director = (SwigDirector_InternalTickCallback *)(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btSimpleDynamicsWorld(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btBroadphaseInterface *arg2 = (btBroadphaseInterface *) 0 ;
  btConstraintSolver *arg3 = (btConstraintSolver *) 0 ;
  btCollisionConfiguration *arg4 = (btCollisionConfiguration *) 0 ;
  btSimpleDynamicsWorld *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btBroadphaseInterface **)&jarg2; 
  arg3 = *(btConstraintSolver **)&jarg3; 
  arg4 = *(btCollisionConfiguration **)&jarg4; 
  result = (btSimpleDynamicsWorld *)new btSimpleDynamicsWorld(arg1,arg2,arg3,arg4);
  *(btSimpleDynamicsWorld **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btSimpleDynamicsWorld(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSimpleDynamicsWorld *arg1 = (btSimpleDynamicsWorld *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSimpleDynamicsWorld **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSimpleDynamicsWorld_1stepSimulation_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jint jarg3, jfloat jarg4) {
  jint jresult = 0 ;
  btSimpleDynamicsWorld *arg1 = (btSimpleDynamicsWorld *) 0 ;
  btScalar arg2 ;
  int arg3 ;
  btScalar arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSimpleDynamicsWorld **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (btScalar)jarg4; 
  result = (int)(arg1)->stepSimulation(arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSimpleDynamicsWorld_1stepSimulation_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jint jarg3) {
  jint jresult = 0 ;
  btSimpleDynamicsWorld *arg1 = (btSimpleDynamicsWorld *) 0 ;
  btScalar arg2 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSimpleDynamicsWorld **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (int)jarg3; 
  result = (int)(arg1)->stepSimulation(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSimpleDynamicsWorld_1stepSimulation_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jint jresult = 0 ;
  btSimpleDynamicsWorld *arg1 = (btSimpleDynamicsWorld *) 0 ;
  btScalar arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSimpleDynamicsWorld **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (int)(arg1)->stepSimulation(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSimpleDynamicsWorld_1addRigidBody_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSimpleDynamicsWorld *arg1 = (btSimpleDynamicsWorld *) 0 ;
  btRigidBody *arg2 = (btRigidBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSimpleDynamicsWorld **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2; 
  (arg1)->addRigidBody(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSimpleDynamicsWorld_1addRigidBody_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  btSimpleDynamicsWorld *arg1 = (btSimpleDynamicsWorld *) 0 ;
  btRigidBody *arg2 = (btRigidBody *) 0 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSimpleDynamicsWorld **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->addRigidBody(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btActionInterface(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btActionInterface *arg1 = (btActionInterface *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btActionInterface **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btActionInterface_1updateAction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3) {
  btActionInterface *arg1 = (btActionInterface *) 0 ;
  btCollisionWorld *arg2 = (btCollisionWorld *) 0 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btActionInterface **)&jarg1; 
  arg2 = *(btCollisionWorld **)&jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->updateAction(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btActionInterface_1debugDraw(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btActionInterface *arg1 = (btActionInterface *) 0 ;
  btIDebugDraw *arg2 = (btIDebugDraw *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btActionInterface **)&jarg1; 
  arg2 = *(btIDebugDraw **)&jarg2; 
  (arg1)->debugDraw(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_CustomActionInterface_1updateAction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  CustomActionInterface *arg1 = (CustomActionInterface *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CustomActionInterface **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->updateAction(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_CustomActionInterface_1debugDraw(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CustomActionInterface *arg1 = (CustomActionInterface *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CustomActionInterface **)&jarg1; 
  (arg1)->debugDraw();
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1CustomActionInterface(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  CustomActionInterface *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (CustomActionInterface *)new SwigDirector_CustomActionInterface(jenv);
  *(CustomActionInterface **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1CustomActionInterface(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CustomActionInterface *arg1 = (CustomActionInterface *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CustomActionInterface **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_CustomActionInterface_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  CustomActionInterface *obj = *((CustomActionInterface **)&objarg);
  (void)jcls;
  SwigDirector_CustomActionInterface *director = (SwigDirector_CustomActionInterface *)(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_CustomActionInterface_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  CustomActionInterface *obj = *((CustomActionInterface **)&objarg);
  SwigDirector_CustomActionInterface *director = (SwigDirector_CustomActionInterface *)(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1operatorNew_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1operatorDelete_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1operatorNew_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1operatorDelete_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1operatorNewArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new[](arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1operatorDeleteArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete[](arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1operatorNewArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new[](arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1operatorDeleteArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete[](arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btDiscreteDynamicsWorld(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  btDispatcher *arg1 = (btDispatcher *) 0 ;
  btBroadphaseInterface *arg2 = (btBroadphaseInterface *) 0 ;
  btConstraintSolver *arg3 = (btConstraintSolver *) 0 ;
  btCollisionConfiguration *arg4 = (btCollisionConfiguration *) 0 ;
  btDiscreteDynamicsWorld *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(btDispatcher **)&jarg1; 
  arg2 = *(btBroadphaseInterface **)&jarg2; 
  arg3 = *(btConstraintSolver **)&jarg3; 
  arg4 = *(btCollisionConfiguration **)&jarg4; 
  result = (btDiscreteDynamicsWorld *)new btDiscreteDynamicsWorld(arg1,arg2,arg3,arg4);
  *(btDiscreteDynamicsWorld **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btDiscreteDynamicsWorld(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1stepSimulation_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jint jarg3, jfloat jarg4) {
  jint jresult = 0 ;
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  btScalar arg2 ;
  int arg3 ;
  btScalar arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (btScalar)jarg4; 
  result = (int)(arg1)->stepSimulation(arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1stepSimulation_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jint jarg3) {
  jint jresult = 0 ;
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  btScalar arg2 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (int)jarg3; 
  result = (int)(arg1)->stepSimulation(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1stepSimulation_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jint jresult = 0 ;
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  btScalar arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (int)(arg1)->stepSimulation(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1synchronizeSingleMotionState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  btRigidBody *arg2 = (btRigidBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2; 
  (arg1)->synchronizeSingleMotionState(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1addConstraint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  btTypedConstraint *arg2 = (btTypedConstraint *) 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = *(btTypedConstraint **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  (arg1)->addConstraint(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1addConstraint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  btTypedConstraint *arg2 = (btTypedConstraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = *(btTypedConstraint **)&jarg2; 
  (arg1)->addConstraint(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1getSimulationIslandManager(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  btSimulationIslandManager *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  result = (btSimulationIslandManager *)(arg1)->getSimulationIslandManager();
  *(btSimulationIslandManager **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1getSimulationIslandManagerConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  btSimulationIslandManager *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  result = (btSimulationIslandManager *)((btDiscreteDynamicsWorld const *)arg1)->getSimulationIslandManager();
  *(btSimulationIslandManager **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1getCollisionWorld(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  btCollisionWorld *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  result = (btCollisionWorld *)(arg1)->getCollisionWorld();
  *(btCollisionWorld **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1addCollisionObject_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  btCollisionObject *arg2 = (btCollisionObject *) 0 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = *(btCollisionObject **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->addCollisionObject(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1addCollisionObject_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  btCollisionObject *arg2 = (btCollisionObject *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = *(btCollisionObject **)&jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->addCollisionObject(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1addCollisionObject_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  btCollisionObject *arg2 = (btCollisionObject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = *(btCollisionObject **)&jarg2; 
  (arg1)->addCollisionObject(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1addRigidBody_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  btRigidBody *arg2 = (btRigidBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2; 
  (arg1)->addRigidBody(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1addRigidBody_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  btRigidBody *arg2 = (btRigidBody *) 0 ;
  int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->addRigidBody(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1debugDrawConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  btTypedConstraint *arg2 = (btTypedConstraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = *(btTypedConstraint **)&jarg2; 
  (arg1)->debugDrawConstraint(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1applyGravity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  (arg1)->applyGravity();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1setNumTasks(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setNumTasks(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1updateVehicles(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->updateVehicles(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1setSynchronizeAllMotionStates(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->setSynchronizeAllMotionStates(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1getSynchronizeAllMotionStates(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  result = (bool)((btDiscreteDynamicsWorld const *)arg1)->getSynchronizeAllMotionStates();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1setApplySpeculativeContactRestitution(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->setApplySpeculativeContactRestitution(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1getApplySpeculativeContactRestitution(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  result = (bool)((btDiscreteDynamicsWorld const *)arg1)->getApplySpeculativeContactRestitution();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1setLatencyMotionStateInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->setLatencyMotionStateInterpolation(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btDiscreteDynamicsWorld_1getLatencyMotionStateInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btDiscreteDynamicsWorld *arg1 = (btDiscreteDynamicsWorld *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btDiscreteDynamicsWorld **)&jarg1; 
  result = (bool)((btDiscreteDynamicsWorld const *)arg1)->getLatencyMotionStateInterpolation();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btCharacterControllerInterface(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btCharacterControllerInterface *arg1 = (btCharacterControllerInterface *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btCharacterControllerInterface **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btCharacterControllerInterface_1setWalkDirection(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btCharacterControllerInterface *arg1 = (btCharacterControllerInterface *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCharacterControllerInterface **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setWalkDirection((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btCharacterControllerInterface_1setVelocityForTimeInterval(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jfloat jarg3) {
  btCharacterControllerInterface *arg1 = (btCharacterControllerInterface *) 0 ;
  btVector3 *arg2 = 0 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCharacterControllerInterface **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (btScalar)jarg3; 
  (arg1)->setVelocityForTimeInterval((btVector3 const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btCharacterControllerInterface_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCharacterControllerInterface *arg1 = (btCharacterControllerInterface *) 0 ;
  btCollisionWorld *arg2 = (btCollisionWorld *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCharacterControllerInterface **)&jarg1; 
  arg2 = *(btCollisionWorld **)&jarg2; 
  (arg1)->reset(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btCharacterControllerInterface_1warp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btCharacterControllerInterface *arg1 = (btCharacterControllerInterface *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCharacterControllerInterface **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->warp((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btCharacterControllerInterface_1preStep(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btCharacterControllerInterface *arg1 = (btCharacterControllerInterface *) 0 ;
  btCollisionWorld *arg2 = (btCollisionWorld *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCharacterControllerInterface **)&jarg1; 
  arg2 = *(btCollisionWorld **)&jarg2; 
  (arg1)->preStep(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btCharacterControllerInterface_1playerStep(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3) {
  btCharacterControllerInterface *arg1 = (btCharacterControllerInterface *) 0 ;
  btCollisionWorld *arg2 = (btCollisionWorld *) 0 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btCharacterControllerInterface **)&jarg1; 
  arg2 = *(btCollisionWorld **)&jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->playerStep(arg2,arg3);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btCharacterControllerInterface_1canJump(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCharacterControllerInterface *arg1 = (btCharacterControllerInterface *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCharacterControllerInterface **)&jarg1; 
  result = (bool)((btCharacterControllerInterface const *)arg1)->canJump();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btCharacterControllerInterface_1jump_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btCharacterControllerInterface *arg1 = (btCharacterControllerInterface *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCharacterControllerInterface **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->jump((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btCharacterControllerInterface_1jump_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btCharacterControllerInterface *arg1 = (btCharacterControllerInterface *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCharacterControllerInterface **)&jarg1; 
  (arg1)->jump();
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btCharacterControllerInterface_1onGround(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btCharacterControllerInterface *arg1 = (btCharacterControllerInterface *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCharacterControllerInterface **)&jarg1; 
  result = (bool)((btCharacterControllerInterface const *)arg1)->onGround();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btCharacterControllerInterface_1setUpInterpolate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btCharacterControllerInterface *arg1 = (btCharacterControllerInterface *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btCharacterControllerInterface **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->setUpInterpolate(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1operatorNew_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1operatorDelete_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1operatorNew_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1operatorDelete_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1operatorNewArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new[](arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1operatorDeleteArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete[](arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1operatorNewArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new[](arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1operatorDeleteArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete[](arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btKinematicCharacterController_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3, jobject jarg4) {
  jlong jresult = 0 ;
  btPairCachingGhostObject *arg1 = (btPairCachingGhostObject *) 0 ;
  btConvexShape *arg2 = (btConvexShape *) 0 ;
  btScalar arg3 ;
  btVector3 *arg4 = 0 ;
  btKinematicCharacterController *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btPairCachingGhostObject **)&jarg1; 
  arg2 = *(btConvexShape **)&jarg2; 
  arg3 = (btScalar)jarg3; 
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  result = (btKinematicCharacterController *)new btKinematicCharacterController(arg1,arg2,arg3,(btVector3 const &)*arg4);
  *(btKinematicCharacterController **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btKinematicCharacterController_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3) {
  jlong jresult = 0 ;
  btPairCachingGhostObject *arg1 = (btPairCachingGhostObject *) 0 ;
  btConvexShape *arg2 = (btConvexShape *) 0 ;
  btScalar arg3 ;
  btKinematicCharacterController *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btPairCachingGhostObject **)&jarg1; 
  arg2 = *(btConvexShape **)&jarg2; 
  arg3 = (btScalar)jarg3; 
  result = (btKinematicCharacterController *)new btKinematicCharacterController(arg1,arg2,arg3);
  *(btKinematicCharacterController **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btKinematicCharacterController(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1setUp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setUp((btVector3 const &)*arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1getUp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  result = (btVector3 *) &(arg1)->getUp();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1setAngularVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setAngularVelocity((btVector3 const &)*arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1getAngularVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  result = (btVector3 *) &((btKinematicCharacterController const *)arg1)->getAngularVelocity();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1setLinearVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setLinearVelocity((btVector3 const &)*arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1getLinearVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  result = ((btKinematicCharacterController const *)arg1)->getLinearVelocity();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1setLinearDamping(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setLinearDamping(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1getLinearDamping(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  result = (btScalar)((btKinematicCharacterController const *)arg1)->getLinearDamping();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1setAngularDamping(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setAngularDamping(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1getAngularDamping(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  result = (btScalar)((btKinematicCharacterController const *)arg1)->getAngularDamping();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1setStepHeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setStepHeight(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1getStepHeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  result = (btScalar)((btKinematicCharacterController const *)arg1)->getStepHeight();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1setFallSpeed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setFallSpeed(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1getFallSpeed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  result = (btScalar)((btKinematicCharacterController const *)arg1)->getFallSpeed();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1setJumpSpeed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setJumpSpeed(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1getJumpSpeed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  result = (btScalar)((btKinematicCharacterController const *)arg1)->getJumpSpeed();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1setMaxJumpHeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setMaxJumpHeight(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1jump_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->jump((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1jump_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  (arg1)->jump();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1applyImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->applyImpulse((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1setGravity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setGravity((btVector3 const &)*arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1getGravity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  result = ((btKinematicCharacterController const *)arg1)->getGravity();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1setMaxSlope(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setMaxSlope(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1getMaxSlope(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  result = (btScalar)((btKinematicCharacterController const *)arg1)->getMaxSlope();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1setMaxPenetrationDepth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setMaxPenetrationDepth(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1getMaxPenetrationDepth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  result = (btScalar)((btKinematicCharacterController const *)arg1)->getMaxPenetrationDepth();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1getGhostObject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  btPairCachingGhostObject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  result = (btPairCachingGhostObject *)(arg1)->getGhostObject();
  *(btPairCachingGhostObject **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btKinematicCharacterController_1setUseGhostSweepTest(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btKinematicCharacterController *arg1 = (btKinematicCharacterController *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btKinematicCharacterController **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->setUseGhostSweepTest(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1tau_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_tau = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1tau_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (btScalar) ((arg1)->m_tau);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1damping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_damping = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1damping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (btScalar) ((arg1)->m_damping);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1friction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_friction = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1friction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (btScalar) ((arg1)->m_friction);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1timeStep_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_timeStep = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1timeStep_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (btScalar) ((arg1)->m_timeStep);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1restitution_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_restitution = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1restitution_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (btScalar) ((arg1)->m_restitution);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1numIterations_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numIterations = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1numIterations_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (int) ((arg1)->m_numIterations);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1maxErrorReduction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_maxErrorReduction = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1maxErrorReduction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (btScalar) ((arg1)->m_maxErrorReduction);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1sor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_sor = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1sor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (btScalar) ((arg1)->m_sor);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1erp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_erp = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1erp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (btScalar) ((arg1)->m_erp);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1erp2_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_erp2 = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1erp2_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (btScalar) ((arg1)->m_erp2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1globalCfm_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_globalCfm = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1globalCfm_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (btScalar) ((arg1)->m_globalCfm);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1frictionERP_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_frictionERP = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1frictionERP_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (btScalar) ((arg1)->m_frictionERP);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1frictionCFM_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_frictionCFM = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1frictionCFM_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (btScalar) ((arg1)->m_frictionCFM);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1splitImpulse_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_splitImpulse = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1splitImpulse_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (int) ((arg1)->m_splitImpulse);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1splitImpulsePenetrationThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_splitImpulsePenetrationThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1splitImpulsePenetrationThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (btScalar) ((arg1)->m_splitImpulsePenetrationThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1splitImpulseTurnErp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_splitImpulseTurnErp = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1splitImpulseTurnErp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (btScalar) ((arg1)->m_splitImpulseTurnErp);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1linearSlop_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_linearSlop = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1linearSlop_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (btScalar) ((arg1)->m_linearSlop);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1warmstartingFactor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_warmstartingFactor = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1warmstartingFactor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (btScalar) ((arg1)->m_warmstartingFactor);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1solverMode_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_solverMode = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1solverMode_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (int) ((arg1)->m_solverMode);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1restingContactRestitutionThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_restingContactRestitutionThreshold = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1restingContactRestitutionThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (int) ((arg1)->m_restingContactRestitutionThreshold);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1minimumSolverBatchSize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_minimumSolverBatchSize = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1minimumSolverBatchSize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (int) ((arg1)->m_minimumSolverBatchSize);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1maxGyroscopicForce_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_maxGyroscopicForce = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1maxGyroscopicForce_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (btScalar) ((arg1)->m_maxGyroscopicForce);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1singleAxisRollingFrictionThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_singleAxisRollingFrictionThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1singleAxisRollingFrictionThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (btScalar) ((arg1)->m_singleAxisRollingFrictionThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1leastSquaresResidualThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_leastSquaresResidualThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1leastSquaresResidualThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (btScalar) ((arg1)->m_leastSquaresResidualThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1restitutionVelocityThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_restitutionVelocityThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoData_1restitutionVelocityThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  result = (btScalar) ((arg1)->m_restitutionVelocityThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btContactSolverInfoData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btContactSolverInfoData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btContactSolverInfoData *)new btContactSolverInfoData();
  *(btContactSolverInfoData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btContactSolverInfoData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btContactSolverInfoData *arg1 = (btContactSolverInfoData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btContactSolverInfoData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btContactSolverInfo(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btContactSolverInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btContactSolverInfo *)new btContactSolverInfo();
  *(btContactSolverInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btContactSolverInfo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btContactSolverInfo *arg1 = (btContactSolverInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btContactSolverInfo **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1tau_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_tau = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1tau_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_tau);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1damping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_damping = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1damping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_damping);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1friction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_friction = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1friction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_friction);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1timeStep_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_timeStep = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1timeStep_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_timeStep);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1restitution_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_restitution = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1restitution_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_restitution);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1maxErrorReduction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_maxErrorReduction = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1maxErrorReduction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_maxErrorReduction);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1sor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_sor = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1sor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_sor);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1erp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_erp = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1erp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_erp);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1erp2_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_erp2 = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1erp2_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_erp2);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1globalCfm_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_globalCfm = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1globalCfm_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_globalCfm);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1splitImpulsePenetrationThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_splitImpulsePenetrationThreshold = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1splitImpulsePenetrationThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_splitImpulsePenetrationThreshold);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1splitImpulseTurnErp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_splitImpulseTurnErp = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1splitImpulseTurnErp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_splitImpulseTurnErp);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1linearSlop_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_linearSlop = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1linearSlop_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_linearSlop);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1warmstartingFactor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_warmstartingFactor = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1warmstartingFactor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_warmstartingFactor);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1maxGyroscopicForce_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_maxGyroscopicForce = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1maxGyroscopicForce_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_maxGyroscopicForce);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1singleAxisRollingFrictionThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_singleAxisRollingFrictionThreshold = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1singleAxisRollingFrictionThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_singleAxisRollingFrictionThreshold);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1numIterations_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numIterations = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1numIterations_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_numIterations);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1solverMode_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_solverMode = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1solverMode_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_solverMode);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1restingContactRestitutionThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_restingContactRestitutionThreshold = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1restingContactRestitutionThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_restingContactRestitutionThreshold);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1minimumSolverBatchSize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_minimumSolverBatchSize = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1minimumSolverBatchSize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_minimumSolverBatchSize);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1splitImpulse_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_splitImpulse = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1splitImpulse_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_splitImpulse);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1padding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_padding, (const char *)arg2, 4-1);
      arg1->m_padding[4-1] = 0;
    } else {
      arg1->m_padding[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoDoubleData_1padding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_padding);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btContactSolverInfoDoubleData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btContactSolverInfoDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btContactSolverInfoDoubleData *)new btContactSolverInfoDoubleData();
  *(btContactSolverInfoDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btContactSolverInfoDoubleData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btContactSolverInfoDoubleData *arg1 = (btContactSolverInfoDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btContactSolverInfoDoubleData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1tau_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_tau = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1tau_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  result = (float) ((arg1)->m_tau);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1damping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_damping = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1damping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  result = (float) ((arg1)->m_damping);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1friction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_friction = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1friction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  result = (float) ((arg1)->m_friction);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1timeStep_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_timeStep = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1timeStep_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  result = (float) ((arg1)->m_timeStep);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1restitution_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_restitution = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1restitution_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  result = (float) ((arg1)->m_restitution);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1maxErrorReduction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_maxErrorReduction = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1maxErrorReduction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  result = (float) ((arg1)->m_maxErrorReduction);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1sor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_sor = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1sor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  result = (float) ((arg1)->m_sor);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1erp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_erp = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1erp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  result = (float) ((arg1)->m_erp);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1erp2_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_erp2 = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1erp2_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  result = (float) ((arg1)->m_erp2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1globalCfm_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_globalCfm = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1globalCfm_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  result = (float) ((arg1)->m_globalCfm);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1splitImpulsePenetrationThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_splitImpulsePenetrationThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1splitImpulsePenetrationThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  result = (float) ((arg1)->m_splitImpulsePenetrationThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1splitImpulseTurnErp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_splitImpulseTurnErp = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1splitImpulseTurnErp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  result = (float) ((arg1)->m_splitImpulseTurnErp);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1linearSlop_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_linearSlop = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1linearSlop_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  result = (float) ((arg1)->m_linearSlop);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1warmstartingFactor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_warmstartingFactor = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1warmstartingFactor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  result = (float) ((arg1)->m_warmstartingFactor);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1maxGyroscopicForce_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_maxGyroscopicForce = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1maxGyroscopicForce_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  result = (float) ((arg1)->m_maxGyroscopicForce);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1singleAxisRollingFrictionThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_singleAxisRollingFrictionThreshold = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1singleAxisRollingFrictionThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  result = (float) ((arg1)->m_singleAxisRollingFrictionThreshold);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1numIterations_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_numIterations = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1numIterations_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  result = (int) ((arg1)->m_numIterations);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1solverMode_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_solverMode = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1solverMode_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  result = (int) ((arg1)->m_solverMode);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1restingContactRestitutionThreshold_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_restingContactRestitutionThreshold = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1restingContactRestitutionThreshold_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  result = (int) ((arg1)->m_restingContactRestitutionThreshold);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1minimumSolverBatchSize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_minimumSolverBatchSize = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1minimumSolverBatchSize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  result = (int) ((arg1)->m_minimumSolverBatchSize);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1splitImpulse_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_splitImpulse = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1splitImpulse_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  result = (int) ((arg1)->m_splitImpulse);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1padding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_padding, (const char *)arg2, 4-1);
      arg1->m_padding[4-1] = 0;
    } else {
      arg1->m_padding[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactSolverInfoFloatData_1padding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_padding);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btContactSolverInfoFloatData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btContactSolverInfoFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btContactSolverInfoFloatData *)new btContactSolverInfoFloatData();
  *(btContactSolverInfoFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btContactSolverInfoFloatData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btContactSolverInfoFloatData *arg1 = (btContactSolverInfoFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btContactSolverInfoFloatData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btConstraintSolver(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConstraintSolver *arg1 = (btConstraintSolver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConstraintSolver **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConstraintSolver_1prepareSolve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  btConstraintSolver *arg1 = (btConstraintSolver *) 0 ;
  int arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConstraintSolver **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->prepareSolve(arg2,arg3);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConstraintSolver_1solveGroup(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jlong jarg4, jint jarg5, jlong jarg6, jint jarg7, jlong jarg8, jobject jarg8_, jlong jarg9, jobject jarg9_, jlong jarg10, jobject jarg10_) {
  jfloat jresult = 0 ;
  btConstraintSolver *arg1 = (btConstraintSolver *) 0 ;
  btCollisionObject **arg2 = (btCollisionObject **) 0 ;
  int arg3 ;
  btPersistentManifold **arg4 = (btPersistentManifold **) 0 ;
  int arg5 ;
  btTypedConstraint **arg6 = (btTypedConstraint **) 0 ;
  int arg7 ;
  btContactSolverInfo *arg8 = 0 ;
  btIDebugDraw *arg9 = (btIDebugDraw *) 0 ;
  btDispatcher *arg10 = (btDispatcher *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg8_;
  (void)jarg9_;
  (void)jarg10_;
  arg1 = *(btConstraintSolver **)&jarg1; 
  arg2 = *(btCollisionObject ***)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = *(btPersistentManifold ***)&jarg4; 
  arg5 = (int)jarg5; 
  arg6 = *(btTypedConstraint ***)&jarg6; 
  arg7 = (int)jarg7; 
  arg8 = *(btContactSolverInfo **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btContactSolverInfo const & reference is null");
    return 0;
  } 
  arg9 = *(btIDebugDraw **)&jarg9; 
  arg10 = *(btDispatcher **)&jarg10; 
  result = (btScalar)(arg1)->solveGroup(arg2,arg3,arg4,arg5,arg6,arg7,(btContactSolverInfo const &)*arg8,arg9,arg10);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConstraintSolver_1allSolved(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  btConstraintSolver *arg1 = (btConstraintSolver *) 0 ;
  btContactSolverInfo *arg2 = 0 ;
  btIDebugDraw *arg3 = (btIDebugDraw *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btConstraintSolver **)&jarg1; 
  arg2 = *(btContactSolverInfo **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btContactSolverInfo const & reference is null");
    return ;
  } 
  arg3 = *(btIDebugDraw **)&jarg3; 
  (arg1)->allSolved((btContactSolverInfo const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConstraintSolver_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btConstraintSolver *arg1 = (btConstraintSolver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConstraintSolver **)&jarg1; 
  (arg1)->reset();
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConstraintSolver_1getSolverType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btConstraintSolver *arg1 = (btConstraintSolver *) 0 ;
  btConstraintSolverType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConstraintSolver **)&jarg1; 
  result = (btConstraintSolverType)((btConstraintSolver const *)arg1)->getSolverType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSequentialImpulseConstraintSolver_1operatorNew_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btSequentialImpulseConstraintSolver *arg1 = (btSequentialImpulseConstraintSolver *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSequentialImpulseConstraintSolver **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSequentialImpulseConstraintSolver_1operatorDelete_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSequentialImpulseConstraintSolver *arg1 = (btSequentialImpulseConstraintSolver *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSequentialImpulseConstraintSolver **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSequentialImpulseConstraintSolver_1operatorNew_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btSequentialImpulseConstraintSolver *arg1 = (btSequentialImpulseConstraintSolver *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSequentialImpulseConstraintSolver **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSequentialImpulseConstraintSolver_1operatorDelete_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btSequentialImpulseConstraintSolver *arg1 = (btSequentialImpulseConstraintSolver *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSequentialImpulseConstraintSolver **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSequentialImpulseConstraintSolver_1operatorNewArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btSequentialImpulseConstraintSolver *arg1 = (btSequentialImpulseConstraintSolver *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSequentialImpulseConstraintSolver **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new[](arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSequentialImpulseConstraintSolver_1operatorDeleteArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSequentialImpulseConstraintSolver *arg1 = (btSequentialImpulseConstraintSolver *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSequentialImpulseConstraintSolver **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete[](arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSequentialImpulseConstraintSolver_1operatorNewArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btSequentialImpulseConstraintSolver *arg1 = (btSequentialImpulseConstraintSolver *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSequentialImpulseConstraintSolver **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new[](arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSequentialImpulseConstraintSolver_1operatorDeleteArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btSequentialImpulseConstraintSolver *arg1 = (btSequentialImpulseConstraintSolver *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSequentialImpulseConstraintSolver **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete[](arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btSequentialImpulseConstraintSolver(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSequentialImpulseConstraintSolver *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSequentialImpulseConstraintSolver *)new btSequentialImpulseConstraintSolver();
  *(btSequentialImpulseConstraintSolver **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btSequentialImpulseConstraintSolver(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSequentialImpulseConstraintSolver *arg1 = (btSequentialImpulseConstraintSolver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSequentialImpulseConstraintSolver **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSequentialImpulseConstraintSolver_1btRand2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSequentialImpulseConstraintSolver *arg1 = (btSequentialImpulseConstraintSolver *) 0 ;
  unsigned long result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSequentialImpulseConstraintSolver **)&jarg1; 
  result = (unsigned long)(arg1)->btRand2();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSequentialImpulseConstraintSolver_1btRandInt2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  btSequentialImpulseConstraintSolver *arg1 = (btSequentialImpulseConstraintSolver *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSequentialImpulseConstraintSolver **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)(arg1)->btRandInt2(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSequentialImpulseConstraintSolver_1setRandSeed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSequentialImpulseConstraintSolver *arg1 = (btSequentialImpulseConstraintSolver *) 0 ;
  unsigned long arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSequentialImpulseConstraintSolver **)&jarg1; 
  arg2 = (unsigned long)jarg2; 
  (arg1)->setRandSeed(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSequentialImpulseConstraintSolver_1getRandSeed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSequentialImpulseConstraintSolver *arg1 = (btSequentialImpulseConstraintSolver *) 0 ;
  unsigned long result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSequentialImpulseConstraintSolver **)&jarg1; 
  result = (unsigned long)((btSequentialImpulseConstraintSolver const *)arg1)->getRandSeed();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSequentialImpulseConstraintSolver_1getActiveConstraintRowSolverGeneric(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSequentialImpulseConstraintSolver *arg1 = (btSequentialImpulseConstraintSolver *) 0 ;
  btSingleConstraintRowSolver result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSequentialImpulseConstraintSolver **)&jarg1; 
  result = (btSingleConstraintRowSolver)(arg1)->getActiveConstraintRowSolverGeneric();
  *(btSingleConstraintRowSolver *)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSequentialImpulseConstraintSolver_1setConstraintRowSolverGeneric(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSequentialImpulseConstraintSolver *arg1 = (btSequentialImpulseConstraintSolver *) 0 ;
  btSingleConstraintRowSolver arg2 = (btSingleConstraintRowSolver) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSequentialImpulseConstraintSolver **)&jarg1; 
  arg2 = *(btSingleConstraintRowSolver *)&jarg2; 
  (arg1)->setConstraintRowSolverGeneric(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSequentialImpulseConstraintSolver_1getActiveConstraintRowSolverLowerLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSequentialImpulseConstraintSolver *arg1 = (btSequentialImpulseConstraintSolver *) 0 ;
  btSingleConstraintRowSolver result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSequentialImpulseConstraintSolver **)&jarg1; 
  result = (btSingleConstraintRowSolver)(arg1)->getActiveConstraintRowSolverLowerLimit();
  *(btSingleConstraintRowSolver *)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSequentialImpulseConstraintSolver_1setConstraintRowSolverLowerLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSequentialImpulseConstraintSolver *arg1 = (btSequentialImpulseConstraintSolver *) 0 ;
  btSingleConstraintRowSolver arg2 = (btSingleConstraintRowSolver) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSequentialImpulseConstraintSolver **)&jarg1; 
  arg2 = *(btSingleConstraintRowSolver *)&jarg2; 
  (arg1)->setConstraintRowSolverLowerLimit(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSequentialImpulseConstraintSolver_1getScalarConstraintRowSolverGeneric(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSequentialImpulseConstraintSolver *arg1 = (btSequentialImpulseConstraintSolver *) 0 ;
  btSingleConstraintRowSolver result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSequentialImpulseConstraintSolver **)&jarg1; 
  result = (btSingleConstraintRowSolver)(arg1)->getScalarConstraintRowSolverGeneric();
  *(btSingleConstraintRowSolver *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSequentialImpulseConstraintSolver_1getScalarConstraintRowSolverLowerLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSequentialImpulseConstraintSolver *arg1 = (btSequentialImpulseConstraintSolver *) 0 ;
  btSingleConstraintRowSolver result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSequentialImpulseConstraintSolver **)&jarg1; 
  result = (btSingleConstraintRowSolver)(arg1)->getScalarConstraintRowSolverLowerLimit();
  *(btSingleConstraintRowSolver *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1operatorNew_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1operatorDelete_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1operatorNew_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1operatorDelete_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1operatorNewArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new[](arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1operatorDeleteArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete[](arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1operatorNewArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new[](arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1operatorDeleteArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete[](arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1worldTransform_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btTransform *arg2 = (btTransform *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSolverBody **)&jarg1; 
  arg2 = *(btTransform **)&jarg2; 
  if (arg1) (arg1)->m_worldTransform = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1worldTransform_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  result = (btTransform *)& ((arg1)->m_worldTransform);
  *(btTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1deltaLinearVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSolverBody **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_deltaLinearVelocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1deltaLinearVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_deltaLinearVelocity);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1deltaAngularVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSolverBody **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_deltaAngularVelocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1deltaAngularVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_deltaAngularVelocity);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1angularFactor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSolverBody **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_angularFactor = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1angularFactor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_angularFactor);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1linearFactor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSolverBody **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_linearFactor = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1linearFactor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_linearFactor);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1invMass_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSolverBody **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_invMass = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1invMass_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_invMass);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1pushVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSolverBody **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_pushVelocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1pushVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_pushVelocity);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1turnVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSolverBody **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_turnVelocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1turnVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_turnVelocity);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1linearVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSolverBody **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_linearVelocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1linearVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_linearVelocity);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1angularVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSolverBody **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_angularVelocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1angularVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_angularVelocity);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1externalForceImpulse_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSolverBody **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_externalForceImpulse = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1externalForceImpulse_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_externalForceImpulse);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1externalTorqueImpulse_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSolverBody **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_externalTorqueImpulse = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1externalTorqueImpulse_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_externalTorqueImpulse);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1originalBody_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btRigidBody *arg2 = (btRigidBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSolverBody **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2; 
  if (arg1) (arg1)->m_originalBody = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1originalBody_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btRigidBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  result = (btRigidBody *) ((arg1)->m_originalBody);
  *(btRigidBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1getVelocityInLocalPointNoDelta(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  ((btSolverBody const *)arg1)->getVelocityInLocalPointNoDelta((btVector3 const &)*arg2,*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1getVelocityInLocalPointObsolete(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  ((btSolverBody const *)arg1)->getVelocityInLocalPointObsolete((btVector3 const &)*arg2,*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1getAngularVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  ((btSolverBody const *)arg1)->getAngularVelocity(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1applyImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jfloat jarg4) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (btScalar)jarg4; 
  (arg1)->applyImpulse((btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1internalApplyPushImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jfloat jarg4) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (btScalar)jarg4; 
  (arg1)->internalApplyPushImpulse((btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1internalGetDeltaLinearVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  result = (btVector3 *) &(arg1)->internalGetDeltaLinearVelocity();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1internalGetDeltaAngularVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  result = (btVector3 *) &(arg1)->internalGetDeltaAngularVelocity();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1internalGetAngularFactor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  result = (btVector3 *) &((btSolverBody const *)arg1)->internalGetAngularFactor();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1internalGetInvMass(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  result = (btVector3 *) &((btSolverBody const *)arg1)->internalGetInvMass();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1internalSetInvMass(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->internalSetInvMass((btVector3 const &)*arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1internalGetPushVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  result = (btVector3 *) &(arg1)->internalGetPushVelocity();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1internalGetTurnVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  result = (btVector3 *) &(arg1)->internalGetTurnVelocity();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1internalGetVelocityInLocalPointObsolete(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  ((btSolverBody const *)arg1)->internalGetVelocityInLocalPointObsolete((btVector3 const &)*arg2,*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1internalGetAngularVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  ((btSolverBody const *)arg1)->internalGetAngularVelocity(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1internalApplyImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jfloat jarg4) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btScalar arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (btScalar)jarg4; 
  (arg1)->internalApplyImpulse((btVector3 const &)*arg2,(btVector3 const &)*arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1writebackVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  (arg1)->writebackVelocity();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolverBody_1writebackVelocityAndTransform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSolverBody **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->writebackVelocityAndTransform(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btSolverBody(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSolverBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSolverBody *)new btSolverBody();
  *(btSolverBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btSolverBody(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSolverBody *arg1 = (btSolverBody *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSolverBody **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1operatorNew_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1operatorDelete_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1operatorNew_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1operatorDelete_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1operatorNewArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new[](arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1operatorDeleteArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete[](arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1operatorNewArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new[](arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1operatorDeleteArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete[](arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btSliderConstraint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jboolean jarg5) {
  jlong jresult = 0 ;
  btRigidBody *arg1 = 0 ;
  btRigidBody *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  bool arg5 ;
  btSliderConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBody **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = jarg5 ? true : false; 
  result = (btSliderConstraint *)new btSliderConstraint(*arg1,*arg2,(btTransform const &)*arg3,(btTransform const &)*arg4,arg5);
  *(btSliderConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btSliderConstraint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  btRigidBody *arg1 = 0 ;
  btTransform *arg2 = 0 ;
  bool arg3 ;
  btSliderConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = jarg3 ? true : false; 
  result = (btSliderConstraint *)new btSliderConstraint(*arg1,(btTransform const &)*arg2,arg3);
  *(btSliderConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getInfo1NonVirtual(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btTypedConstraint::btConstraintInfo1 *arg2 = (btTypedConstraint::btConstraintInfo1 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = *(btTypedConstraint::btConstraintInfo1 **)&jarg2; 
  (arg1)->getInfo1NonVirtual(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getInfo2NonVirtual(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jobject jarg5, jobject jarg6, jfloat jarg7, jfloat jarg8) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btTypedConstraint::btConstraintInfo2 *arg2 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btTransform *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  btScalar arg7 ;
  btScalar arg8 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = *(btTypedConstraint::btConstraintInfo2 **)&jarg2; 
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  arg7 = (btScalar)jarg7; 
  arg8 = (btScalar)jarg8; 
  (arg1)->getInfo2NonVirtual(arg2,(btTransform const &)*arg3,(btTransform const &)*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6,arg7,arg8);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getRigidBodyAConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btRigidBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btRigidBody *) &((btSliderConstraint const *)arg1)->getRigidBodyA();
  *(btRigidBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getRigidBodyBConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btRigidBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btRigidBody *) &((btSliderConstraint const *)arg1)->getRigidBodyB();
  *(btRigidBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getCalculatedTransformA(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btTransform *) &((btSliderConstraint const *)arg1)->getCalculatedTransformA();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getCalculatedTransformB(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btTransform *) &((btSliderConstraint const *)arg1)->getCalculatedTransformB();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getFrameOffsetAConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btTransform *) &((btSliderConstraint const *)arg1)->getFrameOffsetA();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getFrameOffsetBConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btTransform *) &((btSliderConstraint const *)arg1)->getFrameOffsetB();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getFrameOffsetA(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btTransform *) &(arg1)->getFrameOffsetA();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getFrameOffsetB(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btTransform *) &(arg1)->getFrameOffsetB();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getLowerLinLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getLowerLinLimit();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setLowerLinLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setLowerLinLimit(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getUpperLinLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getUpperLinLimit();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setUpperLinLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setUpperLinLimit(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getLowerAngLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getLowerAngLimit();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setLowerAngLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setLowerAngLimit(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getUpperAngLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getUpperAngLimit();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setUpperAngLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setUpperAngLimit(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getUseLinearReferenceFrameA(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (bool)(arg1)->getUseLinearReferenceFrameA();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getSoftnessDirLin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getSoftnessDirLin();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getRestitutionDirLin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getRestitutionDirLin();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getDampingDirLin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getDampingDirLin();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getSoftnessDirAng(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getSoftnessDirAng();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getRestitutionDirAng(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getRestitutionDirAng();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getDampingDirAng(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getDampingDirAng();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getSoftnessLimLin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getSoftnessLimLin();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getRestitutionLimLin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getRestitutionLimLin();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getDampingLimLin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getDampingLimLin();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getSoftnessLimAng(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getSoftnessLimAng();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getRestitutionLimAng(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getRestitutionLimAng();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getDampingLimAng(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getDampingLimAng();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getSoftnessOrthoLin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getSoftnessOrthoLin();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getRestitutionOrthoLin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getRestitutionOrthoLin();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getDampingOrthoLin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getDampingOrthoLin();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getSoftnessOrthoAng(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getSoftnessOrthoAng();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getRestitutionOrthoAng(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getRestitutionOrthoAng();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getDampingOrthoAng(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getDampingOrthoAng();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setSoftnessDirLin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setSoftnessDirLin(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setRestitutionDirLin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setRestitutionDirLin(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setDampingDirLin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setDampingDirLin(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setSoftnessDirAng(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setSoftnessDirAng(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setRestitutionDirAng(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setRestitutionDirAng(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setDampingDirAng(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setDampingDirAng(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setSoftnessLimLin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setSoftnessLimLin(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setRestitutionLimLin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setRestitutionLimLin(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setDampingLimLin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setDampingLimLin(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setSoftnessLimAng(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setSoftnessLimAng(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setRestitutionLimAng(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setRestitutionLimAng(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setDampingLimAng(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setDampingLimAng(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setSoftnessOrthoLin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setSoftnessOrthoLin(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setRestitutionOrthoLin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setRestitutionOrthoLin(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setDampingOrthoLin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setDampingOrthoLin(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setSoftnessOrthoAng(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setSoftnessOrthoAng(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setRestitutionOrthoAng(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setRestitutionOrthoAng(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setDampingOrthoAng(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setDampingOrthoAng(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setPoweredLinMotor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->setPoweredLinMotor(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getPoweredLinMotor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (bool)(arg1)->getPoweredLinMotor();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setTargetLinMotorVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setTargetLinMotorVelocity(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getTargetLinMotorVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getTargetLinMotorVelocity();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setMaxLinMotorForce(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setMaxLinMotorForce(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getMaxLinMotorForce(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getMaxLinMotorForce();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setPoweredAngMotor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->setPoweredAngMotor(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getPoweredAngMotor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (bool)(arg1)->getPoweredAngMotor();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setTargetAngMotorVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setTargetAngMotorVelocity(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getTargetAngMotorVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getTargetAngMotorVelocity();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setMaxAngMotorForce(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setMaxAngMotorForce(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getMaxAngMotorForce(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getMaxAngMotorForce();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getLinearPos(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)((btSliderConstraint const *)arg1)->getLinearPos();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getAngularPos(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)((btSliderConstraint const *)arg1)->getAngularPos();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getSolveLinLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (bool)(arg1)->getSolveLinLimit();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getLinDepth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getLinDepth();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getSolveAngLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (bool)(arg1)->getSolveAngLimit();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getAngDepth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getAngDepth();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1calculateTransforms(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btTransform *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->calculateTransforms((btTransform const &)*arg2,(btTransform const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1testLinLimits(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  (arg1)->testLinLimits();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1testAngLimits(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  (arg1)->testAngLimits();
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getAncorInA(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (arg1)->getAncorInA();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getAncorInB(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (arg1)->getAncorInB();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getUseFrameOffset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (bool)(arg1)->getUseFrameOffset();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setUseFrameOffset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->setUseFrameOffset(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setFrames(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  btTransform *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->setFrames((btTransform const &)*arg2,(btTransform const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setParam_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3, jint jarg4) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->setParam(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1setParam_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setParam(arg2,arg3);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getParam_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  int arg2 ;
  int arg3 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (btScalar)((btSliderConstraint const *)arg1)->getParam(arg2,arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getParam_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jfloat jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  int arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btScalar)((btSliderConstraint const *)arg1)->getParam(arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraint_1getFlags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraint **)&jarg1; 
  result = (int)((btSliderConstraint const *)arg1)->getFlags();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btSliderConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSliderConstraint *arg1 = (btSliderConstraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSliderConstraint **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintData_1typeConstraintData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSliderConstraintData *arg1 = (btSliderConstraintData *) 0 ;
  btTypedConstraintData *arg2 = (btTypedConstraintData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSliderConstraintData **)&jarg1; 
  arg2 = *(btTypedConstraintData **)&jarg2; 
  if (arg1) (arg1)->m_typeConstraintData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintData_1typeConstraintData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSliderConstraintData *arg1 = (btSliderConstraintData *) 0 ;
  btTypedConstraintData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintData **)&jarg1; 
  result = (btTypedConstraintData *)& ((arg1)->m_typeConstraintData);
  *(btTypedConstraintData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintData_1rbAFrame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSliderConstraintData *arg1 = (btSliderConstraintData *) 0 ;
  btTransformFloatData *arg2 = (btTransformFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSliderConstraintData **)&jarg1; 
  arg2 = *(btTransformFloatData **)&jarg2; 
  if (arg1) (arg1)->m_rbAFrame = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintData_1rbAFrame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSliderConstraintData *arg1 = (btSliderConstraintData *) 0 ;
  btTransformFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintData **)&jarg1; 
  result = (btTransformFloatData *)& ((arg1)->m_rbAFrame);
  *(btTransformFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintData_1rbBFrame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSliderConstraintData *arg1 = (btSliderConstraintData *) 0 ;
  btTransformFloatData *arg2 = (btTransformFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSliderConstraintData **)&jarg1; 
  arg2 = *(btTransformFloatData **)&jarg2; 
  if (arg1) (arg1)->m_rbBFrame = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintData_1rbBFrame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSliderConstraintData *arg1 = (btSliderConstraintData *) 0 ;
  btTransformFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintData **)&jarg1; 
  result = (btTransformFloatData *)& ((arg1)->m_rbBFrame);
  *(btTransformFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintData_1linearUpperLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraintData *arg1 = (btSliderConstraintData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_linearUpperLimit = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintData_1linearUpperLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraintData *arg1 = (btSliderConstraintData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintData **)&jarg1; 
  result = (float) ((arg1)->m_linearUpperLimit);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintData_1linearLowerLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraintData *arg1 = (btSliderConstraintData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_linearLowerLimit = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintData_1linearLowerLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraintData *arg1 = (btSliderConstraintData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintData **)&jarg1; 
  result = (float) ((arg1)->m_linearLowerLimit);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintData_1angularUpperLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraintData *arg1 = (btSliderConstraintData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_angularUpperLimit = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintData_1angularUpperLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraintData *arg1 = (btSliderConstraintData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintData **)&jarg1; 
  result = (float) ((arg1)->m_angularUpperLimit);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintData_1angularLowerLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btSliderConstraintData *arg1 = (btSliderConstraintData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_angularLowerLimit = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintData_1angularLowerLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btSliderConstraintData *arg1 = (btSliderConstraintData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintData **)&jarg1; 
  result = (float) ((arg1)->m_angularLowerLimit);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintData_1useLinearReferenceFrameA_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSliderConstraintData *arg1 = (btSliderConstraintData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_useLinearReferenceFrameA = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintData_1useLinearReferenceFrameA_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSliderConstraintData *arg1 = (btSliderConstraintData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintData **)&jarg1; 
  result = (int) ((arg1)->m_useLinearReferenceFrameA);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintData_1useOffsetForConstraintFrame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSliderConstraintData *arg1 = (btSliderConstraintData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_useOffsetForConstraintFrame = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintData_1useOffsetForConstraintFrame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSliderConstraintData *arg1 = (btSliderConstraintData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintData **)&jarg1; 
  result = (int) ((arg1)->m_useOffsetForConstraintFrame);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btSliderConstraintData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSliderConstraintData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSliderConstraintData *)new btSliderConstraintData();
  *(btSliderConstraintData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btSliderConstraintData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSliderConstraintData *arg1 = (btSliderConstraintData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSliderConstraintData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintDoubleData_1typeConstraintData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSliderConstraintDoubleData *arg1 = (btSliderConstraintDoubleData *) 0 ;
  btTypedConstraintDoubleData *arg2 = (btTypedConstraintDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSliderConstraintDoubleData **)&jarg1; 
  arg2 = *(btTypedConstraintDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_typeConstraintData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintDoubleData_1typeConstraintData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSliderConstraintDoubleData *arg1 = (btSliderConstraintDoubleData *) 0 ;
  btTypedConstraintDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintDoubleData **)&jarg1; 
  result = (btTypedConstraintDoubleData *)& ((arg1)->m_typeConstraintData);
  *(btTypedConstraintDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintDoubleData_1rbAFrame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSliderConstraintDoubleData *arg1 = (btSliderConstraintDoubleData *) 0 ;
  btTransformDoubleData *arg2 = (btTransformDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSliderConstraintDoubleData **)&jarg1; 
  arg2 = *(btTransformDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_rbAFrame = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintDoubleData_1rbAFrame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSliderConstraintDoubleData *arg1 = (btSliderConstraintDoubleData *) 0 ;
  btTransformDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintDoubleData **)&jarg1; 
  result = (btTransformDoubleData *)& ((arg1)->m_rbAFrame);
  *(btTransformDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintDoubleData_1rbBFrame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btSliderConstraintDoubleData *arg1 = (btSliderConstraintDoubleData *) 0 ;
  btTransformDoubleData *arg2 = (btTransformDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btSliderConstraintDoubleData **)&jarg1; 
  arg2 = *(btTransformDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_rbBFrame = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintDoubleData_1rbBFrame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btSliderConstraintDoubleData *arg1 = (btSliderConstraintDoubleData *) 0 ;
  btTransformDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintDoubleData **)&jarg1; 
  result = (btTransformDoubleData *)& ((arg1)->m_rbBFrame);
  *(btTransformDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintDoubleData_1linearUpperLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btSliderConstraintDoubleData *arg1 = (btSliderConstraintDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_linearUpperLimit = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintDoubleData_1linearUpperLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btSliderConstraintDoubleData *arg1 = (btSliderConstraintDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_linearUpperLimit);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintDoubleData_1linearLowerLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btSliderConstraintDoubleData *arg1 = (btSliderConstraintDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_linearLowerLimit = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintDoubleData_1linearLowerLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btSliderConstraintDoubleData *arg1 = (btSliderConstraintDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_linearLowerLimit);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintDoubleData_1angularUpperLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btSliderConstraintDoubleData *arg1 = (btSliderConstraintDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_angularUpperLimit = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintDoubleData_1angularUpperLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btSliderConstraintDoubleData *arg1 = (btSliderConstraintDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_angularUpperLimit);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintDoubleData_1angularLowerLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btSliderConstraintDoubleData *arg1 = (btSliderConstraintDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_angularLowerLimit = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintDoubleData_1angularLowerLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btSliderConstraintDoubleData *arg1 = (btSliderConstraintDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_angularLowerLimit);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintDoubleData_1useLinearReferenceFrameA_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSliderConstraintDoubleData *arg1 = (btSliderConstraintDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_useLinearReferenceFrameA = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintDoubleData_1useLinearReferenceFrameA_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSliderConstraintDoubleData *arg1 = (btSliderConstraintDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_useLinearReferenceFrameA);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintDoubleData_1useOffsetForConstraintFrame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btSliderConstraintDoubleData *arg1 = (btSliderConstraintDoubleData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintDoubleData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_useOffsetForConstraintFrame = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSliderConstraintDoubleData_1useOffsetForConstraintFrame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btSliderConstraintDoubleData *arg1 = (btSliderConstraintDoubleData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btSliderConstraintDoubleData **)&jarg1; 
  result = (int) ((arg1)->m_useOffsetForConstraintFrame);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btSliderConstraintDoubleData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btSliderConstraintDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btSliderConstraintDoubleData *)new btSliderConstraintDoubleData();
  *(btSliderConstraintDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btSliderConstraintDoubleData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSliderConstraintDoubleData *arg1 = (btSliderConstraintDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSliderConstraintDoubleData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btConstraintSetting(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btConstraintSetting *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btConstraintSetting *)new btConstraintSetting();
  *(btConstraintSetting **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConstraintSetting_1tau_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btConstraintSetting *arg1 = (btConstraintSetting *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConstraintSetting **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_tau = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConstraintSetting_1tau_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConstraintSetting *arg1 = (btConstraintSetting *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConstraintSetting **)&jarg1; 
  result = (btScalar) ((arg1)->m_tau);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConstraintSetting_1damping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btConstraintSetting *arg1 = (btConstraintSetting *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConstraintSetting **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_damping = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConstraintSetting_1damping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConstraintSetting *arg1 = (btConstraintSetting *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConstraintSetting **)&jarg1; 
  result = (btScalar) ((arg1)->m_damping);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConstraintSetting_1impulseClamp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btConstraintSetting *arg1 = (btConstraintSetting *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConstraintSetting **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_impulseClamp = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConstraintSetting_1impulseClamp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConstraintSetting *arg1 = (btConstraintSetting *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConstraintSetting **)&jarg1; 
  result = (btScalar) ((arg1)->m_impulseClamp);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btConstraintSetting(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConstraintSetting *arg1 = (btConstraintSetting *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConstraintSetting **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1operatorNew_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1operatorDelete_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1operatorNew_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1operatorDelete_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1operatorNewArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new[](arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1operatorDeleteArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete[](arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1operatorNewArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new[](arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1operatorDeleteArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete[](arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1useSolveConstraintObsolete_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_useSolveConstraintObsolete = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1useSolveConstraintObsolete_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  result = (bool) ((arg1)->m_useSolveConstraintObsolete);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1setting_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  btConstraintSetting *arg2 = (btConstraintSetting *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  arg2 = *(btConstraintSetting **)&jarg2; 
  if (arg1) (arg1)->m_setting = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1setting_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  btConstraintSetting *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  result = (btConstraintSetting *)& ((arg1)->m_setting);
  *(btConstraintSetting **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btPoint2PointConstraint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  jlong jresult = 0 ;
  btRigidBody *arg1 = 0 ;
  btRigidBody *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btPoint2PointConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBody **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  result = (btPoint2PointConstraint *)new btPoint2PointConstraint(*arg1,*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
  *(btPoint2PointConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btPoint2PointConstraint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  btRigidBody *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btPoint2PointConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btPoint2PointConstraint *)new btPoint2PointConstraint(*arg1,(btVector3 const &)*arg2);
  *(btPoint2PointConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1getInfo1NonVirtual(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  btTypedConstraint::btConstraintInfo1 *arg2 = (btTypedConstraint::btConstraintInfo1 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  arg2 = *(btTypedConstraint::btConstraintInfo1 **)&jarg2; 
  (arg1)->getInfo1NonVirtual(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1getInfo2NonVirtual(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  btTypedConstraint::btConstraintInfo2 *arg2 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btTransform *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  arg2 = *(btTypedConstraint::btConstraintInfo2 **)&jarg2; 
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  (arg1)->getInfo2NonVirtual(arg2,(btTransform const &)*arg3,(btTransform const &)*arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1updateRHS(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->updateRHS(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1setPivotA(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setPivotA((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1setPivotB(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setPivotB((btVector3 const &)*arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1getPivotInA(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  result = (btVector3 *) &((btPoint2PointConstraint const *)arg1)->getPivotInA();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1getPivotInB(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  result = (btVector3 *) &((btPoint2PointConstraint const *)arg1)->getPivotInB();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1setParam_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3, jint jarg4) {
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->setParam(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1setParam_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setParam(arg2,arg3);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1getParam_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jfloat jresult = 0 ;
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  int arg2 ;
  int arg3 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (btScalar)((btPoint2PointConstraint const *)arg1)->getParam(arg2,arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1getParam_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jfloat jresult = 0 ;
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  int arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btScalar)((btPoint2PointConstraint const *)arg1)->getParam(arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraint_1getFlags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  result = (int)((btPoint2PointConstraint const *)arg1)->getFlags();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btPoint2PointConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btPoint2PointConstraint *arg1 = (btPoint2PointConstraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btPoint2PointConstraint **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraintFloatData_1typeConstraintData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btPoint2PointConstraintFloatData *arg1 = (btPoint2PointConstraintFloatData *) 0 ;
  btTypedConstraintData *arg2 = (btTypedConstraintData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btPoint2PointConstraintFloatData **)&jarg1; 
  arg2 = *(btTypedConstraintData **)&jarg2; 
  if (arg1) (arg1)->m_typeConstraintData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraintFloatData_1typeConstraintData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btPoint2PointConstraintFloatData *arg1 = (btPoint2PointConstraintFloatData *) 0 ;
  btTypedConstraintData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraintFloatData **)&jarg1; 
  result = (btTypedConstraintData *)& ((arg1)->m_typeConstraintData);
  *(btTypedConstraintData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraintFloatData_1pivotInA_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btPoint2PointConstraintFloatData *arg1 = (btPoint2PointConstraintFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btPoint2PointConstraintFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_pivotInA = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraintFloatData_1pivotInA_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btPoint2PointConstraintFloatData *arg1 = (btPoint2PointConstraintFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraintFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_pivotInA);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraintFloatData_1pivotInB_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btPoint2PointConstraintFloatData *arg1 = (btPoint2PointConstraintFloatData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btPoint2PointConstraintFloatData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_pivotInB = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraintFloatData_1pivotInB_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btPoint2PointConstraintFloatData *arg1 = (btPoint2PointConstraintFloatData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraintFloatData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_pivotInB);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btPoint2PointConstraintFloatData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btPoint2PointConstraintFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btPoint2PointConstraintFloatData *)new btPoint2PointConstraintFloatData();
  *(btPoint2PointConstraintFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btPoint2PointConstraintFloatData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btPoint2PointConstraintFloatData *arg1 = (btPoint2PointConstraintFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btPoint2PointConstraintFloatData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraintDoubleData2_1typeConstraintData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btPoint2PointConstraintDoubleData2 *arg1 = (btPoint2PointConstraintDoubleData2 *) 0 ;
  btTypedConstraintDoubleData *arg2 = (btTypedConstraintDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btPoint2PointConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btTypedConstraintDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_typeConstraintData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraintDoubleData2_1typeConstraintData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btPoint2PointConstraintDoubleData2 *arg1 = (btPoint2PointConstraintDoubleData2 *) 0 ;
  btTypedConstraintDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraintDoubleData2 **)&jarg1; 
  result = (btTypedConstraintDoubleData *)& ((arg1)->m_typeConstraintData);
  *(btTypedConstraintDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraintDoubleData2_1pivotInA_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btPoint2PointConstraintDoubleData2 *arg1 = (btPoint2PointConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btPoint2PointConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_pivotInA = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraintDoubleData2_1pivotInA_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btPoint2PointConstraintDoubleData2 *arg1 = (btPoint2PointConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_pivotInA);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraintDoubleData2_1pivotInB_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btPoint2PointConstraintDoubleData2 *arg1 = (btPoint2PointConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btPoint2PointConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_pivotInB = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraintDoubleData2_1pivotInB_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btPoint2PointConstraintDoubleData2 *arg1 = (btPoint2PointConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_pivotInB);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btPoint2PointConstraintDoubleData2(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btPoint2PointConstraintDoubleData2 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btPoint2PointConstraintDoubleData2 *)new btPoint2PointConstraintDoubleData2();
  *(btPoint2PointConstraintDoubleData2 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btPoint2PointConstraintDoubleData2(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btPoint2PointConstraintDoubleData2 *arg1 = (btPoint2PointConstraintDoubleData2 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btPoint2PointConstraintDoubleData2 **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraintDoubleData_1typeConstraintData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btPoint2PointConstraintDoubleData *arg1 = (btPoint2PointConstraintDoubleData *) 0 ;
  btTypedConstraintData *arg2 = (btTypedConstraintData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btPoint2PointConstraintDoubleData **)&jarg1; 
  arg2 = *(btTypedConstraintData **)&jarg2; 
  if (arg1) (arg1)->m_typeConstraintData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraintDoubleData_1typeConstraintData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btPoint2PointConstraintDoubleData *arg1 = (btPoint2PointConstraintDoubleData *) 0 ;
  btTypedConstraintData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraintDoubleData **)&jarg1; 
  result = (btTypedConstraintData *)& ((arg1)->m_typeConstraintData);
  *(btTypedConstraintData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraintDoubleData_1pivotInA_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btPoint2PointConstraintDoubleData *arg1 = (btPoint2PointConstraintDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btPoint2PointConstraintDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_pivotInA = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraintDoubleData_1pivotInA_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btPoint2PointConstraintDoubleData *arg1 = (btPoint2PointConstraintDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraintDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_pivotInA);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraintDoubleData_1pivotInB_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btPoint2PointConstraintDoubleData *arg1 = (btPoint2PointConstraintDoubleData *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btPoint2PointConstraintDoubleData **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_pivotInB = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btPoint2PointConstraintDoubleData_1pivotInB_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btPoint2PointConstraintDoubleData *arg1 = (btPoint2PointConstraintDoubleData *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btPoint2PointConstraintDoubleData **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_pivotInB);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btPoint2PointConstraintDoubleData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btPoint2PointConstraintDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btPoint2PointConstraintDoubleData *)new btPoint2PointConstraintDoubleData();
  *(btPoint2PointConstraintDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btPoint2PointConstraintDoubleData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btPoint2PointConstraintDoubleData *arg1 = (btPoint2PointConstraintDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btPoint2PointConstraintDoubleData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btJacobianEntry_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btJacobianEntry *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btJacobianEntry *)new btJacobianEntry();
  *(btJacobianEntry **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btJacobianEntry_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jobject jarg4, jobject jarg5, jobject jarg6, jfloat jarg7, jobject jarg8, jfloat jarg9) {
  jlong jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  btScalar arg7 ;
  btVector3 *arg8 = 0 ;
  btScalar arg9 ;
  btJacobianEntry *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  arg7 = (btScalar)jarg7; 
  btVector3 local_arg8;
  gdx_setbtVector3FromVector3(jenv, local_arg8, jarg8);
  arg8 = &local_arg8;
  gdxAutoCommitVector3 auto_commit_arg8(jenv, jarg8, &local_arg8);
  arg9 = (btScalar)jarg9; 
  result = (btJacobianEntry *)new btJacobianEntry((btMatrix3x3 const &)*arg1,(btMatrix3x3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6,arg7,(btVector3 const &)*arg8,arg9);
  *(btJacobianEntry **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btJacobianEntry_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jobject jarg4, jobject jarg5) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btMatrix3x3 *arg2 = 0 ;
  btMatrix3x3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btJacobianEntry *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btMatrix3x3 local_arg2;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btMatrix3x3 local_arg3;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  result = (btJacobianEntry *)new btJacobianEntry((btVector3 const &)*arg1,(btMatrix3x3 const &)*arg2,(btMatrix3x3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5);
  *(btJacobianEntry **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btJacobianEntry_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jobject jarg4) {
  jlong jresult = 0 ;
  btVector3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btJacobianEntry *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btVector3 local_arg1;
  gdx_setbtVector3FromVector3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitVector3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  result = (btJacobianEntry *)new btJacobianEntry((btVector3 const &)*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4);
  *(btJacobianEntry **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btJacobianEntry_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3, jobject jarg4, jobject jarg5, jfloat jarg6) {
  jlong jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btScalar arg6 ;
  btJacobianEntry *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  arg6 = (btScalar)jarg6; 
  result = (btJacobianEntry *)new btJacobianEntry((btMatrix3x3 const &)*arg1,(btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5,arg6);
  *(btJacobianEntry **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJacobianEntry_1getDiagonal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btJacobianEntry *arg1 = (btJacobianEntry *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btJacobianEntry **)&jarg1; 
  result = (btScalar)((btJacobianEntry const *)arg1)->getDiagonal();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJacobianEntry_1getNonDiagonal_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3) {
  jfloat jresult = 0 ;
  btJacobianEntry *arg1 = (btJacobianEntry *) 0 ;
  btJacobianEntry *arg2 = 0 ;
  btScalar arg3 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btJacobianEntry **)&jarg1; 
  arg2 = *(btJacobianEntry **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btJacobianEntry const & reference is null");
    return 0;
  } 
  arg3 = (btScalar)jarg3; 
  result = (btScalar)((btJacobianEntry const *)arg1)->getNonDiagonal((btJacobianEntry const &)*arg2,arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJacobianEntry_1getNonDiagonal_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3, jfloat jarg4) {
  jfloat jresult = 0 ;
  btJacobianEntry *arg1 = (btJacobianEntry *) 0 ;
  btJacobianEntry *arg2 = 0 ;
  btScalar arg3 ;
  btScalar arg4 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btJacobianEntry **)&jarg1; 
  arg2 = *(btJacobianEntry **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btJacobianEntry const & reference is null");
    return 0;
  } 
  arg3 = (btScalar)jarg3; 
  arg4 = (btScalar)jarg4; 
  result = (btScalar)((btJacobianEntry const *)arg1)->getNonDiagonal((btJacobianEntry const &)*arg2,arg3,arg4);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJacobianEntry_1getRelativeVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jobject jarg5) {
  jfloat jresult = 0 ;
  btJacobianEntry *arg1 = (btJacobianEntry *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btJacobianEntry **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  result = (btScalar)(arg1)->getRelativeVelocity((btVector3 const &)*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJacobianEntry_1linearJointAxis_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btJacobianEntry *arg1 = (btJacobianEntry *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btJacobianEntry **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_linearJointAxis = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJacobianEntry_1linearJointAxis_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btJacobianEntry *arg1 = (btJacobianEntry *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btJacobianEntry **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_linearJointAxis);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJacobianEntry_1aJ_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btJacobianEntry *arg1 = (btJacobianEntry *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btJacobianEntry **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_aJ = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJacobianEntry_1aJ_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btJacobianEntry *arg1 = (btJacobianEntry *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btJacobianEntry **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_aJ);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJacobianEntry_1bJ_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btJacobianEntry *arg1 = (btJacobianEntry *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btJacobianEntry **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_bJ = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJacobianEntry_1bJ_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btJacobianEntry *arg1 = (btJacobianEntry *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btJacobianEntry **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_bJ);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJacobianEntry_10MinvJt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btJacobianEntry *arg1 = (btJacobianEntry *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btJacobianEntry **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_0MinvJt = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJacobianEntry_10MinvJt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btJacobianEntry *arg1 = (btJacobianEntry *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btJacobianEntry **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_0MinvJt);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJacobianEntry_11MinvJt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btJacobianEntry *arg1 = (btJacobianEntry *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btJacobianEntry **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_1MinvJt = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJacobianEntry_11MinvJt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btJacobianEntry *arg1 = (btJacobianEntry *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btJacobianEntry **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_1MinvJt);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJacobianEntry_1Adiag_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btJacobianEntry *arg1 = (btJacobianEntry *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btJacobianEntry **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_Adiag = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btJacobianEntry_1Adiag_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btJacobianEntry *arg1 = (btJacobianEntry *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btJacobianEntry **)&jarg1; 
  result = (btScalar) ((arg1)->m_Adiag);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btJacobianEntry(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btJacobianEntry *arg1 = (btJacobianEntry *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btJacobianEntry **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btSolve2LinearConstraint(JNIEnv *jenv, jclass jcls, jfloat jarg1, jfloat jarg2) {
  jlong jresult = 0 ;
  btScalar arg1 ;
  btScalar arg2 ;
  btSolve2LinearConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (btScalar)jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (btSolve2LinearConstraint *)new btSolve2LinearConstraint(arg1,arg2);
  *(btSolve2LinearConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolve2LinearConstraint_1resolveUnilateralPairConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jobject jarg4, jobject jarg5, jobject jarg6, jfloat jarg7, jobject jarg8, jobject jarg9, jobject jarg10, jobject jarg11, jfloat jarg12, jobject jarg13, jobject jarg14, jobject jarg15, jfloat jarg16, jobject jarg17, jobject jarg18, jobject jarg19, jfloat jarg20, jobject jarg21, jlong jarg22, jlong jarg23) {
  btSolve2LinearConstraint *arg1 = (btSolve2LinearConstraint *) 0 ;
  btRigidBody *arg2 = (btRigidBody *) 0 ;
  btRigidBody *arg3 = (btRigidBody *) 0 ;
  btMatrix3x3 *arg4 = 0 ;
  btMatrix3x3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  btScalar arg7 ;
  btVector3 *arg8 = 0 ;
  btVector3 *arg9 = 0 ;
  btVector3 *arg10 = 0 ;
  btVector3 *arg11 = 0 ;
  btScalar arg12 ;
  btVector3 *arg13 = 0 ;
  btVector3 *arg14 = 0 ;
  btVector3 *arg15 = 0 ;
  btScalar arg16 ;
  btVector3 *arg17 = 0 ;
  btVector3 *arg18 = 0 ;
  btVector3 *arg19 = 0 ;
  btScalar arg20 ;
  btVector3 *arg21 = 0 ;
  btScalar *arg22 = 0 ;
  btScalar *arg23 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btSolve2LinearConstraint **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2; 
  arg3 = *(btRigidBody **)&jarg3; 
  btMatrix3x3 local_arg4;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btMatrix3x3 local_arg5;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  arg7 = (btScalar)jarg7; 
  btVector3 local_arg8;
  gdx_setbtVector3FromVector3(jenv, local_arg8, jarg8);
  arg8 = &local_arg8;
  gdxAutoCommitVector3 auto_commit_arg8(jenv, jarg8, &local_arg8);
  btVector3 local_arg9;
  gdx_setbtVector3FromVector3(jenv, local_arg9, jarg9);
  arg9 = &local_arg9;
  gdxAutoCommitVector3 auto_commit_arg9(jenv, jarg9, &local_arg9);
  btVector3 local_arg10;
  gdx_setbtVector3FromVector3(jenv, local_arg10, jarg10);
  arg10 = &local_arg10;
  gdxAutoCommitVector3 auto_commit_arg10(jenv, jarg10, &local_arg10);
  btVector3 local_arg11;
  gdx_setbtVector3FromVector3(jenv, local_arg11, jarg11);
  arg11 = &local_arg11;
  gdxAutoCommitVector3 auto_commit_arg11(jenv, jarg11, &local_arg11);
  arg12 = (btScalar)jarg12; 
  btVector3 local_arg13;
  gdx_setbtVector3FromVector3(jenv, local_arg13, jarg13);
  arg13 = &local_arg13;
  gdxAutoCommitVector3 auto_commit_arg13(jenv, jarg13, &local_arg13);
  btVector3 local_arg14;
  gdx_setbtVector3FromVector3(jenv, local_arg14, jarg14);
  arg14 = &local_arg14;
  gdxAutoCommitVector3 auto_commit_arg14(jenv, jarg14, &local_arg14);
  btVector3 local_arg15;
  gdx_setbtVector3FromVector3(jenv, local_arg15, jarg15);
  arg15 = &local_arg15;
  gdxAutoCommitVector3 auto_commit_arg15(jenv, jarg15, &local_arg15);
  arg16 = (btScalar)jarg16; 
  btVector3 local_arg17;
  gdx_setbtVector3FromVector3(jenv, local_arg17, jarg17);
  arg17 = &local_arg17;
  gdxAutoCommitVector3 auto_commit_arg17(jenv, jarg17, &local_arg17);
  btVector3 local_arg18;
  gdx_setbtVector3FromVector3(jenv, local_arg18, jarg18);
  arg18 = &local_arg18;
  gdxAutoCommitVector3 auto_commit_arg18(jenv, jarg18, &local_arg18);
  btVector3 local_arg19;
  gdx_setbtVector3FromVector3(jenv, local_arg19, jarg19);
  arg19 = &local_arg19;
  gdxAutoCommitVector3 auto_commit_arg19(jenv, jarg19, &local_arg19);
  arg20 = (btScalar)jarg20; 
  btVector3 local_arg21;
  gdx_setbtVector3FromVector3(jenv, local_arg21, jarg21);
  arg21 = &local_arg21;
  gdxAutoCommitVector3 auto_commit_arg21(jenv, jarg21, &local_arg21);
  arg22 = *(btScalar **)&jarg22;
  if (!arg22) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  arg23 = *(btScalar **)&jarg23;
  if (!arg23) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  (arg1)->resolveUnilateralPairConstraint(arg2,arg3,(btMatrix3x3 const &)*arg4,(btMatrix3x3 const &)*arg5,(btVector3 const &)*arg6,arg7,(btVector3 const &)*arg8,(btVector3 const &)*arg9,(btVector3 const &)*arg10,(btVector3 const &)*arg11,arg12,(btVector3 const &)*arg13,(btVector3 const &)*arg14,(btVector3 const &)*arg15,arg16,(btVector3 const &)*arg17,(btVector3 const &)*arg18,(btVector3 const &)*arg19,arg20,(btVector3 const &)*arg21,*arg22,*arg23);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btSolve2LinearConstraint_1resolveBilateralPairConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jobject jarg4, jobject jarg5, jobject jarg6, jfloat jarg7, jobject jarg8, jobject jarg9, jobject jarg10, jobject jarg11, jfloat jarg12, jobject jarg13, jobject jarg14, jobject jarg15, jfloat jarg16, jobject jarg17, jobject jarg18, jobject jarg19, jfloat jarg20, jobject jarg21, jlong jarg22, jlong jarg23) {
  btSolve2LinearConstraint *arg1 = (btSolve2LinearConstraint *) 0 ;
  btRigidBody *arg2 = (btRigidBody *) 0 ;
  btRigidBody *arg3 = (btRigidBody *) 0 ;
  btMatrix3x3 *arg4 = 0 ;
  btMatrix3x3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  btScalar arg7 ;
  btVector3 *arg8 = 0 ;
  btVector3 *arg9 = 0 ;
  btVector3 *arg10 = 0 ;
  btVector3 *arg11 = 0 ;
  btScalar arg12 ;
  btVector3 *arg13 = 0 ;
  btVector3 *arg14 = 0 ;
  btVector3 *arg15 = 0 ;
  btScalar arg16 ;
  btVector3 *arg17 = 0 ;
  btVector3 *arg18 = 0 ;
  btVector3 *arg19 = 0 ;
  btScalar arg20 ;
  btVector3 *arg21 = 0 ;
  btScalar *arg22 = 0 ;
  btScalar *arg23 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(btSolve2LinearConstraint **)&jarg1; 
  arg2 = *(btRigidBody **)&jarg2; 
  arg3 = *(btRigidBody **)&jarg3; 
  btMatrix3x3 local_arg4;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btMatrix3x3 local_arg5;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  arg7 = (btScalar)jarg7; 
  btVector3 local_arg8;
  gdx_setbtVector3FromVector3(jenv, local_arg8, jarg8);
  arg8 = &local_arg8;
  gdxAutoCommitVector3 auto_commit_arg8(jenv, jarg8, &local_arg8);
  btVector3 local_arg9;
  gdx_setbtVector3FromVector3(jenv, local_arg9, jarg9);
  arg9 = &local_arg9;
  gdxAutoCommitVector3 auto_commit_arg9(jenv, jarg9, &local_arg9);
  btVector3 local_arg10;
  gdx_setbtVector3FromVector3(jenv, local_arg10, jarg10);
  arg10 = &local_arg10;
  gdxAutoCommitVector3 auto_commit_arg10(jenv, jarg10, &local_arg10);
  btVector3 local_arg11;
  gdx_setbtVector3FromVector3(jenv, local_arg11, jarg11);
  arg11 = &local_arg11;
  gdxAutoCommitVector3 auto_commit_arg11(jenv, jarg11, &local_arg11);
  arg12 = (btScalar)jarg12; 
  btVector3 local_arg13;
  gdx_setbtVector3FromVector3(jenv, local_arg13, jarg13);
  arg13 = &local_arg13;
  gdxAutoCommitVector3 auto_commit_arg13(jenv, jarg13, &local_arg13);
  btVector3 local_arg14;
  gdx_setbtVector3FromVector3(jenv, local_arg14, jarg14);
  arg14 = &local_arg14;
  gdxAutoCommitVector3 auto_commit_arg14(jenv, jarg14, &local_arg14);
  btVector3 local_arg15;
  gdx_setbtVector3FromVector3(jenv, local_arg15, jarg15);
  arg15 = &local_arg15;
  gdxAutoCommitVector3 auto_commit_arg15(jenv, jarg15, &local_arg15);
  arg16 = (btScalar)jarg16; 
  btVector3 local_arg17;
  gdx_setbtVector3FromVector3(jenv, local_arg17, jarg17);
  arg17 = &local_arg17;
  gdxAutoCommitVector3 auto_commit_arg17(jenv, jarg17, &local_arg17);
  btVector3 local_arg18;
  gdx_setbtVector3FromVector3(jenv, local_arg18, jarg18);
  arg18 = &local_arg18;
  gdxAutoCommitVector3 auto_commit_arg18(jenv, jarg18, &local_arg18);
  btVector3 local_arg19;
  gdx_setbtVector3FromVector3(jenv, local_arg19, jarg19);
  arg19 = &local_arg19;
  gdxAutoCommitVector3 auto_commit_arg19(jenv, jarg19, &local_arg19);
  arg20 = (btScalar)jarg20; 
  btVector3 local_arg21;
  gdx_setbtVector3FromVector3(jenv, local_arg21, jarg21);
  arg21 = &local_arg21;
  gdxAutoCommitVector3 auto_commit_arg21(jenv, jarg21, &local_arg21);
  arg22 = *(btScalar **)&jarg22;
  if (!arg22) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  arg23 = *(btScalar **)&jarg23;
  if (!arg23) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  (arg1)->resolveBilateralPairConstraint(arg2,arg3,(btMatrix3x3 const &)*arg4,(btMatrix3x3 const &)*arg5,(btVector3 const &)*arg6,arg7,(btVector3 const &)*arg8,(btVector3 const &)*arg9,(btVector3 const &)*arg10,(btVector3 const &)*arg11,arg12,(btVector3 const &)*arg13,(btVector3 const &)*arg14,(btVector3 const &)*arg15,arg16,(btVector3 const &)*arg17,(btVector3 const &)*arg18,(btVector3 const &)*arg19,arg20,(btVector3 const &)*arg21,*arg22,*arg23);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btSolve2LinearConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btSolve2LinearConstraint *arg1 = (btSolve2LinearConstraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btSolve2LinearConstraint **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1loLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_loLimit = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1loLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  result = (btScalar) ((arg1)->m_loLimit);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1hiLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_hiLimit = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1hiLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  result = (btScalar) ((arg1)->m_hiLimit);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1targetVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_targetVelocity = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1targetVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  result = (btScalar) ((arg1)->m_targetVelocity);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1maxMotorForce_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_maxMotorForce = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1maxMotorForce_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  result = (btScalar) ((arg1)->m_maxMotorForce);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1maxLimitForce_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_maxLimitForce = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1maxLimitForce_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  result = (btScalar) ((arg1)->m_maxLimitForce);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1damping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_damping = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1damping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  result = (btScalar) ((arg1)->m_damping);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1limitSoftness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_limitSoftness = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1limitSoftness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  result = (btScalar) ((arg1)->m_limitSoftness);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1normalCFM_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_normalCFM = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1normalCFM_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  result = (btScalar) ((arg1)->m_normalCFM);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1stopERP_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_stopERP = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1stopERP_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  result = (btScalar) ((arg1)->m_stopERP);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1stopCFM_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_stopCFM = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1stopCFM_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  result = (btScalar) ((arg1)->m_stopCFM);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1bounce_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_bounce = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1bounce_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  result = (btScalar) ((arg1)->m_bounce);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1enableMotor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_enableMotor = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1enableMotor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  result = (bool) ((arg1)->m_enableMotor);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1currentLimitError_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_currentLimitError = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1currentLimitError_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  result = (btScalar) ((arg1)->m_currentLimitError);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1currentPosition_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_currentPosition = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1currentPosition_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  result = (btScalar) ((arg1)->m_currentPosition);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1currentLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_currentLimit = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1currentLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  result = (int) ((arg1)->m_currentLimit);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1accumulatedImpulse_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_accumulatedImpulse = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1accumulatedImpulse_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  result = (btScalar) ((arg1)->m_accumulatedImpulse);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btRotationalLimitMotor_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btRotationalLimitMotor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btRotationalLimitMotor *)new btRotationalLimitMotor();
  *(btRotationalLimitMotor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btRotationalLimitMotor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRotationalLimitMotor *arg1 = 0 ;
  btRotationalLimitMotor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRotationalLimitMotor const & reference is null");
    return 0;
  } 
  result = (btRotationalLimitMotor *)new btRotationalLimitMotor((btRotationalLimitMotor const &)*arg1);
  *(btRotationalLimitMotor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1isLimited(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  result = (bool)((btRotationalLimitMotor const *)arg1)->isLimited();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1needApplyTorques(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  result = (bool)((btRotationalLimitMotor const *)arg1)->needApplyTorques();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1testLimitValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  jint jresult = 0 ;
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  result = (int)(arg1)->testLimitValue(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor_1solveAngularLimits(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jobject jarg3, jfloat jarg4, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  btScalar arg2 ;
  btVector3 *arg3 = 0 ;
  btScalar arg4 ;
  btRigidBody *arg5 = (btRigidBody *) 0 ;
  btRigidBody *arg6 = (btRigidBody *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  (void)jarg6_;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  arg4 = (btScalar)jarg4; 
  arg5 = *(btRigidBody **)&jarg5; 
  arg6 = *(btRigidBody **)&jarg6; 
  result = (btScalar)(arg1)->solveAngularLimits(arg2,*arg3,arg4,arg5,arg6);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btRotationalLimitMotor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btRotationalLimitMotor *arg1 = (btRotationalLimitMotor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btRotationalLimitMotor **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1lowerLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_lowerLimit = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1lowerLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_lowerLimit);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1upperLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_upperLimit = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1upperLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_upperLimit);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1accumulatedImpulse_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_accumulatedImpulse = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1accumulatedImpulse_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_accumulatedImpulse);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1limitSoftness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_limitSoftness = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1limitSoftness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  result = (btScalar) ((arg1)->m_limitSoftness);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1damping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_damping = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1damping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  result = (btScalar) ((arg1)->m_damping);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1restitution_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_restitution = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1restitution_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  result = (btScalar) ((arg1)->m_restitution);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1normalCFM_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_normalCFM = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1normalCFM_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_normalCFM);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1stopERP_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_stopERP = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1stopERP_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_stopERP);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1stopCFM_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_stopCFM = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1stopCFM_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_stopCFM);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1enableMotor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbooleanArray jarg2) {
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  bool *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  arg2 = (bool *)jenv->GetPrimitiveArrayCritical(jarg2, 0); 
  {
    size_t ii;
    bool *b = (bool *) arg1->m_enableMotor;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((bool *) arg2 + ii);
  }
  jenv->ReleasePrimitiveArrayCritical(jarg2, (bool *)arg2, 0); 
}


SWIGEXPORT jbooleanArray JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1enableMotor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jbooleanArray jresult = 0 ;
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  bool *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  result = (bool *)(bool *) ((arg1)->m_enableMotor);
  /*jresult = SWIG_JavaArrayOut##Bool(jenv, (bool *)result, 3);*/ 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1targetVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_targetVelocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1targetVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_targetVelocity);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1maxMotorForce_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_maxMotorForce = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1maxMotorForce_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_maxMotorForce);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1currentLimitError_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_currentLimitError = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1currentLimitError_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_currentLimitError);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1currentLinearDiff_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_currentLinearDiff = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1currentLinearDiff_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_currentLinearDiff);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1currentLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  int *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  arg2 = (int *)jenv->GetPrimitiveArrayCritical(jarg2, 0); 
  {
    size_t ii;
    int *b = (int *) arg1->m_currentLimit;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((int *) arg2 + ii);
  }
  jenv->ReleasePrimitiveArrayCritical(jarg2, (int *)arg2, 0); 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1currentLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  result = (int *)(int *) ((arg1)->m_currentLimit);
  /*jresult = SWIG_JavaArrayOut##Int(jenv, (int *)result, 3);*/ 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btTranslationalLimitMotor_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTranslationalLimitMotor *)new btTranslationalLimitMotor();
  *(btTranslationalLimitMotor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btTranslationalLimitMotor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor *arg1 = 0 ;
  btTranslationalLimitMotor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTranslationalLimitMotor const & reference is null");
    return 0;
  } 
  result = (btTranslationalLimitMotor *)new btTranslationalLimitMotor((btTranslationalLimitMotor const &)*arg1);
  *(btTranslationalLimitMotor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1isLimited(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)((btTranslationalLimitMotor const *)arg1)->isLimited(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1needApplyForce(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)((btTranslationalLimitMotor const *)arg1)->needApplyForce(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1testLimitValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  jint jresult = 0 ;
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  result = (int)(arg1)->testLimitValue(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor_1solveLinearAxis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jlong jarg4, jobject jarg4_, jobject jarg5, jlong jarg6, jobject jarg6_, jobject jarg7, jint jarg8, jobject jarg9, jobject jarg10) {
  jfloat jresult = 0 ;
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btRigidBody *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btRigidBody *arg6 = 0 ;
  btVector3 *arg7 = 0 ;
  int arg8 ;
  btVector3 *arg9 = 0 ;
  btVector3 *arg10 = 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  (void)jarg6_;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = *(btRigidBody **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  arg6 = *(btRigidBody **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btVector3 local_arg7;
  gdx_setbtVector3FromVector3(jenv, local_arg7, jarg7);
  arg7 = &local_arg7;
  gdxAutoCommitVector3 auto_commit_arg7(jenv, jarg7, &local_arg7);
  arg8 = (int)jarg8; 
  btVector3 local_arg9;
  gdx_setbtVector3FromVector3(jenv, local_arg9, jarg9);
  arg9 = &local_arg9;
  gdxAutoCommitVector3 auto_commit_arg9(jenv, jarg9, &local_arg9);
  btVector3 local_arg10;
  gdx_setbtVector3FromVector3(jenv, local_arg10, jarg10);
  arg10 = &local_arg10;
  gdxAutoCommitVector3 auto_commit_arg10(jenv, jarg10, &local_arg10);
  result = (btScalar)(arg1)->solveLinearAxis(arg2,arg3,*arg4,(btVector3 const &)*arg5,*arg6,(btVector3 const &)*arg7,arg8,(btVector3 const &)*arg9,(btVector3 const &)*arg10);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btTranslationalLimitMotor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTranslationalLimitMotor *arg1 = (btTranslationalLimitMotor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTranslationalLimitMotor **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1operatorNew_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1operatorDelete_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1operatorNew_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1operatorDelete_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1operatorNewArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new[](arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1operatorDeleteArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete[](arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1operatorNewArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new[](arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1operatorDeleteArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete[](arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1useSolveConstraintObsolete_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_useSolveConstraintObsolete = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1useSolveConstraintObsolete_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  result = (bool) ((arg1)->m_useSolveConstraintObsolete);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btGeneric6DofConstraint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jboolean jarg5) {
  jlong jresult = 0 ;
  btRigidBody *arg1 = 0 ;
  btRigidBody *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  bool arg5 ;
  btGeneric6DofConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBody **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = jarg5 ? true : false; 
  result = (btGeneric6DofConstraint *)new btGeneric6DofConstraint(*arg1,*arg2,(btTransform const &)*arg3,(btTransform const &)*arg4,arg5);
  *(btGeneric6DofConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btGeneric6DofConstraint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  btRigidBody *arg1 = 0 ;
  btTransform *arg2 = 0 ;
  bool arg3 ;
  btGeneric6DofConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = jarg3 ? true : false; 
  result = (btGeneric6DofConstraint *)new btGeneric6DofConstraint(*arg1,(btTransform const &)*arg2,arg3);
  *(btGeneric6DofConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1calculateTransforms_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btTransform *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->calculateTransforms((btTransform const &)*arg2,(btTransform const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1calculateTransforms_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  (arg1)->calculateTransforms();
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1getCalculatedTransformA(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  result = (btTransform *) &((btGeneric6DofConstraint const *)arg1)->getCalculatedTransformA();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1getCalculatedTransformB(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  result = (btTransform *) &((btGeneric6DofConstraint const *)arg1)->getCalculatedTransformB();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1getFrameOffsetAConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  result = (btTransform *) &((btGeneric6DofConstraint const *)arg1)->getFrameOffsetA();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1getFrameOffsetBConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  result = (btTransform *) &((btGeneric6DofConstraint const *)arg1)->getFrameOffsetB();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1getFrameOffsetA(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  result = (btTransform *) &(arg1)->getFrameOffsetA();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1getFrameOffsetB(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  result = (btTransform *) &(arg1)->getFrameOffsetB();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1getInfo1NonVirtual(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btTypedConstraint::btConstraintInfo1 *arg2 = (btTypedConstraint::btConstraintInfo1 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = *(btTypedConstraint::btConstraintInfo1 **)&jarg2; 
  (arg1)->getInfo1NonVirtual(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1getInfo2NonVirtual(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jobject jarg5, jobject jarg6, jobject jarg7, jobject jarg8) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btTypedConstraint::btConstraintInfo2 *arg2 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btTransform *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  btVector3 *arg7 = 0 ;
  btVector3 *arg8 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = *(btTypedConstraint::btConstraintInfo2 **)&jarg2; 
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  btVector3 local_arg7;
  gdx_setbtVector3FromVector3(jenv, local_arg7, jarg7);
  arg7 = &local_arg7;
  gdxAutoCommitVector3 auto_commit_arg7(jenv, jarg7, &local_arg7);
  btVector3 local_arg8;
  gdx_setbtVector3FromVector3(jenv, local_arg8, jarg8);
  arg8 = &local_arg8;
  gdxAutoCommitVector3 auto_commit_arg8(jenv, jarg8, &local_arg8);
  (arg1)->getInfo2NonVirtual(arg2,(btTransform const &)*arg3,(btTransform const &)*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6,(btVector3 const &)*arg7,(btVector3 const &)*arg8);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1updateRHS(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->updateRHS(arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1getAxis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  int arg2 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  result = ((btGeneric6DofConstraint const *)arg1)->getAxis(arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1getAngle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jfloat jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  int arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btScalar)((btGeneric6DofConstraint const *)arg1)->getAngle(arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1getRelativePivotPosition(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jfloat jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  int arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btScalar)((btGeneric6DofConstraint const *)arg1)->getRelativePivotPosition(arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1setFrames(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btTransform *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->setFrames((btTransform const &)*arg2,(btTransform const &)*arg3);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1testAngularLimitMotor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)(arg1)->testAngularLimitMotor(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1setLinearLowerLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setLinearLowerLimit((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1getLinearLowerLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  ((btGeneric6DofConstraint const *)arg1)->getLinearLowerLimit(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1setLinearUpperLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setLinearUpperLimit((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1getLinearUpperLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  ((btGeneric6DofConstraint const *)arg1)->getLinearUpperLimit(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1setAngularLowerLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setAngularLowerLimit((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1getAngularLowerLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  ((btGeneric6DofConstraint const *)arg1)->getAngularLowerLimit(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1setAngularUpperLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setAngularUpperLimit((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1getAngularUpperLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  ((btGeneric6DofConstraint const *)arg1)->getAngularUpperLimit(*arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1getRotationalLimitMotor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  int arg2 ;
  btRotationalLimitMotor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btRotationalLimitMotor *)(arg1)->getRotationalLimitMotor(arg2);
  *(btRotationalLimitMotor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1getTranslationalLimitMotor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btTranslationalLimitMotor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  result = (btTranslationalLimitMotor *)(arg1)->getTranslationalLimitMotor();
  *(btTranslationalLimitMotor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1setLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3, jfloat jarg4) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  btScalar arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (btScalar)jarg4; 
  (arg1)->setLimit(arg2,arg3,arg4);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1isLimited(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)((btGeneric6DofConstraint const *)arg1)->isLimited(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1calcAnchorPos(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  (arg1)->calcAnchorPos();
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1get_1limit_1motor_1info2_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jobject jarg5, jobject jarg6, jobject jarg7, jobject jarg8, jlong jarg9, jobject jarg9_, jint jarg10, jobject jarg11, jint jarg12, jint jarg13) {
  jint jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btRotationalLimitMotor *arg2 = (btRotationalLimitMotor *) 0 ;
  btTransform *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  btVector3 *arg7 = 0 ;
  btVector3 *arg8 = 0 ;
  btTypedConstraint::btConstraintInfo2 *arg9 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  int arg10 ;
  btVector3 *arg11 = 0 ;
  int arg12 ;
  int arg13 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg9_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = *(btRotationalLimitMotor **)&jarg2; 
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  btVector3 local_arg7;
  gdx_setbtVector3FromVector3(jenv, local_arg7, jarg7);
  arg7 = &local_arg7;
  gdxAutoCommitVector3 auto_commit_arg7(jenv, jarg7, &local_arg7);
  btVector3 local_arg8;
  gdx_setbtVector3FromVector3(jenv, local_arg8, jarg8);
  arg8 = &local_arg8;
  gdxAutoCommitVector3 auto_commit_arg8(jenv, jarg8, &local_arg8);
  arg9 = *(btTypedConstraint::btConstraintInfo2 **)&jarg9; 
  arg10 = (int)jarg10; 
  btVector3 local_arg11;
  gdx_setbtVector3FromVector3(jenv, local_arg11, jarg11);
  arg11 = &local_arg11;
  gdxAutoCommitVector3 auto_commit_arg11(jenv, jarg11, &local_arg11);
  arg12 = (int)jarg12; 
  arg13 = (int)jarg13; 
  result = (int)(arg1)->get_limit_motor_info2(arg2,(btTransform const &)*arg3,(btTransform const &)*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6,(btVector3 const &)*arg7,(btVector3 const &)*arg8,arg9,arg10,*arg11,arg12,arg13);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1get_1limit_1motor_1info2_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jobject jarg5, jobject jarg6, jobject jarg7, jobject jarg8, jlong jarg9, jobject jarg9_, jint jarg10, jobject jarg11, jint jarg12) {
  jint jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btRotationalLimitMotor *arg2 = (btRotationalLimitMotor *) 0 ;
  btTransform *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btVector3 *arg6 = 0 ;
  btVector3 *arg7 = 0 ;
  btVector3 *arg8 = 0 ;
  btTypedConstraint::btConstraintInfo2 *arg9 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  int arg10 ;
  btVector3 *arg11 = 0 ;
  int arg12 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg9_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = *(btRotationalLimitMotor **)&jarg2; 
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  btVector3 local_arg7;
  gdx_setbtVector3FromVector3(jenv, local_arg7, jarg7);
  arg7 = &local_arg7;
  gdxAutoCommitVector3 auto_commit_arg7(jenv, jarg7, &local_arg7);
  btVector3 local_arg8;
  gdx_setbtVector3FromVector3(jenv, local_arg8, jarg8);
  arg8 = &local_arg8;
  gdxAutoCommitVector3 auto_commit_arg8(jenv, jarg8, &local_arg8);
  arg9 = *(btTypedConstraint::btConstraintInfo2 **)&jarg9; 
  arg10 = (int)jarg10; 
  btVector3 local_arg11;
  gdx_setbtVector3FromVector3(jenv, local_arg11, jarg11);
  arg11 = &local_arg11;
  gdxAutoCommitVector3 auto_commit_arg11(jenv, jarg11, &local_arg11);
  arg12 = (int)jarg12; 
  result = (int)(arg1)->get_limit_motor_info2(arg2,(btTransform const &)*arg3,(btTransform const &)*arg4,(btVector3 const &)*arg5,(btVector3 const &)*arg6,(btVector3 const &)*arg7,(btVector3 const &)*arg8,arg9,arg10,*arg11,arg12);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1getUseFrameOffset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  result = (bool)((btGeneric6DofConstraint const *)arg1)->getUseFrameOffset();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1setUseFrameOffset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->setUseFrameOffset(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1getUseLinearReferenceFrameA(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  result = (bool)((btGeneric6DofConstraint const *)arg1)->getUseLinearReferenceFrameA();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1setUseLinearReferenceFrameA(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->setUseLinearReferenceFrameA(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1setParam_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3, jint jarg4) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->setParam(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1setParam_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setParam(arg2,arg3);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1getParam_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jfloat jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  int arg2 ;
  int arg3 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (btScalar)((btGeneric6DofConstraint const *)arg1)->getParam(arg2,arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1getParam_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jfloat jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  int arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btScalar)((btGeneric6DofConstraint const *)arg1)->getParam(arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1setAxis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->setAxis((btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraint_1getFlags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  result = (int)((btGeneric6DofConstraint const *)arg1)->getFlags();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btGeneric6DofConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btGeneric6DofConstraint *arg1 = (btGeneric6DofConstraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btGeneric6DofConstraint **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintData_1typeConstraintData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofConstraintData *arg1 = (btGeneric6DofConstraintData *) 0 ;
  btTypedConstraintData *arg2 = (btTypedConstraintData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofConstraintData **)&jarg1; 
  arg2 = *(btTypedConstraintData **)&jarg2; 
  if (arg1) (arg1)->m_typeConstraintData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintData_1typeConstraintData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofConstraintData *arg1 = (btGeneric6DofConstraintData *) 0 ;
  btTypedConstraintData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraintData **)&jarg1; 
  result = (btTypedConstraintData *)& ((arg1)->m_typeConstraintData);
  *(btTypedConstraintData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintData_1rbAFrame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofConstraintData *arg1 = (btGeneric6DofConstraintData *) 0 ;
  btTransformFloatData *arg2 = (btTransformFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofConstraintData **)&jarg1; 
  arg2 = *(btTransformFloatData **)&jarg2; 
  if (arg1) (arg1)->m_rbAFrame = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintData_1rbAFrame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofConstraintData *arg1 = (btGeneric6DofConstraintData *) 0 ;
  btTransformFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraintData **)&jarg1; 
  result = (btTransformFloatData *)& ((arg1)->m_rbAFrame);
  *(btTransformFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintData_1rbBFrame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofConstraintData *arg1 = (btGeneric6DofConstraintData *) 0 ;
  btTransformFloatData *arg2 = (btTransformFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofConstraintData **)&jarg1; 
  arg2 = *(btTransformFloatData **)&jarg2; 
  if (arg1) (arg1)->m_rbBFrame = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintData_1rbBFrame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofConstraintData *arg1 = (btGeneric6DofConstraintData *) 0 ;
  btTransformFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraintData **)&jarg1; 
  result = (btTransformFloatData *)& ((arg1)->m_rbBFrame);
  *(btTransformFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintData_1linearUpperLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofConstraintData *arg1 = (btGeneric6DofConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_linearUpperLimit = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintData_1linearUpperLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofConstraintData *arg1 = (btGeneric6DofConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_linearUpperLimit);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintData_1linearLowerLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofConstraintData *arg1 = (btGeneric6DofConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_linearLowerLimit = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintData_1linearLowerLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofConstraintData *arg1 = (btGeneric6DofConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_linearLowerLimit);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintData_1angularUpperLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofConstraintData *arg1 = (btGeneric6DofConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_angularUpperLimit = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintData_1angularUpperLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofConstraintData *arg1 = (btGeneric6DofConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_angularUpperLimit);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintData_1angularLowerLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofConstraintData *arg1 = (btGeneric6DofConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_angularLowerLimit = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintData_1angularLowerLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofConstraintData *arg1 = (btGeneric6DofConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_angularLowerLimit);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintData_1useLinearReferenceFrameA_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btGeneric6DofConstraintData *arg1 = (btGeneric6DofConstraintData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraintData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_useLinearReferenceFrameA = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintData_1useLinearReferenceFrameA_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btGeneric6DofConstraintData *arg1 = (btGeneric6DofConstraintData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraintData **)&jarg1; 
  result = (int) ((arg1)->m_useLinearReferenceFrameA);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintData_1useOffsetForConstraintFrame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btGeneric6DofConstraintData *arg1 = (btGeneric6DofConstraintData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraintData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_useOffsetForConstraintFrame = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintData_1useOffsetForConstraintFrame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btGeneric6DofConstraintData *arg1 = (btGeneric6DofConstraintData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraintData **)&jarg1; 
  result = (int) ((arg1)->m_useOffsetForConstraintFrame);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btGeneric6DofConstraintData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btGeneric6DofConstraintData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btGeneric6DofConstraintData *)new btGeneric6DofConstraintData();
  *(btGeneric6DofConstraintData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btGeneric6DofConstraintData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btGeneric6DofConstraintData *arg1 = (btGeneric6DofConstraintData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btGeneric6DofConstraintData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintDoubleData2_1typeConstraintData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofConstraintDoubleData2 *arg1 = (btGeneric6DofConstraintDoubleData2 *) 0 ;
  btTypedConstraintDoubleData *arg2 = (btTypedConstraintDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btTypedConstraintDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_typeConstraintData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintDoubleData2_1typeConstraintData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofConstraintDoubleData2 *arg1 = (btGeneric6DofConstraintDoubleData2 *) 0 ;
  btTypedConstraintDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraintDoubleData2 **)&jarg1; 
  result = (btTypedConstraintDoubleData *)& ((arg1)->m_typeConstraintData);
  *(btTypedConstraintDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintDoubleData2_1rbAFrame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofConstraintDoubleData2 *arg1 = (btGeneric6DofConstraintDoubleData2 *) 0 ;
  btTransformDoubleData *arg2 = (btTransformDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btTransformDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_rbAFrame = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintDoubleData2_1rbAFrame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofConstraintDoubleData2 *arg1 = (btGeneric6DofConstraintDoubleData2 *) 0 ;
  btTransformDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraintDoubleData2 **)&jarg1; 
  result = (btTransformDoubleData *)& ((arg1)->m_rbAFrame);
  *(btTransformDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintDoubleData2_1rbBFrame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofConstraintDoubleData2 *arg1 = (btGeneric6DofConstraintDoubleData2 *) 0 ;
  btTransformDoubleData *arg2 = (btTransformDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btTransformDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_rbBFrame = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintDoubleData2_1rbBFrame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofConstraintDoubleData2 *arg1 = (btGeneric6DofConstraintDoubleData2 *) 0 ;
  btTransformDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraintDoubleData2 **)&jarg1; 
  result = (btTransformDoubleData *)& ((arg1)->m_rbBFrame);
  *(btTransformDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintDoubleData2_1linearUpperLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofConstraintDoubleData2 *arg1 = (btGeneric6DofConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_linearUpperLimit = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintDoubleData2_1linearUpperLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofConstraintDoubleData2 *arg1 = (btGeneric6DofConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_linearUpperLimit);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintDoubleData2_1linearLowerLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofConstraintDoubleData2 *arg1 = (btGeneric6DofConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_linearLowerLimit = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintDoubleData2_1linearLowerLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofConstraintDoubleData2 *arg1 = (btGeneric6DofConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_linearLowerLimit);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintDoubleData2_1angularUpperLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofConstraintDoubleData2 *arg1 = (btGeneric6DofConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_angularUpperLimit = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintDoubleData2_1angularUpperLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofConstraintDoubleData2 *arg1 = (btGeneric6DofConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_angularUpperLimit);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintDoubleData2_1angularLowerLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofConstraintDoubleData2 *arg1 = (btGeneric6DofConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_angularLowerLimit = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintDoubleData2_1angularLowerLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofConstraintDoubleData2 *arg1 = (btGeneric6DofConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_angularLowerLimit);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintDoubleData2_1useLinearReferenceFrameA_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btGeneric6DofConstraintDoubleData2 *arg1 = (btGeneric6DofConstraintDoubleData2 *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraintDoubleData2 **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_useLinearReferenceFrameA = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintDoubleData2_1useLinearReferenceFrameA_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btGeneric6DofConstraintDoubleData2 *arg1 = (btGeneric6DofConstraintDoubleData2 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraintDoubleData2 **)&jarg1; 
  result = (int) ((arg1)->m_useLinearReferenceFrameA);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintDoubleData2_1useOffsetForConstraintFrame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btGeneric6DofConstraintDoubleData2 *arg1 = (btGeneric6DofConstraintDoubleData2 *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraintDoubleData2 **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_useOffsetForConstraintFrame = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofConstraintDoubleData2_1useOffsetForConstraintFrame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btGeneric6DofConstraintDoubleData2 *arg1 = (btGeneric6DofConstraintDoubleData2 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofConstraintDoubleData2 **)&jarg1; 
  result = (int) ((arg1)->m_useOffsetForConstraintFrame);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btGeneric6DofConstraintDoubleData2(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btGeneric6DofConstraintDoubleData2 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btGeneric6DofConstraintDoubleData2 *)new btGeneric6DofConstraintDoubleData2();
  *(btGeneric6DofConstraintDoubleData2 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btGeneric6DofConstraintDoubleData2(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btGeneric6DofConstraintDoubleData2 *arg1 = (btGeneric6DofConstraintDoubleData2 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btGeneric6DofConstraintDoubleData2 **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btUniversalConstraint_1operatorNew_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btUniversalConstraint *arg1 = (btUniversalConstraint *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btUniversalConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btUniversalConstraint_1operatorDelete_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btUniversalConstraint *arg1 = (btUniversalConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btUniversalConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btUniversalConstraint_1operatorNew_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btUniversalConstraint *arg1 = (btUniversalConstraint *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btUniversalConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btUniversalConstraint_1operatorDelete_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btUniversalConstraint *arg1 = (btUniversalConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btUniversalConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btUniversalConstraint_1operatorNewArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btUniversalConstraint *arg1 = (btUniversalConstraint *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btUniversalConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new[](arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btUniversalConstraint_1operatorDeleteArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btUniversalConstraint *arg1 = (btUniversalConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btUniversalConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete[](arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btUniversalConstraint_1operatorNewArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btUniversalConstraint *arg1 = (btUniversalConstraint *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btUniversalConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new[](arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btUniversalConstraint_1operatorDeleteArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btUniversalConstraint *arg1 = (btUniversalConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btUniversalConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete[](arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btUniversalConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jobject jarg5) {
  jlong jresult = 0 ;
  btRigidBody *arg1 = 0 ;
  btRigidBody *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btVector3 *arg5 = 0 ;
  btUniversalConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBody **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btVector3 local_arg5;
  gdx_setbtVector3FromVector3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitVector3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  result = (btUniversalConstraint *)new btUniversalConstraint(*arg1,*arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btVector3 const &)*arg5);
  *(btUniversalConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btUniversalConstraint_1getAnchor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btUniversalConstraint *arg1 = (btUniversalConstraint *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btUniversalConstraint **)&jarg1; 
  result = (btVector3 *) &(arg1)->getAnchor();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btUniversalConstraint_1getAnchor2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btUniversalConstraint *arg1 = (btUniversalConstraint *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btUniversalConstraint **)&jarg1; 
  result = (btVector3 *) &(arg1)->getAnchor2();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btUniversalConstraint_1getAxis1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btUniversalConstraint *arg1 = (btUniversalConstraint *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btUniversalConstraint **)&jarg1; 
  result = (btVector3 *) &(arg1)->getAxis1();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btUniversalConstraint_1getAxis2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btUniversalConstraint *arg1 = (btUniversalConstraint *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btUniversalConstraint **)&jarg1; 
  result = (btVector3 *) &(arg1)->getAxis2();
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btUniversalConstraint_1getAngle1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btUniversalConstraint *arg1 = (btUniversalConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btUniversalConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getAngle1();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btUniversalConstraint_1getAngle2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btUniversalConstraint *arg1 = (btUniversalConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btUniversalConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getAngle2();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btUniversalConstraint_1setUpperLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  btUniversalConstraint *arg1 = (btUniversalConstraint *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btUniversalConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setUpperLimit(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btUniversalConstraint_1setLowerLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  btUniversalConstraint *arg1 = (btUniversalConstraint *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btUniversalConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setLowerLimit(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btUniversalConstraint_1setAxis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btUniversalConstraint *arg1 = (btUniversalConstraint *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btUniversalConstraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->setAxis((btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btUniversalConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btUniversalConstraint *arg1 = (btUniversalConstraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btUniversalConstraint **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactConstraint_1setContactManifold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btContactConstraint *arg1 = (btContactConstraint *) 0 ;
  btPersistentManifold *arg2 = (btPersistentManifold *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btContactConstraint **)&jarg1; 
  arg2 = *(btPersistentManifold **)&jarg2; 
  (arg1)->setContactManifold(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactConstraint_1getContactManifold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btContactConstraint *arg1 = (btContactConstraint *) 0 ;
  btPersistentManifold *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactConstraint **)&jarg1; 
  result = (btPersistentManifold *)(arg1)->getContactManifold();
  *(btPersistentManifold **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btContactConstraint_1getContactManifoldConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btContactConstraint *arg1 = (btContactConstraint *) 0 ;
  btPersistentManifold *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btContactConstraint **)&jarg1; 
  result = (btPersistentManifold *)((btContactConstraint const *)arg1)->getContactManifold();
  *(btPersistentManifold **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btContactConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btContactConstraint *arg1 = (btContactConstraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btContactConstraint **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_resolveSingleCollision(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jlong jarg5, jobject jarg5_, jfloat jarg6) {
  jfloat jresult = 0 ;
  btRigidBody *arg1 = (btRigidBody *) 0 ;
  btCollisionObject *arg2 = (btCollisionObject *) 0 ;
  btVector3 *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btContactSolverInfo *arg5 = 0 ;
  btScalar arg6 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg5_;
  arg1 = *(btRigidBody **)&jarg1; 
  arg2 = *(btCollisionObject **)&jarg2; 
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = *(btContactSolverInfo **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btContactSolverInfo const & reference is null");
    return 0;
  } 
  arg6 = (btScalar)jarg6; 
  result = (btScalar)resolveSingleCollision(arg1,arg2,(btVector3 const &)*arg3,(btVector3 const &)*arg4,(btContactSolverInfo const &)*arg5,arg6);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_resolveSingleBilateral(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jobject jarg3_, jobject jarg4, jfloat jarg5, jobject jarg6, jlong jarg7, jfloat jarg8) {
  btRigidBody *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  btRigidBody *arg3 = 0 ;
  btVector3 *arg4 = 0 ;
  btScalar arg5 ;
  btVector3 *arg6 = 0 ;
  btScalar *arg7 = 0 ;
  btScalar arg8 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(btRigidBody **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return ;
  } 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = *(btRigidBody **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return ;
  } 
  btVector3 local_arg4;
  gdx_setbtVector3FromVector3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitVector3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = (btScalar)jarg5; 
  btVector3 local_arg6;
  gdx_setbtVector3FromVector3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitVector3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  arg7 = *(btScalar **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btScalar & reference is null");
    return ;
  } 
  arg8 = (btScalar)jarg8; 
  resolveSingleBilateral(*arg1,(btVector3 const &)*arg2,*arg3,(btVector3 const &)*arg4,arg5,(btVector3 const &)*arg6,*arg7,arg8);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1operatorNew_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1operatorDelete_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1operatorNew_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1operatorDelete_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1operatorNewArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new[](arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1operatorDeleteArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete[](arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1operatorNewArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new[](arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1operatorDeleteArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete[](arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btConeTwistConstraint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  jlong jresult = 0 ;
  btRigidBody *arg1 = 0 ;
  btRigidBody *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  btConeTwistConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBody **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  result = (btConeTwistConstraint *)new btConeTwistConstraint(*arg1,*arg2,(btTransform const &)*arg3,(btTransform const &)*arg4);
  *(btConeTwistConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btConeTwistConstraint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  btRigidBody *arg1 = 0 ;
  btTransform *arg2 = 0 ;
  btConeTwistConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btConeTwistConstraint *)new btConeTwistConstraint(*arg1,(btTransform const &)*arg2);
  *(btConeTwistConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getInfo1NonVirtual(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btTypedConstraint::btConstraintInfo1 *arg2 = (btTypedConstraint::btConstraintInfo1 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = *(btTypedConstraint::btConstraintInfo1 **)&jarg2; 
  (arg1)->getInfo1NonVirtual(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getInfo2NonVirtual(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jobject jarg5, jobject jarg6) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btTypedConstraint::btConstraintInfo2 *arg2 = (btTypedConstraint::btConstraintInfo2 *) 0 ;
  btTransform *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  btMatrix3x3 *arg5 = 0 ;
  btMatrix3x3 *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = *(btTypedConstraint::btConstraintInfo2 **)&jarg2; 
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btMatrix3x3 local_arg5;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  btMatrix3x3 local_arg6;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg6, jarg6);
  arg6 = &local_arg6;
  gdxAutoCommitMatrix3 auto_commit_arg6(jenv, jarg6, &local_arg6);
  (arg1)->getInfo2NonVirtual(arg2,(btTransform const &)*arg3,(btTransform const &)*arg4,(btMatrix3x3 const &)*arg5,(btMatrix3x3 const &)*arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1updateRHS(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->updateRHS(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getRigidBodyAConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btRigidBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (btRigidBody *) &((btConeTwistConstraint const *)arg1)->getRigidBodyA();
  *(btRigidBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getRigidBodyBConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btRigidBody *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (btRigidBody *) &((btConeTwistConstraint const *)arg1)->getRigidBodyB();
  *(btRigidBody **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1setAngularOnly(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->setAngularOnly(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getAngularOnly(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (bool)((btConeTwistConstraint const *)arg1)->getAngularOnly();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1setLimit_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setLimit(arg2,arg3);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jfloat jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  int arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btScalar)((btConeTwistConstraint const *)arg1)->getLimit(arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1setLimit_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4, jfloat jarg5, jfloat jarg6, jfloat jarg7) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btScalar arg4 ;
  btScalar arg5 ;
  btScalar arg6 ;
  btScalar arg7 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (btScalar)jarg4; 
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  arg7 = (btScalar)jarg7; 
  (arg1)->setLimit(arg2,arg3,arg4,arg5,arg6,arg7);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1setLimit_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4, jfloat jarg5, jfloat jarg6) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btScalar arg4 ;
  btScalar arg5 ;
  btScalar arg6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (btScalar)jarg4; 
  arg5 = (btScalar)jarg5; 
  arg6 = (btScalar)jarg6; 
  (arg1)->setLimit(arg2,arg3,arg4,arg5,arg6);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1setLimit_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4, jfloat jarg5) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btScalar arg4 ;
  btScalar arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (btScalar)jarg4; 
  arg5 = (btScalar)jarg5; 
  (arg1)->setLimit(arg2,arg3,arg4,arg5);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1setLimit_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3, jfloat jarg4) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btScalar arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (btScalar)jarg4; 
  (arg1)->setLimit(arg2,arg3,arg4);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getAFrame(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (btTransform *) &((btConeTwistConstraint const *)arg1)->getAFrame();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getBFrame(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (btTransform *) &((btConeTwistConstraint const *)arg1)->getBFrame();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getSolveTwistLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (int)(arg1)->getSolveTwistLimit();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getSolveSwingLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (int)(arg1)->getSolveSwingLimit();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getTwistLimitSign(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getTwistLimitSign();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1calcAngleInfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  (arg1)->calcAngleInfo();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1calcAngleInfo2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jobject jarg5) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btTransform *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  btMatrix3x3 *arg4 = 0 ;
  btMatrix3x3 *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btMatrix3x3 local_arg4;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix3 auto_commit_arg4(jenv, jarg4, &local_arg4);
  btMatrix3x3 local_arg5;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg5, jarg5);
  arg5 = &local_arg5;
  gdxAutoCommitMatrix3 auto_commit_arg5(jenv, jarg5, &local_arg5);
  (arg1)->calcAngleInfo2((btTransform const &)*arg2,(btTransform const &)*arg3,(btMatrix3x3 const &)*arg4,(btMatrix3x3 const &)*arg5);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getSwingSpan1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (btScalar)((btConeTwistConstraint const *)arg1)->getSwingSpan1();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getSwingSpan2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (btScalar)((btConeTwistConstraint const *)arg1)->getSwingSpan2();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getTwistSpan(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (btScalar)((btConeTwistConstraint const *)arg1)->getTwistSpan();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getLimitSoftness(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (btScalar)((btConeTwistConstraint const *)arg1)->getLimitSoftness();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getBiasFactor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (btScalar)((btConeTwistConstraint const *)arg1)->getBiasFactor();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getRelaxationFactor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (btScalar)((btConeTwistConstraint const *)arg1)->getRelaxationFactor();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getTwistAngle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (btScalar)((btConeTwistConstraint const *)arg1)->getTwistAngle();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1isPastSwingLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (bool)(arg1)->isPastSwingLimit();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getDamping(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (btScalar)((btConeTwistConstraint const *)arg1)->getDamping();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1setDamping(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setDamping(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1enableMotor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->enableMotor(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1isMotorEnabled(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (bool)((btConeTwistConstraint const *)arg1)->isMotorEnabled();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getMaxMotorImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (btScalar)((btConeTwistConstraint const *)arg1)->getMaxMotorImpulse();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1isMaxMotorImpulseNormalized(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (bool)((btConeTwistConstraint const *)arg1)->isMaxMotorImpulseNormalized();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1setMaxMotorImpulse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setMaxMotorImpulse(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1setMaxMotorImpulseNormalized(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setMaxMotorImpulseNormalized(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getFixThresh(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (btScalar)(arg1)->getFixThresh();
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1setFixThresh(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->setFixThresh(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1setMotorTarget(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btQuaternion *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setMotorTarget((btQuaternion const &)*arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getMotorTarget(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btQuaternion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (btQuaternion *) &((btConeTwistConstraint const *)arg1)->getMotorTarget();
  jresult = gdx_getReturnQuaternion(jenv);
  gdx_setQuaternionFrombtQuaternion(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1setMotorTargetInConstraintSpace(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btQuaternion *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  btQuaternion local_arg2;
  gdx_setbtQuaternionFromQuaternion(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitQuaternion auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setMotorTargetInConstraintSpace((btQuaternion const &)*arg2);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1GetPointForAngle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2, jfloat jarg3) {
  jobject jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btScalar arg2 ;
  btScalar arg3 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  arg3 = (btScalar)jarg3; 
  result = ((btConeTwistConstraint const *)arg1)->GetPointForAngle(arg2,arg3);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1setParam_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3, jint jarg4) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->setParam(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1setParam_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setParam(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1setFrames(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btTransform *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->setFrames((btTransform const &)*arg2,(btTransform const &)*arg3);
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getFrameOffsetA(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (btTransform *) &((btConeTwistConstraint const *)arg1)->getFrameOffsetA();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getFrameOffsetB(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (btTransform *) &((btConeTwistConstraint const *)arg1)->getFrameOffsetB();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getParam_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jfloat jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  int arg2 ;
  int arg3 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (btScalar)((btConeTwistConstraint const *)arg1)->getParam(arg2,arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getParam_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jfloat jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  int arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btScalar)((btConeTwistConstraint const *)arg1)->getParam(arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraint_1getFlags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  result = (int)((btConeTwistConstraint const *)arg1)->getFlags();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btConeTwistConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConeTwistConstraint *arg1 = (btConeTwistConstraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConeTwistConstraint **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintDoubleData_1typeConstraintData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConeTwistConstraintDoubleData *arg1 = (btConeTwistConstraintDoubleData *) 0 ;
  btTypedConstraintDoubleData *arg2 = (btTypedConstraintDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConeTwistConstraintDoubleData **)&jarg1; 
  arg2 = *(btTypedConstraintDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_typeConstraintData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintDoubleData_1typeConstraintData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConeTwistConstraintDoubleData *arg1 = (btConeTwistConstraintDoubleData *) 0 ;
  btTypedConstraintDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintDoubleData **)&jarg1; 
  result = (btTypedConstraintDoubleData *)& ((arg1)->m_typeConstraintData);
  *(btTypedConstraintDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintDoubleData_1rbAFrame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConeTwistConstraintDoubleData *arg1 = (btConeTwistConstraintDoubleData *) 0 ;
  btTransformDoubleData *arg2 = (btTransformDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConeTwistConstraintDoubleData **)&jarg1; 
  arg2 = *(btTransformDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_rbAFrame = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintDoubleData_1rbAFrame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConeTwistConstraintDoubleData *arg1 = (btConeTwistConstraintDoubleData *) 0 ;
  btTransformDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintDoubleData **)&jarg1; 
  result = (btTransformDoubleData *)& ((arg1)->m_rbAFrame);
  *(btTransformDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintDoubleData_1rbBFrame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConeTwistConstraintDoubleData *arg1 = (btConeTwistConstraintDoubleData *) 0 ;
  btTransformDoubleData *arg2 = (btTransformDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConeTwistConstraintDoubleData **)&jarg1; 
  arg2 = *(btTransformDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_rbBFrame = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintDoubleData_1rbBFrame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConeTwistConstraintDoubleData *arg1 = (btConeTwistConstraintDoubleData *) 0 ;
  btTransformDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintDoubleData **)&jarg1; 
  result = (btTransformDoubleData *)& ((arg1)->m_rbBFrame);
  *(btTransformDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintDoubleData_1swingSpan1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btConeTwistConstraintDoubleData *arg1 = (btConeTwistConstraintDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_swingSpan1 = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintDoubleData_1swingSpan1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btConeTwistConstraintDoubleData *arg1 = (btConeTwistConstraintDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_swingSpan1);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintDoubleData_1swingSpan2_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btConeTwistConstraintDoubleData *arg1 = (btConeTwistConstraintDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_swingSpan2 = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintDoubleData_1swingSpan2_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btConeTwistConstraintDoubleData *arg1 = (btConeTwistConstraintDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_swingSpan2);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintDoubleData_1twistSpan_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btConeTwistConstraintDoubleData *arg1 = (btConeTwistConstraintDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_twistSpan = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintDoubleData_1twistSpan_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btConeTwistConstraintDoubleData *arg1 = (btConeTwistConstraintDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_twistSpan);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintDoubleData_1limitSoftness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btConeTwistConstraintDoubleData *arg1 = (btConeTwistConstraintDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_limitSoftness = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintDoubleData_1limitSoftness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btConeTwistConstraintDoubleData *arg1 = (btConeTwistConstraintDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_limitSoftness);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintDoubleData_1biasFactor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btConeTwistConstraintDoubleData *arg1 = (btConeTwistConstraintDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_biasFactor = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintDoubleData_1biasFactor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btConeTwistConstraintDoubleData *arg1 = (btConeTwistConstraintDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_biasFactor);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintDoubleData_1relaxationFactor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btConeTwistConstraintDoubleData *arg1 = (btConeTwistConstraintDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_relaxationFactor = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintDoubleData_1relaxationFactor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btConeTwistConstraintDoubleData *arg1 = (btConeTwistConstraintDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_relaxationFactor);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintDoubleData_1damping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  btConeTwistConstraintDoubleData *arg1 = (btConeTwistConstraintDoubleData *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintDoubleData **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->m_damping = arg2;
}


SWIGEXPORT jdouble JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintDoubleData_1damping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  btConeTwistConstraintDoubleData *arg1 = (btConeTwistConstraintDoubleData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintDoubleData **)&jarg1; 
  result = (double) ((arg1)->m_damping);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btConeTwistConstraintDoubleData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btConeTwistConstraintDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btConeTwistConstraintDoubleData *)new btConeTwistConstraintDoubleData();
  *(btConeTwistConstraintDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btConeTwistConstraintDoubleData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConeTwistConstraintDoubleData *arg1 = (btConeTwistConstraintDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConeTwistConstraintDoubleData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintData_1typeConstraintData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  btTypedConstraintData *arg2 = (btTypedConstraintData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  arg2 = *(btTypedConstraintData **)&jarg2; 
  if (arg1) (arg1)->m_typeConstraintData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintData_1typeConstraintData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  btTypedConstraintData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  result = (btTypedConstraintData *)& ((arg1)->m_typeConstraintData);
  *(btTypedConstraintData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintData_1rbAFrame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  btTransformFloatData *arg2 = (btTransformFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  arg2 = *(btTransformFloatData **)&jarg2; 
  if (arg1) (arg1)->m_rbAFrame = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintData_1rbAFrame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  btTransformFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  result = (btTransformFloatData *)& ((arg1)->m_rbAFrame);
  *(btTransformFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintData_1rbBFrame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  btTransformFloatData *arg2 = (btTransformFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  arg2 = *(btTransformFloatData **)&jarg2; 
  if (arg1) (arg1)->m_rbBFrame = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintData_1rbBFrame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  btTransformFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  result = (btTransformFloatData *)& ((arg1)->m_rbBFrame);
  *(btTransformFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintData_1swingSpan1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_swingSpan1 = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintData_1swingSpan1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  result = (float) ((arg1)->m_swingSpan1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintData_1swingSpan2_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_swingSpan2 = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintData_1swingSpan2_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  result = (float) ((arg1)->m_swingSpan2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintData_1twistSpan_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_twistSpan = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintData_1twistSpan_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  result = (float) ((arg1)->m_twistSpan);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintData_1limitSoftness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_limitSoftness = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintData_1limitSoftness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  result = (float) ((arg1)->m_limitSoftness);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintData_1biasFactor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_biasFactor = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintData_1biasFactor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  result = (float) ((arg1)->m_biasFactor);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintData_1relaxationFactor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_relaxationFactor = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintData_1relaxationFactor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  result = (float) ((arg1)->m_relaxationFactor);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintData_1damping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->m_damping = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintData_1damping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  result = (float) ((arg1)->m_damping);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintData_1pad_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_pad, (const char *)arg2, 4-1);
      arg1->m_pad[4-1] = 0;
    } else {
      arg1->m_pad[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btConeTwistConstraintData_1pad_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_pad);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btConeTwistConstraintData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btConeTwistConstraintData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btConeTwistConstraintData *)new btConeTwistConstraintData();
  *(btConeTwistConstraintData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btConeTwistConstraintData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btConeTwistConstraintData *arg1 = (btConeTwistConstraintData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btConeTwistConstraintData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraint_1operatorNew_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btGeneric6DofSpringConstraint *arg1 = (btGeneric6DofSpringConstraint *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraint_1operatorDelete_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btGeneric6DofSpringConstraint *arg1 = (btGeneric6DofSpringConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraint_1operatorNew_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btGeneric6DofSpringConstraint *arg1 = (btGeneric6DofSpringConstraint *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraint_1operatorDelete_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btGeneric6DofSpringConstraint *arg1 = (btGeneric6DofSpringConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraint_1operatorNewArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btGeneric6DofSpringConstraint *arg1 = (btGeneric6DofSpringConstraint *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new[](arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraint_1operatorDeleteArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btGeneric6DofSpringConstraint *arg1 = (btGeneric6DofSpringConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete[](arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraint_1operatorNewArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btGeneric6DofSpringConstraint *arg1 = (btGeneric6DofSpringConstraint *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new[](arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraint_1operatorDeleteArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btGeneric6DofSpringConstraint *arg1 = (btGeneric6DofSpringConstraint *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete[](arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btGeneric6DofSpringConstraint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jboolean jarg5) {
  jlong jresult = 0 ;
  btRigidBody *arg1 = 0 ;
  btRigidBody *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  bool arg5 ;
  btGeneric6DofSpringConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBody **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = jarg5 ? true : false; 
  result = (btGeneric6DofSpringConstraint *)new btGeneric6DofSpringConstraint(*arg1,*arg2,(btTransform const &)*arg3,(btTransform const &)*arg4,arg5);
  *(btGeneric6DofSpringConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btGeneric6DofSpringConstraint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  btRigidBody *arg1 = 0 ;
  btTransform *arg2 = 0 ;
  bool arg3 ;
  btGeneric6DofSpringConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = jarg3 ? true : false; 
  result = (btGeneric6DofSpringConstraint *)new btGeneric6DofSpringConstraint(*arg1,(btTransform const &)*arg2,arg3);
  *(btGeneric6DofSpringConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraint_1enableSpring(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  btGeneric6DofSpringConstraint *arg1 = (btGeneric6DofSpringConstraint *) 0 ;
  int arg2 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = jarg3 ? true : false; 
  (arg1)->enableSpring(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraint_1setStiffness(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  btGeneric6DofSpringConstraint *arg1 = (btGeneric6DofSpringConstraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setStiffness(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraint_1setDamping(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  btGeneric6DofSpringConstraint *arg1 = (btGeneric6DofSpringConstraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setDamping(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraint_1setEquilibriumPoint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btGeneric6DofSpringConstraint *arg1 = (btGeneric6DofSpringConstraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraint **)&jarg1; 
  (arg1)->setEquilibriumPoint();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraint_1setEquilibriumPoint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btGeneric6DofSpringConstraint *arg1 = (btGeneric6DofSpringConstraint *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setEquilibriumPoint(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraint_1setEquilibriumPoint_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  btGeneric6DofSpringConstraint *arg1 = (btGeneric6DofSpringConstraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setEquilibriumPoint(arg2,arg3);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraint_1isSpringEnabled(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  btGeneric6DofSpringConstraint *arg1 = (btGeneric6DofSpringConstraint *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)((btGeneric6DofSpringConstraint const *)arg1)->isSpringEnabled(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraint_1getStiffness(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jfloat jresult = 0 ;
  btGeneric6DofSpringConstraint *arg1 = (btGeneric6DofSpringConstraint *) 0 ;
  int arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btScalar)((btGeneric6DofSpringConstraint const *)arg1)->getStiffness(arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraint_1getDamping(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jfloat jresult = 0 ;
  btGeneric6DofSpringConstraint *arg1 = (btGeneric6DofSpringConstraint *) 0 ;
  int arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btScalar)((btGeneric6DofSpringConstraint const *)arg1)->getDamping(arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraint_1getEquilibriumPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jfloat jresult = 0 ;
  btGeneric6DofSpringConstraint *arg1 = (btGeneric6DofSpringConstraint *) 0 ;
  int arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraint **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btScalar)((btGeneric6DofSpringConstraint const *)arg1)->getEquilibriumPoint(arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraint_1setAxis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btGeneric6DofSpringConstraint *arg1 = (btGeneric6DofSpringConstraint *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->setAxis((btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btGeneric6DofSpringConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btGeneric6DofSpringConstraint *arg1 = (btGeneric6DofSpringConstraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btGeneric6DofSpringConstraint **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraintData_16dofData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpringConstraintData *arg1 = (btGeneric6DofSpringConstraintData *) 0 ;
  btGeneric6DofConstraintData *arg2 = (btGeneric6DofConstraintData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpringConstraintData **)&jarg1; 
  arg2 = *(btGeneric6DofConstraintData **)&jarg2; 
  if (arg1) (arg1)->m_6dofData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraintData_16dofData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpringConstraintData *arg1 = (btGeneric6DofSpringConstraintData *) 0 ;
  btGeneric6DofConstraintData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraintData **)&jarg1; 
  result = (btGeneric6DofConstraintData *)& ((arg1)->m_6dofData);
  *(btGeneric6DofConstraintData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraintData_1springEnabled_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btGeneric6DofSpringConstraintData *arg1 = (btGeneric6DofSpringConstraintData *) 0 ;
  int *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraintData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  arg2 = (int *)jenv->GetPrimitiveArrayCritical(jarg2, 0); 
  {
    size_t ii;
    int *b = (int *) arg1->m_springEnabled;
    for (ii = 0; ii < (size_t)6; ii++) b[ii] = *((int *) arg2 + ii);
  }
  jenv->ReleasePrimitiveArrayCritical(jarg2, (int *)arg2, 0); 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraintData_1springEnabled_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btGeneric6DofSpringConstraintData *arg1 = (btGeneric6DofSpringConstraintData *) 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraintData **)&jarg1; 
  result = (int *)(int *) ((arg1)->m_springEnabled);
  /*jresult = SWIG_JavaArrayOut##Int(jenv, (int *)result, 6);*/ 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraintData_1equilibriumPoint_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloatArray jarg2) {
  btGeneric6DofSpringConstraintData *arg1 = (btGeneric6DofSpringConstraintData *) 0 ;
  float *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraintData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  arg2 = (float *)jenv->GetPrimitiveArrayCritical(jarg2, 0); 
  {
    size_t ii;
    float *b = (float *) arg1->m_equilibriumPoint;
    for (ii = 0; ii < (size_t)6; ii++) b[ii] = *((float *) arg2 + ii);
  }
  jenv->ReleasePrimitiveArrayCritical(jarg2, (float *)arg2, 0); 
}


SWIGEXPORT jfloatArray JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraintData_1equilibriumPoint_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloatArray jresult = 0 ;
  btGeneric6DofSpringConstraintData *arg1 = (btGeneric6DofSpringConstraintData *) 0 ;
  float *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraintData **)&jarg1; 
  result = (float *)(float *) ((arg1)->m_equilibriumPoint);
  /*jresult = SWIG_JavaArrayOut##Float(jenv, (float *)result, 6);*/ 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraintData_1springStiffness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloatArray jarg2) {
  btGeneric6DofSpringConstraintData *arg1 = (btGeneric6DofSpringConstraintData *) 0 ;
  float *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraintData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  arg2 = (float *)jenv->GetPrimitiveArrayCritical(jarg2, 0); 
  {
    size_t ii;
    float *b = (float *) arg1->m_springStiffness;
    for (ii = 0; ii < (size_t)6; ii++) b[ii] = *((float *) arg2 + ii);
  }
  jenv->ReleasePrimitiveArrayCritical(jarg2, (float *)arg2, 0); 
}


SWIGEXPORT jfloatArray JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraintData_1springStiffness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloatArray jresult = 0 ;
  btGeneric6DofSpringConstraintData *arg1 = (btGeneric6DofSpringConstraintData *) 0 ;
  float *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraintData **)&jarg1; 
  result = (float *)(float *) ((arg1)->m_springStiffness);
  /*jresult = SWIG_JavaArrayOut##Float(jenv, (float *)result, 6);*/ 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraintData_1springDamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloatArray jarg2) {
  btGeneric6DofSpringConstraintData *arg1 = (btGeneric6DofSpringConstraintData *) 0 ;
  float *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraintData **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  arg2 = (float *)jenv->GetPrimitiveArrayCritical(jarg2, 0); 
  {
    size_t ii;
    float *b = (float *) arg1->m_springDamping;
    for (ii = 0; ii < (size_t)6; ii++) b[ii] = *((float *) arg2 + ii);
  }
  jenv->ReleasePrimitiveArrayCritical(jarg2, (float *)arg2, 0); 
}


SWIGEXPORT jfloatArray JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraintData_1springDamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloatArray jresult = 0 ;
  btGeneric6DofSpringConstraintData *arg1 = (btGeneric6DofSpringConstraintData *) 0 ;
  float *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraintData **)&jarg1; 
  result = (float *)(float *) ((arg1)->m_springDamping);
  /*jresult = SWIG_JavaArrayOut##Float(jenv, (float *)result, 6);*/ 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btGeneric6DofSpringConstraintData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btGeneric6DofSpringConstraintData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btGeneric6DofSpringConstraintData *)new btGeneric6DofSpringConstraintData();
  *(btGeneric6DofSpringConstraintData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btGeneric6DofSpringConstraintData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btGeneric6DofSpringConstraintData *arg1 = (btGeneric6DofSpringConstraintData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btGeneric6DofSpringConstraintData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraintDoubleData2_16dofData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpringConstraintDoubleData2 *arg1 = (btGeneric6DofSpringConstraintDoubleData2 *) 0 ;
  btGeneric6DofConstraintDoubleData2 *arg2 = (btGeneric6DofConstraintDoubleData2 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpringConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btGeneric6DofConstraintDoubleData2 **)&jarg2; 
  if (arg1) (arg1)->m_6dofData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraintDoubleData2_16dofData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpringConstraintDoubleData2 *arg1 = (btGeneric6DofSpringConstraintDoubleData2 *) 0 ;
  btGeneric6DofConstraintDoubleData2 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraintDoubleData2 **)&jarg1; 
  result = (btGeneric6DofConstraintDoubleData2 *)& ((arg1)->m_6dofData);
  *(btGeneric6DofConstraintDoubleData2 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraintDoubleData2_1springEnabled_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btGeneric6DofSpringConstraintDoubleData2 *arg1 = (btGeneric6DofSpringConstraintDoubleData2 *) 0 ;
  int *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraintDoubleData2 **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  arg2 = (int *)jenv->GetPrimitiveArrayCritical(jarg2, 0); 
  {
    size_t ii;
    int *b = (int *) arg1->m_springEnabled;
    for (ii = 0; ii < (size_t)6; ii++) b[ii] = *((int *) arg2 + ii);
  }
  jenv->ReleasePrimitiveArrayCritical(jarg2, (int *)arg2, 0); 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraintDoubleData2_1springEnabled_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btGeneric6DofSpringConstraintDoubleData2 *arg1 = (btGeneric6DofSpringConstraintDoubleData2 *) 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraintDoubleData2 **)&jarg1; 
  result = (int *)(int *) ((arg1)->m_springEnabled);
  /*jresult = SWIG_JavaArrayOut##Int(jenv, (int *)result, 6);*/ 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraintDoubleData2_1equilibriumPoint_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdoubleArray jarg2) {
  btGeneric6DofSpringConstraintDoubleData2 *arg1 = (btGeneric6DofSpringConstraintDoubleData2 *) 0 ;
  double *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraintDoubleData2 **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  arg2 = (double *)jenv->GetPrimitiveArrayCritical(jarg2, 0); 
  {
    size_t ii;
    double *b = (double *) arg1->m_equilibriumPoint;
    for (ii = 0; ii < (size_t)6; ii++) b[ii] = *((double *) arg2 + ii);
  }
  jenv->ReleasePrimitiveArrayCritical(jarg2, (double *)arg2, 0); 
}


SWIGEXPORT jdoubleArray JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraintDoubleData2_1equilibriumPoint_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdoubleArray jresult = 0 ;
  btGeneric6DofSpringConstraintDoubleData2 *arg1 = (btGeneric6DofSpringConstraintDoubleData2 *) 0 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraintDoubleData2 **)&jarg1; 
  result = (double *)(double *) ((arg1)->m_equilibriumPoint);
  /*jresult = SWIG_JavaArrayOut##Double(jenv, (double *)result, 6);*/ 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraintDoubleData2_1springStiffness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdoubleArray jarg2) {
  btGeneric6DofSpringConstraintDoubleData2 *arg1 = (btGeneric6DofSpringConstraintDoubleData2 *) 0 ;
  double *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraintDoubleData2 **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  arg2 = (double *)jenv->GetPrimitiveArrayCritical(jarg2, 0); 
  {
    size_t ii;
    double *b = (double *) arg1->m_springStiffness;
    for (ii = 0; ii < (size_t)6; ii++) b[ii] = *((double *) arg2 + ii);
  }
  jenv->ReleasePrimitiveArrayCritical(jarg2, (double *)arg2, 0); 
}


SWIGEXPORT jdoubleArray JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraintDoubleData2_1springStiffness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdoubleArray jresult = 0 ;
  btGeneric6DofSpringConstraintDoubleData2 *arg1 = (btGeneric6DofSpringConstraintDoubleData2 *) 0 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraintDoubleData2 **)&jarg1; 
  result = (double *)(double *) ((arg1)->m_springStiffness);
  /*jresult = SWIG_JavaArrayOut##Double(jenv, (double *)result, 6);*/ 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraintDoubleData2_1springDamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdoubleArray jarg2) {
  btGeneric6DofSpringConstraintDoubleData2 *arg1 = (btGeneric6DofSpringConstraintDoubleData2 *) 0 ;
  double *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraintDoubleData2 **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  arg2 = (double *)jenv->GetPrimitiveArrayCritical(jarg2, 0); 
  {
    size_t ii;
    double *b = (double *) arg1->m_springDamping;
    for (ii = 0; ii < (size_t)6; ii++) b[ii] = *((double *) arg2 + ii);
  }
  jenv->ReleasePrimitiveArrayCritical(jarg2, (double *)arg2, 0); 
}


SWIGEXPORT jdoubleArray JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpringConstraintDoubleData2_1springDamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdoubleArray jresult = 0 ;
  btGeneric6DofSpringConstraintDoubleData2 *arg1 = (btGeneric6DofSpringConstraintDoubleData2 *) 0 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpringConstraintDoubleData2 **)&jarg1; 
  result = (double *)(double *) ((arg1)->m_springDamping);
  /*jresult = SWIG_JavaArrayOut##Double(jenv, (double *)result, 6);*/ 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btGeneric6DofSpringConstraintDoubleData2(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btGeneric6DofSpringConstraintDoubleData2 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btGeneric6DofSpringConstraintDoubleData2 *)new btGeneric6DofSpringConstraintDoubleData2();
  *(btGeneric6DofSpringConstraintDoubleData2 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btGeneric6DofSpringConstraintDoubleData2(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btGeneric6DofSpringConstraintDoubleData2 *arg1 = (btGeneric6DofSpringConstraintDoubleData2 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btGeneric6DofSpringConstraintDoubleData2 **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1loLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_loLimit = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1loLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (btScalar) ((arg1)->m_loLimit);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1hiLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_hiLimit = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1hiLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (btScalar) ((arg1)->m_hiLimit);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1bounce_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_bounce = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1bounce_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (btScalar) ((arg1)->m_bounce);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1stopERP_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_stopERP = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1stopERP_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (btScalar) ((arg1)->m_stopERP);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1stopCFM_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_stopCFM = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1stopCFM_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (btScalar) ((arg1)->m_stopCFM);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1motorERP_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_motorERP = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1motorERP_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (btScalar) ((arg1)->m_motorERP);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1motorCFM_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_motorCFM = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1motorCFM_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (btScalar) ((arg1)->m_motorCFM);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1enableMotor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_enableMotor = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1enableMotor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (bool) ((arg1)->m_enableMotor);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1targetVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_targetVelocity = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1targetVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (btScalar) ((arg1)->m_targetVelocity);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1maxMotorForce_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_maxMotorForce = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1maxMotorForce_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (btScalar) ((arg1)->m_maxMotorForce);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1servoMotor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_servoMotor = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1servoMotor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (bool) ((arg1)->m_servoMotor);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1servoTarget_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_servoTarget = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1servoTarget_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (btScalar) ((arg1)->m_servoTarget);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1enableSpring_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_enableSpring = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1enableSpring_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (bool) ((arg1)->m_enableSpring);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1springStiffness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_springStiffness = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1springStiffness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (btScalar) ((arg1)->m_springStiffness);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1springStiffnessLimited_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_springStiffnessLimited = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1springStiffnessLimited_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (bool) ((arg1)->m_springStiffnessLimited);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1springDamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_springDamping = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1springDamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (btScalar) ((arg1)->m_springDamping);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1springDampingLimited_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->m_springDampingLimited = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1springDampingLimited_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (bool) ((arg1)->m_springDampingLimited);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1equilibriumPoint_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_equilibriumPoint = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1equilibriumPoint_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (btScalar) ((arg1)->m_equilibriumPoint);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1currentLimitError_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_currentLimitError = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1currentLimitError_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (btScalar) ((arg1)->m_currentLimitError);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1currentLimitErrorHi_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_currentLimitErrorHi = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1currentLimitErrorHi_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (btScalar) ((arg1)->m_currentLimitErrorHi);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1currentPosition_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  if (arg1) (arg1)->m_currentPosition = arg2;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1currentPosition_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (btScalar) ((arg1)->m_currentPosition);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1currentLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_currentLimit = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1currentLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (int) ((arg1)->m_currentLimit);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btRotationalLimitMotor2_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btRotationalLimitMotor2 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btRotationalLimitMotor2 *)new btRotationalLimitMotor2();
  *(btRotationalLimitMotor2 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btRotationalLimitMotor2_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = 0 ;
  btRotationalLimitMotor2 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRotationalLimitMotor2 const & reference is null");
    return 0;
  } 
  result = (btRotationalLimitMotor2 *)new btRotationalLimitMotor2((btRotationalLimitMotor2 const &)*arg1);
  *(btRotationalLimitMotor2 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1isLimited(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  result = (bool)(arg1)->isLimited();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btRotationalLimitMotor2_1testLimitValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  btScalar arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  arg2 = (btScalar)jarg2; 
  (arg1)->testLimitValue(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btRotationalLimitMotor2(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btRotationalLimitMotor2 *arg1 = (btRotationalLimitMotor2 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btRotationalLimitMotor2 **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1lowerLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_lowerLimit = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1lowerLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_lowerLimit);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1upperLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_upperLimit = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1upperLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_upperLimit);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1bounce_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_bounce = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1bounce_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_bounce);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1stopERP_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_stopERP = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1stopERP_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_stopERP);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1stopCFM_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_stopCFM = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1stopCFM_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_stopCFM);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1motorERP_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_motorERP = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1motorERP_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_motorERP);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1motorCFM_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_motorCFM = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1motorCFM_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_motorCFM);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1enableMotor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbooleanArray jarg2) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  bool *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  arg2 = (bool *)jenv->GetPrimitiveArrayCritical(jarg2, 0); 
  {
    size_t ii;
    bool *b = (bool *) arg1->m_enableMotor;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((bool *) arg2 + ii);
  }
  jenv->ReleasePrimitiveArrayCritical(jarg2, (bool *)arg2, 0); 
}


SWIGEXPORT jbooleanArray JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1enableMotor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jbooleanArray jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  bool *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  result = (bool *)(bool *) ((arg1)->m_enableMotor);
  /*jresult = SWIG_JavaArrayOut##Bool(jenv, (bool *)result, 3);*/ 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1servoMotor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbooleanArray jarg2) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  bool *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  arg2 = (bool *)jenv->GetPrimitiveArrayCritical(jarg2, 0); 
  {
    size_t ii;
    bool *b = (bool *) arg1->m_servoMotor;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((bool *) arg2 + ii);
  }
  jenv->ReleasePrimitiveArrayCritical(jarg2, (bool *)arg2, 0); 
}


SWIGEXPORT jbooleanArray JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1servoMotor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jbooleanArray jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  bool *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  result = (bool *)(bool *) ((arg1)->m_servoMotor);
  /*jresult = SWIG_JavaArrayOut##Bool(jenv, (bool *)result, 3);*/ 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1enableSpring_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbooleanArray jarg2) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  bool *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  arg2 = (bool *)jenv->GetPrimitiveArrayCritical(jarg2, 0); 
  {
    size_t ii;
    bool *b = (bool *) arg1->m_enableSpring;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((bool *) arg2 + ii);
  }
  jenv->ReleasePrimitiveArrayCritical(jarg2, (bool *)arg2, 0); 
}


SWIGEXPORT jbooleanArray JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1enableSpring_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jbooleanArray jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  bool *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  result = (bool *)(bool *) ((arg1)->m_enableSpring);
  /*jresult = SWIG_JavaArrayOut##Bool(jenv, (bool *)result, 3);*/ 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1servoTarget_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_servoTarget = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1servoTarget_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_servoTarget);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1springStiffness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_springStiffness = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1springStiffness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_springStiffness);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1springStiffnessLimited_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbooleanArray jarg2) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  bool *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  arg2 = (bool *)jenv->GetPrimitiveArrayCritical(jarg2, 0); 
  {
    size_t ii;
    bool *b = (bool *) arg1->m_springStiffnessLimited;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((bool *) arg2 + ii);
  }
  jenv->ReleasePrimitiveArrayCritical(jarg2, (bool *)arg2, 0); 
}


SWIGEXPORT jbooleanArray JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1springStiffnessLimited_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jbooleanArray jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  bool *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  result = (bool *)(bool *) ((arg1)->m_springStiffnessLimited);
  /*jresult = SWIG_JavaArrayOut##Bool(jenv, (bool *)result, 3);*/ 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1springDamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_springDamping = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1springDamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_springDamping);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1springDampingLimited_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbooleanArray jarg2) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  bool *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  arg2 = (bool *)jenv->GetPrimitiveArrayCritical(jarg2, 0); 
  {
    size_t ii;
    bool *b = (bool *) arg1->m_springDampingLimited;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((bool *) arg2 + ii);
  }
  jenv->ReleasePrimitiveArrayCritical(jarg2, (bool *)arg2, 0); 
}


SWIGEXPORT jbooleanArray JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1springDampingLimited_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jbooleanArray jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  bool *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  result = (bool *)(bool *) ((arg1)->m_springDampingLimited);
  /*jresult = SWIG_JavaArrayOut##Bool(jenv, (bool *)result, 3);*/ 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1equilibriumPoint_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_equilibriumPoint = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1equilibriumPoint_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_equilibriumPoint);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1targetVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_targetVelocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1targetVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_targetVelocity);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1maxMotorForce_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_maxMotorForce = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1maxMotorForce_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_maxMotorForce);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1currentLimitError_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_currentLimitError = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1currentLimitError_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_currentLimitError);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1currentLimitErrorHi_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_currentLimitErrorHi = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1currentLimitErrorHi_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_currentLimitErrorHi);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1currentLinearDiff_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *arg2 = (btVector3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  arg2 = *(btVector3 **)&jarg2; 
  if (arg1) (arg1)->m_currentLinearDiff = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1currentLinearDiff_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  btVector3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  result = (btVector3 *)& ((arg1)->m_currentLinearDiff);
  *(btVector3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1currentLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  int *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  arg2 = (int *)jenv->GetPrimitiveArrayCritical(jarg2, 0); 
  {
    size_t ii;
    int *b = (int *) arg1->m_currentLimit;
    for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((int *) arg2 + ii);
  }
  jenv->ReleasePrimitiveArrayCritical(jarg2, (int *)arg2, 0); 
}


SWIGEXPORT jintArray JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1currentLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  result = (int *)(int *) ((arg1)->m_currentLimit);
  /*jresult = SWIG_JavaArrayOut##Int(jenv, (int *)result, 3);*/ 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btTranslationalLimitMotor2_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor2 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btTranslationalLimitMotor2 *)new btTranslationalLimitMotor2();
  *(btTranslationalLimitMotor2 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btTranslationalLimitMotor2_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = 0 ;
  btTranslationalLimitMotor2 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btTranslationalLimitMotor2 const & reference is null");
    return 0;
  } 
  result = (btTranslationalLimitMotor2 *)new btTranslationalLimitMotor2((btTranslationalLimitMotor2 const &)*arg1);
  *(btTranslationalLimitMotor2 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1isLimited(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)(arg1)->isLimited(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btTranslationalLimitMotor2_1testLimitValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->testLimitValue(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btTranslationalLimitMotor2(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btTranslationalLimitMotor2 *arg1 = (btTranslationalLimitMotor2 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btTranslationalLimitMotor2 **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1operatorNew_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1operatorDelete_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1operatorNew_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1operatorDelete_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1operatorNewArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  size_t arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (void *)(arg1)->operator new[](arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1operatorDeleteArray_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  (arg1)->operator delete[](arg2);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1operatorNewArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  size_t arg2 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (void *)jarg3; 
  result = (void *)(arg1)->operator new[](arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1operatorDeleteArray_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  void *arg2 = (void *) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (void *)jarg2; 
  arg3 = (void *)jarg3; 
  (arg1)->operator delete[](arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btGeneric6DofSpring2Constraint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jint jarg5) {
  jlong jresult = 0 ;
  btRigidBody *arg1 = 0 ;
  btRigidBody *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  RotateOrder arg5 ;
  btGeneric6DofSpring2Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBody **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  arg5 = (RotateOrder)jarg5; 
  result = (btGeneric6DofSpring2Constraint *)new btGeneric6DofSpring2Constraint(*arg1,*arg2,(btTransform const &)*arg3,(btTransform const &)*arg4,arg5);
  *(btGeneric6DofSpring2Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btGeneric6DofSpring2Constraint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  jlong jresult = 0 ;
  btRigidBody *arg1 = 0 ;
  btRigidBody *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  btTransform *arg4 = 0 ;
  btGeneric6DofSpring2Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btRigidBody **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  arg2 = *(btRigidBody **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  btTransform local_arg4;
  gdx_setbtTransformFromMatrix4(jenv, local_arg4, jarg4);
  arg4 = &local_arg4;
  gdxAutoCommitMatrix4 auto_commit_arg4(jenv, jarg4, &local_arg4);
  result = (btGeneric6DofSpring2Constraint *)new btGeneric6DofSpring2Constraint(*arg1,*arg2,(btTransform const &)*arg3,(btTransform const &)*arg4);
  *(btGeneric6DofSpring2Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btGeneric6DofSpring2Constraint_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3) {
  jlong jresult = 0 ;
  btRigidBody *arg1 = 0 ;
  btTransform *arg2 = 0 ;
  RotateOrder arg3 ;
  btGeneric6DofSpring2Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  arg3 = (RotateOrder)jarg3; 
  result = (btGeneric6DofSpring2Constraint *)new btGeneric6DofSpring2Constraint(*arg1,(btTransform const &)*arg2,arg3);
  *(btGeneric6DofSpring2Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btGeneric6DofSpring2Constraint_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  btRigidBody *arg1 = 0 ;
  btTransform *arg2 = 0 ;
  btGeneric6DofSpring2Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btRigidBody **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "btRigidBody & reference is null");
    return 0;
  } 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (btGeneric6DofSpring2Constraint *)new btGeneric6DofSpring2Constraint(*arg1,(btTransform const &)*arg2);
  *(btGeneric6DofSpring2Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1getRotationalLimitMotor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  btRotationalLimitMotor2 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btRotationalLimitMotor2 *)(arg1)->getRotationalLimitMotor(arg2);
  *(btRotationalLimitMotor2 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1getTranslationalLimitMotor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  btTranslationalLimitMotor2 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  result = (btTranslationalLimitMotor2 *)(arg1)->getTranslationalLimitMotor();
  *(btTranslationalLimitMotor2 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1calculateTransforms_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  btTransform *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->calculateTransforms((btTransform const &)*arg2,(btTransform const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1calculateTransforms_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  (arg1)->calculateTransforms();
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1getCalculatedTransformA(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  result = (btTransform *) &((btGeneric6DofSpring2Constraint const *)arg1)->getCalculatedTransformA();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1getCalculatedTransformB(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  result = (btTransform *) &((btGeneric6DofSpring2Constraint const *)arg1)->getCalculatedTransformB();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1getFrameOffsetAConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  result = (btTransform *) &((btGeneric6DofSpring2Constraint const *)arg1)->getFrameOffsetA();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1getFrameOffsetBConst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  result = (btTransform *) &((btGeneric6DofSpring2Constraint const *)arg1)->getFrameOffsetB();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1getFrameOffsetA(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  result = (btTransform *) &(arg1)->getFrameOffsetA();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1getFrameOffsetB(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  btTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  result = (btTransform *) &(arg1)->getFrameOffsetB();
  jresult = gdx_getReturnMatrix4(jenv);
  gdx_setMatrix4FrombtTransform(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1getAxis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  btVector3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  result = ((btGeneric6DofSpring2Constraint const *)arg1)->getAxis(arg2);
  jresult = gdx_getReturnVector3(jenv);
  gdx_setVector3FrombtVector3(jenv, jresult, result);
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1getAngle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jfloat jresult = 0 ;
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btScalar)((btGeneric6DofSpring2Constraint const *)arg1)->getAngle(arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1getRelativePivotPosition(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jfloat jresult = 0 ;
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btScalar)((btGeneric6DofSpring2Constraint const *)arg1)->getRelativePivotPosition(arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setFrames(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  btTransform *arg2 = 0 ;
  btTransform *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  btTransform local_arg2;
  gdx_setbtTransformFromMatrix4(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitMatrix4 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btTransform local_arg3;
  gdx_setbtTransformFromMatrix4(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitMatrix4 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->setFrames((btTransform const &)*arg2,(btTransform const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setLinearLowerLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setLinearLowerLimit((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1getLinearLowerLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->getLinearLowerLimit(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setLinearUpperLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setLinearUpperLimit((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1getLinearUpperLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->getLinearUpperLimit(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setAngularLowerLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setAngularLowerLimit((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setAngularLowerLimitReversed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setAngularLowerLimitReversed((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1getAngularLowerLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->getAngularLowerLimit(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1getAngularLowerLimitReversed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->getAngularLowerLimitReversed(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setAngularUpperLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setAngularUpperLimit((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setAngularUpperLimitReversed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->setAngularUpperLimitReversed((btVector3 const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1getAngularUpperLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->getAngularUpperLimit(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1getAngularUpperLimitReversed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  btVector3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  (arg1)->getAngularUpperLimitReversed(*arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3, jfloat jarg4) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  btScalar arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (btScalar)jarg4; 
  (arg1)->setLimit(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setLimitReversed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3, jfloat jarg4) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  btScalar arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (btScalar)jarg4; 
  (arg1)->setLimitReversed(arg2,arg3,arg4);
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1isLimited(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)(arg1)->isLimited(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setRotationOrder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  RotateOrder arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (RotateOrder)jarg2; 
  (arg1)->setRotationOrder(arg2);
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1getRotationOrder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  RotateOrder result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  result = (RotateOrder)(arg1)->getRotationOrder();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setAxis(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  btVector3 *arg2 = 0 ;
  btVector3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  btVector3 local_arg3;
  gdx_setbtVector3FromVector3(jenv, local_arg3, jarg3);
  arg3 = &local_arg3;
  gdxAutoCommitVector3 auto_commit_arg3(jenv, jarg3, &local_arg3);
  (arg1)->setAxis((btVector3 const &)*arg2,(btVector3 const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setBounce(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setBounce(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1enableMotor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = jarg3 ? true : false; 
  (arg1)->enableMotor(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setServo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = jarg3 ? true : false; 
  (arg1)->setServo(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setTargetVelocity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setTargetVelocity(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setServoTarget(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setServoTarget(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setMaxMotorForce(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setMaxMotorForce(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1enableSpring(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = jarg3 ? true : false; 
  (arg1)->enableSpring(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setStiffness_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3, jboolean jarg4) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  bool arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = jarg4 ? true : false; 
  (arg1)->setStiffness(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setStiffness_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setStiffness(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setDamping_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3, jboolean jarg4) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  bool arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = jarg4 ? true : false; 
  (arg1)->setDamping(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setDamping_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setDamping(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setEquilibriumPoint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  (arg1)->setEquilibriumPoint();
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setEquilibriumPoint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setEquilibriumPoint(arg2);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setEquilibriumPoint_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setEquilibriumPoint(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setParam_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3, jint jarg4) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  arg4 = (int)jarg4; 
  (arg1)->setParam(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1setParam_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  btScalar arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (btScalar)jarg3; 
  (arg1)->setParam(arg2,arg3);
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1getParam_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jfloat jresult = 0 ;
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  int arg3 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (btScalar)((btGeneric6DofSpring2Constraint const *)arg1)->getParam(arg2,arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1getParam_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jfloat jresult = 0 ;
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  int arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (btScalar)((btGeneric6DofSpring2Constraint const *)arg1)->getParam(arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1btGetMatrixElem(JNIEnv *jenv, jclass jcls, jobject jarg1, jint jarg2) {
  jfloat jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  int arg2 ;
  btScalar result;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  arg2 = (int)jarg2; 
  result = (btScalar)btGeneric6DofSpring2Constraint::btGetMatrixElem((btMatrix3x3 const &)*arg1,arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1matrixToEulerXYZ(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jboolean jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (bool)btGeneric6DofSpring2Constraint::matrixToEulerXYZ((btMatrix3x3 const &)*arg1,*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1matrixToEulerXZY(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jboolean jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (bool)btGeneric6DofSpring2Constraint::matrixToEulerXZY((btMatrix3x3 const &)*arg1,*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1matrixToEulerYXZ(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jboolean jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (bool)btGeneric6DofSpring2Constraint::matrixToEulerYXZ((btMatrix3x3 const &)*arg1,*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1matrixToEulerYZX(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jboolean jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (bool)btGeneric6DofSpring2Constraint::matrixToEulerYZX((btMatrix3x3 const &)*arg1,*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1matrixToEulerZXY(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jboolean jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (bool)btGeneric6DofSpring2Constraint::matrixToEulerZXY((btMatrix3x3 const &)*arg1,*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2Constraint_1matrixToEulerZYX(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jboolean jresult = 0 ;
  btMatrix3x3 *arg1 = 0 ;
  btVector3 *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  btMatrix3x3 local_arg1;
  gdx_setbtMatrix3x3FromMatrix3(jenv, local_arg1, jarg1);
  arg1 = &local_arg1;
  gdxAutoCommitMatrix3 auto_commit_arg1(jenv, jarg1, &local_arg1);
  btVector3 local_arg2;
  gdx_setbtVector3FromVector3(jenv, local_arg2, jarg2);
  arg2 = &local_arg2;
  gdxAutoCommitVector3 auto_commit_arg2(jenv, jarg2, &local_arg2);
  result = (bool)btGeneric6DofSpring2Constraint::matrixToEulerZYX((btMatrix3x3 const &)*arg1,*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btGeneric6DofSpring2Constraint(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btGeneric6DofSpring2Constraint *arg1 = (btGeneric6DofSpring2Constraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btGeneric6DofSpring2Constraint **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1typeConstraintData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btTypedConstraintData *arg2 = (btTypedConstraintData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btTypedConstraintData **)&jarg2; 
  if (arg1) (arg1)->m_typeConstraintData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1typeConstraintData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btTypedConstraintData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btTypedConstraintData *)& ((arg1)->m_typeConstraintData);
  *(btTypedConstraintData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1rbAFrame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btTransformFloatData *arg2 = (btTransformFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btTransformFloatData **)&jarg2; 
  if (arg1) (arg1)->m_rbAFrame = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1rbAFrame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btTransformFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btTransformFloatData *)& ((arg1)->m_rbAFrame);
  *(btTransformFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1rbBFrame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btTransformFloatData *arg2 = (btTransformFloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btTransformFloatData **)&jarg2; 
  if (arg1) (arg1)->m_rbBFrame = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1rbBFrame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btTransformFloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btTransformFloatData *)& ((arg1)->m_rbBFrame);
  *(btTransformFloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearUpperLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_linearUpperLimit = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearUpperLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_linearUpperLimit);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearLowerLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_linearLowerLimit = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearLowerLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_linearLowerLimit);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearBounce_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_linearBounce = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearBounce_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_linearBounce);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearStopERP_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_linearStopERP = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearStopERP_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_linearStopERP);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearStopCFM_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_linearStopCFM = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearStopCFM_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_linearStopCFM);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearMotorERP_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_linearMotorERP = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearMotorERP_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_linearMotorERP);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearMotorCFM_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_linearMotorCFM = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearMotorCFM_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_linearMotorCFM);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearTargetVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_linearTargetVelocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearTargetVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_linearTargetVelocity);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearMaxMotorForce_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_linearMaxMotorForce = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearMaxMotorForce_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_linearMaxMotorForce);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearServoTarget_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_linearServoTarget = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearServoTarget_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_linearServoTarget);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearSpringStiffness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_linearSpringStiffness = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearSpringStiffness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_linearSpringStiffness);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearSpringDamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_linearSpringDamping = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearSpringDamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_linearSpringDamping);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearEquilibriumPoint_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_linearEquilibriumPoint = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearEquilibriumPoint_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_linearEquilibriumPoint);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearEnableMotor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_linearEnableMotor, (const char *)arg2, 4-1);
      arg1->m_linearEnableMotor[4-1] = 0;
    } else {
      arg1->m_linearEnableMotor[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearEnableMotor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_linearEnableMotor);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearServoMotor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_linearServoMotor, (const char *)arg2, 4-1);
      arg1->m_linearServoMotor[4-1] = 0;
    } else {
      arg1->m_linearServoMotor[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearServoMotor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_linearServoMotor);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearEnableSpring_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_linearEnableSpring, (const char *)arg2, 4-1);
      arg1->m_linearEnableSpring[4-1] = 0;
    } else {
      arg1->m_linearEnableSpring[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearEnableSpring_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_linearEnableSpring);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearSpringStiffnessLimited_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_linearSpringStiffnessLimited, (const char *)arg2, 4-1);
      arg1->m_linearSpringStiffnessLimited[4-1] = 0;
    } else {
      arg1->m_linearSpringStiffnessLimited[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearSpringStiffnessLimited_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_linearSpringStiffnessLimited);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearSpringDampingLimited_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_linearSpringDampingLimited, (const char *)arg2, 4-1);
      arg1->m_linearSpringDampingLimited[4-1] = 0;
    } else {
      arg1->m_linearSpringDampingLimited[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1linearSpringDampingLimited_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_linearSpringDampingLimited);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1padding1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_padding1, (const char *)arg2, 4-1);
      arg1->m_padding1[4-1] = 0;
    } else {
      arg1->m_padding1[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1padding1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_padding1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularUpperLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_angularUpperLimit = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularUpperLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_angularUpperLimit);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularLowerLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_angularLowerLimit = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularLowerLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_angularLowerLimit);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularBounce_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_angularBounce = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularBounce_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_angularBounce);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularStopERP_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_angularStopERP = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularStopERP_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_angularStopERP);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularStopCFM_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_angularStopCFM = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularStopCFM_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_angularStopCFM);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularMotorERP_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_angularMotorERP = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularMotorERP_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_angularMotorERP);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularMotorCFM_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_angularMotorCFM = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularMotorCFM_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_angularMotorCFM);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularTargetVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_angularTargetVelocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularTargetVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_angularTargetVelocity);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularMaxMotorForce_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_angularMaxMotorForce = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularMaxMotorForce_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_angularMaxMotorForce);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularServoTarget_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_angularServoTarget = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularServoTarget_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_angularServoTarget);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularSpringStiffness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_angularSpringStiffness = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularSpringStiffness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_angularSpringStiffness);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularSpringDamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_angularSpringDamping = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularSpringDamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_angularSpringDamping);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularEquilibriumPoint_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *arg2 = (btVector3FloatData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = *(btVector3FloatData **)&jarg2; 
  if (arg1) (arg1)->m_angularEquilibriumPoint = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularEquilibriumPoint_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  btVector3FloatData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (btVector3FloatData *)& ((arg1)->m_angularEquilibriumPoint);
  *(btVector3FloatData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularEnableMotor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_angularEnableMotor, (const char *)arg2, 4-1);
      arg1->m_angularEnableMotor[4-1] = 0;
    } else {
      arg1->m_angularEnableMotor[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularEnableMotor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_angularEnableMotor);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularServoMotor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_angularServoMotor, (const char *)arg2, 4-1);
      arg1->m_angularServoMotor[4-1] = 0;
    } else {
      arg1->m_angularServoMotor[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularServoMotor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_angularServoMotor);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularEnableSpring_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_angularEnableSpring, (const char *)arg2, 4-1);
      arg1->m_angularEnableSpring[4-1] = 0;
    } else {
      arg1->m_angularEnableSpring[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularEnableSpring_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_angularEnableSpring);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularSpringStiffnessLimited_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_angularSpringStiffnessLimited, (const char *)arg2, 4-1);
      arg1->m_angularSpringStiffnessLimited[4-1] = 0;
    } else {
      arg1->m_angularSpringStiffnessLimited[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularSpringStiffnessLimited_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_angularSpringStiffnessLimited);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularSpringDampingLimited_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_angularSpringDampingLimited, (const char *)arg2, 4-1);
      arg1->m_angularSpringDampingLimited[4-1] = 0;
    } else {
      arg1->m_angularSpringDampingLimited[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1angularSpringDampingLimited_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_angularSpringDampingLimited);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1rotateOrder_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->m_rotateOrder = arg2;
}


SWIGEXPORT jint JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintData_1rotateOrder_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  result = (int) ((arg1)->m_rotateOrder);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_new_1btGeneric6DofSpring2ConstraintData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (btGeneric6DofSpring2ConstraintData *)new btGeneric6DofSpring2ConstraintData();
  *(btGeneric6DofSpring2ConstraintData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_delete_1btGeneric6DofSpring2ConstraintData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  btGeneric6DofSpring2ConstraintData *arg1 = (btGeneric6DofSpring2ConstraintData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(btGeneric6DofSpring2ConstraintData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1typeConstraintData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btTypedConstraintDoubleData *arg2 = (btTypedConstraintDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btTypedConstraintDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_typeConstraintData = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1typeConstraintData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btTypedConstraintDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btTypedConstraintDoubleData *)& ((arg1)->m_typeConstraintData);
  *(btTypedConstraintDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1rbAFrame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btTransformDoubleData *arg2 = (btTransformDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btTransformDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_rbAFrame = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1rbAFrame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btTransformDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btTransformDoubleData *)& ((arg1)->m_rbAFrame);
  *(btTransformDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1rbBFrame_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btTransformDoubleData *arg2 = (btTransformDoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btTransformDoubleData **)&jarg2; 
  if (arg1) (arg1)->m_rbBFrame = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1rbBFrame_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btTransformDoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btTransformDoubleData *)& ((arg1)->m_rbBFrame);
  *(btTransformDoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearUpperLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_linearUpperLimit = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearUpperLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_linearUpperLimit);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearLowerLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_linearLowerLimit = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearLowerLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_linearLowerLimit);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearBounce_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_linearBounce = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearBounce_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_linearBounce);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearStopERP_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_linearStopERP = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearStopERP_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_linearStopERP);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearStopCFM_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_linearStopCFM = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearStopCFM_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_linearStopCFM);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearMotorERP_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_linearMotorERP = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearMotorERP_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_linearMotorERP);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearMotorCFM_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_linearMotorCFM = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearMotorCFM_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_linearMotorCFM);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearTargetVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_linearTargetVelocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearTargetVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_linearTargetVelocity);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearMaxMotorForce_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_linearMaxMotorForce = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearMaxMotorForce_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_linearMaxMotorForce);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearServoTarget_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_linearServoTarget = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearServoTarget_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_linearServoTarget);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearSpringStiffness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_linearSpringStiffness = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearSpringStiffness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_linearSpringStiffness);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearSpringDamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_linearSpringDamping = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearSpringDamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_linearSpringDamping);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearEquilibriumPoint_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_linearEquilibriumPoint = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearEquilibriumPoint_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_linearEquilibriumPoint);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearEnableMotor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_linearEnableMotor, (const char *)arg2, 4-1);
      arg1->m_linearEnableMotor[4-1] = 0;
    } else {
      arg1->m_linearEnableMotor[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearEnableMotor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_linearEnableMotor);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearServoMotor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_linearServoMotor, (const char *)arg2, 4-1);
      arg1->m_linearServoMotor[4-1] = 0;
    } else {
      arg1->m_linearServoMotor[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearServoMotor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_linearServoMotor);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearEnableSpring_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_linearEnableSpring, (const char *)arg2, 4-1);
      arg1->m_linearEnableSpring[4-1] = 0;
    } else {
      arg1->m_linearEnableSpring[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearEnableSpring_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_linearEnableSpring);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearSpringStiffnessLimited_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_linearSpringStiffnessLimited, (const char *)arg2, 4-1);
      arg1->m_linearSpringStiffnessLimited[4-1] = 0;
    } else {
      arg1->m_linearSpringStiffnessLimited[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearSpringStiffnessLimited_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_linearSpringStiffnessLimited);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearSpringDampingLimited_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_linearSpringDampingLimited, (const char *)arg2, 4-1);
      arg1->m_linearSpringDampingLimited[4-1] = 0;
    } else {
      arg1->m_linearSpringDampingLimited[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1linearSpringDampingLimited_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_linearSpringDampingLimited);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1padding1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_padding1, (const char *)arg2, 4-1);
      arg1->m_padding1[4-1] = 0;
    } else {
      arg1->m_padding1[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1padding1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_padding1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularUpperLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_angularUpperLimit = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularUpperLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_angularUpperLimit);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularLowerLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_angularLowerLimit = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularLowerLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_angularLowerLimit);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularBounce_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_angularBounce = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularBounce_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_angularBounce);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularStopERP_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_angularStopERP = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularStopERP_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_angularStopERP);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularStopCFM_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_angularStopCFM = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularStopCFM_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_angularStopCFM);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularMotorERP_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_angularMotorERP = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularMotorERP_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_angularMotorERP);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularMotorCFM_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_angularMotorCFM = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularMotorCFM_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_angularMotorCFM);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularTargetVelocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_angularTargetVelocity = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularTargetVelocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_angularTargetVelocity);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularMaxMotorForce_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_angularMaxMotorForce = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularMaxMotorForce_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_angularMaxMotorForce);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularServoTarget_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_angularServoTarget = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularServoTarget_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_angularServoTarget);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularSpringStiffness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_angularSpringStiffness = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularSpringStiffness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_angularSpringStiffness);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularSpringDamping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_angularSpringDamping = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularSpringDamping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_angularSpringDamping);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularEquilibriumPoint_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *arg2 = (btVector3DoubleData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = *(btVector3DoubleData **)&jarg2; 
  if (arg1) (arg1)->m_angularEquilibriumPoint = *arg2;
}


SWIGEXPORT jlong JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularEquilibriumPoint_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  btVector3DoubleData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (btVector3DoubleData *)& ((arg1)->m_angularEquilibriumPoint);
  *(btVector3DoubleData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularEnableMotor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_angularEnableMotor, (const char *)arg2, 4-1);
      arg1->m_angularEnableMotor[4-1] = 0;
    } else {
      arg1->m_angularEnableMotor[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularEnableMotor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_angularEnableMotor);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularServoMotor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  char *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if(arg2) {
      strncpy((char*)arg1->m_angularServoMotor, (const char *)arg2, 4-1);
      arg1->m_angularServoMotor[4-1] = 0;
    } else {
      arg1->m_angularServoMotor[0] = 0;
    }
  }
  
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_com_badlogic_gdx_physics_bullet_dynamics_DynamicsJNI_btGeneric6DofSpring2ConstraintDoubleData2_1angularServoMotor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  btGeneric6DofSpring2ConstraintDoubleData2 *arg1 = (btGeneric6DofSpring2ConstraintDoubleData2 *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(btGeneric6DofSpring2ConstraintDoubleData2 **)&jarg1; 
  result = (char *)(char *) ((arg1)->m_angularServoMotor);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jres