/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.controllers.lwjgl3;

import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.PovDirection;
import com.badlogic.gdx.controllers.lwjgl3.Lwjgl3ControllerManager;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.glfw.GLFW;

public class Lwjgl3Controller
implements Controller {
    final Lwjgl3ControllerManager manager;
    final Array<ControllerListener> listeners = new Array();
    final int index;
    final float[] axisState;
    final boolean[] buttonState;
    final Vector3 zero = new Vector3(0.0f, 0.0f, 0.0f);
    final String name;

    public Lwjgl3Controller(Lwjgl3ControllerManager manager, int index) {
        this.manager = manager;
        this.index = index;
        this.axisState = new float[GLFW.glfwGetJoystickAxes((int)index).limit()];
        this.buttonState = new boolean[GLFW.glfwGetJoystickButtons((int)index).limit()];
        this.name = GLFW.glfwGetJoystickName((int)index);
    }

    void pollState() {
        int i;
        if (!GLFW.glfwJoystickPresent((int)this.index)) {
            this.manager.disconnected(this);
            return;
        }
        FloatBuffer axes = GLFW.glfwGetJoystickAxes((int)this.index);
        if (axes == null) {
            this.manager.disconnected(this);
            return;
        }
        ByteBuffer buttons = GLFW.glfwGetJoystickButtons((int)this.index);
        if (buttons == null) {
            this.manager.disconnected(this);
            return;
        }
        for (i = 0; i < axes.limit(); ++i) {
            if (this.axisState[i] != axes.get(i)) {
                for (ControllerListener listener : this.listeners) {
                    listener.axisMoved((Controller)this, i, axes.get(i));
                }
                this.manager.axisChanged(this, i, axes.get(i));
            }
            this.axisState[i] = axes.get(i);
        }
        for (i = 0; i < buttons.limit(); ++i) {
            if (this.buttonState[i] != (buttons.get(i) == 1)) {
                for (ControllerListener listener : this.listeners) {
                    if (buttons.get(i) == 1) {
                        listener.buttonDown((Controller)this, i);
                        continue;
                    }
                    listener.buttonUp((Controller)this, i);
                }
                this.manager.buttonChanged(this, i, buttons.get(i) == 1);
            }
            this.buttonState[i] = buttons.get(i) == 1;
        }
    }

    public void addListener(ControllerListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(ControllerListener listener) {
        this.listeners.removeValue((Object)listener, true);
    }

    public boolean getButton(int buttonCode) {
        if (buttonCode < 0 || buttonCode >= this.buttonState.length) {
            return false;
        }
        return this.buttonState[buttonCode];
    }

    public float getAxis(int axisCode) {
        if (axisCode < 0 || axisCode >= this.axisState.length) {
            return 0.0f;
        }
        return this.axisState[axisCode];
    }

    public PovDirection getPov(int povCode) {
        return PovDirection.center;
    }

    public boolean getSliderX(int sliderCode) {
        return false;
    }

    public boolean getSliderY(int sliderCode) {
        return false;
    }

    public Vector3 getAccelerometer(int accelerometerCode) {
        return this.zero;
    }

    public void setAccelerometerSensitivity(float sensitivity) {
    }

    public String getName() {
        return this.name;
    }
}

