/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.controllers.lwjgl3;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.ControllerManager;
import com.badlogic.gdx.controllers.lwjgl3.Lwjgl3Controller;
import com.badlogic.gdx.utils.Array;
import org.lwjgl.glfw.GLFW;

public class Lwjgl3ControllerManager
implements ControllerManager {
    final Array<Controller> controllers = new Array();
    final Array<Controller> polledControllers = new Array();
    final Array<ControllerListener> listeners = new Array();

    public Lwjgl3ControllerManager() {
        for (int i = 0; i < 15; ++i) {
            if (!GLFW.glfwJoystickPresent((int)i)) continue;
            this.controllers.add((Object)new Lwjgl3Controller(this, i));
        }
        Gdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                Lwjgl3ControllerManager.this.pollState();
                Gdx.app.postRunnable((Runnable)this);
            }
        });
    }

    void pollState() {
        for (int i = 0; i < 15; ++i) {
            if (!GLFW.glfwJoystickPresent((int)i)) continue;
            boolean alreadyUsed = false;
            for (int j = 0; j < this.controllers.size; ++j) {
                if (((Lwjgl3Controller)this.controllers.get((int)j)).index != i) continue;
                alreadyUsed = true;
                break;
            }
            if (alreadyUsed) continue;
            Lwjgl3Controller controller = new Lwjgl3Controller(this, i);
            this.connected(controller);
        }
        this.polledControllers.addAll(this.controllers);
        for (Controller controller : this.polledControllers) {
            ((Lwjgl3Controller)controller).pollState();
        }
        this.polledControllers.clear();
    }

    public Array<Controller> getControllers() {
        return this.controllers;
    }

    public void addListener(ControllerListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(ControllerListener listener) {
        this.listeners.removeValue((Object)listener, true);
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    void connected(Lwjgl3Controller controller) {
        this.controllers.add((Object)controller);
        for (ControllerListener listener : this.listeners) {
            listener.connected((Controller)controller);
        }
    }

    void disconnected(Lwjgl3Controller controller) {
        this.controllers.removeValue((Object)controller, true);
        for (ControllerListener listener : this.listeners) {
            listener.disconnected((Controller)controller);
        }
    }

    void axisChanged(Lwjgl3Controller controller, int axisCode, float value) {
        for (ControllerListener listener : this.listeners) {
            listener.axisMoved((Controller)controller, axisCode, value);
        }
    }

    void buttonChanged(Lwjgl3Controller controller, int buttonCode, boolean value) {
        for (ControllerListener listener : this.listeners) {
            if (value) {
                listener.buttonDown((Controller)controller, buttonCode);
                continue;
            }
            listener.buttonUp((Controller)controller, buttonCode);
        }
    }

    public Array<ControllerListener> getListeners() {
        return this.listeners;
    }
}

