/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.gradle;

import com.badlogic.gdx.jnigen.BuildTarget;
import com.badlogic.gdx.jnigen.gradle.JnigenBuildTargetTask;
import com.badlogic.gdx.jnigen.gradle.JnigenIOSJarTask;
import com.badlogic.gdx.jnigen.gradle.JnigenJarTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;

public class JnigenExtension {
    public static final boolean x32 = false;
    public static final boolean x64 = true;
    public static final boolean ARM = true;
    public static final BuildTarget.TargetOs Windows = BuildTarget.TargetOs.Windows;
    public static final BuildTarget.TargetOs Linux = BuildTarget.TargetOs.Linux;
    public static final BuildTarget.TargetOs MacOsX = BuildTarget.TargetOs.MacOsX;
    public static final BuildTarget.TargetOs Android = BuildTarget.TargetOs.Android;
    public static final BuildTarget.TargetOs IOS = BuildTarget.TargetOs.IOS;
    final Project project;
    String subProjectDir;
    String sharedLibName = null;
    String temporaryDir = "target";
    String libsDir = "libs";
    String jniDir = "jni";
    boolean release = true;
    NativeCodeGeneratorConfig nativeCodeGeneratorConfig;
    ArrayList<BuildTarget> targets = new ArrayList();
    Action<BuildTarget> all = null;
    Task jarAndroidNatives = null;
    JnigenJarTask jarDesktopNatives = null;

    @Inject
    public JnigenExtension(Project project) {
        this.project = project;
        this.subProjectDir = project.getProjectDir().getAbsolutePath() + File.separator;
        this.nativeCodeGeneratorConfig = new NativeCodeGeneratorConfig(project, this.subProjectDir);
    }

    public void nativeCodeGenerator(Action<NativeCodeGeneratorConfig> container) {
        container.execute((Object)this.nativeCodeGeneratorConfig);
    }

    public void all(Action<BuildTarget> container) {
        this.all = container;
    }

    public void add(BuildTarget.TargetOs type) {
        this.add(type, false, false, null);
    }

    public void add(BuildTarget.TargetOs type, boolean is64Bit) {
        this.add(type, is64Bit, false, null);
    }

    public void add(BuildTarget.TargetOs type, boolean is64Bit, boolean isARM) {
        this.add(type, is64Bit, isARM, null);
    }

    public void add(BuildTarget.TargetOs type, Action<BuildTarget> container) {
        this.add(type, false, false, container);
    }

    public void add(BuildTarget.TargetOs type, boolean is64Bit, Action<BuildTarget> container) {
        this.add(type, is64Bit, false, container);
    }

    public void add(BuildTarget.TargetOs type, boolean is64Bit, boolean isARM, Action<BuildTarget> container) {
        String name = type + (isARM ? "ARM" : "") + (is64Bit ? "64" : "");
        if (this.get(type, is64Bit, isARM) != null) {
            throw new RuntimeException("Attempt to add duplicate build target " + name);
        }
        if ((type == Android || type == IOS) && (is64Bit || isARM)) {
            throw new RuntimeException("Android and iOS must not have is64Bit or isARM.");
        }
        BuildTarget target = BuildTarget.newDefaultTarget((BuildTarget.TargetOs)type, (boolean)is64Bit, (boolean)isARM);
        if (this.all != null) {
            this.all.execute((Object)target);
        }
        if (container != null) {
            container.execute((Object)target);
        }
        this.targets.add(target);
        Task jnigenTask = this.project.getTasks().getByName("jnigen");
        Task jnigenBuildTask = this.project.getTasks().getByName("jnigenBuild");
        Task builtTargetTask = this.project.getTasks().create("jnigenBuild" + name, JnigenBuildTargetTask.class, new Object[]{this, target});
        builtTargetTask.dependsOn(new Object[]{jnigenTask});
        if (!target.excludeFromMasterBuildFile && target.canBuild.getAsBoolean()) {
            jnigenBuildTask.dependsOn(new Object[]{builtTargetTask});
        }
        if (type == Android) {
            String[] abis;
            if (this.jarAndroidNatives == null) {
                this.jarAndroidNatives = this.project.getTasks().create("jnigenJarNativesAndroid");
                this.jarAndroidNatives.setGroup("jnigen");
                this.jarAndroidNatives.setDescription("Assembles all jar archives containing the native libraries for Android.");
            }
            if (Arrays.asList(abis = target.androidABIs).contains("all")) {
                ArrayList<String> tmp = new ArrayList<String>(Arrays.asList(abis));
                tmp.remove("all");
                tmp.add("armeabi");
                tmp.add("armeabi-v7a");
                tmp.add("x86");
                tmp.add("x86_64");
                tmp.add("arm64-v8a");
                abis = tmp.toArray(new String[tmp.size()]);
            }
            JnigenJarTask[] jarAndroidNativesABIs = new JnigenJarTask[abis.length];
            for (int i = 0; i < abis.length; ++i) {
                jarAndroidNativesABIs[i] = (JnigenJarTask)this.project.getTasks().create("jnigenJarNativesAndroid" + abis[i], JnigenJarTask.class, new Object[]{type});
                jarAndroidNativesABIs[i].add(target, this, abis[i]);
                this.jarAndroidNatives.dependsOn(new Object[]{jarAndroidNativesABIs[i]});
            }
        } else if (type == IOS) {
            JnigenIOSJarTask jarIOSNatives = (JnigenIOSJarTask)this.project.getTasks().create("jnigenJarNativesIOS", JnigenIOSJarTask.class);
            jarIOSNatives.add(target, this);
        } else {
            if (this.jarDesktopNatives == null) {
                this.jarDesktopNatives = (JnigenJarTask)this.project.getTasks().create("jnigenJarNativesDesktop", JnigenJarTask.class, new Object[]{type});
            }
            this.jarDesktopNatives.add(target, this);
        }
    }

    public BuildTarget get(BuildTarget.TargetOs type) {
        return this.get(type, false, false, null);
    }

    public BuildTarget get(BuildTarget.TargetOs type, boolean is64Bit) {
        return this.get(type, is64Bit, false, null);
    }

    public BuildTarget get(BuildTarget.TargetOs type, boolean is64Bit, boolean isARM) {
        return this.get(type, is64Bit, isARM, null);
    }

    public BuildTarget get(BuildTarget.TargetOs type, Action<BuildTarget> container) {
        return this.get(type, false, false, container);
    }

    public BuildTarget get(BuildTarget.TargetOs type, boolean is64Bit, Action<BuildTarget> container) {
        return this.get(type, is64Bit, false, container);
    }

    public BuildTarget get(BuildTarget.TargetOs type, boolean is64Bit, boolean isARM, Action<BuildTarget> container) {
        for (BuildTarget target : this.targets) {
            if (target.os != type || target.is64Bit != is64Bit || target.isARM != isARM) continue;
            if (container != null) {
                container.execute((Object)target);
            }
            return target;
        }
        return null;
    }

    public void each(Predicate<BuildTarget> condition, Action<BuildTarget> container) {
        for (BuildTarget target : this.targets) {
            if (!condition.test(target)) continue;
            container.execute((Object)target);
        }
    }

    class NativeCodeGeneratorConfig {
        String sourceDir;
        String classpath;
        String jniDir = "jni";
        String[] includes = null;
        String[] excludes = null;
        boolean multipleSourceSetDirs = false;

        public NativeCodeGeneratorConfig(Project project, String subProjectDir) {
            JavaPluginConvention javaPlugin = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
            SourceSetContainer sourceSets = javaPlugin.getSourceSets();
            SourceSet main = (SourceSet)sourceSets.findByName("main");
            this.classpath = main.getRuntimeClasspath().getAsPath();
            Set javaSrcDirs = main.getJava().getSrcDirs();
            if (javaSrcDirs.size() == 1) {
                for (File srcDir : javaSrcDirs) {
                    this.sourceDir = srcDir.getPath();
                }
            } else {
                this.multipleSourceSetDirs = true;
            }
        }

        public String toString() {
            return "NativeCodeGeneratorConfig[sourceDir=`" + this.sourceDir + "`, classpath=`" + this.classpath + "`, jniDir=`" + this.jniDir + "`, includes=`" + (this.includes == null ? "null" : Arrays.toString(this.includes)) + "`, excludes=`" + (this.includes == null ? "null" : Arrays.toString(this.excludes)) + "`]";
        }
    }
}

