/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.gradle;

import com.badlogic.gdx.jnigen.AntScriptGenerator;
import com.badlogic.gdx.jnigen.BuildConfig;
import com.badlogic.gdx.jnigen.BuildTarget;
import com.badlogic.gdx.jnigen.NativeCodeGenerator;
import com.badlogic.gdx.jnigen.gradle.JnigenExtension;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JnigenTask
extends DefaultTask {
    private static final Logger log = LoggerFactory.getLogger(JnigenTask.class);
    JnigenExtension ext;

    @Inject
    public JnigenTask(JnigenExtension ext) {
        this.ext = ext;
        this.setGroup("jnigen");
        this.setDescription("Generates jnigen native code files and build scripts.");
    }

    @TaskAction
    public void run() {
        if (this.ext.sharedLibName == null) {
            log.error("sharedLibName must be defined");
            throw new RuntimeException("sharedLibName must be defined");
        }
        log.debug("subProjectDir " + this.ext.subProjectDir);
        log.debug("sharedLibName " + this.ext.sharedLibName);
        log.debug("nativeCodeGeneratorConfig " + this.ext.nativeCodeGeneratorConfig);
        try {
            if (this.ext.nativeCodeGeneratorConfig.multipleSourceSetDirs && this.ext.nativeCodeGeneratorConfig.sourceDir == null) {
                log.error("Multiple java SrcDirs detected. Please manually specify nativeCodeGenerator { sourceDir = \"\"}");
                throw new RuntimeException("Multiple java SrcDirs detected. Please manually specify nativeCodeGenerator { sourceDir = \"\"}");
            }
            String absoluteSourceDir = this.ext.nativeCodeGeneratorConfig.sourceDir;
            if (!absoluteSourceDir.startsWith(this.ext.subProjectDir)) {
                absoluteSourceDir = this.ext.subProjectDir + this.ext.nativeCodeGeneratorConfig.sourceDir;
            }
            new NativeCodeGenerator().generate(absoluteSourceDir, this.ext.nativeCodeGeneratorConfig.classpath, this.ext.subProjectDir + this.ext.nativeCodeGeneratorConfig.jniDir, this.ext.nativeCodeGeneratorConfig.includes, this.ext.nativeCodeGeneratorConfig.excludes);
        }
        catch (Exception e) {
            throw new RuntimeException("NativeCodeGenerator threw exception", e);
        }
        BuildConfig buildConfig = new BuildConfig(this.ext.sharedLibName, this.ext.temporaryDir, this.ext.libsDir, this.ext.subProjectDir + this.ext.jniDir);
        new AntScriptGenerator().generate(buildConfig, this.ext.targets.toArray(new BuildTarget[0]));
    }
}

