/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.gradle;

import com.badlogic.gdx.jnigen.BuildExecutor;
import com.badlogic.gdx.jnigen.BuildTarget;
import com.badlogic.gdx.jnigen.gradle.JnigenExtension;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;

public class JnigenBuildTargetTask
extends DefaultTask {
    JnigenExtension ext;
    BuildTarget target;

    @Inject
    public JnigenBuildTargetTask(JnigenExtension ext, BuildTarget target) {
        this.ext = ext;
        this.target = target;
        this.setGroup("jnigen");
        this.setDescription("Executes all jnigen build script for build target " + target.getTargetFolder() + ".");
    }

    @TaskAction
    public void run() {
        boolean verbose = this.getProject().findProperty("VERBOSE") != null;
        String[] stringArray = new String[4];
        stringArray[0] = "-Drelease=" + this.ext.release;
        stringArray[1] = "clean";
        stringArray[2] = "postcompile";
        String string = stringArray[3] = verbose ? "-v" : "";
        if (!BuildExecutor.executeAnt((String)new File(this.ext.subProjectDir + this.ext.jniDir, this.target.getBuildFilename()).getPath(), (String[])stringArray)) {
            throw new RuntimeException("Ant execution for " + this.target.getBuildFilename() + " failed.");
        }
    }
}

