/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.gradle;

import com.badlogic.gdx.jnigen.BuildTarget;
import com.badlogic.gdx.jnigen.gradle.JnigenBuildTargetTask;
import com.badlogic.gdx.jnigen.gradle.JnigenGenerateRoboVMXml;
import com.badlogic.gdx.jnigen.gradle.JnigenIOSJarTask;
import com.badlogic.gdx.jnigen.gradle.JnigenJarTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JnigenExtension {
    private static final Logger log = LoggerFactory.getLogger(JnigenExtension.class);
    public static final boolean x32 = false;
    public static final boolean x64 = true;
    public static final boolean ARM = true;
    public static final BuildTarget.TargetOs Windows = BuildTarget.TargetOs.Windows;
    public static final BuildTarget.TargetOs Linux = BuildTarget.TargetOs.Linux;
    public static final BuildTarget.TargetOs MacOsX = BuildTarget.TargetOs.MacOsX;
    public static final BuildTarget.TargetOs Android = BuildTarget.TargetOs.Android;
    public static final BuildTarget.TargetOs IOS = BuildTarget.TargetOs.IOS;
    final Project project;
    String subProjectDir;
    String sharedLibName = null;
    String temporaryDir = "target";
    String libsDir = "libs";
    String jniDir = "jni";
    boolean release = true;
    NativeCodeGeneratorConfig nativeCodeGeneratorConfig;
    List<BuildTarget> targets = new ArrayList<BuildTarget>();
    Action<BuildTarget> all = null;
    Task jarAndroidNatives = null;
    JnigenJarTask jarDesktopNatives = null;
    RoboVMXml robovm = new RoboVMXml();

    @Inject
    public JnigenExtension(Project project) {
        this.project = project;
        this.subProjectDir = project.getProjectDir().getAbsolutePath() + File.separator;
        this.nativeCodeGeneratorConfig = new NativeCodeGeneratorConfig(project, this.subProjectDir);
    }

    public void nativeCodeGenerator(Action<NativeCodeGeneratorConfig> container) {
        container.execute((Object)this.nativeCodeGeneratorConfig);
    }

    public void all(Action<BuildTarget> container) {
        this.all = container;
    }

    public void robovm(Action<RoboVMXml> action) {
        action.execute((Object)this.robovm);
    }

    public void add(BuildTarget.TargetOs type) {
        this.add(type, false, false, null);
    }

    public void add(BuildTarget.TargetOs type, boolean is64Bit) {
        this.add(type, is64Bit, false, null);
    }

    public void add(BuildTarget.TargetOs type, boolean is64Bit, boolean isARM) {
        this.add(type, is64Bit, isARM, null);
    }

    public void add(BuildTarget.TargetOs type, Action<BuildTarget> container) {
        this.add(type, false, false, container);
    }

    public void add(BuildTarget.TargetOs type, boolean is64Bit, Action<BuildTarget> container) {
        this.add(type, is64Bit, false, container);
    }

    public void add(BuildTarget.TargetOs type, boolean is64Bit, boolean isARM, Action<BuildTarget> container) {
        String name = type + (isARM ? "ARM" : "") + (is64Bit ? "64" : "");
        if (this.get(type, is64Bit, isARM) != null) {
            throw new RuntimeException("Attempt to add duplicate build target " + name);
        }
        if ((type == Android || type == IOS) && (is64Bit || isARM)) {
            throw new RuntimeException("Android and iOS must not have is64Bit or isARM.");
        }
        BuildTarget target = BuildTarget.newDefaultTarget((BuildTarget.TargetOs)type, (boolean)is64Bit, (boolean)isARM);
        if (this.all != null) {
            this.all.execute((Object)target);
        }
        if (container != null) {
            container.execute((Object)target);
        }
        this.targets.add(target);
        Task jnigenTask = this.project.getTasks().getByName("jnigen");
        Task jnigenBuildTask = this.project.getTasks().getByName("jnigenBuild");
        Task builtTargetTask = this.project.getTasks().create("jnigenBuild" + name, JnigenBuildTargetTask.class, new Object[]{this, target});
        builtTargetTask.dependsOn(new Object[]{jnigenTask});
        if (!target.excludeFromMasterBuildFile && target.canBuild.getAsBoolean()) {
            jnigenBuildTask.dependsOn(new Object[]{builtTargetTask});
        }
        if (type == Android) {
            String[] abis;
            if (this.jarAndroidNatives == null) {
                this.jarAndroidNatives = this.project.getTasks().create("jnigenJarNativesAndroid");
                this.jarAndroidNatives.setGroup("jnigen");
                this.jarAndroidNatives.setDescription("Assembles all jar archives containing the native libraries for Android.");
            }
            if (Arrays.asList(abis = target.androidABIs).contains("all")) {
                ArrayList<String> tmp = new ArrayList<String>(Arrays.asList(abis));
                tmp.remove("all");
                tmp.add("armeabi");
                tmp.add("armeabi-v7a");
                tmp.add("x86");
                tmp.add("x86_64");
                tmp.add("arm64-v8a");
                abis = tmp.toArray(new String[tmp.size()]);
            }
            JnigenJarTask[] jarAndroidNativesABIs = new JnigenJarTask[abis.length];
            for (int i = 0; i < abis.length; ++i) {
                jarAndroidNativesABIs[i] = (JnigenJarTask)this.project.getTasks().create("jnigenJarNativesAndroid" + abis[i], JnigenJarTask.class, new Object[]{type});
                jarAndroidNativesABIs[i].add(target, this, abis[i]);
                this.jarAndroidNatives.dependsOn(new Object[]{jarAndroidNativesABIs[i]});
            }
        } else if (type == IOS) {
            JnigenGenerateRoboVMXml generateRoboVMXml = (JnigenGenerateRoboVMXml)this.project.getTasks().create("jnigenGenerateRoboVMXml", JnigenGenerateRoboVMXml.class, new Object[]{this});
            JnigenIOSJarTask jarIOSNatives = (JnigenIOSJarTask)this.project.getTasks().create("jnigenJarNativesIOS", JnigenIOSJarTask.class);
            jarIOSNatives.add(target, this);
            jarIOSNatives.dependsOn(new Object[]{generateRoboVMXml});
        } else {
            if (this.jarDesktopNatives == null) {
                this.jarDesktopNatives = (JnigenJarTask)this.project.getTasks().create("jnigenJarNativesDesktop", JnigenJarTask.class, new Object[]{type});
            }
            this.jarDesktopNatives.add(target, this);
        }
    }

    public BuildTarget get(BuildTarget.TargetOs type) {
        return this.get(type, false, false, null);
    }

    public BuildTarget get(BuildTarget.TargetOs type, boolean is64Bit) {
        return this.get(type, is64Bit, false, null);
    }

    public BuildTarget get(BuildTarget.TargetOs type, boolean is64Bit, boolean isARM) {
        return this.get(type, is64Bit, isARM, null);
    }

    public BuildTarget get(BuildTarget.TargetOs type, Action<BuildTarget> container) {
        return this.get(type, false, false, container);
    }

    public BuildTarget get(BuildTarget.TargetOs type, boolean is64Bit, Action<BuildTarget> container) {
        return this.get(type, is64Bit, false, container);
    }

    public BuildTarget get(BuildTarget.TargetOs type, boolean is64Bit, boolean isARM, Action<BuildTarget> container) {
        for (BuildTarget target : this.targets) {
            if (target.os != type || target.is64Bit != is64Bit || target.isARM != isARM) continue;
            if (container != null) {
                container.execute((Object)target);
            }
            return target;
        }
        return null;
    }

    public void each(Predicate<BuildTarget> condition, Action<BuildTarget> container) {
        for (BuildTarget target : this.targets) {
            if (!condition.test(target)) continue;
            container.execute((Object)target);
        }
    }

    class RoboVMXml {
        private File manualFile = null;
        private List<String> forceLinkClasses = new ArrayList<String>();
        private List<RoboVMXmlLib> extraLibs = new ArrayList<RoboVMXmlLib>();

        RoboVMXml() {
        }

        public File getManualFile() {
            return this.manualFile;
        }

        public List<String> getForceLinkClasses() {
            return this.forceLinkClasses;
        }

        public List<RoboVMXmlLib> getExtraLibs() {
            return this.extraLibs;
        }

        public void manualFile(File manualFile) {
            if (!this.forceLinkClasses.isEmpty() || !this.extraLibs.isEmpty()) {
                throw new RuntimeException("robovm cannot use both manualFile and gradle overrides");
            }
            this.manualFile = manualFile;
        }

        public void forceLinkClasses(String[] forceLinkClasses) {
            if (this.manualFile != null) {
                throw new RuntimeException("robovm cannot use both manualFile and gradle overrides");
            }
            this.forceLinkClasses.addAll(Arrays.asList(forceLinkClasses));
        }

        public void extraLib(String path) {
            if (this.manualFile != null) {
                throw new RuntimeException("robovm cannot use both manualFile and gradle overrides");
            }
            this.extraLibs.add(new RoboVMXmlLib(path, null));
        }

        public void extraLib(String path, String variant) {
            if (this.manualFile != null) {
                throw new RuntimeException("robovm cannot use both manualFile and gradle overrides");
            }
            this.extraLibs.add(new RoboVMXmlLib(path, variant));
        }

        class RoboVMXmlLib {
            String path;
            String variant;

            public RoboVMXmlLib(String path, String variant) {
                this.path = path;
                this.variant = variant;
            }
        }
    }

    class NativeCodeGeneratorConfig {
        SourceSet sourceSet;
        private String sourceDir;
        String jniDir = "jni";
        String[] includes = null;
        String[] excludes = null;

        public NativeCodeGeneratorConfig(Project project, String subProjectDir) {
            JavaPluginConvention javaPlugin = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
            SourceSetContainer sourceSets = javaPlugin.getSourceSets();
            this.sourceSet = (SourceSet)sourceSets.findByName("main");
        }

        public String toString() {
            return "NativeCodeGeneratorConfig[sourceDir=`" + this.sourceDir + "`, sourceSet=`" + this.sourceSet + "`, jniDir=`" + this.jniDir + "`, includes=`" + Arrays.toString(this.includes) + "`, excludes=`" + Arrays.toString(this.excludes) + "`]";
        }

        public void setSourceDir(String sourceDir) {
            this.sourceDir = sourceDir;
        }

        public String getSourceDir() {
            if (this.sourceDir != null) {
                return this.sourceDir;
            }
            Set javaSrcDirs = this.sourceSet.getJava().getSrcDirs();
            if (javaSrcDirs.size() == 1) {
                for (File srcDir : javaSrcDirs) {
                    this.sourceDir = srcDir.getPath();
                }
            } else {
                log.error("Multiple java SrcDirs detected. Please manually specify nativeCodeGenerator { sourceDir = \"\"}");
                throw new RuntimeException("Multiple java SrcDirs detected. Please manually specify nativeCodeGenerator { sourceDir = \"\"}");
            }
            return this.sourceDir;
        }
    }
}

