/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.gradle;

import com.badlogic.gdx.jnigen.BuildTarget;
import com.badlogic.gdx.jnigen.gradle.JnigenExtension;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.tasks.bundling.Jar;

public class JnigenJarTask
extends Jar {
    @Inject
    public JnigenJarTask(BuildTarget.TargetOs os) {
        switch (os) {
            case Android: {
                this.getArchiveClassifier().set((Object)"natives-android");
                break;
            }
            case IOS: {
                this.getArchiveClassifier().set((Object)"natives-ios");
                break;
            }
            default: {
                this.getArchiveClassifier().set((Object)"natives-desktop");
            }
        }
        this.setGroup("jnigen");
        this.setDescription("Assembles a jar archive containing the native libraries.");
    }

    public final void add(BuildTarget target, JnigenExtension ext) {
        this.add(target, ext, null);
    }

    public void add(BuildTarget target, JnigenExtension ext, String abi) {
        String targetFolder = target.getTargetFolder();
        if (abi != null && !abi.isEmpty()) {
            targetFolder = abi;
            this.getArchiveClassifier().set((Object)("natives-" + abi));
        }
        String path = ext.subProjectDir + ext.libsDir + File.separatorChar + targetFolder + File.separatorChar + target.getSharedLibFilename(ext.sharedLibName);
        this.from(new Object[]{path});
    }
}

