/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.gradle;

import com.badlogic.gdx.jnigen.BuildTarget;
import com.badlogic.gdx.jnigen.gradle.JnigenExtension;
import com.badlogic.gdx.jnigen.gradle.JnigenJarTask;
import java.io.File;

public class JnigenIOSJarTask
extends JnigenJarTask {
    public JnigenIOSJarTask() {
        super(BuildTarget.TargetOs.IOS);
    }

    @Override
    public void add(BuildTarget target, JnigenExtension ext, String abi) {
        String targetFolder = target.getTargetFolder();
        String path = ext.subProjectDir + ext.libsDir + File.separatorChar + targetFolder;
        this.from(path, copySpec -> {
            copySpec.include(new String[]{"**/*.xcframework/"});
            copySpec.include(new String[]{"**/*.framework/"});
            copySpec.include(new String[]{"**/*.a"});
            copySpec.into((Object)"META-INF/robovm/ios/libs");
        });
        File robovmXml = new File(this.getProject().getBuildDir(), "robovm.xml");
        this.from(robovmXml, copySpec -> {
            copySpec.into((Object)"META-INF/robovm/ios");
            copySpec.rename(".*", "robovm.xml");
        });
    }
}

