/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.gradle;

import com.badlogic.gdx.jnigen.BuildTarget;
import com.badlogic.gdx.jnigen.gradle.JnigenBuildTargetTask;
import com.badlogic.gdx.jnigen.gradle.JnigenGenerateRoboVMXml;
import com.badlogic.gdx.jnigen.gradle.JnigenIOSJarTask;
import com.badlogic.gdx.jnigen.gradle.JnigenJarTask;
import com.badlogic.gdx.utils.Architecture;
import com.badlogic.gdx.utils.Os;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JnigenExtension {
    private static final Logger log = LoggerFactory.getLogger(JnigenExtension.class);
    public static final Architecture.Bitness x32 = Architecture.Bitness._32;
    public static final Architecture.Bitness x64 = Architecture.Bitness._64;
    public static final Architecture.Bitness x128 = Architecture.Bitness._128;
    public static final Architecture x86 = Architecture.x86;
    public static final Architecture ARM = Architecture.ARM;
    public static final Architecture RISCV = Architecture.RISCV;
    public static final Architecture LOONGARCH = Architecture.LOONGARCH;
    public static final Os Windows = Os.Windows;
    public static final Os Linux = Os.Linux;
    public static final Os MacOsX = Os.MacOsX;
    public static final Os Android = Os.Android;
    public static final Os IOS = Os.IOS;
    final Project project;
    String subProjectDir;
    String sharedLibName = null;
    String temporaryDir = "target";
    String libsDir = "libs";
    String jniDir = "jni";
    boolean release = true;
    NativeCodeGeneratorConfig nativeCodeGeneratorConfig;
    List<BuildTarget> targets = new ArrayList<BuildTarget>();
    Action<BuildTarget> all = null;
    Task jarAndroidNatives = null;
    JnigenJarTask jarDesktopNatives = null;
    RoboVMXml robovm = new RoboVMXml();

    @Inject
    public JnigenExtension(Project project) {
        this.project = project;
        this.subProjectDir = project.getProjectDir().getAbsolutePath() + File.separator;
        this.nativeCodeGeneratorConfig = new NativeCodeGeneratorConfig(project, this.subProjectDir);
    }

    public void nativeCodeGenerator(Action<NativeCodeGeneratorConfig> container) {
        container.execute((Object)this.nativeCodeGeneratorConfig);
    }

    public void all(Action<BuildTarget> container) {
        this.all = container;
    }

    public void robovm(Action<RoboVMXml> action) {
        action.execute((Object)this.robovm);
    }

    public void add(Os type) {
        this.add(type, Architecture.Bitness._32);
    }

    public void add(Os type, Architecture.Bitness bitness) {
        this.add(type, bitness, Architecture.x86);
    }

    public void add(Os type, Architecture.Bitness bitness, Architecture architecture) {
        this.add(type, bitness, architecture, null);
    }

    @Deprecated
    public void add(Os type, boolean is64Bit) {
        this.add(type, is64Bit, false, null);
    }

    @Deprecated
    public void add(Os type, boolean is64Bit, boolean isARM) {
        this.add(type, is64Bit, isARM, null);
    }

    public void add(Os type, Action<BuildTarget> container) {
        this.add(type, Architecture.Bitness._32, Architecture.x86, container);
    }

    @Deprecated
    public void add(Os type, boolean is64Bit, Action<BuildTarget> container) {
        this.add(type, is64Bit, false, container);
    }

    public void add(Os type, Architecture.Bitness bitness, Action<BuildTarget> container) {
        this.add(type, bitness, Architecture.x86, container);
    }

    @Deprecated
    public void add(Os type, boolean is64Bit, boolean isARM, Action<BuildTarget> container) {
        this.add(type, is64Bit ? Architecture.Bitness._64 : Architecture.Bitness._32, isARM ? Architecture.ARM : Architecture.x86, container);
    }

    public void add(Os type, Architecture.Bitness bitness, Architecture architecture, Action<BuildTarget> container) {
        String name = type + architecture.toSuffix().toUpperCase() + bitness.toSuffix();
        if (this.get(type, bitness, architecture) != null) {
            throw new RuntimeException("Attempt to add duplicate build target " + name);
        }
        if ((type == Android || type == IOS) && bitness != Architecture.Bitness._32 && architecture != Architecture.x86) {
            throw new RuntimeException("Android and iOS must not have is64Bit or isARM or isRISCV.");
        }
        BuildTarget target = BuildTarget.newDefaultTarget((Os)type, (Architecture.Bitness)bitness, (Architecture)architecture);
        if (this.all != null) {
            this.all.execute((Object)target);
        }
        if (container != null) {
            container.execute((Object)target);
        }
        this.targets.add(target);
        Task jnigenTask = this.project.getTasks().getByName("jnigen");
        Task jnigenBuildTask = this.project.getTasks().getByName("jnigenBuild");
        Task builtTargetTask = this.project.getTasks().create("jnigenBuild" + name, JnigenBuildTargetTask.class, new Object[]{this, target});
        builtTargetTask.dependsOn(new Object[]{jnigenTask});
        if (!target.excludeFromMasterBuildFile && target.canBuild.getAsBoolean()) {
            jnigenBuildTask.dependsOn(new Object[]{builtTargetTask});
        }
        if (type == Android) {
            String[] abis;
            if (this.jarAndroidNatives == null) {
                this.jarAndroidNatives = this.project.getTasks().create("jnigenJarNativesAndroid");
                this.jarAndroidNatives.setGroup("jnigen");
                this.jarAndroidNatives.setDescription("Assembles all jar archives containing the native libraries for Android.");
            }
            if (Arrays.asList(abis = target.androidABIs).contains("all")) {
                ArrayList<String> tmp = new ArrayList<String>(Arrays.asList(abis));
                tmp.remove("all");
                tmp.add("armeabi");
                tmp.add("armeabi-v7a");
                tmp.add("x86");
                tmp.add("x86_64");
                tmp.add("arm64-v8a");
                abis = tmp.toArray(new String[tmp.size()]);
            }
            JnigenJarTask[] jarAndroidNativesABIs = new JnigenJarTask[abis.length];
            for (int i = 0; i < abis.length; ++i) {
                jarAndroidNativesABIs[i] = (JnigenJarTask)this.project.getTasks().create("jnigenJarNativesAndroid" + abis[i], JnigenJarTask.class, new Object[]{type});
                jarAndroidNativesABIs[i].add(target, this, abis[i]);
                this.jarAndroidNatives.dependsOn(new Object[]{jarAndroidNativesABIs[i]});
            }
        } else if (type == IOS) {
            JnigenGenerateRoboVMXml generateRoboVMXml = (JnigenGenerateRoboVMXml)this.project.getTasks().create("jnigenGenerateRoboVMXml", JnigenGenerateRoboVMXml.class, new Object[]{this});
            JnigenIOSJarTask jarIOSNatives = (JnigenIOSJarTask)this.project.getTasks().create("jnigenJarNativesIOS", JnigenIOSJarTask.class);
            jarIOSNatives.add(target, this);
            jarIOSNatives.dependsOn(new Object[]{generateRoboVMXml});
        } else {
            if (this.jarDesktopNatives == null) {
                this.jarDesktopNatives = (JnigenJarTask)this.project.getTasks().create("jnigenJarNativesDesktop", JnigenJarTask.class, new Object[]{type});
            }
            this.jarDesktopNatives.add(target, this);
        }
    }

    public BuildTarget get(Os type) {
        return this.get(type, Architecture.Bitness._32, Architecture.x86, null);
    }

    public BuildTarget get(Os type, Architecture.Bitness bitness) {
        return this.get(type, bitness, Architecture.x86);
    }

    @Deprecated
    public BuildTarget get(Os type, boolean is64Bit) {
        return this.get(type, is64Bit, false, null);
    }

    @Deprecated
    public BuildTarget get(Os type, boolean is64Bit, boolean isARM) {
        return this.get(type, is64Bit, isARM, null);
    }

    public BuildTarget get(Os type, Architecture.Bitness bitness, Architecture architecture) {
        return this.get(type, bitness, architecture, null);
    }

    public BuildTarget get(Os type, Action<BuildTarget> container) {
        return this.get(type, Architecture.Bitness._32, Architecture.x86, container);
    }

    @Deprecated
    public BuildTarget get(Os type, boolean is64Bit, Action<BuildTarget> container) {
        return this.get(type, is64Bit, false, container);
    }

    @Deprecated
    public BuildTarget get(Os type, boolean is64Bit, boolean isARM, Action<BuildTarget> container) {
        return this.get(type, is64Bit ? Architecture.Bitness._64 : Architecture.Bitness._32, isARM ? Architecture.ARM : Architecture.x86, container);
    }

    public BuildTarget get(Os type, Architecture.Bitness bitness, Architecture architecture, Action<BuildTarget> container) {
        for (BuildTarget target : this.targets) {
            if (target.os != type || target.bitness != bitness || target.architecture != architecture) continue;
            if (container != null) {
                container.execute((Object)target);
            }
            return target;
        }
        return null;
    }

    public void each(Predicate<BuildTarget> condition, Action<BuildTarget> container) {
        for (BuildTarget target : this.targets) {
            if (!condition.test(target)) continue;
            container.execute((Object)target);
        }
    }

    class RoboVMXml {
        private File manualFile = null;
        private List<String> forceLinkClasses = new ArrayList<String>();
        private List<RoboVMXmlLib> extraLibs = new ArrayList<RoboVMXmlLib>();
        private List<String> extraXCFrameworks = new ArrayList<String>();

        RoboVMXml() {
        }

        public File getManualFile() {
            return this.manualFile;
        }

        public List<String> getForceLinkClasses() {
            return this.forceLinkClasses;
        }

        public List<RoboVMXmlLib> getExtraLibs() {
            return this.extraLibs;
        }

        public List<String> getExtraXCFrameworks() {
            return this.extraXCFrameworks;
        }

        public void manualFile(File manualFile) {
            if (!this.forceLinkClasses.isEmpty() || !this.extraLibs.isEmpty()) {
                throw new RuntimeException("robovm cannot use both manualFile and gradle overrides");
            }
            this.manualFile = manualFile;
        }

        public void forceLinkClasses(String[] forceLinkClasses) {
            if (this.manualFile != null) {
                throw new RuntimeException("robovm cannot use both manualFile and gradle overrides");
            }
            this.forceLinkClasses.addAll(Arrays.asList(forceLinkClasses));
        }

        public void extraLib(String path) {
            if (this.manualFile != null) {
                throw new RuntimeException("robovm cannot use both manualFile and gradle overrides");
            }
            this.extraLibs.add(new RoboVMXmlLib(path, null));
        }

        public void extraLib(String path, String variant) {
            if (this.manualFile != null) {
                throw new RuntimeException("robovm cannot use both manualFile and gradle overrides");
            }
            this.extraLibs.add(new RoboVMXmlLib(path, variant));
        }

        public void extraXCFramework(String path) {
            if (this.manualFile != null) {
                throw new RuntimeException("robovm cannot use both manualFile and gradle overrides");
            }
            this.extraXCFrameworks.add(path);
        }

        class RoboVMXmlLib {
            String path;
            String variant;

            public RoboVMXmlLib(String path, String variant) {
                this.path = path;
                this.variant = variant;
            }
        }
    }

    class NativeCodeGeneratorConfig {
        SourceSet sourceSet;
        private String[] sourceDirs;
        String jniDir = "jni";
        String[] includes = null;
        String[] excludes = null;

        public NativeCodeGeneratorConfig(Project project, String subProjectDir) {
            JavaPluginConvention javaPlugin = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
            SourceSetContainer sourceSets = javaPlugin.getSourceSets();
            this.sourceSet = (SourceSet)sourceSets.findByName("main");
        }

        public String toString() {
            return "NativeCodeGeneratorConfig[sourceDir=`" + Arrays.toString(this.sourceDirs) + "`, sourceSet=`" + this.sourceSet + "`, jniDir=`" + this.jniDir + "`, includes=`" + Arrays.toString(this.includes) + "`, excludes=`" + Arrays.toString(this.excludes) + "`]";
        }

        @Deprecated
        public void setSourceDir(String sourceDir) {
            this.sourceDirs = new String[]{sourceDir};
        }

        public void setSourceDirs(String[] sourceDirs) {
            this.sourceDirs = sourceDirs;
        }

        public String[] getSourceDirs() {
            if (this.sourceDirs != null) {
                return this.sourceDirs;
            }
            this.sourceDirs = (String[])this.sourceSet.getJava().getSrcDirs().stream().map(File::getPath).toArray(String[]::new);
            return this.sourceDirs;
        }
    }
}

