/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.parsing;

import java.util.ArrayList;

public interface JavaMethodParser {
    public ArrayList<JavaSegment> parse(String var1) throws Exception;

    public static class JavaMethod
    implements JavaSegment {
        private final String className;
        private final String name;
        private final boolean isStatic;
        private boolean isManual;
        private final String returnType;
        private String nativeCode;
        private final ArrayList<Argument> arguments;
        private final boolean hasDisposableArgument;
        private final int startIndex;
        private final int endIndex;

        public JavaMethod(String className, String name, boolean isStatic, String returnType, String nativeCode, ArrayList<Argument> arguments, int startIndex, int endIndex) {
            this.className = className;
            this.name = name;
            this.isStatic = isStatic;
            this.returnType = returnType;
            this.nativeCode = nativeCode;
            this.arguments = arguments;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            for (Argument arg : arguments) {
                if (!arg.type.isPrimitiveArray() && !arg.type.isBuffer() && !arg.type.isString()) continue;
                this.hasDisposableArgument = true;
                return;
            }
            this.hasDisposableArgument = false;
        }

        public String getName() {
            return this.name;
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public void setManual(boolean isManual) {
            this.isManual = isManual;
        }

        public boolean isManual() {
            return this.isManual;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public String getNativeCode() {
            return this.nativeCode;
        }

        public void setNativeCode(String nativeCode) {
            this.nativeCode = nativeCode;
        }

        public ArrayList<Argument> getArguments() {
            return this.arguments;
        }

        public boolean hasDisposableArgument() {
            return this.hasDisposableArgument;
        }

        @Override
        public int getStartIndex() {
            return this.startIndex;
        }

        @Override
        public int getEndIndex() {
            return this.endIndex;
        }

        public CharSequence getClassName() {
            return this.className;
        }

        public String toString() {
            return "JavaMethod [className=" + this.className + ", name=" + this.name + ", isStatic=" + this.isStatic + ", returnType=" + this.returnType + ", nativeCode=" + this.nativeCode + ", arguments=" + this.arguments + ", hasDisposableArgument=" + this.hasDisposableArgument + ", startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + "]";
        }
    }

    public static class Argument {
        final ArgumentType type;
        private final String name;

        public Argument(ArgumentType type, String name) {
            this.type = type;
            this.name = name;
        }

        public ArgumentType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "Argument [type=" + (Object)((Object)this.type) + ", name=" + this.name + "]";
        }
    }

    public static enum ArgumentType {
        Boolean("jboolean"),
        Byte("jbyte"),
        Char("jchar"),
        Short("jshort"),
        Integer("jint"),
        Long("jlong"),
        Float("jfloat"),
        Double("jdouble"),
        Buffer("jobject"),
        ByteBuffer("jobject"),
        CharBuffer("jobject"),
        ShortBuffer("jobject"),
        IntBuffer("jobject"),
        LongBuffer("jobject"),
        FloatBuffer("jobject"),
        DoubleBuffer("jobject"),
        BooleanArray("jbooleanArray"),
        ByteArray("jbyteArray"),
        CharArray("jcharArray"),
        ShortArray("jshortArray"),
        IntegerArray("jintArray"),
        LongArray("jlongArray"),
        FloatArray("jfloatArray"),
        DoubleArray("jdoubleArray"),
        String("jstring"),
        Class("jclass"),
        Throwable("jthrowable"),
        Object("jobject"),
        ObjectArray("jobjectArray");

        private final String jniType;

        private ArgumentType(String jniType) {
            this.jniType = jniType;
        }

        public boolean isPrimitiveArray() {
            return this.toString().endsWith("Array") && this != ObjectArray;
        }

        public boolean isBuffer() {
            return this.toString().endsWith("Buffer");
        }

        public boolean isObject() {
            return this.toString().equals("Object") || this == ObjectArray;
        }

        public boolean isString() {
            return this.toString().equals("String");
        }

        public boolean isPlainOldDataType() {
            return !this.isString() && !this.isPrimitiveArray() && !this.isBuffer() && !this.isObject();
        }

        public String getBufferCType() {
            if (!this.isBuffer()) {
                throw new RuntimeException("ArgumentType " + (Object)((Object)this) + " is not a Buffer!");
            }
            if (this == Buffer) {
                return "unsigned char*";
            }
            if (this == ByteBuffer) {
                return "char*";
            }
            if (this == CharBuffer) {
                return "unsigned short*";
            }
            if (this == ShortBuffer) {
                return "short*";
            }
            if (this == IntBuffer) {
                return "int*";
            }
            if (this == LongBuffer) {
                return "long long*";
            }
            if (this == FloatBuffer) {
                return "float*";
            }
            if (this == DoubleBuffer) {
                return "double*";
            }
            throw new RuntimeException("Unknown Buffer type " + (Object)((Object)this));
        }

        public String getArrayCType() {
            if (!this.isPrimitiveArray()) {
                throw new RuntimeException("ArgumentType " + (Object)((Object)this) + " is not an Array!");
            }
            if (this == BooleanArray) {
                return "bool*";
            }
            if (this == ByteArray) {
                return "char*";
            }
            if (this == CharArray) {
                return "unsigned short*";
            }
            if (this == ShortArray) {
                return "short*";
            }
            if (this == IntegerArray) {
                return "int*";
            }
            if (this == LongArray) {
                return "long long*";
            }
            if (this == FloatArray) {
                return "float*";
            }
            if (this == DoubleArray) {
                return "double*";
            }
            throw new RuntimeException("Unknown Array type " + (Object)((Object)this));
        }

        public String getJniType() {
            return this.jniType;
        }
    }

    public static class JniSection
    implements JavaSegment {
        private String nativeCode;
        private final int startIndex;
        private final int endIndex;

        public JniSection(String nativeCode, int startIndex, int endIndex) {
            this.nativeCode = nativeCode;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public String getNativeCode() {
            return this.nativeCode;
        }

        public void setNativeCode(String nativeCode) {
            this.nativeCode = nativeCode;
        }

        @Override
        public int getStartIndex() {
            return this.startIndex;
        }

        @Override
        public int getEndIndex() {
            return this.endIndex;
        }

        public String toString() {
            return "JniSection [nativeCode=" + this.nativeCode + ", startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + "]";
        }
    }

    public static interface JavaSegment {
        public int getStartIndex();

        public int getEndIndex();
    }
}

