/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen;

import java.util.function.BooleanSupplier;

public class BuildTarget {
    public TargetOs os;
    public boolean is64Bit;
    public boolean isARM;
    public String[] cIncludes;
    public String[] cExcludes;
    public String[] cppIncludes;
    public String[] cppExcludes;
    public String[] headerDirs;
    public String cCompiler = "gcc";
    public String cppCompiler = "g++";
    public String archiver = "ar";
    public String compilerPrefix = "";
    public String compilerSuffix = "";
    public String cFlags;
    public String cppFlags;
    public String linkerFlags;
    public String archiverFlags = "rcs";
    public String buildFileName;
    public boolean excludeFromMasterBuildFile = false;
    public String preCompileTask;
    public String postCompileTask;
    public String libraries;
    public String osFileName;
    public String libName;
    public BooleanSupplier canBuild = () -> !System.getProperty("os.name").contains("Mac");
    public String[] androidABIs = new String[]{"all"};
    public String[] androidAndroidMk = new String[0];
    public String[] androidApplicationMk = new String[0];
    public String xcframeworkBundleIdentifier = null;
    public String minIOSVersion = "11.0";

    public BuildTarget(TargetOs targetType, boolean is64Bit, String[] cIncludes, String[] cExcludes, String[] cppIncludes, String[] cppExcludes, String[] headerDirs, String compilerPrefix, String cFlags, String cppFlags, String linkerFlags) {
        if (targetType == null) {
            throw new IllegalArgumentException("targetType must not be null");
        }
        if (cIncludes == null) {
            cIncludes = new String[]{};
        }
        if (cExcludes == null) {
            cExcludes = new String[]{};
        }
        if (cppIncludes == null) {
            cppIncludes = new String[]{};
        }
        if (cppExcludes == null) {
            cppExcludes = new String[]{};
        }
        if (headerDirs == null) {
            headerDirs = new String[]{};
        }
        if (compilerPrefix == null) {
            compilerPrefix = "";
        }
        if (cFlags == null) {
            cFlags = "";
        }
        if (cppFlags == null) {
            cppFlags = "";
        }
        if (linkerFlags == null) {
            linkerFlags = "";
        }
        this.os = targetType;
        this.is64Bit = is64Bit;
        this.cIncludes = cIncludes;
        this.cExcludes = cExcludes;
        this.cppIncludes = cppIncludes;
        this.cppExcludes = cppExcludes;
        this.headerDirs = headerDirs;
        this.compilerPrefix = compilerPrefix;
        this.cFlags = cFlags;
        this.cppFlags = cppFlags;
        this.linkerFlags = linkerFlags;
        this.libraries = "";
    }

    public String getBuildFilename() {
        if (this.buildFileName != null && !this.buildFileName.isEmpty()) {
            return this.buildFileName;
        }
        return "build-" + this.os.toString().toLowerCase() + (this.isARM ? "arm" : "") + (this.is64Bit ? "64" : "32") + ".xml";
    }

    public String getSharedLibFilename(String sharedLibName) {
        if (this.libName != null && !this.libName.isEmpty()) {
            return this.libName;
        }
        String libPrefix = "";
        String libSuffix = "";
        if (this.os == TargetOs.Windows) {
            libSuffix = (this.is64Bit ? "64" : "") + ".dll";
        }
        if (this.os == TargetOs.Linux || this.os == TargetOs.Android) {
            libPrefix = "lib";
            libSuffix = (this.isARM ? "arm" : "") + (this.is64Bit ? "64" : "") + ".so";
        }
        if (this.os == TargetOs.MacOsX) {
            libPrefix = "lib";
            libSuffix = (this.isARM ? "arm" : "") + (this.is64Bit ? "64" : "") + ".dylib";
        }
        return libPrefix + sharedLibName + libSuffix;
    }

    public String getTargetFolder() {
        if (this.osFileName != null && !this.osFileName.isEmpty()) {
            return this.osFileName;
        }
        return this.os.toString().toLowerCase() + (this.isARM ? "arm" : "") + (this.is64Bit ? "64" : "32");
    }

    public static BuildTarget newDefaultTarget(TargetOs type, boolean is64Bit) {
        return BuildTarget.newDefaultTarget(type, is64Bit, false);
    }

    public static BuildTarget newDefaultTarget(TargetOs type, boolean is64Bit, boolean isARM) {
        if (type == TargetOs.Windows && !is64Bit) {
            return new BuildTarget(TargetOs.Windows, false, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "i686-w64-mingw32-", "-c -Wall -O2 -mfpmath=sse -msse2 -fmessage-length=0 -m32", "-c -Wall -O2 -mfpmath=sse -msse2 -fmessage-length=0 -m32", "-Wl,--kill-at -shared -m32 -static -static-libgcc -static-libstdc++");
        }
        if (type == TargetOs.Windows && is64Bit) {
            return new BuildTarget(TargetOs.Windows, true, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "x86_64-w64-mingw32-", "-c -Wall -O2 -mfpmath=sse -msse2 -fmessage-length=0 -m64", "-c -Wall -O2 -mfpmath=sse -msse2 -fmessage-length=0 -m64", "-Wl,--kill-at -shared -static -static-libgcc -static-libstdc++ -m64");
        }
        if (type == TargetOs.Linux && isARM && !is64Bit) {
            BuildTarget target = new BuildTarget(TargetOs.Linux, false, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "arm-linux-gnueabihf-", "-c -Wall -O2 -fmessage-length=0 -fPIC", "-c -Wall -O2 -fmessage-length=0 -fPIC", "-shared");
            target.isARM = true;
            return target;
        }
        if (type == TargetOs.Linux && isARM && is64Bit) {
            BuildTarget target = new BuildTarget(TargetOs.Linux, true, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "aarch64-linux-gnu-", "-c -Wall -O2 -fmessage-length=0 -fPIC", "-c -Wall -O2 -fmessage-length=0 -fPIC", "-shared");
            target.isARM = true;
            return target;
        }
        if (type == TargetOs.Linux && !is64Bit) {
            return new BuildTarget(TargetOs.Linux, false, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "", "-c -Wall -O2 -mfpmath=sse -msse -fmessage-length=0 -m32 -fPIC", "-c -Wall -O2 -mfpmath=sse -msse -fmessage-length=0 -m32 -fPIC", "-shared -m32");
        }
        if (type == TargetOs.Linux && is64Bit) {
            return new BuildTarget(TargetOs.Linux, true, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "", "-c -Wall -O2 -mfpmath=sse -msse -fmessage-length=0 -m64 -fPIC", "-c -Wall -O2 -mfpmath=sse -msse -fmessage-length=0 -m64 -fPIC", "-shared -m64 -Wl,-wrap,memcpy");
        }
        if (type == TargetOs.MacOsX && !is64Bit) {
            throw new RuntimeException("macOS 32-bit not supported");
        }
        if (type == TargetOs.MacOsX && is64Bit && isARM) {
            BuildTarget mac = new BuildTarget(TargetOs.MacOsX, true, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "", "-c -Wall -O2 -arch arm64 -DFIXED_POINT -fmessage-length=0 -fPIC -mmacosx-version-min=10.7 -stdlib=libc++", "-c -Wall -O2 -arch arm64 -DFIXED_POINT -fmessage-length=0 -fPIC -mmacosx-version-min=10.7 -stdlib=libc++", "-shared -arch arm64 -mmacosx-version-min=10.7 -stdlib=libc++");
            mac.cCompiler = "clang";
            mac.cppCompiler = "clang++";
            mac.canBuild = () -> System.getProperty("os.name").contains("Mac");
            mac.isARM = true;
            return mac;
        }
        if (type == TargetOs.MacOsX && is64Bit) {
            BuildTarget mac = new BuildTarget(TargetOs.MacOsX, true, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "", "-c -Wall -O2 -arch x86_64 -DFIXED_POINT -fmessage-length=0 -fPIC -mmacosx-version-min=10.7 -stdlib=libc++", "-c -Wall -O2 -arch x86_64 -DFIXED_POINT -fmessage-length=0 -fPIC -mmacosx-version-min=10.7 -stdlib=libc++", "-shared -arch x86_64 -mmacosx-version-min=10.7 -stdlib=libc++");
            mac.cCompiler = "clang";
            mac.cppCompiler = "clang++";
            mac.canBuild = () -> System.getProperty("os.name").contains("Mac");
            return mac;
        }
        if (type == TargetOs.Android) {
            BuildTarget android = new BuildTarget(TargetOs.Android, false, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "", "-O2 -Wall -D__ANDROID__", "-O2 -Wall -D__ANDROID__", "-lm");
            return android;
        }
        if (type == TargetOs.IOS) {
            BuildTarget ios = new BuildTarget(TargetOs.IOS, false, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "", "-c -Wall -O2 -stdlib=libc++", "-c -Wall -O2 -stdlib=libc++", "-shared -stdlib=libc++");
            ios.cCompiler = "clang";
            ios.cppCompiler = "clang++";
            ios.canBuild = () -> System.getProperty("os.name").contains("Mac");
            return ios;
        }
        throw new RuntimeException("Unknown target type");
    }

    public static enum TargetOs {
        Windows,
        Linux,
        MacOsX,
        Android,
        IOS;

    }
}

