/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.parsing;

import com.badlogic.gdx.jnigen.parsing.JavaMethodParser;
import com.github.javaparser.JavaParser;
import com.github.javaparser.Position;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class RobustJavaMethodParser
implements JavaMethodParser {
    private static final String JNI_MANUAL = "MANUAL";
    private static final Map<String, JavaMethodParser.ArgumentType> plainOldDataTypes;
    private static final Map<String, JavaMethodParser.ArgumentType> arrayTypes;
    private static final Map<String, JavaMethodParser.ArgumentType> bufferTypes;
    private static final Map<String, JavaMethodParser.ArgumentType> otherTypes;
    public static String CustomIgnoreTag;
    Stack<TypeDeclaration<?>> classStack = new Stack();

    @Override
    public ArrayList<JavaMethodParser.JavaSegment> parse(String classFile) throws Exception {
        CompilationUnit unit = (CompilationUnit)new JavaParser().parse((InputStream)new ByteArrayInputStream(classFile.getBytes())).getResult().get();
        ArrayList<JavaMethodParser.JavaMethod> methods = new ArrayList<JavaMethodParser.JavaMethod>();
        this.getJavaMethods(methods, this.getOuterClass(unit));
        ArrayList<JavaMethodParser.JniSection> methodBodies = this.getNativeCodeBodies(classFile);
        ArrayList<JavaMethodParser.JniSection> sections = this.getJniSections(classFile);
        this.alignMethodBodies(methods, methodBodies);
        ArrayList<JavaMethodParser.JavaSegment> segments = this.sortMethodsAndSections(methods, sections);
        return segments;
    }

    private ArrayList<JavaMethodParser.JavaSegment> sortMethodsAndSections(ArrayList<JavaMethodParser.JavaMethod> methods, ArrayList<JavaMethodParser.JniSection> sections) {
        ArrayList<JavaMethodParser.JavaSegment> segments = new ArrayList<JavaMethodParser.JavaSegment>();
        segments.addAll(methods);
        segments.addAll(sections);
        Collections.sort(segments, new Comparator<JavaMethodParser.JavaSegment>(){

            @Override
            public int compare(JavaMethodParser.JavaSegment o1, JavaMethodParser.JavaSegment o2) {
                return o1.getStartIndex() - o2.getStartIndex();
            }
        });
        return segments;
    }

    private void alignMethodBodies(ArrayList<JavaMethodParser.JavaMethod> methods, ArrayList<JavaMethodParser.JniSection> methodBodies) {
        block0: for (JavaMethodParser.JavaMethod method : methods) {
            for (JavaMethodParser.JniSection section : methodBodies) {
                if (method.getEndIndex() != section.getStartIndex()) continue;
                if (section.getNativeCode().startsWith(JNI_MANUAL)) {
                    section.setNativeCode(section.getNativeCode().substring(JNI_MANUAL.length()));
                    method.setManual(true);
                }
                method.setNativeCode(section.getNativeCode());
                continue block0;
            }
        }
    }

    private void getJavaMethods(ArrayList<JavaMethodParser.JavaMethod> methods, TypeDeclaration<?> type) {
        this.classStack.push(type);
        if (type.getMembers() != null) {
            for (BodyDeclaration member : type.getMembers()) {
                MethodDeclaration method;
                if (member.isClassOrInterfaceDeclaration() || member.isEnumDeclaration()) {
                    this.getJavaMethods(methods, (TypeDeclaration)member);
                    continue;
                }
                if (!(member instanceof MethodDeclaration) || !(method = (MethodDeclaration)member).isNative()) continue;
                methods.add(this.createMethod(method));
            }
        }
        this.classStack.pop();
    }

    private JavaMethodParser.JavaMethod createMethod(MethodDeclaration method) {
        String className = this.classStack.peek().getNameAsString();
        String name = method.getNameAsString();
        boolean isStatic = method.isStatic();
        String returnType = method.getType().toString();
        ArrayList<JavaMethodParser.Argument> arguments = new ArrayList<JavaMethodParser.Argument>();
        if (method.getParameters() != null) {
            for (Parameter parameter : method.getParameters()) {
                arguments.add(new JavaMethodParser.Argument(this.getArgumentType(parameter), parameter.getNameAsString()));
            }
        }
        return new JavaMethodParser.JavaMethod(className, name, isStatic, returnType, null, arguments, ((Position)method.getBegin().get()).line, ((Position)method.getEnd().get()).line);
    }

    private JavaMethodParser.ArgumentType getArgumentType(Parameter parameter) {
        String[] typeTokens = parameter.getType().toString().split("\\.");
        String type = typeTokens[typeTokens.length - 1];
        int arrayDim = 0;
        for (int i = 0; i < type.length(); ++i) {
            if (type.charAt(i) != '[') continue;
            ++arrayDim;
        }
        type = type.replace("[", "").replace("]", "");
        if (arrayDim >= 1) {
            if (arrayDim > 1) {
                return JavaMethodParser.ArgumentType.ObjectArray;
            }
            JavaMethodParser.ArgumentType arrayType = arrayTypes.get(type);
            if (arrayType == null) {
                return JavaMethodParser.ArgumentType.ObjectArray;
            }
            return arrayType;
        }
        if (plainOldDataTypes.containsKey(type)) {
            return plainOldDataTypes.get(type);
        }
        if (bufferTypes.containsKey(type)) {
            return bufferTypes.get(type);
        }
        if (otherTypes.containsKey(type)) {
            return otherTypes.get(type);
        }
        return JavaMethodParser.ArgumentType.Object;
    }

    private TypeDeclaration<?> getOuterClass(CompilationUnit unit) {
        for (TypeDeclaration type : unit.getTypes()) {
            if (!(type instanceof ClassOrInterfaceDeclaration) && !(type instanceof EnumDeclaration)) continue;
            return type;
        }
        throw new RuntimeException("Couldn't find class, is your java file empty?");
    }

    private ArrayList<JavaMethodParser.JniSection> getJniSections(String classFile) {
        ArrayList<JavaMethodParser.JniSection> sections = this.getComments(classFile);
        Iterator<JavaMethodParser.JniSection> iter = sections.iterator();
        while (iter.hasNext()) {
            JavaMethodParser.JniSection section = iter.next();
            if (!section.getNativeCode().startsWith("JNI")) {
                iter.remove();
                continue;
            }
            section.setNativeCode(section.getNativeCode().substring(3));
        }
        return sections;
    }

    private ArrayList<JavaMethodParser.JniSection> getNativeCodeBodies(String classFile) {
        ArrayList<JavaMethodParser.JniSection> sections = this.getComments(classFile);
        Iterator<JavaMethodParser.JniSection> iter = sections.iterator();
        while (iter.hasNext()) {
            JavaMethodParser.JniSection section = iter.next();
            if (section.getNativeCode().startsWith("JNI")) {
                iter.remove();
            }
            if (section.getNativeCode().startsWith("-{")) {
                iter.remove();
            }
            if (CustomIgnoreTag.isEmpty() || !section.getNativeCode().startsWith(CustomIgnoreTag)) continue;
            iter.remove();
        }
        return sections;
    }

    private ArrayList<JavaMethodParser.JniSection> getComments(String classFile) {
        ArrayList<JavaMethodParser.JniSection> sections = new ArrayList<JavaMethodParser.JniSection>();
        boolean inComment = false;
        int start = 0;
        int startLine = 0;
        int line = 1;
        for (int i = 0; i < classFile.length() - 2; ++i) {
            char c1 = classFile.charAt(i);
            char c2 = classFile.charAt(i + 1);
            char c3 = classFile.charAt(i + 2);
            if (c1 == '\n') {
                ++line;
            }
            if (!inComment) {
                if (c1 != '/' || c2 != '*' || c3 == '*') continue;
                inComment = true;
                start = i;
                startLine = line;
                continue;
            }
            if (c1 != '*' || c2 != '/') continue;
            sections.add(new JavaMethodParser.JniSection(classFile.substring(start + 2, i), startLine, line));
            inComment = false;
        }
        return sections;
    }

    static {
        CustomIgnoreTag = "";
        plainOldDataTypes = new HashMap<String, JavaMethodParser.ArgumentType>();
        plainOldDataTypes.put("boolean", JavaMethodParser.ArgumentType.Boolean);
        plainOldDataTypes.put("byte", JavaMethodParser.ArgumentType.Byte);
        plainOldDataTypes.put("char", JavaMethodParser.ArgumentType.Char);
        plainOldDataTypes.put("short", JavaMethodParser.ArgumentType.Short);
        plainOldDataTypes.put("int", JavaMethodParser.ArgumentType.Integer);
        plainOldDataTypes.put("long", JavaMethodParser.ArgumentType.Long);
        plainOldDataTypes.put("float", JavaMethodParser.ArgumentType.Float);
        plainOldDataTypes.put("double", JavaMethodParser.ArgumentType.Double);
        arrayTypes = new HashMap<String, JavaMethodParser.ArgumentType>();
        arrayTypes.put("boolean", JavaMethodParser.ArgumentType.BooleanArray);
        arrayTypes.put("byte", JavaMethodParser.ArgumentType.ByteArray);
        arrayTypes.put("char", JavaMethodParser.ArgumentType.CharArray);
        arrayTypes.put("short", JavaMethodParser.ArgumentType.ShortArray);
        arrayTypes.put("int", JavaMethodParser.ArgumentType.IntegerArray);
        arrayTypes.put("long", JavaMethodParser.ArgumentType.LongArray);
        arrayTypes.put("float", JavaMethodParser.ArgumentType.FloatArray);
        arrayTypes.put("double", JavaMethodParser.ArgumentType.DoubleArray);
        bufferTypes = new HashMap<String, JavaMethodParser.ArgumentType>();
        bufferTypes.put("Buffer", JavaMethodParser.ArgumentType.Buffer);
        bufferTypes.put("ByteBuffer", JavaMethodParser.ArgumentType.ByteBuffer);
        bufferTypes.put("CharBuffer", JavaMethodParser.ArgumentType.CharBuffer);
        bufferTypes.put("ShortBuffer", JavaMethodParser.ArgumentType.ShortBuffer);
        bufferTypes.put("IntBuffer", JavaMethodParser.ArgumentType.IntBuffer);
        bufferTypes.put("LongBuffer", JavaMethodParser.ArgumentType.LongBuffer);
        bufferTypes.put("FloatBuffer", JavaMethodParser.ArgumentType.FloatBuffer);
        bufferTypes.put("DoubleBuffer", JavaMethodParser.ArgumentType.DoubleBuffer);
        otherTypes = new HashMap<String, JavaMethodParser.ArgumentType>();
        otherTypes.put("String", JavaMethodParser.ArgumentType.String);
        otherTypes.put("Class", JavaMethodParser.ArgumentType.Class);
        otherTypes.put("Throwable", JavaMethodParser.ArgumentType.Throwable);
    }
}

