/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen;

import com.badlogic.gdx.jnigen.AndroidNdkScriptGenerator;
import com.badlogic.gdx.jnigen.BuildConfig;
import com.badlogic.gdx.jnigen.BuildTarget;
import com.badlogic.gdx.jnigen.FileDescriptor;
import com.badlogic.gdx.utils.Os;
import java.util.ArrayList;

public class AntScriptGenerator {
    public void generate(BuildConfig config, BuildTarget ... targets) {
        int i;
        if (!config.libsDir.exists() && !config.libsDir.mkdirs()) {
            throw new RuntimeException("Couldn't create directory for shared library files in '" + config.libsDir + "'");
        }
        if (!config.jniDir.exists() && !config.jniDir.mkdirs()) {
            throw new RuntimeException("Couldn't create native code directory '" + config.jniDir + "'");
        }
        this.copyJniHeaders(config.jniDir.path());
        if (!config.jniDir.child("memcpy_wrap.c").exists()) {
            new FileDescriptor("com/badlogic/gdx/jnigen/resources/scripts/memcpy_wrap.c", FileDescriptor.FileType.Classpath).copyTo(config.jniDir.child("memcpy_wrap.c"));
        }
        ArrayList<String> buildFiles = new ArrayList<String>();
        ArrayList<String> libsDirs = new ArrayList<String>();
        ArrayList<String> sharedLibFiles = new ArrayList<String>();
        for (BuildTarget target : targets) {
            String buildFile = this.generateBuildTargetTemplate(config, target);
            FileDescriptor libsDir = new FileDescriptor(AntScriptGenerator.getLibsDirectory(config, target));
            if (!libsDir.exists() && !libsDir.mkdirs()) {
                throw new RuntimeException("Couldn't create libs directory '" + libsDir + "'");
            }
            String buildFileName = target.getBuildFilename();
            config.jniDir.child(buildFileName).writeString(buildFile, false);
            System.out.println("Wrote target '" + target.os + target.architecture.toSuffix() + target.bitness.toSuffix() + "' build script '" + config.jniDir.child(buildFileName) + "'");
            if (target.os == Os.IOS) {
                byte[] plist = new FileDescriptor("com/badlogic/gdx/jnigen/resources/scripts/Info.plist.template", FileDescriptor.FileType.Classpath).readBytes();
                config.jniDir.child("Info.plist").writeBytes(plist, false);
            }
            if (target.excludeFromMasterBuildFile) continue;
            if (target.os != Os.MacOsX && target.os != Os.IOS) {
                buildFiles.add(buildFileName);
            }
            String sharedLibFilename = target.getSharedLibFilename(config.sharedLibName);
            if (target.os == Os.Android || target.os == Os.IOS) continue;
            sharedLibFiles.add(sharedLibFilename);
            libsDirs.add("../" + libsDir.path().replace('\\', '/'));
        }
        String template = new FileDescriptor("com/badlogic/gdx/jnigen/resources/scripts/build.xml.template", FileDescriptor.FileType.Classpath).readString();
        StringBuilder clean = new StringBuilder();
        StringBuilder compile = new StringBuilder();
        StringBuilder pack = new StringBuilder();
        for (i = 0; i < buildFiles.size(); ++i) {
            clean.append("\t\t<ant antfile=\"" + (String)buildFiles.get(i) + "\" target=\"clean\"/>\n");
            compile.append("\t\t<ant antfile=\"" + (String)buildFiles.get(i) + "\"/>\n");
        }
        for (i = 0; i < libsDirs.size(); ++i) {
            pack.append("\t\t\t<fileset dir=\"" + (String)libsDirs.get(i) + "\" includes=\"" + (String)sharedLibFiles.get(i) + "\"/>\n");
        }
        if (config.sharedLibs != null) {
            for (String sharedLib : config.sharedLibs) {
                pack.append("\t\t\t<fileset dir=\"" + sharedLib + "\"/>\n");
            }
        }
        template = template.replace("%projectName%", config.sharedLibName + "-natives");
        template = template.replace("<clean/>", clean.toString());
        template = template.replace("<compile/>", compile.toString());
        template = template.replace("%packFile%", "../" + config.libsDir.path().replace('\\', '/') + "/" + config.sharedLibName + "-natives.jar");
        template = template.replace("<pack/>", pack);
        config.jniDir.child("build.xml").writeString(template, false);
        System.out.println("Wrote master build script '" + config.jniDir.child("build.xml") + "'");
    }

    private void copyJniHeaders(String jniDir) {
        String[] files;
        String pack = "com/badlogic/gdx/jnigen/resources/headers";
        for (String file : files = new String[]{"classfile_constants.h", "jawt.h", "jdwpTransport.h", "jni.h", "linux/jawt_md.h", "linux/jni_md.h", "mac/jni_md.h", "win32/jawt_md.h", "win32/jni_md.h"}) {
            new FileDescriptor("com/badlogic/gdx/jnigen/resources/headers", FileDescriptor.FileType.Classpath).child(file).copyTo(new FileDescriptor(jniDir).child("jni-headers").child(file));
        }
    }

    public static String getLibsDirectory(BuildConfig config, BuildTarget target) {
        return config.libsDir.child(target.getTargetFolder()).path().replace('\\', '/');
    }

    private String generateBuildTargetTemplate(BuildConfig config, BuildTarget target) {
        if (target.os == Os.Android) {
            new AndroidNdkScriptGenerator().generate(config, target);
            String template = new FileDescriptor("com/badlogic/gdx/jnigen/resources/scripts/build-android.xml.template", FileDescriptor.FileType.Classpath).readString();
            template = template.replace("%precompile%", target.preCompileTask == null ? "" : target.preCompileTask);
            template = template.replace("%postcompile%", target.postCompileTask == null ? "" : target.postCompileTask);
            return template;
        }
        String template = null;
        template = target.os == Os.IOS ? new FileDescriptor("com/badlogic/gdx/jnigen/resources/scripts/build-ios.xml.template", FileDescriptor.FileType.Classpath).readString() : new FileDescriptor("com/badlogic/gdx/jnigen/resources/scripts/build-target.xml.template", FileDescriptor.FileType.Classpath).readString();
        String libName = target.getSharedLibFilename(config.sharedLibName);
        StringBuilder cIncludes = new StringBuilder();
        cIncludes.append("\t\t<include name=\"memcpy_wrap.c\"/>\n");
        for (String cInclude : target.cIncludes) {
            cIncludes.append("\t\t<include name=\"" + cInclude + "\"/>\n");
        }
        StringBuilder cppIncludes = new StringBuilder();
        for (String cppInclude : target.cppIncludes) {
            cppIncludes.append("\t\t<include name=\"" + cppInclude + "\"/>\n");
        }
        StringBuilder cExcludes = new StringBuilder();
        for (String cExclude : target.cExcludes) {
            cExcludes.append("\t\t<exclude name=\"" + cExclude + "\"/>\n");
        }
        StringBuilder cppExcludes = new StringBuilder();
        for (String cppExclude : target.cppExcludes) {
            cppExcludes.append("\t\t<exclude name=\"" + cppExclude + "\"/>\n");
        }
        StringBuilder headerDirs = new StringBuilder();
        for (String headerDir : target.headerDirs) {
            headerDirs.append("\t\t\t<arg value=\"-I" + headerDir + "\"/>\n");
        }
        template = template.replace("%projectName%", config.sharedLibName + "-" + target.os + "-" + target.architecture.toSuffix() + target.bitness.name().substring(1));
        template = template.replace("%buildDir%", config.buildDir.child(target.getTargetFolder()).path().replace('\\', '/'));
        template = template.replace("%libsDir%", "../" + AntScriptGenerator.getLibsDirectory(config, target));
        template = template.replace("%libName%", libName);
        template = template.replace("%xcframeworkName%", config.sharedLibName);
        template = template.replace("%xcframeworkBundleIdentifier%", target.xcframeworkBundleIdentifier == null ? "gdx.jnigen." + config.sharedLibName : target.xcframeworkBundleIdentifier);
        template = template.replace("%minIOSVersion%", target.minIOSVersion);
        template = template.replace("%jniPlatform%", target.os.getJniPlatform());
        template = template.replace("%cCompiler%", target.cCompiler);
        template = template.replace("%cppCompiler%", target.cppCompiler);
        template = template.replace("%archiver%", target.archiver);
        template = template.replace("%compilerPrefix%", target.compilerPrefix);
        template = template.replace("%compilerSuffix%", target.compilerSuffix);
        template = template.replace("%cFlags%", target.cFlags);
        template = template.replace("%cppFlags%", target.cppFlags);
        template = template.replace("%linkerFlags%", target.linkerFlags);
        template = template.replace("%archiverFlags%", target.archiverFlags);
        template = template.replace("%libraries%", target.libraries);
        template = template.replace("%cIncludes%", cIncludes.toString().trim());
        template = template.replace("%cExcludes%", cExcludes.toString().trim());
        template = template.replace("%cppIncludes%", cppIncludes.toString().trim());
        template = template.replace("%cppExcludes%", cppExcludes.toString().trim());
        template = template.replace("%headerDirs%", headerDirs.toString().trim());
        template = template.replace("%precompile%", target.preCompileTask == null ? "" : target.preCompileTask);
        template = template.replace("%postcompile%", target.postCompileTask == null ? "" : target.postCompileTask);
        return template;
    }
}

