/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen;

import com.badlogic.gdx.utils.Architecture;
import com.badlogic.gdx.utils.Os;
import java.util.function.BooleanSupplier;

public class BuildTarget {
    public Os os;
    public Architecture.Bitness bitness;
    public Architecture architecture = Architecture.x86;
    public String[] cIncludes;
    public String[] cExcludes;
    public String[] cppIncludes;
    public String[] cppExcludes;
    public String[] headerDirs;
    public String cCompiler = "gcc";
    public String cppCompiler = "g++";
    public String archiver = "ar";
    public String compilerPrefix = "";
    public String compilerSuffix = "";
    public String cFlags;
    public String cppFlags;
    public String linkerFlags;
    public String archiverFlags = "rcs";
    public String buildFileName;
    public boolean excludeFromMasterBuildFile = false;
    public String preCompileTask;
    public String postCompileTask;
    public String libraries;
    public String osFileName;
    public String libName;
    public BooleanSupplier canBuild = () -> !System.getProperty("os.name").contains("Mac");
    public String[] androidABIs = new String[]{"all"};
    public String[] androidAndroidMk = new String[0];
    public String[] androidApplicationMk = new String[0];
    public String xcframeworkBundleIdentifier = null;
    public String minIOSVersion = "12.0";

    public BuildTarget(Os targetType, Architecture.Bitness bitness, String[] cIncludes, String[] cExcludes, String[] cppIncludes, String[] cppExcludes, String[] headerDirs, String compilerPrefix, String cFlags, String cppFlags, String linkerFlags) {
        if (targetType == null) {
            throw new IllegalArgumentException("targetType must not be null");
        }
        if (cIncludes == null) {
            cIncludes = new String[]{};
        }
        if (cExcludes == null) {
            cExcludes = new String[]{};
        }
        if (cppIncludes == null) {
            cppIncludes = new String[]{};
        }
        if (cppExcludes == null) {
            cppExcludes = new String[]{};
        }
        if (headerDirs == null) {
            headerDirs = new String[]{};
        }
        if (compilerPrefix == null) {
            compilerPrefix = "";
        }
        if (cFlags == null) {
            cFlags = "";
        }
        if (cppFlags == null) {
            cppFlags = "";
        }
        if (linkerFlags == null) {
            linkerFlags = "";
        }
        this.os = targetType;
        this.bitness = bitness;
        this.cIncludes = cIncludes;
        this.cExcludes = cExcludes;
        this.cppIncludes = cppIncludes;
        this.cppExcludes = cppExcludes;
        this.headerDirs = headerDirs;
        this.compilerPrefix = compilerPrefix;
        this.cFlags = cFlags;
        this.cppFlags = cppFlags;
        this.linkerFlags = linkerFlags;
        this.libraries = "";
    }

    public String getBuildFilename() {
        if (this.buildFileName != null && !this.buildFileName.isEmpty()) {
            return this.buildFileName;
        }
        return "build-" + this.os.toString().toLowerCase() + this.architecture.toSuffix() + this.bitness.name().substring(1) + ".xml";
    }

    public String getSharedLibFilename(String sharedLibName) {
        if (this.libName != null && !this.libName.isEmpty()) {
            return this.libName;
        }
        String suffix = this.os.getLibExtension().isEmpty() ? "" : "." + this.os.getLibExtension();
        return this.os.getLibPrefix() + sharedLibName + this.architecture.toSuffix() + this.bitness.toSuffix() + suffix;
    }

    public String getTargetFolder() {
        if (this.osFileName != null && !this.osFileName.isEmpty()) {
            return this.osFileName;
        }
        return this.os.toString().toLowerCase() + this.architecture.toSuffix() + this.bitness.name().substring(1);
    }

    @Deprecated
    public static BuildTarget newDefaultTarget(Os type, boolean is64Bit) {
        return BuildTarget.newDefaultTarget(type, is64Bit, false);
    }

    public static BuildTarget newDefaultTarget(Os type, Architecture.Bitness bitness) {
        return BuildTarget.newDefaultTarget(type, bitness, Architecture.x86);
    }

    @Deprecated
    public static BuildTarget newDefaultTarget(Os type, boolean is64Bit, boolean isARM) {
        return BuildTarget.newDefaultTarget(type, is64Bit ? Architecture.Bitness._64 : Architecture.Bitness._32, isARM ? Architecture.ARM : Architecture.x86);
    }

    public static BuildTarget newDefaultTarget(Os type, Architecture.Bitness bitness, Architecture architecture) {
        if (type == Os.Windows && architecture == Architecture.x86 && bitness == Architecture.Bitness._32) {
            return new BuildTarget(Os.Windows, Architecture.Bitness._32, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "i686-w64-mingw32-", "-c -Wall -O2 -mfpmath=sse -msse2 -fmessage-length=0 -m32", "-c -Wall -O2 -mfpmath=sse -msse2 -fmessage-length=0 -m32", "-Wl,--kill-at -shared -m32 -static -static-libgcc -static-libstdc++");
        }
        if (type == Os.Windows && architecture == Architecture.x86 && bitness == Architecture.Bitness._64) {
            return new BuildTarget(Os.Windows, Architecture.Bitness._64, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "x86_64-w64-mingw32-", "-c -Wall -O2 -mfpmath=sse -msse2 -fmessage-length=0 -m64", "-c -Wall -O2 -mfpmath=sse -msse2 -fmessage-length=0 -m64", "-Wl,--kill-at -shared -static -static-libgcc -static-libstdc++ -m64");
        }
        if (type == Os.Windows && architecture == Architecture.ARM && bitness == Architecture.Bitness._32) {
            BuildTarget target = new BuildTarget(Os.Windows, Architecture.Bitness._32, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "armv7-w64-mingw32-", "-c -Wall -O2 -fmessage-length=0", "-c -Wall -O2 -fmessage-length=0", "-Wl,--kill-at -shared -static -static-libgcc -static-libstdc++");
            target.architecture = Architecture.ARM;
            return target;
        }
        if (type == Os.Windows && architecture == Architecture.ARM && bitness == Architecture.Bitness._64) {
            BuildTarget target = new BuildTarget(Os.Windows, Architecture.Bitness._64, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "aarch64-w64-mingw32-", "-c -Wall -O2 -fmessage-length=0", "-c -Wall -O2 -fmessage-length=0", "-Wl,--kill-at -shared -static -static-libgcc -static-libstdc++");
            target.architecture = Architecture.ARM;
            return target;
        }
        if (type == Os.Linux && architecture == Architecture.LOONGARCH && bitness == Architecture.Bitness._64) {
            BuildTarget target = new BuildTarget(Os.Linux, Architecture.Bitness._64, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "loongarch64-unknown-linux-gnu-", "-c -Wall -O2 -fmessage-length=0 -fPIC", "-c -Wall -O2 -fmessage-length=0 -fPIC", "-shared");
            target.architecture = Architecture.LOONGARCH;
            return target;
        }
        if (type == Os.Linux && architecture == Architecture.RISCV && bitness == Architecture.Bitness._32) {
            BuildTarget target = new BuildTarget(Os.Linux, Architecture.Bitness._32, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "riscv32-linux-gnu-", "-c -Wall -O2 -fmessage-length=0 -fPIC", "-c -Wall -O2 -fmessage-length=0 -fPIC", "-shared");
            target.architecture = Architecture.RISCV;
            return target;
        }
        if (type == Os.Linux && architecture == Architecture.RISCV && bitness == Architecture.Bitness._64) {
            BuildTarget target = new BuildTarget(Os.Linux, Architecture.Bitness._64, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "riscv64-linux-gnu-", "-c -Wall -O2 -fmessage-length=0 -fPIC", "-c -Wall -O2 -fmessage-length=0 -fPIC", "-shared");
            target.architecture = Architecture.RISCV;
            return target;
        }
        if (type == Os.Linux && architecture == Architecture.ARM && bitness == Architecture.Bitness._32) {
            BuildTarget target = new BuildTarget(Os.Linux, Architecture.Bitness._32, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "arm-linux-gnueabihf-", "-c -Wall -O2 -fmessage-length=0 -fPIC", "-c -Wall -O2 -fmessage-length=0 -fPIC", "-shared");
            target.architecture = Architecture.ARM;
            return target;
        }
        if (type == Os.Linux && architecture == Architecture.ARM && bitness == Architecture.Bitness._64) {
            BuildTarget target = new BuildTarget(Os.Linux, Architecture.Bitness._64, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "aarch64-linux-gnu-", "-c -Wall -O2 -fmessage-length=0 -fPIC", "-c -Wall -O2 -fmessage-length=0 -fPIC", "-shared");
            target.architecture = Architecture.ARM;
            return target;
        }
        if (type == Os.Linux && bitness == Architecture.Bitness._32) {
            return new BuildTarget(Os.Linux, Architecture.Bitness._32, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "", "-c -Wall -O2 -mfpmath=sse -msse -fmessage-length=0 -m32 -fPIC", "-c -Wall -O2 -mfpmath=sse -msse -fmessage-length=0 -m32 -fPIC", "-shared -m32");
        }
        if (type == Os.Linux && bitness == Architecture.Bitness._64) {
            return new BuildTarget(Os.Linux, Architecture.Bitness._64, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "", "-c -Wall -O2 -mfpmath=sse -msse -fmessage-length=0 -m64 -fPIC", "-c -Wall -O2 -mfpmath=sse -msse -fmessage-length=0 -m64 -fPIC", "-shared -m64 -Wl,-wrap,memcpy");
        }
        if (type == Os.MacOsX && bitness == Architecture.Bitness._32) {
            throw new RuntimeException("macOS 32-bit not supported");
        }
        if (type == Os.MacOsX && bitness == Architecture.Bitness._64 && architecture == Architecture.ARM) {
            BuildTarget mac = new BuildTarget(Os.MacOsX, Architecture.Bitness._64, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "", "-c -Wall -O2 -arch arm64 -DFIXED_POINT -fmessage-length=0 -fPIC -mmacosx-version-min=10.7 -stdlib=libc++", "-c -Wall -O2 -arch arm64 -DFIXED_POINT -fmessage-length=0 -fPIC -mmacosx-version-min=10.7 -stdlib=libc++", "-shared -arch arm64 -mmacosx-version-min=10.7 -stdlib=libc++");
            mac.cCompiler = "clang";
            mac.cppCompiler = "clang++";
            mac.canBuild = () -> System.getProperty("os.name").contains("Mac");
            mac.architecture = Architecture.ARM;
            return mac;
        }
        if (type == Os.MacOsX && bitness == Architecture.Bitness._64) {
            BuildTarget mac = new BuildTarget(Os.MacOsX, Architecture.Bitness._64, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "", "-c -Wall -O2 -arch x86_64 -DFIXED_POINT -fmessage-length=0 -fPIC -mmacosx-version-min=10.7 -stdlib=libc++", "-c -Wall -O2 -arch x86_64 -DFIXED_POINT -fmessage-length=0 -fPIC -mmacosx-version-min=10.7 -stdlib=libc++", "-shared -arch x86_64 -mmacosx-version-min=10.7 -stdlib=libc++");
            mac.cCompiler = "clang";
            mac.cppCompiler = "clang++";
            mac.canBuild = () -> System.getProperty("os.name").contains("Mac");
            return mac;
        }
        if (type == Os.Android) {
            BuildTarget android = new BuildTarget(Os.Android, Architecture.Bitness._32, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "", "-O2 -Wall -D__ANDROID__", "-O2 -Wall -D__ANDROID__", "-lm -Wl,-z,max-page-size=0x4000");
            return android;
        }
        if (type == Os.IOS) {
            BuildTarget ios = new BuildTarget(Os.IOS, Architecture.Bitness._32, new String[]{"**/*.c"}, new String[0], new String[]{"**/*.cpp"}, new String[0], new String[0], "", "-c -Wall -O2 -stdlib=libc++", "-c -Wall -O2 -stdlib=libc++", "-shared -stdlib=libc++");
            ios.cCompiler = "clang";
            ios.cppCompiler = "clang++";
            ios.canBuild = () -> System.getProperty("os.name").contains("Mac");
            return ios;
        }
        throw new RuntimeException("Unknown target type");
    }
}

