/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.angle;

import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengles.GLES20;

public class Lwjgl3GLES20
implements GL20 {
    private ByteBuffer buffer = null;
    private FloatBuffer floatBuffer = null;
    private IntBuffer intBuffer = null;

    private void ensureBufferCapacity(int numBytes) {
        if (this.buffer == null || this.buffer.capacity() < numBytes) {
            this.buffer = BufferUtils.newByteBuffer((int)numBytes);
            this.floatBuffer = this.buffer.asFloatBuffer();
            this.intBuffer = this.buffer.asIntBuffer();
        }
    }

    private FloatBuffer toFloatBuffer(float[] v, int offset, int count) {
        this.ensureBufferCapacity(count << 2);
        ((Buffer)this.floatBuffer).clear();
        ((Buffer)this.floatBuffer).limit(count);
        this.floatBuffer.put(v, offset, count);
        ((Buffer)this.floatBuffer).position(0);
        return this.floatBuffer;
    }

    private IntBuffer toIntBuffer(int[] v, int offset, int count) {
        this.ensureBufferCapacity(count << 2);
        ((Buffer)this.intBuffer).clear();
        ((Buffer)this.intBuffer).limit(count);
        this.intBuffer.put(v, offset, count);
        ((Buffer)this.intBuffer).position(0);
        return this.intBuffer;
    }

    public void glActiveTexture(int texture) {
        GLES20.glActiveTexture((int)texture);
    }

    public void glAttachShader(int program, int shader) {
        GLES20.glAttachShader((int)program, (int)shader);
    }

    public void glBindAttribLocation(int program, int index, String name) {
        GLES20.glBindAttribLocation((int)program, (int)index, (CharSequence)name);
    }

    public void glBindBuffer(int target, int buffer) {
        GLES20.glBindBuffer((int)target, (int)buffer);
    }

    public void glBindFramebuffer(int target, int framebuffer) {
        GLES20.glBindFramebuffer((int)target, (int)framebuffer);
    }

    public void glBindRenderbuffer(int target, int renderbuffer) {
        GLES20.glBindRenderbuffer((int)target, (int)renderbuffer);
    }

    public void glBindTexture(int target, int texture) {
        GLES20.glBindTexture((int)target, (int)texture);
    }

    public void glBlendColor(float red, float green, float blue, float alpha) {
        GLES20.glBlendColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void glBlendEquation(int mode) {
        GLES20.glBlendEquation((int)mode);
    }

    public void glBlendEquationSeparate(int modeRGB, int modeAlpha) {
        GLES20.glBlendEquationSeparate((int)modeRGB, (int)modeAlpha);
    }

    public void glBlendFunc(int sfactor, int dfactor) {
        GLES20.glBlendFunc((int)sfactor, (int)dfactor);
    }

    public void glBlendFuncSeparate(int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        GLES20.glBlendFuncSeparate((int)srcRGB, (int)dstRGB, (int)srcAlpha, (int)dstAlpha);
    }

    public void glBufferData(int target, int size, Buffer data, int usage) {
        if (data == null) {
            GLES20.glBufferData((int)target, (long)size, (int)usage);
        } else if (data instanceof ByteBuffer) {
            GLES20.glBufferData((int)target, (ByteBuffer)((ByteBuffer)data), (int)usage);
        } else if (data instanceof IntBuffer) {
            GLES20.glBufferData((int)target, (IntBuffer)((IntBuffer)data), (int)usage);
        } else if (data instanceof FloatBuffer) {
            GLES20.glBufferData((int)target, (FloatBuffer)((FloatBuffer)data), (int)usage);
        } else if (data instanceof ShortBuffer) {
            GLES20.glBufferData((int)target, (ShortBuffer)((ShortBuffer)data), (int)usage);
        } else {
            throw new GdxRuntimeException("Buffer data of type " + data.getClass().getName() + " not supported in GLES20.");
        }
    }

    public void glBufferSubData(int target, int offset, int size, Buffer data) {
        if (data == null) {
            throw new GdxRuntimeException("Using null for the data not possible, ");
        }
        if (data instanceof ByteBuffer) {
            GLES20.glBufferSubData((int)target, (long)offset, (ByteBuffer)((ByteBuffer)data));
        } else if (data instanceof IntBuffer) {
            GLES20.glBufferSubData((int)target, (long)offset, (IntBuffer)((IntBuffer)data));
        } else if (data instanceof FloatBuffer) {
            GLES20.glBufferSubData((int)target, (long)offset, (FloatBuffer)((FloatBuffer)data));
        } else if (data instanceof ShortBuffer) {
            GLES20.glBufferSubData((int)target, (long)offset, (ShortBuffer)((ShortBuffer)data));
        } else {
            throw new GdxRuntimeException("Buffer data of type " + data.getClass().getName() + " not supported in GLES20.");
        }
    }

    public int glCheckFramebufferStatus(int target) {
        return GLES20.glCheckFramebufferStatus((int)target);
    }

    public void glClear(int mask) {
        GLES20.glClear((int)mask);
    }

    public void glClearColor(float red, float green, float blue, float alpha) {
        GLES20.glClearColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void glClearDepthf(float depth) {
        GLES20.glClearDepthf((float)depth);
    }

    public void glClearStencil(int s) {
        GLES20.glClearStencil((int)s);
    }

    public void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        GLES20.glColorMask((boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
    }

    public void glCompileShader(int shader) {
        GLES20.glCompileShader((int)shader);
    }

    public void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, Buffer data) {
        if (!(data instanceof ByteBuffer)) {
            throw new GdxRuntimeException("Can't use " + data.getClass().getName() + " with this method. Use ByteBuffer instead.");
        }
        GLES20.glCompressedTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (ByteBuffer)((ByteBuffer)data));
    }

    public void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, Buffer data) {
        throw new GdxRuntimeException("not implemented");
    }

    public void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border) {
        GLES20.glCopyTexImage2D((int)target, (int)level, (int)internalformat, (int)x, (int)y, (int)width, (int)height, (int)border);
    }

    public void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        GLES20.glCopyTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)x, (int)y, (int)width, (int)height);
    }

    public int glCreateProgram() {
        return GLES20.glCreateProgram();
    }

    public int glCreateShader(int type) {
        return GLES20.glCreateShader((int)type);
    }

    public void glCullFace(int mode) {
        GLES20.glCullFace((int)mode);
    }

    public void glDeleteBuffers(int n, IntBuffer buffers) {
        GLES20.glDeleteBuffers((IntBuffer)buffers);
    }

    public void glDeleteBuffer(int buffer) {
        GLES20.glDeleteBuffers((int)buffer);
    }

    public void glDeleteFramebuffers(int n, IntBuffer framebuffers) {
        GLES20.glDeleteFramebuffers((IntBuffer)framebuffers);
    }

    public void glDeleteFramebuffer(int framebuffer) {
        GLES20.glDeleteFramebuffers((int)framebuffer);
    }

    public void glDeleteProgram(int program) {
        GLES20.glDeleteProgram((int)program);
    }

    public void glDeleteRenderbuffers(int n, IntBuffer renderbuffers) {
        GLES20.glDeleteRenderbuffers((IntBuffer)renderbuffers);
    }

    public void glDeleteRenderbuffer(int renderbuffer) {
        GLES20.glDeleteRenderbuffers((int)renderbuffer);
    }

    public void glDeleteShader(int shader) {
        GLES20.glDeleteShader((int)shader);
    }

    public void glDeleteTextures(int n, IntBuffer textures) {
        GLES20.glDeleteTextures((IntBuffer)textures);
    }

    public void glDeleteTexture(int texture) {
        GLES20.glDeleteTextures((int)texture);
    }

    public void glDepthFunc(int func) {
        GLES20.glDepthFunc((int)func);
    }

    public void glDepthMask(boolean flag) {
        GLES20.glDepthMask((boolean)flag);
    }

    public void glDepthRangef(float zNear, float zFar) {
        GLES20.glDepthRangef((float)zNear, (float)zFar);
    }

    public void glDetachShader(int program, int shader) {
        GLES20.glDetachShader((int)program, (int)shader);
    }

    public void glDisable(int cap) {
        GLES20.glDisable((int)cap);
    }

    public void glDisableVertexAttribArray(int index) {
        GLES20.glDisableVertexAttribArray((int)index);
    }

    public void glDrawArrays(int mode, int first, int count) {
        GLES20.glDrawArrays((int)mode, (int)first, (int)count);
    }

    public void glDrawElements(int mode, int count, int type, Buffer indices) {
        if (indices instanceof ShortBuffer && type == 5123) {
            ShortBuffer sb = (ShortBuffer)indices;
            int position = sb.position();
            int oldLimit = sb.limit();
            sb.limit(position + count);
            GLES20.glDrawElements((int)mode, (ShortBuffer)sb);
            sb.limit(oldLimit);
        } else if (indices instanceof ByteBuffer && type == 5123) {
            ShortBuffer sb = ((ByteBuffer)indices).asShortBuffer();
            int position = sb.position();
            int oldLimit = sb.limit();
            sb.limit(position + count);
            GLES20.glDrawElements((int)mode, (ShortBuffer)sb);
            sb.limit(oldLimit);
        } else if (indices instanceof ByteBuffer && type == 5121) {
            ByteBuffer bb = (ByteBuffer)indices;
            int position = bb.position();
            int oldLimit = bb.limit();
            bb.limit(position + count);
            GLES20.glDrawElements((int)mode, (ByteBuffer)bb);
            bb.limit(oldLimit);
        } else {
            throw new GdxRuntimeException("Can't use " + indices.getClass().getName() + " with this method. Use ShortBuffer or ByteBuffer instead. Blame LWJGL");
        }
    }

    public void glEnable(int cap) {
        GLES20.glEnable((int)cap);
    }

    public void glEnableVertexAttribArray(int index) {
        GLES20.glEnableVertexAttribArray((int)index);
    }

    public void glFinish() {
        GLES20.glFinish();
    }

    public void glFlush() {
        GLES20.glFlush();
    }

    public void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        GLES20.glFramebufferRenderbuffer((int)target, (int)attachment, (int)renderbuffertarget, (int)renderbuffer);
    }

    public void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        GLES20.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
    }

    public void glFrontFace(int mode) {
        GLES20.glFrontFace((int)mode);
    }

    public void glGenBuffers(int n, IntBuffer buffers) {
        GLES20.glGenBuffers((IntBuffer)buffers);
    }

    public int glGenBuffer() {
        return GLES20.glGenBuffers();
    }

    public void glGenFramebuffers(int n, IntBuffer framebuffers) {
        GLES20.glGenFramebuffers((IntBuffer)framebuffers);
    }

    public int glGenFramebuffer() {
        return GLES20.glGenFramebuffers();
    }

    public void glGenRenderbuffers(int n, IntBuffer renderbuffers) {
        GLES20.glGenRenderbuffers((IntBuffer)renderbuffers);
    }

    public int glGenRenderbuffer() {
        return GLES20.glGenRenderbuffers();
    }

    public void glGenTextures(int n, IntBuffer textures) {
        GLES20.glGenTextures((IntBuffer)textures);
    }

    public int glGenTexture() {
        return GLES20.glGenTextures();
    }

    public void glGenerateMipmap(int target) {
        GLES20.glGenerateMipmap((int)target);
    }

    public String glGetActiveAttrib(int program, int index, IntBuffer size, IntBuffer type) {
        return GLES20.glGetActiveAttrib((int)program, (int)index, (int)256, (IntBuffer)size, (IntBuffer)type);
    }

    public String glGetActiveUniform(int program, int index, IntBuffer size, IntBuffer type) {
        return GLES20.glGetActiveUniform((int)program, (int)index, (int)256, (IntBuffer)size, (IntBuffer)type);
    }

    public void glGetAttachedShaders(int program, int maxcount, Buffer count, IntBuffer shaders) {
        GLES20.glGetAttachedShaders((int)program, (IntBuffer)((IntBuffer)count), (IntBuffer)shaders);
    }

    public int glGetAttribLocation(int program, String name) {
        return GLES20.glGetAttribLocation((int)program, (CharSequence)name);
    }

    public void glGetBooleanv(int pname, Buffer params) {
        GLES20.glGetBooleanv((int)pname, (ByteBuffer)((ByteBuffer)params));
    }

    public void glGetBufferParameteriv(int target, int pname, IntBuffer params) {
        GLES20.glGetBufferParameteriv((int)target, (int)pname, (IntBuffer)params);
    }

    public int glGetError() {
        return GLES20.glGetError();
    }

    public void glGetFloatv(int pname, FloatBuffer params) {
        GLES20.glGetFloatv((int)pname, (FloatBuffer)params);
    }

    public void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, IntBuffer params) {
        GLES20.glGetFramebufferAttachmentParameteriv((int)target, (int)attachment, (int)pname, (IntBuffer)params);
    }

    public void glGetIntegerv(int pname, IntBuffer params) {
        GLES20.glGetIntegerv((int)pname, (IntBuffer)params);
    }

    public String glGetProgramInfoLog(int program) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(10240);
        buffer.order(ByteOrder.nativeOrder());
        ByteBuffer tmp = ByteBuffer.allocateDirect(4);
        tmp.order(ByteOrder.nativeOrder());
        IntBuffer intBuffer = tmp.asIntBuffer();
        GLES20.glGetProgramInfoLog((int)program, (IntBuffer)intBuffer, (ByteBuffer)buffer);
        int numBytes = intBuffer.get(0);
        byte[] bytes = new byte[numBytes];
        buffer.get(bytes);
        return new String(bytes);
    }

    public void glGetProgramiv(int program, int pname, IntBuffer params) {
        GLES20.glGetProgramiv((int)program, (int)pname, (IntBuffer)params);
    }

    public void glGetRenderbufferParameteriv(int target, int pname, IntBuffer params) {
        GLES20.glGetRenderbufferParameteriv((int)target, (int)pname, (IntBuffer)params);
    }

    public String glGetShaderInfoLog(int shader) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(10240);
        buffer.order(ByteOrder.nativeOrder());
        ByteBuffer tmp = ByteBuffer.allocateDirect(4);
        tmp.order(ByteOrder.nativeOrder());
        IntBuffer intBuffer = tmp.asIntBuffer();
        GLES20.glGetShaderInfoLog((int)shader, (IntBuffer)intBuffer, (ByteBuffer)buffer);
        int numBytes = intBuffer.get(0);
        byte[] bytes = new byte[numBytes];
        buffer.get(bytes);
        return new String(bytes);
    }

    public void glGetShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range, IntBuffer precision) {
        throw new UnsupportedOperationException("unsupported, won't implement");
    }

    public void glGetShaderiv(int shader, int pname, IntBuffer params) {
        GLES20.glGetShaderiv((int)shader, (int)pname, (IntBuffer)params);
    }

    public String glGetString(int name) {
        return GLES20.glGetString((int)name);
    }

    public void glGetTexParameterfv(int target, int pname, FloatBuffer params) {
        GLES20.glGetTexParameterfv((int)target, (int)pname, (FloatBuffer)params);
    }

    public void glGetTexParameteriv(int target, int pname, IntBuffer params) {
        GLES20.glGetTexParameteriv((int)target, (int)pname, (IntBuffer)params);
    }

    public int glGetUniformLocation(int program, String name) {
        return GLES20.glGetUniformLocation((int)program, (CharSequence)name);
    }

    public void glGetUniformfv(int program, int location, FloatBuffer params) {
        GLES20.glGetUniformfv((int)program, (int)location, (FloatBuffer)params);
    }

    public void glGetUniformiv(int program, int location, IntBuffer params) {
        GLES20.glGetUniformiv((int)program, (int)location, (IntBuffer)params);
    }

    public void glGetVertexAttribPointerv(int index, int pname, Buffer pointer) {
        throw new UnsupportedOperationException("unsupported, won't implement");
    }

    public void glGetVertexAttribfv(int index, int pname, FloatBuffer params) {
        GLES20.glGetVertexAttribfv((int)index, (int)pname, (FloatBuffer)params);
    }

    public void glGetVertexAttribiv(int index, int pname, IntBuffer params) {
        GLES20.glGetVertexAttribiv((int)index, (int)pname, (IntBuffer)params);
    }

    public void glHint(int target, int mode) {
        GLES20.glHint((int)target, (int)mode);
    }

    public boolean glIsBuffer(int buffer) {
        return GLES20.glIsBuffer((int)buffer);
    }

    public boolean glIsEnabled(int cap) {
        return GLES20.glIsEnabled((int)cap);
    }

    public boolean glIsFramebuffer(int framebuffer) {
        return GLES20.glIsFramebuffer((int)framebuffer);
    }

    public boolean glIsProgram(int program) {
        return GLES20.glIsProgram((int)program);
    }

    public boolean glIsRenderbuffer(int renderbuffer) {
        return GLES20.glIsRenderbuffer((int)renderbuffer);
    }

    public boolean glIsShader(int shader) {
        return GLES20.glIsShader((int)shader);
    }

    public boolean glIsTexture(int texture) {
        return GLES20.glIsTexture((int)texture);
    }

    public void glLineWidth(float width) {
        GLES20.glLineWidth((float)width);
    }

    public void glLinkProgram(int program) {
        GLES20.glLinkProgram((int)program);
    }

    public void glPixelStorei(int pname, int param) {
        GLES20.glPixelStorei((int)pname, (int)param);
    }

    public void glPolygonOffset(float factor, float units) {
        GLES20.glPolygonOffset((float)factor, (float)units);
    }

    public void glReadPixels(int x, int y, int width, int height, int format, int type, Buffer pixels) {
        if (pixels instanceof ByteBuffer) {
            GLES20.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (ByteBuffer)((ByteBuffer)pixels));
        } else if (pixels instanceof ShortBuffer) {
            GLES20.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (ShortBuffer)((ShortBuffer)pixels));
        } else if (pixels instanceof IntBuffer) {
            GLES20.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (IntBuffer)((IntBuffer)pixels));
        } else if (pixels instanceof FloatBuffer) {
            GLES20.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (FloatBuffer)((FloatBuffer)pixels));
        } else {
            throw new GdxRuntimeException("Can't use " + pixels.getClass().getName() + " with this method. Use ByteBuffer, ShortBuffer, IntBuffer or FloatBuffer instead.");
        }
    }

    public void glReleaseShaderCompiler() {
    }

    public void glRenderbufferStorage(int target, int internalformat, int width, int height) {
        GLES20.glRenderbufferStorage((int)target, (int)internalformat, (int)width, (int)height);
    }

    public void glSampleCoverage(float value, boolean invert) {
        GLES20.glSampleCoverage((float)value, (boolean)invert);
    }

    public void glScissor(int x, int y, int width, int height) {
        GLES20.glScissor((int)x, (int)y, (int)width, (int)height);
    }

    public void glShaderBinary(int n, IntBuffer shaders, int binaryformat, Buffer binary, int length) {
        throw new UnsupportedOperationException("unsupported, won't implement");
    }

    public void glShaderSource(int shader, String string) {
        GLES20.glShaderSource((int)shader, (CharSequence)string);
    }

    public void glStencilFunc(int func, int ref, int mask) {
        GLES20.glStencilFunc((int)func, (int)ref, (int)mask);
    }

    public void glStencilFuncSeparate(int face, int func, int ref, int mask) {
        GLES20.glStencilFuncSeparate((int)face, (int)func, (int)ref, (int)mask);
    }

    public void glStencilMask(int mask) {
        GLES20.glStencilMask((int)mask);
    }

    public void glStencilMaskSeparate(int face, int mask) {
        GLES20.glStencilMaskSeparate((int)face, (int)mask);
    }

    public void glStencilOp(int fail, int zfail, int zpass) {
        GLES20.glStencilOp((int)fail, (int)zfail, (int)zpass);
    }

    public void glStencilOpSeparate(int face, int fail, int zfail, int zpass) {
        GLES20.glStencilOpSeparate((int)face, (int)fail, (int)zfail, (int)zpass);
    }

    public void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, Buffer pixels) {
        if (pixels == null) {
            GLES20.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (ByteBuffer)null);
        } else if (pixels instanceof ByteBuffer) {
            GLES20.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (ByteBuffer)((ByteBuffer)pixels));
        } else if (pixels instanceof ShortBuffer) {
            GLES20.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (ShortBuffer)((ShortBuffer)pixels));
        } else if (pixels instanceof IntBuffer) {
            GLES20.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (IntBuffer)((IntBuffer)pixels));
        } else if (pixels instanceof FloatBuffer) {
            GLES20.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (FloatBuffer)((FloatBuffer)pixels));
        } else {
            throw new GdxRuntimeException("Can't use " + pixels.getClass().getName() + " with this method. Use ByteBuffer, ShortBuffer, IntBuffer, FloatBuffer or DoubleBuffer instead.");
        }
    }

    public void glTexParameterf(int target, int pname, float param) {
        GLES20.glTexParameterf((int)target, (int)pname, (float)param);
    }

    public void glTexParameterfv(int target, int pname, FloatBuffer params) {
        GLES20.glTexParameterfv((int)target, (int)pname, (FloatBuffer)params);
    }

    public void glTexParameteri(int target, int pname, int param) {
        GLES20.glTexParameteri((int)target, (int)pname, (int)param);
    }

    public void glTexParameteriv(int target, int pname, IntBuffer params) {
        GLES20.glTexParameteriv((int)target, (int)pname, (IntBuffer)params);
    }

    public void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, Buffer pixels) {
        if (pixels instanceof ByteBuffer) {
            GLES20.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (ByteBuffer)((ByteBuffer)pixels));
        } else if (pixels instanceof ShortBuffer) {
            GLES20.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (ShortBuffer)((ShortBuffer)pixels));
        } else if (pixels instanceof IntBuffer) {
            GLES20.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (IntBuffer)((IntBuffer)pixels));
        } else if (pixels instanceof FloatBuffer) {
            GLES20.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (FloatBuffer)((FloatBuffer)pixels));
        } else {
            throw new GdxRuntimeException("Can't use " + pixels.getClass().getName() + " with this method. Use ByteBuffer, ShortBuffer, IntBuffer, FloatBuffer or DoubleBuffer instead.");
        }
    }

    public void glUniform1f(int location, float x) {
        GLES20.glUniform1f((int)location, (float)x);
    }

    public void glUniform1fv(int location, int count, FloatBuffer v) {
        GLES20.glUniform1fv((int)location, (FloatBuffer)v);
    }

    public void glUniform1fv(int location, int count, float[] v, int offset) {
        GLES20.glUniform1fv((int)location, (FloatBuffer)this.toFloatBuffer(v, offset, count));
    }

    public void glUniform1i(int location, int x) {
        GLES20.glUniform1i((int)location, (int)x);
    }

    public void glUniform1iv(int location, int count, IntBuffer v) {
        GLES20.glUniform1iv((int)location, (IntBuffer)v);
    }

    public void glUniform1iv(int location, int count, int[] v, int offset) {
        GLES20.glUniform1iv((int)location, (IntBuffer)this.toIntBuffer(v, offset, count));
    }

    public void glUniform2f(int location, float x, float y) {
        GLES20.glUniform2f((int)location, (float)x, (float)y);
    }

    public void glUniform2fv(int location, int count, FloatBuffer v) {
        GLES20.glUniform2fv((int)location, (FloatBuffer)v);
    }

    public void glUniform2fv(int location, int count, float[] v, int offset) {
        GLES20.glUniform2fv((int)location, (FloatBuffer)this.toFloatBuffer(v, offset, count << 1));
    }

    public void glUniform2i(int location, int x, int y) {
        GLES20.glUniform2i((int)location, (int)x, (int)y);
    }

    public void glUniform2iv(int location, int count, IntBuffer v) {
        GLES20.glUniform2iv((int)location, (IntBuffer)v);
    }

    public void glUniform2iv(int location, int count, int[] v, int offset) {
        GLES20.glUniform2iv((int)location, (IntBuffer)this.toIntBuffer(v, offset, count << 1));
    }

    public void glUniform3f(int location, float x, float y, float z) {
        GLES20.glUniform3f((int)location, (float)x, (float)y, (float)z);
    }

    public void glUniform3fv(int location, int count, FloatBuffer v) {
        GLES20.glUniform3fv((int)location, (FloatBuffer)v);
    }

    public void glUniform3fv(int location, int count, float[] v, int offset) {
        GLES20.glUniform3fv((int)location, (FloatBuffer)this.toFloatBuffer(v, offset, count * 3));
    }

    public void glUniform3i(int location, int x, int y, int z) {
        GLES20.glUniform3i((int)location, (int)x, (int)y, (int)z);
    }

    public void glUniform3iv(int location, int count, IntBuffer v) {
        GLES20.glUniform3iv((int)location, (IntBuffer)v);
    }

    public void glUniform3iv(int location, int count, int[] v, int offset) {
        GLES20.glUniform3iv((int)location, (IntBuffer)this.toIntBuffer(v, offset, count * 3));
    }

    public void glUniform4f(int location, float x, float y, float z, float w) {
        GLES20.glUniform4f((int)location, (float)x, (float)y, (float)z, (float)w);
    }

    public void glUniform4fv(int location, int count, FloatBuffer v) {
        GLES20.glUniform4fv((int)location, (FloatBuffer)v);
    }

    public void glUniform4fv(int location, int count, float[] v, int offset) {
        GLES20.glUniform4fv((int)location, (FloatBuffer)this.toFloatBuffer(v, offset, count << 2));
    }

    public void glUniform4i(int location, int x, int y, int z, int w) {
        GLES20.glUniform4i((int)location, (int)x, (int)y, (int)z, (int)w);
    }

    public void glUniform4iv(int location, int count, IntBuffer v) {
        GLES20.glUniform4iv((int)location, (IntBuffer)v);
    }

    public void glUniform4iv(int location, int count, int[] v, int offset) {
        GLES20.glUniform4iv((int)location, (IntBuffer)this.toIntBuffer(v, offset, count << 2));
    }

    public void glUniformMatrix2fv(int location, int count, boolean transpose, FloatBuffer value) {
        GLES20.glUniformMatrix2fv((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    public void glUniformMatrix2fv(int location, int count, boolean transpose, float[] value, int offset) {
        GLES20.glUniformMatrix2fv((int)location, (boolean)transpose, (FloatBuffer)this.toFloatBuffer(value, offset, count << 2));
    }

    public void glUniformMatrix3fv(int location, int count, boolean transpose, FloatBuffer value) {
        GLES20.glUniformMatrix3fv((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    public void glUniformMatrix3fv(int location, int count, boolean transpose, float[] value, int offset) {
        GLES20.glUniformMatrix3fv((int)location, (boolean)transpose, (FloatBuffer)this.toFloatBuffer(value, offset, count * 9));
    }

    public void glUniformMatrix4fv(int location, int count, boolean transpose, FloatBuffer value) {
        GLES20.glUniformMatrix4fv((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    public void glUniformMatrix4fv(int location, int count, boolean transpose, float[] value, int offset) {
        GLES20.glUniformMatrix4fv((int)location, (boolean)transpose, (FloatBuffer)this.toFloatBuffer(value, offset, count << 4));
    }

    public void glUseProgram(int program) {
        GLES20.glUseProgram((int)program);
    }

    public void glValidateProgram(int program) {
        GLES20.glValidateProgram((int)program);
    }

    public void glVertexAttrib1f(int indx, float x) {
        GLES20.glVertexAttrib1f((int)indx, (float)x);
    }

    public void glVertexAttrib1fv(int indx, FloatBuffer values) {
        GLES20.glVertexAttrib1f((int)indx, (float)values.get());
    }

    public void glVertexAttrib2f(int indx, float x, float y) {
        GLES20.glVertexAttrib2f((int)indx, (float)x, (float)y);
    }

    public void glVertexAttrib2fv(int indx, FloatBuffer values) {
        GLES20.glVertexAttrib2f((int)indx, (float)values.get(), (float)values.get());
    }

    public void glVertexAttrib3f(int indx, float x, float y, float z) {
        GLES20.glVertexAttrib3f((int)indx, (float)x, (float)y, (float)z);
    }

    public void glVertexAttrib3fv(int indx, FloatBuffer values) {
        GLES20.glVertexAttrib3f((int)indx, (float)values.get(), (float)values.get(), (float)values.get());
    }

    public void glVertexAttrib4f(int indx, float x, float y, float z, float w) {
        GLES20.glVertexAttrib4f((int)indx, (float)x, (float)y, (float)z, (float)w);
    }

    public void glVertexAttrib4fv(int indx, FloatBuffer values) {
        GLES20.glVertexAttrib4f((int)indx, (float)values.get(), (float)values.get(), (float)values.get(), (float)values.get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void glVertexAttribPointer(int indx, int size, int type, boolean normalized, int stride, Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            if (type == 5120) {
                GLES20.glVertexAttribPointer((int)indx, (int)size, (int)type, (boolean)normalized, (int)stride, (ByteBuffer)((ByteBuffer)buffer));
                return;
            } else if (type == 5121) {
                GLES20.glVertexAttribPointer((int)indx, (int)size, (int)type, (boolean)normalized, (int)stride, (ByteBuffer)((ByteBuffer)buffer));
                return;
            } else if (type == 5122) {
                GLES20.glVertexAttribPointer((int)indx, (int)size, (int)type, (boolean)normalized, (int)stride, (ShortBuffer)((ByteBuffer)buffer).asShortBuffer());
                return;
            } else if (type == 5123) {
                GLES20.glVertexAttribPointer((int)indx, (int)size, (int)type, (boolean)normalized, (int)stride, (ShortBuffer)((ByteBuffer)buffer).asShortBuffer());
                return;
            } else {
                if (type != 5126) throw new GdxRuntimeException("Can't use " + buffer.getClass().getName() + " with type " + type + " with this method. Use ByteBuffer and one of GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT or GL_FLOAT for type.");
                GLES20.glVertexAttribPointer((int)indx, (int)size, (int)type, (boolean)normalized, (int)stride, (FloatBuffer)((ByteBuffer)buffer).asFloatBuffer());
            }
            return;
        } else {
            if (!(buffer instanceof FloatBuffer)) throw new GdxRuntimeException("Can't use " + buffer.getClass().getName() + " with this method. Use ByteBuffer instead.");
            if (type != 5126) throw new GdxRuntimeException("Can't use " + buffer.getClass().getName() + " with type " + type + " with this method.");
            GLES20.glVertexAttribPointer((int)indx, (int)size, (int)type, (boolean)normalized, (int)stride, (FloatBuffer)((FloatBuffer)buffer));
        }
    }

    public void glViewport(int x, int y, int width, int height) {
        GLES20.glViewport((int)x, (int)y, (int)width, (int)height);
    }

    public void glDrawElements(int mode, int count, int type, int indices) {
        GLES20.glDrawElements((int)mode, (int)count, (int)type, (long)indices);
    }

    public void glVertexAttribPointer(int indx, int size, int type, boolean normalized, int stride, int ptr) {
        GLES20.glVertexAttribPointer((int)indx, (int)size, (int)type, (boolean)normalized, (int)stride, (long)ptr);
    }
}

