/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tools.bmfont;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl.LwjglApplication;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.PixmapPacker;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.tools.bmfont.BitmapFontWriter;
import com.badlogic.gdx.tools.hiero.Hiero;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ScreenUtils;

public class BitmapFontWriterTest
extends ApplicationAdapter {
    SpriteBatch spriteBatch;
    ShapeRenderer renderer;
    BitmapFont generatedFont;
    BitmapFont loadedFont;
    BitmapFont font;

    public void create() {
        BitmapFontWriter.FontInfo info = new BitmapFontWriter.FontInfo();
        info.padding = new BitmapFontWriter.Padding(0, 0, 0, 0);
        FreeTypeFontGenerator.FreeTypeFontParameter param = new FreeTypeFontGenerator.FreeTypeFontParameter();
        param.size = 13;
        param.shadowOffsetY = 3;
        param.renderCount = 3;
        param.shadowColor = new Color(0.0f, 0.0f, 0.0f, 1.0f);
        param.characters = Hiero.EXTENDED_CHARS;
        param.packer = new PixmapPacker(1024, 1024, Pixmap.Format.RGBA8888, 2, false, (PixmapPacker.PackStrategy)new PixmapPacker.SkylineStrategy());
        FreeTypeFontGenerator generator = new FreeTypeFontGenerator(Gdx.files.absolute("../../tests/gdx-tests-android/assets/data/unbom.ttf"));
        this.generatedFont = generator.generateFont(param);
        info.overrideMetrics(this.generatedFont.getData());
        BitmapFontWriter.writeFont(this.generatedFont.getData(), new String[]{"bitmapWrittenFont.png"}, Gdx.files.local("bitmapWrittenFont.fnt"), info, 512, 512);
        BitmapFontWriter.writePixmaps((Array<PixmapPacker.Page>)param.packer.getPages(), Gdx.files.local(""), "bitmapWrittenFont");
        float ascent = this.generatedFont.getAscent();
        float descent = this.generatedFont.getDescent();
        float capHeight = this.generatedFont.getCapHeight();
        float lineHeight = this.generatedFont.getLineHeight();
        float spaceXadvance = this.generatedFont.getSpaceXadvance();
        float xHeight = this.generatedFont.getXHeight();
        this.loadedFont = new BitmapFont(Gdx.files.local("bitmapWrittenFont.fnt"));
        float loadedFontascent = this.loadedFont.getAscent();
        float loadedFontdescent = this.loadedFont.getDescent();
        float loadedFontcapHeight = this.loadedFont.getCapHeight();
        float loadedFontlineHeight = this.loadedFont.getLineHeight();
        float loadedFontspaceXadvance = this.loadedFont.getSpaceXadvance();
        float loadedFontxHeight = this.loadedFont.getXHeight();
        System.out.println("Ascent: " + ascent + " : " + loadedFontascent);
        System.out.println("Descent: " + descent + " : " + loadedFontdescent);
        System.out.println("Cap Height: " + capHeight + " : " + loadedFontcapHeight);
        System.out.println("Line height: " + lineHeight + " : " + loadedFontlineHeight);
        System.out.println("Space X advance: " + spaceXadvance + " : " + loadedFontspaceXadvance);
        System.out.println("xHeight: " + xHeight + " : " + loadedFontxHeight);
        if (!MathUtils.isEqual((float)ascent, (float)loadedFontascent)) {
            throw new GdxRuntimeException("Ascent is not equal");
        }
        if (!MathUtils.isEqual((float)descent, (float)loadedFontdescent)) {
            throw new GdxRuntimeException("Descent is not equal");
        }
        if (!MathUtils.isEqual((float)capHeight, (float)loadedFontcapHeight)) {
            throw new GdxRuntimeException("Cap height is not equal");
        }
        if (!MathUtils.isEqual((float)lineHeight, (float)loadedFontlineHeight)) {
            throw new GdxRuntimeException("Line Height is not equal");
        }
        if (!MathUtils.isEqual((float)spaceXadvance, (float)loadedFontspaceXadvance)) {
            throw new GdxRuntimeException("spaceXAdvance is not equal");
        }
        if (!MathUtils.isEqual((float)xHeight, (float)loadedFontxHeight)) {
            throw new GdxRuntimeException("xHeight is not equal");
        }
        this.spriteBatch = new SpriteBatch();
        this.renderer = new ShapeRenderer();
        this.renderer.setProjectionMatrix(this.spriteBatch.getProjectionMatrix());
        this.font = new BitmapFont();
    }

    public void render() {
        ScreenUtils.clear((float)1.0f, (float)0.5f, (float)0.5f, (float)1.0f);
        this.renderer.setProjectionMatrix(this.renderer.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight()));
        this.spriteBatch.setProjectionMatrix(this.spriteBatch.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight()));
        this.spriteBatch.begin();
        String text = "Sphinx of black quartz.";
        this.generatedFont.setColor(Color.RED);
        int viewHeight = Gdx.graphics.getHeight();
        this.font.setColor(Color.BLACK);
        this.font.draw((Batch)this.spriteBatch, (CharSequence)"draw position", 20.0f, (float)(viewHeight - 0));
        this.font.setColor(Color.BLUE);
        this.font.draw((Batch)this.spriteBatch, (CharSequence)"bounds", 20.0f, (float)(viewHeight - 20));
        this.font.setColor(Color.MAGENTA);
        this.font.draw((Batch)this.spriteBatch, (CharSequence)"baseline", 20.0f, (float)(viewHeight - 40));
        this.font.setColor(Color.GREEN);
        this.font.draw((Batch)this.spriteBatch, (CharSequence)"x height", 20.0f, (float)(viewHeight - 60));
        this.font.setColor(Color.CYAN);
        this.font.draw((Batch)this.spriteBatch, (CharSequence)"ascent", 20.0f, (float)(viewHeight - 80));
        this.font.setColor(Color.RED);
        this.font.draw((Batch)this.spriteBatch, (CharSequence)"descent", 20.0f, (float)(viewHeight - 100));
        this.font.setColor(Color.ORANGE);
        this.font.draw((Batch)this.spriteBatch, (CharSequence)"line height", 20.0f, (float)(viewHeight - 120));
        this.font.setColor(Color.LIGHT_GRAY);
        this.font.draw((Batch)this.spriteBatch, (CharSequence)"cap height", 20.0f, (float)(viewHeight - 140));
        this.generatedFont.setColor(Color.WHITE);
        this.spriteBatch.end();
        this.renderFontWithMetrics(this.generatedFont, text, 100.0f, 300.0f);
        this.renderFontWithMetrics(this.loadedFont, text, 100.0f, 200.0f);
    }

    private void renderFontWithMetrics(BitmapFont font, String text, float x, float y) {
        this.spriteBatch.begin();
        GlyphLayout layout = font.draw((Batch)this.spriteBatch, (CharSequence)text, x, y);
        this.spriteBatch.end();
        this.renderer.begin(ShapeRenderer.ShapeType.Filled);
        this.renderer.setColor(Color.BLACK);
        this.renderer.rect(x - 3.0f, y - 3.0f, 6.0f, 6.0f);
        this.renderer.end();
        float baseline = y - font.getCapHeight();
        this.renderer.begin(ShapeRenderer.ShapeType.Line);
        this.renderer.setColor(Color.LIGHT_GRAY);
        this.renderer.line(0.0f, y, 9999.0f, y);
        this.renderer.setColor(Color.MAGENTA);
        this.renderer.line(0.0f, baseline, 9999.0f, baseline);
        this.renderer.setColor(Color.GREEN);
        this.renderer.line(0.0f, baseline + font.getXHeight(), 9999.0f, baseline + font.getXHeight());
        this.renderer.setColor(Color.CYAN);
        this.renderer.line(0.0f, y + font.getAscent(), 9999.0f, y + font.getAscent());
        this.renderer.setColor(Color.RED);
        this.renderer.line(0.0f, baseline + font.getDescent(), 9999.0f, baseline + font.getDescent());
        this.renderer.setColor(Color.ORANGE);
        this.renderer.line(0.0f, y - font.getLineHeight(), 9999.0f, y - font.getLineHeight());
        this.renderer.end();
        this.renderer.begin(ShapeRenderer.ShapeType.Line);
        this.renderer.setColor(Color.BLUE);
        this.renderer.rect(x, y, layout.width, -layout.height);
        this.renderer.end();
    }

    public static void main(String[] args) throws Exception {
        new LwjglApplication((ApplicationListener)new BitmapFontWriterTest());
    }
}

