/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tools.particleeditor;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.Array;

public class CustomShading {
    private ShaderProgram shader;
    Array<String> extraTexturePaths = new Array();
    Array<Texture> extraTextures = new Array();
    String defaultVertexShaderCode;
    String defaultFragmentShaderCode;
    String vertexShaderCode;
    String fragmentShaderCode;
    FileHandle lastVertexShaderFile;
    FileHandle lastFragmentShaderFile;
    boolean hasShaderErrors;
    String shaderErrorMessage;
    boolean hasMissingSamplers;
    String missingSamplerMessage;

    public CustomShading() {
        this.shader = SpriteBatch.createDefaultShader();
        this.vertexShaderCode = this.defaultVertexShaderCode = this.shader.getVertexShaderSource();
        this.fragmentShaderCode = this.defaultFragmentShaderCode = this.shader.getFragmentShaderSource();
    }

    public void begin(SpriteBatch spriteBatch) {
        spriteBatch.setShader(this.shader);
        for (int i = 0; i < this.extraTextures.size; ++i) {
            ((Texture)this.extraTextures.get(i)).bind(i + 1);
        }
        Gdx.gl.glActiveTexture(33984);
    }

    public void end(SpriteBatch spriteBatch) {
        spriteBatch.setShader(null);
        for (int i = 0; i < this.extraTextures.size; ++i) {
            Gdx.gl.glActiveTexture(33985 + i);
            Gdx.gl.glBindTexture(((Texture)this.extraTextures.get((int)i)).glTarget, 0);
        }
        Gdx.gl.glActiveTexture(33984);
    }

    public void setVertexShaderFile(String absolutePath) {
        if (absolutePath == null) {
            this.lastVertexShaderFile = null;
            this.vertexShaderCode = this.defaultVertexShaderCode;
        } else {
            this.lastVertexShaderFile = Gdx.files.absolute(absolutePath);
            this.vertexShaderCode = this.lastVertexShaderFile.readString();
        }
        this.updateShader();
    }

    public void setFragmentShaderFile(String absolutePath) {
        if (absolutePath == null) {
            this.lastFragmentShaderFile = null;
            this.fragmentShaderCode = this.defaultFragmentShaderCode;
        } else {
            this.lastFragmentShaderFile = Gdx.files.absolute(absolutePath);
            this.fragmentShaderCode = this.lastFragmentShaderFile.readString();
        }
        this.updateShader();
    }

    public void reloadVertexShader() {
        if (this.lastVertexShaderFile != null) {
            this.vertexShaderCode = this.lastVertexShaderFile.readString();
        }
        this.updateShader();
    }

    public void reloadFragmentShader() {
        if (this.lastFragmentShaderFile != null) {
            this.fragmentShaderCode = this.lastFragmentShaderFile.readString();
        }
        this.updateShader();
    }

    private void updateShader() {
        ShaderProgram shader = new ShaderProgram(this.vertexShaderCode, this.fragmentShaderCode);
        if (shader.isCompiled()) {
            this.hasShaderErrors = false;
            this.shaderErrorMessage = null;
            if (this.shader != null) {
                this.shader.dispose();
            }
            this.shader = shader;
            this.updateSamplers();
        } else {
            this.hasShaderErrors = true;
            this.shaderErrorMessage = shader.getLog();
            shader.dispose();
        }
    }

    public void addTexture(String absolutePath) {
        this.extraTexturePaths.add((Object)absolutePath);
        this.extraTextures.add((Object)new Texture(Gdx.files.absolute(absolutePath)));
        this.updateSamplers();
    }

    public void swapTexture(int indexA, int indexB) {
        this.extraTexturePaths.swap(indexA, indexB);
        this.extraTextures.swap(indexA, indexB);
        this.updateSamplers();
    }

    public void removeTexture(int index) {
        this.extraTexturePaths.removeIndex(index);
        ((Texture)this.extraTextures.removeIndex(index)).dispose();
        this.updateSamplers();
    }

    public void reloadTexture(int index) {
        Texture previousTexture = (Texture)this.extraTextures.get(index);
        String path = (String)this.extraTexturePaths.get(index);
        Texture texture = new Texture(Gdx.files.absolute(path));
        previousTexture.dispose();
        this.extraTextures.set(index, (Object)texture);
    }

    private void updateSamplers() {
        this.hasMissingSamplers = false;
        this.missingSamplerMessage = "";
        this.shader.bind();
        for (int i = 0; i < this.extraTextures.size; ++i) {
            int unit = i + 1;
            int location = this.shader.fetchUniformLocation("u_texture" + unit, false);
            if (location >= 0) {
                this.shader.setUniformi(location, unit);
                continue;
            }
            this.hasMissingSamplers = true;
            this.missingSamplerMessage = this.missingSamplerMessage + "uniform sampler2D u_texture" + unit + " missing in shader program.\n";
        }
    }
}

