/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tools.particleeditor;

import com.badlogic.gdx.graphics.g2d.ParticleEmitter;
import com.badlogic.gdx.tools.particleeditor.EditorPanel;
import com.badlogic.gdx.tools.particleeditor.ParticleEditor;
import com.badlogic.gdx.utils.Array;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class ImagePanel
extends EditorPanel {
    JPanel imagesPanel;
    JList imageList;
    DefaultListModel<String> imageListModel;
    String lastDir;

    public ImagePanel(final ParticleEditor editor, String name, String description) {
        super(null, name, description);
        JPanel contentPanel = this.getContentPanel();
        JPanel buttonsPanel = new JPanel(new GridLayout(3, 1));
        contentPanel.add((Component)buttonsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        JButton addButton = new JButton("Add");
        buttonsPanel.add(addButton);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileDialog dialog = new FileDialog((Frame)editor, "Open Image", 0);
                if (ImagePanel.this.lastDir != null) {
                    dialog.setDirectory(ImagePanel.this.lastDir);
                }
                dialog.setMultipleMode(true);
                dialog.setVisible(true);
                File[] files = dialog.getFiles();
                String dir = dialog.getDirectory();
                if (dir == null || files == null) {
                    return;
                }
                ImagePanel.this.lastDir = dir;
                ParticleEmitter emitter = editor.getEmitter();
                for (File file : files) {
                    emitter.getImagePaths().add((Object)file.getAbsolutePath());
                }
                emitter.getSprites().clear();
                ImagePanel.this.updateImageList((Array<String>)emitter.getImagePaths());
            }
        });
        JButton defaultButton = new JButton("Default");
        buttonsPanel.add(defaultButton);
        defaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParticleEmitter emitter = editor.getEmitter();
                emitter.setImagePaths(new Array((Object[])new String[]{"particle.png"}));
                emitter.getSprites().clear();
                ImagePanel.this.updateImageList((Array<String>)emitter.getImagePaths());
            }
        });
        JButton defaultPremultButton = new JButton("Default (Premultiplied Alpha)");
        buttonsPanel.add(defaultPremultButton);
        defaultPremultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParticleEmitter emitter = editor.getEmitter();
                emitter.setImagePaths(new Array((Object[])new String[]{"pre_particle.png"}));
                emitter.getSprites().clear();
                ImagePanel.this.updateImageList((Array<String>)emitter.getImagePaths());
            }
        });
        JPanel modesPanel = new JPanel(new GridLayout(4, 1));
        contentPanel.add((Component)modesPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel label = new JLabel("Sprite mode:");
        modesPanel.add(label);
        ButtonGroup checkboxGroup = new ButtonGroup();
        JRadioButton singleCheckbox = new JRadioButton("Single", editor.getEmitter().getSpriteMode() == ParticleEmitter.SpriteMode.single);
        modesPanel.add(singleCheckbox);
        checkboxGroup.add(singleCheckbox);
        singleCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    editor.getEmitter().setSpriteMode(ParticleEmitter.SpriteMode.single);
                }
            }
        });
        JRadioButton randomCheckbox = new JRadioButton("Random", editor.getEmitter().getSpriteMode() == ParticleEmitter.SpriteMode.random);
        modesPanel.add(randomCheckbox);
        checkboxGroup.add(randomCheckbox);
        randomCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    editor.getEmitter().setSpriteMode(ParticleEmitter.SpriteMode.random);
                }
            }
        });
        JRadioButton animatedCheckbox = new JRadioButton("Animated", editor.getEmitter().getSpriteMode() == ParticleEmitter.SpriteMode.animated);
        modesPanel.add(animatedCheckbox);
        checkboxGroup.add(animatedCheckbox);
        animatedCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    editor.getEmitter().setSpriteMode(ParticleEmitter.SpriteMode.animated);
                }
            }
        });
        this.imagesPanel = new JPanel(new GridBagLayout());
        contentPanel.add((Component)this.imagesPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.imageListModel = new DefaultListModel();
        this.imageList = new JList<String>(this.imageListModel);
        this.imageList.setFixedCellWidth(250);
        this.imageList.setSelectionMode(0);
        this.imagesPanel.add((Component)this.imageList, new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        JButton upButton = new JButton("\u2191");
        this.imagesPanel.add((Component)upButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ImagePanel.this.imageList.getSelectedIndex();
                if (index <= 0) {
                    return;
                }
                ParticleEmitter emitter = editor.getEmitter();
                String imagePath = (String)emitter.getImagePaths().removeIndex(index);
                emitter.getImagePaths().insert(index - 1, (Object)imagePath);
                emitter.getSprites().clear();
                ImagePanel.this.updateImageList((Array<String>)emitter.getImagePaths());
                ImagePanel.this.imageList.setSelectedIndex(index - 1);
            }
        });
        JButton downButton = new JButton("\u2193");
        this.imagesPanel.add((Component)downButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ImagePanel.this.imageList.getSelectedIndex();
                if (index < 0 || index >= ImagePanel.this.imageList.getModel().getSize() - 1) {
                    return;
                }
                ParticleEmitter emitter = editor.getEmitter();
                String imagePath = (String)emitter.getImagePaths().removeIndex(index);
                emitter.getImagePaths().insert(index + 1, (Object)imagePath);
                emitter.getSprites().clear();
                ImagePanel.this.updateImageList((Array<String>)emitter.getImagePaths());
                ImagePanel.this.imageList.setSelectedIndex(index + 1);
            }
        });
        JButton removeButton = new JButton("X");
        this.imagesPanel.add((Component)removeButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ImagePanel.this.imageList.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                ParticleEmitter emitter = editor.getEmitter();
                Array imagePaths = emitter.getImagePaths();
                imagePaths.removeIndex(index);
                if (imagePaths.size == 0) {
                    imagePaths.add((Object)"particle.png");
                }
                emitter.getSprites().clear();
                ImagePanel.this.updateImageList((Array<String>)imagePaths);
            }
        });
        this.updateImageList((Array<String>)editor.getEmitter().getImagePaths());
    }

    public void updateImageList(Array<String> imagePaths) {
        if (imagePaths != null && imagePaths.size > 0) {
            this.imagesPanel.setVisible(true);
            this.imageListModel.removeAllElements();
            for (String imagePath : imagePaths) {
                this.imageListModel.addElement(new File(imagePath).getName());
            }
        } else {
            this.imagesPanel.setVisible(false);
        }
        this.revalidate();
    }
}

