/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tools.particleeditor;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.tools.particleeditor.EditorPanel;
import com.badlogic.gdx.tools.particleeditor.ParticleEditor;
import com.badlogic.gdx.tools.particleeditor.Slider;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

class PreviewImagePanel
extends EditorPanel {
    ParticleEditor editor;
    DefaultListModel<String> imageListModel;
    String lastDir;
    JPanel previewContainer;
    Slider valueX;
    Slider valueY;
    Slider valueWidth;
    Slider valueHeight;

    public PreviewImagePanel(final ParticleEditor editor, String name, String description) {
        super(null, name, description);
        this.editor = editor;
        JButton addButton = new JButton("Select preview");
        JButton removeButton = new JButton("Remove preview");
        this.previewContainer = new JPanel(new GridLayout(1, 1));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileDialog dialog = new FileDialog((Frame)editor, "Select Image", 0);
                if (PreviewImagePanel.this.lastDir != null) {
                    dialog.setDirectory(PreviewImagePanel.this.lastDir);
                }
                dialog.setVisible(true);
                String file = dialog.getFile();
                String dir = dialog.getDirectory();
                if (dir == null || file == null || file.trim().length() == 0) {
                    return;
                }
                PreviewImagePanel.this.lastDir = dir;
                try {
                    FileHandle absolute = Gdx.files.absolute(dir + file);
                    BufferedImage read = ImageIO.read(absolute.read());
                    Image scaledInstance = read.getScaledInstance(100, -1, 4);
                    ImageIcon image = new ImageIcon(scaledInstance);
                    JLabel previewImage = new JLabel(image);
                    previewImage.setOpaque(true);
                    previewImage.setBackground(Color.MAGENTA);
                    this.buildImagePanel(previewImage, absolute.file());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            private void buildImagePanel(JLabel previewImage, File file) {
                PreviewImagePanel.this.previewContainer.removeAll();
                PreviewImagePanel.this.previewContainer.add((Component)previewImage, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
                PreviewImagePanel.this.previewContainer.updateUI();
                PreviewImagePanel.this.editor.renderer.setImageBackground(file);
            }
        });
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.clearImagePanel();
            }

            private void clearImagePanel() {
                PreviewImagePanel.this.previewContainer.removeAll();
                PreviewImagePanel.this.previewContainer.updateUI();
                PreviewImagePanel.this.editor.renderer.setImageBackground(null);
            }
        });
        JPanel buttonPanel = new JPanel(new GridLayout());
        buttonPanel.add(addButton);
        buttonPanel.add(removeButton);
        this.getContentPanel().add((Component)buttonPanel, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.initializeComponents();
        this.getContentPanel().add((Component)this.previewContainer, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
    }

    private void initializeComponents() {
        JPanel contentPanel = this.getContentPanel();
        JLabel label = new JLabel("X:");
        contentPanel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 6), 0, 0));
        this.valueX = new Slider(0.0f, 0.0f, 99999.0f, 1.0f, 0.0f, 500.0f);
        contentPanel.add((Component)this.valueX, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("Y:");
        contentPanel.add((Component)label, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 0, 6), 0, 0));
        this.valueY = new Slider(0.0f, 0.0f, 99999.0f, 1.0f, 0.0f, 500.0f);
        contentPanel.add((Component)this.valueY, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("Width:");
        contentPanel.add((Component)label, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 6), 0, 0));
        this.valueWidth = new Slider(0.0f, 0.0f, 99999.0f, 1.0f, 0.0f, 500.0f);
        contentPanel.add((Component)this.valueWidth, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("Height:");
        contentPanel.add((Component)label, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 0, 6), 0, 0));
        this.valueHeight = new Slider(0.0f, 0.0f, 99999.0f, 1.0f, 0.0f, 500.0f);
        contentPanel.add((Component)this.valueHeight, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        float x = 0.0f;
        float y = 0.0f;
        float w = 64.0f;
        float h = 64.0f;
        if (this.editor.renderer.bgImage != null) {
            x = this.editor.renderer.bgImage.getX();
            y = this.editor.renderer.bgImage.getY();
            w = this.editor.renderer.bgImage.getWidth();
            h = this.editor.renderer.bgImage.getHeight();
        }
        this.valueX.setValue(x);
        this.valueY.setValue(y);
        this.valueWidth.setValue(w);
        this.valueHeight.setValue(h);
    }

    public void updateSpritePosition() {
        this.editor.renderer.updateImageBackgroundPosSize(this.valueX.getValue(), this.valueY.getValue(), this.valueWidth.getValue(), this.valueHeight.getValue());
    }
}

