/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.entity;

import com.karelherink.jdwpanalyzer.entity.Type;
import com.karelherink.jdwpanalyzer.model.constants.ClassStatus;
import java.awt.Component;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTable;

public class ReferenceType
extends Type {
    private static Map referenceTypes = Collections.synchronizedMap(new HashMap());
    private Byte typeTag;
    private String signature;
    private Long classLoaderId;
    private Integer modifiers;
    private Long[] fieldIds;
    private Long[] methodIds;
    private String sourceFile;
    private Long[] nestedTypeIds;
    private Integer status;
    private Long[] interfaceTypeIds;
    private Long classObjectId;
    private String sourceDebugExtension;
    private String signatureWithGeneric;
    private Long[] fieldsWithGenericFieldIds;
    private Long[] methodsWithGenericMethodIds;
    private byte[] classBytes;
    private Long superclass;

    public static ReferenceType getType(long typeId) {
        return ReferenceType.getType(new Long(typeId));
    }

    public static ReferenceType getType(Long typeId) {
        ReferenceType refType = (ReferenceType)referenceTypes.get(typeId);
        if (refType == null) {
            refType = new ReferenceType(typeId);
            referenceTypes.put(typeId, refType);
        }
        return refType;
    }

    @Override
    public Component getTypeDetailedView() {
        int i;
        Vector rowData = new Vector();
        Vector<String> colNames = new Vector<String>();
        colNames.add("Description");
        colNames.add("Value");
        Vector<Object> colData = new Vector<Object>();
        colData.add("RefTypeId:");
        colData.add(new Long(super.getTypeId()));
        rowData.add(colData);
        colData = new Vector();
        colData.add("Signature:");
        colData.add(this.signature);
        rowData.add(colData);
        colData = new Vector();
        colData.add("SignatureWithGeneric:");
        colData.add(this.signatureWithGeneric);
        rowData.add(colData);
        colData = new Vector();
        colData.add("SourceFile:");
        colData.add(this.sourceFile);
        rowData.add(colData);
        colData = new Vector();
        colData.add("ClassLoaderId:");
        colData.add(this.classLoaderId);
        rowData.add(colData);
        colData = new Vector();
        colData.add("Modifiers:");
        colData.add(this.modifiers);
        rowData.add(colData);
        colData = new Vector();
        colData.add("Num FieldIds:");
        colData.add(this.fieldIds == null ? null : String.valueOf(this.fieldIds.length));
        rowData.add(colData);
        if (this.fieldIds != null && this.fieldIds.length != 0) {
            for (i = 0; i < this.fieldIds.length; ++i) {
                colData = new Vector();
                colData.add("FieldId:");
                colData.add(this.fieldIds[i]);
                rowData.add(colData);
            }
        }
        colData = new Vector();
        colData.add("Num MethodIds:");
        colData.add(this.methodIds == null ? null : String.valueOf(this.methodIds.length));
        rowData.add(colData);
        if (this.methodIds != null && this.methodIds.length != 0) {
            for (i = 0; i < this.methodIds.length; ++i) {
                colData = new Vector();
                colData.add("MethodId:");
                colData.add(this.methodIds[i]);
                rowData.add(colData);
            }
        }
        colData = new Vector();
        colData.add("Num NestedTypeIds:");
        colData.add(this.nestedTypeIds == null ? null : String.valueOf(this.nestedTypeIds.length));
        rowData.add(colData);
        if (this.nestedTypeIds != null && this.nestedTypeIds.length != 0) {
            for (i = 0; i < this.nestedTypeIds.length; ++i) {
                colData = new Vector();
                colData.add("NestedTypeId:");
                colData.add(this.nestedTypeIds[i]);
                rowData.add(colData);
            }
        }
        colData = new Vector();
        colData.add("Status:");
        colData.add(this.status == null ? null : ClassStatus.asString(this.status));
        rowData.add(colData);
        colData = new Vector();
        colData.add("Num InterfaceTypeIds:");
        colData.add(this.interfaceTypeIds == null ? null : String.valueOf(this.interfaceTypeIds.length));
        rowData.add(colData);
        if (this.interfaceTypeIds != null && this.interfaceTypeIds.length != 0) {
            for (i = 0; i < this.interfaceTypeIds.length; ++i) {
                colData = new Vector();
                colData.add("InterfaceTypeId:");
                colData.add(this.interfaceTypeIds[i]);
                rowData.add(colData);
            }
        }
        colData = new Vector();
        colData.add("ClassObjectId:");
        colData.add(this.classObjectId);
        rowData.add(colData);
        colData = new Vector();
        colData.add("SourceDebugExtension:");
        colData.add(this.sourceDebugExtension);
        rowData.add(colData);
        colData = new Vector();
        colData.add("Num FieldWithGenericIds:");
        colData.add(this.fieldsWithGenericFieldIds == null ? null : String.valueOf(this.fieldsWithGenericFieldIds.length));
        if (this.fieldsWithGenericFieldIds != null && this.fieldsWithGenericFieldIds.length != 0) {
            for (i = 0; i < this.fieldsWithGenericFieldIds.length; ++i) {
                colData = new Vector();
                colData.add("FieldWithGenericId:");
                colData.add(this.fieldsWithGenericFieldIds[i]);
                rowData.add(colData);
            }
        }
        colData = new Vector();
        colData.add("Num MethodWithGenericIds:");
        colData.add(this.methodsWithGenericMethodIds == null ? null : String.valueOf(this.methodsWithGenericMethodIds.length));
        if (this.methodsWithGenericMethodIds != null && this.methodsWithGenericMethodIds.length != 0) {
            for (i = 0; i < this.methodsWithGenericMethodIds.length; ++i) {
                colData = new Vector();
                colData.add("MethodWithGenericId:");
                colData.add(this.methodsWithGenericMethodIds[i]);
                rowData.add(colData);
            }
        }
        return new JTable(rowData, colNames);
    }

    private ReferenceType(Long typeId) {
        super(typeId);
    }

    @Override
    public String toString() {
        return "ReferenceType";
    }

    public Long getClassLoaderId() {
        return this.classLoaderId;
    }

    public void setClassLoaderId(Long classLoaderId) {
        this.classLoaderId = classLoaderId;
    }

    public Long getClassObjectId() {
        return this.classObjectId;
    }

    public void setClassObjectId(Long classObjectId) {
        this.classObjectId = classObjectId;
    }

    public Long[] getFieldIds() {
        return this.fieldIds;
    }

    public void setFieldIds(Long[] fieldIds) {
        this.fieldIds = fieldIds;
    }

    public Long[] getFieldsWithGenericFieldIds() {
        return this.fieldsWithGenericFieldIds;
    }

    public void setFieldsWithGenericFieldIds(Long[] fieldsWithGenericFieldIds) {
        this.fieldsWithGenericFieldIds = fieldsWithGenericFieldIds;
    }

    public Long[] getInterfaceTypeIds() {
        return this.interfaceTypeIds;
    }

    public void setInterfaceTypeIds(Long[] interfaceTypeIds) {
        this.interfaceTypeIds = interfaceTypeIds;
    }

    public Long[] getMethodIds() {
        return this.methodIds;
    }

    public void setMethodIds(Long[] methodIds) {
        this.methodIds = methodIds;
    }

    public Long[] getMethodsWithGenericMethodIds() {
        return this.methodsWithGenericMethodIds;
    }

    public void setMethodsWithGenericMethodIds(Long[] methodsWithGenericMethodIds) {
        this.methodsWithGenericMethodIds = methodsWithGenericMethodIds;
    }

    public Integer getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(Integer modifiers) {
        this.modifiers = modifiers;
    }

    public Long[] getNestedTypeIds() {
        return this.nestedTypeIds;
    }

    public void setNestedTypeIds(Long[] nestedTypeIds) {
        this.nestedTypeIds = nestedTypeIds;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getSignatureWithGeneric() {
        return this.signatureWithGeneric;
    }

    public void setSignatureWithGeneric(String signatureWithGeneric) {
        this.signatureWithGeneric = signatureWithGeneric;
    }

    public String getSourceDebugExtension() {
        return this.sourceDebugExtension;
    }

    public void setSourceDebugExtension(String sourceDebugExtension) {
        this.sourceDebugExtension = sourceDebugExtension;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Byte getTypeTag() {
        return this.typeTag;
    }

    public void setTypeTag(Byte typeTag) {
        this.typeTag = typeTag;
    }

    public Long getSuperclass() {
        return this.superclass;
    }

    public void setSuperclass(Long superclass) {
        this.superclass = superclass;
    }

    public byte[] getClassBytes() {
        return this.classBytes;
    }

    public void setClassBytes(byte[] classBytes) {
        this.classBytes = classBytes;
    }
}

