/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.logger;

import com.karelherink.jdwpanalyzer.model.Packet;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class PacketLogReader
extends Thread {
    private DataInputStream disSeq;
    private DataOutputStream dos;

    public PacketLogReader(String logDirPath, DataOutputStream dos) throws IOException {
        this.dos = dos;
        File logDir = new File(logDirPath);
        if (!logDir.exists()) {
            throw new IllegalArgumentException("Log directory does NOT exist: " + logDirPath);
        }
        File seqLogFile = new File(logDir + File.separator + "seq.log");
        this.disSeq = new DataInputStream(new BufferedInputStream(new FileInputStream(seqLogFile)));
    }

    @Override
    public void run() {
        while (!PacketLogReader.interrupted()) {
            try {
                Packet p = Packet.readPacket(this.disSeq, false);
                Packet.writePacket(p, this.dos);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.interrupt();
            }
        }
        System.out.println("Reader interrupted!!");
    }
}

