/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.logger;

import com.karelherink.jdwpanalyzer.model.Packet;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;

public class PacketLogWriter
extends Thread {
    static final String LOG_SEQ_FILE = "seq.log";
    private LinkedList packetLogRequestQueue;
    private DataOutputStream dosSeq;

    public PacketLogWriter(String logDir) throws IOException {
        this.createFiles(logDir);
        this.packetLogRequestQueue = new LinkedList();
    }

    private void createFiles(String logDirPath) throws IOException {
        File logDir = new File(logDirPath);
        if (!logDir.exists() && !logDir.mkdirs()) {
            throw new IllegalArgumentException("Couldn't create directory: " + logDirPath);
        }
        File seqLogFile = new File(logDir + File.separator + LOG_SEQ_FILE);
        seqLogFile.delete();
        seqLogFile.createNewFile();
        this.dosSeq = new DataOutputStream(new FileOutputStream(seqLogFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestPacketLog(Packet packet) {
        LinkedList linkedList = this.packetLogRequestQueue;
        synchronized (linkedList) {
            this.packetLogRequestQueue.addFirst(packet);
            this.packetLogRequestQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!PacketLogWriter.interrupted()) {
            LinkedList linkedList = this.packetLogRequestQueue;
            synchronized (linkedList) {
                while (this.packetLogRequestQueue.size() == 0) {
                    try {
                        this.packetLogRequestQueue.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        this.interrupt();
                        break;
                    }
                }
                while (this.packetLogRequestQueue.size() > 0) {
                    Packet p = (Packet)this.packetLogRequestQueue.removeLast();
                    try {
                        Packet.writePacket(p, this.dosSeq);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        this.interrupt();
                        break;
                    }
                }
            }
        }
        System.out.println("Interrupted - shutting down logger.");
        try {
            this.dosSeq.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

