/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.model;

import com.karelherink.jdwpanalyzer.model.Key;
import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.PacketAnalyzer;
import com.karelherink.jdwpanalyzer.model.Request;
import com.karelherink.jdwpanalyzer.model.Response;
import java.util.HashMap;

public class AnalyzerManager {
    private static HashMap requestAnalyzers = new HashMap(40);
    private static HashMap responseAnalyzers = new HashMap(40);

    public static synchronized PacketAnalyzer createPacketAnalyzer(Packet packet) {
        int cmd;
        String analyzerClassName = null;
        PacketAnalyzer packetAnalyzer = null;
        if (packet instanceof Request) {
            int cmd2;
            Request request = (Request)packet;
            int cmdSet = request.getCmdSet();
            Key key = new Key(cmdSet, cmd2 = request.getCmd());
            packetAnalyzer = (PacketAnalyzer)requestAnalyzers.get(key);
            if (packetAnalyzer != null) {
                return packetAnalyzer;
            }
            analyzerClassName = "com.karelherink.jdwpanalyzer.request.Analyzer_" + cmdSet + "_" + cmd2;
            packetAnalyzer = AnalyzerManager.loadInstance(analyzerClassName);
            requestAnalyzers.put(key, packetAnalyzer);
            return packetAnalyzer;
        }
        Response response = (Response)packet;
        Request request = Request.getRequest(response.getId());
        int cmdSet = request.getCmdSet();
        Key key = new Key(cmdSet, cmd = request.getCmd());
        packetAnalyzer = (PacketAnalyzer)responseAnalyzers.get(key);
        if (packetAnalyzer != null) {
            return packetAnalyzer;
        }
        analyzerClassName = "com.karelherink.jdwpanalyzer.response.Analyzer_" + cmdSet + "_" + cmd;
        packetAnalyzer = AnalyzerManager.loadInstance(analyzerClassName);
        responseAnalyzers.put(key, packetAnalyzer);
        return packetAnalyzer;
    }

    private static PacketAnalyzer loadInstance(String analyzerClassName) {
        PacketAnalyzer packetAnalyzer = null;
        try {
            packetAnalyzer = (PacketAnalyzer)Class.forName(analyzerClassName).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            packetAnalyzer = new PacketAnalyzer();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            packetAnalyzer = new PacketAnalyzer();
        }
        catch (ClassNotFoundException e) {
            packetAnalyzer = new PacketAnalyzer();
        }
        return packetAnalyzer;
    }
}

