/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.model;

import com.karelherink.jdwpanalyzer.logger.PacketLogReader;
import com.karelherink.jdwpanalyzer.logger.PacketLogWriter;
import com.karelherink.jdwpanalyzer.model.AnalyzerManager;
import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.PacketAnalyzer;
import com.karelherink.jdwpanalyzer.model.Request;
import com.karelherink.jdwpanalyzer.model.Response;
import com.karelherink.jdwpanalyzer.ui.View;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class JDWPProxy {
    private PacketLogWriter packetLogWriter;
    static List sequentialRequests = Collections.synchronizedList(new ArrayList());
    private View view;
    private Socket socketVM;
    private Socket socketDebugger;

    public static void main(String[] args) throws NumberFormatException, IOException, UnknownHostException {
        if (args.length != 4 && args.length != 5 && args.length != 1) {
            System.err.println("\nUsage: java -jar JDWPAnalyzer.jar (<inPort> <outAddress> <reqDelay> <respDelay> [<log_dir>]) | <log_dir>\n\ninPort     = port to which debugger will connect\noutAddress = address as 'host:port' on which the remote VM is accepting debugger connections.\n             localhost addresses can just specify a port - no host required\nreqDelay   = num MS to wait before passing each request to VM\nrespDelay  = num MS to wait before passing each response to debugger\nlog_dir    = log directory path for writing or reading\n");
            System.exit(1);
        }
        if (args.length >= 4) {
            int inPort = Integer.parseInt(args[0]);
            String outAddress = args[1];
            int reqDelay = Integer.parseInt(args[2]);
            int respDelay = Integer.parseInt(args[3]);
            if (args.length == 5) {
                String logFile = args[4];
                new JDWPProxy(inPort, outAddress, reqDelay, respDelay, logFile);
            } else {
                new JDWPProxy(inPort, outAddress, reqDelay, respDelay, null);
            }
        } else {
            new JDWPProxy(args[0]);
        }
    }

    public JDWPProxy(int inPort, String outAddress, int reqDelay, int respDelay, String logDir) throws IOException {
        this.activeMode(inPort, outAddress, reqDelay, respDelay, logDir);
    }

    public JDWPProxy(String logDir) throws IOException {
        this.passiveMode(logDir);
    }

    private void passiveMode(String logDir) throws IOException {
        PipedInputStream pin = new PipedInputStream();
        PipedOutputStream pout = new PipedOutputStream();
        pin.connect(pout);
        DataInputStream din = new DataInputStream(pin);
        DataOutputStream dos = new DataOutputStream(pout);
        T t = new T(din, null, 0);
        t.setName("Sequential reader");
        System.out.println("Starting replay..");
        this.view = new View(this, sequentialRequests);
        t.setDaemon(true);
        t.start();
        PacketLogReader packetLogReader = new PacketLogReader(logDir, dos);
        packetLogReader.setDaemon(true);
        packetLogReader.start();
    }

    private void activeMode(int inPort, String outAddress, int reqDelay, int respDelay, String logDir) throws IOException {
        if (logDir != null) {
            this.initLogWriter(logDir);
        }
        try (ServerSocket serverSock = new ServerSocket(inPort);){
            serverSock.setReuseAddress(true);
            System.out.println("JDWPProxy: waiting for connection on port " + inPort + "..");
            this.socketDebugger = serverSock.accept();
        }
        if (outAddress.indexOf(58) == -1) {
            System.out.println("JDWPProxy: Connection received, connecting to VM on port " + outAddress + "..");
            this.socketVM = new Socket(InetAddress.getLocalHost(), (int)Integer.valueOf(outAddress));
        } else {
            System.out.println("JDWPProxy: Connection received, connecting to VM at address " + outAddress + "..");
            StringTokenizer st = new StringTokenizer(outAddress, ":");
            String host = st.nextToken();
            int port = Integer.valueOf(st.nextToken());
            this.socketVM = new Socket(host, port);
        }
        T dbToVm = new T(new DataInputStream(this.socketDebugger.getInputStream()), new DataOutputStream(this.socketVM.getOutputStream()), reqDelay);
        T vmToDb = new T(new DataInputStream(this.socketVM.getInputStream()), new DataOutputStream(this.socketDebugger.getOutputStream()), respDelay);
        dbToVm.setName("=> DEBUGGER TO VM");
        vmToDb.setName("<= VM TO DEBUGGER");
        System.out.println("JDWPProxy: Connected Starting communication..");
        this.view = new View(this, sequentialRequests);
        dbToVm.shakeHands();
        vmToDb.shakeHands();
        dbToVm.setDaemon(true);
        vmToDb.setDaemon(true);
        dbToVm.start();
        vmToDb.start();
    }

    private void initLogWriter(String logDir) throws IOException {
        this.packetLogWriter = new PacketLogWriter(logDir);
        this.packetLogWriter.setDaemon(true);
        this.packetLogWriter.setPriority(1);
        this.packetLogWriter.start();
    }

    public void shutDown() {
        try {
            System.out.println("Shut down.");
            if (this.socketDebugger != null) {
                this.socketDebugger.close();
            }
            if (this.socketVM != null) {
                this.socketVM.close();
            }
            if (this.packetLogWriter != null) {
                this.packetLogWriter.interrupt();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class T
    extends Thread {
        private DataInputStream dis;
        private DataOutputStream dos;
        private int delay;

        public T(DataInputStream dis, DataOutputStream dos, int delay) {
            this.dis = dis;
            this.dos = dos;
            this.delay = delay;
        }

        private void shakeHands() throws IOException {
            byte[] handShake = new byte[14];
            this.dis.readFully(handShake);
            for (int i = 0; i < handShake.length; ++i) {
                System.out.print((char)handShake[i]);
            }
            System.out.println();
            this.dos.write(handShake);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        Response resp;
                        Packet packet = Packet.readPacket(this.dis, true);
                        if (JDWPProxy.this.packetLogWriter != null) {
                            JDWPProxy.this.packetLogWriter.requestPacketLog(packet);
                        }
                        PacketAnalyzer packetAnalyzer = AnalyzerManager.createPacketAnalyzer(packet);
                        if (packet instanceof Request) {
                            packetAnalyzer.updateInternalDataModel(packet);
                            sequentialRequests.add(packet);
                        }
                        if (packet instanceof Response && !(resp = (Response)packet).isError()) {
                            packetAnalyzer.updateInternalDataModel(packet);
                        }
                        JDWPProxy.this.view.updateView(packet);
                        if (this.dos != null) {
                            Packet.writePacket(packet, this.dos);
                        }
                        this.doDelay(this.delay);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    try {
                        if (this.dis != null) {
                            this.dis.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    try {
                        if (this.dos != null) {
                            this.dos.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                try {
                    if (this.dis != null) {
                        this.dis.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                try {
                    if (this.dos != null) {
                        this.dos.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }

        private void doDelay(int delay) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

