/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.model;

import com.karelherink.jdwpanalyzer.entity.Type;
import java.util.ArrayList;

public class Node {
    private Node parent;
    private Descriptor descriptor;
    private Value value;
    private ArrayList children;

    public Node(Descriptor descriptor, Value value) {
        this.descriptor = descriptor;
        this.value = value;
        this.children = new ArrayList();
    }

    public void addChild(Node node) {
        this.children.add(node);
        if (node.parent != null) {
            node.parent.children.remove(node);
        }
        node.parent = this;
    }

    public Value getValue() {
        return this.value;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public ArrayList getChildren() {
        return this.children;
    }

    public int getChildCount() {
        return this.countKidsRecursive(this.children);
    }

    private int countKidsRecursive(ArrayList children) {
        if (children == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < children.size(); ++i) {
            Node child = (Node)children.get(i);
            count += this.countKidsRecursive(child.children);
        }
        return count;
    }

    public static class Value {
        private Object realValue;
        private String printableValue;

        public Value(Object realValue) {
            this(realValue, null);
        }

        public Value(Object realValue, String printableValue) {
            this.realValue = realValue;
            this.printableValue = printableValue;
        }

        public String toString() {
            String str = "";
            if (this.printableValue != null) {
                str = str + this.printableValue;
            }
            if (this.realValue != null) {
                str = this.printableValue != null ? str + " [" + this.realValue + "]" : str + this.realValue;
            }
            return str;
        }

        public String getPrintableValue() {
            return this.printableValue;
        }

        public void setPrintableValue(String printableValue) {
            this.printableValue = printableValue;
        }

        public Object getRealValue() {
            return this.realValue;
        }

        public void setRealValue(Object realValue) {
            this.realValue = realValue;
        }
    }

    public static class Descriptor {
        private String label = "UNKNOWN";
        private String description = "";
        private Type associatedType = null;

        public Descriptor(String label) {
            this.label = label;
        }

        public Descriptor(String label, Type associatedType) {
            this.label = label;
            this.associatedType = associatedType;
        }

        public String toString() {
            return this.label;
        }

        public Type getAssociatedType() {
            return this.associatedType;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

