/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.model;

import com.karelherink.jdwpanalyzer.model.Request;
import com.karelherink.jdwpanalyzer.model.Response;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Packet {
    private static long packetCount = 0L;
    private long sequentialPacketNumber;
    protected byte[] header;
    protected byte[] data;

    protected Packet(byte[] header, byte[] data, boolean incrementPacketCount) {
        this.header = header;
        this.data = data;
        if (incrementPacketCount) {
            this.sequentialPacketNumber = packetCount++;
        }
    }

    public static Packet readPacket(DataInputStream is, boolean incrementPacketCount) throws IOException {
        byte[] header = new byte[11];
        is.readFully(header);
        byte[] data = new byte[Packet.getDataLenght(header)];
        is.readFully(data);
        Packet packet = Packet.isResponse(header) ? new Response(header, data, incrementPacketCount) : new Request(header, data, incrementPacketCount);
        return packet;
    }

    public static void writePacket(Packet p, DataOutputStream os) throws IOException {
        os.write(p.header);
        os.write(p.data);
    }

    public int getDataLen() {
        return this.getLength() - 11;
    }

    public boolean isResponse() {
        return (this.getFlag() & 0x80) > 0;
    }

    public int getFlag() {
        return this.getUnsignedByte(this.header[8]);
    }

    public int getId() {
        return this.getVal(4, 4);
    }

    public int getLength() {
        return this.getVal(0, 4);
    }

    int getVal(int index, int n) {
        int len = 0;
        int last = index + n;
        for (int i = index; i < last; ++i) {
            len <<= 8;
            len += this.getUnsignedByte(this.header[i]);
        }
        return len;
    }

    int getDataVal(int index, int n) {
        int len = 0;
        int last = index + n;
        for (int i = index; i < last; ++i) {
            len <<= 8;
            len += this.data[i] & 0xFF;
        }
        return len;
    }

    protected int getUnsignedByte(byte b) {
        return b & 0xFF;
    }

    public byte[] getData() {
        return this.data;
    }

    public long getSequentialPacketNumber() {
        return this.sequentialPacketNumber;
    }

    private static boolean isResponse(byte[] header) {
        return (header[8] & 0xFF & 0x80) > 0;
    }

    private static int getDataLenght(byte[] header) {
        return Packet.getVal(header, 0, 4) - 11;
    }

    private static int getVal(byte[] header, int index, int n) {
        int len = 0;
        int last = index + n;
        for (int i = index; i < last; ++i) {
            len <<= 8;
            len += header[i] & 0xFF;
        }
        return len;
    }

    public String toLongString() {
        return "Packet #" + this.sequentialPacketNumber;
    }
}

