/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.model;

import com.karelherink.jdwpanalyzer.entity.MethodType;
import com.karelherink.jdwpanalyzer.entity.ReferenceType;
import com.karelherink.jdwpanalyzer.model.Node;
import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.constants.Tag;
import com.karelherink.jdwpanalyzer.model.constants.TypeTag;

public class PacketAnalyzer {
    protected static int fieldIDSize = 8;
    protected static int methodIDSize = 8;
    protected static int objectIDSize = 8;
    protected static int referenceTypeIDSize = 8;
    protected static int frameIDSize = 8;
    protected static int locationSize = 1 + referenceTypeIDSize + methodIDSize + 8;
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_PRIVATE = 2;
    private static final int ACC_PROTECTED = 4;
    private static final int ACC_STATIC = 8;
    private static final int ACC_FINAL = 16;
    private static final int ACC_VOLATILE = 64;
    private static final int ACC_TRANSIENT = 128;

    protected static synchronized void setIDSizes(int[] sizes) {
        fieldIDSize = sizes[0];
        methodIDSize = sizes[1];
        objectIDSize = sizes[2];
        referenceTypeIDSize = sizes[3];
        frameIDSize = sizes[4];
        locationSize = 1 + referenceTypeIDSize + methodIDSize + 8;
    }

    protected static long getVal(Packet packet, int index, int n) {
        int len = 0;
        int last = index + n;
        for (int i = index; i < last; ++i) {
            len <<= 8;
            len += packet.getData()[i] & 0xFF;
        }
        return len;
    }

    protected static Value getValue(Packet packet, int index) {
        switch (packet.getData()[index++]) {
            case 91: {
                return new Value(objectIDSize + 1, new Long(PacketAnalyzer.getVal(packet, index, objectIDSize)));
            }
            case 66: {
                return new Value(2, new Byte((byte)PacketAnalyzer.getVal(packet, index, 1)));
            }
            case 67: {
                return new Value(3, new Character((char)PacketAnalyzer.getVal(packet, index, 2)));
            }
            case 76: {
                return new Value(objectIDSize + 1, new Long(PacketAnalyzer.getVal(packet, index, objectIDSize)));
            }
            case 70: {
                return new Value(5, "TODO: FLOAT");
            }
            case 68: {
                return new Value(9, "TODO: DOUBLE");
            }
            case 73: {
                return new Value(5, new Long(PacketAnalyzer.getVal(packet, index, 4)));
            }
            case 74: {
                return new Value(9, new Long(PacketAnalyzer.getVal(packet, index, 8)));
            }
            case 83: {
                return new Value(3, new Short((short)PacketAnalyzer.getVal(packet, index, 2)));
            }
            case 86: {
                return new Value(1, "void/null");
            }
            case 90: {
                return new Value(2, new Boolean(PacketAnalyzer.getVal(packet, index, 1) != 0L));
            }
            case 115: {
                return new Value(objectIDSize + 1, new Long(PacketAnalyzer.getVal(packet, index, objectIDSize)));
            }
            case 116: {
                return new Value(objectIDSize + 1, new Long(PacketAnalyzer.getVal(packet, index, objectIDSize)));
            }
            case 103: {
                return new Value(objectIDSize + 1, new Long(PacketAnalyzer.getVal(packet, index, objectIDSize)));
            }
            case 108: {
                return new Value(objectIDSize + 1, new Long(PacketAnalyzer.getVal(packet, index, objectIDSize)));
            }
            case 99: {
                return new Value(objectIDSize + 1, new Long(PacketAnalyzer.getVal(packet, index, objectIDSize)));
            }
        }
        return new Value(1, "ERR - UNKNOWN");
    }

    protected static Value getUntaggedValue(Packet packet, int index, int tag) {
        switch (tag) {
            case 91: {
                return new Value(objectIDSize, new Long(PacketAnalyzer.getVal(packet, index, objectIDSize)));
            }
            case 66: {
                return new Value(1, new Byte((byte)PacketAnalyzer.getVal(packet, index, 1)));
            }
            case 67: {
                return new Value(2, new Character((char)PacketAnalyzer.getVal(packet, index, 2)));
            }
            case 76: {
                return new Value(objectIDSize, new Long(PacketAnalyzer.getVal(packet, index, objectIDSize)));
            }
            case 70: {
                return new Value(4, "TODO: FLOAT");
            }
            case 68: {
                return new Value(8, "TODO: DOUBLE");
            }
            case 73: {
                return new Value(4, new Long(PacketAnalyzer.getVal(packet, index, 4)));
            }
            case 74: {
                return new Value(8, new Long(PacketAnalyzer.getVal(packet, index, 8)));
            }
            case 83: {
                return new Value(2, new Short((short)PacketAnalyzer.getVal(packet, index, 2)));
            }
            case 86: {
                return new Value(0, "void/null");
            }
            case 90: {
                return new Value(1, new Boolean(PacketAnalyzer.getVal(packet, index, 1) != 0L));
            }
            case 115: {
                return new Value(objectIDSize, new Long(PacketAnalyzer.getVal(packet, index, objectIDSize)));
            }
            case 116: {
                return new Value(objectIDSize, new Long(PacketAnalyzer.getVal(packet, index, objectIDSize)));
            }
            case 103: {
                return new Value(objectIDSize, new Long(PacketAnalyzer.getVal(packet, index, objectIDSize)));
            }
            case 108: {
                return new Value(objectIDSize, new Long(PacketAnalyzer.getVal(packet, index, objectIDSize)));
            }
            case 99: {
                return new Value(objectIDSize, new Long(PacketAnalyzer.getVal(packet, index, objectIDSize)));
            }
        }
        return new Value(0, "ERR - UNKNOWN");
    }

    protected static String getStr(Packet packet, int index, int n) {
        StringBuffer sb = new StringBuffer(n + 1);
        for (int i = index; i < index + n; ++i) {
            sb.append((char)packet.getData()[i]);
        }
        return sb.toString();
    }

    protected static Value[] getArrayRegion(Packet packet, int index) {
        byte tag = packet.getData()[index++];
        int numValues = (int)PacketAnalyzer.getVal(packet, index, 4);
        index += 4;
        Value[] values = new Value[numValues];
        for (int i = 0; i < numValues; ++i) {
            Value value;
            if (Tag.isPrimitive(tag)) {
                values[i] = value = PacketAnalyzer.getUntaggedValue(packet, index, tag);
                index += value.offset;
                continue;
            }
            values[i] = value = PacketAnalyzer.getValue(packet, index);
            index += value.offset;
        }
        return values;
    }

    protected static String getModBitsAsStr(int modBits) {
        String description = "";
        if ((modBits & 1) == 1) {
            description = description + "PUBLIC ";
        }
        if ((modBits & 2) == 2) {
            description = description + "PRIVATE ";
        }
        if ((modBits & 4) == 4) {
            description = description + "PROTECTED ";
        }
        if ((modBits & 8) == 8) {
            description = description + "STATIC ";
        }
        if ((modBits & 0x10) == 16) {
            description = description + "FINAL ";
        }
        if ((modBits & 0x40) == 64) {
            description = description + "VOLATILE ";
        }
        if ((modBits & 0x80) == 128) {
            description = description + "TRANSIENT ";
        }
        return description.trim();
    }

    protected static String getInvokeOptionsAsStr(int invokeOptions) {
        String description = "";
        if ((invokeOptions & 1) == 1) {
            description = description + "SINGLE_THREADED ";
        }
        if ((invokeOptions & 2) == 2) {
            description = description + "NONVIRTUAL ";
        }
        return description.trim();
    }

    protected static boolean getBoolean(Packet packet, int index) {
        byte val = packet.getData()[index++];
        return val != 0;
    }

    public static String getStringTranslation(int cmdSet, int cmd) {
        String translation = "";
        block0 : switch (cmdSet) {
            case 1: {
                switch (cmd) {
                    case 1: {
                        translation = translation + "VirtualMachine_Version";
                        break block0;
                    }
                    case 2: {
                        translation = translation + "VirtualMachine_ClassesBySignature";
                        break block0;
                    }
                    case 3: {
                        translation = translation + "VirtualMachine_AllClasses";
                        break block0;
                    }
                    case 4: {
                        translation = translation + "VirtualMachine_AllThreads";
                        break block0;
                    }
                    case 5: {
                        translation = translation + "VirtualMachine_TopLevelThreadGroups";
                        break block0;
                    }
                    case 6: {
                        translation = translation + "VirtualMachine_Dispose";
                        break block0;
                    }
                    case 7: {
                        translation = translation + "VirtualMachine_IDSizes";
                        break block0;
                    }
                    case 8: {
                        translation = translation + "VirtualMachine_Suspend";
                        break block0;
                    }
                    case 9: {
                        translation = translation + "VirtualMachine_Resume";
                        break block0;
                    }
                    case 10: {
                        translation = translation + "VirtualMachine_Exit";
                        break block0;
                    }
                    case 11: {
                        translation = translation + "VirtualMachine_CreateString";
                        break block0;
                    }
                    case 12: {
                        translation = translation + "VirtualMachine_Capabilities";
                        break block0;
                    }
                    case 13: {
                        translation = translation + "VirtualMachine_ClassPaths";
                        break block0;
                    }
                    case 14: {
                        translation = translation + "VirtualMachine_DisposeObjects";
                        break block0;
                    }
                    case 15: {
                        translation = translation + "VirtualMachine_HoldEvents";
                        break block0;
                    }
                    case 16: {
                        translation = translation + "VirtualMachine_ReleaseEvents";
                        break block0;
                    }
                    case 17: {
                        translation = translation + "VirtualMachine_CapabilitiesNew";
                        break block0;
                    }
                    case 18: {
                        translation = translation + "VirtualMachine_RedefineClasses";
                        break block0;
                    }
                    case 19: {
                        translation = translation + "VirtualMachine_SetDefaultStratum";
                        break block0;
                    }
                    case 20: {
                        translation = translation + "VirtualMachine_AllClassesWithGeneric";
                        break block0;
                    }
                }
                translation = translation + "ERROR: in command set " + cmdSet + " there is no command " + cmd;
                break;
            }
            case 2: {
                switch (cmd) {
                    case 1: {
                        translation = translation + "ReferenceType_Signature";
                        break block0;
                    }
                    case 2: {
                        translation = translation + "ReferenceType_ClassLoader";
                        break block0;
                    }
                    case 3: {
                        translation = translation + "ReferenceType_Modifiers";
                        break block0;
                    }
                    case 4: {
                        translation = translation + "ReferenceType_Fields";
                        break block0;
                    }
                    case 5: {
                        translation = translation + "ReferenceType_Methods";
                        break block0;
                    }
                    case 6: {
                        translation = translation + "ReferenceType_GetValues";
                        break block0;
                    }
                    case 7: {
                        translation = translation + "ReferenceType_SourceFile";
                        break block0;
                    }
                    case 8: {
                        translation = translation + "ReferenceType_NestedTypes";
                        break block0;
                    }
                    case 9: {
                        translation = translation + "ReferenceType_Status";
                        break block0;
                    }
                    case 10: {
                        translation = translation + "ReferenceType_Interfaces";
                        break block0;
                    }
                    case 11: {
                        translation = translation + "ReferenceType_ClassObject";
                        break block0;
                    }
                    case 12: {
                        translation = translation + "ReferenceType_SourceDebugExtension";
                        break block0;
                    }
                    case 13: {
                        translation = translation + "ReferenceType_SignatureWithGeneric";
                        break block0;
                    }
                    case 14: {
                        translation = translation + "ReferenceType_FieldsWithGeneric";
                        break block0;
                    }
                    case 15: {
                        translation = translation + "ReferenceType_MethodsWithGeneric";
                        break block0;
                    }
                }
                translation = translation + "ERROR: in command set " + cmdSet + " there is no command " + cmd;
                break;
            }
            case 3: {
                switch (cmd) {
                    case 1: {
                        translation = translation + "ClassType_Superclass";
                        break block0;
                    }
                    case 2: {
                        translation = translation + "ClassType_SetValues";
                        break block0;
                    }
                    case 3: {
                        translation = translation + "ClassType_InvokeMethod";
                        break block0;
                    }
                    case 4: {
                        translation = translation + "ClassType_NewInstance";
                        break block0;
                    }
                }
                translation = translation + "ERROR: in command set " + cmdSet + " there is no command " + cmd;
                break;
            }
            case 4: {
                switch (cmd) {
                    case 1: {
                        translation = translation + "ArrayType_NewInstance";
                        break block0;
                    }
                }
                translation = translation + "ERROR: in command set " + cmdSet + " there is no command " + cmd;
                break;
            }
            case 5: {
                switch (cmd) {
                    default: 
                }
                translation = translation + "ERROR: in command set " + cmdSet + " there is no command " + cmd;
                break;
            }
            case 6: {
                switch (cmd) {
                    case 1: {
                        translation = translation + "Method_LineTable";
                        break block0;
                    }
                    case 2: {
                        translation = translation + "Method_VariableTable";
                        break block0;
                    }
                    case 3: {
                        translation = translation + "Method_Bytecodes";
                        break block0;
                    }
                    case 4: {
                        translation = translation + "Method_IsObsolete";
                        break block0;
                    }
                    case 5: {
                        translation = translation + "Method_VariableTableWithGeneric";
                        break block0;
                    }
                }
                translation = translation + "ERROR: in command set " + cmdSet + " there is no command " + cmd;
                break;
            }
            case 8: {
                switch (cmd) {
                    default: 
                }
                break;
            }
            case 9: {
                switch (cmd) {
                    case 1: {
                        translation = translation + "ObjectReference_ReferenceType";
                        break block0;
                    }
                    case 2: {
                        translation = translation + "ObjectReference_GetValues";
                        break block0;
                    }
                    case 3: {
                        translation = translation + "ObjectReference_SetValues";
                        break block0;
                    }
                    case 5: {
                        translation = translation + "ObjectReference_MonitorInfo";
                        break block0;
                    }
                    case 6: {
                        translation = translation + "ObjectReference_InvokeMethod";
                        break block0;
                    }
                    case 7: {
                        translation = translation + "ObjectReference_DisableCollection";
                        break block0;
                    }
                    case 8: {
                        translation = translation + "ObjectReference_EnableCollection";
                        break block0;
                    }
                    case 9: {
                        translation = translation + "ObjectReference_IsCollected";
                        break block0;
                    }
                }
                translation = translation + "ERROR: in command set " + cmdSet + " there is no command " + cmd;
                break;
            }
            case 10: {
                switch (cmd) {
                    case 1: {
                        translation = translation + "StringReference_Value";
                        break block0;
                    }
                }
                translation = translation + "ERROR: in command set " + cmdSet + " there is no command " + cmd;
                break;
            }
            case 11: {
                switch (cmd) {
                    case 1: {
                        translation = translation + "ThreadReference_Name";
                        break block0;
                    }
                    case 2: {
                        translation = translation + "ThreadReference_Suspend";
                        break block0;
                    }
                    case 3: {
                        translation = translation + "ThreadReference_Resume";
                        break block0;
                    }
                    case 4: {
                        translation = translation + "ThreadReference_Status";
                        break block0;
                    }
                    case 5: {
                        translation = translation + "ThreadReference_ThreadGroup";
                        break block0;
                    }
                    case 6: {
                        translation = translation + "ThreadReference_Frames";
                        break block0;
                    }
                    case 7: {
                        translation = translation + "ThreadReference_FrameCount";
                        break block0;
                    }
                    case 8: {
                        translation = translation + "ThreadReference_OwnedMonitors";
                        break block0;
                    }
                    case 9: {
                        translation = translation + "ThreadReference_CurrentContendedMonitor";
                        break block0;
                    }
                    case 10: {
                        translation = translation + "ThreadReference_Stop";
                        break block0;
                    }
                    case 11: {
                        translation = translation + "ThreadReference_Interrupt";
                        break block0;
                    }
                    case 12: {
                        translation = translation + "ThreadReference_SuspendCount";
                        break block0;
                    }
                }
                translation = translation + "ERROR: in command set " + cmdSet + " there is no command " + cmd;
                break;
            }
            case 12: {
                switch (cmd) {
                    case 1: {
                        translation = translation + "ThreadGroupReference_Name";
                        break block0;
                    }
                    case 2: {
                        translation = translation + "ThreadGroupReference_Parent";
                        break block0;
                    }
                    case 3: {
                        translation = translation + "ThreadGroupReference_Children";
                        break block0;
                    }
                }
                translation = translation + "ERROR: in command set " + cmdSet + " there is no command " + cmd;
                break;
            }
            case 13: {
                switch (cmd) {
                    case 1: {
                        translation = translation + "ArrayReference_Length";
                        break block0;
                    }
                    case 2: {
                        translation = translation + "ArrayReference_GetValues";
                        break block0;
                    }
                    case 3: {
                        translation = translation + "ArrayReference_SetValues";
                        break block0;
                    }
                }
                translation = translation + "ERROR: in command set " + cmdSet + " there is no command " + cmd;
                break;
            }
            case 14: {
                switch (cmd) {
                    case 1: {
                        translation = translation + "ClassLoaderReference_VisibleClasses";
                        break block0;
                    }
                }
                break;
            }
            case 15: {
                switch (cmd) {
                    case 1: {
                        translation = translation + "EventRequest_Set";
                        break block0;
                    }
                    case 2: {
                        translation = translation + "EventRequest_Clear";
                        break block0;
                    }
                    case 3: {
                        translation = translation + "EventRequest_ClearAllBreakpoints";
                        break block0;
                    }
                }
                translation = translation + "ERROR: in command set " + cmdSet + " there is no command " + cmd;
                break;
            }
            case 16: {
                switch (cmd) {
                    case 1: {
                        translation = translation + "StackFrame_GetValues";
                        break block0;
                    }
                    case 2: {
                        translation = translation + "StackFrame_SetValues";
                        break block0;
                    }
                    case 3: {
                        translation = translation + "StackFrame_ThisObject";
                        break block0;
                    }
                    case 4: {
                        translation = translation + "StackFrame_PopFrames";
                        break block0;
                    }
                }
                translation = translation + "ERROR: in command set " + cmdSet + " there is no command " + cmd;
                break;
            }
            case 17: {
                switch (cmd) {
                    case 1: {
                        translation = translation + "ClassObjectReference_ReflectedType";
                        break block0;
                    }
                }
                translation = translation + "ERROR: in command set " + cmdSet + " there is no command " + cmd;
                break;
            }
            case 64: {
                switch (cmd) {
                    case 100: {
                        translation = translation + "Event_Composite";
                        break block0;
                    }
                }
                translation = translation + "ERROR: in command set " + cmdSet + " there is no command " + cmd;
                break;
            }
            default: {
                translation = translation + "ERROR: there is no command set " + cmdSet;
            }
        }
        return translation;
    }

    public static Location getLocation(Packet packet, int index) {
        byte typeTag = packet.getData()[index++];
        long classID = PacketAnalyzer.getVal(packet, index, referenceTypeIDSize);
        long methodID = PacketAnalyzer.getVal(packet, index += referenceTypeIDSize, methodIDSize);
        long execIndex = PacketAnalyzer.getVal(packet, index += methodIDSize, 8);
        index += 8;
        return new Location(typeTag, classID, methodID, execIndex);
    }

    public static String taggedObjectIDToString(Packet packet, int index) {
        int tag = packet.getData()[index++] & 0xFF;
        long objectID = PacketAnalyzer.getVal(packet, index, objectIDSize);
        return Tag.asString(tag) + "-" + objectID;
    }

    public void updateInternalDataModel(Packet packet) {
    }

    public Node getPacketInfo(Packet packet) {
        return new Node(new Node.Descriptor("NONE"), new Node.Value("NONE"));
    }

    public static class Location {
        private byte typeTag;
        private long classID;
        private long methodID;
        private long execIndex;
        private String decription = "Location:";

        public Location(byte typeTag, long classID, long methodID, long execIndex) {
            this.typeTag = typeTag;
            this.classID = classID;
            this.methodID = methodID;
            this.execIndex = execIndex;
        }

        public String toString() {
            return TypeTag.asString(this.typeTag) + " - [classID]:" + this.classID + ", [methodID]:" + this.methodID + ", [index]:" + this.execIndex;
        }

        public Node toNode() {
            Node root = new Node(new Node.Descriptor(this.decription), new Node.Value(this.toString()));
            ReferenceType refType = ReferenceType.getType(this.classID);
            Node typeInfo = new Node(new Node.Descriptor("RefTypeID:", refType), new Node.Value(new Long(this.classID)));
            root.addChild(typeInfo);
            MethodType methType = MethodType.getType(this.classID, this.methodID);
            Node methInfo = new Node(new Node.Descriptor("MethodID:", methType), new Node.Value(new Long(this.methodID)));
            root.addChild(methInfo);
            return root;
        }

        public long getClassID() {
            return this.classID;
        }

        public void setClassID(long classID) {
            this.classID = classID;
        }

        public long getExecIndex() {
            return this.execIndex;
        }

        public void setExecIndex(long execIndex) {
            this.execIndex = execIndex;
        }

        public long getMethodID() {
            return this.methodID;
        }

        public void setMethodID(long methodID) {
            this.methodID = methodID;
        }

        public int getTypeTag() {
            return this.typeTag;
        }

        public void setTypeTag(byte typeTag) {
            this.typeTag = typeTag;
        }

        public String getDecription() {
            return this.decription;
        }

        public void setDecription(String decription) {
            this.decription = decription;
        }
    }

    public static class Value {
        private int offset;
        private Object value;

        public Value(int offset, Object value) {
            this.offset = offset;
            this.value = value;
        }

        public int getOffset() {
            return this.offset;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

