/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.model;

import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.PacketAnalyzer;
import java.util.Hashtable;

public class Request
extends Packet {
    private static Hashtable requests = new Hashtable();
    private static int requestCount = 0;
    private int sequentialRequestNumber = 0;

    public Request(byte[] header, byte[] data, boolean incrementPacketCount) {
        super(header, data, incrementPacketCount);
        if (incrementPacketCount) {
            this.sequentialRequestNumber = requestCount++;
        }
        requests.put(new Integer(this.getId()), this);
    }

    public int getCmdSet() {
        return this.getUnsignedByte(this.header[9]);
    }

    public int getCmd() {
        return this.getUnsignedByte(this.header[10]);
    }

    public String toString() {
        return "[" + this.getSequentialRequestNumber() + "]  " + PacketAnalyzer.getStringTranslation(this.getCmdSet(), this.getCmd());
    }

    @Override
    public String toLongString() {
        return ">> JDWP REQ [id = " + this.getId() + ", " + PacketAnalyzer.getStringTranslation(this.getCmdSet(), this.getCmd()) + ", packet # " + this.getSequentialPacketNumber() + " , req # " + this.getSequentialRequestNumber() + ", flag = " + this.getFlag() + ", cmdSet = " + this.getCmdSet() + ", cmd = " + this.getCmd() + ", data = " + this.getDataLen() + "]";
    }

    public static Request getRequest(int id) {
        return (Request)requests.get(new Integer(id));
    }

    public int getSequentialRequestNumber() {
        return this.sequentialRequestNumber;
    }
}

