/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.model;

import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.constants.Error;
import java.util.Hashtable;

public class Response
extends Packet {
    private static Hashtable responses = new Hashtable();
    private static int responseCount = 0;
    private int sequentialResponseNumber = 0;

    public Response(byte[] header, byte[] data, boolean incrementPacketCount) {
        super(header, data, incrementPacketCount);
        if (incrementPacketCount) {
            this.sequentialResponseNumber = responseCount++;
        }
        responses.put(new Integer(this.getId()), this);
    }

    public boolean isError() {
        return this.getErrCode() != 0;
    }

    public int getErrCode() {
        return this.getVal(9, 2);
    }

    public String toString() {
        return Error.asString(this.getErrCode()) + "  [" + this.getSequentialResponseNumber() + "]";
    }

    @Override
    public String toLongString() {
        return "<< JDWP RSP [id = " + this.getId() + ", packet # " + this.getSequentialPacketNumber() + " , resp # " + this.getSequentialResponseNumber() + ", flag = " + this.getFlag() + ", err = " + this.getErrCode() + ", data = " + this.getDataLen() + "]";
    }

    public static Response getResponse(int id) {
        return (Response)responses.get(new Integer(id));
    }

    public int getSequentialResponseNumber() {
        return this.sequentialResponseNumber;
    }
}

