/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.model.constants;

public class Error {
    public static final short INVALID_TAG = 500;
    public static final short ALREADY_INVOKING = 502;
    public static final short INVALID_INDEX = 503;
    public static final short INVALID_LENGTH = 504;
    public static final short INVALID_STRING = 506;
    public static final short INVALID_CLASS_LOADER = 507;
    public static final short INVALID_ARRAY = 508;
    public static final short TRANSPORT_LOAD = 509;
    public static final short TRANSPORT_INIT = 510;
    public static final short NATIVE_METHOD = 511;
    public static final short INVALID_COUNT = 512;
    public static final short NONE = 0;
    public static final short INVALID_THREAD = 10;
    public static final short INVALID_THREAD_GROUP = 11;
    public static final short INVALID_PRIORITY = 12;
    public static final short THREAD_NOT_SUSPENDED = 13;
    public static final short THREAD_SUSPENDED = 14;
    public static final short INVALID_OBJECT = 20;
    public static final short INVALID_CLASS = 21;
    public static final short CLASS_NOT_PREPARED = 22;
    public static final short INVALID_METHODID = 23;
    public static final short INVALID_LOCATION = 24;
    public static final short INVALID_FIELDID = 25;
    public static final short INVALID_FRAMEID = 30;
    public static final short NO_MORE_FRAMES = 31;
    public static final short OPAQUE_FRAME = 32;
    public static final short NOT_CURRENT_FRAME = 33;
    public static final short TYPE_MISMATCH = 34;
    public static final short INVALID_SLOT = 35;
    public static final short DUPLICATE = 40;
    public static final short NOT_FOUND = 41;
    public static final short INVALID_MONITOR = 50;
    public static final short NOT_MONITOR_OWNER = 51;
    public static final short INTERRUPT = 52;
    public static final short INVALID_CLASS_FORMAT = 60;
    public static final short CIRCULAR_CLASS_DEFINITION = 61;
    public static final short FAILS_VERIFICATION = 62;
    public static final short ADD_METHOD_NOT_IMPLEMENTED = 63;
    public static final short SCHEMA_CHANGE_NOT_IMPLEMENTED = 64;
    public static final short INVALID_TYPESTATE = 65;
    public static final short NOT_IMPLEMENTED = 99;
    public static final short NULL_POINTER = 100;
    public static final short ABSENT_INFORMATION = 101;
    public static final short INVALID_EVENT_TYPE = 102;
    public static final short ILLEGAL_ARGUMENT = 103;
    public static final short OUT_OF_MEMORY = 110;
    public static final short ACCESS_DENIED = 111;
    public static final short VM_DEAD = 112;
    public static final short INTERNAL = 113;
    public static final short UNATTACHED_THREAD = 115;

    public static String asString(int errCode) {
        return errCode == 0 ? "OK" : "ERR : " + Error.getStringTranslation(errCode);
    }

    private static String getStringTranslation(int errCode) {
        switch (errCode) {
            case 500: {
                return "INVALID_TAG";
            }
            case 502: {
                return "ALREADY_INVOKING";
            }
            case 503: {
                return "INVALID_INDEX";
            }
            case 504: {
                return "INVALID_LENGTH";
            }
            case 506: {
                return "INVALID_STRING";
            }
            case 507: {
                return "INVALID_CLASS_LOADER";
            }
            case 508: {
                return "INVALID_ARRAY";
            }
            case 509: {
                return "TRANSPORT_LOAD";
            }
            case 510: {
                return "TRANSPORT_INIT";
            }
            case 511: {
                return "NATIVE_METHOD";
            }
            case 512: {
                return "INVALID_COUNT";
            }
            case 0: {
                return "NONE";
            }
            case 10: {
                return "INVALID_THREAD";
            }
            case 11: {
                return "INVALID_THREAD_GROUP";
            }
            case 12: {
                return "INVALID_PRIORITY";
            }
            case 13: {
                return "THREAD_NOT_SUSPENDED";
            }
            case 14: {
                return "THREAD_SUSPENDED";
            }
            case 20: {
                return "INVALID_OBJECT";
            }
            case 21: {
                return "INVALID_CLASS";
            }
            case 22: {
                return "CLASS_NOT_PREPARED";
            }
            case 23: {
                return "INVALID_METHODID";
            }
            case 24: {
                return "INVALID_LOCATION";
            }
            case 25: {
                return "INVALID_FIELDID";
            }
            case 30: {
                return "INVALID_FRAMEID";
            }
            case 31: {
                return "NO_MORE_FRAMES";
            }
            case 32: {
                return "OPAQUE_FRAME";
            }
            case 33: {
                return "NOT_CURRENT_FRAME";
            }
            case 34: {
                return "TYPE_MISMATCH";
            }
            case 35: {
                return "INVALID_SLOT";
            }
            case 40: {
                return "DUPLICATE";
            }
            case 41: {
                return "NOT_FOUND";
            }
            case 50: {
                return "INVALID_MONITOR";
            }
            case 51: {
                return "NOT_MONITOR_OWNER";
            }
            case 52: {
                return "INTERRUPT";
            }
            case 60: {
                return "INVALID_CLASS_FORMAT";
            }
            case 61: {
                return "CIRCULAR_CLASS_DEFINITION";
            }
            case 62: {
                return "FAILS_VERIFICATION";
            }
            case 63: {
                return "ADD_METHOD_NOT_IMPLEMENTED";
            }
            case 64: {
                return "SCHEMA_CHANGE_NOT_IMPLEMENTED";
            }
            case 65: {
                return "INVALID_TYPESTATE";
            }
            case 99: {
                return "NOT_IMPLEMENTED";
            }
            case 100: {
                return "NULL_POINTER";
            }
            case 101: {
                return "ABSENT_INFORMATION";
            }
            case 102: {
                return "INVALID_EVENT_TYPE";
            }
            case 103: {
                return "ILLEGAL_ARGUMENT";
            }
            case 110: {
                return "OUT_OF_MEMORY";
            }
            case 111: {
                return "ACCESS_DENIED";
            }
            case 112: {
                return "VM_DEAD";
            }
            case 113: {
                return "INTERNAL";
            }
            case 115: {
                return "UNATTACHED_THREAD";
            }
        }
        return "UNKNOWN";
    }
}

