/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.request;

import com.karelherink.jdwpanalyzer.entity.FieldType;
import com.karelherink.jdwpanalyzer.entity.ObjectType;
import com.karelherink.jdwpanalyzer.entity.ReferenceType;
import com.karelherink.jdwpanalyzer.model.Node;
import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.PacketAnalyzer;
import com.karelherink.jdwpanalyzer.model.constants.EventKind;
import com.karelherink.jdwpanalyzer.model.constants.Step;
import com.karelherink.jdwpanalyzer.model.constants.SuspendPolicy;

public class Analyzer_15_1
extends PacketAnalyzer {
    @Override
    public Node getPacketInfo(Packet packet) {
        int index = 0;
        byte eventKind = packet.getData()[index++];
        Node root = new Node(new Node.Descriptor("EventKind:"), new Node.Value(new Byte(eventKind), EventKind.asString(eventKind)));
        byte suspend = packet.getData()[index++];
        Node suspendInfo = new Node(new Node.Descriptor("SuspendPolicy:"), new Node.Value(new Byte(suspend), SuspendPolicy.asString(suspend)));
        root.addChild(suspendInfo);
        int numModifiers = (int)Analyzer_15_1.getVal(packet, index, 4);
        index += 4;
        Node modifiersInfo = new Node(new Node.Descriptor("NumModifiers:"), new Node.Value(new Integer(numModifiers)));
        root.addChild(modifiersInfo);
        block13: for (int i = 0; i < numModifiers; ++i) {
            byte mod = packet.getData()[index++];
            switch (mod) {
                case 1: {
                    int count = (int)Analyzer_15_1.getVal(packet, index, 4);
                    index += 4;
                    Node countInfo = new Node(new Node.Descriptor("Count:"), new Node.Value(new Integer(count)));
                    root.addChild(countInfo);
                    continue block13;
                }
                case 2: {
                    int exprId = (int)Analyzer_15_1.getVal(packet, index, 4);
                    index += 4;
                    Node exprIdInfo = new Node(new Node.Descriptor("Conditional-ExprID:"), new Node.Value(new Integer(exprId)));
                    root.addChild(exprIdInfo);
                    continue block13;
                }
                case 3: {
                    long objTypeId = Analyzer_15_1.getVal(packet, index, objectIDSize);
                    index += objectIDSize;
                    ObjectType objType = ObjectType.getType(objTypeId);
                    Node threadIdInfo = new Node(new Node.Descriptor("ThreadOnly-ThreadID:", objType), new Node.Value(new Long(objTypeId)));
                    root.addChild(threadIdInfo);
                    continue block13;
                }
                case 4: {
                    long refId = Analyzer_15_1.getVal(packet, index, referenceTypeIDSize);
                    index += referenceTypeIDSize;
                    ReferenceType refType = ReferenceType.getType(refId);
                    Node refIdInfo = new Node(new Node.Descriptor("ClassOnly-RefTypeID:", refType), new Node.Value(new Long(refId)));
                    root.addChild(refIdInfo);
                    continue block13;
                }
                case 5: {
                    int len = (int)Analyzer_15_1.getVal(packet, index, 4);
                    String classMatch = Analyzer_15_1.getStr(packet, index += 4, len);
                    index += len;
                    Node matchInfo = new Node(new Node.Descriptor("ClassInclude-Pattern:"), new Node.Value(classMatch));
                    root.addChild(matchInfo);
                    continue block13;
                }
                case 6: {
                    int len = (int)Analyzer_15_1.getVal(packet, index, 4);
                    String classExclude = Analyzer_15_1.getStr(packet, index += 4, len);
                    index += len;
                    Node excludeInfo = new Node(new Node.Descriptor("ClassExclude-Pattern:"), new Node.Value(classExclude));
                    root.addChild(excludeInfo);
                    continue block13;
                }
                case 7: {
                    PacketAnalyzer.Location location = Analyzer_15_1.getLocation(packet, index);
                    index += locationSize;
                    Node locationInfo = location.toNode();
                    root.addChild(locationInfo);
                    continue block13;
                }
                case 8: {
                    long refId = Analyzer_15_1.getVal(packet, index, referenceTypeIDSize);
                    index += referenceTypeIDSize;
                    boolean reportCaught = Analyzer_15_1.getBoolean(packet, index++);
                    boolean reportUncaught = Analyzer_15_1.getBoolean(packet, index++);
                    String desc = (reportCaught ? "Caught=YES" : "Caught=NO") + "/" + (reportUncaught ? "Uncaught=YES" : "Uncaught=NO");
                    ReferenceType refType = ReferenceType.getType(refId);
                    Node exceptionInfo = new Node(new Node.Descriptor("Exception:", refType), new Node.Value(desc));
                    root.addChild(exceptionInfo);
                    continue block13;
                }
                case 9: {
                    long refId = Analyzer_15_1.getVal(packet, index, referenceTypeIDSize);
                    long fieldId = Analyzer_15_1.getVal(packet, index += referenceTypeIDSize, fieldIDSize);
                    index += fieldIDSize;
                    FieldType fieldType = FieldType.getType(refId, fieldId);
                    Node fieldOnlyInfo = new Node(new Node.Descriptor("FieldOnlyID:", fieldType), new Node.Value(new Long(fieldId)));
                    root.addChild(fieldOnlyInfo);
                    continue block13;
                }
                case 10: {
                    long threadId = Analyzer_15_1.getVal(packet, index, objectIDSize);
                    int stepSize = (int)Analyzer_15_1.getVal(packet, index += objectIDSize, 4);
                    int stepDepth = (int)Analyzer_15_1.getVal(packet, index += 4, 4);
                    index += 4;
                    String desc = "ThreadID:" + threadId + "," + Step.sizeAsString(stepSize) + "," + Step.depthAsString(stepDepth);
                    ObjectType threadType = ObjectType.getType(threadId);
                    Node stepInfo = new Node(new Node.Descriptor("Step:", threadType), new Node.Value(desc));
                    root.addChild(stepInfo);
                    continue block13;
                }
                case 11: {
                    long objId = Analyzer_15_1.getVal(packet, index, objectIDSize);
                    index += objectIDSize;
                    ObjectType instance = ObjectType.getType(objId);
                    Node instanceInfo = new Node(new Node.Descriptor("InstanceOnly-ObjID:", instance), new Node.Value(new Long(objId)));
                    root.addChild(instanceInfo);
                    continue block13;
                }
                default: {
                    Node errInfo = new Node(new Node.Descriptor("ERR: Unknown modifier " + mod), null);
                    root.addChild(errInfo);
                }
            }
        }
        return root;
    }
}

