/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.request;

import com.karelherink.jdwpanalyzer.entity.ObjectType;
import com.karelherink.jdwpanalyzer.model.Node;
import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.PacketAnalyzer;
import com.karelherink.jdwpanalyzer.model.constants.Tag;

public class Analyzer_16_1
extends PacketAnalyzer {
    @Override
    public Node getPacketInfo(Packet packet) {
        int index = 0;
        Node root = new Node(null, null);
        long threadId = Analyzer_16_1.getVal(packet, index, objectIDSize);
        ObjectType objType = ObjectType.getType(threadId);
        Node threadInfo = new Node(new Node.Descriptor("ThreadID:", objType), new Node.Value(new Long(threadId)));
        root.addChild(threadInfo);
        long frameId = Analyzer_16_1.getVal(packet, index += objectIDSize, frameIDSize);
        Node frameInfo = new Node(new Node.Descriptor("FrameID:"), new Node.Value(new Long(frameId)));
        root.addChild(frameInfo);
        int numVars = (int)Analyzer_16_1.getVal(packet, index += frameIDSize, 4);
        index += 4;
        Node variablesInfo = new Node(new Node.Descriptor("NumVariables:"), new Node.Value(new Integer(numVars)));
        root.addChild(variablesInfo);
        for (int i = 0; i < numVars; ++i) {
            int vfi = (int)Analyzer_16_1.getVal(packet, index, 4);
            index += 4;
            Node vfiInfo = new Node(new Node.Descriptor("VariableFrameIndex:"), new Node.Value(new Integer(vfi)));
            variablesInfo.addChild(vfiInfo);
            byte variableTag = packet.getData()[index++];
            Node variableTagInfo = new Node(new Node.Descriptor("VariableTag:"), new Node.Value(new Byte(variableTag), Tag.asString(variableTag)));
            variablesInfo.addChild(variableTagInfo);
        }
        return root;
    }
}

