/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.request;

import com.karelherink.jdwpanalyzer.entity.ObjectType;
import com.karelherink.jdwpanalyzer.model.Node;
import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.PacketAnalyzer;
import java.util.ArrayList;
import java.util.Iterator;

public class Analyzer_1_14
extends PacketAnalyzer {
    @Override
    public void updateInternalDataModel(Packet packet) {
        ArrayList children = this.getPacketInfo(packet).getChildren();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            Node child = (Node)iter.next();
            Long objectId = (Long)child.getValue().getRealValue();
            ObjectType object = ObjectType.getType(objectId);
            object.setDisposeRequested(new Boolean(true));
            iter.next();
        }
    }

    @Override
    public Node getPacketInfo(Packet packet) {
        int index = 0;
        int numObjects = (int)Analyzer_1_14.getVal(packet, index, 4);
        index += 4;
        Node objectsInfo = new Node(new Node.Descriptor("NumObjects:"), new Node.Value(new Integer(numObjects)));
        for (int i = 0; i < numObjects; ++i) {
            long objectId = Analyzer_1_14.getVal(packet, index, objectIDSize);
            ObjectType objectType = ObjectType.getType(objectId);
            Node objectInfo = new Node(new Node.Descriptor("ObjectId:", objectType), new Node.Value(new Long(objectId)));
            objectsInfo.addChild(objectInfo);
            int refCount = (int)Analyzer_1_14.getVal(packet, index += objectIDSize, 4);
            index += 4;
            Node refCountInfo = new Node(new Node.Descriptor("ReferenceCount:"), new Node.Value(new Long(refCount)));
            objectsInfo.addChild(refCountInfo);
        }
        return objectsInfo;
    }
}

