/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.request;

import com.karelherink.jdwpanalyzer.entity.ReferenceType;
import com.karelherink.jdwpanalyzer.model.Node;
import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.PacketAnalyzer;
import java.util.ArrayList;

public class Analyzer_1_18
extends PacketAnalyzer {
    @Override
    public void updateInternalDataModel(Packet packet) {
        ArrayList classes = this.getPacketInfo(packet).getChildren();
        for (Node refTypeInfo : classes) {
            ReferenceType refType = (ReferenceType)refTypeInfo.getDescriptor().getAssociatedType();
            byte[] classBytes = (byte[])((Node)refTypeInfo.getChildren().get(0)).getValue().getRealValue();
            refType.setClassBytes(classBytes);
        }
    }

    @Override
    public Node getPacketInfo(Packet packet) {
        int index = 0;
        int numClasses = (int)Analyzer_1_18.getVal(packet, index, 4);
        index += 4;
        Node classesInfo = new Node(new Node.Descriptor("NumClasses:"), new Node.Value(new Integer(numClasses)));
        for (int i = 0; i < numClasses; ++i) {
            long referenceTypeID = Analyzer_1_18.getVal(packet, index, referenceTypeIDSize);
            ReferenceType refType = ReferenceType.getType(referenceTypeID);
            Node refTypeInfo = new Node(new Node.Descriptor("RefTypeID:", refType), new Node.Value(new Long(referenceTypeID)));
            classesInfo.addChild(refTypeInfo);
            int numBytes = (int)Analyzer_1_18.getVal(packet, index += referenceTypeIDSize, 4);
            byte[] classBytes = new byte[numBytes];
            System.arraycopy(packet.getData(), index += 4, classBytes, 0, numBytes);
            index += numBytes;
            Node byteInfo = new Node(new Node.Descriptor("ClassBytes:"), new Node.Value(classBytes, Integer.toString(numBytes)));
            refTypeInfo.addChild(byteInfo);
        }
        return classesInfo;
    }
}

