/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.request;

import com.karelherink.jdwpanalyzer.entity.FieldType;
import com.karelherink.jdwpanalyzer.entity.ObjectType;
import com.karelherink.jdwpanalyzer.entity.ReferenceType;
import com.karelherink.jdwpanalyzer.model.Node;
import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.PacketAnalyzer;
import com.karelherink.jdwpanalyzer.model.constants.ClassStatus;
import com.karelherink.jdwpanalyzer.model.constants.EventKind;
import com.karelherink.jdwpanalyzer.model.constants.SuspendPolicy;
import com.karelherink.jdwpanalyzer.model.constants.TypeTag;

public class Analyzer_64_100
extends PacketAnalyzer {
    @Override
    public Node getPacketInfo(Packet packet) {
        int index = 0;
        Node root = new Node(null, null);
        byte suspend = packet.getData()[index++];
        Node suspendInfo = new Node(new Node.Descriptor("SuspendPolicy:"), new Node.Value(new Byte(suspend), SuspendPolicy.asString(suspend)));
        root.addChild(suspendInfo);
        int numEvents = (int)Analyzer_64_100.getVal(packet, index, 4);
        index += 4;
        Node eventsInfo = new Node(new Node.Descriptor("NumEvents:"), new Node.Value(new Integer(numEvents)));
        root.addChild(eventsInfo);
        block10: for (int i = 0; i < numEvents; ++i) {
            byte eventKind = packet.getData()[index++];
            Node eventInfo = new Node(new Node.Descriptor("EventKind:"), new Node.Value(new Byte(eventKind), EventKind.asString(eventKind)));
            eventsInfo.addChild(eventInfo);
            int requestId = (int)Analyzer_64_100.getVal(packet, index, 4);
            index += 4;
            switch (eventKind) {
                case 6: 
                case 7: 
                case 90: {
                    long threadId = Analyzer_64_100.getVal(packet, index, objectIDSize);
                    index += objectIDSize;
                    ObjectType thread = ObjectType.getType(threadId);
                    Node threadInfo = new Node(new Node.Descriptor("ThreadID:", thread), new Node.Value(new Long(threadId)));
                    eventInfo.addChild(threadInfo);
                    continue block10;
                }
                case 1: 
                case 2: 
                case 40: 
                case 41: {
                    long threadId = Analyzer_64_100.getVal(packet, index, objectIDSize);
                    ObjectType thread = ObjectType.getType(threadId);
                    Node threadInfo = new Node(new Node.Descriptor("ThreadID:", thread), new Node.Value(new Long(threadId)));
                    eventInfo.addChild(threadInfo);
                    PacketAnalyzer.Location location = Analyzer_64_100.getLocation(packet, index += objectIDSize);
                    index += locationSize;
                    Node locationInfo = location.toNode();
                    eventInfo.addChild(locationInfo);
                    continue block10;
                }
                case 4: {
                    long threadId = Analyzer_64_100.getVal(packet, index, objectIDSize);
                    ObjectType thread = ObjectType.getType(threadId);
                    Node threadInfo = new Node(new Node.Descriptor("ThreadID:", thread), new Node.Value(new Long(threadId)));
                    eventInfo.addChild(threadInfo);
                    PacketAnalyzer.Location locationThrown = Analyzer_64_100.getLocation(packet, index += objectIDSize);
                    locationThrown.setDecription("LocationThrown:");
                    Node locationThrownInfo = locationThrown.toNode();
                    eventInfo.addChild(locationThrownInfo);
                    PacketAnalyzer.Value value = Analyzer_64_100.getValue(packet, index += locationSize);
                    Long objectId = (Long)value.getValue();
                    ObjectType objectType = ObjectType.getType(objectId);
                    Node singleValueInfo = new Node(new Node.Descriptor("ExceptionObjectID:", objectType), new Node.Value(value));
                    eventInfo.addChild(singleValueInfo);
                    PacketAnalyzer.Location locationCaught = Analyzer_64_100.getLocation(packet, index += value.getOffset());
                    locationCaught.setDecription("LocationCaught");
                    index += locationSize;
                    Node locationCaughtInfo = locationCaught.toNode();
                    eventInfo.addChild(locationCaughtInfo);
                    continue block10;
                }
                case 8: {
                    long threadId = Analyzer_64_100.getVal(packet, index, objectIDSize);
                    index += objectIDSize;
                    ObjectType thread = ObjectType.getType(threadId);
                    Node threadInfo = new Node(new Node.Descriptor("LoaderThreadID:", thread), new Node.Value(new Long(threadId)));
                    eventInfo.addChild(threadInfo);
                    byte typeTag = packet.getData()[index++];
                    Node typeTagInfo = new Node(new Node.Descriptor("TypeTag:"), new Node.Value(new Byte(typeTag), TypeTag.asString(typeTag)));
                    eventInfo.addChild(typeTagInfo);
                    long refId = Analyzer_64_100.getVal(packet, index, referenceTypeIDSize);
                    ReferenceType refType = ReferenceType.getType(refId);
                    Node refIdInfo = new Node(new Node.Descriptor("ReferenceID:", refType), new Node.Value(new Long(refId)));
                    eventInfo.addChild(refIdInfo);
                    int sigLen = (int)Analyzer_64_100.getVal(packet, index += referenceTypeIDSize, 4);
                    String signature = Analyzer_64_100.getStr(packet, index += 4, sigLen);
                    Node signatureInfo = new Node(new Node.Descriptor("RefTypeSignature:"), new Node.Value(signature));
                    eventInfo.addChild(signatureInfo);
                    int classStatus = (int)Analyzer_64_100.getVal(packet, index += sigLen, 4);
                    index += 4;
                    Node classStatusInfo = new Node(new Node.Descriptor("Status:"), new Node.Value(new Integer(classStatus), ClassStatus.asString(classStatus)));
                    eventInfo.addChild(classStatusInfo);
                    continue block10;
                }
                case 9: {
                    int sigLen = (int)Analyzer_64_100.getVal(packet, index, 4);
                    String signature = Analyzer_64_100.getStr(packet, index += 4, sigLen);
                    index += sigLen;
                    Node signatureInfo = new Node(new Node.Descriptor("RefTypeSignature:"), new Node.Value(signature));
                    eventInfo.addChild(signatureInfo);
                    continue block10;
                }
                case 20: {
                    long threadId = Analyzer_64_100.getVal(packet, index, objectIDSize);
                    ObjectType thread = ObjectType.getType(threadId);
                    Node threadInfo = new Node(new Node.Descriptor("AccessorThreadID:", thread), new Node.Value(new Long(threadId)));
                    eventInfo.addChild(threadInfo);
                    PacketAnalyzer.Location location = Analyzer_64_100.getLocation(packet, index += objectIDSize);
                    location.setDecription("AccessLocation:");
                    index += locationSize;
                    Node locationInfo = location.toNode();
                    eventInfo.addChild(locationInfo);
                    byte typeTag = packet.getData()[index++];
                    Node typeTagInfo = new Node(new Node.Descriptor("TypeTag:"), new Node.Value(new Byte(typeTag), TypeTag.asString(typeTag)));
                    eventInfo.addChild(typeTagInfo);
                    long refId = Analyzer_64_100.getVal(packet, index, referenceTypeIDSize);
                    ReferenceType refType = ReferenceType.getType(refId);
                    Node refIdInfo = new Node(new Node.Descriptor("ReferenceID:", refType), new Node.Value(new Long(refId)));
                    eventInfo.addChild(refIdInfo);
                    long fieldId = Analyzer_64_100.getVal(packet, index += referenceTypeIDSize, fieldIDSize);
                    FieldType fieldType = FieldType.getType(refId, fieldId);
                    Node fieldIdInfo = new Node(new Node.Descriptor("AccessedFieldID:", fieldType), new Node.Value(new Long(fieldId)));
                    eventInfo.addChild(fieldIdInfo);
                    PacketAnalyzer.Value value = Analyzer_64_100.getValue(packet, index += fieldIDSize);
                    index += value.getOffset();
                    Long objectId = (Long)value.getValue();
                    ObjectType objectType = ObjectType.getType(objectId);
                    Node singleValueInfo = new Node(new Node.Descriptor("AccessedObjectID:", objectType), new Node.Value(value));
                    eventInfo.addChild(singleValueInfo);
                    continue block10;
                }
                case 21: {
                    long threadId = Analyzer_64_100.getVal(packet, index, objectIDSize);
                    ObjectType thread = ObjectType.getType(threadId);
                    Node threadInfo = new Node(new Node.Descriptor("AccessorThreadID:", thread), new Node.Value(new Long(threadId)));
                    eventInfo.addChild(threadInfo);
                    PacketAnalyzer.Location location = Analyzer_64_100.getLocation(packet, index += objectIDSize);
                    location.setDecription("AccessLocation:");
                    index += locationSize;
                    Node locationInfo = location.toNode();
                    eventInfo.addChild(locationInfo);
                    byte typeTag = packet.getData()[index++];
                    Node typeTagInfo = new Node(new Node.Descriptor("TypeTag:"), new Node.Value(new Byte(typeTag), TypeTag.asString(typeTag)));
                    eventInfo.addChild(typeTagInfo);
                    long refId = Analyzer_64_100.getVal(packet, index, referenceTypeIDSize);
                    ReferenceType refType = ReferenceType.getType(refId);
                    Node refIdInfo = new Node(new Node.Descriptor("ReferenceID:", refType), new Node.Value(new Long(refId)));
                    eventInfo.addChild(refIdInfo);
                    long fieldId = Analyzer_64_100.getVal(packet, index += referenceTypeIDSize, fieldIDSize);
                    FieldType fieldType = FieldType.getType(refId, fieldId);
                    Node fieldIdInfo = new Node(new Node.Descriptor("AccessedFieldID:", fieldType), new Node.Value(new Long(fieldId)));
                    eventInfo.addChild(fieldIdInfo);
                    PacketAnalyzer.Value value = Analyzer_64_100.getValue(packet, index += fieldIDSize);
                    index += value.getOffset();
                    Long objectId = (Long)value.getValue();
                    ObjectType objectType = ObjectType.getType(objectId);
                    Node singleValueInfo = new Node(new Node.Descriptor("AccessedObjectID:", objectType), new Node.Value(value));
                    eventInfo.addChild(singleValueInfo);
                    value = Analyzer_64_100.getValue(packet, index);
                    index += value.getOffset();
                    objectId = (Long)value.getValue();
                    objectType = ObjectType.getType(objectId);
                    singleValueInfo = new Node(new Node.Descriptor("ValueSet:", objectType), new Node.Value(value));
                    eventInfo.addChild(singleValueInfo);
                    continue block10;
                }
                case 99: {
                    continue block10;
                }
                default: {
                    Node errInfo = new Node(new Node.Descriptor("ERR: Unknown eventKind " + eventKind), null);
                    eventInfo.addChild(errInfo);
                }
            }
        }
        return root;
    }
}

