/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.response;

import com.karelherink.jdwpanalyzer.entity.ObjectType;
import com.karelherink.jdwpanalyzer.model.AnalyzerManager;
import com.karelherink.jdwpanalyzer.model.Node;
import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.PacketAnalyzer;
import com.karelherink.jdwpanalyzer.model.Request;
import com.karelherink.jdwpanalyzer.model.constants.SuspendStatus;
import com.karelherink.jdwpanalyzer.model.constants.ThreadStatus;
import java.util.ArrayList;

public class Analyzer_11_4
extends PacketAnalyzer {
    @Override
    public void updateInternalDataModel(Packet packet) {
        Request request = Request.getRequest(packet.getId());
        PacketAnalyzer requestPacketAnalyzer = AnalyzerManager.createPacketAnalyzer(request);
        Long objTypeId = (Long)requestPacketAnalyzer.getPacketInfo(request).getValue().getRealValue();
        ObjectType objectType = ObjectType.getType(objTypeId);
        ArrayList nodes = this.getPacketInfo(packet).getChildren();
        Integer threadStatus = (Integer)((Node)nodes.get(0)).getValue().getRealValue();
        objectType.setThreadStatus(threadStatus);
        Integer suspendStatus = (Integer)((Node)nodes.get(0)).getValue().getRealValue();
        objectType.setSuspendStatus(suspendStatus);
    }

    @Override
    public Node getPacketInfo(Packet packet) {
        Node root = new Node(null, null);
        int index = 0;
        int threadStatus = (int)Analyzer_11_4.getVal(packet, index, 4);
        Node threadStatusInfo = new Node(new Node.Descriptor("ThreadStatus:"), new Node.Value(new Integer(threadStatus), ThreadStatus.asString(threadStatus)));
        root.addChild(threadStatusInfo);
        int suspendStatus = (int)Analyzer_11_4.getVal(packet, index += 4, 4);
        index += 4;
        Node suspendStatusInfo = new Node(new Node.Descriptor("SuspendStatus:"), new Node.Value(new Integer(suspendStatus), SuspendStatus.asString(suspendStatus)));
        root.addChild(suspendStatusInfo);
        return root;
    }
}

