/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.response;

import com.karelherink.jdwpanalyzer.entity.ObjectType;
import com.karelherink.jdwpanalyzer.model.AnalyzerManager;
import com.karelherink.jdwpanalyzer.model.Node;
import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.PacketAnalyzer;
import com.karelherink.jdwpanalyzer.model.Request;
import java.util.ArrayList;

public class Analyzer_12_3
extends PacketAnalyzer {
    @Override
    public void updateInternalDataModel(Packet packet) {
        Request request = Request.getRequest(packet.getId());
        PacketAnalyzer requestPacketAnalyzer = AnalyzerManager.createPacketAnalyzer(request);
        Long objTypeId = (Long)requestPacketAnalyzer.getPacketInfo(request).getValue().getRealValue();
        ObjectType objectType = ObjectType.getType(objTypeId);
        ArrayList<Long> childThreads = new ArrayList<Long>();
        ArrayList childThreadGroups = new ArrayList();
        ArrayList nodes = this.getPacketInfo(packet).getChildren();
        ArrayList threadNodes = ((Node)nodes.get(0)).getChildren();
        for (Node threadNode : threadNodes) {
            Long threadId = (Long)threadNode.getValue().getRealValue();
            childThreads.add(threadId);
        }
        objectType.setChildThreadIds(childThreads.toArray(new Long[childThreads.size()]));
        ArrayList threadGroupNodes = ((Node)nodes.get(1)).getChildren();
        for (Node threadGroupNode : threadGroupNodes) {
            Long threadGroupId = (Long)threadGroupNode.getValue().getRealValue();
            childThreads.add(threadGroupId);
        }
        objectType.setChildThreadGroupIds(childThreadGroups.toArray(new Long[childThreadGroups.size()]));
    }

    @Override
    public Node getPacketInfo(Packet packet) {
        int index = 0;
        Node root = new Node(null, null);
        int numThreads = (int)Analyzer_12_3.getVal(packet, index, 4);
        index += 4;
        Node threadsInfo = new Node(new Node.Descriptor("NumThreads:"), new Node.Value(new Integer(numThreads)));
        for (int i = 0; i < numThreads; ++i) {
            long threadId = Analyzer_12_3.getVal(packet, index, objectIDSize);
            index += objectIDSize;
            ObjectType objectType = ObjectType.getType(threadId);
            Node threadInfo = new Node(new Node.Descriptor("ThreadId:", objectType), new Node.Value(new Long(threadId)));
            threadsInfo.addChild(threadInfo);
        }
        root.addChild(threadsInfo);
        int numThreadGroups = (int)Analyzer_12_3.getVal(packet, index, 4);
        index += 4;
        Node threadGroupsInfo = new Node(new Node.Descriptor("NumThreadGroups:"), new Node.Value(new Integer(numThreadGroups)));
        for (int i = 0; i < numThreadGroups; ++i) {
            long threadGroupId = Analyzer_12_3.getVal(packet, index, objectIDSize);
            index += objectIDSize;
            ObjectType objectType = ObjectType.getType(threadGroupId);
            Node threadGroupInfo = new Node(new Node.Descriptor("ThreadGroupId:", objectType), new Node.Value(new Long(threadGroupId)));
            threadGroupsInfo.addChild(threadGroupInfo);
        }
        root.addChild(threadGroupsInfo);
        return root;
    }
}

