/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.response;

import com.karelherink.jdwpanalyzer.entity.ObjectType;
import com.karelherink.jdwpanalyzer.entity.ReferenceType;
import com.karelherink.jdwpanalyzer.model.AnalyzerManager;
import com.karelherink.jdwpanalyzer.model.Node;
import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.PacketAnalyzer;
import com.karelherink.jdwpanalyzer.model.Request;
import com.karelherink.jdwpanalyzer.model.constants.TypeTag;
import java.util.ArrayList;

public class Analyzer_17_1
extends PacketAnalyzer {
    @Override
    public void updateInternalDataModel(Packet packet) {
        Request request = Request.getRequest(packet.getId());
        PacketAnalyzer requestPacketAnalyzer = AnalyzerManager.createPacketAnalyzer(request);
        Long objTypeId = (Long)requestPacketAnalyzer.getPacketInfo(request).getValue().getRealValue();
        ObjectType objectType = ObjectType.getType(objTypeId);
        ArrayList nodes = this.getPacketInfo(packet).getChildren();
        Node refTypeIdInfo = (Node)nodes.get(1);
        Long refTypeId = (Long)refTypeIdInfo.getValue().getRealValue();
        objectType.setReferenceTypeId(refTypeId);
    }

    @Override
    public Node getPacketInfo(Packet packet) {
        Node root = new Node(null, null);
        int index = 0;
        byte typeTag = packet.getData()[index++];
        Node tagInfo = new Node(new Node.Descriptor("TypeTag:"), new Node.Value(new Integer(typeTag), TypeTag.asString(typeTag)));
        root.addChild(tagInfo);
        long referenceTypeId = (int)Analyzer_17_1.getVal(packet, index, referenceTypeIDSize);
        index += referenceTypeIDSize;
        ReferenceType refType = ReferenceType.getType(referenceTypeId);
        Node referenceTypeIdInfo = new Node(new Node.Descriptor("RefTypeID:", refType), new Node.Value(new Long(referenceTypeId)));
        root.addChild(referenceTypeIdInfo);
        return root;
    }
}

