/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.response;

import com.karelherink.jdwpanalyzer.entity.ReferenceType;
import com.karelherink.jdwpanalyzer.model.AnalyzerManager;
import com.karelherink.jdwpanalyzer.model.Node;
import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.PacketAnalyzer;
import com.karelherink.jdwpanalyzer.model.Request;
import com.karelherink.jdwpanalyzer.model.constants.ClassStatus;
import com.karelherink.jdwpanalyzer.model.constants.TypeTag;
import java.util.ArrayList;

public class Analyzer_1_2
extends PacketAnalyzer {
    @Override
    public void updateInternalDataModel(Packet packet) {
        Request request = Request.getRequest(packet.getId());
        PacketAnalyzer requestPacketAnalyzer = AnalyzerManager.createPacketAnalyzer(request);
        String signature = (String)requestPacketAnalyzer.getPacketInfo(request).getValue().getRealValue();
        ArrayList classesInfo = this.getPacketInfo(packet).getChildren();
        for (int i = 0; i < classesInfo.size(); ++i) {
            Node singleClassInfo = (Node)classesInfo.get(i);
            Long refTypeId = (Long)singleClassInfo.getValue().getRealValue();
            ReferenceType refType = ReferenceType.getType(refTypeId);
            refType.setSignature(signature);
            Node typeTag = (Node)singleClassInfo.getChildren().get(0);
            refType.setTypeTag((Byte)typeTag.getValue().getRealValue());
            Node typeStatus = (Node)singleClassInfo.getChildren().get(1);
            refType.setStatus((Integer)typeStatus.getValue().getRealValue());
        }
    }

    @Override
    public Node getPacketInfo(Packet packet) {
        int index = 0;
        int numClasses = (int)Analyzer_1_2.getVal(packet, index, 4);
        index += 4;
        Node classesInfo = new Node(new Node.Descriptor("NumClasses:"), new Node.Value(new Integer(numClasses)));
        for (int i = 0; i < numClasses; ++i) {
            byte typeTag = (byte)(packet.getData()[index++] & 0xFF);
            long refTypeId = Analyzer_1_2.getVal(packet, index, referenceTypeIDSize);
            int classStatus = (int)Analyzer_1_2.getVal(packet, index += referenceTypeIDSize, 4);
            index += 4;
            ReferenceType referenceType = ReferenceType.getType(refTypeId);
            Node singleClassInfo = new Node(new Node.Descriptor("RefTypeID:", referenceType), new Node.Value(new Long(refTypeId)));
            classesInfo.addChild(singleClassInfo);
            Node typeTagInfo = new Node(new Node.Descriptor("TypeTag:"), new Node.Value(new Byte(typeTag), TypeTag.asString(typeTag)));
            singleClassInfo.addChild(typeTagInfo);
            Node typeStatusInfo = new Node(new Node.Descriptor("TypeStatus:"), new Node.Value(new Integer(classStatus), ClassStatus.asString(classStatus)));
            singleClassInfo.addChild(typeStatusInfo);
        }
        return classesInfo;
    }
}

