/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.response;

import com.karelherink.jdwpanalyzer.entity.ReferenceType;
import com.karelherink.jdwpanalyzer.model.AnalyzerManager;
import com.karelherink.jdwpanalyzer.model.Node;
import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.PacketAnalyzer;
import com.karelherink.jdwpanalyzer.model.Request;
import java.util.ArrayList;

public class Analyzer_2_10
extends PacketAnalyzer {
    @Override
    public void updateInternalDataModel(Packet packet) {
        Request request = Request.getRequest(packet.getId());
        PacketAnalyzer requestPacketAnalyzer = AnalyzerManager.createPacketAnalyzer(request);
        Long referenceTypeId = (Long)requestPacketAnalyzer.getPacketInfo(request).getValue().getRealValue();
        ReferenceType referenceType = ReferenceType.getType(referenceTypeId);
        ArrayList<Long> interfacesRefTypeIds = new ArrayList<Long>();
        ArrayList interfacesInfo = this.getPacketInfo(packet).getChildren();
        for (int i = 0; i < interfacesInfo.size(); ++i) {
            Node singleInterfaceInfo = (Node)interfacesInfo.get(i);
            Long interfaceRefTypeId = (Long)singleInterfaceInfo.getValue().getRealValue();
            interfacesRefTypeIds.add(interfaceRefTypeId);
            ReferenceType interfaceRefType = ReferenceType.getType(interfaceRefTypeId);
            interfaceRefType.setTypeTag(new Byte(2));
        }
        referenceType.setInterfaceTypeIds(interfacesRefTypeIds.toArray(new Long[interfacesRefTypeIds.size()]));
    }

    @Override
    public Node getPacketInfo(Packet packet) {
        int index = 0;
        int numClasses = (int)Analyzer_2_10.getVal(packet, index, 4);
        index += 4;
        Node interfacesInfo = new Node(new Node.Descriptor("NumInterfaces:"), new Node.Value(new Integer(numClasses)));
        for (int i = 0; i < numClasses; ++i) {
            long interfaceRefTypeId = Analyzer_2_10.getVal(packet, index, referenceTypeIDSize);
            index += referenceTypeIDSize;
            ReferenceType referenceType = ReferenceType.getType(interfaceRefTypeId);
            Node singleInterfaceInfo = new Node(new Node.Descriptor("RefTypeID:", referenceType), new Node.Value(new Long(interfaceRefTypeId)));
            interfacesInfo.addChild(singleInterfaceInfo);
        }
        return interfacesInfo;
    }
}

